from django.http import HttpResponse
from django.template import Context,Template,loader

def chyba(text):

    t=loader.get_template("chyba.html")
    c=Context({'chyba':text})
    return HttpResponse(t.render(c))

class Dvojica(object):

    def __init__(self,n,hodnota):
        self.n = n
        self.hodnota = hodnota

# * Toto je dekorator.
# * Ako parameter ocakava funkciu f(request,cislo)
# * Jeho navratovou hodnotou je funkcia, ktora skontroluje
#   cislo, ak je chybne vrati chybu, a ak je v poriadku,
#   zavola f.

def skontroluj_cislo(f):

    # * __dekorovane_f je funkcia s dvomi premennymi
    #   ocakava, ze v nadradenom prostredi je nastavena premenna f
 
    def __dekorovane_f(request,cislo):
        
        # cislo je retazec
        # musime ho previest na int
        # treba kontrolovat vstup uzivatela! 
        try:
            cislo_int=int(cislo)
        except ValueError:
            return chyba("%s sa nepodarilo previest na cislo" % cislo)
        if cislo_int<0:
            return chyba("cislo %d je zaporne" % cislo_int)
        return f(request,cislo_int)

    return __dekorovane_f

# Teraz pouzijeme specialnu syntax, ktora zabezpeci
# obalenie funkcie dekoratorom
@skontroluj_cislo
def nasobky(request,cislo_int):

    zoz_nasobkov=[]
    for i in range(11):
        zoz_nasobkov.append(Dvojica(i,i*cislo_int))
    c=Context({'cislo':cislo_int,'vysledky':zoz_nasobkov})
    t=loader.get_template("nasobky.html")
    return HttpResponse(t.render(c))


# Detto pre delitele
@skontroluj_cislo
def delitele(request,cislo_int):
    
    zoz_delitelov=[]
    pocitadlo=0
    for i in range(1,cislo_int+1):
        if (cislo_int % i)==0:
            pocitadlo+=1
            zoz_delitelov.append(Dvojica(pocitadlo,i))
    c=Context({'cislo':cislo_int,'vysledky':zoz_delitelov})
    t=loader.get_template("delitele.html")
    return HttpResponse(t.render(c))


