(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1737734,      52016]*)
(*NotebookOutlinePosition[   1738740,      52047]*)
(*  CellTagsIndexPosition[   1738696,      52043]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "An Copula Experiment in Geodesy\n",
  StyleBox["-----",
    FontSize->14],
  " ",
  StyleBox["MOPI permanent observations ----- positive dependence ------ \
chopped (Xi,",
    FontSize->14],
  StyleBox["Y",
    FontSize->14],
  StyleBox["i) with extremal Yi's",
    FontSize->14]
}], "Title",
  FontSize->24],

Cell[CellGroupData[{

Cell["Initial settings", "Section"],

Cell[BoxData[
    \( (*\ \(\(--\(--\(-\ 
                read\)\)\)\ in\ \(\(packages\ --\)--\)\)\(-\)\ *) \)], "Input"],

Cell[BoxData[{
    \(<< Statistics`ContinuousDistributions`\), "\[IndentingNewLine]", 
    \(<< Statistics`MultiDescriptiveStatistics`\), "\[IndentingNewLine]", 
    \(<< Statistics`MultinormalDistribution`\)}], "Input"],

Cell[BoxData[{
    \(<< Graphics`Graphics`\), "\[IndentingNewLine]", 
    \(<< Graphics`Graphics3D`\)}], "Input"],

Cell[BoxData[{
    \(<< Statistics`NonlinearFit`\), "\[IndentingNewLine]", 
    \(<< Statistics`DataManipulation`\)}], "Input"],

Cell[BoxData[
    \(\(\(<< Statistics`StatisticsPlots`\)\(\ \)\( (*\ 
      Mathematica\ 5\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(SetDirectory["\<d:\\math\\Analyza CR\\copula\>"];\)\( (*\ 
      at\ home\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(SetDirectory["d:\\documents\\phd\\copula\\program"];\)\( (*\ 
      at\ KMaDG\ *) \)\)\)], "DisplayFormula"],

Cell[BoxData[
    \( (*\ \(--\(--\(-\ \(\(settings\ --\)--\)\)\)\)\(-\)\ *) \)], "Input"],

Cell[BoxData[{
    \(\(SetOptions[ListPlot, PlotJoined \[Rule] True, PlotRange \[Rule] All, 
        DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(SetOptions[{Histogram, Plot, QuantilePlot, ContourPlot, Plot3D}, 
        PlotRange \[Rule] All, 
        DisplayFunction \[Rule] Identity];\)\)}], "Input"],

Cell[BoxData[
    \(\(\(Off[General::spell1];\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \( (*\ \(\(--\(--\(-\ 
                user\)\)\)\ \(\(functions\ --\)--\)\)\(-\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(fShow[plot__, \ options___] := 
        Show[plot, DisplayFunction \[RuleDelayed] $DisplayFunction, \ 
          options];\)\)], "Input"],

Cell[BoxData[
    \(\(fDShow[plot__] := 
        Show[plot, DisplayFunction \[RuleDelayed] Identity];\)\)], "Input"],

Cell[BoxData[
    \( (*\ \(\(--\(--\(-\ 
                read\)\)\)\ in\ the\ \(\(data\ --\)--\)\)\(-\)\ *) \)], \
"Input"],

Cell[BoxData[
    \(\(XY = 
        ReadList["\<data\\mopi_nt.dat\>", Table[Number, {2}]];\)\)], "Input"],

Cell[BoxData[
    \(\({X, Y} = Transpose[XY];\)\)], "Input"],

Cell[BoxData[{
    StyleBox[\(Y = \(-Y\);\),
      FontColor->RGBColor[0, 1, 
      0]], "\[IndentingNewLine]", \(Y = 
        Extract[Y, 
          tmpOrdY = 
            Partition[Drop[Drop[Ordering[Y], 1], 0], 1]];\), "\n", \(X = 
        Extract[X, tmpOrdY];\), "\[IndentingNewLine]", \(XY = 
        Transpose[{X, Y}];\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(n = Length[XY]\)], "Input"],

Cell[BoxData[
    \(727\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["First look", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphicsArray[{ListPlot[X], ListPlot[Y]}] // fShow;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224977 0.00131182 0.286882 0.031176 [
[.15368 .27438 -9 -9 ]
[.15368 .27438 9 0 ]
[.28486 .27438 -9 -9 ]
[.28486 .27438 9 0 ]
[.41604 .27438 -9 -9 ]
[.41604 .27438 9 0 ]
[.54723 .27438 -9 -9 ]
[.54723 .27438 9 0 ]
[.67841 .27438 -9 -9 ]
[.67841 .27438 9 0 ]
[.80959 .27438 -9 -9 ]
[.80959 .27438 9 0 ]
[.94077 .27438 -9 -9 ]
[.94077 .27438 9 0 ]
[.01 .05306 -24 -4.5 ]
[.01 .05306 0 4.5 ]
[.01 .131 -12 -4.5 ]
[.01 .131 0 4.5 ]
[.01 .20894 -24 -4.5 ]
[.01 .20894 0 4.5 ]
[.01 .36482 -18 -4.5 ]
[.01 .36482 0 4.5 ]
[.01 .44276 -6 -4.5 ]
[.01 .44276 0 4.5 ]
[.01 .5207 -18 -4.5 ]
[.01 .5207 0 4.5 ]
[.01 .59864 -12 -4.5 ]
[.01 .59864 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15368 .28688 m
.15368 .29313 L
s
[(100)] .15368 .27438 0 1 Mshowa
.28486 .28688 m
.28486 .29313 L
s
[(200)] .28486 .27438 0 1 Mshowa
.41604 .28688 m
.41604 .29313 L
s
[(300)] .41604 .27438 0 1 Mshowa
.54723 .28688 m
.54723 .29313 L
s
[(400)] .54723 .27438 0 1 Mshowa
.67841 .28688 m
.67841 .29313 L
s
[(500)] .67841 .27438 0 1 Mshowa
.80959 .28688 m
.80959 .29313 L
s
[(600)] .80959 .27438 0 1 Mshowa
.94077 .28688 m
.94077 .29313 L
s
[(700)] .94077 .27438 0 1 Mshowa
.125 Mabswid
.04873 .28688 m
.04873 .29063 L
s
.07497 .28688 m
.07497 .29063 L
s
.10121 .28688 m
.10121 .29063 L
s
.12744 .28688 m
.12744 .29063 L
s
.17992 .28688 m
.17992 .29063 L
s
.20615 .28688 m
.20615 .29063 L
s
.23239 .28688 m
.23239 .29063 L
s
.25863 .28688 m
.25863 .29063 L
s
.3111 .28688 m
.3111 .29063 L
s
.33733 .28688 m
.33733 .29063 L
s
.36357 .28688 m
.36357 .29063 L
s
.38981 .28688 m
.38981 .29063 L
s
.44228 .28688 m
.44228 .29063 L
s
.46852 .28688 m
.46852 .29063 L
s
.49475 .28688 m
.49475 .29063 L
s
.52099 .28688 m
.52099 .29063 L
s
.57346 .28688 m
.57346 .29063 L
s
.5997 .28688 m
.5997 .29063 L
s
.62593 .28688 m
.62593 .29063 L
s
.65217 .28688 m
.65217 .29063 L
s
.70464 .28688 m
.70464 .29063 L
s
.73088 .28688 m
.73088 .29063 L
s
.75712 .28688 m
.75712 .29063 L
s
.78335 .28688 m
.78335 .29063 L
s
.83583 .28688 m
.83583 .29063 L
s
.86206 .28688 m
.86206 .29063 L
s
.8883 .28688 m
.8883 .29063 L
s
.91453 .28688 m
.91453 .29063 L
s
.96701 .28688 m
.96701 .29063 L
s
.99324 .28688 m
.99324 .29063 L
s
.25 Mabswid
0 .28688 m
1 .28688 L
s
.0225 .05306 m
.02875 .05306 L
s
[(-7.5)] .01 .05306 1 0 Mshowa
.0225 .131 m
.02875 .131 L
s
[(-5)] .01 .131 1 0 Mshowa
.0225 .20894 m
.02875 .20894 L
s
[(-2.5)] .01 .20894 1 0 Mshowa
.0225 .36482 m
.02875 .36482 L
s
[(2.5)] .01 .36482 1 0 Mshowa
.0225 .44276 m
.02875 .44276 L
s
[(5)] .01 .44276 1 0 Mshowa
.0225 .5207 m
.02875 .5207 L
s
[(7.5)] .01 .5207 1 0 Mshowa
.0225 .59864 m
.02875 .59864 L
s
[(10)] .01 .59864 1 0 Mshowa
.125 Mabswid
.0225 .06865 m
.02625 .06865 L
s
.0225 .08424 m
.02625 .08424 L
s
.0225 .09983 m
.02625 .09983 L
s
.0225 .11541 m
.02625 .11541 L
s
.0225 .14659 m
.02625 .14659 L
s
.0225 .16218 m
.02625 .16218 L
s
.0225 .17777 m
.02625 .17777 L
s
.0225 .19335 m
.02625 .19335 L
s
.0225 .22453 m
.02625 .22453 L
s
.0225 .24012 m
.02625 .24012 L
s
.0225 .25571 m
.02625 .25571 L
s
.0225 .27129 m
.02625 .27129 L
s
.0225 .30247 m
.02625 .30247 L
s
.0225 .31806 m
.02625 .31806 L
s
.0225 .33365 m
.02625 .33365 L
s
.0225 .34923 m
.02625 .34923 L
s
.0225 .38041 m
.02625 .38041 L
s
.0225 .396 m
.02625 .396 L
s
.0225 .41159 m
.02625 .41159 L
s
.0225 .42717 m
.02625 .42717 L
s
.0225 .45835 m
.02625 .45835 L
s
.0225 .47394 m
.02625 .47394 L
s
.0225 .48953 m
.02625 .48953 L
s
.0225 .50511 m
.02625 .50511 L
s
.0225 .53629 m
.02625 .53629 L
s
.0225 .55188 m
.02625 .55188 L
s
.0225 .56747 m
.02625 .56747 L
s
.0225 .58305 m
.02625 .58305 L
s
.0225 .03747 m
.02625 .03747 L
s
.0225 .02189 m
.02625 .02189 L
s
.0225 .0063 m
.02625 .0063 L
s
.0225 .61423 m
.02625 .61423 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
.5 Mabswid
.02381 .06958 m
.02512 .09266 L
.02643 .11136 L
.02774 .0197 L
.02906 .13942 L
.03037 .09764 L
.03168 .07644 L
.03299 .28595 L
.0343 .21393 L
.03562 .37355 L
.03693 .13256 L
.03824 .09764 L
.03955 .16997 L
.04086 .14347 L
.04217 .30434 L
.04349 .14285 L
.0448 .12103 L
.04611 .14378 L
.04742 .24479 L
.04873 .13724 L
.05005 .29811 L
.05136 .28688 L
.05267 .22983 L
.05398 .1547 L
.05529 .1653 L
.05661 .21985 L
.05792 .23513 L
.05923 .16311 L
.06054 .22422 L
.06185 .11947 L
.06316 .1335 L
.06448 .26288 L
.06579 .19522 L
.0671 .21299 L
.06841 .12601 L
.06972 .20177 L
.07104 .18088 L
.07235 .11978 L
.07366 .30278 L
.07497 .18307 L
.07628 .1734 L
.07759 .1865 L
.07891 .1653 L
.08022 .31743 L
.08153 .37168 L
.08284 .17184 L
.08415 .30964 L
.08547 .10856 L
.08678 .16997 L
.08809 .18961 L
Mistroke
.0894 .14347 L
.09071 .27067 L
.09202 .24822 L
.09334 .16966 L
.09465 .1522 L
.09596 .41096 L
.09727 .28439 L
.09858 .26475 L
.0999 .23014 L
.10121 .30029 L
.10252 .1229 L
.10383 .2582 L
.10514 .28345 L
.10645 .26724 L
.10777 .16904 L
.10908 .19678 L
.11039 .24885 L
.1117 .25508 L
.11301 .1628 L
.11433 .04464 L
.11564 .17278 L
.11695 .31245 L
.11826 .27691 L
.11957 .22889 L
.12088 .24822 L
.1222 .2741 L
.12351 .30621 L
.12482 .13131 L
.12613 .17808 L
.12744 .25882 L
.12876 .14223 L
.13007 .34799 L
.13138 .34238 L
.13269 .22204 L
.134 .1893 L
.13531 .29093 L
.13663 .25789 L
.13794 .18182 L
.13925 .343 L
.14056 .29374 L
.14187 .17932 L
.14319 .24511 L
.1445 .22702 L
.14581 .26163 L
.14712 .20582 L
.14843 .28563 L
.14974 .20832 L
.15106 .13848 L
.15237 .22235 L
.15368 .35173 L
Mistroke
.15499 .16935 L
.1563 .20801 L
.15762 .15501 L
.15893 .30278 L
.16024 .25072 L
.16155 .17309 L
.16286 .31806 L
.16417 .18868 L
.16549 .26038 L
.1668 .14846 L
.16811 .21861 L
.16942 .26755 L
.17073 .16872 L
.17205 .20271 L
.17336 .16872 L
.17467 .27722 L
.17598 .2688 L
.17729 .19772 L
.1786 .24822 L
.17992 .30247 L
.18123 .22048 L
.18254 .25228 L
.18385 .27846 L
.18516 .29093 L
.18648 .08361 L
.18779 .18556 L
.1891 .21736 L
.19041 .34736 L
.19172 .14316 L
.19303 .28034 L
.19435 .23108 L
.19566 .30153 L
.19697 .24386 L
.19828 .25539 L
.19959 .26818 L
.20091 .17371 L
.20222 .29592 L
.20353 .31182 L
.20484 .23575 L
.20615 .20084 L
.20746 .31276 L
.20878 .40348 L
.21009 .20551 L
.2114 .2264 L
.21271 .25789 L
.21402 .23949 L
.21534 .26194 L
.21665 .3776 L
.21796 .19585 L
.21927 .09515 L
Mistroke
.22058 .17122 L
.22189 .22266 L
.22321 .20115 L
.22452 .16374 L
.22583 .28813 L
.22714 .21175 L
.22845 .32616 L
.22977 .29093 L
.23108 .12944 L
.23239 .21674 L
.2337 .13599 L
.23501 .25477 L
.23632 .22359 L
.23764 .35266 L
.23895 .07395 L
.24026 .25259 L
.24157 .28345 L
.24288 .25415 L
.2442 .24012 L
.24551 .30496 L
.24682 .17527 L
.24813 .22484 L
.24944 .1865 L
.25075 .32086 L
.25207 .30683 L
.25338 .1335 L
.25469 .22734 L
.256 .17402 L
.25731 .17465 L
.25863 .28813 L
.25994 .20364 L
.26125 .20832 L
.26256 .35672 L
.26387 .20021 L
.26518 .23762 L
.2665 .32554 L
.26781 .28501 L
.26912 .24136 L
.27043 .18244 L
.27174 .23669 L
.27306 .23731 L
.27437 .21923 L
.27568 .26444 L
.27699 .20021 L
.2783 .36888 L
.27961 .28096 L
.28093 .3112 L
.28224 .24324 L
.28355 .18213 L
.28486 .32086 L
Mistroke
.28617 .31588 L
.28749 .11915 L
.2888 .18431 L
.29011 .24074 L
.29142 .22547 L
.29273 .25165 L
.29404 .28844 L
.29536 .19928 L
.29667 .26163 L
.29798 .30247 L
.29929 .24854 L
.3006 .22702 L
.30192 .21829 L
.30323 .31026 L
.30454 .16467 L
.30585 .23856 L
.30716 .26755 L
.30847 .23419 L
.30979 .23482 L
.3111 .15875 L
.31241 .25134 L
.31372 .26412 L
.31503 .24729 L
.31635 .33022 L
.31766 .22702 L
.31897 .3299 L
.32028 .32086 L
.32159 .23918 L
.3229 .28127 L
.32422 .24105 L
.32553 .25914 L
.32684 .21331 L
.32815 .30341 L
.32946 .22858 L
.33078 .17777 L
.33209 .2953 L
.3334 .20801 L
.33471 .20582 L
.33602 .25446 L
.33733 .30278 L
.33865 .16218 L
.33996 .13131 L
.34127 .25228 L
.34258 .29966 L
.34389 .27753 L
.34521 .28283 L
.34652 .27192 L
.34783 .19585 L
.34914 .22952 L
.35045 .28906 L
Mistroke
.35176 .24043 L
.35308 .19429 L
.35439 .30683 L
.3557 .21144 L
.35701 .23607 L
.35832 .26132 L
.35964 .21299 L
.36095 .26974 L
.36226 .18151 L
.36357 .24854 L
.36488 .24542 L
.36619 .21985 L
.36751 .24511 L
.36882 .31089 L
.37013 .19211 L
.37144 .22172 L
.37275 .38384 L
.37407 .15095 L
.37538 .30465 L
.37669 .2794 L
.378 .20551 L
.37931 .30309 L
.38062 .28563 L
.38194 .20676 L
.38325 .32772 L
.38456 .07769 L
.38587 .29125 L
.38718 .31743 L
.3885 .24791 L
.38981 .33988 L
.39112 .22796 L
.39243 .18961 L
.39374 .32866 L
.39505 .30933 L
.39637 .26849 L
.39768 .22765 L
.39899 .30871 L
.4003 .14035 L
.40161 .28252 L
.40293 .18026 L
.40424 .27566 L
.40555 .23825 L
.40686 .06647 L
.40817 .25882 L
.40948 .34082 L
.4108 .27535 L
.41211 .17247 L
.41342 .19522 L
.41473 .22172 L
.41604 .39132 L
Mistroke
.41736 .21081 L
.41867 .23669 L
.41998 .22921 L
.42129 .25 L
.4226 .35235 L
.42391 .35266 L
.42523 .22204 L
.42654 .11011 L
.42785 .18151 L
.42916 .25196 L
.43047 .30839 L
.43179 .31494 L
.4331 .27379 L
.43441 .25153 L
.43572 .2211 L
.43703 .26444 L
.43834 .20052 L
.43966 .29 L
.44097 .31775 L
.44228 .27036 L
.44359 .1759 L
.4449 .26288 L
.44622 .27566 L
.44753 .25664 L
.44884 .28875 L
.45015 .28563 L
.45146 .27846 L
.45277 .14503 L
.45409 .25477 L
.4554 .26662 L
.45671 .39787 L
.45802 .18899 L
.45933 .21518 L
.46065 .27472 L
.46196 .30434 L
.46327 .28221 L
.46458 .24698 L
.46589 .20333 L
.4672 .25433 L
.46852 .22765 L
.46983 .18992 L
.47114 .25483 L
.47245 .25486 L
.47376 .2549 L
.47508 .24947 L
.47639 .21705 L
.4777 .24573 L
.47901 .30839 L
.48032 .11136 L
.48163 .29935 L
Mistroke
.48295 .27784 L
.48426 .14659 L
.48557 .24947 L
.48688 .26662 L
.48819 .22266 L
.48951 .35609 L
.49082 .24604 L
.49213 .29592 L
.49344 .33115 L
.49475 .27722 L
.49606 .20239 L
.49738 .24791 L
.49869 .26724 L
.5 .22453 L
.50131 .26038 L
.50262 .25888 L
.50394 .23794 L
.50525 .27223 L
.50656 .42406 L
.50787 .2476 L
.50918 .32055 L
.51049 .32585 L
.51181 .37262 L
.51312 .20801 L
.51443 .25477 L
.51574 .26069 L
.51705 .21424 L
.51837 .25695 L
.51968 .21362 L
.52099 .22921 L
.5223 .26568 L
.52361 .29468 L
.52492 .21299 L
.52624 .22547 L
.52755 .24729 L
.52886 .23731 L
.53017 .30278 L
.53148 .33115 L
.5328 .2635 L
.53411 .21518 L
.53542 .22172 L
.53673 .30029 L
.53804 .26537 L
.53935 .24199 L
.54067 .25633 L
.54198 .17901 L
.54329 .24168 L
.5446 .18494 L
.54591 .32211 L
.54723 .2264 L
Mistroke
.54854 .15064 L
.54985 .23794 L
.55116 .26288 L
.55247 .33115 L
.55378 .22858 L
.5551 .20146 L
.55641 .32118 L
.55772 .20863 L
.55903 .24542 L
.56034 .31151 L
.56166 .36015 L
.56297 .33115 L
.56428 .2688 L
.56559 .23108 L
.5669 .33209 L
.56821 .28782 L
.56953 .26786 L
.57084 .30029 L
.57215 .21362 L
.57346 .36326 L
.57477 .2688 L
.57609 .23077 L
.5774 .16904 L
.57871 .36856 L
.58002 .20208 L
.58133 .2688 L
.58264 .3536 L
.58396 .33988 L
.58527 .25664 L
.58658 .25446 L
.58789 .29873 L
.5892 .35828 L
.59052 .24324 L
.59183 .26942 L
.59314 .31369 L
.59445 .30247 L
.59576 .26101 L
.59707 .18369 L
.59839 .20707 L
.5997 .2529 L
.60101 .29842 L
.60232 .2582 L
.60363 .23949 L
.60495 .27441 L
.60626 .11292 L
.60757 .20801 L
.60888 .18338 L
.61019 .31525 L
.6115 .25384 L
.61282 .23482 L
Mistroke
.61413 .25446 L
.61544 .37137 L
.61675 .30871 L
.61806 .25508 L
.61938 .16124 L
.62069 .31556 L
.622 .23451 L
.62331 .25103 L
.62462 .22827 L
.62593 .15501 L
.62725 .20863 L
.62856 .29187 L
.62987 .28906 L
.63118 .25415 L
.63249 .32554 L
.63381 .22079 L
.63512 .27441 L
.63643 .3907 L
.63774 .29842 L
.63905 .36794 L
.64036 .24386 L
.64168 .35765 L
.64299 .30902 L
.6443 .30683 L
.64561 .24573 L
.64692 .25446 L
.64824 .20769 L
.64955 .28751 L
.65086 .32648 L
.65217 .27504 L
.65348 .27597 L
.65479 .28719 L
.65611 .26319 L
.65742 .22297 L
.65873 .29998 L
.66004 .29093 L
.66135 .22796 L
.66267 .28969 L
.66398 .26786 L
.66529 .2688 L
.6666 .33645 L
.66791 .27504 L
.66922 .28314 L
.67054 .19522 L
.67185 .32429 L
.67316 .3271 L
.67447 .16498 L
.67578 .18868 L
.6771 .15033 L
.67841 .22141 L
Mistroke
.67972 .26256 L
.68103 .29499 L
.68234 .35547 L
.68365 .33022 L
.68497 .32835 L
.68628 .26412 L
.68759 .3458 L
.6889 .26381 L
.69021 .34705 L
.69153 .12227 L
.69284 .23014 L
.69415 .2105 L
.69546 .22453 L
.69677 .16654 L
.69808 .23513 L
.6994 .26911 L
.70071 .23108 L
.70202 .237 L
.70333 .30091 L
.70464 .31432 L
.70596 .34674 L
.70727 .27098 L
.70858 .27722 L
.70989 .12196 L
.7112 .27348 L
.71251 .21829 L
.71383 .19585 L
.71514 .26444 L
.71645 .24822 L
.71776 .23887 L
.71907 .27472 L
.72039 .27691 L
.7217 .22484 L
.72301 .30309 L
.72432 .19367 L
.72563 .38945 L
.72694 .33365 L
.72826 .39226 L
.72957 .32149 L
.73088 .21985 L
.73219 .29873 L
.7335 .26911 L
.73482 .60332 L
.73613 .2158 L
.73744 .29062 L
.73875 .26724 L
.74006 .31681 L
.74137 .23607 L
.74269 .27504 L
.744 .20302 L
Mistroke
.74531 .24698 L
.74662 .25415 L
.74793 .32897 L
.74925 .35204 L
.75056 .24635 L
.75187 .30871 L
.75318 .24854 L
.75449 .34674 L
.7558 .26911 L
.75712 .23731 L
.75843 .1812 L
.75974 .28096 L
.76105 .28252 L
.76236 .32305 L
.76368 .09515 L
.76499 .34955 L
.7663 .23014 L
.76761 .29031 L
.76892 .23201 L
.77023 .27285 L
.77155 .22079 L
.77286 .34113 L
.77417 .33957 L
.77548 .39007 L
.77679 .28969 L
.77811 .14877 L
.77942 .27036 L
.78073 .29998 L
.78204 .16841 L
.78335 .34393 L
.78466 .367 L
.78598 .27067 L
.78729 .32554 L
.7886 .11978 L
.78991 .25851 L
.79122 .37511 L
.79254 .28782 L
.79385 .19429 L
.79516 .3695 L
.79647 .26942 L
.79778 .33988 L
.79909 .30621 L
.80041 .28719 L
.80172 .12477 L
.80303 .37449 L
.80434 .3218 L
.80565 .25384 L
.80697 .10481 L
.80828 .44494 L
.80959 .32086 L
Mistroke
.8109 .29779 L
.81221 .3112 L
.81352 .26381 L
.81484 .2847 L
.81615 .37667 L
.81746 .23731 L
.81877 .29592 L
.82008 .40192 L
.8214 .24043 L
.82271 .23264 L
.82402 .31588 L
.82533 .17465 L
.82664 .27909 L
.82795 .27691 L
.82927 .30216 L
.83058 .27535 L
.83189 .23482 L
.8332 .31806 L
.83451 .25539 L
.83583 .32305 L
.83714 .30309 L
.83845 .29561 L
.83976 .26163 L
.84107 .4543 L
.84238 .13817 L
.8437 .29655 L
.84501 .20021 L
.84632 .26444 L
.84763 .32461 L
.84894 .41844 L
.85026 .21299 L
.85157 .28376 L
.85288 .19024 L
.85419 .23638 L
.8555 .32679 L
.85681 .14191 L
.85813 .20551 L
.85944 .24916 L
.86075 .30465 L
.86206 .27441 L
.86337 .35983 L
.86469 .3299 L
.866 .24168 L
.86731 .39756 L
.86862 .31775 L
.86993 .30777 L
.87124 .18899 L
.87256 .29312 L
.87387 .32803 L
.87518 .32616 L
Mistroke
.87649 .35235 L
.8778 .28501 L
.87912 .29998 L
.88043 .22484 L
.88174 .27722 L
.88305 .21518 L
.88436 .38571 L
.88567 .31026 L
.88699 .1469 L
.8883 .25041 L
.88961 .25695 L
.89092 .27161 L
.89223 .26599 L
.89355 .34082 L
.89486 .21642 L
.89617 .32741 L
.89748 .32803 L
.89879 .35453 L
.9001 .3564 L
.90142 .19647 L
.90273 .1469 L
.90404 .21736 L
.90535 .30683 L
.90666 .31993 L
.90798 .28906 L
.90929 .31213 L
.9106 .4543 L
.91191 .34736 L
.91322 .01472 L
.91453 .25165 L
.91585 .29249 L
.91716 .41502 L
.91847 .39756 L
.91978 .26942 L
.92109 .22515 L
.92241 .19741 L
.92372 .38789 L
.92503 .23139 L
.92634 .28906 L
.92765 .38571 L
.92896 .33552 L
.93028 .20427 L
.93159 .3006 L
.9329 .31775 L
.93421 .21299 L
.93552 .33895 L
.93684 .36295 L
.93815 .33271 L
.93946 .20551 L
.94077 .24573 L
Mistroke
.94208 .08517 L
.94339 .30434 L
.94471 .20395 L
.94602 .36607 L
.94733 .38353 L
.94864 .26381 L
.94995 .40161 L
.95127 .34799 L
.95258 .27909 L
.95389 .2158 L
.9552 .43216 L
.95651 .23388 L
.95783 .35796 L
.95914 .38758 L
.96045 .08736 L
.96176 .19491 L
.96307 .31026 L
.96438 .42343 L
.9657 .45305 L
.96701 .32959 L
.96832 .32803 L
.96963 .42562 L
.97094 .22921 L
.97226 .43902 L
.97357 .16 L
.97488 .16498 L
.97619 .31681 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224977 0.00131182 0.283688 0.0301539 [
[.15368 .27119 -9 -9 ]
[.15368 .27119 9 0 ]
[.28486 .27119 -9 -9 ]
[.28486 .27119 9 0 ]
[.41604 .27119 -9 -9 ]
[.41604 .27119 9 0 ]
[.54723 .27119 -9 -9 ]
[.54723 .27119 9 0 ]
[.67841 .27119 -9 -9 ]
[.67841 .27119 9 0 ]
[.80959 .27119 -9 -9 ]
[.80959 .27119 9 0 ]
[.94077 .27119 -9 -9 ]
[.94077 .27119 9 0 ]
[.01 .13292 -12 -4.5 ]
[.01 .13292 0 4.5 ]
[.01 .43446 -6 -4.5 ]
[.01 .43446 0 4.5 ]
[.01 .58523 -12 -4.5 ]
[.01 .58523 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15368 .28369 m
.15368 .28994 L
s
[(100)] .15368 .27119 0 1 Mshowa
.28486 .28369 m
.28486 .28994 L
s
[(200)] .28486 .27119 0 1 Mshowa
.41604 .28369 m
.41604 .28994 L
s
[(300)] .41604 .27119 0 1 Mshowa
.54723 .28369 m
.54723 .28994 L
s
[(400)] .54723 .27119 0 1 Mshowa
.67841 .28369 m
.67841 .28994 L
s
[(500)] .67841 .27119 0 1 Mshowa
.80959 .28369 m
.80959 .28994 L
s
[(600)] .80959 .27119 0 1 Mshowa
.94077 .28369 m
.94077 .28994 L
s
[(700)] .94077 .27119 0 1 Mshowa
.125 Mabswid
.04873 .28369 m
.04873 .28744 L
s
.07497 .28369 m
.07497 .28744 L
s
.10121 .28369 m
.10121 .28744 L
s
.12744 .28369 m
.12744 .28744 L
s
.17992 .28369 m
.17992 .28744 L
s
.20615 .28369 m
.20615 .28744 L
s
.23239 .28369 m
.23239 .28744 L
s
.25863 .28369 m
.25863 .28744 L
s
.3111 .28369 m
.3111 .28744 L
s
.33733 .28369 m
.33733 .28744 L
s
.36357 .28369 m
.36357 .28744 L
s
.38981 .28369 m
.38981 .28744 L
s
.44228 .28369 m
.44228 .28744 L
s
.46852 .28369 m
.46852 .28744 L
s
.49475 .28369 m
.49475 .28744 L
s
.52099 .28369 m
.52099 .28744 L
s
.57346 .28369 m
.57346 .28744 L
s
.5997 .28369 m
.5997 .28744 L
s
.62593 .28369 m
.62593 .28744 L
s
.65217 .28369 m
.65217 .28744 L
s
.70464 .28369 m
.70464 .28744 L
s
.73088 .28369 m
.73088 .28744 L
s
.75712 .28369 m
.75712 .28744 L
s
.78335 .28369 m
.78335 .28744 L
s
.83583 .28369 m
.83583 .28744 L
s
.86206 .28369 m
.86206 .28744 L
s
.8883 .28369 m
.8883 .28744 L
s
.91453 .28369 m
.91453 .28744 L
s
.96701 .28369 m
.96701 .28744 L
s
.99324 .28369 m
.99324 .28744 L
s
.25 Mabswid
0 .28369 m
1 .28369 L
s
.0225 .13292 m
.02875 .13292 L
s
[(-5)] .01 .13292 1 0 Mshowa
.0225 .43446 m
.02875 .43446 L
s
[(5)] .01 .43446 1 0 Mshowa
.0225 .58523 m
.02875 .58523 L
s
[(10)] .01 .58523 1 0 Mshowa
.125 Mabswid
.0225 .16307 m
.02625 .16307 L
s
.0225 .19323 m
.02625 .19323 L
s
.0225 .22338 m
.02625 .22338 L
s
.0225 .25353 m
.02625 .25353 L
s
.0225 .31384 m
.02625 .31384 L
s
.0225 .344 m
.02625 .344 L
s
.0225 .37415 m
.02625 .37415 L
s
.0225 .4043 m
.02625 .4043 L
s
.0225 .46461 m
.02625 .46461 L
s
.0225 .49476 m
.02625 .49476 L
s
.0225 .52492 m
.02625 .52492 L
s
.0225 .55507 m
.02625 .55507 L
s
.0225 .10276 m
.02625 .10276 L
s
.0225 .07261 m
.02625 .07261 L
s
.0225 .04246 m
.02625 .04246 L
s
.0225 .0123 m
.02625 .0123 L
s
.0225 .61538 m
.02625 .61538 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02512 .01833 L
.02643 .0319 L
.02774 .04216 L
.02906 .05995 L
.03037 .06779 L
.03168 .08347 L
.03299 .08769 L
.0343 .09613 L
.03562 .09613 L
.03693 .09643 L
.03824 .09673 L
.03955 .1088 L
.04086 .11 L
.04217 .11181 L
.04349 .11694 L
.0448 .11784 L
.04611 .11814 L
.04742 .11844 L
.04873 .11905 L
.05005 .11995 L
.05136 .12297 L
.05267 .12327 L
.05398 .12448 L
.05529 .12568 L
.05661 .1293 L
.05792 .13051 L
.05923 .13232 L
.06054 .13533 L
.06185 .13593 L
.06316 .13593 L
.06448 .13895 L
.06579 .14076 L
.0671 .14136 L
.06841 .14166 L
.06972 .14196 L
.07104 .14317 L
.07235 .14408 L
.07366 .14558 L
.07497 .1486 L
.07628 .1498 L
.07759 .15071 L
.07891 .15101 L
.08022 .15161 L
.08153 .15192 L
.08284 .15252 L
.08415 .15282 L
.08547 .15433 L
.08678 .15463 L
.08809 .15644 L
Mistroke
.0894 .15704 L
.09071 .15704 L
.09202 .15825 L
.09334 .15885 L
.09465 .15945 L
.09596 .15976 L
.09727 .16126 L
.09858 .16368 L
.0999 .16488 L
.10121 .16488 L
.10252 .16488 L
.10383 .16548 L
.10514 .16699 L
.10645 .16729 L
.10777 .16729 L
.10908 .1682 L
.11039 .1694 L
.1117 .1694 L
.11301 .17031 L
.11433 .17272 L
.11564 .17363 L
.11695 .17423 L
.11826 .17483 L
.11957 .17694 L
.12088 .17815 L
.1222 .17815 L
.12351 .17875 L
.12482 .17905 L
.12613 .17936 L
.12744 .18056 L
.12876 .18207 L
.13007 .18267 L
.13138 .18328 L
.13269 .18418 L
.134 .18629 L
.13531 .18659 L
.13663 .18659 L
.13794 .1872 L
.13925 .1872 L
.14056 .1887 L
.14187 .1887 L
.14319 .18931 L
.1445 .19021 L
.14581 .19051 L
.14712 .19051 L
.14843 .19081 L
.14974 .19112 L
.15106 .19112 L
.15237 .19202 L
.15368 .19262 L
Mistroke
.15499 .19323 L
.1563 .19323 L
.15762 .19353 L
.15893 .19413 L
.16024 .19413 L
.16155 .19504 L
.16286 .19504 L
.16417 .19534 L
.16549 .19564 L
.1668 .19654 L
.16811 .19684 L
.16942 .19684 L
.17073 .19684 L
.17205 .19835 L
.17336 .19896 L
.17467 .19986 L
.17598 .20076 L
.17729 .20076 L
.1786 .20167 L
.17992 .20197 L
.18123 .20197 L
.18254 .20257 L
.18385 .20257 L
.18516 .20257 L
.18648 .20288 L
.18779 .20408 L
.1891 .20468 L
.19041 .20468 L
.19172 .20499 L
.19303 .20529 L
.19435 .20589 L
.19566 .20619 L
.19697 .20619 L
.19828 .20649 L
.19959 .2068 L
.20091 .2068 L
.20222 .2071 L
.20353 .2071 L
.20484 .2071 L
.20615 .2074 L
.20746 .2074 L
.20878 .2074 L
.21009 .2077 L
.2114 .2077 L
.21271 .2086 L
.21402 .20891 L
.21534 .20921 L
.21665 .20921 L
.21796 .20921 L
.21927 .20921 L
Mistroke
.22058 .20981 L
.22189 .21011 L
.22321 .21072 L
.22452 .21102 L
.22583 .21102 L
.22714 .21132 L
.22845 .21192 L
.22977 .21192 L
.23108 .21222 L
.23239 .21283 L
.2337 .21313 L
.23501 .21373 L
.23632 .21433 L
.23764 .21494 L
.23895 .21524 L
.24026 .21554 L
.24157 .21644 L
.24288 .21675 L
.2442 .21705 L
.24551 .21705 L
.24682 .21735 L
.24813 .21765 L
.24944 .21825 L
.25075 .21825 L
.25207 .21856 L
.25338 .21856 L
.25469 .21856 L
.256 .21856 L
.25731 .21856 L
.25863 .21886 L
.25994 .21916 L
.26125 .21946 L
.26256 .21976 L
.26387 .22006 L
.26518 .22036 L
.2665 .22067 L
.26781 .22067 L
.26912 .22097 L
.27043 .22127 L
.27174 .22157 L
.27306 .22157 L
.27437 .22248 L
.27568 .22308 L
.27699 .22338 L
.2783 .22338 L
.27961 .22368 L
.28093 .22398 L
.28224 .22459 L
.28355 .22489 L
.28486 .22519 L
Mistroke
.28617 .22579 L
.28749 .2264 L
.2888 .2267 L
.29011 .2267 L
.29142 .2267 L
.29273 .2267 L
.29404 .227 L
.29536 .2273 L
.29667 .2273 L
.29798 .2276 L
.29929 .2276 L
.3006 .2279 L
.30192 .2282 L
.30323 .22911 L
.30454 .22971 L
.30585 .22971 L
.30716 .23001 L
.30847 .23001 L
.30979 .23001 L
.3111 .23032 L
.31241 .23032 L
.31372 .23092 L
.31503 .23092 L
.31635 .23122 L
.31766 .23152 L
.31897 .23182 L
.32028 .23182 L
.32159 .23212 L
.3229 .23212 L
.32422 .23212 L
.32553 .23243 L
.32684 .23303 L
.32815 .23333 L
.32946 .23333 L
.33078 .23333 L
.33209 .23393 L
.3334 .23393 L
.33471 .23424 L
.33602 .23424 L
.33733 .23424 L
.33865 .23454 L
.33996 .23514 L
.34127 .23574 L
.34258 .23574 L
.34389 .23604 L
.34521 .23604 L
.34652 .23604 L
.34783 .23665 L
.34914 .23725 L
.35045 .23755 L
Mistroke
.35176 .23785 L
.35308 .23846 L
.35439 .23876 L
.3557 .23906 L
.35701 .23906 L
.35832 .23936 L
.35964 .23936 L
.36095 .23966 L
.36226 .23966 L
.36357 .23996 L
.36488 .23996 L
.36619 .24027 L
.36751 .24027 L
.36882 .24087 L
.37013 .24087 L
.37144 .24087 L
.37275 .24117 L
.37407 .24147 L
.37538 .24147 L
.37669 .24147 L
.378 .24147 L
.37931 .24177 L
.38062 .24177 L
.38194 .24208 L
.38325 .24208 L
.38456 .24238 L
.38587 .24268 L
.38718 .24268 L
.3885 .24328 L
.38981 .24388 L
.39112 .24388 L
.39243 .24419 L
.39374 .24449 L
.39505 .24449 L
.39637 .24449 L
.39768 .24449 L
.39899 .24479 L
.4003 .24509 L
.40161 .24539 L
.40293 .24569 L
.40424 .24569 L
.40555 .246 L
.40686 .246 L
.40817 .246 L
.40948 .2463 L
.4108 .2463 L
.41211 .2466 L
.41342 .2469 L
.41473 .2472 L
.41604 .2472 L
Mistroke
.41736 .2472 L
.41867 .2475 L
.41998 .2475 L
.42129 .24753 L
.4226 .2478 L
.42391 .2478 L
.42523 .24841 L
.42654 .24841 L
.42785 .24841 L
.42916 .24871 L
.43047 .24901 L
.43179 .24901 L
.4331 .24901 L
.43441 .24913 L
.43572 .24961 L
.43703 .24961 L
.43834 .24961 L
.43966 .24961 L
.44097 .24961 L
.44228 .24961 L
.44359 .24961 L
.4449 .24961 L
.44622 .25052 L
.44753 .25052 L
.44884 .25052 L
.45015 .25052 L
.45146 .25082 L
.45277 .25082 L
.45409 .25082 L
.4554 .25082 L
.45671 .25082 L
.45802 .25112 L
.45933 .25112 L
.46065 .25142 L
.46196 .25172 L
.46327 .25172 L
.46458 .25203 L
.46589 .25203 L
.4672 .25209 L
.46852 .25233 L
.46983 .25233 L
.47114 .2526 L
.47245 .25263 L
.47376 .25266 L
.47508 .25323 L
.47639 .25323 L
.4777 .25323 L
.47901 .25353 L
.48032 .25353 L
.48163 .25353 L
Mistroke
.48295 .25353 L
.48426 .25384 L
.48557 .25384 L
.48688 .25414 L
.48819 .25474 L
.48951 .25474 L
.49082 .25504 L
.49213 .25534 L
.49344 .25564 L
.49475 .25564 L
.49606 .25595 L
.49738 .25625 L
.49869 .25655 L
.5 .25655 L
.50131 .25655 L
.50262 .25682 L
.50394 .25715 L
.50525 .25715 L
.50656 .25715 L
.50787 .25715 L
.50918 .25745 L
.51049 .25745 L
.51181 .25776 L
.51312 .25806 L
.51443 .25836 L
.51574 .25866 L
.51705 .25866 L
.51837 .25866 L
.51968 .25896 L
.52099 .25987 L
.5223 .25987 L
.52361 .25987 L
.52492 .25987 L
.52624 .25987 L
.52755 .25987 L
.52886 .26017 L
.53017 .26047 L
.53148 .26047 L
.5328 .26047 L
.53411 .26077 L
.53542 .26077 L
.53673 .26137 L
.53804 .26137 L
.53935 .26137 L
.54067 .26168 L
.54198 .26168 L
.54329 .26168 L
.5446 .26168 L
.54591 .26198 L
.54723 .26198 L
Mistroke
.54854 .26258 L
.54985 .26258 L
.55116 .26348 L
.55247 .26379 L
.55378 .26409 L
.5551 .26409 L
.55641 .26409 L
.55772 .26409 L
.55903 .26409 L
.56034 .26439 L
.56166 .26439 L
.56297 .26469 L
.56428 .26469 L
.56559 .26469 L
.5669 .26499 L
.56821 .26529 L
.56953 .26529 L
.57084 .26529 L
.57215 .26529 L
.57346 .2656 L
.57477 .2656 L
.57609 .2656 L
.5774 .2659 L
.57871 .2659 L
.58002 .2662 L
.58133 .2662 L
.58264 .2668 L
.58396 .2668 L
.58527 .2671 L
.58658 .2674 L
.58789 .2674 L
.5892 .26771 L
.59052 .26771 L
.59183 .26801 L
.59314 .26831 L
.59445 .26861 L
.59576 .26861 L
.59707 .26861 L
.59839 .26921 L
.5997 .26921 L
.60101 .26952 L
.60232 .26952 L
.60363 .26952 L
.60495 .26952 L
.60626 .26982 L
.60757 .26982 L
.60888 .26982 L
.61019 .27012 L
.6115 .27012 L
.61282 .27072 L
Mistroke
.61413 .27102 L
.61544 .27102 L
.61675 .27132 L
.61806 .27132 L
.61938 .27132 L
.62069 .27132 L
.622 .27132 L
.62331 .27132 L
.62462 .27163 L
.62593 .27163 L
.62725 .27163 L
.62856 .27193 L
.62987 .27193 L
.63118 .27193 L
.63249 .27223 L
.63381 .27223 L
.63512 .27313 L
.63643 .27344 L
.63774 .27344 L
.63905 .27344 L
.64036 .27344 L
.64168 .27374 L
.64299 .27374 L
.6443 .27374 L
.64561 .27374 L
.64692 .27374 L
.64824 .27374 L
.64955 .27404 L
.65086 .27404 L
.65217 .27404 L
.65348 .27404 L
.65479 .27434 L
.65611 .27434 L
.65742 .27464 L
.65873 .27494 L
.66004 .27524 L
.66135 .27555 L
.66267 .27555 L
.66398 .27555 L
.66529 .27585 L
.6666 .27585 L
.66791 .27615 L
.66922 .27705 L
.67054 .27705 L
.67185 .27705 L
.67316 .27705 L
.67447 .27766 L
.67578 .27796 L
.6771 .27826 L
.67841 .27826 L
Mistroke
.67972 .27916 L
.68103 .27947 L
.68234 .27947 L
.68365 .27977 L
.68497 .27977 L
.68628 .28007 L
.68759 .28037 L
.6889 .28037 L
.69021 .28067 L
.69153 .28067 L
.69284 .28067 L
.69415 .28097 L
.69546 .28128 L
.69677 .28188 L
.69808 .28188 L
.6994 .28218 L
.70071 .28248 L
.70202 .28308 L
.70333 .28369 L
.70464 .28369 L
.70596 .28399 L
.70727 .28399 L
.70858 .28399 L
.70989 .28429 L
.7112 .28459 L
.71251 .28489 L
.71383 .2852 L
.71514 .2852 L
.71645 .2852 L
.71776 .2852 L
.71907 .2855 L
.72039 .2855 L
.7217 .2858 L
.72301 .2858 L
.72432 .2858 L
.72563 .2861 L
.72694 .2861 L
.72826 .2861 L
.72957 .2867 L
.73088 .287 L
.73219 .28731 L
.7335 .28761 L
.73482 .28761 L
.73613 .28791 L
.73744 .28791 L
.73875 .28821 L
.74006 .28851 L
.74137 .28881 L
.74269 .28912 L
.744 .28912 L
Mistroke
.74531 .28942 L
.74662 .28942 L
.74793 .28942 L
.74925 .28972 L
.75056 .29032 L
.75187 .29062 L
.75318 .29123 L
.75449 .29183 L
.7558 .29213 L
.75712 .29243 L
.75843 .29334 L
.75974 .29364 L
.76105 .29364 L
.76236 .29394 L
.76368 .29454 L
.76499 .29454 L
.7663 .29484 L
.76761 .29515 L
.76892 .29515 L
.77023 .29545 L
.77155 .29545 L
.77286 .29635 L
.77417 .29665 L
.77548 .29726 L
.77679 .29756 L
.77811 .29756 L
.77942 .29786 L
.78073 .29816 L
.78204 .29816 L
.78335 .29846 L
.78466 .29876 L
.78598 .29907 L
.78729 .29937 L
.7886 .29937 L
.78991 .29937 L
.79122 .29967 L
.79254 .29967 L
.79385 .29997 L
.79516 .29997 L
.79647 .30027 L
.79778 .30027 L
.79909 .30027 L
.80041 .30088 L
.80172 .30088 L
.80303 .30178 L
.80434 .30208 L
.80565 .30208 L
.80697 .30299 L
.80828 .30389 L
.80959 .30389 L
Mistroke
.8109 .30449 L
.81221 .30449 L
.81352 .30449 L
.81484 .3048 L
.81615 .3048 L
.81746 .3051 L
.81877 .3051 L
.82008 .3054 L
.8214 .3057 L
.82271 .3057 L
.82402 .30691 L
.82533 .30691 L
.82664 .30721 L
.82795 .30721 L
.82927 .30841 L
.83058 .30841 L
.83189 .30841 L
.8332 .30872 L
.83451 .30872 L
.83583 .30902 L
.83714 .30902 L
.83845 .30902 L
.83976 .30962 L
.84107 .30992 L
.84238 .31052 L
.8437 .31113 L
.84501 .31173 L
.84632 .31203 L
.84763 .31203 L
.84894 .31203 L
.85026 .31233 L
.85157 .31264 L
.85288 .31294 L
.85419 .31384 L
.8555 .31505 L
.85681 .31535 L
.85813 .31565 L
.85944 .31565 L
.86075 .31625 L
.86206 .31625 L
.86337 .31656 L
.86469 .31746 L
.866 .31746 L
.86731 .31987 L
.86862 .32078 L
.86993 .32078 L
.87124 .32108 L
.87256 .32259 L
.87387 .32379 L
.87518 .32409 L
Mistroke
.87649 .32409 L
.8778 .32409 L
.87912 .3247 L
.88043 .3262 L
.88174 .3262 L
.88305 .3262 L
.88436 .32651 L
.88567 .32681 L
.88699 .32711 L
.8883 .32711 L
.88961 .32771 L
.89092 .32771 L
.89223 .32801 L
.89355 .32922 L
.89486 .32982 L
.89617 .32982 L
.89748 .33012 L
.89879 .33012 L
.9001 .33103 L
.90142 .33133 L
.90273 .33163 L
.90404 .33193 L
.90535 .33224 L
.90666 .33254 L
.90798 .33374 L
.90929 .33435 L
.9106 .33435 L
.91191 .33465 L
.91322 .33495 L
.91453 .33616 L
.91585 .33706 L
.91716 .33796 L
.91847 .33917 L
.91978 .33977 L
.92109 .34008 L
.92241 .34188 L
.92372 .34219 L
.92503 .34219 L
.92634 .34249 L
.92765 .3446 L
.92896 .34641 L
.93028 .34701 L
.93159 .34761 L
.9329 .34942 L
.93421 .35003 L
.93552 .35153 L
.93684 .35364 L
.93815 .35425 L
.93946 .35666 L
.94077 .35666 L
Mistroke
.94208 .35696 L
.94339 .36088 L
.94471 .36299 L
.94602 .36299 L
.94733 .36329 L
.94864 .3651 L
.94995 .36872 L
.95127 .36932 L
.95258 .37023 L
.95389 .37385 L
.9552 .37385 L
.95651 .37566 L
.95783 .37626 L
.95914 .38923 L
.96045 .39254 L
.96176 .39948 L
.96307 .40038 L
.96438 .4037 L
.9657 .40551 L
.96701 .41033 L
.96832 .41275 L
.96963 .423 L
.97094 .46672 L
.97226 .49688 L
.97357 .49808 L
.97488 .55477 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{489.688, 144.063},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007Y0000T2000`400?l00000o`00003oo`0J6Q[Z
01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z
01XJ6P00o`0J6Q[Z01XJ6P00o`0J6QX>01XJ6P030=_Kf`0J6QX06QXJ0=T06QXJ003o01XJ6Ph06QXJ
00<0fm_K01XJ6P0J6QX0f@0J6QX00?l06QXJ3P0J6QX00`3Kfm/06QXJ01XJ6P3I01XJ6P009`0J6QX0
0`3Kfm/06QXJ01XJ6P3S01XJ6P80fm_KfP0J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0h`0J6QX20=_K
fmX06QXJ000W01XJ6P80fm_Ki00J6QX20=_KfmX06QXJ000W01XJ6P030=_Kf`0J6QX06QXJ0:h06QXJ
00<0fm_K01XJ6P0J6QX0<P0J6QX20=_KfmX06QXJ000W01XJ6P80fm_K[`0J6QX00`3Kfm/06QXJ01XJ
6P0b01XJ6P80fm_KfP0J6QX002L06QXJ0P3Kfm^_01XJ6P030=_Kf`0J6QX06QXJ03806QXJ0P3Kfm_J
01XJ6P009`0J6QX20=_Kfjl06QXJ00<0fm_K01XJ6P0J6QX0<P0J6QX30=_KfmT06QXJ000W01XJ6P80
fm_K[`0J6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX0fm_K0=T06QXJ000W01XJ6P80fm_K
[`0J6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX0fm_K0=T06QXJ000E01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX0W00J
6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX0fm_K0=T06QXJ000E01XJ6P030=_Kf`0J6QX0
6QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX0W00J
6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX0fm_K0=T06QXJ000E01XJ6P030=_Kf`0J6QX0
6QXJ00X06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX0W00J6QX0
0`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX0fm_K0=T06QXJ000=01XJ6P@0fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P0701XJ6P80fm_K1@0J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX0W00J6QX00`3K
fm/06QXJ01XJ6P0b01XJ6P<0fm_Kf@0J6QX001<06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3K
fm/06QXJ01XJ6P0401XJ6P80fm_K400J6QX00`3Kfm/06QXJ01XJ6P2L01XJ6P030=_Kf`0J6QX06QXJ
03806QXJ00<0fm_K01XJ6P3Kfm/0f@0J6QX001<06QXJ103Kfm/901XJ6P<0fm_K100J6QX20=_Kfa00
6QXJ00<0fm_K01XJ6P0J6QX0=`0J6QX00`3Kfm/06QXJ01XJ6P1R01XJ6P030=_Kf`0J6QX06QXJ0380
6QXJ00<0fm_K01XJ6P3Kfm/0f@0J6QX002L06QXJ0P3Kfm/@01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ
00<0fm_K01XJ6P0J6QX07P0J6QX00`3Kfm/06QXJ01XJ6P1R01XJ6P030=_Kf`0J6QX06QXJ03806QXJ
00@0fm_K01XJ6P0J6QX0fm_Kf00J6QX002L06QXJ0`3Kfm/?01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ
00<0fm_K01XJ6P0J6QX06P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K06@06QXJ00<0fm_K01XJ6P0J
6QX0<P0J6QX0103Kfm/06QXJ01XJ6P3Kfm_H01XJ6P009`0J6QX30=_Kf`l06QXJ00<0fm_K01XJ6P0J
6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ01X06QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`1T01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0;@0J6QX00`3K
fm/06QXJ01XJ6P020=_KfmL06QXJ000W01XJ6P<0fm_K3`0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P03
0=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX06P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K
06@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K02/06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`3G01XJ6P009`0J6QX30=_Kf`l06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX0
0`3Kfm/06QXJ01XJ6P0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0700J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K04H06QXJ00<0fm_K01XJ6P0J6QX06`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050=_K
f`0J6QX06QXJ01XJ6P3Kfm/0:`0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0e@0J6QX002L06QXJ
103Kfm/>01XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0100J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K01`06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`1601XJ6P030=_Kf`0J6QX06QXJ
01/06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K02/06QXJ00@0fm_K
01XJ6P0J6QX06QXJ0P3Kfm_F01XJ6P009`0J6QX40=_Kf`h06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX0
0`3Kfm/06QXJ01XJ6P0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0700J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K04H06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030=_K
f`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0[01XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX0e00J6QX002L06QXJ103Kfm/801XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3K
fm/0700J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3K
fm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX04P0J6QX00`3K
fm/06QXJ01XJ6P0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0:`0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P80fm_Ke@0J6QX002L06QXJ103Kfm/801XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ
6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0700J6QX0
1@3Kfm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ
6P0F01XJ6P030=_Kf`0J6QX06QXJ01`06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ
6P0B01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0U01XJ6P80fm_K
100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ0=806QXJ000P01XJ6P80fm_K1@0J
6QX50=_Kf`<06QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0501XJ6P030=_Kf`0J6QX06QXJ00/06QXJ
00<0fm_K01XJ6P0J6QX0100J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00P06QXJ00<0fm_K01XJ6P0J
6QX04@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3K
fm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J6QX06QXJ01`06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3K
fm/06QXJ01XJ6P0J6QX0fm_K01@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX0fm_K02@06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_K
f`0J6QX06QXJ0=406QXJ000O01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ1@3Kfm/301XJ6P<0fm_K
00<06QXJ0=_Kf`0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`0=01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0801XJ6P030=_Kf`0J6QX06QXJ01406QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3K
fm/06QXJ01XJ6P0>01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX0
1@3Kfm/06QXJ0=_Kf`0J6QX0fm_K01@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K02L06QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3Kfm/501XJ6P030=_Kf`0J6QX06QXJ0=40
6QXJ000R01XJ6P030=_Kf`0J6QX06QXJ00806QXJ1@3Kfm/301XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0
0P0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00/06QXJ00<0fm_K01XJ6P0J6QX0100J6QX01@3Kfm/0
6QXJ0=_Kf`0J6QX0fm_K00P06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P0601XJ
6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX0
6QXJ01H06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0D01XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0N01XJ6P@0fm_K0`0J6QX20=_Kf`@06QXJ00<0fm_K01XJ6P0J
6QX01P0J6QX00`3Kfm/06QXJ01XJ6P3@01XJ6P006@0J6QX40=_Kf`<06QXJ0P3Kfm/501XJ6PD0fm_K
0`0J6QX30=_Kf`0301XJ6P3Kfm/06QXJ00806QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0;01XJ6P03
0=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ
6P0J6QX03P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K
01XJ6P3Kfm/06QXJ0=_Kf`0D01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ
0=_Kf`0U01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX20=_Kfm006QXJ
000P01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ1P3Kfm/201XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX00P0J
6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX20=_Kf`D06QXJ
00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0
200J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ0080fm_K0`0J6QX00`3Kfm/06QXJ
01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0601XJ
6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0
fm_K02D06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0P3Kfm_?01XJ6P00800J6QX30=_K
f`@06QXJ1P3Kfm/201XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00P0J6QX0103Kfm/06QXJ0=_Kf`0J6QX2
0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0100J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/2
01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P06
01XJ6P030=_Kf`0J6QX06QXJ0080fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0
6QXJ00<06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00H06QXJ
00<0fm_K01XJ6P3Kfm/01@0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/0100J6QX01@3K
fm/06QXJ01XJ6P0J6QX0fm_K02/06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX30=_Kfld06QXJ000W01XJ
6P030=_Kf`0J6QX0fm_K00<0fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00@0fm_K01XJ
6P3Kfm/06QXJ0P3Kfm/301XJ6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ0P3Kfm/501XJ6P030=_Kf`0J
6QX0fm_K0080fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P80fm_K0`0J6QX00`3Kfm/06QXJ01XJ
6P0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ
6P0901XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ
01XJ6P0801XJ6P0:0=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`H06QXJ00<0
fm_K01XJ6P3Kfm/01@0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/0100J6QX01@3Kfm/0
6QXJ01XJ6P0J6QX0fm_K02/06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX30=_Kfl/06QXJ000W01XJ6P03
0=_Kf`0J6QX0fm_K00@0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P030=_Kf`0501XJ6P3Kfm/06QXJ
0=_Kf`0J6QX00P3Kfm/301XJ6P040=_Kf`0J6QX0fm_K0=_Kf`<06QXJ0P3Kfm/501XJ6P030=_Kf`0J
6QX0fm_K0080fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K2@0J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX0fm_K00806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00D0
fm_K01XJ6P0J6QX06QXJ0=_Kf`0901XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J
6QX0200J6QX02P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/601XJ6P030=_K
f`0J6QX0fm_K00D06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00@06QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0[01XJ6P80fm_K3P0J6QX00`3Kfm/06QXJ01XJ6P3901XJ6P009`0J6QX00`3K
fm/06QXJ0=_Kf`040=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00`3Kfm/01@0J6QX0fm_K01XJ6P3K
fm/06QXJ0080fm_K0`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/301XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ
0=_Kf`020=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K00806QXJ0P3Kfm/301XJ6P030=_K
f`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_K
f`0J6QX06QXJ00T06QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0901XJ6P040=_Kf`0J6QX06QXJ0=_K
f`806QXJ00<0fm_K01XJ6P0J6QX0200J6QX02P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K
01XJ6P3Kfm/601XJ6P030=_Kf`0J6QX0fm_K00D06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0
fm_K00@06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ02H06QXJ00<0
fm_K01XJ6P0J6QX03P0J6QX30=_KflP06QXJ000W01XJ6Pl0fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ
6P020=_Kf`<06QXJ00@0fm_K01XJ6P3Kfm/0fm_K0`0J6QX20=_Kf`D06QXJ1@3Kfm/201XJ6P030=_K
f`0J6QX06QXJ00<06QXJ0P3Kfm/201XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_K
f`0J6QX0fm_K00806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00D0fm_K01XJ6P3Kfm/0
6QXJ0=_Kf`0801XJ6P80fm_K0P0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00T06QXJ00X0fm_K01XJ6P0J
6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K1P0J6QX00`3Kfm/06QXJ0=_Kf`0501XJ6P070=_K
f`0J6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0
0`3Kfm/06QXJ01XJ6P0V01XJ6P030=_Kf`0J6QX06QXJ01006QXJ0P3Kfm_701XJ6P009`0J6QX00`3K
fm/06QXJ0=_Kf`0<0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00P3Kfm/301XJ6PH0fm_K00<06QXJ
0=_Kf`3Kfm/01@0J6QX50=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_Kf`806QXJ0P3Kfm/5
01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX20=_Kf`<06QXJ00<0fm_K
01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/0200J
6QX20=_Kf`806QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00<0fm_K00@0
6QXJ0=_Kf`0J6QX0fm_K1P0J6QX00`3Kfm/06QXJ0=_Kf`0501XJ6P030=_Kf`0J6QX06QXJ0080fm_K
00<06QXJ0=_Kf`0J6QX00`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J
6QX09P0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P80fm_KaP0J6QX002L06QXJ00<0fm_K01XJ6P3Kfm/0
303Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ0080fm_K0`0J6QX60=_Kf`0501XJ6P3Kfm/0fm_K01XJ
6P3Kfm/00`0J6QX60=_Kf`0301XJ6P3Kfm/06QXJ00@06QXJ0P3Kfm/201XJ6P80fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K00806QXJ0`3Kfm/201XJ6P060=_Kf`0J6QX06QXJ
0=_Kf`0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00P06QXJ0P3Kfm/201XJ6P80fm_K
00<06QXJ0=_Kf`0J6QX02@0J6QX00`3Kfm/06QXJ01XJ6P030=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`80
6QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00D06QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/0
0`0J6QX0fm_K01XJ6P0301XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ01XJ
6P0V01XJ6P030=_Kf`0J6QX06QXJ01<06QXJ0P3Kfm_401XJ6P009`0J6QX?0=_Kf`0501XJ6P3Kfm/0
fm_K0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K01XJ6P060=_Kf`0501XJ6P3Kfm/0fm_K01XJ6P3Kfm/0
0`0J6QX60=_Kf`0301XJ6P3Kfm/06QXJ00@06QXJ0P3Kfm/201XJ6P80fm_K0`0J6QX00`3Kfm/06QXJ
0=_Kf`0301XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K0P0J6QX30=_Kf`806QXJ00H0fm_K01XJ
6P0J6QX0fm_K01XJ6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00T06QXJ0P3Kfm/501XJ6P030=_Kf`0J
6QX06QXJ00<06QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P80fm_K0P0J6QX20=_Kf`0301XJ
6P3Kfm/06QXJ00P06QXJ0P3Kfm/201XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX01P3Kfm/0
6QXJ01XJ6P0J6QX0fm_K01XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P040=_Kf`@06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ02H06QXJ00<0fm_K01XJ6P0J6QX0500J
6QX30=_Kfl806QXJ000W01XJ6P030=_Kf`0J6QX0fm_K00`0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ
6P020=_Kf`0301XJ6P3Kfm/06QXJ00H0fm_K00D06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0301XJ6PP0fm_K
0P0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00<06QXJ
00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/201XJ6P<0fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/0
6QXJ0=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX20=_Kf`D06QXJ00/0fm_K01XJ6P0J6QX06QXJ
0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P80fm_K0P0J6QX20=_Kf`0301XJ6P3Kfm/0
6QXJ00P06QXJ0P3Kfm/201XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX01P3Kfm/06QXJ01XJ
6P0J6QX0fm_K01XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P040=_Kf`@06QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ02H06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX40=_K
fkl06QXJ000W01XJ6P030=_Kf`0J6QX0fm_K00`0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_K
f`0301XJ6P3Kfm/0fm_K00@0fm_K00D06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0301XJ6PP0fm_K0P0J6QX0
0`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00<06QXJ00D0fm_K
01XJ6P3Kfm/0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ00D0fm_K01XJ6P0J6QX0
fm_K01XJ6P020=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/02`0J6QX20=_Kf`D06QXJ00/0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P80fm_K0P0J6QX20=_Kf`0301XJ
6P3Kfm/06QXJ00P06QXJ0P3Kfm/201XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX01P3Kfm/0
6QXJ01XJ6P0J6QX0fm_K01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX06QXJ0=_Kf`0201XJ6P@0fm_K100J
6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX09P0J6QX20=_KfaX06QXJ
1@3Kfm^k01XJ6P009`0J6QX?0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K
0=_Kf`040=_Kf`0501XJ6P3Kfm/0fm_K01XJ6P3Kfm/00`0J6QX80=_Kf`806QXJ00<0fm_K01XJ6P0J
6QX00P3Kfm/201XJ6P80fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`0301XJ6P3Kfm/06QXJ0080
fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/201XJ6P050=_Kf`0J6QX06QXJ0=_Kf`0J6QX00P3Kfm/2
01XJ6P030=_Kf`0J6QX0fm_K00/06QXJ0P3Kfm/501XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K00@0
6QXJ0=_Kf`3Kfm/0fm_K1`0J6QX30=_Kf`806QXJ0P3Kfm/01@0J6QX0fm_K0=_Kf`0J6QX0fm_K00H0
6QXJ0P3Kfm/201XJ6PL0fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P80fm_K00D06QXJ
0=_Kf`0J6QX06QXJ0=_Kf`0201XJ6P@0fm_K100J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ
00<0fm_K01XJ6P0J6QX09P0J6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P<0fm_K^@0J6QX001<06QXJ103K
fm/301XJ6P80fm_K100J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P3Kfm/0303Kfm/01@0J6QX0fm_K0=_K
f`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6PP0fm_K
00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00<06QXJ00<0fm_K01XJ6P3K
fm/00P3Kfm/00`0J6QX0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0P0J6QX01@3K
fm/06QXJ0=_Kf`3Kfm/06QXJ0080fm_K0P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/:01XJ6P80fm_K00<0
6QXJ0=_Kf`0J6QX00P0J6QX0103Kfm/06QXJ01XJ6P0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`L0
6QXJ0`3Kfm/201XJ6P80fm_K00D06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0601XJ6P80fm_K0P0J6QX70=_K
f`806QXJ00H0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P80fm_K
00<06QXJ0=_Kf`3Kfm/00`3Kfm/301XJ6P80fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/X01XJ6P03
0=_Kf`0J6QX06QXJ01l06QXJ1@3Kfm^e01XJ6P004`0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P040=_K
f`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P3Kfm/0303Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ
00@0fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00`0fm_K00D06QXJ
0=_Kf`3Kfm/0fm_K01XJ6P020=_Kf`<06QXJ1@3Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`0401XJ6P3K
fm/0fm_K0=_Kf`806QXJ00D0fm_K01XJ6P3Kfm/0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ
6P80fm_K00<06QXJ0=_Kf`0J6QX01`0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00806QXJ00@0fm_K01XJ
6P0J6QX06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`3Kfm/701XJ6P<0fm_K0P0J6QX20=_Kf`0501XJ6P3K
fm/0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ1`3Kfm/201XJ6P060=_K
f`0J6QX06QXJ01XJ6P3Kfm/06QXJ0P3Kfm/0100J6QX0fm_K01XJ6P0J6QX20=_Kf`0301XJ6P3Kfm/0
fm_K00<0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_KfbP06QXJ00<0
fm_K01XJ6P0J6QX08`0J6QX70=_Kfjl06QXJ000D01XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K
01XJ6P0J6QX00P0J6QX?0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_K
f`070=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0303Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ0080
fm_K0`0J6QX70=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0
fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PD0fm_K00D06QXJ0=_Kf`0J6QX06QXJ0=_Kf`05
01XJ6P80fm_K00<06QXJ0=_Kf`0J6QX00P0J6QX0103Kfm/06QXJ01XJ6P0J6QX30=_Kf`0401XJ6P3K
fm/0fm_K0=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3Kfm/201XJ6P80fm_K00D06QXJ0=_Kf`3K
fm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ0080fm_K0P0J6QX70=_Kf`806QXJ00H0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/0
0`3Kfm/00`0J6QX0fm_K01XJ6P020=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K:00J6QX00`3Kfm/0
6QXJ01XJ6P0Y01XJ6P<0fm_K[@0J6QX000d06QXJ103Kfm/401XJ6P030=_Kf`0J6QX06QXJ00P06QXJ
0P3Kfm/501XJ6P030=_Kf`0J6QX0fm_K0100fm_K00<06QXJ0=_Kf`3Kfm/0403Kfm/00`0J6QX0fm_K
0=_Kf`0>0=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ203Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX50=_Kf`04
01XJ6P3Kfm/06QXJ01XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/06QXJ103Kfm/201XJ6P80fm_K0`0J6QX3
0=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3Kfm/201XJ6P80fm_K
00T06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00P0J6QX20=_Kf`806QXJ1`3Kfm/2
01XJ6P040=_Kf`0J6QX06QXJ01XJ6P@0fm_K00@06QXJ0=_Kf`0J6QX06QXJ203Kfm/00`0J6QX0fm_K
0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ6P0J6QX09P0J6QX00`3Kfm/06QXJ
01XJ6P0/01XJ6PH0fm_KY`0J6QX001<06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ
01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K00H0fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0fm_K
0=_Kf`0@0=_Kf`0301XJ6P3Kfm/0fm_K0140fm_K0P0J6QX>0=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K
00<06QXJ0=_Kf`3Kfm/00P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX50=_Kf`0401XJ6P3Kfm/06QXJ01XJ
6P80fm_K00<06QXJ0=_Kf`3Kfm/01@3Kfm/201XJ6P80fm_K0`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K
0080fm_K0P0J6QX0103Kfm/06QXJ01XJ6P0J6QX30=_Kf`806QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`0J
6QX30=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/01@3Kfm/201XJ6P040=_K
f`0J6QX06QXJ01XJ6P@0fm_K00@06QXJ0=_Kf`0J6QX06QXJ203Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ6P0J6QX09P0J6QX20=_Kfc<06QXJ103Kfm^S01XJ
6P00500J6QX20=_Kf`X06QXJ0`3Kfm/401XJ6PT0fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0
fm_K0=_Kf`0@0=_Kf`0301XJ6P3Kfm/0fm_K0180fm_K00<06QXJ0=_Kf`3Kfm/0303Kfm/00`0J6QX0
fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00D0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/0100J6QX0
fm_K0=_Kf`0J6QX:0=_Kf`806QXJ0P3Kfm/301XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ
6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K0P0J6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@0
6QXJ0=_Kf`0J6QX06QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`050=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0
6QXJ103Kfm/00`0J6QX0fm_K01XJ6P090=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3K
fm/00P0J6QX00`3Kfm/06QXJ01XJ6P0V01XJ6P030=_Kf`0J6QX06QXJ03D06QXJ1`3Kfm^M01XJ6P00
9`0J6QX00`3Kfm/06QXJ0=_Kf`060=_Kf`0301XJ6P3Kfm/0fm_K01X0fm_K00<06QXJ0=_Kf`3Kfm/0
4P3Kfm/00`0J6QX0fm_K0=_Kf`0I0=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00@06QXJ0=_Kf`3Kfm/0
6QXJ2P3Kfm/0100J6QX0fm_K0=_Kf`3Kfm/301XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ
6P030=_Kf`0J6QX0fm_K00@0fm_K0P0J6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@06QXJ
0=_Kf`0J6QX06QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`050=_Kf`806QXJ00@0fm_K01XJ6P0J6QX06QXJ
103Kfm/00`0J6QX0fm_K01XJ6P0>0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K:00J6QX00`3Kfm/0
6QXJ01XJ6P0A01XJ6PD0fm_K0P0J6QX20=_Kf`@06QXJ0P3Kfm/=01XJ6P@0fm_K0`0J6QX20=_Kf`@0
6QXJ1`3Kfm/801XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/?01XJ6P<0fm_K0P0J6QX20=_Kf`@0
6QXJ0P3Kfm/>01XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/<01XJ6P<0fm_K100J6QX20=_Kf`@0
6QXJ0P3Kfm/?01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/401XJ6P80fm_K4`0J6QX002L06QXJ
00<0fm_K01XJ6P3Kfm/01P3Kfm/00`0J6QX0fm_K0=_Kf`0J0=_Kf`0301XJ6P3Kfm/0fm_K0180fm_K
00<06QXJ0=_Kf`3Kfm/06@3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PX0
fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX80=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PD0fm_K00<06QXJ
0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`806QXJ2`3Kfm/00`0J6QX0fm_K0=_Kf`07
0=_Kf`0301XJ6P3Kfm/06QXJ00h0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/X01XJ6P030=_Kf`0J6QX0
6QXJ01<06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040=_Kf`0J6QX06QXJ0=_Kf`80
6QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX60=_Kf`0501XJ6P3Kfm/06QXJ01XJ6P3Kfm/00P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`l06QXJ00@0fm_K01XJ6P0J6QX0
fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00@0fm_K01XJ
6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`/06QXJ
00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`h06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX0400J6QX002L06QXJ1`3Kfm/00`0J6QX0fm_K01XJ6P0T0=_Kf`0301XJ6P3K
fm/0fm_K02H0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX:0=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K0P0J6QX90=_Kf`0301XJ6P3Kfm/0fm_K00L0fm_K00<06QXJ0=_Kf`3Kfm/0
203Kfm/201XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/201XJ6PH0fm_K00<06QXJ0=_Kf`3Kfm/0
303Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_KfbP06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX01@3Kfm/0
6QXJ01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0;
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/901XJ6PT0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00X0
6QXJ1@3Kfm/01@0J6QX0fm_K01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K3`0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0
2@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ
6P0J6QX0fm_K3P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K
0P0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P009`0J6QX00`3Kfm/06QXJ0=_Kf`040=_Kf`0301XJ6P3K
fm/06QXJ02@0fm_K00<06QXJ0=_Kf`3Kfm/09P3Kfm/00`0J6QX0fm_K0=_Kf`0A0=_Kf`0301XJ6P3K
fm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/04P3Kfm/00`0J6QX0fm_K0=_Kf`090=_Kf`0501XJ6P3K
fm/0fm_K0=_Kf`0J6QX02`3Kfm/201XJ6QD0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/X01XJ6P03
0=_Kf`0J6QX06QXJ01<06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0300J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0
fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P030=_Kf`0J6QX0fm_K00X0fm_K
300J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ
6P0J6QX0fm_K3@0J6QX20=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/;01XJ6P<0fm_K0`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_K
f`l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J
6QX06QXJ01006QXJ000W01XJ6P030=_Kf`0J6QX0fm_K00@0fm_K00<06QXJ0=_Kf`0J6QX0IP3Kfm/0
0`0J6QX0fm_K0=_Kf`0:0=_Kf`0301XJ6P3Kfm/0fm_K00D0fm_K00<06QXJ0=_Kf`3Kfm/06@3Kfm/2
01XJ6QP0fm_K00<06QXJ0=_Kf`3Kfm/0:00J6QX20=_Kfa@06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX02P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K2`0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0
2@3Kfm/501XJ6P030=_Kf`0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/=01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/<01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K
0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/<01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ
6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/B01XJ6P009`0J6QX30=_Kf`0701XJ6P3Kfm/0
fm_K0=_Kf`0J6QX0fm_K01XJ6P070=_Kf`0301XJ6P3Kfm/0fm_K01X0fm_K00<06QXJ0=_Kf`3Kfm/0
C03Kfm/00`0J6QX0fm_K0=_Kf`050=_Kf`0301XJ6P3Kfm/0fm_K01X0fm_K00<06QXJ0=_Kf`3Kfm/0
5P3Kfm/00`0J6QX0fm_K0=_Kf`0X01XJ6P030=_Kf`0J6QX06QXJ01806QXJ0P3Kfm/401XJ6P80fm_K
100J6QX20=_Kf`h06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kf`d06QXJ0P3Kfm/401XJ6P80fm_K
100J6QX20=_Kf`T06QXJ203Kfm/301XJ6P80fm_K100J6QX20=_Kf`h06QXJ0`3Kfm/301XJ6P80fm_K
100J6QX20=_Kf`d06QXJ0`3Kfm/301XJ6P80fm_K100J6QX20=_Kf`d06QXJ103Kfm/301XJ6P80fm_K
100J6QX20=_Kfa<06QXJ000W01XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0
1`3Kfm/201XJ6TH0fm_K00<06QXJ0=_Kf`3Kfm/09`3Kfm/00`0J6QX0fm_K01XJ6P0G0=_Kf`0301XJ
6P3Kfm/0fm_K01h0fm_K:00J6QX00`3Kfm/06QXJ01XJ6P1V01XJ6PP0fm_KJ`0J6QX002L06QXJ00@0
fm_K01XJ6P3Kfm/06QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P070=_Kf`806QXJ1@3Kfm/00`0J6QX0fm_K
0=_Kf`0C0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PL0fm_K00<06QXJ0=_Kf`3Kfm/0703Kfm/201XJ6PD0
fm_K00@06QXJ0=_Kf`3Kfm/06QXJ103Kfm/00`0J6QX0fm_K0=_Kf`0C0=_Kf`0301XJ6P3Kfm/0fm_K
00<0fm_K00<06QXJ0=_Kf`0J6QX03`3Kfm/00`0J6QX0fm_K0=_Kf`0S0=_Kf`0301XJ6P3Kfm/0fm_K
02P06QXJ00<0fm_K01XJ6P0J6QX0K@0J6QX:0=_Kff806QXJ000W01XJ6P<0fm_K00@06QXJ0=_Kf`3K
fm/0fm_K0`0J6QX70=_Kf`806QXJ1@3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K
00h0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1`3Kfm/00`0J6QX0fm_K0=_Kf`0F0=_Kf`0301XJ6P3Kfm/0
fm_K00<0fm_K0P0J6QX50=_Kf`0601XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K
0=_Kf`0C0=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K
0=_Kf`090=_Kf`0301XJ6P3Kfm/0fm_K02<0fm_K00<06QXJ0=_Kf`3Kfm/0:00J6QX00`3Kfm/06QXJ
01XJ6P1g01XJ6PP0fm_KFP0J6QX002L06QXJ00@0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/301XJ6P<0fm_K
00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX50=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3K
fm/03P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX02@3Kfm/0
0`0J6QX0fm_K0=_Kf`0<0=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K0P0J6QX50=_Kf`0601XJ6P3Kfm/0
fm_K01XJ6P3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0I0=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P80
fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/00`0J6QX0fm_K0=_Kf`0S0=_Kf`0301XJ6P3Kfm/0fm_K02P0
6QXJ00<0fm_K01XJ6P0J6QX0O`0J6QX90=_Kfe406QXJ000W01XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0
fm_K0`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ1@3Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`806QXJ3`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX02@3K
fm/201XJ6Pd0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/201XJ6PD0fm_K00H06QXJ0=_Kf`3Kfm/06QXJ
0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K00<06QXJ0=_Kf`3Kfm/03@3Kfm/00`0J6QX0
fm_K0=_Kf`0201XJ6P80fm_K0P0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`3K
fm/08`3Kfm/00`0J6QX0fm_K0=_Kf`0X01XJ6P030=_Kf`0J6QX06QXJ08L06QXJ1P3Kfm]<01XJ6P00
8P0J6Q[80=_Kfal06QXJd`3Kfm/=01XJ6P009`0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`<06QXJ
0`3Kfm/00`0J6QX0fm_K0=_Kf`0301XJ6PD0fm_K0P0J6QX30=_Kf`806QXJ203Kfm/01@0J6QX0fm_K
0=_Kf`3Kfm/06QXJ0080fm_K00<06QXJ0=_Kf`3Kfm/00P0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00P0
fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0;0=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00D06QXJ0=_K
f`3Kfm/0fm_K01XJ6P050=_Kf`0601XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K
0=_Kf`0K0=_Kf`806QXJ0P3Kfm/201XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/0;03Kfm/201XJ6P030=_K
f`0J6QX06QXJ02<06QXJ00<0fm_K01XJ6P0J6QX06@0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030=_K
f`0J6QX06QXJ01P06QXJ00<0fm_K01XJ6P0J6QX06@0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030=_K
f`0J6QX06QXJ00T06QXJ1@3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0fm_K01XJ6P0J6QX0
5`0J6QX002L06QXJ00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/401XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0
0`0J6QX30=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P<0fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`050=_Kf`80
6QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`806QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/0
6QXJ00H0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0;0=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`806QXJ0P3K
fm/201XJ6PD0fm_K00H06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00P0
fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/00`0J6QX0fm_K0=_Kf`0:0=_Kf`806QXJ0P3Kfm/201XJ6P@0
fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0T0=_Kf`0301XJ6P3Kfm/0fm_K02P0
6QXJ00<0fm_K01XJ6P0J6QX0V00J6QX50=_Kfc`06QXJ000W01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0
100J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00<06QXJ0`3Kfm/0100J6QX0fm_K01XJ6P0J6QX30=_Kf`80
6QXJ00<0fm_K01XJ6P3Kfm/01@3Kfm/201XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/201XJ
6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K
01XJ6P0J6QX02`3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P80fm_K0P0J6QX50=_Kf`0301XJ6P3K
fm/0fm_K00<06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`080=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<0
6QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6P80fm_K0P0J6QX40=_Kf`0301XJ6P3K
fm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0303Kfm/00`0J6QX0fm_K0=_Kf`0E0=_Kf`0301XJ6P3K
fm/0fm_K02P06QXJ00<0fm_K01XJ6P0J6QX0W00J6QX70=_KfcH06QXJ000W01XJ6P050=_Kf`0J6QX0
fm_K01XJ6P3Kfm/01P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00<06QXJ0`3Kfm/01`0J6QX0fm_K01XJ
6P0J6QX0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/06QXJ01XJ6P030=_Kf`806QXJ0P3Kfm/0100J6QX0
fm_K0=_Kf`0J6QX20=_Kf`806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K0080fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P070=_Kf`0801XJ6P3Kfm/0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/201XJ6P80fm_K
0P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/201XJ6P80fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0:0=_Kf`80
6QXJ103Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`806QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6P80
fm_K0P0J6QX40=_Kf`0601XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ2`3Kfm/0100J6QX0fm_K0=_Kf`0J
6QX80=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/0:00J6QX00`3Kfm/06QXJ01XJ
6P2R01XJ6PD0fm_K<P0J6QX002L06QXJ00<0fm_K01XJ6P3Kfm/0200J6QX20=_Kf`0301XJ6P3Kfm/0
fm_K00<06QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX0fm_K00@06QXJ00<0
fm_K01XJ6P0J6QX00`3Kfm/201XJ6P80fm_K0P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/201XJ6P80fm_K
0`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/901XJ6P030=_Kf`0J6QX0fm_K00@0fm_K00P06QXJ0=_Kf`3K
fm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`806QXJ00H0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX20=_Kf`80
6QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00X0fm_K0P0J6QX40=_Kf`0601XJ6P3Kfm/0fm_K0=_K
f`0J6QX0fm_K0P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00@0fm_K01XJ6P0J6QX06QXJ103K
fm/01P0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P/0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ203Kfm/00`0J
6QX0fm_K0=_Kf`0<0=_Kf`0301XJ6P3Kfm/0fm_K02P06QXJ00<0fm_K01XJ6P0J6QX0YP0J6QX50=_K
fbh06QXJ000W01XJ6P<0fm_K200J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00D06QXJ00<0fm_K01XJ6P3K
fm/00P0J6QX00`3Kfm/06QXJ0=_Kf`0401XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX20=_K
f`806QXJ00@0fm_K01XJ6P3Kfm/0fm_K0P0J6QX20=_Kf`D06QXJ0P3Kfm/901XJ6P030=_Kf`0J6QX0
fm_K00<0fm_K0P0J6QX30=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00`0J
6QX20=_Kf`806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00X0fm_K0P0J6QX40=_Kf`0601XJ6P3K
fm/0fm_K0=_Kf`0J6QX0fm_K0P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00@0fm_K01XJ6P0J
6QX06QXJ103Kfm/01P0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P/0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ
203Kfm/00`0J6QX0fm_K0=_Kf`0<0=_Kf`0301XJ6P3Kfm/0fm_K02P06QXJ0P3Kfm^/01XJ6P@0fm_K
:P0J6QX002L06QXJ00<0fm_K01XJ6P3Kfm/0200J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00D06QXJ00<0
fm_K01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K
0P0J6QX20=_Kf`806QXJ00@0fm_K01XJ6P3Kfm/0fm_K0P0J6QX20=_Kf`D06QXJ0P3Kfm/901XJ6P05
0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX30=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_K
f`806QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00T0fm_K100J6QX20=_Kf`806QXJ0`3Kfm/0100J
6QX0fm_K01XJ6P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3K
fm/201XJ6P80fm_K00<06QXJ0=_Kf`0J6QX02P3Kfm/201XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/06QXJ
0`3Kfm/00`0J6QX0fm_K01XJ6P0>0=_Kf`0301XJ6P3Kfm/06QXJ02P06QXJ00<0fm_K01XJ6P0J6QX0
[P0J6QX30=_KfbP06QXJ000W01XJ6P030=_Kf`0J6QX0fm_K00P06QXJ0P3Kfm/00`0J6QX0fm_K0=_K
f`0501XJ6P030=_Kf`0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX0100J6QX0103Kfm/06QXJ01XJ
6P0J6QX20=_Kf`806QXJ0P3Kfm/401XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P80fm_K
2@0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00<06QXJ0`3Kfm/601XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ0P3Kfm/201XJ6P80fm_K0`0J6QX01P3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6PH0fm_K100J6QX2
0=_Kf`806QXJ0`3Kfm/0100J6QX0fm_K01XJ6P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00@0
fm_K01XJ6P0J6QX06QXJ0`3Kfm/201XJ6P80fm_K00<06QXJ0=_Kf`0J6QX02P3Kfm/301XJ6P050=_K
f`0J6QX0fm_K0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00T0
fm_K00<06QXJ0=_Kf`0J6QX0:00J6QX00`3Kfm/06QXJ01XJ6P2`01XJ6P<0fm_K9P0J6QX002L06QXJ
00<0fm_K01XJ6P3Kfm/0200J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00D06QXJ00<0fm_K01XJ6P3Kfm/0
0P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0`0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01P0J6QX20=_Kf`T06QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0301XJ6P<0fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K0P0J6QX2
0=_Kf`<06QXJ00H0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX60=_Kf`@06QXJ0P3Kfm/201XJ6P<0fm_K
100J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3Kfm/201XJ6P80
fm_K00<06QXJ0=_Kf`0J6QX02P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ0`3Kfm/00`0J6QX0
fm_K01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00/0fm_K:@0J6QX00`3Kfm/06QXJ01XJ6P2b01XJ6PD0
fm_K8P0J6QX002L06QXJ0`3Kfm/801XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/01@0J6QX00`3Kfm/06QXJ
0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/301XJ6P03
0=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0A01XJ6P050=_Kf`0J6QX06QXJ
01XJ6P3Kfm/00`0J6QX30=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ01XJ6P0J
6QX20=_Kf`T06QXJ00<0fm_K01XJ6P3Kfm/00`3Kfm/401XJ6P80fm_K0`0J6QX20=_Kf`@06QXJ00<0
fm_K01XJ6P0J6QX00P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K0P0J6QX20=_Kf`0301XJ
6P3Kfm/06QXJ00X0fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0
0P3Kfm/00`0J6QX0fm_K0=_Kf`0;0=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0]P0J6QX40=_Kfal06QXJ
000W01XJ6P030=_Kf`0J6QX0fm_K00P06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0501XJ6P030=_Kf`0J
6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX0100J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`<06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K01406QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0301XJ6P<0fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040=_Kf`0J6QX06QXJ
01XJ6P80fm_K2@0J6QX00`3Kfm/06QXJ0=_Kf`030=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX2
0=_Kf`L06QXJ0P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K0P0J6QX20=_Kf`0501XJ6P3K
fm/06QXJ0=_Kf`0J6QX0203Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ0`3Kfm/00`0J6QX0fm_K
01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00/0fm_K:@0J6QX00`3Kfm/06QXJ01XJ6P2i01XJ6P80fm_K
7P0J6QX002L06QXJ00<0fm_K01XJ6P3Kfm/02@0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/501XJ6P030=_K
f`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0100J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`<0
6QXJ00<0fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K01406QXJ00<0fm_K01XJ
6P0J6QX01P0J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ01XJ6P0J6QX2
0=_Kf`T06QXJ00<0fm_K01XJ6P3Kfm/00`3Kfm/401XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/7
01XJ6P80fm_K0P0J6QX0103Kfm/06QXJ01XJ6P0J6QX30=_Kf`806QXJ0P3Kfm/01@0J6QX0fm_K01XJ
6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ
0`3Kfm/01P0J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6PH0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/Y01XJ
6P80fm_K_00J6QX20=_Kfa`06QXJ000W01XJ6P<0fm_K2@0J6QX00`3Kfm/06QXJ0=_Kf`0;01XJ6P03
0=_Kf`0J6QX06QXJ00P06QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0A01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ
00<06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/901XJ6P030=_Kf`0J6QX0fm_K00<0fm_K100J6QX0
0`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K1`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P<0fm_K0P0J6QX0
1`3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`<06QXJ
00<0fm_K01XJ6P3Kfm/00P0J6QX30=_Kf`0601XJ6P3Kfm/06QXJ01XJ6P3Kfm/06QXJ1P3Kfm/00`0J
6QX0fm_K0=_Kf`040=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0_00J6QX20=_Kfa/06QXJ000C01XJ6P@0
fm_K0`0J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX0fm_K00T06QXJ00<0fm_K01XJ6P3K
fm/05P0J6QX20=_Kf`P06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0A01XJ6P030=_Kf`0J6QX06QXJ
00H06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040=_Kf`0J6QX06QXJ
01XJ6P80fm_K2@0J6QX00`3Kfm/06QXJ0=_Kf`030=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX2
0=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX30=_Kf`L06QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/0
0`0J6QX0fm_K0=_Kf`020=_Kf`<06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX0fm_K00806QXJ00<0fm_K01XJ6P3Kfm/01@3Kfm/00`0J6QX0fm_K0=_Kf`040=_KfbT06QXJ00<0
fm_K01XJ6P0J6QX0_@0J6QX20=_KfaX06QXJ000C01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00@0fm_K
01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ0=_Kf`0901XJ6P030=_Kf`0J6QX0fm_K01H06QXJ0P3K
fm/<01XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ
6P0501XJ6P030=_Kf`0J6QX06QXJ00L06QXJ0P3Kfm/901XJ6P040=_Kf`0J6QX0fm_K0=_Kf`H06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P<0fm_K1`0J6QX00`3Kfm/06QXJ
0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P050=_K
f`0J6QX06QXJ01XJ6P3Kfm/0100J6QX40=_Kf`0301XJ6P3Kfm/06QXJ00H0fm_K:@0J6QX00`3Kfm/0
6QXJ01XJ6P2n01XJ6P80fm_K6@0J6QX001@06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P<0fm_K2@0J6QX00`3Kfm/06QXJ0=_Kf`0F01XJ6P80fm_K300J6QX00`3Kfm/06QXJ
01XJ6P0?01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ
01XJ6P0701XJ6P80fm_K300J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00<0fm_K01XJ6P0J6QX03P0J6QX30=_Kf`L06QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/00`0J6QX0fm_K
0=_Kf`020=_Kf`<06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00@0
6QXJ103Kfm/301XJ6PH0fm_K:@0J6QX00`3Kfm/06QXJ01XJ6P2o01XJ6P80fm_K600J6QX001D06QXJ
00<0fm_K01XJ6P0J6QX0200J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P3Kfm/02@0J6QX00`3Kfm/06QXJ
0=_Kf`0F01XJ6P80fm_K300J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ
00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K4`0J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00h06QXJ0`3Kfm/701XJ6P030=_Kf`0J6QX06QXJ0080fm_K
00<06QXJ0=_Kf`3Kfm/00P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ00D0fm_K01XJ6P0J6QX0
6QXJ0=_Kf`0401XJ6P@0fm_K0`0J6QX60=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0`00J6QX00`3Kfm/0
6QXJ01XJ6P0F01XJ6P004`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ00@0
6QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0D01XJ6P80fm_K7P0J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/0
6QXJ01XJ6P0G01XJ6P030=_Kf`0J6QX06QXJ00h06QXJ0`3Kfm/701XJ6P040=_Kf`0J6QX06QXJ0=_K
f`806QXJ103Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`04
01XJ6P@0fm_K0`0J6QX60=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0`@0J6QX00`3Kfm/06QXJ01XJ6P0E
01XJ6P00500J6QX20=_Kf`X06QXJ0`3Kfm/401XJ6P80fm_K300J6QX00`3Kfm/06QXJ01XJ6P0D01XJ
6P030=_Kf`0J6QX06QXJ01d06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ
6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ
6P<0fm_K1`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K00<06QXJ00<0fm_K01XJ
6P3Kfm/00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00@06QXJ103Kfm/301XJ6PH0fm_K:@0J6QX2
0=_Kfl<06QXJ00<0fm_K01XJ6P0J6QX0500J6QX002L06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3K
fm/06QXJ01XJ6P0D01XJ6P030=_Kf`0J6QX06QXJ01d06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3K
fm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX00`3K
fm/06QXJ01XJ6P0>01XJ6P<0fm_K1`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K
00<06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00@06QXJ103Kfm/4
01XJ6PD0fm_K:@0J6QX00`3Kfm/06QXJ01XJ6P3201XJ6P030=_Kf`0J6QX06QXJ01@06QXJ000W01XJ
6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`3Kfm/06QXJ01XJ6P0V01XJ
6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ
6P030=_Kf`0J6QX06QXJ00h06QXJ0`3Kfm/701XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ
6P3Kfm/00`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00H06QXJ0`3Kfm/501XJ
6P80fm_K00<06QXJ0=_Kf`3Kfm/0:@0J6QX00`3Kfm/06QXJ01XJ6P3301XJ6P030=_Kf`0J6QX06QXJ
01<06QXJ000W01XJ6P80fm_K300J6QX00`3Kfm/06QXJ01XJ6P0D01XJ6P030=_Kf`0J6QX06QXJ02h0
6QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0Z01XJ6P030=_Kf`0J6QX06QXJ00`0
6QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00H0
6QXJ0`3Kfm/501XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/0:@0J6QX00`3Kfm/06QXJ01XJ6P3301XJ6P03
0=_Kf`0J6QX06QXJ01<06QXJ000W01XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0
500J6QX00`3Kfm/06QXJ01XJ6P0h01XJ6P030=_Kf`0J6QX06QXJ02X06QXJ00<0fm_K01XJ6P0J6QX0
300J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0fm_K00/06QXJ0`3Kfm/501XJ6P80fm_K
00<06QXJ0=_Kf`3Kfm/0:@0J6QX00`3Kfm/06QXJ01XJ6P3301XJ6P030=_Kf`0J6QX06QXJ01<06QXJ
000W01XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0C`0J6QX00`3Kfm/06QXJ01XJ
6P0Z01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ0=_K
f`0;01XJ6P80fm_K1`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/Y01XJ6P030=_Kf`0J6QX06QXJ0<<06QXJ
0P3Kfm/D01XJ6P009`0J6QX20=_Kf``06QXJ00<0fm_K01XJ6P0J6QX0C`0J6QX00`3Kfm/06QXJ01XJ
6P0Z01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ0=_K
f`0;01XJ6P80fm_K1`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/Y01XJ6P80fm_Ka@0J6QX00`3Kfm/06QXJ
01XJ6P0B01XJ6P009`0J6QX00`3Kfm/06QXJ01XJ6P1M01XJ6P030=_Kf`0J6QX06QXJ02X06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX0fm_K00/06QXJ0P3K
fm/701XJ6P040=_Kf`0J6QX0fm_K0=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0a00J6QX00`3Kfm/06QXJ
01XJ6P0B01XJ6P009`0J6QX00`3Kfm/06QXJ01XJ6P1M01XJ6P030=_Kf`0J6QX06QXJ02X06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0
fm_K01XJ6P0J6QX01P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/Y01XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ
00<0fm_K01XJ6P0J6QX04@0J6QX002L06QXJ0P3Kfm]N01XJ6P030=_Kf`0J6QX06QXJ02X06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0
fm_K01XJ6P0J6QX01P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/Y01XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ
00<0fm_K01XJ6P0J6QX04@0J6QX002006QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ08X06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0
fm_K01XJ6P0J6QX01P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/S01XJ6P80fm_K100J6QX00`3Kfm/06QXJ
01XJ6P3501XJ6P030=_Kf`0J6QX06QXJ01406QXJ000O01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ
00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P80fm_K8P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX002806QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kfh/06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ
01XJ6P0T01XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_Ka@0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P00
800J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_K
f`0J6QX06QXJ02806QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX0
4@0J6QX002006QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J
6QX06QXJ01806QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J
6QX06QXJ02806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3501XJ6P030=_Kf`0J
6QX06QXJ01406QXJ000P01XJ6P<0fm_K100J6QX20=_Kfh/06QXJ00<0fm_K01XJ6P0J6QX04P0J6QX0
0`3Kfm/06QXJ01XJ6P0;01XJ6P030=_Kf`0J6QX06QXJ02d06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX0
6QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3K
fm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX002L0
6QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<D0
6QXJ00<0fm_K01XJ6P0J6QX04@0J6QX002L06QXJ0P3Kfm^;01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ
00<0fm_K01XJ6P0J6QX0a@0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P009`0J6QX00`3Kfm/06QXJ01XJ
6P2:01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ0P3Kfm_601XJ6P030=_Kf`0J6QX06QXJ01406QXJ000W
01XJ6P030=_Kf`0J6QX06QXJ08X06QXJ00<0fm_K01XJ6P0J6QX0EP0J6QX00`3Kfm/06QXJ01XJ6P35
01XJ6P030=_Kf`0J6QX06QXJ01406QXJ000W01XJ6P030=_Kf`0J6QX06QXJ08X06QXJ00<0fm_K01XJ
6P0J6QX0EP0J6QX00`3Kfm/06QXJ01XJ6P3501XJ6P030=_Kf`0J6QX06QXJ01406QXJ000W01XJ6P80
fm_KR`0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J
6QX04@0J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_K
f`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0RP0J
6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<D06QXJ00<0fm_K01XJ6P0J6QX04@0J
6QX002L06QXJ0P3Kfm^;01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ0P3Kfm_601XJ6P030=_Kf`0J6QX0
6QXJ01406QXJ000E01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0a@0J6QX20=_K
fa806QXJ000E01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX00`3K
fm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3K
fm/06QXJ01XJ6P0@01XJ6P005@0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ0P3Kfm^;01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/0
6QXJ01XJ6P0@01XJ6P005P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ
01XJ6P2:01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/06QXJ
01XJ6P0@01XJ6P004`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<H06QXJ
00<0fm_K01XJ6P0J6QX0400J6QX001<06QXJ103Kfm/901XJ6P<0fm_K100J6QX20=_Kfh/06QXJ00<0
fm_K01XJ6P0J6QX0EP0J6QX20=_KflL06QXJ00<0fm_K01XJ6P0J6QX0400J6QX002L06QXJ00<0fm_K
01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<H06QXJ00<0fm_K
01XJ6P0J6QX0400J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P1F01XJ
6P030=_Kf`0J6QX06QXJ0<H06QXJ00<0fm_K01XJ6P0J6QX0400J6QX002L06QXJ0P3Kfm^;01XJ6P03
0=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P00
9`0J6QX00`3Kfm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0
aP0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P009`0J6QX00`3Kfm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J
6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P009`0J6QX2
0=_Kfh/06QXJ00<0fm_K01XJ6P0J6QX0EP0J6QX00`3Kfm/06QXJ01XJ6P3601XJ6P030=_Kf`0J6QX0
6QXJ01006QXJ000W01XJ6P030=_Kf`0J6QX06QXJ08X06QXJ00<0fm_K01XJ6P0J6QX0EP0J6QX20=_K
flL06QXJ00<0fm_K01XJ6P0J6QX0400J6QX002L06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/0
6QXJ01XJ6P1F01XJ6P030=_Kf`0J6QX06QXJ0<H06QXJ00<0fm_K01XJ6P0J6QX0400J6QX002L06QXJ
0P3Kfm^;01XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/06QXJ
01XJ6P0@01XJ6P006@0J6QX50=_Kf`806QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ08X06QXJ00<0
fm_K01XJ6P0J6QX0EP0J6QX00`3Kfm/06QXJ01XJ6P3601XJ6P030=_Kf`0J6QX06QXJ01006QXJ000K
01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J
6QX06QXJ08X06QXJ00<0fm_K01XJ6P0J6QX0B@0J6QX50=_Kf`806QXJ0P3Kfm/401XJ6P030=_Kf`0J
6QX06QXJ0<H06QXJ00<0fm_K01XJ6P0J6QX0400J6QX001/06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`0201XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm^;01XJ6P030=_Kf`0J6QX06QXJ04/06QXJ00D0
fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0b00J6QX00`3Kfm/0
6QXJ01XJ6P0@01XJ6P006`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J
6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2:01XJ6P030=_Kf`0J6QX06QXJ04/06QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_KaP0J6QX00`3Kfm/06QXJ01XJ6P0@
01XJ6P006`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX00P0J6QX0
0`3Kfm/06QXJ01XJ6P3H01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K0<P06QXJ00<0fm_K01XJ6P0J6QX0400J6QX001X06QXJ0P3Kfm/401XJ6P80fm_K1@0J
6QX20=_KfmT06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3K
fm/0b00J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P009`0J6QX00`3Kfm/06QXJ01XJ6P3G01XJ6P80fm_K
100J6QX20=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX0aP0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P00o`0J
6QX>01XJ6P030=_Kf`0J6QX06QXJ0<H06QXJ00<0fm_K01XJ6P0J6QX0400J6QX00?l06QXJ3P0J6QX0
0`3Kfm/06QXJ01XJ6P3I01XJ6P00o`0J6QX>01XJ6P030=_Kf`0J6QX06QXJ0=T06QXJ003o01XJ6Ph0
6QXJ0P3Kfm_J01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ
6P00o`0J6Q[Z01XJ6P00o`0J6Q[Z01XJ6P00\
\>"],
  ImageRangeCache->{{{66.625, 457.375}, {307.875, 193.625}} -> {-0.417291, \
1.0327, 0.00432761, 0.00432761}, {{77.125, 253.188}, {305.125, 196.313}} -> \
{-472.962, 28.3903, 3.8489, 0.161953}, {{270.75, 446.813}, {305.125, \
196.313}} -> {-1280.54, 27.7561, 3.62693, 0.157786}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Transpose[{Y, X}], \ PlotJoined \[Rule] False] // 
        fShow;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.459016 0.04879 0.286882 0.031176 [
[.21507 .27438 -6 -9 ]
[.21507 .27438 6 0 ]
[.70297 .27438 -3 -9 ]
[.70297 .27438 3 0 ]
[.94692 .27438 -6 -9 ]
[.94692 .27438 6 0 ]
[.44652 .05306 -24 -4.5 ]
[.44652 .05306 0 4.5 ]
[.44652 .131 -12 -4.5 ]
[.44652 .131 0 4.5 ]
[.44652 .20894 -24 -4.5 ]
[.44652 .20894 0 4.5 ]
[.44652 .36482 -18 -4.5 ]
[.44652 .36482 0 4.5 ]
[.44652 .44276 -6 -4.5 ]
[.44652 .44276 0 4.5 ]
[.44652 .5207 -18 -4.5 ]
[.44652 .5207 0 4.5 ]
[.44652 .59864 -12 -4.5 ]
[.44652 .59864 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21507 .28688 m
.21507 .29313 L
s
[(-5)] .21507 .27438 0 1 Mshowa
.70297 .28688 m
.70297 .29313 L
s
[(5)] .70297 .27438 0 1 Mshowa
.94692 .28688 m
.94692 .29313 L
s
[(10)] .94692 .27438 0 1 Mshowa
.125 Mabswid
.26386 .28688 m
.26386 .29063 L
s
.31265 .28688 m
.31265 .29063 L
s
.36144 .28688 m
.36144 .29063 L
s
.41023 .28688 m
.41023 .29063 L
s
.50781 .28688 m
.50781 .29063 L
s
.5566 .28688 m
.5566 .29063 L
s
.60539 .28688 m
.60539 .29063 L
s
.65418 .28688 m
.65418 .29063 L
s
.75176 .28688 m
.75176 .29063 L
s
.80055 .28688 m
.80055 .29063 L
s
.84934 .28688 m
.84934 .29063 L
s
.89813 .28688 m
.89813 .29063 L
s
.16628 .28688 m
.16628 .29063 L
s
.11749 .28688 m
.11749 .29063 L
s
.0687 .28688 m
.0687 .29063 L
s
.01991 .28688 m
.01991 .29063 L
s
.99571 .28688 m
.99571 .29063 L
s
.25 Mabswid
0 .28688 m
1 .28688 L
s
.45902 .05306 m
.46527 .05306 L
s
[(-7.5)] .44652 .05306 1 0 Mshowa
.45902 .131 m
.46527 .131 L
s
[(-5)] .44652 .131 1 0 Mshowa
.45902 .20894 m
.46527 .20894 L
s
[(-2.5)] .44652 .20894 1 0 Mshowa
.45902 .36482 m
.46527 .36482 L
s
[(2.5)] .44652 .36482 1 0 Mshowa
.45902 .44276 m
.46527 .44276 L
s
[(5)] .44652 .44276 1 0 Mshowa
.45902 .5207 m
.46527 .5207 L
s
[(7.5)] .44652 .5207 1 0 Mshowa
.45902 .59864 m
.46527 .59864 L
s
[(10)] .44652 .59864 1 0 Mshowa
.125 Mabswid
.45902 .06865 m
.46277 .06865 L
s
.45902 .08424 m
.46277 .08424 L
s
.45902 .09983 m
.46277 .09983 L
s
.45902 .11541 m
.46277 .11541 L
s
.45902 .14659 m
.46277 .14659 L
s
.45902 .16218 m
.46277 .16218 L
s
.45902 .17777 m
.46277 .17777 L
s
.45902 .19335 m
.46277 .19335 L
s
.45902 .22453 m
.46277 .22453 L
s
.45902 .24012 m
.46277 .24012 L
s
.45902 .25571 m
.46277 .25571 L
s
.45902 .27129 m
.46277 .27129 L
s
.45902 .30247 m
.46277 .30247 L
s
.45902 .31806 m
.46277 .31806 L
s
.45902 .33365 m
.46277 .33365 L
s
.45902 .34923 m
.46277 .34923 L
s
.45902 .38041 m
.46277 .38041 L
s
.45902 .396 m
.46277 .396 L
s
.45902 .41159 m
.46277 .41159 L
s
.45902 .42717 m
.46277 .42717 L
s
.45902 .45835 m
.46277 .45835 L
s
.45902 .47394 m
.46277 .47394 L
s
.45902 .48953 m
.46277 .48953 L
s
.45902 .50511 m
.46277 .50511 L
s
.45902 .53629 m
.46277 .53629 L
s
.45902 .55188 m
.46277 .55188 L
s
.45902 .56747 m
.46277 .56747 L
s
.45902 .58305 m
.46277 .58305 L
s
.45902 .03747 m
.46277 .03747 L
s
.45902 .02189 m
.46277 .02189 L
s
.45902 .0063 m
.46277 .0063 L
s
.45902 .61423 m
.46277 .61423 L
s
.25 Mabswid
.45902 0 m
.45902 .61803 L
s
.008 w
.02381 .06958 Mdot
.02966 .09266 Mdot
.05162 .11136 Mdot
.06821 .0197 Mdot
.09699 .13942 Mdot
.10968 .09764 Mdot
.13505 .07644 Mdot
.14188 .28595 Mdot
.15554 .21393 Mdot
.15554 .37355 Mdot
.15603 .13256 Mdot
.15652 .09764 Mdot
.17603 .16997 Mdot
.17799 .14347 Mdot
.18091 .30434 Mdot
.18921 .14285 Mdot
.19067 .12103 Mdot
.19116 .14378 Mdot
.19165 .24479 Mdot
.19262 .13724 Mdot
.19409 .29811 Mdot
.19897 .28688 Mdot
.19945 .22983 Mdot
.20141 .1547 Mdot
.20336 .1653 Mdot
.20921 .21985 Mdot
.21116 .23513 Mdot
.21409 .16311 Mdot
.21897 .22422 Mdot
.21995 .11947 Mdot
.21995 .1335 Mdot
.22482 .26288 Mdot
.22775 .19522 Mdot
.22873 .21299 Mdot
.22922 .12601 Mdot
.2297 .20177 Mdot
.23165 .18088 Mdot
.23312 .11978 Mdot
.23556 .30278 Mdot
.24044 .18307 Mdot
.24239 .1734 Mdot
.24385 .1865 Mdot
.24434 .1653 Mdot
.24532 .31743 Mdot
.2458 .37168 Mdot
.24678 .17184 Mdot
.24727 .30964 Mdot
.24971 .10856 Mdot
.2502 .16997 Mdot
.25312 .18961 Mdot
.2541 .14347 Mdot
.2541 .27067 Mdot
.25605 .24822 Mdot
.25703 .16966 Mdot
.258 .1522 Mdot
.25849 .41096 Mdot
.26093 .28439 Mdot
.26483 .26475 Mdot
.26678 .23014 Mdot
.26678 .30029 Mdot
.26678 .1229 Mdot
.26776 .2582 Mdot
.2702 .28345 Mdot
.27069 .26724 Mdot
.27069 .16904 Mdot
.27215 .19678 Mdot
.2741 .24885 Mdot
.2741 .25508 Mdot
.27557 .1628 Mdot
.27947 .04464 Mdot
.28093 .17278 Mdot
.28191 .31245 Mdot
.28288 .27691 Mdot
.2863 .22889 Mdot
.28825 .24822 Mdot
.28825 .2741 Mdot
.28923 .30621 Mdot
.28972 .13131 Mdot
.2902 .17808 Mdot
.29215 .25882 Mdot
.29459 .14223 Mdot
.29557 .34799 Mdot
.29655 .34238 Mdot
.29801 .22204 Mdot
.30142 .1893 Mdot
.30191 .29093 Mdot
.30191 .25789 Mdot
.30289 .18182 Mdot
.30289 .343 Mdot
.30533 .29374 Mdot
.30533 .17932 Mdot
.3063 .24511 Mdot
.30777 .22702 Mdot
.30826 .26163 Mdot
.30826 .20582 Mdot
.30874 .28563 Mdot
.30923 .20832 Mdot
.30923 .13848 Mdot
.31069 .22235 Mdot
.31167 .35173 Mdot
.31265 .16935 Mdot
.31265 .20801 Mdot
.31313 .15501 Mdot
.31411 .30278 Mdot
.31411 .25072 Mdot
.31557 .17309 Mdot
.31557 .31806 Mdot
.31606 .18868 Mdot
.31655 .26038 Mdot
.31801 .14846 Mdot
.3185 .21861 Mdot
.3185 .26755 Mdot
.3185 .16872 Mdot
.32094 .20271 Mdot
.32192 .16872 Mdot
.32338 .27722 Mdot
.32484 .2688 Mdot
.32484 .19772 Mdot
.32631 .24822 Mdot
.3268 .30247 Mdot
.3268 .22048 Mdot
.32777 .25228 Mdot
.32777 .27846 Mdot
.32777 .29093 Mdot
.32826 .08361 Mdot
.33021 .18556 Mdot
.33119 .21736 Mdot
.33119 .34736 Mdot
.33167 .14316 Mdot
.33216 .28034 Mdot
.33314 .23108 Mdot
.33363 .30153 Mdot
.33363 .24386 Mdot
.33411 .25539 Mdot
.3346 .26818 Mdot
.3346 .17371 Mdot
.33509 .29592 Mdot
.33509 .31182 Mdot
.33509 .23575 Mdot
.33558 .20084 Mdot
.33558 .31276 Mdot
.33558 .40348 Mdot
.33607 .20551 Mdot
.33607 .2264 Mdot
.33753 .25789 Mdot
.33802 .23949 Mdot
.33851 .26194 Mdot
.33851 .3776 Mdot
.33851 .19585 Mdot
.33851 .09515 Mdot
.33948 .17122 Mdot
.33997 .22266 Mdot
.34094 .20115 Mdot
.34143 .16374 Mdot
.34143 .28813 Mdot
.34192 .21175 Mdot
.3429 .32616 Mdot
.3429 .29093 Mdot
.34338 .12944 Mdot
.34436 .21674 Mdot
.34485 .13599 Mdot
.34582 .25477 Mdot
.3468 .22359 Mdot
.34778 .35266 Mdot
.34826 .07395 Mdot
.34875 .25259 Mdot
.35021 .28345 Mdot
.3507 .25415 Mdot
.35119 .24012 Mdot
.35119 .30496 Mdot
.35168 .17527 Mdot
.35217 .22484 Mdot
.35314 .1865 Mdot
.35314 .32086 Mdot
.35363 .30683 Mdot
.35363 .1335 Mdot
.35363 .22734 Mdot
.35363 .17402 Mdot
.35363 .17465 Mdot
.35412 .28813 Mdot
.35461 .20364 Mdot
.35509 .20832 Mdot
.35558 .35672 Mdot
.35607 .20021 Mdot
.35656 .23762 Mdot
.35705 .32554 Mdot
.35705 .28501 Mdot
.35753 .24136 Mdot
.35802 .18244 Mdot
.35851 .23669 Mdot
.35851 .23731 Mdot
.35997 .21923 Mdot
.36095 .26444 Mdot
.36144 .20021 Mdot
.36144 .36888 Mdot
.36192 .28096 Mdot
.36241 .3112 Mdot
.36339 .24324 Mdot
.36388 .18213 Mdot
.36436 .32086 Mdot
.36534 .31588 Mdot
.36632 .11915 Mdot
.3668 .18431 Mdot
.3668 .24074 Mdot
.3668 .22547 Mdot
.3668 .25165 Mdot
.36729 .28844 Mdot
.36778 .19928 Mdot
.36778 .26163 Mdot
.36827 .30247 Mdot
.36827 .24854 Mdot
.36875 .22702 Mdot
.36924 .21829 Mdot
.37071 .31026 Mdot
.37168 .16467 Mdot
.37168 .23856 Mdot
.37217 .26755 Mdot
.37217 .23419 Mdot
.37217 .23482 Mdot
.37266 .15875 Mdot
.37266 .25134 Mdot
.37363 .26412 Mdot
.37363 .24729 Mdot
.37412 .33022 Mdot
.37461 .22702 Mdot
.3751 .3299 Mdot
.3751 .32086 Mdot
.37559 .23918 Mdot
.37559 .28127 Mdot
.37559 .24105 Mdot
.37607 .25914 Mdot
.37705 .21331 Mdot
.37754 .30341 Mdot
.37754 .22858 Mdot
.37754 .17777 Mdot
.37851 .2953 Mdot
.37851 .20801 Mdot
.379 .20582 Mdot
.379 .25446 Mdot
.379 .30278 Mdot
.37949 .16218 Mdot
.38046 .13131 Mdot
.38144 .25228 Mdot
.38144 .29966 Mdot
.38193 .27753 Mdot
.38193 .28283 Mdot
.38193 .27192 Mdot
.3829 .19585 Mdot
.38388 .22952 Mdot
.38437 .28906 Mdot
.38486 .24043 Mdot
.38583 .19429 Mdot
.38632 .30683 Mdot
.38681 .21144 Mdot
.38681 .23607 Mdot
.3873 .26132 Mdot
.3873 .21299 Mdot
.38778 .26974 Mdot
.38778 .18151 Mdot
.38827 .24854 Mdot
.38827 .24542 Mdot
.38876 .21985 Mdot
.38876 .24511 Mdot
.38973 .31089 Mdot
.38973 .19211 Mdot
.38973 .22172 Mdot
.39022 .38384 Mdot
.39071 .15095 Mdot
.39071 .30465 Mdot
.39071 .2794 Mdot
.39071 .20551 Mdot
.3912 .30309 Mdot
.3912 .28563 Mdot
.39169 .20676 Mdot
.39169 .32772 Mdot
.39217 .07769 Mdot
.39266 .29125 Mdot
.39266 .31743 Mdot
.39364 .24791 Mdot
.39461 .33988 Mdot
.39461 .22796 Mdot
.3951 .18961 Mdot
.39559 .32866 Mdot
.39559 .30933 Mdot
.39559 .26849 Mdot
.39559 .22765 Mdot
.39608 .30871 Mdot
.39657 .14035 Mdot
.39705 .28252 Mdot
.39754 .18026 Mdot
.39754 .27566 Mdot
.39803 .23825 Mdot
.39803 .06647 Mdot
.39803 .25882 Mdot
.39852 .34082 Mdot
.39852 .27535 Mdot
.399 .17247 Mdot
.39949 .19522 Mdot
.39998 .22172 Mdot
.39998 .39132 Mdot
.39998 .21081 Mdot
.40047 .23669 Mdot
.40047 .22921 Mdot
.40052 .25 Mdot
.40096 .35235 Mdot
.40096 .35266 Mdot
.40193 .22204 Mdot
.40193 .11011 Mdot
.40193 .18151 Mdot
.40242 .25196 Mdot
.40291 .30839 Mdot
.40291 .31494 Mdot
.40291 .27379 Mdot
.4031 .25153 Mdot
.40388 .2211 Mdot
.40388 .26444 Mdot
.40388 .20052 Mdot
.40388 .29 Mdot
.40388 .31775 Mdot
.40388 .27036 Mdot
.40388 .1759 Mdot
.40388 .26288 Mdot
.40535 .27566 Mdot
.40535 .25664 Mdot
.40535 .28875 Mdot
.40535 .28563 Mdot
.40584 .27846 Mdot
.40584 .14503 Mdot
.40584 .25477 Mdot
.40584 .26662 Mdot
.40584 .39787 Mdot
.40632 .18899 Mdot
.40632 .21518 Mdot
.40681 .27472 Mdot
.4073 .30434 Mdot
.4073 .28221 Mdot
.40779 .24698 Mdot
.40779 .20333 Mdot
.40788 .25433 Mdot
.40827 .22765 Mdot
.40827 .18992 Mdot
.40871 .25483 Mdot
.40876 .25486 Mdot
.40881 .2549 Mdot
.40974 .24947 Mdot
.40974 .21705 Mdot
.40974 .24573 Mdot
.41023 .30839 Mdot
.41023 .11136 Mdot
.41023 .29935 Mdot
.41023 .27784 Mdot
.41071 .14659 Mdot
.41071 .24947 Mdot
.4112 .26662 Mdot
.41218 .22266 Mdot
.41218 .35609 Mdot
.41267 .24604 Mdot
.41315 .29592 Mdot
.41364 .33115 Mdot
.41364 .27722 Mdot
.41413 .20239 Mdot
.41462 .24791 Mdot
.41511 .26724 Mdot
.41511 .22453 Mdot
.41511 .26038 Mdot
.41554 .25888 Mdot
.41608 .23794 Mdot
.41608 .27223 Mdot
.41608 .42406 Mdot
.41608 .2476 Mdot
.41657 .32055 Mdot
.41657 .32585 Mdot
.41706 .37262 Mdot
.41754 .20801 Mdot
.41803 .25477 Mdot
.41852 .26069 Mdot
.41852 .21424 Mdot
.41852 .25695 Mdot
.41901 .21362 Mdot
.42047 .22921 Mdot
.42047 .26568 Mdot
.42047 .29468 Mdot
.42047 .21299 Mdot
.42047 .22547 Mdot
.42047 .24729 Mdot
.42096 .23731 Mdot
.42145 .30278 Mdot
.42145 .33115 Mdot
.42145 .2635 Mdot
.42194 .21518 Mdot
.42194 .22172 Mdot
.42291 .30029 Mdot
.42291 .26537 Mdot
.42291 .24199 Mdot
.4234 .25633 Mdot
.4234 .17901 Mdot
.4234 .24168 Mdot
.4234 .18494 Mdot
.42389 .32211 Mdot
.42389 .2264 Mdot
.42486 .15064 Mdot
.42486 .23794 Mdot
.42633 .26288 Mdot
.42681 .33115 Mdot
.4273 .22858 Mdot
.4273 .20146 Mdot
.4273 .32118 Mdot
.4273 .20863 Mdot
.4273 .24542 Mdot
.42779 .31151 Mdot
.42779 .36015 Mdot
.42828 .33115 Mdot
.42828 .2688 Mdot
.42828 .23108 Mdot
.42877 .33209 Mdot
.42925 .28782 Mdot
.42925 .26786 Mdot
.42925 .30029 Mdot
.42925 .21362 Mdot
.42974 .36326 Mdot
.42974 .2688 Mdot
.42974 .23077 Mdot
.43023 .16904 Mdot
.43023 .36856 Mdot
.43072 .20208 Mdot
.43072 .2688 Mdot
.43169 .3536 Mdot
.43169 .33988 Mdot
.43218 .25664 Mdot
.43267 .25446 Mdot
.43267 .29873 Mdot
.43316 .35828 Mdot
.43316 .24324 Mdot
.43365 .26942 Mdot
.43413 .31369 Mdot
.43462 .30247 Mdot
.43462 .26101 Mdot
.43462 .18369 Mdot
.4356 .20707 Mdot
.4356 .2529 Mdot
.43609 .29842 Mdot
.43609 .2582 Mdot
.43609 .23949 Mdot
.43609 .27441 Mdot
.43657 .11292 Mdot
.43657 .20801 Mdot
.43657 .18338 Mdot
.43706 .31525 Mdot
.43706 .25384 Mdot
.43804 .23482 Mdot
.43852 .25446 Mdot
.43852 .37137 Mdot
.43901 .30871 Mdot
.43901 .25508 Mdot
.43901 .16124 Mdot
.43901 .31556 Mdot
.43901 .23451 Mdot
.43901 .25103 Mdot
.4395 .22827 Mdot
.4395 .15501 Mdot
.4395 .20863 Mdot
.43999 .29187 Mdot
.43999 .28906 Mdot
.43999 .25415 Mdot
.44048 .32554 Mdot
.44048 .22079 Mdot
.44194 .27441 Mdot
.44243 .3907 Mdot
.44243 .29842 Mdot
.44243 .36794 Mdot
.44243 .24386 Mdot
.44292 .35765 Mdot
.44292 .30902 Mdot
.44292 .30683 Mdot
.44292 .24573 Mdot
.44292 .25446 Mdot
.44292 .20769 Mdot
.4434 .28751 Mdot
.4434 .32648 Mdot
.4434 .27504 Mdot
.4434 .27597 Mdot
.44389 .28719 Mdot
.44389 .26319 Mdot
.44438 .22297 Mdot
.44487 .29998 Mdot
.44536 .29093 Mdot
.44584 .22796 Mdot
.44584 .28969 Mdot
.44584 .26786 Mdot
.44633 .2688 Mdot
.44633 .33645 Mdot
.44682 .27504 Mdot
.44828 .28314 Mdot
.44828 .19522 Mdot
.44828 .32429 Mdot
.44828 .3271 Mdot
.44926 .16498 Mdot
.44975 .18868 Mdot
.45023 .15033 Mdot
.45023 .22141 Mdot
.4517 .26256 Mdot
.45219 .29499 Mdot
.45219 .35547 Mdot
.45267 .33022 Mdot
.45267 .32835 Mdot
.45316 .26412 Mdot
.45365 .3458 Mdot
.45365 .26381 Mdot
.45414 .34705 Mdot
.45414 .12227 Mdot
.45414 .23014 Mdot
.45463 .2105 Mdot
.45511 .22453 Mdot
.45609 .16654 Mdot
.45609 .23513 Mdot
.45658 .26911 Mdot
.45706 .23108 Mdot
.45804 .237 Mdot
.45902 .30091 Mdot
.45902 .31432 Mdot
.4595 .34674 Mdot
.4595 .27098 Mdot
.4595 .27722 Mdot
.45999 .12196 Mdot
.46048 .27348 Mdot
.46097 .21829 Mdot
.46146 .19585 Mdot
.46146 .26444 Mdot
.46146 .24822 Mdot
.46146 .23887 Mdot
.46194 .27472 Mdot
.46194 .27691 Mdot
.46243 .22484 Mdot
.46243 .30309 Mdot
.46243 .19367 Mdot
.46292 .38945 Mdot
.46292 .33365 Mdot
.46292 .39226 Mdot
.4639 .32149 Mdot
.46438 .21985 Mdot
.46487 .29873 Mdot
.46536 .26911 Mdot
.46536 .60332 Mdot
.46585 .2158 Mdot
.46585 .29062 Mdot
.46633 .26724 Mdot
.46682 .31681 Mdot
.46731 .23607 Mdot
.4678 .27504 Mdot
.4678 .20302 Mdot
.46829 .24698 Mdot
.46829 .25415 Mdot
.46829 .32897 Mdot
.46877 .35204 Mdot
.46975 .24635 Mdot
.47024 .30871 Mdot
.47121 .24854 Mdot
.47219 .34674 Mdot
.47268 .26911 Mdot
.47317 .23731 Mdot
.47463 .1812 Mdot
.47512 .28096 Mdot
.47512 .28252 Mdot
.4756 .32305 Mdot
.47658 .09515 Mdot
.47658 .34955 Mdot
.47707 .23014 Mdot
.47756 .29031 Mdot
.47756 .23201 Mdot
.47804 .27285 Mdot
.47804 .22079 Mdot
.47951 .34113 Mdot
.48 .33957 Mdot
.48097 .39007 Mdot
.48146 .28969 Mdot
.48146 .14877 Mdot
.48195 .27036 Mdot
.48244 .29998 Mdot
.48244 .16841 Mdot
.48292 .34393 Mdot
.48341 .367 Mdot
.4839 .27067 Mdot
.48439 .32554 Mdot
.48439 .11978 Mdot
.48439 .25851 Mdot
.48488 .37511 Mdot
.48488 .28782 Mdot
.48536 .19429 Mdot
.48536 .3695 Mdot
.48585 .26942 Mdot
.48585 .33988 Mdot
.48585 .30621 Mdot
.48683 .28719 Mdot
.48683 .12477 Mdot
.48829 .37449 Mdot
.48878 .3218 Mdot
.48878 .25384 Mdot
.49024 .10481 Mdot
.49171 .44494 Mdot
.49171 .32086 Mdot
.49268 .29779 Mdot
.49268 .3112 Mdot
.49268 .26381 Mdot
.49317 .2847 Mdot
.49317 .37667 Mdot
.49366 .23731 Mdot
.49366 .29592 Mdot
.49415 .40192 Mdot
.49463 .24043 Mdot
.49463 .23264 Mdot
.49658 .31588 Mdot
.49658 .17465 Mdot
.49707 .27909 Mdot
.49707 .27691 Mdot
.49902 .30216 Mdot
.49902 .27535 Mdot
.49902 .23482 Mdot
.49951 .31806 Mdot
.49951 .25539 Mdot
.5 .32305 Mdot
.5 .30309 Mdot
.5 .29561 Mdot
.50098 .26163 Mdot
.50146 .4543 Mdot
.50244 .13817 Mdot
.50342 .29655 Mdot
.50439 .20021 Mdot
.50488 .26444 Mdot
.50488 .32461 Mdot
.50488 .41844 Mdot
.50537 .21299 Mdot
.50585 .28376 Mdot
.50634 .19024 Mdot
.50781 .23638 Mdot
.50976 .32679 Mdot
.51025 .14191 Mdot
.51073 .20551 Mdot
.51073 .24916 Mdot
.51171 .30465 Mdot
.51171 .27441 Mdot
.5122 .35983 Mdot
.51366 .3299 Mdot
.51366 .24168 Mdot
.51756 .39756 Mdot
.51903 .31775 Mdot
.51903 .30777 Mdot
.51952 .18899 Mdot
.52196 .29312 Mdot
.52391 .32803 Mdot
.5244 .32616 Mdot
.5244 .35235 Mdot
.5244 .28501 Mdot
.52537 .29998 Mdot
.52781 .22484 Mdot
.52781 .27722 Mdot
.52781 .21518 Mdot
.5283 .38571 Mdot
.52879 .31026 Mdot
.52927 .1469 Mdot
.52927 .25041 Mdot
.53025 .25695 Mdot
.53025 .27161 Mdot
.53074 .26599 Mdot
.53269 .34082 Mdot
.53367 .21642 Mdot
.53367 .32741 Mdot
.53415 .32803 Mdot
.53415 .35453 Mdot
.53562 .3564 Mdot
.5361 .19647 Mdot
.53659 .1469 Mdot
.53708 .21736 Mdot
.53757 .30683 Mdot
.53806 .31993 Mdot
.54001 .28906 Mdot
.54098 .31213 Mdot
.54098 .4543 Mdot
.54147 .34736 Mdot
.54196 .01472 Mdot
.54391 .25165 Mdot
.54537 .29249 Mdot
.54684 .41502 Mdot
.54879 .39756 Mdot
.54977 .26942 Mdot
.55025 .22515 Mdot
.55318 .19741 Mdot
.55367 .38789 Mdot
.55367 .23139 Mdot
.55416 .28906 Mdot
.55757 .38571 Mdot
.5605 .33552 Mdot
.56148 .20427 Mdot
.56245 .3006 Mdot
.56538 .31775 Mdot
.56635 .21299 Mdot
.56879 .33895 Mdot
.57221 .36295 Mdot
.57319 .33271 Mdot
.57709 .20551 Mdot
.57709 .24573 Mdot
.57758 .08517 Mdot
.58392 .30434 Mdot
.58733 .20395 Mdot
.58733 .36607 Mdot
.58782 .38353 Mdot
.59075 .26381 Mdot
.5966 .40161 Mdot
.59758 .34799 Mdot
.59904 .27909 Mdot
.6049 .2158 Mdot
.6049 .43216 Mdot
.60783 .23388 Mdot
.6088 .35796 Mdot
.62978 .38758 Mdot
.63515 .08736 Mdot
.64637 .19491 Mdot
.64783 .31026 Mdot
.6532 .42343 Mdot
.65613 .45305 Mdot
.66393 .32959 Mdot
.66784 .32803 Mdot
.68443 .42562 Mdot
.75517 .22921 Mdot
.80396 .43902 Mdot
.80591 .16 Mdot
.89764 .16498 Mdot
.97619 .31681 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{320.563, 198.125},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000500000aR000`400?l00000o`00003oTP0J6QX0
0`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX20=_Kfj`0
6QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B
01XJ6P030=_Kf`0J6QX06QXJ01L06QXJ00<0fm_K01XJ6P0J6QX0T@0J6QX001D06QXJ00<0fm_K01XJ
6P0J6QX0NP0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P030=_Kf`0J6QX06QXJ09406QXJ000E01XJ6P03
0=_Kf`0J6QX06QXJ07X06QXJ0P3Kfm^/01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J
6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3K
fm/06QXJ01XJ6P2[01XJ6P00TP0J6QX20=_Kfj`06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ
001H01XJ6P030=_Kf`0J6QX06QXJ03L06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX005P06QXJ00<0fm_K
01XJ6P0J6QX0900J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K100J6QX20=_Kf`H06QXJ00<0fm_K
01XJ6P0J6QX0Z`0J6QX007l06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/5
01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ001o01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX30=_Kfj/06QXJ001g01XJ6P@0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80
fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00O@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P03
0=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX007d06QXJ103Kfm/901XJ6P<0fm_K
1@0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00OP0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P030=_Kf`0J
6QX06QXJ0:/06QXJ000701XJ6P030=_Kf`0J6QX06QXJ07@06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX2
0=_Kfj`06QXJ000701XJ6P030=_Kf`0J6QX06QXJ08P06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX006h0
6QXJ00<0fm_K01XJ6P0J6QX08@0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00:P0J6QX00`3Kfm/06QXJ
01XJ6P1101XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX00`3Kfm/06QXJ
01XJ6P2[01XJ6P00:P0J6QX00`3Kfm/06QXJ01XJ6P1?01XJ6P030=_Kf`0J6QX06QXJ01<06QXJ00<0
fm_K01XJ6P0J6QX0Z`0J6QX006P06QXJ00<0fm_K01XJ6P0J6QX09`0J6QX20=_Kfb<06QXJ00<0fm_K
01XJ6P0J6QX0QP0J6QX006P06QXJ00<0fm_K01XJ6P0J6QX09`0J6QX00`3Kfm/06QXJ01XJ6P0R01XJ
6P030=_Kf`0J6QX06QXJ01006QXJ00<0fm_K01XJ6P0J6QX0L`0J6QX009806QXJ00<0fm_K01XJ6P0J
6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P1c01XJ6P002@0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_K
f`0J6QX06QXJ02@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2V01XJ6P002@0J
6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P0J6QX0=`0J
6QX00`3Kfm/06QXJ01XJ6P0T01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0YP0J
6QX002806QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P1N01XJ6P80fm_K[00J6QX0
09806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0
6QXJ01XJ6P2R01XJ6P00C`0J6QX00`3Kfm/06QXJ01XJ6P0]01XJ6P030=_Kf`0J6QX06QXJ01006QXJ
00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P2R01XJ6P00400J6QX00`3Kfm/06QXJ01XJ
6P0l01XJ6P030=_Kf`0J6QX06QXJ02d06QXJ00@0fm_K01XJ6P0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ
01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ000@01XJ6P030=_Kf`0J6QX06QXJ06l06QXJ00<0
fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P80fm_K[00J6QX004D06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`0Z01XJ6P030=_Kf`0J6QX06QXJ01/06QXJ00<0fm_K01XJ6P0J6QX01@0J
6QX00`3Kfm/06QXJ01XJ6P2S01XJ6P00?00J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P050=_Kf`0J6QX0
6QXJ01XJ6P3Kfm/02P0J6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0
fm_K01XJ6P3Kfm/01`0J6QX00`3Kfm/06QXJ01XJ6P2S01XJ6P00?00J6QX00`3Kfm/06QXJ01XJ6P09
01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<0fm_K01XJ6P0J6QX0<`0J6QX20=_Kf`@06QXJ00<0fm_K
01XJ6P3Kfm/01`0J6QX00`3Kfm/06QXJ01XJ6P2S01XJ6P00B00J6QX00`3Kfm/06QXJ01XJ6P0R01XJ
6P030=_Kf`0J6QX06QXJ01T06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P05
01XJ6P030=_Kf`0J6QX06QXJ0:<06QXJ000a01XJ6P030=_Kf`0J6QX06QXJ02L06QXJ00<0fm_K01XJ
6P0J6QX03`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ01406QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX30=_Kfj/06QXJ000a01XJ6P030=_Kf`0J6QX06QXJ01406QXJ00<0fm_K01XJ6P0J
6QX04`0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00<0fm_K01XJ
6P0J6QX0200J6QX40=_Kf`<06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ000l01XJ6P03
0=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX06P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P04
0=_Kf`0J6QX06QXJ0=_KfaT06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ
6P030=_Kf`0J6QX06QXJ09h06QXJ000N01XJ6P030=_Kf`0J6QX06QXJ01/06QXJ00<0fm_K01XJ6P0J
6QX07P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0fm_K01XJ6P0J
6QX02@0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX0103Kfm/06QXJ01XJ6P3Kfm^M01XJ
6P007P0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P030=_Kf`0J6QX06QXJ0080fm_K4`0J6QX00`3Kfm/0
6QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<0fm_K01XJ6P0J6QX04P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/@01XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX0V`0J6QX003P0
6QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/C01XJ6P030=_Kf`0J6QX06QXJ01406QXJ00<0fm_K01XJ6P0J
6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P80fm_K3`0J6QX20=_Kfa@06QXJ00<0fm_K01XJ6P3K
fm/0U@0J6QX006@06QXJ00<0fm_K01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX01@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/601XJ6P03
0=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P3Kfm/0U@0J6QX003l06QXJ00<0fm_K01XJ6P0J6QX0
3`0J6QX00`3Kfm/06QXJ01XJ6P0X01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0
1@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ0:@06QXJ000o01XJ6P030=_K
f`0J6QX06QXJ00l06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`3Kfm/06QXJ01XJ6P0U01XJ6P030=_K
f`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX006<06QXJ00<0fm_K01XJ6P0J6QX0400J
6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0J`0J
6QX00`3Kfm/06QXJ01XJ6P0m01XJ6P00@`0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P030=_Kf`0J6QX0
6QXJ01806QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ0=_Kf`0B01XJ6P030=_Kf`0J6QX0
6QXJ00@06QXJ0P3Kfm]/01XJ6P030=_Kf`0J6QX06QXJ03d06QXJ001001XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030=_Kf`0J6QX0
6QXJ00L06QXJ00<0fm_K01XJ6P3Kfm/04P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P80fm_KRP0J
6QX00`3Kfm/06QXJ01XJ6P0P01XJ6P00=`0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX0
6QXJ00X06QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00@0
fm_K01XJ6P3Kfm/0fm_K3`0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX00P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ08406QXJ00<0fm_K01XJ6P0J6QX0
800J6QX003L06QXJ00<0fm_K01XJ6P0J6QX04P0J6QX01P3Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`<0
6QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0901XJ6P@0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0@01XJ
6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ
6P030=_Kf`0J6QX06QXJ0:@06QXJ001<01XJ6P030=_Kf`0J6QX0fm_K00X06QXJ00<0fm_K01XJ6P0J
6QX0200J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K0`0J6QX20=_Kf`d06QXJ00<0fm_K01XJ6P3K
fm/04@0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ0:006QXJ001L01XJ6P050=_K
f`0J6QX06QXJ01XJ6P3Kfm/02@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K1P0J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX20=_Kf`T0
6QXJ00<0fm_K01XJ6P0J6QX0X00J6QX004T06QXJ00<0fm_K01XJ6P0J6QX0400J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K01006QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K
00806QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`2Y
01XJ6P00B@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/C01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K
01XJ6P0J6QX01P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/601XJ6P030=_Kf`0J6QX06QXJ0080fm_K1P0J
6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00L06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`2Y01XJ6P00
C00J6QX20=_KfaH06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0701XJ6P050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/0300J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0100J6QX0
103Kfm/06QXJ01XJ6P3Kfm/B01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001=01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`h06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_Kf`0J
6QX06QXJ00P06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P040=_Kf`0J
6QX06QXJ0=_Kf`h06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`2J01XJ6P00B00J6QX00`3Kfm/06QXJ
01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P0J6QX0600J6QX20=_Kf`0301XJ
6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ6P0J6QX02P0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`H0
6QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0Y01XJ6P030=_Kf`0J6QX06QXJ0700
6QXJ001801XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K00d06QXJ0P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00@0fm_K01XJ6P0J
6QX06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3K
fm/06QXJ01XJ6P0K01XJ6P030=_Kf`0J6QX06QXJ07006QXJ001801XJ6P030=_Kf`0J6QX06QXJ00/0
6QXJ00<0fm_K01XJ6P0J6QX03P0J6QX00`3Kfm/06QXJ01XJ6P030=_Kf`@06QXJ0P3Kfm/00`0J6QX0
fm_K01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0
6QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ08h06QXJ001801XJ6P030=_Kf`0J6QX06QXJ01X06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0
1`0J6QX50=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K0=_Kf`0601XJ6P03
0=_Kf`0J6QX0fm_K00/06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P03
0=_Kf`0J6QX06QXJ08<06QXJ001Q01XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/0
6QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/301XJ
6P040=_Kf`0J6QX0fm_K0=_Kf`<06QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P0401XJ6P030=_Kf`0J6QX0
fm_K00d06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P040=_Kf`0J6QX0
6QXJ0=_KfhD06QXJ001Q01XJ6P<0fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX0
6QXJ00D06QXJ00H0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX20=_Kf`@06QXJ00@0fm_K01XJ6P0J6QX0
fm_K0P0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/=01XJ6P030=_Kf`0J6QX06QXJ0180
6QXJ00<0fm_K01XJ6P0J6QX0QP0J6QX003406QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`3Kfm/06QXJ
01XJ6P0G01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0601XJ6PD0
fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P050=_Kf`0J6QX0fm_K0=_Kf`0J6QX00P3Kfm/401XJ
6P030=_Kf`0J6QX0fm_K00d06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX00`3Kfm/06QXJ01XJ6P2901XJ
6P00<@0J6QX00`3Kfm/06QXJ01XJ6P0D01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ00<0fm_K01XJ6P0J
6QX00P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ0080fm_K00@06QXJ0=_Kf`0J6QX06QXJ0`3Kfm/201XJ
6P80fm_K00@06QXJ0=_Kf`0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ0=_Kf`0;01XJ6P030=_Kf`0J6QX0
6QXJ00@06QXJ00@0fm_K01XJ6P3Kfm/0fm_K2@0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_Kf`0J
6QX06QXJ07d06QXJ001201XJ6P030=_Kf`0J6QX06QXJ02006QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_K
f`0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ
01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00<06QXJ00@0fm_K01XJ6P0J6QX06QXJ0`3Kfm/501XJ6P<0
fm_K4P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/E01XJ6P030=_Kf`0J6QX06QXJ07d06QXJ001201XJ6P03
0=_Kf`0J6QX06QXJ01T06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX0fm_K
00<06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/501XJ6P040=_Kf`0J
6QX06QXJ01XJ6P80fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/501XJ6P80fm_K00@06QXJ0=_Kf`0J
6QX06QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ0:D06QXJ001501XJ6P030=_Kf`0J6QX06QXJ01H0
6QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0701XJ6P80fm_K0P0J6QX20=_Kf`@06QXJ00<0fm_K01XJ
6P0J6QX0100J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`806QXJ00@0fm_K01XJ6P3Kfm/0fm_K1@0J
6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P030=_K
f`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0SP0J6QX003l06QXJ00<0fm_K01XJ6P0J6QX00`0J
6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX01P0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K0`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`<06QXJ
00P0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`02
01XJ6P040=_Kf`0J6QX0fm_K0=_Kfa<06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ
6P0n01XJ6P030=_Kf`0J6QX06QXJ04d06QXJ000o01XJ6P030=_Kf`0J6QX06QXJ01806QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J
6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00<06QXJ00@0fm_K01XJ6P3Kfm/0fm_K0P0J6QX00`3Kfm/0
6QXJ0=_Kf`0201XJ6P<0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ0100
6QXJ00<0fm_K01XJ6P0J6QX0?@0J6QX00`3Kfm/06QXJ01XJ6P1=01XJ6P00@P0J6QX00`3Kfm/06QXJ
01XJ6P0?01XJ6P030=_Kf`0J6QX06QXJ01806QXJ0P3Kfm/;01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3K
fm/03@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/401XJ6P<0fm_K00D06QXJ0=_Kf`0J6QX06QXJ0=_Kf`05
01XJ6P80fm_K4@0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_Kf`0J6QX06QXJ07`06QXJ001201XJ
6P030=_Kf`0J6QX06QXJ02D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0201XJ
6P80fm_K0P0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`@06QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P02
01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm/0100J6QX0fm_K01XJ6P3Kfm/601XJ6P80fm_K0P0J
6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P030=_Kf`0J6QX06QXJ07`06QXJ001[01XJ6P070=_Kf`0J6QX0
6QXJ01XJ6P3Kfm/06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX0fm_K0=_Kf`806QXJ00@0fm_K01XJ6P0J
6QX06QXJ0P3Kfm/401XJ6P@0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P<0fm_K0P0J6QX00`3K
fm/06QXJ01XJ6P0401XJ6P070=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`2L01XJ6P00?00J6QX0
0`3Kfm/06QXJ01XJ6P0R01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX0
103Kfm/06QXJ0=_Kf`0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/:01XJ6P80fm_K00D0
6QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0501XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX00`3Kfm/06QXJ01XJ6P2J01XJ6P00?00J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J
6QX06QXJ00<06QXJ00<0fm_K01XJ6P3Kfm/02@0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/401XJ6P030=_K
f`0J6QX0fm_K00<06QXJ1@3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ00@0fm_K01XJ6P3Kfm/0fm_K8@0J6QX00`3Kfm/06QXJ01XJ6P2601XJ6P00AP0J6QX20=_Kf`T0
6QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00D0
6QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0<01XJ6P<0fm_K100J6QX0103Kfm/06QXJ0=_Kf`0J6QX7
0=_Kf`D06QXJ0P3Kfm/501XJ6P040=_Kf`0J6QX0fm_K0=_Kf``06QXJ00<0fm_K01XJ6P0J6QX00`0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX09@0J
6QX20=_KfdP06QXJ1@3Kfm/201XJ6P80fm_K3P0J6QX004D06QXJ00@0fm_K01XJ6P0J6QX0fm_K3@0J
6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX00P0J
6QX30=_Kf`@06QXJ00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/501XJ6P@0fm_K00<06QXJ0=_Kf`0J6QX0
0`0J6QX40=_Kf`D06QXJ00<0fm_K01XJ6P3Kfm/01P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0^01XJ6P040=_K
f`0J6QX06QXJ0=_KfdT06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ
00/06QXJ001801XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<0fm_K01XJ6P3Kfm/0200J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P050=_Kf`0J6QX0fm_K0=_Kf`0J6QX00`3Kfm/801XJ6P80fm_K1P0J6QX20=_K
f`806QXJ0`3Kfm/201XJ6P@0fm_K1@0J6QX30=_Kf`H06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX0
0`3Kfm/06QXJ01XJ6P0f01XJ6P030=_Kf`0J6QX06QXJ04L06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`0201XJ6P030=_Kf`0J6QX06QXJ00/06QXJ000o01XJ6P@0fm_K0`0J6QX20=_Kf``06QXJ00<0fm_K
01XJ6P0J6QX01@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3K
fm/;01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P@0fm_K
0P0J6QX20=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00T0
6QXJ00<0fm_K01XJ6P0J6QX0=00J6QX20=_KfdX06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ
6P030=_Kf`0J6QX06QXJ00/06QXJ001601XJ6P80fm_K500J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0100J6QX0103Kfm/06QXJ0=_Kf`0J6QX2
0=_Kf`<06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/201XJ6P<0fm_K00D06QXJ0=_Kf`0J6QX0
6QXJ0=_Kf`0201XJ6P060=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ0=_Kf`02
01XJ6P80fm_K6P0J6QX00`3Kfm/06QXJ01XJ6P0Q01XJ6P030=_Kf`0J6QX06QXJ04T06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00/06QXJ001601XJ6P<0fm_K2`0J6QX2
0=_Kf`/06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00D0
fm_K01XJ6P3Kfm/06QXJ0=_Kf`0901XJ6P@0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K1@0J6QX0203Kfm/0
6QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`L06QXJ00<0
fm_K01XJ6P0J6QX0400J6QX00`3Kfm/06QXJ01XJ6P0Q01XJ6P<0fm_KB00J6QX20=_Kf`@06QXJ0P3K
fm/>01XJ6P00D00J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`l06QXJ00<0fm_K01XJ6P3Kfm/00P0J
6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/00P0J
6QX40=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K0`0J6QX0103Kfm/06QXJ01XJ6P0J6QX40=_Kf`04
01XJ6P3Kfm/06QXJ01XJ6P80fm_K3@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ
08l06QXJ001@01XJ6P030=_Kf`0J6QX06QXJ01@06QXJ00@0fm_K01XJ6P0J6QX0fm_K3P0J6QX01@3K
fm/06QXJ0=_Kf`0J6QX0fm_K00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ6P80fm_K0`0J
6QX0103Kfm/06QXJ01XJ6P0J6QX30=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/=01XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0S`0J6QX005T06QXJ00<0fm_K01XJ6P3Kfm/07@0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P040=_Kf`0J6QX0fm_K0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/0
6QXJ01XJ6P0301XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@0J6QX00`3Kfm/06QXJ01XJ6P2E01XJ
6P00F@0J6QX00`3Kfm/06QXJ0=_Kf`0:01XJ6P030=_Kf`0J6QX0fm_K01006QXJ00L0fm_K01XJ6P0J
6QX0fm_K01XJ6P3Kfm/06QXJ00@0fm_K1P0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00<06QXJ00<0
fm_K01XJ6P3Kfm/02@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00@06QXJ00<0fm_K01XJ6P0J6QX0
500J6QX00`3Kfm/06QXJ01XJ6P1o01XJ6P00IP0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/801XJ6P030=_K
f`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P<0fm_K
2P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ01@06QXJ00<0fm_K01XJ6P0J6QX0O`0J6QX002`06QXJ
00<0fm_K01XJ6P0J6QX08`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/<01XJ6P030=_Kf`0J6QX06QXJ00@0
6QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/401XJ6P030=_Kf`0J6QX0fm_K
00806QXJ00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/<01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0100J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@0J6QX00`3Kfm/06QXJ
01XJ6P2G01XJ6P00o`3Kfm]10=_Kf`001P0J6QX00`3Kfm/06QXJ01XJ6P0=01XJ6P030=_Kf`0J6QX0
6QXJ00`06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX0
6QXJ00806QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX0
6QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0
0P0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/401XJ6P03
0=_Kf`0J6QX06QXJ00<0fm_K100J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX0fm_K0=_K
f`L06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P80fm_K3`0J6QX00`3K
fm/06QXJ01XJ6P0<01XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3K
fm/06QXJ01XJ6P0<01XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`3K
fm/06QXJ01XJ6P0=01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ0@3Kfm/101XJ6P406QXJ001401XJ6P03
0=_Kf`0J6QX06QXJ01P06QXJ0P3Kfm/701XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/02`0J6QX01@3K
fm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P03
01XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J
6QX0fm_K00D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J
6QX06QXJ03006QXJ00<0fm_K01XJ6P0J6QX0B`0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P00?@0J6QX0
0`3Kfm/06QXJ01XJ6P0P01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX0
0`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX0fm_K00<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P0J
6QX0fm_K00806QXJ0P3Kfm/801XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/01@0J6QX00`3Kfm/06QXJ01XJ
6P2G01XJ6P00?@0J6QX00`3Kfm/06QXJ01XJ6P0D01XJ6P030=_Kf`0J6QX06QXJ01806QXJ0P3Kfm/>
01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ
0=_Kf`3Kfm/00`0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX00`3Kfm/00`0J6QX0fm_K01XJ6P05
01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0R`0J6QX003T06QXJ00<0fm_K01XJ
6P0J6QX03P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00L0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00D06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ0=_K
f`020=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`806QXJ0P3Kfm/0100J6QX0fm_K01XJ
6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80
fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J
6QX0100J6QX00`3Kfm/06QXJ01XJ6P2401XJ6P00>@0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_K
f`0J6QX06QXJ00h06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00L0
6QXJ0P3Kfm/401XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/301XJ6P<0fm_K0P0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K00D06QXJ0P3Kfm/601XJ6P030=_Kf`0J
6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0Q00J6QX004h06QXJ00<0fm_K01XJ6P0J6QX02P0J
6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K100J6QX20=_Kf`07
01XJ6P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0501XJ6P030=_Kf`0J6QX06QXJ0080fm_K1@0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/401XJ6P030=_Kf`0J6QX0fm_K00P06QXJ00@0fm_K01XJ6P0J6QX0fm_K
0P0J6QX00`3Kfm/06QXJ01XJ6P0P01XJ6P030=_Kf`0J6QX06QXJ06l06QXJ001>01XJ6P030=_Kf`0J
6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J
6QX0fm_K00D06QXJ00<0fm_K01XJ6P3Kfm/02P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`@06QXJ0P3K
fm/201XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K02406QXJ00<0fm_K01XJ6P0J6QX0K`0J6QX004d06QXJ00<0fm_K01XJ6P0J6QX02@0J
6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX01@0J
6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00T06QXJ0P3Kfm/501XJ6P80fm_K00<06QXJ0=_Kf`0J6QX0
1`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`3Kfm/06QXJ01XJ6P2001XJ6P030=_Kf`0J6QX06QXJ00L06QXJ001=01XJ6P030=_Kf`0J
6QX06QXJ01@06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX20=_Kf`H06QXJ0`3Kfm/701XJ6P<0fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0P00J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P00I00J
6QX00`3Kfm/06QXJ01XJ6P0901XJ6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0
2P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/:01XJ6P80fm_K0`0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_K
f`0301XJ6P3Kfm/0fm_K00/06QXJ00<0fm_K01XJ6P0J6QX0TP0J6QX006`06QXJ00<0fm_K01XJ6P0J
6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P040=_Kf`0J6QX0fm_K0=_Kf`@06QXJ00<0fm_K01XJ
6P3Kfm/00`0J6QX20=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/301XJ6P80fm_K00<06QXJ0=_K
f`0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2G01XJ6P00K00J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P03
0=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/401XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P04
0=_Kf`0J6QX0fm_K0=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/01@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P040=_Kf`0J6QX0fm_K0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K:@0J6QX20=_Kff/06QXJ001f
01XJ6P80fm_K100J6QX20=_Kf`D06QXJ00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/601XJ6P060=_Kf`0J
6QX06QXJ0=_Kf`0J6QX0fm_K3P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ
00X06QXJ00<0fm_K01XJ6P0J6QX06P0J6QX20=_Kff/06QXJ002301XJ6P040=_Kf`0J6QX0fm_K01XJ
6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K7P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0
fm_K08T06QXJ002=01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ
01L06QXJ00<0fm_K01XJ6P3Kfm/0R`0J6QX005h06QXJ00<0fm_K01XJ6P0J6QX0700J6QX20=_Kf`X0
6QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX0fm_K00h0
6QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P2901XJ6P00GP0J6QX00`3Kfm/06QXJ
0=_Kf`0L01XJ6P80fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0fm_K00D06QXJ
0`3Kfm/>01XJ6P030=_Kf`0J6QX06QXJ09@06QXJ001M01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ
00<0fm_K01XJ6P0J6QX0900J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P040=_Kf`0J6QX06QXJ0=_Kfa80
6QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`3Kfm/06QXJ01XJ6P1o01XJ6P00G@0J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0900J6QX01@3Kfm/06QXJ
0=_Kf`3Kfm/06QXJ00<0fm_K500J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P030=_Kf`0J6QX06QXJ07l0
6QXJ001R01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX00`3Kfm/06QXJ
01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/>01XJ
6P040=_Kf`0J6QX06QXJ0=_KfiH06QXJ001^01XJ6P030=_Kf`0J6QX0fm_K00h06QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0501XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K
4`0J6QX00`3Kfm/06QXJ01XJ6P020=_KfaH06QXJ00<0fm_K01XJ6P0J6QX0O00J6QX007006QXJ00<0
fm_K01XJ6P0J6QX02P0J6QX40=_Kf`806QXJ0`3Kfm/201XJ6PD0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/?01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`3Kfm/06QXJ
01XJ6P1l01XJ6P00O@0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ
6P0301XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX00`3Kfm/06QXJ01XJ
6P2701XJ6P00OP0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@0J
6QX30=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX06P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K08D06QXJ
001b01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ0=_K
f`020=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX20=_Kfal06QXJ00<0fm_K01XJ6P0J6QX0P`0J
6QX003406QXJ00<0fm_K01XJ6P0J6QX06@0J6QX00`3Kfm/06QXJ01XJ6P0R01XJ6P030=_Kf`0J6QX0
6QXJ00P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX01P3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P80
fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ0:<06QXJ000a01XJ6P030=_K
f`0J6QX06QXJ01T06QXJ00<0fm_K01XJ6P0J6QX0;P0J6QX20=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX30=_Kfj<06QXJ001[01XJ6P030=_Kf`0J
6QX06QXJ02@06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX30=_Kfj<06QXJ001[01XJ6P030=_Kf`0J6QX0
6QXJ02@06QXJ0P3Kfm/W01XJ6P030=_Kf`0J6QX06QXJ08806QXJ001l01XJ6P030=_Kf`0J6QX06QXJ
01<06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ
00L06QXJ00<0fm_K01XJ6P0J6QX0PP0J6QX007`06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX20=_Kfa@0
6QXJ00<0fm_K01XJ6P0J6QX01@0J6QX20=_KfaH06QXJ00<0fm_K01XJ6P0J6QX0M@0J6QX007l06QXJ
00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K100J6QX00`3Kfm/06QXJ
01XJ6P0E01XJ6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K01XJ6P0J6QX0M@0J6QX007l06QXJ00<0
fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ
6P2U01XJ6P00P@0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P80fm_K400J6QX00`3Kfm/06QXJ01XJ6P07
01XJ6P030=_Kf`0J6QX06QXJ08l06QXJ002101XJ6P030=_Kf`0J6QX06QXJ00h06QXJ00<0fm_K01XJ
6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ
6P0J6QX0300J6QX00`3Kfm/06QXJ01XJ6P2001XJ6P00JP0J6QX00`3Kfm/06QXJ01XJ6P0U01XJ6P03
0=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX07@0J6QX00`3Kfm/06QXJ01XJ6P2001XJ6P00
JP0J6QX00`3Kfm/06QXJ01XJ6P0U01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ001B01XJ6P030=_Kf`0J
6QX06QXJ03d06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX005806QXJ00<0fm_K01XJ6P0J6QX0?@0J6QX2
0=_KfaT06QXJ00<0fm_K01XJ6P0J6QX0T00J6QX009806QXJ00<0fm_K01XJ6P0J6QX0600J6QX00`3K
fm/06QXJ01XJ6P2@01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P030=_Kf`0J6QX06QXJ09d0
6QXJ002401XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ
01XJ6P0/01XJ6P030=_Kf`0J6QX06QXJ06h06QXJ002401XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0
fm_K01XJ6P0J6QX0>P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ06@06QXJ002B
01XJ6P80fm_KA@0J6QX00`3Kfm/06QXJ01XJ6P1T01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P0[01XJ
6P030=_Kf`0J6QX06QXJ07d06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ02/06QXJ00<0fm_K01XJ6P0J
6QX0O@0J6QX008X06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ06X06QXJ00<0fm_K01XJ6P0J6QX0
?P0J6QX008T06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P1Z01XJ6P030=_K
f`0J6QX06QXJ03h06QXJ002<01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0`3Kfm/701XJ6P030=_Kf`0J
6QX06QXJ0:406QXJ002:01XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX0
6QXJ0:406QXJ002:01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX008X0
6QXJ0`3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/0
6QXJ01XJ6P0Q01XJ6P030=_Kf`0J6QX06QXJ06d06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ
00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0Q01XJ6P030=_Kf`0J6QX06QXJ06d06QXJ
002B01XJ6P80fm_K[00J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ
6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX0
Z`0J6QX009806QXJ0P3Kfm^/01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3K
fm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ
01XJ6P2[01XJ6P00TP0J6QX20=_Kfj`06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ
6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P80fm_K
[00J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX0
07l06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`@06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ
0:/06QXJ001o01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P2[01XJ6P00O`0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ0`3Kfm^[01XJ6P00P00J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ
01XJ6P2[01XJ6P00O@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ00D06QXJ
00<0fm_K01XJ6P0J6QX0Z`0J6QX007d06QXJ103Kfm/901XJ6P<0fm_K1@0J6QX00`3Kfm/06QXJ01XJ
6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX20=_Kfj`06QXJ002B01XJ6P03
0=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J
6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P80fm_K[00J6QX00980
6QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0
fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX009806QXJ0P3Kfm^/01XJ
6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J
6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX20=_K
fj`06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ002B01XJ6P030=_Kf`0J6QX06QXJ0:/06QXJ
002301XJ6PD0fm_K0P0J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0Z`0J6QX008D06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0Z`0J
6QX008D06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0`3K
fm^[01XJ6P00Q@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX00`0J
6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00Q@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX20=_Kfj`06QXJ002401XJ6P80fm_K100J6QX20=_Kf`H06QXJ0P3Kfm^/
01XJ6P00TP0J6QX00`3Kfm/06QXJ01XJ6P2[01XJ6P00TP0J6QX20=_Kfj`06QXJ002B01XJ6P030=_K
f`0J6QX06QXJ0:/06QXJ0000\
\>"],
  ImageRangeCache->{{{65, 320.438}, {494.938, 337.438}} -> {-14.6597, \
33.2699, 0.0643411, 0.100693}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({corr = Correlation[X, Y], \[Rho] = SpearmanRankCorrelation[X, Y], 
        KendallRankCorrelation[X, Y]} // N\)], "Input"],

Cell[BoxData[
    \({0.322441321426045`, 0.3177750997450542`, 
      0.22423994044910894`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{\(Usual\ nonparametric\ estimate\ of\ Kendall' s\ tau\), "=", 
      RowBox[{
        SuperscriptBox[
          RowBox[{"(", GridBox[{
                {"n"},
                {"2"}
                }], 
            ")"}], \(-1\)], \(\[Sum]\+\(i\  < \ j\)Sign[\((X\_i - 
                  X\_j)\) \((Y\_i - Y\_j)\)]\)}]}]], "DisplayFormula"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Tau] = 
      Binomial[n, 2]^\((\(-1\))\)\ Sum[
            Sum[Sign[\((X\[LeftDoubleBracket]i\[RightDoubleBracket] - 
                      X\[LeftDoubleBracket]
                        j\[RightDoubleBracket])\) \((Y\[LeftDoubleBracket]
                        i\[RightDoubleBracket] - 
                      Y\[LeftDoubleBracket]j\[RightDoubleBracket])\)], {j, 1, 
                i - 1}], {i, 1, n}] // N\)], "Input"],

Cell[BoxData[
    \(0.2322007116304978`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"QuantilePlot", "[", 
          RowBox[{"X", ",", 
            StyleBox["Y",
              FontColor->RGBColor[0, 1, 0]]}], "]"}], "//", "fShow"}], ";", 
      " ", \( (*\ Mathematica\ 5\ *) \)}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.464185 0.0504439 0.257081 0.0326639 [
[.08586 .24458 -12 -9 ]
[.08586 .24458 12 0 ]
[.21197 .24458 -6 -9 ]
[.21197 .24458 6 0 ]
[.33808 .24458 -12 -9 ]
[.33808 .24458 12 0 ]
[.59029 .24458 -9 -9 ]
[.59029 .24458 9 0 ]
[.7164 .24458 -3 -9 ]
[.7164 .24458 3 0 ]
[.84251 .24458 -9 -9 ]
[.84251 .24458 9 0 ]
[.96862 .24458 -6 -9 ]
[.96862 .24458 6 0 ]
[.45168 .0121 -24 -4.5 ]
[.45168 .0121 0 4.5 ]
[.45168 .09376 -12 -4.5 ]
[.45168 .09376 0 4.5 ]
[.45168 .17542 -24 -4.5 ]
[.45168 .17542 0 4.5 ]
[.45168 .33874 -18 -4.5 ]
[.45168 .33874 0 4.5 ]
[.45168 .4204 -6 -4.5 ]
[.45168 .4204 0 4.5 ]
[.45168 .50206 -18 -4.5 ]
[.45168 .50206 0 4.5 ]
[.45168 .58372 -12 -4.5 ]
[.45168 .58372 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08586 .25708 m
.08586 .26333 L
s
[(-7.5)] .08586 .24458 0 1 Mshowa
.21197 .25708 m
.21197 .26333 L
s
[(-5)] .21197 .24458 0 1 Mshowa
.33808 .25708 m
.33808 .26333 L
s
[(-2.5)] .33808 .24458 0 1 Mshowa
.59029 .25708 m
.59029 .26333 L
s
[(2.5)] .59029 .24458 0 1 Mshowa
.7164 .25708 m
.7164 .26333 L
s
[(5)] .7164 .24458 0 1 Mshowa
.84251 .25708 m
.84251 .26333 L
s
[(7.5)] .84251 .24458 0 1 Mshowa
.96862 .25708 m
.96862 .26333 L
s
[(10)] .96862 .24458 0 1 Mshowa
.125 Mabswid
.11108 .25708 m
.11108 .26083 L
s
.1363 .25708 m
.1363 .26083 L
s
.16152 .25708 m
.16152 .26083 L
s
.18674 .25708 m
.18674 .26083 L
s
.23719 .25708 m
.23719 .26083 L
s
.26241 .25708 m
.26241 .26083 L
s
.28763 .25708 m
.28763 .26083 L
s
.31285 .25708 m
.31285 .26083 L
s
.3633 .25708 m
.3633 .26083 L
s
.38852 .25708 m
.38852 .26083 L
s
.41374 .25708 m
.41374 .26083 L
s
.43896 .25708 m
.43896 .26083 L
s
.48941 .25708 m
.48941 .26083 L
s
.51463 .25708 m
.51463 .26083 L
s
.53985 .25708 m
.53985 .26083 L
s
.56507 .25708 m
.56507 .26083 L
s
.61552 .25708 m
.61552 .26083 L
s
.64074 .25708 m
.64074 .26083 L
s
.66596 .25708 m
.66596 .26083 L
s
.69118 .25708 m
.69118 .26083 L
s
.74163 .25708 m
.74163 .26083 L
s
.76685 .25708 m
.76685 .26083 L
s
.79207 .25708 m
.79207 .26083 L
s
.81729 .25708 m
.81729 .26083 L
s
.86774 .25708 m
.86774 .26083 L
s
.89296 .25708 m
.89296 .26083 L
s
.91818 .25708 m
.91818 .26083 L
s
.9434 .25708 m
.9434 .26083 L
s
.06063 .25708 m
.06063 .26083 L
s
.03541 .25708 m
.03541 .26083 L
s
.01019 .25708 m
.01019 .26083 L
s
.99385 .25708 m
.99385 .26083 L
s
.25 Mabswid
0 .25708 m
1 .25708 L
s
.46418 .0121 m
.47043 .0121 L
s
[(-7.5)] .45168 .0121 1 0 Mshowa
.46418 .09376 m
.47043 .09376 L
s
[(-5)] .45168 .09376 1 0 Mshowa
.46418 .17542 m
.47043 .17542 L
s
[(-2.5)] .45168 .17542 1 0 Mshowa
.46418 .33874 m
.47043 .33874 L
s
[(2.5)] .45168 .33874 1 0 Mshowa
.46418 .4204 m
.47043 .4204 L
s
[(5)] .45168 .4204 1 0 Mshowa
.46418 .50206 m
.47043 .50206 L
s
[(7.5)] .45168 .50206 1 0 Mshowa
.46418 .58372 m
.47043 .58372 L
s
[(10)] .45168 .58372 1 0 Mshowa
.125 Mabswid
.46418 .02843 m
.46793 .02843 L
s
.46418 .04477 m
.46793 .04477 L
s
.46418 .0611 m
.46793 .0611 L
s
.46418 .07743 m
.46793 .07743 L
s
.46418 .11009 m
.46793 .11009 L
s
.46418 .12643 m
.46793 .12643 L
s
.46418 .14276 m
.46793 .14276 L
s
.46418 .15909 m
.46793 .15909 L
s
.46418 .19175 m
.46793 .19175 L
s
.46418 .20809 m
.46793 .20809 L
s
.46418 .22442 m
.46793 .22442 L
s
.46418 .24075 m
.46793 .24075 L
s
.46418 .27341 m
.46793 .27341 L
s
.46418 .28975 m
.46793 .28975 L
s
.46418 .30608 m
.46793 .30608 L
s
.46418 .32241 m
.46793 .32241 L
s
.46418 .35507 m
.46793 .35507 L
s
.46418 .37141 m
.46793 .37141 L
s
.46418 .38774 m
.46793 .38774 L
s
.46418 .40407 m
.46793 .40407 L
s
.46418 .43673 m
.46793 .43673 L
s
.46418 .45306 m
.46793 .45306 L
s
.46418 .4694 m
.46793 .4694 L
s
.46418 .48573 m
.46793 .48573 L
s
.46418 .51839 m
.46793 .51839 L
s
.46418 .53472 m
.46793 .53472 L
s
.46418 .55106 m
.46793 .55106 L
s
.46418 .56739 m
.46793 .56739 L
s
.46418 .60005 m
.46793 .60005 L
s
.46418 .61638 m
.46793 .61638 L
s
.25 Mabswid
.46418 0 m
.46418 .61803 L
s
.0001 w
.02381 .01472 -1.875 0 Mabsadd m
.02381 .01472 0 2.5 Mabsadd L
.02381 .01472 1.875 0 Mabsadd L
.02381 .01472 0 -2.5 Mabsadd L
.02381 .01472 -1.875 0 Mabsadd L closepath F
.07224 .02321 -1.875 0 Mabsadd m
.07224 .02321 0 2.5 Mabsadd L
.07224 .02321 1.875 0 Mabsadd L
.07224 .02321 0 -2.5 Mabsadd L
.07224 .02321 -1.875 0 Mabsadd L closepath F
.10755 .04019 -1.875 0 Mabsadd m
.10755 .04019 0 2.5 Mabsadd L
.10755 .04019 1.875 0 Mabsadd L
.10755 .04019 0 -2.5 Mabsadd L
.10755 .04019 -1.875 0 Mabsadd L closepath F
.11965 .04477 -1.875 0 Mabsadd m
.11965 .04477 0 2.5 Mabsadd L
.11965 .04477 1.875 0 Mabsadd L
.11965 .04477 0 -2.5 Mabsadd L
.11965 .04477 -1.875 0 Mabsadd L closepath F
.12369 .05391 -1.875 0 Mabsadd m
.12369 .05391 0 2.5 Mabsadd L
.12369 .05391 1.875 0 Mabsadd L
.12369 .05391 0 -2.5 Mabsadd L
.12369 .05391 -1.875 0 Mabsadd L closepath F
.12571 .05391 -1.875 0 Mabsadd m
.12571 .05391 0 2.5 Mabsadd L
.12571 .05391 1.875 0 Mabsadd L
.12571 .05391 0 -2.5 Mabsadd L
.12571 .05391 -1.875 0 Mabsadd L closepath F
.13529 .05424 -1.875 0 Mabsadd m
.13529 .05424 0 2.5 Mabsadd L
.13529 .05424 1.875 0 Mabsadd L
.13529 .05424 0 -2.5 Mabsadd L
.13529 .05424 -1.875 0 Mabsadd L closepath F
.13781 .05457 -1.875 0 Mabsadd m
.13781 .05457 0 2.5 Mabsadd L
.13781 .05457 1.875 0 Mabsadd L
.13781 .05457 0 -2.5 Mabsadd L
.13781 .05457 -1.875 0 Mabsadd L closepath F
.14134 .06763 -1.875 0 Mabsadd m
.14134 .06763 0 2.5 Mabsadd L
.14134 .06763 1.875 0 Mabsadd L
.14134 .06763 0 -2.5 Mabsadd L
.14134 .06763 -1.875 0 Mabsadd L closepath F
.15395 .06894 -1.875 0 Mabsadd m
.15395 .06894 0 2.5 Mabsadd L
.15395 .06894 1.875 0 Mabsadd L
.15395 .06894 0 -2.5 Mabsadd L
.15395 .06894 -1.875 0 Mabsadd L closepath F
.15395 .0709 -1.875 0 Mabsadd m
.15395 .0709 0 2.5 Mabsadd L
.15395 .0709 1.875 0 Mabsadd L
.15395 .0709 0 -2.5 Mabsadd L
.15395 .0709 -1.875 0 Mabsadd L closepath F
.15799 .07645 -1.875 0 Mabsadd m
.15799 .07645 0 2.5 Mabsadd L
.15799 .07645 1.875 0 Mabsadd L
.15799 .07645 0 -2.5 Mabsadd L
.15799 .07645 -1.875 0 Mabsadd L closepath F
.15799 .07743 -1.875 0 Mabsadd m
.15799 .07743 0 2.5 Mabsadd L
.15799 .07743 1.875 0 Mabsadd L
.15799 .07743 0 -2.5 Mabsadd L
.15799 .07743 -1.875 0 Mabsadd L closepath F
.16959 .07776 -1.875 0 Mabsadd m
.16959 .07776 0 2.5 Mabsadd L
.16959 .07776 1.875 0 Mabsadd L
.16959 .07776 0 -2.5 Mabsadd L
.16959 .07776 -1.875 0 Mabsadd L closepath F
.17565 .07808 -1.875 0 Mabsadd m
.17565 .07808 0 2.5 Mabsadd L
.17565 .07808 1.875 0 Mabsadd L
.17565 .07808 0 -2.5 Mabsadd L
.17565 .07808 -1.875 0 Mabsadd L closepath F
.17817 .07874 -1.875 0 Mabsadd m
.17817 .07874 0 2.5 Mabsadd L
.17817 .07874 1.875 0 Mabsadd L
.17817 .07874 0 -2.5 Mabsadd L
.17817 .07874 -1.875 0 Mabsadd L closepath F
.18019 .07972 -1.875 0 Mabsadd m
.18019 .07972 0 2.5 Mabsadd L
.18019 .07972 1.875 0 Mabsadd L
.18019 .07972 0 -2.5 Mabsadd L
.18019 .07972 -1.875 0 Mabsadd L closepath F
.18271 .08298 -1.875 0 Mabsadd m
.18271 .08298 0 2.5 Mabsadd L
.18271 .08298 1.875 0 Mabsadd L
.18271 .08298 0 -2.5 Mabsadd L
.18271 .08298 -1.875 0 Mabsadd L closepath F
.1928 .08331 -1.875 0 Mabsadd m
.1928 .08331 0 2.5 Mabsadd L
.1928 .08331 1.875 0 Mabsadd L
.1928 .08331 0 -2.5 Mabsadd L
.1928 .08331 -1.875 0 Mabsadd L closepath F
.1933 .08462 -1.875 0 Mabsadd m
.1933 .08462 0 2.5 Mabsadd L
.1933 .08462 1.875 0 Mabsadd L
.1933 .08462 0 -2.5 Mabsadd L
.1933 .08462 -1.875 0 Mabsadd L closepath F
.19381 .08592 -1.875 0 Mabsadd m
.19381 .08592 0 2.5 Mabsadd L
.19381 .08592 1.875 0 Mabsadd L
.19381 .08592 0 -2.5 Mabsadd L
.19381 .08592 -1.875 0 Mabsadd L closepath F
.19381 .08984 -1.875 0 Mabsadd m
.19381 .08984 0 2.5 Mabsadd L
.19381 .08984 1.875 0 Mabsadd L
.19381 .08984 0 -2.5 Mabsadd L
.19381 .08984 -1.875 0 Mabsadd L closepath F
.19582 .09115 -1.875 0 Mabsadd m
.19582 .09115 0 2.5 Mabsadd L
.19582 .09115 1.875 0 Mabsadd L
.19582 .09115 0 -2.5 Mabsadd L
.19582 .09115 -1.875 0 Mabsadd L closepath F
.19734 .09311 -1.875 0 Mabsadd m
.19734 .09311 0 2.5 Mabsadd L
.19734 .09311 1.875 0 Mabsadd L
.19734 .09311 0 -2.5 Mabsadd L
.19734 .09311 -1.875 0 Mabsadd L closepath F
.19784 .09637 -1.875 0 Mabsadd m
.19784 .09637 0 2.5 Mabsadd L
.19784 .09637 1.875 0 Mabsadd L
.19784 .09637 0 -2.5 Mabsadd L
.19784 .09637 -1.875 0 Mabsadd L closepath F
.19885 .09703 -1.875 0 Mabsadd m
.19885 .09703 0 2.5 Mabsadd L
.19885 .09703 1.875 0 Mabsadd L
.19885 .09703 0 -2.5 Mabsadd L
.19885 .09703 -1.875 0 Mabsadd L closepath F
.20188 .09703 -1.875 0 Mabsadd m
.20188 .09703 0 2.5 Mabsadd L
.20188 .09703 1.875 0 Mabsadd L
.20188 .09703 0 -2.5 Mabsadd L
.20188 .09703 -1.875 0 Mabsadd L closepath F
.20389 .10029 -1.875 0 Mabsadd m
.20389 .10029 0 2.5 Mabsadd L
.20389 .10029 1.875 0 Mabsadd L
.20389 .10029 0 -2.5 Mabsadd L
.20389 .10029 -1.875 0 Mabsadd L closepath F
.20944 .10225 -1.875 0 Mabsadd m
.20944 .10225 0 2.5 Mabsadd L
.20944 .10225 1.875 0 Mabsadd L
.20944 .10225 0 -2.5 Mabsadd L
.20944 .10225 -1.875 0 Mabsadd L closepath F
.21247 .10291 -1.875 0 Mabsadd m
.21247 .10291 0 2.5 Mabsadd L
.21247 .10291 1.875 0 Mabsadd L
.21247 .10291 0 -2.5 Mabsadd L
.21247 .10291 -1.875 0 Mabsadd L closepath F
.21247 .10323 -1.875 0 Mabsadd m
.21247 .10323 0 2.5 Mabsadd L
.21247 .10323 1.875 0 Mabsadd L
.21247 .10323 0 -2.5 Mabsadd L
.21247 .10323 -1.875 0 Mabsadd L closepath F
.21449 .10356 -1.875 0 Mabsadd m
.21449 .10356 0 2.5 Mabsadd L
.21449 .10356 1.875 0 Mabsadd L
.21449 .10356 0 -2.5 Mabsadd L
.21449 .10356 -1.875 0 Mabsadd L closepath F
.216 .10487 -1.875 0 Mabsadd m
.216 .10487 0 2.5 Mabsadd L
.216 .10487 1.875 0 Mabsadd L
.216 .10487 0 -2.5 Mabsadd L
.216 .10487 -1.875 0 Mabsadd L closepath F
.216 .10585 -1.875 0 Mabsadd m
.216 .10585 0 2.5 Mabsadd L
.216 .10585 1.875 0 Mabsadd L
.216 .10585 0 -2.5 Mabsadd L
.216 .10585 -1.875 0 Mabsadd L closepath F
.22004 .10748 -1.875 0 Mabsadd m
.22004 .10748 0 2.5 Mabsadd L
.22004 .10748 1.875 0 Mabsadd L
.22004 .10748 0 -2.5 Mabsadd L
.22004 .10748 -1.875 0 Mabsadd L closepath F
.22205 .11075 -1.875 0 Mabsadd m
.22205 .11075 0 2.5 Mabsadd L
.22205 .11075 1.875 0 Mabsadd L
.22205 .11075 0 -2.5 Mabsadd L
.22205 .11075 -1.875 0 Mabsadd L closepath F
.22357 .11205 -1.875 0 Mabsadd m
.22357 .11205 0 2.5 Mabsadd L
.22357 .11205 1.875 0 Mabsadd L
.22357 .11205 0 -2.5 Mabsadd L
.22357 .11205 -1.875 0 Mabsadd L closepath F
.22407 .11303 -1.875 0 Mabsadd m
.22407 .11303 0 2.5 Mabsadd L
.22407 .11303 1.875 0 Mabsadd L
.22407 .11303 0 -2.5 Mabsadd L
.22407 .11303 -1.875 0 Mabsadd L closepath F
.22559 .11336 -1.875 0 Mabsadd m
.22559 .11336 0 2.5 Mabsadd L
.22559 .11336 1.875 0 Mabsadd L
.22559 .11336 0 -2.5 Mabsadd L
.22559 .11336 -1.875 0 Mabsadd L closepath F
.2271 .11401 -1.875 0 Mabsadd m
.2271 .11401 0 2.5 Mabsadd L
.2271 .11401 1.875 0 Mabsadd L
.2271 .11401 0 -2.5 Mabsadd L
.2271 .11401 -1.875 0 Mabsadd L closepath F
.22962 .11434 -1.875 0 Mabsadd m
.22962 .11434 0 2.5 Mabsadd L
.22962 .11434 1.875 0 Mabsadd L
.22962 .11434 0 -2.5 Mabsadd L
.22962 .11434 -1.875 0 Mabsadd L closepath F
.23013 .11499 -1.875 0 Mabsadd m
.23013 .11499 0 2.5 Mabsadd L
.23013 .11499 1.875 0 Mabsadd L
.23013 .11499 0 -2.5 Mabsadd L
.23013 .11499 -1.875 0 Mabsadd L closepath F
.23113 .11532 -1.875 0 Mabsadd m
.23113 .11532 0 2.5 Mabsadd L
.23113 .11532 1.875 0 Mabsadd L
.23113 .11532 0 -2.5 Mabsadd L
.23113 .11532 -1.875 0 Mabsadd L closepath F
.23164 .11695 -1.875 0 Mabsadd m
.23164 .11695 0 2.5 Mabsadd L
.23164 .11695 1.875 0 Mabsadd L
.23164 .11695 0 -2.5 Mabsadd L
.23164 .11695 -1.875 0 Mabsadd L closepath F
.23214 .11728 -1.875 0 Mabsadd m
.23214 .11728 0 2.5 Mabsadd L
.23214 .11728 1.875 0 Mabsadd L
.23214 .11728 0 -2.5 Mabsadd L
.23214 .11728 -1.875 0 Mabsadd L closepath F
.23214 .11924 -1.875 0 Mabsadd m
.23214 .11924 0 2.5 Mabsadd L
.23214 .11924 1.875 0 Mabsadd L
.23214 .11924 0 -2.5 Mabsadd L
.23214 .11924 -1.875 0 Mabsadd L closepath F
.23265 .11989 -1.875 0 Mabsadd m
.23265 .11989 0 2.5 Mabsadd L
.23265 .11989 1.875 0 Mabsadd L
.23265 .11989 0 -2.5 Mabsadd L
.23265 .11989 -1.875 0 Mabsadd L closepath F
.23467 .11989 -1.875 0 Mabsadd m
.23467 .11989 0 2.5 Mabsadd L
.23467 .11989 1.875 0 Mabsadd L
.23467 .11989 0 -2.5 Mabsadd L
.23467 .11989 -1.875 0 Mabsadd L closepath F
.23719 .1212 -1.875 0 Mabsadd m
.23719 .1212 0 2.5 Mabsadd L
.23719 .1212 1.875 0 Mabsadd L
.23719 .1212 0 -2.5 Mabsadd L
.23719 .1212 -1.875 0 Mabsadd L closepath F
.23769 .12185 -1.875 0 Mabsadd m
.23769 .12185 0 2.5 Mabsadd L
.23769 .12185 1.875 0 Mabsadd L
.23769 .12185 0 -2.5 Mabsadd L
.23769 .12185 -1.875 0 Mabsadd L closepath F
.23769 .12251 -1.875 0 Mabsadd m
.23769 .12251 0 2.5 Mabsadd L
.23769 .12251 1.875 0 Mabsadd L
.23769 .12251 0 -2.5 Mabsadd L
.23769 .12251 -1.875 0 Mabsadd L closepath F
.24021 .12283 -1.875 0 Mabsadd m
.24021 .12283 0 2.5 Mabsadd L
.24021 .12283 1.875 0 Mabsadd L
.24021 .12283 0 -2.5 Mabsadd L
.24021 .12283 -1.875 0 Mabsadd L closepath F
.24072 .12447 -1.875 0 Mabsadd m
.24072 .12447 0 2.5 Mabsadd L
.24072 .12447 1.875 0 Mabsadd L
.24072 .12447 0 -2.5 Mabsadd L
.24072 .12447 -1.875 0 Mabsadd L closepath F
.24324 .12708 -1.875 0 Mabsadd m
.24324 .12708 0 2.5 Mabsadd L
.24324 .12708 1.875 0 Mabsadd L
.24324 .12708 0 -2.5 Mabsadd L
.24324 .12708 -1.875 0 Mabsadd L closepath F
.24374 .12839 -1.875 0 Mabsadd m
.24374 .12839 0 2.5 Mabsadd L
.24374 .12839 1.875 0 Mabsadd L
.24374 .12839 0 -2.5 Mabsadd L
.24374 .12839 -1.875 0 Mabsadd L closepath F
.24425 .12839 -1.875 0 Mabsadd m
.24425 .12839 0 2.5 Mabsadd L
.24425 .12839 1.875 0 Mabsadd L
.24425 .12839 0 -2.5 Mabsadd L
.24425 .12839 -1.875 0 Mabsadd L closepath F
.24627 .12839 -1.875 0 Mabsadd m
.24627 .12839 0 2.5 Mabsadd L
.24627 .12839 1.875 0 Mabsadd L
.24627 .12839 0 -2.5 Mabsadd L
.24627 .12839 -1.875 0 Mabsadd L closepath F
.2503 .12904 -1.875 0 Mabsadd m
.2503 .12904 0 2.5 Mabsadd L
.2503 .12904 1.875 0 Mabsadd L
.2503 .12904 0 -2.5 Mabsadd L
.2503 .12904 -1.875 0 Mabsadd L closepath F
.25081 .13067 -1.875 0 Mabsadd m
.25081 .13067 0 2.5 Mabsadd L
.25081 .13067 1.875 0 Mabsadd L
.25081 .13067 0 -2.5 Mabsadd L
.25081 .13067 -1.875 0 Mabsadd L closepath F
.25081 .131 -1.875 0 Mabsadd m
.25081 .131 0 2.5 Mabsadd L
.25081 .131 1.875 0 Mabsadd L
.25081 .131 0 -2.5 Mabsadd L
.25081 .131 -1.875 0 Mabsadd L closepath F
.25686 .131 -1.875 0 Mabsadd m
.25686 .131 0 2.5 Mabsadd L
.25686 .131 1.875 0 Mabsadd L
.25686 .131 0 -2.5 Mabsadd L
.25686 .131 -1.875 0 Mabsadd L closepath F
.25888 .13198 -1.875 0 Mabsadd m
.25888 .13198 0 2.5 Mabsadd L
.25888 .13198 1.875 0 Mabsadd L
.25888 .13198 0 -2.5 Mabsadd L
.25888 .13198 -1.875 0 Mabsadd L closepath F
.2609 .13329 -1.875 0 Mabsadd m
.2609 .13329 0 2.5 Mabsadd L
.2609 .13329 1.875 0 Mabsadd L
.2609 .13329 0 -2.5 Mabsadd L
.2609 .13329 -1.875 0 Mabsadd L closepath F
.26241 .13329 -1.875 0 Mabsadd m
.26241 .13329 0 2.5 Mabsadd L
.26241 .13329 1.875 0 Mabsadd L
.26241 .13329 0 -2.5 Mabsadd L
.26241 .13329 -1.875 0 Mabsadd L closepath F
.26342 .13427 -1.875 0 Mabsadd m
.26342 .13427 0 2.5 Mabsadd L
.26342 .13427 1.875 0 Mabsadd L
.26342 .13427 0 -2.5 Mabsadd L
.26342 .13427 -1.875 0 Mabsadd L closepath F
.26392 .13688 -1.875 0 Mabsadd m
.26392 .13688 0 2.5 Mabsadd L
.26392 .13688 1.875 0 Mabsadd L
.26392 .13688 0 -2.5 Mabsadd L
.26392 .13688 -1.875 0 Mabsadd L closepath F
.26493 .13786 -1.875 0 Mabsadd m
.26493 .13786 0 2.5 Mabsadd L
.26493 .13786 1.875 0 Mabsadd L
.26493 .13786 0 -2.5 Mabsadd L
.26493 .13786 -1.875 0 Mabsadd L closepath F
.26644 .13851 -1.875 0 Mabsadd m
.26644 .13851 0 2.5 Mabsadd L
.26644 .13851 1.875 0 Mabsadd L
.26644 .13851 0 -2.5 Mabsadd L
.26644 .13851 -1.875 0 Mabsadd L closepath F
.26695 .13916 -1.875 0 Mabsadd m
.26695 .13916 0 2.5 Mabsadd L
.26695 .13916 1.875 0 Mabsadd L
.26695 .13916 0 -2.5 Mabsadd L
.26695 .13916 -1.875 0 Mabsadd L closepath F
.26695 .14145 -1.875 0 Mabsadd m
.26695 .14145 0 2.5 Mabsadd L
.26695 .14145 1.875 0 Mabsadd L
.26695 .14145 0 -2.5 Mabsadd L
.26695 .14145 -1.875 0 Mabsadd L closepath F
.26745 .14276 -1.875 0 Mabsadd m
.26745 .14276 0 2.5 Mabsadd L
.26745 .14276 1.875 0 Mabsadd L
.26745 .14276 0 -2.5 Mabsadd L
.26745 .14276 -1.875 0 Mabsadd L closepath F
.26745 .14276 -1.875 0 Mabsadd m
.26745 .14276 0 2.5 Mabsadd L
.26745 .14276 1.875 0 Mabsadd L
.26745 .14276 0 -2.5 Mabsadd L
.26745 .14276 -1.875 0 Mabsadd L closepath F
.26947 .14341 -1.875 0 Mabsadd m
.26947 .14341 0 2.5 Mabsadd L
.26947 .14341 1.875 0 Mabsadd L
.26947 .14341 0 -2.5 Mabsadd L
.26947 .14341 -1.875 0 Mabsadd L closepath F
.2725 .14374 -1.875 0 Mabsadd m
.2725 .14374 0 2.5 Mabsadd L
.2725 .14374 1.875 0 Mabsadd L
.2725 .14374 0 -2.5 Mabsadd L
.2725 .14374 -1.875 0 Mabsadd L closepath F
.273 .14406 -1.875 0 Mabsadd m
.273 .14406 0 2.5 Mabsadd L
.273 .14406 1.875 0 Mabsadd L
.273 .14406 0 -2.5 Mabsadd L
.273 .14406 -1.875 0 Mabsadd L closepath F
.273 .14537 -1.875 0 Mabsadd m
.273 .14537 0 2.5 Mabsadd L
.273 .14537 1.875 0 Mabsadd L
.273 .14537 0 -2.5 Mabsadd L
.273 .14537 -1.875 0 Mabsadd L closepath F
.27351 .147 -1.875 0 Mabsadd m
.27351 .147 0 2.5 Mabsadd L
.27351 .147 1.875 0 Mabsadd L
.27351 .147 0 -2.5 Mabsadd L
.27351 .147 -1.875 0 Mabsadd L closepath F
.27351 .14766 -1.875 0 Mabsadd m
.27351 .14766 0 2.5 Mabsadd L
.27351 .14766 1.875 0 Mabsadd L
.27351 .14766 0 -2.5 Mabsadd L
.27351 .14766 -1.875 0 Mabsadd L closepath F
.27401 .14831 -1.875 0 Mabsadd m
.27401 .14831 0 2.5 Mabsadd L
.27401 .14831 1.875 0 Mabsadd L
.27401 .14831 0 -2.5 Mabsadd L
.27401 .14831 -1.875 0 Mabsadd L closepath F
.27452 .14929 -1.875 0 Mabsadd m
.27452 .14929 0 2.5 Mabsadd L
.27452 .14929 1.875 0 Mabsadd L
.27452 .14929 0 -2.5 Mabsadd L
.27452 .14929 -1.875 0 Mabsadd L closepath F
.27502 .15158 -1.875 0 Mabsadd m
.27502 .15158 0 2.5 Mabsadd L
.27502 .15158 1.875 0 Mabsadd L
.27502 .15158 0 -2.5 Mabsadd L
.27502 .15158 -1.875 0 Mabsadd L closepath F
.27502 .1519 -1.875 0 Mabsadd m
.27502 .1519 0 2.5 Mabsadd L
.27502 .1519 1.875 0 Mabsadd L
.27502 .1519 0 -2.5 Mabsadd L
.27502 .1519 -1.875 0 Mabsadd L closepath F
.27704 .1519 -1.875 0 Mabsadd m
.27704 .1519 0 2.5 Mabsadd L
.27704 .1519 1.875 0 Mabsadd L
.27704 .1519 0 -2.5 Mabsadd L
.27704 .1519 -1.875 0 Mabsadd L closepath F
.27805 .15256 -1.875 0 Mabsadd m
.27805 .15256 0 2.5 Mabsadd L
.27805 .15256 1.875 0 Mabsadd L
.27805 .15256 0 -2.5 Mabsadd L
.27805 .15256 -1.875 0 Mabsadd L closepath F
.27906 .15256 -1.875 0 Mabsadd m
.27906 .15256 0 2.5 Mabsadd L
.27906 .15256 1.875 0 Mabsadd L
.27906 .15256 0 -2.5 Mabsadd L
.27906 .15256 -1.875 0 Mabsadd L closepath F
.27956 .15419 -1.875 0 Mabsadd m
.27956 .15419 0 2.5 Mabsadd L
.27956 .15419 1.875 0 Mabsadd L
.27956 .15419 0 -2.5 Mabsadd L
.27956 .15419 -1.875 0 Mabsadd L closepath F
.28006 .15419 -1.875 0 Mabsadd m
.28006 .15419 0 2.5 Mabsadd L
.28006 .15419 1.875 0 Mabsadd L
.28006 .15419 0 -2.5 Mabsadd L
.28006 .15419 -1.875 0 Mabsadd L closepath F
.28057 .15484 -1.875 0 Mabsadd m
.28057 .15484 0 2.5 Mabsadd L
.28057 .15484 1.875 0 Mabsadd L
.28057 .15484 0 -2.5 Mabsadd L
.28057 .15484 -1.875 0 Mabsadd L closepath F
.28107 .15582 -1.875 0 Mabsadd m
.28107 .15582 0 2.5 Mabsadd L
.28107 .15582 1.875 0 Mabsadd L
.28107 .15582 0 -2.5 Mabsadd L
.28107 .15582 -1.875 0 Mabsadd L closepath F
.28158 .15615 -1.875 0 Mabsadd m
.28158 .15615 0 2.5 Mabsadd L
.28158 .15615 1.875 0 Mabsadd L
.28158 .15615 0 -2.5 Mabsadd L
.28158 .15615 -1.875 0 Mabsadd L closepath F
.28259 .15615 -1.875 0 Mabsadd m
.28259 .15615 0 2.5 Mabsadd L
.28259 .15615 1.875 0 Mabsadd L
.28259 .15615 0 -2.5 Mabsadd L
.28259 .15615 -1.875 0 Mabsadd L closepath F
.28259 .15648 -1.875 0 Mabsadd m
.28259 .15648 0 2.5 Mabsadd L
.28259 .15648 1.875 0 Mabsadd L
.28259 .15648 0 -2.5 Mabsadd L
.28259 .15648 -1.875 0 Mabsadd L closepath F
.2836 .1568 -1.875 0 Mabsadd m
.2836 .1568 0 2.5 Mabsadd L
.2836 .1568 1.875 0 Mabsadd L
.2836 .1568 0 -2.5 Mabsadd L
.2836 .1568 -1.875 0 Mabsadd L closepath F
.2846 .1568 -1.875 0 Mabsadd m
.2846 .1568 0 2.5 Mabsadd L
.2846 .1568 1.875 0 Mabsadd L
.2846 .1568 0 -2.5 Mabsadd L
.2846 .1568 -1.875 0 Mabsadd L closepath F
.28763 .15778 -1.875 0 Mabsadd m
.28763 .15778 0 2.5 Mabsadd L
.28763 .15778 1.875 0 Mabsadd L
.28763 .15778 0 -2.5 Mabsadd L
.28763 .15778 -1.875 0 Mabsadd L closepath F
.28814 .15844 -1.875 0 Mabsadd m
.28814 .15844 0 2.5 Mabsadd L
.28814 .15844 1.875 0 Mabsadd L
.28814 .15844 0 -2.5 Mabsadd L
.28814 .15844 -1.875 0 Mabsadd L closepath F
.28965 .15909 -1.875 0 Mabsadd m
.28965 .15909 0 2.5 Mabsadd L
.28965 .15909 1.875 0 Mabsadd L
.28965 .15909 0 -2.5 Mabsadd L
.28965 .15909 -1.875 0 Mabsadd L closepath F
.29015 .15909 -1.875 0 Mabsadd m
.29015 .15909 0 2.5 Mabsadd L
.29015 .15909 1.875 0 Mabsadd L
.29015 .15909 0 -2.5 Mabsadd L
.29015 .15909 -1.875 0 Mabsadd L closepath F
.29167 .15942 -1.875 0 Mabsadd m
.29167 .15942 0 2.5 Mabsadd L
.29167 .15942 1.875 0 Mabsadd L
.29167 .15942 0 -2.5 Mabsadd L
.29167 .15942 -1.875 0 Mabsadd L closepath F
.29268 .16007 -1.875 0 Mabsadd m
.29268 .16007 0 2.5 Mabsadd L
.29268 .16007 1.875 0 Mabsadd L
.29268 .16007 0 -2.5 Mabsadd L
.29268 .16007 -1.875 0 Mabsadd L closepath F
.29318 .16007 -1.875 0 Mabsadd m
.29318 .16007 0 2.5 Mabsadd L
.29318 .16007 1.875 0 Mabsadd L
.29318 .16007 0 -2.5 Mabsadd L
.29318 .16007 -1.875 0 Mabsadd L closepath F
.29368 .16105 -1.875 0 Mabsadd m
.29368 .16105 0 2.5 Mabsadd L
.29368 .16105 1.875 0 Mabsadd L
.29368 .16105 0 -2.5 Mabsadd L
.29368 .16105 -1.875 0 Mabsadd L closepath F
.29368 .16105 -1.875 0 Mabsadd m
.29368 .16105 0 2.5 Mabsadd L
.29368 .16105 1.875 0 Mabsadd L
.29368 .16105 0 -2.5 Mabsadd L
.29368 .16105 -1.875 0 Mabsadd L closepath F
.29419 .16138 -1.875 0 Mabsadd m
.29419 .16138 0 2.5 Mabsadd L
.29419 .16138 1.875 0 Mabsadd L
.29419 .16138 0 -2.5 Mabsadd L
.29419 .16138 -1.875 0 Mabsadd L closepath F
.29469 .1617 -1.875 0 Mabsadd m
.29469 .1617 0 2.5 Mabsadd L
.29469 .1617 1.875 0 Mabsadd L
.29469 .1617 0 -2.5 Mabsadd L
.29469 .1617 -1.875 0 Mabsadd L closepath F
.2952 .16268 -1.875 0 Mabsadd m
.2952 .16268 0 2.5 Mabsadd L
.2952 .16268 1.875 0 Mabsadd L
.2952 .16268 0 -2.5 Mabsadd L
.2952 .16268 -1.875 0 Mabsadd L closepath F
.29621 .16301 -1.875 0 Mabsadd m
.29621 .16301 0 2.5 Mabsadd L
.29621 .16301 1.875 0 Mabsadd L
.29621 .16301 0 -2.5 Mabsadd L
.29621 .16301 -1.875 0 Mabsadd L closepath F
.29671 .16301 -1.875 0 Mabsadd m
.29671 .16301 0 2.5 Mabsadd L
.29671 .16301 1.875 0 Mabsadd L
.29671 .16301 0 -2.5 Mabsadd L
.29671 .16301 -1.875 0 Mabsadd L closepath F
.29722 .16301 -1.875 0 Mabsadd m
.29722 .16301 0 2.5 Mabsadd L
.29722 .16301 1.875 0 Mabsadd L
.29722 .16301 0 -2.5 Mabsadd L
.29722 .16301 -1.875 0 Mabsadd L closepath F
.29822 .16464 -1.875 0 Mabsadd m
.29822 .16464 0 2.5 Mabsadd L
.29822 .16464 1.875 0 Mabsadd L
.29822 .16464 0 -2.5 Mabsadd L
.29822 .16464 -1.875 0 Mabsadd L closepath F
.29923 .1653 -1.875 0 Mabsadd m
.29923 .1653 0 2.5 Mabsadd L
.29923 .1653 1.875 0 Mabsadd L
.29923 .1653 0 -2.5 Mabsadd L
.29923 .1653 -1.875 0 Mabsadd L closepath F
.30024 .16628 -1.875 0 Mabsadd m
.30024 .16628 0 2.5 Mabsadd L
.30024 .16628 1.875 0 Mabsadd L
.30024 .16628 0 -2.5 Mabsadd L
.30024 .16628 -1.875 0 Mabsadd L closepath F
.30176 .16726 -1.875 0 Mabsadd m
.30176 .16726 0 2.5 Mabsadd L
.30176 .16726 1.875 0 Mabsadd L
.30176 .16726 0 -2.5 Mabsadd L
.30176 .16726 -1.875 0 Mabsadd L closepath F
.30176 .16726 -1.875 0 Mabsadd m
.30176 .16726 0 2.5 Mabsadd L
.30176 .16726 1.875 0 Mabsadd L
.30176 .16726 0 -2.5 Mabsadd L
.30176 .16726 -1.875 0 Mabsadd L closepath F
.30529 .16824 -1.875 0 Mabsadd m
.30529 .16824 0 2.5 Mabsadd L
.30529 .16824 1.875 0 Mabsadd L
.30529 .16824 0 -2.5 Mabsadd L
.30529 .16824 -1.875 0 Mabsadd L closepath F
.30529 .16856 -1.875 0 Mabsadd m
.30529 .16856 0 2.5 Mabsadd L
.30529 .16856 1.875 0 Mabsadd L
.30529 .16856 0 -2.5 Mabsadd L
.30529 .16856 -1.875 0 Mabsadd L closepath F
.30579 .16856 -1.875 0 Mabsadd m
.30579 .16856 0 2.5 Mabsadd L
.30579 .16856 1.875 0 Mabsadd L
.30579 .16856 0 -2.5 Mabsadd L
.30579 .16856 -1.875 0 Mabsadd L closepath F
.30579 .16922 -1.875 0 Mabsadd m
.30579 .16922 0 2.5 Mabsadd L
.30579 .16922 1.875 0 Mabsadd L
.30579 .16922 0 -2.5 Mabsadd L
.30579 .16922 -1.875 0 Mabsadd L closepath F
.3063 .16922 -1.875 0 Mabsadd m
.3063 .16922 0 2.5 Mabsadd L
.3063 .16922 1.875 0 Mabsadd L
.3063 .16922 0 -2.5 Mabsadd L
.3063 .16922 -1.875 0 Mabsadd L closepath F
.3068 .16922 -1.875 0 Mabsadd m
.3068 .16922 0 2.5 Mabsadd L
.3068 .16922 1.875 0 Mabsadd L
.3068 .16922 0 -2.5 Mabsadd L
.3068 .16922 -1.875 0 Mabsadd L closepath F
.3068 .16954 -1.875 0 Mabsadd m
.3068 .16954 0 2.5 Mabsadd L
.3068 .16954 1.875 0 Mabsadd L
.3068 .16954 0 -2.5 Mabsadd L
.3068 .16954 -1.875 0 Mabsadd L closepath F
.3073 .17085 -1.875 0 Mabsadd m
.3073 .17085 0 2.5 Mabsadd L
.3073 .17085 1.875 0 Mabsadd L
.3073 .17085 0 -2.5 Mabsadd L
.3073 .17085 -1.875 0 Mabsadd L closepath F
.30781 .1715 -1.875 0 Mabsadd m
.30781 .1715 0 2.5 Mabsadd L
.30781 .1715 1.875 0 Mabsadd L
.30781 .1715 0 -2.5 Mabsadd L
.30781 .1715 -1.875 0 Mabsadd L closepath F
.31084 .1715 -1.875 0 Mabsadd m
.31084 .1715 0 2.5 Mabsadd L
.31084 .1715 1.875 0 Mabsadd L
.31084 .1715 0 -2.5 Mabsadd L
.31084 .1715 -1.875 0 Mabsadd L closepath F
.31336 .17183 -1.875 0 Mabsadd m
.31336 .17183 0 2.5 Mabsadd L
.31336 .17183 1.875 0 Mabsadd L
.31336 .17183 0 -2.5 Mabsadd L
.31336 .17183 -1.875 0 Mabsadd L closepath F
.31437 .17216 -1.875 0 Mabsadd m
.31437 .17216 0 2.5 Mabsadd L
.31437 .17216 1.875 0 Mabsadd L
.31437 .17216 0 -2.5 Mabsadd L
.31437 .17216 -1.875 0 Mabsadd L closepath F
.31437 .17281 -1.875 0 Mabsadd m
.31437 .17281 0 2.5 Mabsadd L
.31437 .17281 1.875 0 Mabsadd L
.31437 .17281 0 -2.5 Mabsadd L
.31437 .17281 -1.875 0 Mabsadd L closepath F
.31538 .17314 -1.875 0 Mabsadd m
.31538 .17314 0 2.5 Mabsadd L
.31538 .17314 1.875 0 Mabsadd L
.31538 .17314 0 -2.5 Mabsadd L
.31538 .17314 -1.875 0 Mabsadd L closepath F
.31588 .17314 -1.875 0 Mabsadd m
.31588 .17314 0 2.5 Mabsadd L
.31588 .17314 1.875 0 Mabsadd L
.31588 .17314 0 -2.5 Mabsadd L
.31588 .17314 -1.875 0 Mabsadd L closepath F
.31588 .17346 -1.875 0 Mabsadd m
.31588 .17346 0 2.5 Mabsadd L
.31588 .17346 1.875 0 Mabsadd L
.31588 .17346 0 -2.5 Mabsadd L
.31588 .17346 -1.875 0 Mabsadd L closepath F
.31588 .17379 -1.875 0 Mabsadd m
.31588 .17379 0 2.5 Mabsadd L
.31588 .17379 1.875 0 Mabsadd L
.31588 .17379 0 -2.5 Mabsadd L
.31588 .17379 -1.875 0 Mabsadd L closepath F
.31689 .17379 -1.875 0 Mabsadd m
.31689 .17379 0 2.5 Mabsadd L
.31689 .17379 1.875 0 Mabsadd L
.31689 .17379 0 -2.5 Mabsadd L
.31689 .17379 -1.875 0 Mabsadd L closepath F
.31689 .17412 -1.875 0 Mabsadd m
.31689 .17412 0 2.5 Mabsadd L
.31689 .17412 1.875 0 Mabsadd L
.31689 .17412 0 -2.5 Mabsadd L
.31689 .17412 -1.875 0 Mabsadd L closepath F
.31689 .17412 -1.875 0 Mabsadd m
.31689 .17412 0 2.5 Mabsadd L
.31689 .17412 1.875 0 Mabsadd L
.31689 .17412 0 -2.5 Mabsadd L
.31689 .17412 -1.875 0 Mabsadd L closepath F
.3179 .17412 -1.875 0 Mabsadd m
.3179 .17412 0 2.5 Mabsadd L
.3179 .17412 1.875 0 Mabsadd L
.3179 .17412 0 -2.5 Mabsadd L
.3179 .17412 -1.875 0 Mabsadd L closepath F
.3184 .17444 -1.875 0 Mabsadd m
.3184 .17444 0 2.5 Mabsadd L
.3184 .17444 1.875 0 Mabsadd L
.3184 .17444 0 -2.5 Mabsadd L
.3184 .17444 -1.875 0 Mabsadd L closepath F
.31941 .17444 -1.875 0 Mabsadd m
.31941 .17444 0 2.5 Mabsadd L
.31941 .17444 1.875 0 Mabsadd L
.31941 .17444 0 -2.5 Mabsadd L
.31941 .17444 -1.875 0 Mabsadd L closepath F
.31992 .17444 -1.875 0 Mabsadd m
.31992 .17444 0 2.5 Mabsadd L
.31992 .17444 1.875 0 Mabsadd L
.31992 .17444 0 -2.5 Mabsadd L
.31992 .17444 -1.875 0 Mabsadd L closepath F
.32244 .17477 -1.875 0 Mabsadd m
.32244 .17477 0 2.5 Mabsadd L
.32244 .17477 1.875 0 Mabsadd L
.32244 .17477 0 -2.5 Mabsadd L
.32244 .17477 -1.875 0 Mabsadd L closepath F
.32395 .17477 -1.875 0 Mabsadd m
.32395 .17477 0 2.5 Mabsadd L
.32395 .17477 1.875 0 Mabsadd L
.32395 .17477 0 -2.5 Mabsadd L
.32395 .17477 -1.875 0 Mabsadd L closepath F
.32395 .17575 -1.875 0 Mabsadd m
.32395 .17575 0 2.5 Mabsadd L
.32395 .17575 1.875 0 Mabsadd L
.32395 .17575 0 -2.5 Mabsadd L
.32395 .17575 -1.875 0 Mabsadd L closepath F
.32395 .17607 -1.875 0 Mabsadd m
.32395 .17607 0 2.5 Mabsadd L
.32395 .17607 1.875 0 Mabsadd L
.32395 .17607 0 -2.5 Mabsadd L
.32395 .17607 -1.875 0 Mabsadd L closepath F
.32446 .1764 -1.875 0 Mabsadd m
.32446 .1764 0 2.5 Mabsadd L
.32446 .1764 1.875 0 Mabsadd L
.32446 .1764 0 -2.5 Mabsadd L
.32446 .1764 -1.875 0 Mabsadd L closepath F
.32496 .1764 -1.875 0 Mabsadd m
.32496 .1764 0 2.5 Mabsadd L
.32496 .1764 1.875 0 Mabsadd L
.32496 .1764 0 -2.5 Mabsadd L
.32496 .1764 -1.875 0 Mabsadd L closepath F
.32546 .1764 -1.875 0 Mabsadd m
.32546 .1764 0 2.5 Mabsadd L
.32546 .1764 1.875 0 Mabsadd L
.32546 .1764 0 -2.5 Mabsadd L
.32546 .1764 -1.875 0 Mabsadd L closepath F
.32597 .1764 -1.875 0 Mabsadd m
.32597 .1764 0 2.5 Mabsadd L
.32597 .1764 1.875 0 Mabsadd L
.32597 .1764 0 -2.5 Mabsadd L
.32597 .1764 -1.875 0 Mabsadd L closepath F
.32647 .17705 -1.875 0 Mabsadd m
.32647 .17705 0 2.5 Mabsadd L
.32647 .17705 1.875 0 Mabsadd L
.32647 .17705 0 -2.5 Mabsadd L
.32647 .17705 -1.875 0 Mabsadd L closepath F
.32698 .17738 -1.875 0 Mabsadd m
.32698 .17738 0 2.5 Mabsadd L
.32698 .17738 1.875 0 Mabsadd L
.32698 .17738 0 -2.5 Mabsadd L
.32698 .17738 -1.875 0 Mabsadd L closepath F
.32748 .17803 -1.875 0 Mabsadd m
.32748 .17803 0 2.5 Mabsadd L
.32748 .17803 1.875 0 Mabsadd L
.32748 .17803 0 -2.5 Mabsadd L
.32748 .17803 -1.875 0 Mabsadd L closepath F
.32799 .17836 -1.875 0 Mabsadd m
.32799 .17836 0 2.5 Mabsadd L
.32799 .17836 1.875 0 Mabsadd L
.32799 .17836 0 -2.5 Mabsadd L
.32799 .17836 -1.875 0 Mabsadd L closepath F
.32849 .17836 -1.875 0 Mabsadd m
.32849 .17836 0 2.5 Mabsadd L
.32849 .17836 1.875 0 Mabsadd L
.32849 .17836 0 -2.5 Mabsadd L
.32849 .17836 -1.875 0 Mabsadd L closepath F
.329 .17869 -1.875 0 Mabsadd m
.329 .17869 0 2.5 Mabsadd L
.329 .17869 1.875 0 Mabsadd L
.329 .17869 0 -2.5 Mabsadd L
.329 .17869 -1.875 0 Mabsadd L closepath F
.3295 .17934 -1.875 0 Mabsadd m
.3295 .17934 0 2.5 Mabsadd L
.3295 .17934 1.875 0 Mabsadd L
.3295 .17934 0 -2.5 Mabsadd L
.3295 .17934 -1.875 0 Mabsadd L closepath F
.33 .17934 -1.875 0 Mabsadd m
.33 .17934 0 2.5 Mabsadd L
.33 .17934 1.875 0 Mabsadd L
.33 .17934 0 -2.5 Mabsadd L
.33 .17934 -1.875 0 Mabsadd L closepath F
.33051 .17967 -1.875 0 Mabsadd m
.33051 .17967 0 2.5 Mabsadd L
.33051 .17967 1.875 0 Mabsadd L
.33051 .17967 0 -2.5 Mabsadd L
.33051 .17967 -1.875 0 Mabsadd L closepath F
.33253 .18032 -1.875 0 Mabsadd m
.33253 .18032 0 2.5 Mabsadd L
.33253 .18032 1.875 0 Mabsadd L
.33253 .18032 0 -2.5 Mabsadd L
.33253 .18032 -1.875 0 Mabsadd L closepath F
.33253 .18065 -1.875 0 Mabsadd m
.33253 .18065 0 2.5 Mabsadd L
.33253 .18065 1.875 0 Mabsadd L
.33253 .18065 0 -2.5 Mabsadd L
.33253 .18065 -1.875 0 Mabsadd L closepath F
.33253 .1813 -1.875 0 Mabsadd m
.33253 .1813 0 2.5 Mabsadd L
.33253 .1813 1.875 0 Mabsadd L
.33253 .1813 0 -2.5 Mabsadd L
.33253 .1813 -1.875 0 Mabsadd L closepath F
.33253 .18195 -1.875 0 Mabsadd m
.33253 .18195 0 2.5 Mabsadd L
.33253 .18195 1.875 0 Mabsadd L
.33253 .18195 0 -2.5 Mabsadd L
.33253 .18195 -1.875 0 Mabsadd L closepath F
.33303 .18261 -1.875 0 Mabsadd m
.33303 .18261 0 2.5 Mabsadd L
.33303 .18261 1.875 0 Mabsadd L
.33303 .18261 0 -2.5 Mabsadd L
.33303 .18261 -1.875 0 Mabsadd L closepath F
.33303 .18293 -1.875 0 Mabsadd m
.33303 .18293 0 2.5 Mabsadd L
.33303 .18293 1.875 0 Mabsadd L
.33303 .18293 0 -2.5 Mabsadd L
.33303 .18293 -1.875 0 Mabsadd L closepath F
.33454 .18326 -1.875 0 Mabsadd m
.33454 .18326 0 2.5 Mabsadd L
.33454 .18326 1.875 0 Mabsadd L
.33454 .18326 0 -2.5 Mabsadd L
.33454 .18326 -1.875 0 Mabsadd L closepath F
.33505 .18424 -1.875 0 Mabsadd m
.33505 .18424 0 2.5 Mabsadd L
.33505 .18424 1.875 0 Mabsadd L
.33505 .18424 0 -2.5 Mabsadd L
.33505 .18424 -1.875 0 Mabsadd L closepath F
.33606 .18457 -1.875 0 Mabsadd m
.33606 .18457 0 2.5 Mabsadd L
.33606 .18457 1.875 0 Mabsadd L
.33606 .18457 0 -2.5 Mabsadd L
.33606 .18457 -1.875 0 Mabsadd L closepath F
.33656 .18489 -1.875 0 Mabsadd m
.33656 .18489 0 2.5 Mabsadd L
.33656 .18489 1.875 0 Mabsadd L
.33656 .18489 0 -2.5 Mabsadd L
.33656 .18489 -1.875 0 Mabsadd L closepath F
.33656 .18489 -1.875 0 Mabsadd m
.33656 .18489 0 2.5 Mabsadd L
.33656 .18489 1.875 0 Mabsadd L
.33656 .18489 0 -2.5 Mabsadd L
.33656 .18489 -1.875 0 Mabsadd L closepath F
.33656 .18522 -1.875 0 Mabsadd m
.33656 .18522 0 2.5 Mabsadd L
.33656 .18522 1.875 0 Mabsadd L
.33656 .18522 0 -2.5 Mabsadd L
.33656 .18522 -1.875 0 Mabsadd L closepath F
.33656 .18555 -1.875 0 Mabsadd m
.33656 .18555 0 2.5 Mabsadd L
.33656 .18555 1.875 0 Mabsadd L
.33656 .18555 0 -2.5 Mabsadd L
.33656 .18555 -1.875 0 Mabsadd L closepath F
.33707 .1862 -1.875 0 Mabsadd m
.33707 .1862 0 2.5 Mabsadd L
.33707 .1862 1.875 0 Mabsadd L
.33707 .1862 0 -2.5 Mabsadd L
.33707 .1862 -1.875 0 Mabsadd L closepath F
.33707 .1862 -1.875 0 Mabsadd m
.33707 .1862 0 2.5 Mabsadd L
.33707 .1862 1.875 0 Mabsadd L
.33707 .1862 0 -2.5 Mabsadd L
.33707 .1862 -1.875 0 Mabsadd L closepath F
.33757 .18653 -1.875 0 Mabsadd m
.33757 .18653 0 2.5 Mabsadd L
.33757 .18653 1.875 0 Mabsadd L
.33757 .18653 0 -2.5 Mabsadd L
.33757 .18653 -1.875 0 Mabsadd L closepath F
.33757 .18653 -1.875 0 Mabsadd m
.33757 .18653 0 2.5 Mabsadd L
.33757 .18653 1.875 0 Mabsadd L
.33757 .18653 0 -2.5 Mabsadd L
.33757 .18653 -1.875 0 Mabsadd L closepath F
.3406 .18653 -1.875 0 Mabsadd m
.3406 .18653 0 2.5 Mabsadd L
.3406 .18653 1.875 0 Mabsadd L
.3406 .18653 0 -2.5 Mabsadd L
.3406 .18653 -1.875 0 Mabsadd L closepath F
.3411 .18653 -1.875 0 Mabsadd m
.3411 .18653 0 2.5 Mabsadd L
.3411 .18653 1.875 0 Mabsadd L
.3411 .18653 0 -2.5 Mabsadd L
.3411 .18653 -1.875 0 Mabsadd L closepath F
.34211 .18653 -1.875 0 Mabsadd m
.34211 .18653 0 2.5 Mabsadd L
.34211 .18653 1.875 0 Mabsadd L
.34211 .18653 0 -2.5 Mabsadd L
.34211 .18653 -1.875 0 Mabsadd L closepath F
.34262 .18685 -1.875 0 Mabsadd m
.34262 .18685 0 2.5 Mabsadd L
.34262 .18685 1.875 0 Mabsadd L
.34262 .18685 0 -2.5 Mabsadd L
.34262 .18685 -1.875 0 Mabsadd L closepath F
.34463 .18718 -1.875 0 Mabsadd m
.34463 .18718 0 2.5 Mabsadd L
.34463 .18718 1.875 0 Mabsadd L
.34463 .18718 0 -2.5 Mabsadd L
.34463 .18718 -1.875 0 Mabsadd L closepath F
.34463 .18751 -1.875 0 Mabsadd m
.34463 .18751 0 2.5 Mabsadd L
.34463 .18751 1.875 0 Mabsadd L
.34463 .18751 0 -2.5 Mabsadd L
.34463 .18751 -1.875 0 Mabsadd L closepath F
.34463 .18783 -1.875 0 Mabsadd m
.34463 .18783 0 2.5 Mabsadd L
.34463 .18783 1.875 0 Mabsadd L
.34463 .18783 0 -2.5 Mabsadd L
.34463 .18783 -1.875 0 Mabsadd L closepath F
.34463 .18816 -1.875 0 Mabsadd m
.34463 .18816 0 2.5 Mabsadd L
.34463 .18816 1.875 0 Mabsadd L
.34463 .18816 0 -2.5 Mabsadd L
.34463 .18816 -1.875 0 Mabsadd L closepath F
.34463 .18849 -1.875 0 Mabsadd m
.34463 .18849 0 2.5 Mabsadd L
.34463 .18849 1.875 0 Mabsadd L
.34463 .18849 0 -2.5 Mabsadd L
.34463 .18849 -1.875 0 Mabsadd L closepath F
.34514 .18881 -1.875 0 Mabsadd m
.34514 .18881 0 2.5 Mabsadd L
.34514 .18881 1.875 0 Mabsadd L
.34514 .18881 0 -2.5 Mabsadd L
.34514 .18881 -1.875 0 Mabsadd L closepath F
.34564 .18881 -1.875 0 Mabsadd m
.34564 .18881 0 2.5 Mabsadd L
.34564 .18881 1.875 0 Mabsadd L
.34564 .18881 0 -2.5 Mabsadd L
.34564 .18881 -1.875 0 Mabsadd L closepath F
.34564 .18914 -1.875 0 Mabsadd m
.34564 .18914 0 2.5 Mabsadd L
.34564 .18914 1.875 0 Mabsadd L
.34564 .18914 0 -2.5 Mabsadd L
.34564 .18914 -1.875 0 Mabsadd L closepath F
.34615 .18947 -1.875 0 Mabsadd m
.34615 .18947 0 2.5 Mabsadd L
.34615 .18947 1.875 0 Mabsadd L
.34615 .18947 0 -2.5 Mabsadd L
.34615 .18947 -1.875 0 Mabsadd L closepath F
.34665 .18979 -1.875 0 Mabsadd m
.34665 .18979 0 2.5 Mabsadd L
.34665 .18979 1.875 0 Mabsadd L
.34665 .18979 0 -2.5 Mabsadd L
.34665 .18979 -1.875 0 Mabsadd L closepath F
.34816 .18979 -1.875 0 Mabsadd m
.34816 .18979 0 2.5 Mabsadd L
.34816 .18979 1.875 0 Mabsadd L
.34816 .18979 0 -2.5 Mabsadd L
.34816 .18979 -1.875 0 Mabsadd L closepath F
.34816 .19077 -1.875 0 Mabsadd m
.34816 .19077 0 2.5 Mabsadd L
.34816 .19077 1.875 0 Mabsadd L
.34816 .19077 0 -2.5 Mabsadd L
.34816 .19077 -1.875 0 Mabsadd L closepath F
.34816 .19143 -1.875 0 Mabsadd m
.34816 .19143 0 2.5 Mabsadd L
.34816 .19143 1.875 0 Mabsadd L
.34816 .19143 0 -2.5 Mabsadd L
.34816 .19143 -1.875 0 Mabsadd L closepath F
.34917 .19175 -1.875 0 Mabsadd m
.34917 .19175 0 2.5 Mabsadd L
.34917 .19175 1.875 0 Mabsadd L
.34917 .19175 0 -2.5 Mabsadd L
.34917 .19175 -1.875 0 Mabsadd L closepath F
.34917 .19175 -1.875 0 Mabsadd m
.34917 .19175 0 2.5 Mabsadd L
.34917 .19175 1.875 0 Mabsadd L
.34917 .19175 0 -2.5 Mabsadd L
.34917 .19175 -1.875 0 Mabsadd L closepath F
.35018 .19208 -1.875 0 Mabsadd m
.35018 .19208 0 2.5 Mabsadd L
.35018 .19208 1.875 0 Mabsadd L
.35018 .19208 0 -2.5 Mabsadd L
.35018 .19208 -1.875 0 Mabsadd L closepath F
.35069 .19241 -1.875 0 Mabsadd m
.35069 .19241 0 2.5 Mabsadd L
.35069 .19241 1.875 0 Mabsadd L
.35069 .19241 0 -2.5 Mabsadd L
.35069 .19241 -1.875 0 Mabsadd L closepath F
.35119 .19306 -1.875 0 Mabsadd m
.35119 .19306 0 2.5 Mabsadd L
.35119 .19306 1.875 0 Mabsadd L
.35119 .19306 0 -2.5 Mabsadd L
.35119 .19306 -1.875 0 Mabsadd L closepath F
.35169 .19339 -1.875 0 Mabsadd m
.35169 .19339 0 2.5 Mabsadd L
.35169 .19339 1.875 0 Mabsadd L
.35169 .19339 0 -2.5 Mabsadd L
.35169 .19339 -1.875 0 Mabsadd L closepath F
.35169 .19371 -1.875 0 Mabsadd m
.35169 .19371 0 2.5 Mabsadd L
.35169 .19371 1.875 0 Mabsadd L
.35169 .19371 0 -2.5 Mabsadd L
.35169 .19371 -1.875 0 Mabsadd L closepath F
.35321 .19437 -1.875 0 Mabsadd m
.35321 .19437 0 2.5 Mabsadd L
.35321 .19437 1.875 0 Mabsadd L
.35321 .19437 0 -2.5 Mabsadd L
.35321 .19437 -1.875 0 Mabsadd L closepath F
.35321 .19502 -1.875 0 Mabsadd m
.35321 .19502 0 2.5 Mabsadd L
.35321 .19502 1.875 0 Mabsadd L
.35321 .19502 0 -2.5 Mabsadd L
.35321 .19502 -1.875 0 Mabsadd L closepath F
.35371 .19535 -1.875 0 Mabsadd m
.35371 .19535 0 2.5 Mabsadd L
.35371 .19535 1.875 0 Mabsadd L
.35371 .19535 0 -2.5 Mabsadd L
.35371 .19535 -1.875 0 Mabsadd L closepath F
.35472 .19535 -1.875 0 Mabsadd m
.35472 .19535 0 2.5 Mabsadd L
.35472 .19535 1.875 0 Mabsadd L
.35472 .19535 0 -2.5 Mabsadd L
.35472 .19535 -1.875 0 Mabsadd L closepath F
.35573 .19535 -1.875 0 Mabsadd m
.35573 .19535 0 2.5 Mabsadd L
.35573 .19535 1.875 0 Mabsadd L
.35573 .19535 0 -2.5 Mabsadd L
.35573 .19535 -1.875 0 Mabsadd L closepath F
.35573 .19535 -1.875 0 Mabsadd m
.35573 .19535 0 2.5 Mabsadd L
.35573 .19535 1.875 0 Mabsadd L
.35573 .19535 0 -2.5 Mabsadd L
.35573 .19535 -1.875 0 Mabsadd L closepath F
.35573 .19567 -1.875 0 Mabsadd m
.35573 .19567 0 2.5 Mabsadd L
.35573 .19567 1.875 0 Mabsadd L
.35573 .19567 0 -2.5 Mabsadd L
.35573 .19567 -1.875 0 Mabsadd L closepath F
.35674 .196 -1.875 0 Mabsadd m
.35674 .196 0 2.5 Mabsadd L
.35674 .196 1.875 0 Mabsadd L
.35674 .196 0 -2.5 Mabsadd L
.35674 .196 -1.875 0 Mabsadd L closepath F
.35724 .196 -1.875 0 Mabsadd m
.35724 .196 0 2.5 Mabsadd L
.35724 .196 1.875 0 Mabsadd L
.35724 .196 0 -2.5 Mabsadd L
.35724 .196 -1.875 0 Mabsadd L closepath F
.35724 .19633 -1.875 0 Mabsadd m
.35724 .19633 0 2.5 Mabsadd L
.35724 .19633 1.875 0 Mabsadd L
.35724 .19633 0 -2.5 Mabsadd L
.35724 .19633 -1.875 0 Mabsadd L closepath F
.35775 .19633 -1.875 0 Mabsadd m
.35775 .19633 0 2.5 Mabsadd L
.35775 .19633 1.875 0 Mabsadd L
.35775 .19633 0 -2.5 Mabsadd L
.35775 .19633 -1.875 0 Mabsadd L closepath F
.35825 .19665 -1.875 0 Mabsadd m
.35825 .19665 0 2.5 Mabsadd L
.35825 .19665 1.875 0 Mabsadd L
.35825 .19665 0 -2.5 Mabsadd L
.35825 .19665 -1.875 0 Mabsadd L closepath F
.35876 .19698 -1.875 0 Mabsadd m
.35876 .19698 0 2.5 Mabsadd L
.35876 .19698 1.875 0 Mabsadd L
.35876 .19698 0 -2.5 Mabsadd L
.35876 .19698 -1.875 0 Mabsadd L closepath F
.35876 .19796 -1.875 0 Mabsadd m
.35876 .19796 0 2.5 Mabsadd L
.35876 .19796 1.875 0 Mabsadd L
.35876 .19796 0 -2.5 Mabsadd L
.35876 .19796 -1.875 0 Mabsadd L closepath F
.35876 .19861 -1.875 0 Mabsadd m
.35876 .19861 0 2.5 Mabsadd L
.35876 .19861 1.875 0 Mabsadd L
.35876 .19861 0 -2.5 Mabsadd L
.35876 .19861 -1.875 0 Mabsadd L closepath F
.35926 .19861 -1.875 0 Mabsadd m
.35926 .19861 0 2.5 Mabsadd L
.35926 .19861 1.875 0 Mabsadd L
.35926 .19861 0 -2.5 Mabsadd L
.35926 .19861 -1.875 0 Mabsadd L closepath F
.35926 .19894 -1.875 0 Mabsadd m
.35926 .19894 0 2.5 Mabsadd L
.35926 .19894 1.875 0 Mabsadd L
.35926 .19894 0 -2.5 Mabsadd L
.35926 .19894 -1.875 0 Mabsadd L closepath F
.35977 .19894 -1.875 0 Mabsadd m
.35977 .19894 0 2.5 Mabsadd L
.35977 .19894 1.875 0 Mabsadd L
.35977 .19894 0 -2.5 Mabsadd L
.35977 .19894 -1.875 0 Mabsadd L closepath F
.36027 .19894 -1.875 0 Mabsadd m
.36027 .19894 0 2.5 Mabsadd L
.36027 .19894 1.875 0 Mabsadd L
.36027 .19894 0 -2.5 Mabsadd L
.36027 .19894 -1.875 0 Mabsadd L closepath F
.36027 .19927 -1.875 0 Mabsadd m
.36027 .19927 0 2.5 Mabsadd L
.36027 .19927 1.875 0 Mabsadd L
.36027 .19927 0 -2.5 Mabsadd L
.36027 .19927 -1.875 0 Mabsadd L closepath F
.36077 .19927 -1.875 0 Mabsadd m
.36077 .19927 0 2.5 Mabsadd L
.36077 .19927 1.875 0 Mabsadd L
.36077 .19927 0 -2.5 Mabsadd L
.36077 .19927 -1.875 0 Mabsadd L closepath F
.36178 .19992 -1.875 0 Mabsadd m
.36178 .19992 0 2.5 Mabsadd L
.36178 .19992 1.875 0 Mabsadd L
.36178 .19992 0 -2.5 Mabsadd L
.36178 .19992 -1.875 0 Mabsadd L closepath F
.36279 .19992 -1.875 0 Mabsadd m
.36279 .19992 0 2.5 Mabsadd L
.36279 .19992 1.875 0 Mabsadd L
.36279 .19992 0 -2.5 Mabsadd L
.36279 .19992 -1.875 0 Mabsadd L closepath F
.3633 .20025 -1.875 0 Mabsadd m
.3633 .20025 0 2.5 Mabsadd L
.3633 .20025 1.875 0 Mabsadd L
.3633 .20025 0 -2.5 Mabsadd L
.3633 .20025 -1.875 0 Mabsadd L closepath F
.3633 .20057 -1.875 0 Mabsadd m
.3633 .20057 0 2.5 Mabsadd L
.3633 .20057 1.875 0 Mabsadd L
.3633 .20057 0 -2.5 Mabsadd L
.3633 .20057 -1.875 0 Mabsadd L closepath F
.3638 .2009 -1.875 0 Mabsadd m
.3638 .2009 0 2.5 Mabsadd L
.3638 .2009 1.875 0 Mabsadd L
.3638 .2009 0 -2.5 Mabsadd L
.3638 .2009 -1.875 0 Mabsadd L closepath F
.3638 .2009 -1.875 0 Mabsadd m
.3638 .2009 0 2.5 Mabsadd L
.3638 .2009 1.875 0 Mabsadd L
.3638 .2009 0 -2.5 Mabsadd L
.3638 .2009 -1.875 0 Mabsadd L closepath F
.3638 .20123 -1.875 0 Mabsadd m
.3638 .20123 0 2.5 Mabsadd L
.3638 .20123 1.875 0 Mabsadd L
.3638 .20123 0 -2.5 Mabsadd L
.3638 .20123 -1.875 0 Mabsadd L closepath F
.36431 .20123 -1.875 0 Mabsadd m
.36431 .20123 0 2.5 Mabsadd L
.36431 .20123 1.875 0 Mabsadd L
.36431 .20123 0 -2.5 Mabsadd L
.36431 .20123 -1.875 0 Mabsadd L closepath F
.36481 .20123 -1.875 0 Mabsadd m
.36481 .20123 0 2.5 Mabsadd L
.36481 .20123 1.875 0 Mabsadd L
.36481 .20123 0 -2.5 Mabsadd L
.36481 .20123 -1.875 0 Mabsadd L closepath F
.36481 .20155 -1.875 0 Mabsadd m
.36481 .20155 0 2.5 Mabsadd L
.36481 .20155 1.875 0 Mabsadd L
.36481 .20155 0 -2.5 Mabsadd L
.36481 .20155 -1.875 0 Mabsadd L closepath F
.36632 .20221 -1.875 0 Mabsadd m
.36632 .20221 0 2.5 Mabsadd L
.36632 .20221 1.875 0 Mabsadd L
.36632 .20221 0 -2.5 Mabsadd L
.36632 .20221 -1.875 0 Mabsadd L closepath F
.36632 .20253 -1.875 0 Mabsadd m
.36632 .20253 0 2.5 Mabsadd L
.36632 .20253 1.875 0 Mabsadd L
.36632 .20253 0 -2.5 Mabsadd L
.36632 .20253 -1.875 0 Mabsadd L closepath F
.36733 .20253 -1.875 0 Mabsadd m
.36733 .20253 0 2.5 Mabsadd L
.36733 .20253 1.875 0 Mabsadd L
.36733 .20253 0 -2.5 Mabsadd L
.36733 .20253 -1.875 0 Mabsadd L closepath F
.36733 .20253 -1.875 0 Mabsadd m
.36733 .20253 0 2.5 Mabsadd L
.36733 .20253 1.875 0 Mabsadd L
.36733 .20253 0 -2.5 Mabsadd L
.36733 .20253 -1.875 0 Mabsadd L closepath F
.36733 .20319 -1.875 0 Mabsadd m
.36733 .20319 0 2.5 Mabsadd L
.36733 .20319 1.875 0 Mabsadd L
.36733 .20319 0 -2.5 Mabsadd L
.36733 .20319 -1.875 0 Mabsadd L closepath F
.36784 .20319 -1.875 0 Mabsadd m
.36784 .20319 0 2.5 Mabsadd L
.36784 .20319 1.875 0 Mabsadd L
.36784 .20319 0 -2.5 Mabsadd L
.36784 .20319 -1.875 0 Mabsadd L closepath F
.36834 .20351 -1.875 0 Mabsadd m
.36834 .20351 0 2.5 Mabsadd L
.36834 .20351 1.875 0 Mabsadd L
.36834 .20351 0 -2.5 Mabsadd L
.36834 .20351 -1.875 0 Mabsadd L closepath F
.36834 .20351 -1.875 0 Mabsadd m
.36834 .20351 0 2.5 Mabsadd L
.36834 .20351 1.875 0 Mabsadd L
.36834 .20351 0 -2.5 Mabsadd L
.36834 .20351 -1.875 0 Mabsadd L closepath F
.36885 .20351 -1.875 0 Mabsadd m
.36885 .20351 0 2.5 Mabsadd L
.36885 .20351 1.875 0 Mabsadd L
.36885 .20351 0 -2.5 Mabsadd L
.36885 .20351 -1.875 0 Mabsadd L closepath F
.36885 .20384 -1.875 0 Mabsadd m
.36885 .20384 0 2.5 Mabsadd L
.36885 .20384 1.875 0 Mabsadd L
.36885 .20384 0 -2.5 Mabsadd L
.36885 .20384 -1.875 0 Mabsadd L closepath F
.36935 .20449 -1.875 0 Mabsadd m
.36935 .20449 0 2.5 Mabsadd L
.36935 .20449 1.875 0 Mabsadd L
.36935 .20449 0 -2.5 Mabsadd L
.36935 .20449 -1.875 0 Mabsadd L closepath F
.36985 .20515 -1.875 0 Mabsadd m
.36985 .20515 0 2.5 Mabsadd L
.36985 .20515 1.875 0 Mabsadd L
.36985 .20515 0 -2.5 Mabsadd L
.36985 .20515 -1.875 0 Mabsadd L closepath F
.36985 .20515 -1.875 0 Mabsadd m
.36985 .20515 0 2.5 Mabsadd L
.36985 .20515 1.875 0 Mabsadd L
.36985 .20515 0 -2.5 Mabsadd L
.36985 .20515 -1.875 0 Mabsadd L closepath F
.37036 .20547 -1.875 0 Mabsadd m
.37036 .20547 0 2.5 Mabsadd L
.37036 .20547 1.875 0 Mabsadd L
.37036 .20547 0 -2.5 Mabsadd L
.37036 .20547 -1.875 0 Mabsadd L closepath F
.37086 .20547 -1.875 0 Mabsadd m
.37086 .20547 0 2.5 Mabsadd L
.37086 .20547 1.875 0 Mabsadd L
.37086 .20547 0 -2.5 Mabsadd L
.37086 .20547 -1.875 0 Mabsadd L closepath F
.37086 .20547 -1.875 0 Mabsadd m
.37086 .20547 0 2.5 Mabsadd L
.37086 .20547 1.875 0 Mabsadd L
.37086 .20547 0 -2.5 Mabsadd L
.37086 .20547 -1.875 0 Mabsadd L closepath F
.37086 .20613 -1.875 0 Mabsadd m
.37086 .20613 0 2.5 Mabsadd L
.37086 .20613 1.875 0 Mabsadd L
.37086 .20613 0 -2.5 Mabsadd L
.37086 .20613 -1.875 0 Mabsadd L closepath F
.37137 .20678 -1.875 0 Mabsadd m
.37137 .20678 0 2.5 Mabsadd L
.37137 .20678 1.875 0 Mabsadd L
.37137 .20678 0 -2.5 Mabsadd L
.37137 .20678 -1.875 0 Mabsadd L closepath F
.37187 .20711 -1.875 0 Mabsadd m
.37187 .20711 0 2.5 Mabsadd L
.37187 .20711 1.875 0 Mabsadd L
.37187 .20711 0 -2.5 Mabsadd L
.37187 .20711 -1.875 0 Mabsadd L closepath F
.37238 .20743 -1.875 0 Mabsadd m
.37238 .20743 0 2.5 Mabsadd L
.37238 .20743 1.875 0 Mabsadd L
.37238 .20743 0 -2.5 Mabsadd L
.37238 .20743 -1.875 0 Mabsadd L closepath F
.37238 .20809 -1.875 0 Mabsadd m
.37238 .20809 0 2.5 Mabsadd L
.37238 .20809 1.875 0 Mabsadd L
.37238 .20809 0 -2.5 Mabsadd L
.37238 .20809 -1.875 0 Mabsadd L closepath F
.37238 .20841 -1.875 0 Mabsadd m
.37238 .20841 0 2.5 Mabsadd L
.37238 .20841 1.875 0 Mabsadd L
.37238 .20841 0 -2.5 Mabsadd L
.37238 .20841 -1.875 0 Mabsadd L closepath F
.37339 .20874 -1.875 0 Mabsadd m
.37339 .20874 0 2.5 Mabsadd L
.37339 .20874 1.875 0 Mabsadd L
.37339 .20874 0 -2.5 Mabsadd L
.37339 .20874 -1.875 0 Mabsadd L closepath F
.37389 .20874 -1.875 0 Mabsadd m
.37389 .20874 0 2.5 Mabsadd L
.37389 .20874 1.875 0 Mabsadd L
.37389 .20874 0 -2.5 Mabsadd L
.37389 .20874 -1.875 0 Mabsadd L closepath F
.37389 .20907 -1.875 0 Mabsadd m
.37389 .20907 0 2.5 Mabsadd L
.37389 .20907 1.875 0 Mabsadd L
.37389 .20907 0 -2.5 Mabsadd L
.37389 .20907 -1.875 0 Mabsadd L closepath F
.37389 .20907 -1.875 0 Mabsadd m
.37389 .20907 0 2.5 Mabsadd L
.37389 .20907 1.875 0 Mabsadd L
.37389 .20907 0 -2.5 Mabsadd L
.37389 .20907 -1.875 0 Mabsadd L closepath F
.37439 .20939 -1.875 0 Mabsadd m
.37439 .20939 0 2.5 Mabsadd L
.37439 .20939 1.875 0 Mabsadd L
.37439 .20939 0 -2.5 Mabsadd L
.37439 .20939 -1.875 0 Mabsadd L closepath F
.3754 .20939 -1.875 0 Mabsadd m
.3754 .20939 0 2.5 Mabsadd L
.3754 .20939 1.875 0 Mabsadd L
.3754 .20939 0 -2.5 Mabsadd L
.3754 .20939 -1.875 0 Mabsadd L closepath F
.37641 .20972 -1.875 0 Mabsadd m
.37641 .20972 0 2.5 Mabsadd L
.37641 .20972 1.875 0 Mabsadd L
.37641 .20972 0 -2.5 Mabsadd L
.37641 .20972 -1.875 0 Mabsadd L closepath F
.37843 .20972 -1.875 0 Mabsadd m
.37843 .20972 0 2.5 Mabsadd L
.37843 .20972 1.875 0 Mabsadd L
.37843 .20972 0 -2.5 Mabsadd L
.37843 .20972 -1.875 0 Mabsadd L closepath F
.37893 .21005 -1.875 0 Mabsadd m
.37893 .21005 0 2.5 Mabsadd L
.37893 .21005 1.875 0 Mabsadd L
.37893 .21005 0 -2.5 Mabsadd L
.37893 .21005 -1.875 0 Mabsadd L closepath F
.37944 .21005 -1.875 0 Mabsadd m
.37944 .21005 0 2.5 Mabsadd L
.37944 .21005 1.875 0 Mabsadd L
.37944 .21005 0 -2.5 Mabsadd L
.37944 .21005 -1.875 0 Mabsadd L closepath F
.37994 .2107 -1.875 0 Mabsadd m
.37994 .2107 0 2.5 Mabsadd L
.37994 .2107 1.875 0 Mabsadd L
.37994 .2107 0 -2.5 Mabsadd L
.37994 .2107 -1.875 0 Mabsadd L closepath F
.37994 .2107 -1.875 0 Mabsadd m
.37994 .2107 0 2.5 Mabsadd L
.37994 .2107 1.875 0 Mabsadd L
.37994 .2107 0 -2.5 Mabsadd L
.37994 .2107 -1.875 0 Mabsadd L closepath F
.37994 .2107 -1.875 0 Mabsadd m
.37994 .2107 0 2.5 Mabsadd L
.37994 .2107 1.875 0 Mabsadd L
.37994 .2107 0 -2.5 Mabsadd L
.37994 .2107 -1.875 0 Mabsadd L closepath F
.38045 .21103 -1.875 0 Mabsadd m
.38045 .21103 0 2.5 Mabsadd L
.38045 .21103 1.875 0 Mabsadd L
.38045 .21103 0 -2.5 Mabsadd L
.38045 .21103 -1.875 0 Mabsadd L closepath F
.38045 .21135 -1.875 0 Mabsadd m
.38045 .21135 0 2.5 Mabsadd L
.38045 .21135 1.875 0 Mabsadd L
.38045 .21135 0 -2.5 Mabsadd L
.38045 .21135 -1.875 0 Mabsadd L closepath F
.38146 .21135 -1.875 0 Mabsadd m
.38146 .21135 0 2.5 Mabsadd L
.38146 .21135 1.875 0 Mabsadd L
.38146 .21135 0 -2.5 Mabsadd L
.38146 .21135 -1.875 0 Mabsadd L closepath F
.38196 .21135 -1.875 0 Mabsadd m
.38196 .21135 0 2.5 Mabsadd L
.38196 .21135 1.875 0 Mabsadd L
.38196 .21135 0 -2.5 Mabsadd L
.38196 .21135 -1.875 0 Mabsadd L closepath F
.38196 .21135 -1.875 0 Mabsadd m
.38196 .21135 0 2.5 Mabsadd L
.38196 .21135 1.875 0 Mabsadd L
.38196 .21135 0 -2.5 Mabsadd L
.38196 .21135 -1.875 0 Mabsadd L closepath F
.38247 .21168 -1.875 0 Mabsadd m
.38247 .21168 0 2.5 Mabsadd L
.38247 .21168 1.875 0 Mabsadd L
.38247 .21168 0 -2.5 Mabsadd L
.38247 .21168 -1.875 0 Mabsadd L closepath F
.38297 .21168 -1.875 0 Mabsadd m
.38297 .21168 0 2.5 Mabsadd L
.38297 .21168 1.875 0 Mabsadd L
.38297 .21168 0 -2.5 Mabsadd L
.38297 .21168 -1.875 0 Mabsadd L closepath F
.38297 .21201 -1.875 0 Mabsadd m
.38297 .21201 0 2.5 Mabsadd L
.38297 .21201 1.875 0 Mabsadd L
.38297 .21201 0 -2.5 Mabsadd L
.38297 .21201 -1.875 0 Mabsadd L closepath F
.38347 .21201 -1.875 0 Mabsadd m
.38347 .21201 0 2.5 Mabsadd L
.38347 .21201 1.875 0 Mabsadd L
.38347 .21201 0 -2.5 Mabsadd L
.38347 .21201 -1.875 0 Mabsadd L closepath F
.38398 .21233 -1.875 0 Mabsadd m
.38398 .21233 0 2.5 Mabsadd L
.38398 .21233 1.875 0 Mabsadd L
.38398 .21233 0 -2.5 Mabsadd L
.38398 .21233 -1.875 0 Mabsadd L closepath F
.38398 .21266 -1.875 0 Mabsadd m
.38398 .21266 0 2.5 Mabsadd L
.38398 .21266 1.875 0 Mabsadd L
.38398 .21266 0 -2.5 Mabsadd L
.38398 .21266 -1.875 0 Mabsadd L closepath F
.38398 .21266 -1.875 0 Mabsadd m
.38398 .21266 0 2.5 Mabsadd L
.38398 .21266 1.875 0 Mabsadd L
.38398 .21266 0 -2.5 Mabsadd L
.38398 .21266 -1.875 0 Mabsadd L closepath F
.38398 .21331 -1.875 0 Mabsadd m
.38398 .21331 0 2.5 Mabsadd L
.38398 .21331 1.875 0 Mabsadd L
.38398 .21331 0 -2.5 Mabsadd L
.38398 .21331 -1.875 0 Mabsadd L closepath F
.38448 .21396 -1.875 0 Mabsadd m
.38448 .21396 0 2.5 Mabsadd L
.38448 .21396 1.875 0 Mabsadd L
.38448 .21396 0 -2.5 Mabsadd L
.38448 .21396 -1.875 0 Mabsadd L closepath F
.38499 .21396 -1.875 0 Mabsadd m
.38499 .21396 0 2.5 Mabsadd L
.38499 .21396 1.875 0 Mabsadd L
.38499 .21396 0 -2.5 Mabsadd L
.38499 .21396 -1.875 0 Mabsadd L closepath F
.38499 .21429 -1.875 0 Mabsadd m
.38499 .21429 0 2.5 Mabsadd L
.38499 .21429 1.875 0 Mabsadd L
.38499 .21429 0 -2.5 Mabsadd L
.38499 .21429 -1.875 0 Mabsadd L closepath F
.38549 .21462 -1.875 0 Mabsadd m
.38549 .21462 0 2.5 Mabsadd L
.38549 .21462 1.875 0 Mabsadd L
.38549 .21462 0 -2.5 Mabsadd L
.38549 .21462 -1.875 0 Mabsadd L closepath F
.386 .21462 -1.875 0 Mabsadd m
.386 .21462 0 2.5 Mabsadd L
.386 .21462 1.875 0 Mabsadd L
.386 .21462 0 -2.5 Mabsadd L
.386 .21462 -1.875 0 Mabsadd L closepath F
.3865 .21462 -1.875 0 Mabsadd m
.3865 .21462 0 2.5 Mabsadd L
.3865 .21462 1.875 0 Mabsadd L
.3865 .21462 0 -2.5 Mabsadd L
.3865 .21462 -1.875 0 Mabsadd L closepath F
.38701 .21462 -1.875 0 Mabsadd m
.38701 .21462 0 2.5 Mabsadd L
.38701 .21462 1.875 0 Mabsadd L
.38701 .21462 0 -2.5 Mabsadd L
.38701 .21462 -1.875 0 Mabsadd L closepath F
.38751 .21494 -1.875 0 Mabsadd m
.38751 .21494 0 2.5 Mabsadd L
.38751 .21494 1.875 0 Mabsadd L
.38751 .21494 0 -2.5 Mabsadd L
.38751 .21494 -1.875 0 Mabsadd L closepath F
.38751 .21527 -1.875 0 Mabsadd m
.38751 .21527 0 2.5 Mabsadd L
.38751 .21527 1.875 0 Mabsadd L
.38751 .21527 0 -2.5 Mabsadd L
.38751 .21527 -1.875 0 Mabsadd L closepath F
.38852 .2156 -1.875 0 Mabsadd m
.38852 .2156 0 2.5 Mabsadd L
.38852 .2156 1.875 0 Mabsadd L
.38852 .2156 0 -2.5 Mabsadd L
.38852 .2156 -1.875 0 Mabsadd L closepath F
.38902 .21592 -1.875 0 Mabsadd m
.38902 .21592 0 2.5 Mabsadd L
.38902 .21592 1.875 0 Mabsadd L
.38902 .21592 0 -2.5 Mabsadd L
.38902 .21592 -1.875 0 Mabsadd L closepath F
.38902 .21592 -1.875 0 Mabsadd m
.38902 .21592 0 2.5 Mabsadd L
.38902 .21592 1.875 0 Mabsadd L
.38902 .21592 0 -2.5 Mabsadd L
.38902 .21592 -1.875 0 Mabsadd L closepath F
.38953 .21625 -1.875 0 Mabsadd m
.38953 .21625 0 2.5 Mabsadd L
.38953 .21625 1.875 0 Mabsadd L
.38953 .21625 0 -2.5 Mabsadd L
.38953 .21625 -1.875 0 Mabsadd L closepath F
.39003 .21625 -1.875 0 Mabsadd m
.39003 .21625 0 2.5 Mabsadd L
.39003 .21625 1.875 0 Mabsadd L
.39003 .21625 0 -2.5 Mabsadd L
.39003 .21625 -1.875 0 Mabsadd L closepath F
.39054 .21625 -1.875 0 Mabsadd m
.39054 .21625 0 2.5 Mabsadd L
.39054 .21625 1.875 0 Mabsadd L
.39054 .21625 0 -2.5 Mabsadd L
.39054 .21625 -1.875 0 Mabsadd L closepath F
.39104 .21658 -1.875 0 Mabsadd m
.39104 .21658 0 2.5 Mabsadd L
.39104 .21658 1.875 0 Mabsadd L
.39104 .21658 0 -2.5 Mabsadd L
.39104 .21658 -1.875 0 Mabsadd L closepath F
.39104 .21658 -1.875 0 Mabsadd m
.39104 .21658 0 2.5 Mabsadd L
.39104 .21658 1.875 0 Mabsadd L
.39104 .21658 0 -2.5 Mabsadd L
.39104 .21658 -1.875 0 Mabsadd L closepath F
.39155 .2169 -1.875 0 Mabsadd m
.39155 .2169 0 2.5 Mabsadd L
.39155 .2169 1.875 0 Mabsadd L
.39155 .2169 0 -2.5 Mabsadd L
.39155 .2169 -1.875 0 Mabsadd L closepath F
.39356 .21723 -1.875 0 Mabsadd m
.39356 .21723 0 2.5 Mabsadd L
.39356 .21723 1.875 0 Mabsadd L
.39356 .21723 0 -2.5 Mabsadd L
.39356 .21723 -1.875 0 Mabsadd L closepath F
.39356 .21756 -1.875 0 Mabsadd m
.39356 .21756 0 2.5 Mabsadd L
.39356 .21756 1.875 0 Mabsadd L
.39356 .21756 0 -2.5 Mabsadd L
.39356 .21756 -1.875 0 Mabsadd L closepath F
.39457 .21756 -1.875 0 Mabsadd m
.39457 .21756 0 2.5 Mabsadd L
.39457 .21756 1.875 0 Mabsadd L
.39457 .21756 0 -2.5 Mabsadd L
.39457 .21756 -1.875 0 Mabsadd L closepath F
.39457 .21756 -1.875 0 Mabsadd m
.39457 .21756 0 2.5 Mabsadd L
.39457 .21756 1.875 0 Mabsadd L
.39457 .21756 0 -2.5 Mabsadd L
.39457 .21756 -1.875 0 Mabsadd L closepath F
.39609 .21788 -1.875 0 Mabsadd m
.39609 .21788 0 2.5 Mabsadd L
.39609 .21788 1.875 0 Mabsadd L
.39609 .21788 0 -2.5 Mabsadd L
.39609 .21788 -1.875 0 Mabsadd L closepath F
.39659 .21788 -1.875 0 Mabsadd m
.39659 .21788 0 2.5 Mabsadd L
.39659 .21788 1.875 0 Mabsadd L
.39659 .21788 0 -2.5 Mabsadd L
.39659 .21788 -1.875 0 Mabsadd L closepath F
.39659 .21792 -1.875 0 Mabsadd m
.39659 .21792 0 2.5 Mabsadd L
.39659 .21792 1.875 0 Mabsadd L
.39659 .21792 0 -2.5 Mabsadd L
.39659 .21792 -1.875 0 Mabsadd L closepath F
.39709 .21821 -1.875 0 Mabsadd m
.39709 .21821 0 2.5 Mabsadd L
.39709 .21821 1.875 0 Mabsadd L
.39709 .21821 0 -2.5 Mabsadd L
.39709 .21821 -1.875 0 Mabsadd L closepath F
.39709 .21821 -1.875 0 Mabsadd m
.39709 .21821 0 2.5 Mabsadd L
.39709 .21821 1.875 0 Mabsadd L
.39709 .21821 0 -2.5 Mabsadd L
.39709 .21821 -1.875 0 Mabsadd L closepath F
.3976 .21886 -1.875 0 Mabsadd m
.3976 .21886 0 2.5 Mabsadd L
.3976 .21886 1.875 0 Mabsadd L
.3976 .21886 0 -2.5 Mabsadd L
.3976 .21886 -1.875 0 Mabsadd L closepath F
.3976 .21886 -1.875 0 Mabsadd m
.3976 .21886 0 2.5 Mabsadd L
.3976 .21886 1.875 0 Mabsadd L
.3976 .21886 0 -2.5 Mabsadd L
.3976 .21886 -1.875 0 Mabsadd L closepath F
.3976 .21886 -1.875 0 Mabsadd m
.3976 .21886 0 2.5 Mabsadd L
.3976 .21886 1.875 0 Mabsadd L
.3976 .21886 0 -2.5 Mabsadd L
.3976 .21886 -1.875 0 Mabsadd L closepath F
.3981 .21919 -1.875 0 Mabsadd m
.3981 .21919 0 2.5 Mabsadd L
.3981 .21919 1.875 0 Mabsadd L
.3981 .21919 0 -2.5 Mabsadd L
.3981 .21919 -1.875 0 Mabsadd L closepath F
.39861 .21952 -1.875 0 Mabsadd m
.39861 .21952 0 2.5 Mabsadd L
.39861 .21952 1.875 0 Mabsadd L
.39861 .21952 0 -2.5 Mabsadd L
.39861 .21952 -1.875 0 Mabsadd L closepath F
.39962 .21952 -1.875 0 Mabsadd m
.39962 .21952 0 2.5 Mabsadd L
.39962 .21952 1.875 0 Mabsadd L
.39962 .21952 0 -2.5 Mabsadd L
.39962 .21952 -1.875 0 Mabsadd L closepath F
.39962 .21952 -1.875 0 Mabsadd m
.39962 .21952 0 2.5 Mabsadd L
.39962 .21952 1.875 0 Mabsadd L
.39962 .21952 0 -2.5 Mabsadd L
.39962 .21952 -1.875 0 Mabsadd L closepath F
.40012 .21965 -1.875 0 Mabsadd m
.40012 .21965 0 2.5 Mabsadd L
.40012 .21965 1.875 0 Mabsadd L
.40012 .21965 0 -2.5 Mabsadd L
.40012 .21965 -1.875 0 Mabsadd L closepath F
.40012 .22017 -1.875 0 Mabsadd m
.40012 .22017 0 2.5 Mabsadd L
.40012 .22017 1.875 0 Mabsadd L
.40012 .22017 0 -2.5 Mabsadd L
.40012 .22017 -1.875 0 Mabsadd L closepath F
.40063 .22017 -1.875 0 Mabsadd m
.40063 .22017 0 2.5 Mabsadd L
.40063 .22017 1.875 0 Mabsadd L
.40063 .22017 0 -2.5 Mabsadd L
.40063 .22017 -1.875 0 Mabsadd L closepath F
.40113 .22017 -1.875 0 Mabsadd m
.40113 .22017 0 2.5 Mabsadd L
.40113 .22017 1.875 0 Mabsadd L
.40113 .22017 0 -2.5 Mabsadd L
.40113 .22017 -1.875 0 Mabsadd L closepath F
.40113 .22017 -1.875 0 Mabsadd m
.40113 .22017 0 2.5 Mabsadd L
.40113 .22017 1.875 0 Mabsadd L
.40113 .22017 0 -2.5 Mabsadd L
.40113 .22017 -1.875 0 Mabsadd L closepath F
.40163 .22017 -1.875 0 Mabsadd m
.40163 .22017 0 2.5 Mabsadd L
.40163 .22017 1.875 0 Mabsadd L
.40163 .22017 0 -2.5 Mabsadd L
.40163 .22017 -1.875 0 Mabsadd L closepath F
.40163 .22017 -1.875 0 Mabsadd m
.40163 .22017 0 2.5 Mabsadd L
.40163 .22017 1.875 0 Mabsadd L
.40163 .22017 0 -2.5 Mabsadd L
.40163 .22017 -1.875 0 Mabsadd L closepath F
.40163 .22017 -1.875 0 Mabsadd m
.40163 .22017 0 2.5 Mabsadd L
.40163 .22017 1.875 0 Mabsadd L
.40163 .22017 0 -2.5 Mabsadd L
.40163 .22017 -1.875 0 Mabsadd L closepath F
.40163 .22017 -1.875 0 Mabsadd m
.40163 .22017 0 2.5 Mabsadd L
.40163 .22017 1.875 0 Mabsadd L
.40163 .22017 0 -2.5 Mabsadd L
.40163 .22017 -1.875 0 Mabsadd L closepath F
.40214 .22115 -1.875 0 Mabsadd m
.40214 .22115 0 2.5 Mabsadd L
.40214 .22115 1.875 0 Mabsadd L
.40214 .22115 0 -2.5 Mabsadd L
.40214 .22115 -1.875 0 Mabsadd L closepath F
.40214 .22115 -1.875 0 Mabsadd m
.40214 .22115 0 2.5 Mabsadd L
.40214 .22115 1.875 0 Mabsadd L
.40214 .22115 0 -2.5 Mabsadd L
.40214 .22115 -1.875 0 Mabsadd L closepath F
.40214 .22115 -1.875 0 Mabsadd m
.40214 .22115 0 2.5 Mabsadd L
.40214 .22115 1.875 0 Mabsadd L
.40214 .22115 0 -2.5 Mabsadd L
.40214 .22115 -1.875 0 Mabsadd L closepath F
.40264 .22115 -1.875 0 Mabsadd m
.40264 .22115 0 2.5 Mabsadd L
.40264 .22115 1.875 0 Mabsadd L
.40264 .22115 0 -2.5 Mabsadd L
.40264 .22115 -1.875 0 Mabsadd L closepath F
.40315 .22148 -1.875 0 Mabsadd m
.40315 .22148 0 2.5 Mabsadd L
.40315 .22148 1.875 0 Mabsadd L
.40315 .22148 0 -2.5 Mabsadd L
.40315 .22148 -1.875 0 Mabsadd L closepath F
.40365 .22148 -1.875 0 Mabsadd m
.40365 .22148 0 2.5 Mabsadd L
.40365 .22148 1.875 0 Mabsadd L
.40365 .22148 0 -2.5 Mabsadd L
.40365 .22148 -1.875 0 Mabsadd L closepath F
.40365 .22148 -1.875 0 Mabsadd m
.40365 .22148 0 2.5 Mabsadd L
.40365 .22148 1.875 0 Mabsadd L
.40365 .22148 0 -2.5 Mabsadd L
.40365 .22148 -1.875 0 Mabsadd L closepath F
.40451 .22148 -1.875 0 Mabsadd m
.40451 .22148 0 2.5 Mabsadd L
.40451 .22148 1.875 0 Mabsadd L
.40451 .22148 0 -2.5 Mabsadd L
.40451 .22148 -1.875 0 Mabsadd L closepath F
.40517 .22148 -1.875 0 Mabsadd m
.40517 .22148 0 2.5 Mabsadd L
.40517 .22148 1.875 0 Mabsadd L
.40517 .22148 0 -2.5 Mabsadd L
.40517 .22148 -1.875 0 Mabsadd L closepath F
.40567 .2218 -1.875 0 Mabsadd m
.40567 .2218 0 2.5 Mabsadd L
.40567 .2218 1.875 0 Mabsadd L
.40567 .2218 0 -2.5 Mabsadd L
.40567 .2218 -1.875 0 Mabsadd L closepath F
.40617 .2218 -1.875 0 Mabsadd m
.40617 .2218 0 2.5 Mabsadd L
.40617 .2218 1.875 0 Mabsadd L
.40617 .2218 0 -2.5 Mabsadd L
.40617 .2218 -1.875 0 Mabsadd L closepath F
.40668 .22213 -1.875 0 Mabsadd m
.40668 .22213 0 2.5 Mabsadd L
.40668 .22213 1.875 0 Mabsadd L
.40668 .22213 0 -2.5 Mabsadd L
.40668 .22213 -1.875 0 Mabsadd L closepath F
.40698 .22246 -1.875 0 Mabsadd m
.40698 .22246 0 2.5 Mabsadd L
.40698 .22246 1.875 0 Mabsadd L
.40698 .22246 0 -2.5 Mabsadd L
.40698 .22246 -1.875 0 Mabsadd L closepath F
.40718 .22246 -1.875 0 Mabsadd m
.40718 .22246 0 2.5 Mabsadd L
.40718 .22246 1.875 0 Mabsadd L
.40718 .22246 0 -2.5 Mabsadd L
.40718 .22246 -1.875 0 Mabsadd L closepath F
.40718 .22278 -1.875 0 Mabsadd m
.40718 .22278 0 2.5 Mabsadd L
.40718 .22278 1.875 0 Mabsadd L
.40718 .22278 0 -2.5 Mabsadd L
.40718 .22278 -1.875 0 Mabsadd L closepath F
.40769 .22278 -1.875 0 Mabsadd m
.40769 .22278 0 2.5 Mabsadd L
.40769 .22278 1.875 0 Mabsadd L
.40769 .22278 0 -2.5 Mabsadd L
.40769 .22278 -1.875 0 Mabsadd L closepath F
.40819 .22285 -1.875 0 Mabsadd m
.40819 .22285 0 2.5 Mabsadd L
.40819 .22285 1.875 0 Mabsadd L
.40819 .22285 0 -2.5 Mabsadd L
.40819 .22285 -1.875 0 Mabsadd L closepath F
.40819 .22311 -1.875 0 Mabsadd m
.40819 .22311 0 2.5 Mabsadd L
.40819 .22311 1.875 0 Mabsadd L
.40819 .22311 0 -2.5 Mabsadd L
.40819 .22311 -1.875 0 Mabsadd L closepath F
.4087 .22311 -1.875 0 Mabsadd m
.4087 .22311 0 2.5 Mabsadd L
.4087 .22311 1.875 0 Mabsadd L
.4087 .22311 0 -2.5 Mabsadd L
.4087 .22311 -1.875 0 Mabsadd L closepath F
.4092 .2234 -1.875 0 Mabsadd m
.4092 .2234 0 2.5 Mabsadd L
.4092 .2234 1.875 0 Mabsadd L
.4092 .2234 0 -2.5 Mabsadd L
.4092 .2234 -1.875 0 Mabsadd L closepath F
.41071 .22344 -1.875 0 Mabsadd m
.41071 .22344 0 2.5 Mabsadd L
.41071 .22344 1.875 0 Mabsadd L
.41071 .22344 0 -2.5 Mabsadd L
.41071 .22344 -1.875 0 Mabsadd L closepath F
.41071 .22347 -1.875 0 Mabsadd m
.41071 .22347 0 2.5 Mabsadd L
.41071 .22347 1.875 0 Mabsadd L
.41071 .22347 0 -2.5 Mabsadd L
.41071 .22347 -1.875 0 Mabsadd L closepath F
.41122 .22409 -1.875 0 Mabsadd m
.41122 .22409 0 2.5 Mabsadd L
.41122 .22409 1.875 0 Mabsadd L
.41122 .22409 0 -2.5 Mabsadd L
.41122 .22409 -1.875 0 Mabsadd L closepath F
.41122 .22409 -1.875 0 Mabsadd m
.41122 .22409 0 2.5 Mabsadd L
.41122 .22409 1.875 0 Mabsadd L
.41122 .22409 0 -2.5 Mabsadd L
.41122 .22409 -1.875 0 Mabsadd L closepath F
.41122 .22409 -1.875 0 Mabsadd m
.41122 .22409 0 2.5 Mabsadd L
.41122 .22409 1.875 0 Mabsadd L
.41122 .22409 0 -2.5 Mabsadd L
.41122 .22409 -1.875 0 Mabsadd L closepath F
.41152 .22442 -1.875 0 Mabsadd m
.41152 .22442 0 2.5 Mabsadd L
.41152 .22442 1.875 0 Mabsadd L
.41152 .22442 0 -2.5 Mabsadd L
.41152 .22442 -1.875 0 Mabsadd L closepath F
.41172 .22442 -1.875 0 Mabsadd m
.41172 .22442 0 2.5 Mabsadd L
.41172 .22442 1.875 0 Mabsadd L
.41172 .22442 0 -2.5 Mabsadd L
.41172 .22442 -1.875 0 Mabsadd L closepath F
.41172 .22442 -1.875 0 Mabsadd m
.41172 .22442 0 2.5 Mabsadd L
.41172 .22442 1.875 0 Mabsadd L
.41172 .22442 0 -2.5 Mabsadd L
.41172 .22442 -1.875 0 Mabsadd L closepath F
.41172 .22442 -1.875 0 Mabsadd m
.41172 .22442 0 2.5 Mabsadd L
.41172 .22442 1.875 0 Mabsadd L
.41172 .22442 0 -2.5 Mabsadd L
.41172 .22442 -1.875 0 Mabsadd L closepath F
.41172 .22474 -1.875 0 Mabsadd m
.41172 .22474 0 2.5 Mabsadd L
.41172 .22474 1.875 0 Mabsadd L
.41172 .22474 0 -2.5 Mabsadd L
.41172 .22474 -1.875 0 Mabsadd L closepath F
.41223 .22474 -1.875 0 Mabsadd m
.41223 .22474 0 2.5 Mabsadd L
.41223 .22474 1.875 0 Mabsadd L
.41223 .22474 0 -2.5 Mabsadd L
.41223 .22474 -1.875 0 Mabsadd L closepath F
.41223 .22507 -1.875 0 Mabsadd m
.41223 .22507 0 2.5 Mabsadd L
.41223 .22507 1.875 0 Mabsadd L
.41223 .22507 0 -2.5 Mabsadd L
.41223 .22507 -1.875 0 Mabsadd L closepath F
.41223 .22572 -1.875 0 Mabsadd m
.41223 .22572 0 2.5 Mabsadd L
.41223 .22572 1.875 0 Mabsadd L
.41223 .22572 0 -2.5 Mabsadd L
.41223 .22572 -1.875 0 Mabsadd L closepath F
.41233 .22572 -1.875 0 Mabsadd m
.41233 .22572 0 2.5 Mabsadd L
.41233 .22572 1.875 0 Mabsadd L
.41233 .22572 0 -2.5 Mabsadd L
.41233 .22572 -1.875 0 Mabsadd L closepath F
.41238 .22605 -1.875 0 Mabsadd m
.41238 .22605 0 2.5 Mabsadd L
.41238 .22605 1.875 0 Mabsadd L
.41238 .22605 0 -2.5 Mabsadd L
.41238 .22605 -1.875 0 Mabsadd L closepath F
.41243 .22638 -1.875 0 Mabsadd m
.41243 .22638 0 2.5 Mabsadd L
.41243 .22638 1.875 0 Mabsadd L
.41243 .22638 0 -2.5 Mabsadd L
.41243 .22638 -1.875 0 Mabsadd L closepath F
.41273 .2267 -1.875 0 Mabsadd m
.41273 .2267 0 2.5 Mabsadd L
.41273 .2267 1.875 0 Mabsadd L
.41273 .2267 0 -2.5 Mabsadd L
.41273 .2267 -1.875 0 Mabsadd L closepath F
.41273 .2267 -1.875 0 Mabsadd m
.41273 .2267 0 2.5 Mabsadd L
.41273 .2267 1.875 0 Mabsadd L
.41273 .2267 0 -2.5 Mabsadd L
.41273 .2267 -1.875 0 Mabsadd L closepath F
.41324 .22703 -1.875 0 Mabsadd m
.41324 .22703 0 2.5 Mabsadd L
.41324 .22703 1.875 0 Mabsadd L
.41324 .22703 0 -2.5 Mabsadd L
.41324 .22703 -1.875 0 Mabsadd L closepath F
.41324 .22736 -1.875 0 Mabsadd m
.41324 .22736 0 2.5 Mabsadd L
.41324 .22736 1.875 0 Mabsadd L
.41324 .22736 0 -2.5 Mabsadd L
.41324 .22736 -1.875 0 Mabsadd L closepath F
.41475 .22768 -1.875 0 Mabsadd m
.41475 .22768 0 2.5 Mabsadd L
.41475 .22768 1.875 0 Mabsadd L
.41475 .22768 0 -2.5 Mabsadd L
.41475 .22768 -1.875 0 Mabsadd L closepath F
.41525 .22768 -1.875 0 Mabsadd m
.41525 .22768 0 2.5 Mabsadd L
.41525 .22768 1.875 0 Mabsadd L
.41525 .22768 0 -2.5 Mabsadd L
.41525 .22768 -1.875 0 Mabsadd L closepath F
.41525 .22768 -1.875 0 Mabsadd m
.41525 .22768 0 2.5 Mabsadd L
.41525 .22768 1.875 0 Mabsadd L
.41525 .22768 0 -2.5 Mabsadd L
.41525 .22768 -1.875 0 Mabsadd L closepath F
.41576 .22797 -1.875 0 Mabsadd m
.41576 .22797 0 2.5 Mabsadd L
.41576 .22797 1.875 0 Mabsadd L
.41576 .22797 0 -2.5 Mabsadd L
.41576 .22797 -1.875 0 Mabsadd L closepath F
.41576 .22834 -1.875 0 Mabsadd m
.41576 .22834 0 2.5 Mabsadd L
.41576 .22834 1.875 0 Mabsadd L
.41576 .22834 0 -2.5 Mabsadd L
.41576 .22834 -1.875 0 Mabsadd L closepath F
.41727 .22834 -1.875 0 Mabsadd m
.41727 .22834 0 2.5 Mabsadd L
.41727 .22834 1.875 0 Mabsadd L
.41727 .22834 0 -2.5 Mabsadd L
.41727 .22834 -1.875 0 Mabsadd L closepath F
.41727 .22834 -1.875 0 Mabsadd m
.41727 .22834 0 2.5 Mabsadd L
.41727 .22834 1.875 0 Mabsadd L
.41727 .22834 0 -2.5 Mabsadd L
.41727 .22834 -1.875 0 Mabsadd L closepath F
.41778 .22834 -1.875 0 Mabsadd m
.41778 .22834 0 2.5 Mabsadd L
.41778 .22834 1.875 0 Mabsadd L
.41778 .22834 0 -2.5 Mabsadd L
.41778 .22834 -1.875 0 Mabsadd L closepath F
.41778 .22866 -1.875 0 Mabsadd m
.41778 .22866 0 2.5 Mabsadd L
.41778 .22866 1.875 0 Mabsadd L
.41778 .22866 0 -2.5 Mabsadd L
.41778 .22866 -1.875 0 Mabsadd L closepath F
.41828 .22866 -1.875 0 Mabsadd m
.41828 .22866 0 2.5 Mabsadd L
.41828 .22866 1.875 0 Mabsadd L
.41828 .22866 0 -2.5 Mabsadd L
.41828 .22866 -1.875 0 Mabsadd L closepath F
.41879 .22899 -1.875 0 Mabsadd m
.41879 .22899 0 2.5 Mabsadd L
.41879 .22899 1.875 0 Mabsadd L
.41879 .22899 0 -2.5 Mabsadd L
.41879 .22899 -1.875 0 Mabsadd L closepath F
.41879 .22932 -1.875 0 Mabsadd m
.41879 .22932 0 2.5 Mabsadd L
.41879 .22932 1.875 0 Mabsadd L
.41879 .22932 0 -2.5 Mabsadd L
.41879 .22932 -1.875 0 Mabsadd L closepath F
.41887 .22964 -1.875 0 Mabsadd m
.41887 .22964 0 2.5 Mabsadd L
.41887 .22964 1.875 0 Mabsadd L
.41887 .22964 0 -2.5 Mabsadd L
.41887 .22964 -1.875 0 Mabsadd L closepath F
.41929 .22997 -1.875 0 Mabsadd m
.41929 .22997 0 2.5 Mabsadd L
.41929 .22997 1.875 0 Mabsadd L
.41929 .22997 0 -2.5 Mabsadd L
.41929 .22997 -1.875 0 Mabsadd L closepath F
.42131 .22997 -1.875 0 Mabsadd m
.42131 .22997 0 2.5 Mabsadd L
.42131 .22997 1.875 0 Mabsadd L
.42131 .22997 0 -2.5 Mabsadd L
.42131 .22997 -1.875 0 Mabsadd L closepath F
.42131 .22997 -1.875 0 Mabsadd m
.42131 .22997 0 2.5 Mabsadd L
.42131 .22997 1.875 0 Mabsadd L
.42131 .22997 0 -2.5 Mabsadd L
.42131 .22997 -1.875 0 Mabsadd L closepath F
.42181 .2303 -1.875 0 Mabsadd m
.42181 .2303 0 2.5 Mabsadd L
.42181 .2303 1.875 0 Mabsadd L
.42181 .2303 0 -2.5 Mabsadd L
.42181 .2303 -1.875 0 Mabsadd L closepath F
.42232 .23128 -1.875 0 Mabsadd m
.42232 .23128 0 2.5 Mabsadd L
.42232 .23128 1.875 0 Mabsadd L
.42232 .23128 0 -2.5 Mabsadd L
.42232 .23128 -1.875 0 Mabsadd L closepath F
.42282 .23128 -1.875 0 Mabsadd m
.42282 .23128 0 2.5 Mabsadd L
.42282 .23128 1.875 0 Mabsadd L
.42282 .23128 0 -2.5 Mabsadd L
.42282 .23128 -1.875 0 Mabsadd L closepath F
.42333 .23128 -1.875 0 Mabsadd m
.42333 .23128 0 2.5 Mabsadd L
.42333 .23128 1.875 0 Mabsadd L
.42333 .23128 0 -2.5 Mabsadd L
.42333 .23128 -1.875 0 Mabsadd L closepath F
.42333 .23128 -1.875 0 Mabsadd m
.42333 .23128 0 2.5 Mabsadd L
.42333 .23128 1.875 0 Mabsadd L
.42333 .23128 0 -2.5 Mabsadd L
.42333 .23128 -1.875 0 Mabsadd L closepath F
.42333 .23128 -1.875 0 Mabsadd m
.42333 .23128 0 2.5 Mabsadd L
.42333 .23128 1.875 0 Mabsadd L
.42333 .23128 0 -2.5 Mabsadd L
.42333 .23128 -1.875 0 Mabsadd L closepath F
.42383 .23128 -1.875 0 Mabsadd m
.42383 .23128 0 2.5 Mabsadd L
.42383 .23128 1.875 0 Mabsadd L
.42383 .23128 0 -2.5 Mabsadd L
.42383 .23128 -1.875 0 Mabsadd L closepath F
.42484 .2316 -1.875 0 Mabsadd m
.42484 .2316 0 2.5 Mabsadd L
.42484 .2316 1.875 0 Mabsadd L
.42484 .2316 0 -2.5 Mabsadd L
.42484 .2316 -1.875 0 Mabsadd L closepath F
.42534 .23193 -1.875 0 Mabsadd m
.42534 .23193 0 2.5 Mabsadd L
.42534 .23193 1.875 0 Mabsadd L
.42534 .23193 0 -2.5 Mabsadd L
.42534 .23193 -1.875 0 Mabsadd L closepath F
.42534 .23193 -1.875 0 Mabsadd m
.42534 .23193 0 2.5 Mabsadd L
.42534 .23193 1.875 0 Mabsadd L
.42534 .23193 0 -2.5 Mabsadd L
.42534 .23193 -1.875 0 Mabsadd L closepath F
.42534 .23193 -1.875 0 Mabsadd m
.42534 .23193 0 2.5 Mabsadd L
.42534 .23193 1.875 0 Mabsadd L
.42534 .23193 0 -2.5 Mabsadd L
.42534 .23193 -1.875 0 Mabsadd L closepath F
.42585 .23226 -1.875 0 Mabsadd m
.42585 .23226 0 2.5 Mabsadd L
.42585 .23226 1.875 0 Mabsadd L
.42585 .23226 0 -2.5 Mabsadd L
.42585 .23226 -1.875 0 Mabsadd L closepath F
.42635 .23226 -1.875 0 Mabsadd m
.42635 .23226 0 2.5 Mabsadd L
.42635 .23226 1.875 0 Mabsadd L
.42635 .23226 0 -2.5 Mabsadd L
.42635 .23226 -1.875 0 Mabsadd L closepath F
.42686 .23291 -1.875 0 Mabsadd m
.42686 .23291 0 2.5 Mabsadd L
.42686 .23291 1.875 0 Mabsadd L
.42686 .23291 0 -2.5 Mabsadd L
.42686 .23291 -1.875 0 Mabsadd L closepath F
.42686 .23291 -1.875 0 Mabsadd m
.42686 .23291 0 2.5 Mabsadd L
.42686 .23291 1.875 0 Mabsadd L
.42686 .23291 0 -2.5 Mabsadd L
.42686 .23291 -1.875 0 Mabsadd L closepath F
.42686 .23291 -1.875 0 Mabsadd m
.42686 .23291 0 2.5 Mabsadd L
.42686 .23291 1.875 0 Mabsadd L
.42686 .23291 0 -2.5 Mabsadd L
.42686 .23291 -1.875 0 Mabsadd L closepath F
.42736 .23324 -1.875 0 Mabsadd m
.42736 .23324 0 2.5 Mabsadd L
.42736 .23324 1.875 0 Mabsadd L
.42736 .23324 0 -2.5 Mabsadd L
.42736 .23324 -1.875 0 Mabsadd L closepath F
.42736 .23324 -1.875 0 Mabsadd m
.42736 .23324 0 2.5 Mabsadd L
.42736 .23324 1.875 0 Mabsadd L
.42736 .23324 0 -2.5 Mabsadd L
.42736 .23324 -1.875 0 Mabsadd L closepath F
.42787 .23324 -1.875 0 Mabsadd m
.42787 .23324 0 2.5 Mabsadd L
.42787 .23324 1.875 0 Mabsadd L
.42787 .23324 0 -2.5 Mabsadd L
.42787 .23324 -1.875 0 Mabsadd L closepath F
.42787 .23324 -1.875 0 Mabsadd m
.42787 .23324 0 2.5 Mabsadd L
.42787 .23324 1.875 0 Mabsadd L
.42787 .23324 0 -2.5 Mabsadd L
.42787 .23324 -1.875 0 Mabsadd L closepath F
.42787 .23356 -1.875 0 Mabsadd m
.42787 .23356 0 2.5 Mabsadd L
.42787 .23356 1.875 0 Mabsadd L
.42787 .23356 0 -2.5 Mabsadd L
.42787 .23356 -1.875 0 Mabsadd L closepath F
.42787 .23356 -1.875 0 Mabsadd m
.42787 .23356 0 2.5 Mabsadd L
.42787 .23356 1.875 0 Mabsadd L
.42787 .23356 0 -2.5 Mabsadd L
.42787 .23356 -1.875 0 Mabsadd L closepath F
.42837 .23422 -1.875 0 Mabsadd m
.42837 .23422 0 2.5 Mabsadd L
.42837 .23422 1.875 0 Mabsadd L
.42837 .23422 0 -2.5 Mabsadd L
.42837 .23422 -1.875 0 Mabsadd L closepath F
.42938 .23422 -1.875 0 Mabsadd m
.42938 .23422 0 2.5 Mabsadd L
.42938 .23422 1.875 0 Mabsadd L
.42938 .23422 0 -2.5 Mabsadd L
.42938 .23422 -1.875 0 Mabsadd L closepath F
.42988 .2352 -1.875 0 Mabsadd m
.42988 .2352 0 2.5 Mabsadd L
.42988 .2352 1.875 0 Mabsadd L
.42988 .2352 0 -2.5 Mabsadd L
.42988 .2352 -1.875 0 Mabsadd L closepath F
.43039 .23552 -1.875 0 Mabsadd m
.43039 .23552 0 2.5 Mabsadd L
.43039 .23552 1.875 0 Mabsadd L
.43039 .23552 0 -2.5 Mabsadd L
.43039 .23552 -1.875 0 Mabsadd L closepath F
.4314 .23585 -1.875 0 Mabsadd m
.4314 .23585 0 2.5 Mabsadd L
.4314 .23585 1.875 0 Mabsadd L
.4314 .23585 0 -2.5 Mabsadd L
.4314 .23585 -1.875 0 Mabsadd L closepath F
.4314 .23585 -1.875 0 Mabsadd m
.4314 .23585 0 2.5 Mabsadd L
.4314 .23585 1.875 0 Mabsadd L
.4314 .23585 0 -2.5 Mabsadd L
.4314 .23585 -1.875 0 Mabsadd L closepath F
.43241 .23585 -1.875 0 Mabsadd m
.43241 .23585 0 2.5 Mabsadd L
.43241 .23585 1.875 0 Mabsadd L
.43241 .23585 0 -2.5 Mabsadd L
.43241 .23585 -1.875 0 Mabsadd L closepath F
.43241 .23585 -1.875 0 Mabsadd m
.43241 .23585 0 2.5 Mabsadd L
.43241 .23585 1.875 0 Mabsadd L
.43241 .23585 0 -2.5 Mabsadd L
.43241 .23585 -1.875 0 Mabsadd L closepath F
.43241 .23585 -1.875 0 Mabsadd m
.43241 .23585 0 2.5 Mabsadd L
.43241 .23585 1.875 0 Mabsadd L
.43241 .23585 0 -2.5 Mabsadd L
.43241 .23585 -1.875 0 Mabsadd L closepath F
.43291 .23618 -1.875 0 Mabsadd m
.43291 .23618 0 2.5 Mabsadd L
.43291 .23618 1.875 0 Mabsadd L
.43291 .23618 0 -2.5 Mabsadd L
.43291 .23618 -1.875 0 Mabsadd L closepath F
.43291 .23618 -1.875 0 Mabsadd m
.43291 .23618 0 2.5 Mabsadd L
.43291 .23618 1.875 0 Mabsadd L
.43291 .23618 0 -2.5 Mabsadd L
.43291 .23618 -1.875 0 Mabsadd L closepath F
.43341 .2365 -1.875 0 Mabsadd m
.43341 .2365 0 2.5 Mabsadd L
.43341 .2365 1.875 0 Mabsadd L
.43341 .2365 0 -2.5 Mabsadd L
.43341 .2365 -1.875 0 Mabsadd L closepath F
.43341 .2365 -1.875 0 Mabsadd m
.43341 .2365 0 2.5 Mabsadd L
.43341 .2365 1.875 0 Mabsadd L
.43341 .2365 0 -2.5 Mabsadd L
.43341 .2365 -1.875 0 Mabsadd L closepath F
.43392 .2365 -1.875 0 Mabsadd m
.43392 .2365 0 2.5 Mabsadd L
.43392 .2365 1.875 0 Mabsadd L
.43392 .2365 0 -2.5 Mabsadd L
.43392 .2365 -1.875 0 Mabsadd L closepath F
.43442 .23683 -1.875 0 Mabsadd m
.43442 .23683 0 2.5 Mabsadd L
.43442 .23683 1.875 0 Mabsadd L
.43442 .23683 0 -2.5 Mabsadd L
.43442 .23683 -1.875 0 Mabsadd L closepath F
.43493 .23716 -1.875 0 Mabsadd m
.43493 .23716 0 2.5 Mabsadd L
.43493 .23716 1.875 0 Mabsadd L
.43493 .23716 0 -2.5 Mabsadd L
.43493 .23716 -1.875 0 Mabsadd L closepath F
.43493 .23716 -1.875 0 Mabsadd m
.43493 .23716 0 2.5 Mabsadd L
.43493 .23716 1.875 0 Mabsadd L
.43493 .23716 0 -2.5 Mabsadd L
.43493 .23716 -1.875 0 Mabsadd L closepath F
.43493 .23716 -1.875 0 Mabsadd m
.43493 .23716 0 2.5 Mabsadd L
.43493 .23716 1.875 0 Mabsadd L
.43493 .23716 0 -2.5 Mabsadd L
.43493 .23716 -1.875 0 Mabsadd L closepath F
.43493 .23716 -1.875 0 Mabsadd m
.43493 .23716 0 2.5 Mabsadd L
.43493 .23716 1.875 0 Mabsadd L
.43493 .23716 0 -2.5 Mabsadd L
.43493 .23716 -1.875 0 Mabsadd L closepath F
.43493 .23748 -1.875 0 Mabsadd m
.43493 .23748 0 2.5 Mabsadd L
.43493 .23748 1.875 0 Mabsadd L
.43493 .23748 0 -2.5 Mabsadd L
.43493 .23748 -1.875 0 Mabsadd L closepath F
.43543 .23748 -1.875 0 Mabsadd m
.43543 .23748 0 2.5 Mabsadd L
.43543 .23748 1.875 0 Mabsadd L
.43543 .23748 0 -2.5 Mabsadd L
.43543 .23748 -1.875 0 Mabsadd L closepath F
.43543 .23748 -1.875 0 Mabsadd m
.43543 .23748 0 2.5 Mabsadd L
.43543 .23748 1.875 0 Mabsadd L
.43543 .23748 0 -2.5 Mabsadd L
.43543 .23748 -1.875 0 Mabsadd L closepath F
.43543 .23781 -1.875 0 Mabsadd m
.43543 .23781 0 2.5 Mabsadd L
.43543 .23781 1.875 0 Mabsadd L
.43543 .23781 0 -2.5 Mabsadd L
.43543 .23781 -1.875 0 Mabsadd L closepath F
.43594 .23781 -1.875 0 Mabsadd m
.43594 .23781 0 2.5 Mabsadd L
.43594 .23781 1.875 0 Mabsadd L
.43594 .23781 0 -2.5 Mabsadd L
.43594 .23781 -1.875 0 Mabsadd L closepath F
.43594 .23814 -1.875 0 Mabsadd m
.43594 .23814 0 2.5 Mabsadd L
.43594 .23814 1.875 0 Mabsadd L
.43594 .23814 0 -2.5 Mabsadd L
.43594 .23814 -1.875 0 Mabsadd L closepath F
.43594 .23814 -1.875 0 Mabsadd m
.43594 .23814 0 2.5 Mabsadd L
.43594 .23814 1.875 0 Mabsadd L
.43594 .23814 0 -2.5 Mabsadd L
.43594 .23814 -1.875 0 Mabsadd L closepath F
.43644 .23879 -1.875 0 Mabsadd m
.43644 .23879 0 2.5 Mabsadd L
.43644 .23879 1.875 0 Mabsadd L
.43644 .23879 0 -2.5 Mabsadd L
.43644 .23879 -1.875 0 Mabsadd L closepath F
.43745 .23879 -1.875 0 Mabsadd m
.43745 .23879 0 2.5 Mabsadd L
.43745 .23879 1.875 0 Mabsadd L
.43745 .23879 0 -2.5 Mabsadd L
.43745 .23879 -1.875 0 Mabsadd L closepath F
.43745 .23912 -1.875 0 Mabsadd m
.43745 .23912 0 2.5 Mabsadd L
.43745 .23912 1.875 0 Mabsadd L
.43745 .23912 0 -2.5 Mabsadd L
.43745 .23912 -1.875 0 Mabsadd L closepath F
.43795 .23944 -1.875 0 Mabsadd m
.43795 .23944 0 2.5 Mabsadd L
.43795 .23944 1.875 0 Mabsadd L
.43795 .23944 0 -2.5 Mabsadd L
.43795 .23944 -1.875 0 Mabsadd L closepath F
.43795 .23944 -1.875 0 Mabsadd m
.43795 .23944 0 2.5 Mabsadd L
.43795 .23944 1.875 0 Mabsadd L
.43795 .23944 0 -2.5 Mabsadd L
.43795 .23944 -1.875 0 Mabsadd L closepath F
.43846 .23977 -1.875 0 Mabsadd m
.43846 .23977 0 2.5 Mabsadd L
.43846 .23977 1.875 0 Mabsadd L
.43846 .23977 0 -2.5 Mabsadd L
.43846 .23977 -1.875 0 Mabsadd L closepath F
.43947 .23977 -1.875 0 Mabsadd m
.43947 .23977 0 2.5 Mabsadd L
.43947 .23977 1.875 0 Mabsadd L
.43947 .23977 0 -2.5 Mabsadd L
.43947 .23977 -1.875 0 Mabsadd L closepath F
.43997 .2401 -1.875 0 Mabsadd m
.43997 .2401 0 2.5 Mabsadd L
.43997 .2401 1.875 0 Mabsadd L
.43997 .2401 0 -2.5 Mabsadd L
.43997 .2401 -1.875 0 Mabsadd L closepath F
.44048 .24042 -1.875 0 Mabsadd m
.44048 .24042 0 2.5 Mabsadd L
.44048 .24042 1.875 0 Mabsadd L
.44048 .24042 0 -2.5 Mabsadd L
.44048 .24042 -1.875 0 Mabsadd L closepath F
.44149 .24075 -1.875 0 Mabsadd m
.44149 .24075 0 2.5 Mabsadd L
.44149 .24075 1.875 0 Mabsadd L
.44149 .24075 0 -2.5 Mabsadd L
.44149 .24075 -1.875 0 Mabsadd L closepath F
.44249 .24075 -1.875 0 Mabsadd m
.44249 .24075 0 2.5 Mabsadd L
.44249 .24075 1.875 0 Mabsadd L
.44249 .24075 0 -2.5 Mabsadd L
.44249 .24075 -1.875 0 Mabsadd L closepath F
.443 .24075 -1.875 0 Mabsadd m
.443 .24075 0 2.5 Mabsadd L
.443 .24075 1.875 0 Mabsadd L
.443 .24075 0 -2.5 Mabsadd L
.443 .24075 -1.875 0 Mabsadd L closepath F
.4435 .2414 -1.875 0 Mabsadd m
.4435 .2414 0 2.5 Mabsadd L
.4435 .2414 1.875 0 Mabsadd L
.4435 .2414 0 -2.5 Mabsadd L
.4435 .2414 -1.875 0 Mabsadd L closepath F
.44401 .2414 -1.875 0 Mabsadd m
.44401 .2414 0 2.5 Mabsadd L
.44401 .2414 1.875 0 Mabsadd L
.44401 .2414 0 -2.5 Mabsadd L
.44401 .2414 -1.875 0 Mabsadd L closepath F
.44401 .24173 -1.875 0 Mabsadd m
.44401 .24173 0 2.5 Mabsadd L
.44401 .24173 1.875 0 Mabsadd L
.44401 .24173 0 -2.5 Mabsadd L
.44401 .24173 -1.875 0 Mabsadd L closepath F
.44401 .24173 -1.875 0 Mabsadd m
.44401 .24173 0 2.5 Mabsadd L
.44401 .24173 1.875 0 Mabsadd L
.44401 .24173 0 -2.5 Mabsadd L
.44401 .24173 -1.875 0 Mabsadd L closepath F
.44451 .24173 -1.875 0 Mabsadd m
.44451 .24173 0 2.5 Mabsadd L
.44451 .24173 1.875 0 Mabsadd L
.44451 .24173 0 -2.5 Mabsadd L
.44451 .24173 -1.875 0 Mabsadd L closepath F
.44451 .24173 -1.875 0 Mabsadd m
.44451 .24173 0 2.5 Mabsadd L
.44451 .24173 1.875 0 Mabsadd L
.44451 .24173 0 -2.5 Mabsadd L
.44451 .24173 -1.875 0 Mabsadd L closepath F
.44502 .24206 -1.875 0 Mabsadd m
.44502 .24206 0 2.5 Mabsadd L
.44502 .24206 1.875 0 Mabsadd L
.44502 .24206 0 -2.5 Mabsadd L
.44502 .24206 -1.875 0 Mabsadd L closepath F
.44502 .24206 -1.875 0 Mabsadd m
.44502 .24206 0 2.5 Mabsadd L
.44502 .24206 1.875 0 Mabsadd L
.44502 .24206 0 -2.5 Mabsadd L
.44502 .24206 -1.875 0 Mabsadd L closepath F
.44502 .24206 -1.875 0 Mabsadd m
.44502 .24206 0 2.5 Mabsadd L
.44502 .24206 1.875 0 Mabsadd L
.44502 .24206 0 -2.5 Mabsadd L
.44502 .24206 -1.875 0 Mabsadd L closepath F
.44552 .24238 -1.875 0 Mabsadd m
.44552 .24238 0 2.5 Mabsadd L
.44552 .24238 1.875 0 Mabsadd L
.44552 .24238 0 -2.5 Mabsadd L
.44552 .24238 -1.875 0 Mabsadd L closepath F
.44552 .24238 -1.875 0 Mabsadd m
.44552 .24238 0 2.5 Mabsadd L
.44552 .24238 1.875 0 Mabsadd L
.44552 .24238 0 -2.5 Mabsadd L
.44552 .24238 -1.875 0 Mabsadd L closepath F
.44603 .24304 -1.875 0 Mabsadd m
.44603 .24304 0 2.5 Mabsadd L
.44603 .24304 1.875 0 Mabsadd L
.44603 .24304 0 -2.5 Mabsadd L
.44603 .24304 -1.875 0 Mabsadd L closepath F
.44603 .24336 -1.875 0 Mabsadd m
.44603 .24336 0 2.5 Mabsadd L
.44603 .24336 1.875 0 Mabsadd L
.44603 .24336 0 -2.5 Mabsadd L
.44603 .24336 -1.875 0 Mabsadd L closepath F
.44653 .24336 -1.875 0 Mabsadd m
.44653 .24336 0 2.5 Mabsadd L
.44653 .24336 1.875 0 Mabsadd L
.44653 .24336 0 -2.5 Mabsadd L
.44653 .24336 -1.875 0 Mabsadd L closepath F
.44804 .24369 -1.875 0 Mabsadd m
.44804 .24369 0 2.5 Mabsadd L
.44804 .24369 1.875 0 Mabsadd L
.44804 .24369 0 -2.5 Mabsadd L
.44804 .24369 -1.875 0 Mabsadd L closepath F
.44804 .24369 -1.875 0 Mabsadd m
.44804 .24369 0 2.5 Mabsadd L
.44804 .24369 1.875 0 Mabsadd L
.44804 .24369 0 -2.5 Mabsadd L
.44804 .24369 -1.875 0 Mabsadd L closepath F
.44804 .24369 -1.875 0 Mabsadd m
.44804 .24369 0 2.5 Mabsadd L
.44804 .24369 1.875 0 Mabsadd L
.44804 .24369 0 -2.5 Mabsadd L
.44804 .24369 -1.875 0 Mabsadd L closepath F
.44855 .24369 -1.875 0 Mabsadd m
.44855 .24369 0 2.5 Mabsadd L
.44855 .24369 1.875 0 Mabsadd L
.44855 .24369 0 -2.5 Mabsadd L
.44855 .24369 -1.875 0 Mabsadd L closepath F
.44855 .24369 -1.875 0 Mabsadd m
.44855 .24369 0 2.5 Mabsadd L
.44855 .24369 1.875 0 Mabsadd L
.44855 .24369 0 -2.5 Mabsadd L
.44855 .24369 -1.875 0 Mabsadd L closepath F
.44855 .24369 -1.875 0 Mabsadd m
.44855 .24369 0 2.5 Mabsadd L
.44855 .24369 1.875 0 Mabsadd L
.44855 .24369 0 -2.5 Mabsadd L
.44855 .24369 -1.875 0 Mabsadd L closepath F
.44855 .24402 -1.875 0 Mabsadd m
.44855 .24402 0 2.5 Mabsadd L
.44855 .24402 1.875 0 Mabsadd L
.44855 .24402 0 -2.5 Mabsadd L
.44855 .24402 -1.875 0 Mabsadd L closepath F
.44905 .24402 -1.875 0 Mabsadd m
.44905 .24402 0 2.5 Mabsadd L
.44905 .24402 1.875 0 Mabsadd L
.44905 .24402 0 -2.5 Mabsadd L
.44905 .24402 -1.875 0 Mabsadd L closepath F
.44956 .24402 -1.875 0 Mabsadd m
.44956 .24402 0 2.5 Mabsadd L
.44956 .24402 1.875 0 Mabsadd L
.44956 .24402 0 -2.5 Mabsadd L
.44956 .24402 -1.875 0 Mabsadd L closepath F
.45056 .24434 -1.875 0 Mabsadd m
.45056 .24434 0 2.5 Mabsadd L
.45056 .24434 1.875 0 Mabsadd L
.45056 .24434 0 -2.5 Mabsadd L
.45056 .24434 -1.875 0 Mabsadd L closepath F
.45056 .24434 -1.875 0 Mabsadd m
.45056 .24434 0 2.5 Mabsadd L
.45056 .24434 1.875 0 Mabsadd L
.45056 .24434 0 -2.5 Mabsadd L
.45056 .24434 -1.875 0 Mabsadd L closepath F
.45157 .24434 -1.875 0 Mabsadd m
.45157 .24434 0 2.5 Mabsadd L
.45157 .24434 1.875 0 Mabsadd L
.45157 .24434 0 -2.5 Mabsadd L
.45157 .24434 -1.875 0 Mabsadd L closepath F
.45157 .24467 -1.875 0 Mabsadd m
.45157 .24467 0 2.5 Mabsadd L
.45157 .24467 1.875 0 Mabsadd L
.45157 .24467 0 -2.5 Mabsadd L
.45157 .24467 -1.875 0 Mabsadd L closepath F
.45208 .24467 -1.875 0 Mabsadd m
.45208 .24467 0 2.5 Mabsadd L
.45208 .24467 1.875 0 Mabsadd L
.45208 .24467 0 -2.5 Mabsadd L
.45208 .24467 -1.875 0 Mabsadd L closepath F
.45359 .24565 -1.875 0 Mabsadd m
.45359 .24565 0 2.5 Mabsadd L
.45359 .24565 1.875 0 Mabsadd L
.45359 .24565 0 -2.5 Mabsadd L
.45359 .24565 -1.875 0 Mabsadd L closepath F
.4546 .24598 -1.875 0 Mabsadd m
.4546 .24598 0 2.5 Mabsadd L
.4546 .24598 1.875 0 Mabsadd L
.4546 .24598 0 -2.5 Mabsadd L
.4546 .24598 -1.875 0 Mabsadd L closepath F
.4546 .24598 -1.875 0 Mabsadd m
.4546 .24598 0 2.5 Mabsadd L
.4546 .24598 1.875 0 Mabsadd L
.4546 .24598 0 -2.5 Mabsadd L
.4546 .24598 -1.875 0 Mabsadd L closepath F
.4551 .24598 -1.875 0 Mabsadd m
.4551 .24598 0 2.5 Mabsadd L
.4551 .24598 1.875 0 Mabsadd L
.4551 .24598 0 -2.5 Mabsadd L
.4551 .24598 -1.875 0 Mabsadd L closepath F
.45662 .24598 -1.875 0 Mabsadd m
.45662 .24598 0 2.5 Mabsadd L
.45662 .24598 1.875 0 Mabsadd L
.45662 .24598 0 -2.5 Mabsadd L
.45662 .24598 -1.875 0 Mabsadd L closepath F
.45712 .2463 -1.875 0 Mabsadd m
.45712 .2463 0 2.5 Mabsadd L
.45712 .2463 1.875 0 Mabsadd L
.45712 .2463 0 -2.5 Mabsadd L
.45712 .2463 -1.875 0 Mabsadd L closepath F
.45712 .2463 -1.875 0 Mabsadd m
.45712 .2463 0 2.5 Mabsadd L
.45712 .2463 1.875 0 Mabsadd L
.45712 .2463 0 -2.5 Mabsadd L
.45712 .2463 -1.875 0 Mabsadd L closepath F
.45763 .2463 -1.875 0 Mabsadd m
.45763 .2463 0 2.5 Mabsadd L
.45763 .2463 1.875 0 Mabsadd L
.45763 .2463 0 -2.5 Mabsadd L
.45763 .2463 -1.875 0 Mabsadd L closepath F
.45813 .2463 -1.875 0 Mabsadd m
.45813 .2463 0 2.5 Mabsadd L
.45813 .2463 1.875 0 Mabsadd L
.45813 .2463 0 -2.5 Mabsadd L
.45813 .2463 -1.875 0 Mabsadd L closepath F
.45864 .2463 -1.875 0 Mabsadd m
.45864 .2463 0 2.5 Mabsadd L
.45864 .2463 1.875 0 Mabsadd L
.45864 .2463 0 -2.5 Mabsadd L
.45864 .2463 -1.875 0 Mabsadd L closepath F
.45864 .2463 -1.875 0 Mabsadd m
.45864 .2463 0 2.5 Mabsadd L
.45864 .2463 1.875 0 Mabsadd L
.45864 .2463 0 -2.5 Mabsadd L
.45864 .2463 -1.875 0 Mabsadd L closepath F
.45914 .24663 -1.875 0 Mabsadd m
.45914 .24663 0 2.5 Mabsadd L
.45914 .24663 1.875 0 Mabsadd L
.45914 .24663 0 -2.5 Mabsadd L
.45914 .24663 -1.875 0 Mabsadd L closepath F
.46015 .24663 -1.875 0 Mabsadd m
.46015 .24663 0 2.5 Mabsadd L
.46015 .24663 1.875 0 Mabsadd L
.46015 .24663 0 -2.5 Mabsadd L
.46015 .24663 -1.875 0 Mabsadd L closepath F
.46065 .24663 -1.875 0 Mabsadd m
.46065 .24663 0 2.5 Mabsadd L
.46065 .24663 1.875 0 Mabsadd L
.46065 .24663 0 -2.5 Mabsadd L
.46065 .24663 -1.875 0 Mabsadd L closepath F
.46116 .24663 -1.875 0 Mabsadd m
.46116 .24663 0 2.5 Mabsadd L
.46116 .24663 1.875 0 Mabsadd L
.46116 .24663 0 -2.5 Mabsadd L
.46116 .24663 -1.875 0 Mabsadd L closepath F
.46116 .24696 -1.875 0 Mabsadd m
.46116 .24696 0 2.5 Mabsadd L
.46116 .24696 1.875 0 Mabsadd L
.46116 .24696 0 -2.5 Mabsadd L
.46116 .24696 -1.875 0 Mabsadd L closepath F
.46217 .24696 -1.875 0 Mabsadd m
.46217 .24696 0 2.5 Mabsadd L
.46217 .24696 1.875 0 Mabsadd L
.46217 .24696 0 -2.5 Mabsadd L
.46217 .24696 -1.875 0 Mabsadd L closepath F
.46217 .24728 -1.875 0 Mabsadd m
.46217 .24728 0 2.5 Mabsadd L
.46217 .24728 1.875 0 Mabsadd L
.46217 .24728 0 -2.5 Mabsadd L
.46217 .24728 -1.875 0 Mabsadd L closepath F
.46217 .24761 -1.875 0 Mabsadd m
.46217 .24761 0 2.5 Mabsadd L
.46217 .24761 1.875 0 Mabsadd L
.46217 .24761 0 -2.5 Mabsadd L
.46217 .24761 -1.875 0 Mabsadd L closepath F
.46267 .24794 -1.875 0 Mabsadd m
.46267 .24794 0 2.5 Mabsadd L
.46267 .24794 1.875 0 Mabsadd L
.46267 .24794 0 -2.5 Mabsadd L
.46267 .24794 -1.875 0 Mabsadd L closepath F
.46418 .24826 -1.875 0 Mabsadd m
.46418 .24826 0 2.5 Mabsadd L
.46418 .24826 1.875 0 Mabsadd L
.46418 .24826 0 -2.5 Mabsadd L
.46418 .24826 -1.875 0 Mabsadd L closepath F
.46469 .24826 -1.875 0 Mabsadd m
.46469 .24826 0 2.5 Mabsadd L
.46469 .24826 1.875 0 Mabsadd L
.46469 .24826 0 -2.5 Mabsadd L
.46469 .24826 -1.875 0 Mabsadd L closepath F
.46469 .24826 -1.875 0 Mabsadd m
.46469 .24826 0 2.5 Mabsadd L
.46469 .24826 1.875 0 Mabsadd L
.46469 .24826 0 -2.5 Mabsadd L
.46469 .24826 -1.875 0 Mabsadd L closepath F
.46519 .24859 -1.875 0 Mabsadd m
.46519 .24859 0 2.5 Mabsadd L
.46519 .24859 1.875 0 Mabsadd L
.46519 .24859 0 -2.5 Mabsadd L
.46519 .24859 -1.875 0 Mabsadd L closepath F
.4657 .24859 -1.875 0 Mabsadd m
.4657 .24859 0 2.5 Mabsadd L
.4657 .24859 1.875 0 Mabsadd L
.4657 .24859 0 -2.5 Mabsadd L
.4657 .24859 -1.875 0 Mabsadd L closepath F
.4657 .24892 -1.875 0 Mabsadd m
.4657 .24892 0 2.5 Mabsadd L
.4657 .24892 1.875 0 Mabsadd L
.4657 .24892 0 -2.5 Mabsadd L
.4657 .24892 -1.875 0 Mabsadd L closepath F
.4662 .2499 -1.875 0 Mabsadd m
.4662 .2499 0 2.5 Mabsadd L
.4662 .2499 1.875 0 Mabsadd L
.4662 .2499 0 -2.5 Mabsadd L
.4662 .2499 -1.875 0 Mabsadd L closepath F
.4662 .2499 -1.875 0 Mabsadd m
.4662 .2499 0 2.5 Mabsadd L
.4662 .2499 1.875 0 Mabsadd L
.4662 .2499 0 -2.5 Mabsadd L
.4662 .2499 -1.875 0 Mabsadd L closepath F
.46671 .2499 -1.875 0 Mabsadd m
.46671 .2499 0 2.5 Mabsadd L
.46671 .2499 1.875 0 Mabsadd L
.46671 .2499 0 -2.5 Mabsadd L
.46671 .2499 -1.875 0 Mabsadd L closepath F
.46721 .2499 -1.875 0 Mabsadd m
.46721 .2499 0 2.5 Mabsadd L
.46721 .2499 1.875 0 Mabsadd L
.46721 .2499 0 -2.5 Mabsadd L
.46721 .2499 -1.875 0 Mabsadd L closepath F
.46772 .25055 -1.875 0 Mabsadd m
.46772 .25055 0 2.5 Mabsadd L
.46772 .25055 1.875 0 Mabsadd L
.46772 .25055 0 -2.5 Mabsadd L
.46772 .25055 -1.875 0 Mabsadd L closepath F
.46772 .25088 -1.875 0 Mabsadd m
.46772 .25088 0 2.5 Mabsadd L
.46772 .25088 1.875 0 Mabsadd L
.46772 .25088 0 -2.5 Mabsadd L
.46772 .25088 -1.875 0 Mabsadd L closepath F
.46772 .2512 -1.875 0 Mabsadd m
.46772 .2512 0 2.5 Mabsadd L
.46772 .2512 1.875 0 Mabsadd L
.46772 .2512 0 -2.5 Mabsadd L
.46772 .2512 -1.875 0 Mabsadd L closepath F
.46772 .2512 -1.875 0 Mabsadd m
.46772 .2512 0 2.5 Mabsadd L
.46772 .2512 1.875 0 Mabsadd L
.46772 .2512 0 -2.5 Mabsadd L
.46772 .2512 -1.875 0 Mabsadd L closepath F
.46872 .25218 -1.875 0 Mabsadd m
.46872 .25218 0 2.5 Mabsadd L
.46872 .25218 1.875 0 Mabsadd L
.46872 .25218 0 -2.5 Mabsadd L
.46872 .25218 -1.875 0 Mabsadd L closepath F
.46872 .25251 -1.875 0 Mabsadd m
.46872 .25251 0 2.5 Mabsadd L
.46872 .25251 1.875 0 Mabsadd L
.46872 .25251 0 -2.5 Mabsadd L
.46872 .25251 -1.875 0 Mabsadd L closepath F
.46923 .25251 -1.875 0 Mabsadd m
.46923 .25251 0 2.5 Mabsadd L
.46923 .25251 1.875 0 Mabsadd L
.46923 .25251 0 -2.5 Mabsadd L
.46923 .25251 -1.875 0 Mabsadd L closepath F
.46973 .25284 -1.875 0 Mabsadd m
.46973 .25284 0 2.5 Mabsadd L
.46973 .25284 1.875 0 Mabsadd L
.46973 .25284 0 -2.5 Mabsadd L
.46973 .25284 -1.875 0 Mabsadd L closepath F
.47024 .25284 -1.875 0 Mabsadd m
.47024 .25284 0 2.5 Mabsadd L
.47024 .25284 1.875 0 Mabsadd L
.47024 .25284 0 -2.5 Mabsadd L
.47024 .25284 -1.875 0 Mabsadd L closepath F
.47074 .25316 -1.875 0 Mabsadd m
.47074 .25316 0 2.5 Mabsadd L
.47074 .25316 1.875 0 Mabsadd L
.47074 .25316 0 -2.5 Mabsadd L
.47074 .25316 -1.875 0 Mabsadd L closepath F
.47074 .25349 -1.875 0 Mabsadd m
.47074 .25349 0 2.5 Mabsadd L
.47074 .25349 1.875 0 Mabsadd L
.47074 .25349 0 -2.5 Mabsadd L
.47074 .25349 -1.875 0 Mabsadd L closepath F
.47074 .25349 -1.875 0 Mabsadd m
.47074 .25349 0 2.5 Mabsadd L
.47074 .25349 1.875 0 Mabsadd L
.47074 .25349 0 -2.5 Mabsadd L
.47074 .25349 -1.875 0 Mabsadd L closepath F
.47074 .25381 -1.875 0 Mabsadd m
.47074 .25381 0 2.5 Mabsadd L
.47074 .25381 1.875 0 Mabsadd L
.47074 .25381 0 -2.5 Mabsadd L
.47074 .25381 -1.875 0 Mabsadd L closepath F
.47125 .25381 -1.875 0 Mabsadd m
.47125 .25381 0 2.5 Mabsadd L
.47125 .25381 1.875 0 Mabsadd L
.47125 .25381 0 -2.5 Mabsadd L
.47125 .25381 -1.875 0 Mabsadd L closepath F
.47226 .25381 -1.875 0 Mabsadd m
.47226 .25381 0 2.5 Mabsadd L
.47226 .25381 1.875 0 Mabsadd L
.47226 .25381 0 -2.5 Mabsadd L
.47226 .25381 -1.875 0 Mabsadd L closepath F
.47326 .25414 -1.875 0 Mabsadd m
.47326 .25414 0 2.5 Mabsadd L
.47326 .25414 1.875 0 Mabsadd L
.47326 .25414 0 -2.5 Mabsadd L
.47326 .25414 -1.875 0 Mabsadd L closepath F
.47427 .25447 -1.875 0 Mabsadd m
.47427 .25447 0 2.5 Mabsadd L
.47427 .25447 1.875 0 Mabsadd L
.47427 .25447 0 -2.5 Mabsadd L
.47427 .25447 -1.875 0 Mabsadd L closepath F
.47528 .25512 -1.875 0 Mabsadd m
.47528 .25512 0 2.5 Mabsadd L
.47528 .25512 1.875 0 Mabsadd L
.47528 .25512 0 -2.5 Mabsadd L
.47528 .25512 -1.875 0 Mabsadd L closepath F
.4768 .25512 -1.875 0 Mabsadd m
.4768 .25512 0 2.5 Mabsadd L
.4768 .25512 1.875 0 Mabsadd L
.4768 .25512 0 -2.5 Mabsadd L
.4768 .25512 -1.875 0 Mabsadd L closepath F
.4773 .25545 -1.875 0 Mabsadd m
.4773 .25545 0 2.5 Mabsadd L
.4773 .25545 1.875 0 Mabsadd L
.4773 .25545 0 -2.5 Mabsadd L
.4773 .25545 -1.875 0 Mabsadd L closepath F
.4778 .25577 -1.875 0 Mabsadd m
.4778 .25577 0 2.5 Mabsadd L
.4778 .25577 1.875 0 Mabsadd L
.4778 .25577 0 -2.5 Mabsadd L
.4778 .25577 -1.875 0 Mabsadd L closepath F
.47831 .25643 -1.875 0 Mabsadd m
.47831 .25643 0 2.5 Mabsadd L
.47831 .25643 1.875 0 Mabsadd L
.47831 .25643 0 -2.5 Mabsadd L
.47831 .25643 -1.875 0 Mabsadd L closepath F
.47881 .25708 -1.875 0 Mabsadd m
.47881 .25708 0 2.5 Mabsadd L
.47881 .25708 1.875 0 Mabsadd L
.47881 .25708 0 -2.5 Mabsadd L
.47881 .25708 -1.875 0 Mabsadd L closepath F
.47881 .25708 -1.875 0 Mabsadd m
.47881 .25708 0 2.5 Mabsadd L
.47881 .25708 1.875 0 Mabsadd L
.47881 .25708 0 -2.5 Mabsadd L
.47881 .25708 -1.875 0 Mabsadd L closepath F
.47881 .25741 -1.875 0 Mabsadd m
.47881 .25741 0 2.5 Mabsadd L
.47881 .25741 1.875 0 Mabsadd L
.47881 .25741 0 -2.5 Mabsadd L
.47881 .25741 -1.875 0 Mabsadd L closepath F
.47982 .25741 -1.875 0 Mabsadd m
.47982 .25741 0 2.5 Mabsadd L
.47982 .25741 1.875 0 Mabsadd L
.47982 .25741 0 -2.5 Mabsadd L
.47982 .25741 -1.875 0 Mabsadd L closepath F
.48184 .25741 -1.875 0 Mabsadd m
.48184 .25741 0 2.5 Mabsadd L
.48184 .25741 1.875 0 Mabsadd L
.48184 .25741 0 -2.5 Mabsadd L
.48184 .25741 -1.875 0 Mabsadd L closepath F
.48234 .25773 -1.875 0 Mabsadd m
.48234 .25773 0 2.5 Mabsadd L
.48234 .25773 1.875 0 Mabsadd L
.48234 .25773 0 -2.5 Mabsadd L
.48234 .25773 -1.875 0 Mabsadd L closepath F
.48285 .25806 -1.875 0 Mabsadd m
.48285 .25806 0 2.5 Mabsadd L
.48285 .25806 1.875 0 Mabsadd L
.48285 .25806 0 -2.5 Mabsadd L
.48285 .25806 -1.875 0 Mabsadd L closepath F
.48285 .25839 -1.875 0 Mabsadd m
.48285 .25839 0 2.5 Mabsadd L
.48285 .25839 1.875 0 Mabsadd L
.48285 .25839 0 -2.5 Mabsadd L
.48285 .25839 -1.875 0 Mabsadd L closepath F
.48335 .25871 -1.875 0 Mabsadd m
.48335 .25871 0 2.5 Mabsadd L
.48335 .25871 1.875 0 Mabsadd L
.48335 .25871 0 -2.5 Mabsadd L
.48335 .25871 -1.875 0 Mabsadd L closepath F
.48335 .25871 -1.875 0 Mabsadd m
.48335 .25871 0 2.5 Mabsadd L
.48335 .25871 1.875 0 Mabsadd L
.48335 .25871 0 -2.5 Mabsadd L
.48335 .25871 -1.875 0 Mabsadd L closepath F
.48436 .25871 -1.875 0 Mabsadd m
.48436 .25871 0 2.5 Mabsadd L
.48436 .25871 1.875 0 Mabsadd L
.48436 .25871 0 -2.5 Mabsadd L
.48436 .25871 -1.875 0 Mabsadd L closepath F
.48487 .25871 -1.875 0 Mabsadd m
.48487 .25871 0 2.5 Mabsadd L
.48487 .25871 1.875 0 Mabsadd L
.48487 .25871 0 -2.5 Mabsadd L
.48487 .25871 -1.875 0 Mabsadd L closepath F
.48537 .25904 -1.875 0 Mabsadd m
.48537 .25904 0 2.5 Mabsadd L
.48537 .25904 1.875 0 Mabsadd L
.48537 .25904 0 -2.5 Mabsadd L
.48537 .25904 -1.875 0 Mabsadd L closepath F
.48537 .25904 -1.875 0 Mabsadd m
.48537 .25904 0 2.5 Mabsadd L
.48537 .25904 1.875 0 Mabsadd L
.48537 .25904 0 -2.5 Mabsadd L
.48537 .25904 -1.875 0 Mabsadd L closepath F
.48537 .25937 -1.875 0 Mabsadd m
.48537 .25937 0 2.5 Mabsadd L
.48537 .25937 1.875 0 Mabsadd L
.48537 .25937 0 -2.5 Mabsadd L
.48537 .25937 -1.875 0 Mabsadd L closepath F
.48588 .25937 -1.875 0 Mabsadd m
.48588 .25937 0 2.5 Mabsadd L
.48588 .25937 1.875 0 Mabsadd L
.48588 .25937 0 -2.5 Mabsadd L
.48588 .25937 -1.875 0 Mabsadd L closepath F
.48588 .25937 -1.875 0 Mabsadd m
.48588 .25937 0 2.5 Mabsadd L
.48588 .25937 1.875 0 Mabsadd L
.48588 .25937 0 -2.5 Mabsadd L
.48588 .25937 -1.875 0 Mabsadd L closepath F
.48588 .25969 -1.875 0 Mabsadd m
.48588 .25969 0 2.5 Mabsadd L
.48588 .25969 1.875 0 Mabsadd L
.48588 .25969 0 -2.5 Mabsadd L
.48588 .25969 -1.875 0 Mabsadd L closepath F
.48638 .25969 -1.875 0 Mabsadd m
.48638 .25969 0 2.5 Mabsadd L
.48638 .25969 1.875 0 Mabsadd L
.48638 .25969 0 -2.5 Mabsadd L
.48638 .25969 -1.875 0 Mabsadd L closepath F
.48688 .25969 -1.875 0 Mabsadd m
.48688 .25969 0 2.5 Mabsadd L
.48688 .25969 1.875 0 Mabsadd L
.48688 .25969 0 -2.5 Mabsadd L
.48688 .25969 -1.875 0 Mabsadd L closepath F
.48789 .26035 -1.875 0 Mabsadd m
.48789 .26035 0 2.5 Mabsadd L
.48789 .26035 1.875 0 Mabsadd L
.48789 .26035 0 -2.5 Mabsadd L
.48789 .26035 -1.875 0 Mabsadd L closepath F
.4889 .26067 -1.875 0 Mabsadd m
.4889 .26067 0 2.5 Mabsadd L
.4889 .26067 1.875 0 Mabsadd L
.4889 .26067 0 -2.5 Mabsadd L
.4889 .26067 -1.875 0 Mabsadd L closepath F
.48941 .261 -1.875 0 Mabsadd m
.48941 .261 0 2.5 Mabsadd L
.48941 .261 1.875 0 Mabsadd L
.48941 .261 0 -2.5 Mabsadd L
.48941 .261 -1.875 0 Mabsadd L closepath F
.48941 .26133 -1.875 0 Mabsadd m
.48941 .26133 0 2.5 Mabsadd L
.48941 .26133 1.875 0 Mabsadd L
.48941 .26133 0 -2.5 Mabsadd L
.48941 .26133 -1.875 0 Mabsadd L closepath F
.48941 .26133 -1.875 0 Mabsadd m
.48941 .26133 0 2.5 Mabsadd L
.48941 .26133 1.875 0 Mabsadd L
.48941 .26133 0 -2.5 Mabsadd L
.48941 .26133 -1.875 0 Mabsadd L closepath F
.48991 .26165 -1.875 0 Mabsadd m
.48991 .26165 0 2.5 Mabsadd L
.48991 .26165 1.875 0 Mabsadd L
.48991 .26165 0 -2.5 Mabsadd L
.48991 .26165 -1.875 0 Mabsadd L closepath F
.48991 .26165 -1.875 0 Mabsadd m
.48991 .26165 0 2.5 Mabsadd L
.48991 .26165 1.875 0 Mabsadd L
.48991 .26165 0 -2.5 Mabsadd L
.48991 .26165 -1.875 0 Mabsadd L closepath F
.48991 .26198 -1.875 0 Mabsadd m
.48991 .26198 0 2.5 Mabsadd L
.48991 .26198 1.875 0 Mabsadd L
.48991 .26198 0 -2.5 Mabsadd L
.48991 .26198 -1.875 0 Mabsadd L closepath F
.48991 .26231 -1.875 0 Mabsadd m
.48991 .26231 0 2.5 Mabsadd L
.48991 .26231 1.875 0 Mabsadd L
.48991 .26231 0 -2.5 Mabsadd L
.48991 .26231 -1.875 0 Mabsadd L closepath F
.49042 .26263 -1.875 0 Mabsadd m
.49042 .26263 0 2.5 Mabsadd L
.49042 .26263 1.875 0 Mabsadd L
.49042 .26263 0 -2.5 Mabsadd L
.49042 .26263 -1.875 0 Mabsadd L closepath F
.49042 .26296 -1.875 0 Mabsadd m
.49042 .26296 0 2.5 Mabsadd L
.49042 .26296 1.875 0 Mabsadd L
.49042 .26296 0 -2.5 Mabsadd L
.49042 .26296 -1.875 0 Mabsadd L closepath F
.49042 .26296 -1.875 0 Mabsadd m
.49042 .26296 0 2.5 Mabsadd L
.49042 .26296 1.875 0 Mabsadd L
.49042 .26296 0 -2.5 Mabsadd L
.49042 .26296 -1.875 0 Mabsadd L closepath F
.49092 .26329 -1.875 0 Mabsadd m
.49092 .26329 0 2.5 Mabsadd L
.49092 .26329 1.875 0 Mabsadd L
.49092 .26329 0 -2.5 Mabsadd L
.49092 .26329 -1.875 0 Mabsadd L closepath F
.49243 .26329 -1.875 0 Mabsadd m
.49243 .26329 0 2.5 Mabsadd L
.49243 .26329 1.875 0 Mabsadd L
.49243 .26329 0 -2.5 Mabsadd L
.49243 .26329 -1.875 0 Mabsadd L closepath F
.49243 .26329 -1.875 0 Mabsadd m
.49243 .26329 0 2.5 Mabsadd L
.49243 .26329 1.875 0 Mabsadd L
.49243 .26329 0 -2.5 Mabsadd L
.49243 .26329 -1.875 0 Mabsadd L closepath F
.49243 .26361 -1.875 0 Mabsadd m
.49243 .26361 0 2.5 Mabsadd L
.49243 .26361 1.875 0 Mabsadd L
.49243 .26361 0 -2.5 Mabsadd L
.49243 .26361 -1.875 0 Mabsadd L closepath F
.49294 .26427 -1.875 0 Mabsadd m
.49294 .26427 0 2.5 Mabsadd L
.49294 .26427 1.875 0 Mabsadd L
.49294 .26427 0 -2.5 Mabsadd L
.49294 .26427 -1.875 0 Mabsadd L closepath F
.49294 .26459 -1.875 0 Mabsadd m
.49294 .26459 0 2.5 Mabsadd L
.49294 .26459 1.875 0 Mabsadd L
.49294 .26459 0 -2.5 Mabsadd L
.49294 .26459 -1.875 0 Mabsadd L closepath F
.49344 .26525 -1.875 0 Mabsadd m
.49344 .26525 0 2.5 Mabsadd L
.49344 .26525 1.875 0 Mabsadd L
.49344 .26525 0 -2.5 Mabsadd L
.49344 .26525 -1.875 0 Mabsadd L closepath F
.49546 .2659 -1.875 0 Mabsadd m
.49546 .2659 0 2.5 Mabsadd L
.49546 .2659 1.875 0 Mabsadd L
.49546 .2659 0 -2.5 Mabsadd L
.49546 .2659 -1.875 0 Mabsadd L closepath F
.49546 .26623 -1.875 0 Mabsadd m
.49546 .26623 0 2.5 Mabsadd L
.49546 .26623 1.875 0 Mabsadd L
.49546 .26623 0 -2.5 Mabsadd L
.49546 .26623 -1.875 0 Mabsadd L closepath F
.49647 .26655 -1.875 0 Mabsadd m
.49647 .26655 0 2.5 Mabsadd L
.49647 .26655 1.875 0 Mabsadd L
.49647 .26655 0 -2.5 Mabsadd L
.49647 .26655 -1.875 0 Mabsadd L closepath F
.49647 .26753 -1.875 0 Mabsadd m
.49647 .26753 0 2.5 Mabsadd L
.49647 .26753 1.875 0 Mabsadd L
.49647 .26753 0 -2.5 Mabsadd L
.49647 .26753 -1.875 0 Mabsadd L closepath F
.49647 .26786 -1.875 0 Mabsadd m
.49647 .26786 0 2.5 Mabsadd L
.49647 .26786 1.875 0 Mabsadd L
.49647 .26786 0 -2.5 Mabsadd L
.49647 .26786 -1.875 0 Mabsadd L closepath F
.49647 .26786 -1.875 0 Mabsadd m
.49647 .26786 0 2.5 Mabsadd L
.49647 .26786 1.875 0 Mabsadd L
.49647 .26786 0 -2.5 Mabsadd L
.49647 .26786 -1.875 0 Mabsadd L closepath F
.49798 .26819 -1.875 0 Mabsadd m
.49798 .26819 0 2.5 Mabsadd L
.49798 .26819 1.875 0 Mabsadd L
.49798 .26819 0 -2.5 Mabsadd L
.49798 .26819 -1.875 0 Mabsadd L closepath F
.49899 .26884 -1.875 0 Mabsadd m
.49899 .26884 0 2.5 Mabsadd L
.49899 .26884 1.875 0 Mabsadd L
.49899 .26884 0 -2.5 Mabsadd L
.49899 .26884 -1.875 0 Mabsadd L closepath F
.49899 .26884 -1.875 0 Mabsadd m
.49899 .26884 0 2.5 Mabsadd L
.49899 .26884 1.875 0 Mabsadd L
.49899 .26884 0 -2.5 Mabsadd L
.49899 .26884 -1.875 0 Mabsadd L closepath F
.4995 .26917 -1.875 0 Mabsadd m
.4995 .26917 0 2.5 Mabsadd L
.4995 .26917 1.875 0 Mabsadd L
.4995 .26917 0 -2.5 Mabsadd L
.4995 .26917 -1.875 0 Mabsadd L closepath F
.4995 .26949 -1.875 0 Mabsadd m
.4995 .26949 0 2.5 Mabsadd L
.4995 .26949 1.875 0 Mabsadd L
.4995 .26949 0 -2.5 Mabsadd L
.4995 .26949 -1.875 0 Mabsadd L closepath F
.4995 .26949 -1.875 0 Mabsadd m
.4995 .26949 0 2.5 Mabsadd L
.4995 .26949 1.875 0 Mabsadd L
.4995 .26949 0 -2.5 Mabsadd L
.4995 .26949 -1.875 0 Mabsadd L closepath F
.5 .26982 -1.875 0 Mabsadd m
.5 .26982 0 2.5 Mabsadd L
.5 .26982 1.875 0 Mabsadd L
.5 .26982 0 -2.5 Mabsadd L
.5 .26982 -1.875 0 Mabsadd L closepath F
.5005 .26982 -1.875 0 Mabsadd m
.5005 .26982 0 2.5 Mabsadd L
.5005 .26982 1.875 0 Mabsadd L
.5005 .26982 0 -2.5 Mabsadd L
.5005 .26982 -1.875 0 Mabsadd L closepath F
.50101 .2708 -1.875 0 Mabsadd m
.50101 .2708 0 2.5 Mabsadd L
.50101 .2708 1.875 0 Mabsadd L
.50101 .2708 0 -2.5 Mabsadd L
.50101 .2708 -1.875 0 Mabsadd L closepath F
.50202 .27113 -1.875 0 Mabsadd m
.50202 .27113 0 2.5 Mabsadd L
.50202 .27113 1.875 0 Mabsadd L
.50202 .27113 0 -2.5 Mabsadd L
.50202 .27113 -1.875 0 Mabsadd L closepath F
.50202 .27178 -1.875 0 Mabsadd m
.50202 .27178 0 2.5 Mabsadd L
.50202 .27178 1.875 0 Mabsadd L
.50202 .27178 0 -2.5 Mabsadd L
.50202 .27178 -1.875 0 Mabsadd L closepath F
.50202 .27211 -1.875 0 Mabsadd m
.50202 .27211 0 2.5 Mabsadd L
.50202 .27211 1.875 0 Mabsadd L
.50202 .27211 0 -2.5 Mabsadd L
.50202 .27211 -1.875 0 Mabsadd L closepath F
.50303 .27211 -1.875 0 Mabsadd m
.50303 .27211 0 2.5 Mabsadd L
.50303 .27211 1.875 0 Mabsadd L
.50303 .27211 0 -2.5 Mabsadd L
.50303 .27211 -1.875 0 Mabsadd L closepath F
.50353 .27243 -1.875 0 Mabsadd m
.50353 .27243 0 2.5 Mabsadd L
.50353 .27243 1.875 0 Mabsadd L
.50353 .27243 0 -2.5 Mabsadd L
.50353 .27243 -1.875 0 Mabsadd L closepath F
.50353 .27276 -1.875 0 Mabsadd m
.50353 .27276 0 2.5 Mabsadd L
.50353 .27276 1.875 0 Mabsadd L
.50353 .27276 0 -2.5 Mabsadd L
.50353 .27276 -1.875 0 Mabsadd L closepath F
.50404 .27276 -1.875 0 Mabsadd m
.50404 .27276 0 2.5 Mabsadd L
.50404 .27276 1.875 0 Mabsadd L
.50404 .27276 0 -2.5 Mabsadd L
.50404 .27276 -1.875 0 Mabsadd L closepath F
.50454 .27309 -1.875 0 Mabsadd m
.50454 .27309 0 2.5 Mabsadd L
.50454 .27309 1.875 0 Mabsadd L
.50454 .27309 0 -2.5 Mabsadd L
.50454 .27309 -1.875 0 Mabsadd L closepath F
.50504 .27341 -1.875 0 Mabsadd m
.50504 .27341 0 2.5 Mabsadd L
.50504 .27341 1.875 0 Mabsadd L
.50504 .27341 0 -2.5 Mabsadd L
.50504 .27341 -1.875 0 Mabsadd L closepath F
.50555 .27374 -1.875 0 Mabsadd m
.50555 .27374 0 2.5 Mabsadd L
.50555 .27374 1.875 0 Mabsadd L
.50555 .27374 0 -2.5 Mabsadd L
.50555 .27374 -1.875 0 Mabsadd L closepath F
.50605 .27407 -1.875 0 Mabsadd m
.50605 .27407 0 2.5 Mabsadd L
.50605 .27407 1.875 0 Mabsadd L
.50605 .27407 0 -2.5 Mabsadd L
.50605 .27407 -1.875 0 Mabsadd L closepath F
.50757 .27407 -1.875 0 Mabsadd m
.50757 .27407 0 2.5 Mabsadd L
.50757 .27407 1.875 0 Mabsadd L
.50757 .27407 0 -2.5 Mabsadd L
.50757 .27407 -1.875 0 Mabsadd L closepath F
.50858 .27407 -1.875 0 Mabsadd m
.50858 .27407 0 2.5 Mabsadd L
.50858 .27407 1.875 0 Mabsadd L
.50858 .27407 0 -2.5 Mabsadd L
.50858 .27407 -1.875 0 Mabsadd L closepath F
.50958 .27439 -1.875 0 Mabsadd m
.50958 .27439 0 2.5 Mabsadd L
.50958 .27439 1.875 0 Mabsadd L
.50958 .27439 0 -2.5 Mabsadd L
.50958 .27439 -1.875 0 Mabsadd L closepath F
.51009 .27439 -1.875 0 Mabsadd m
.51009 .27439 0 2.5 Mabsadd L
.51009 .27439 1.875 0 Mabsadd L
.51009 .27439 0 -2.5 Mabsadd L
.51009 .27439 -1.875 0 Mabsadd L closepath F
.51059 .27472 -1.875 0 Mabsadd m
.51059 .27472 0 2.5 Mabsadd L
.51059 .27472 1.875 0 Mabsadd L
.51059 .27472 0 -2.5 Mabsadd L
.51059 .27472 -1.875 0 Mabsadd L closepath F
.5111 .27472 -1.875 0 Mabsadd m
.5111 .27472 0 2.5 Mabsadd L
.5111 .27472 1.875 0 Mabsadd L
.5111 .27472 0 -2.5 Mabsadd L
.5111 .27472 -1.875 0 Mabsadd L closepath F
.5111 .27505 -1.875 0 Mabsadd m
.5111 .27505 0 2.5 Mabsadd L
.5111 .27505 1.875 0 Mabsadd L
.5111 .27505 0 -2.5 Mabsadd L
.5111 .27505 -1.875 0 Mabsadd L closepath F
.51261 .27505 -1.875 0 Mabsadd m
.51261 .27505 0 2.5 Mabsadd L
.51261 .27505 1.875 0 Mabsadd L
.51261 .27505 0 -2.5 Mabsadd L
.51261 .27505 -1.875 0 Mabsadd L closepath F
.51261 .27505 -1.875 0 Mabsadd m
.51261 .27505 0 2.5 Mabsadd L
.51261 .27505 1.875 0 Mabsadd L
.51261 .27505 0 -2.5 Mabsadd L
.51261 .27505 -1.875 0 Mabsadd L closepath F
.51362 .2757 -1.875 0 Mabsadd m
.51362 .2757 0 2.5 Mabsadd L
.51362 .2757 1.875 0 Mabsadd L
.51362 .2757 0 -2.5 Mabsadd L
.51362 .2757 -1.875 0 Mabsadd L closepath F
.51362 .2757 -1.875 0 Mabsadd m
.51362 .2757 0 2.5 Mabsadd L
.51362 .2757 1.875 0 Mabsadd L
.51362 .2757 0 -2.5 Mabsadd L
.51362 .2757 -1.875 0 Mabsadd L closepath F
.51412 .27668 -1.875 0 Mabsadd m
.51412 .27668 0 2.5 Mabsadd L
.51412 .27668 1.875 0 Mabsadd L
.51412 .27668 0 -2.5 Mabsadd L
.51412 .27668 -1.875 0 Mabsadd L closepath F
.51412 .27701 -1.875 0 Mabsadd m
.51412 .27701 0 2.5 Mabsadd L
.51412 .27701 1.875 0 Mabsadd L
.51412 .27701 0 -2.5 Mabsadd L
.51412 .27701 -1.875 0 Mabsadd L closepath F
.51412 .27701 -1.875 0 Mabsadd m
.51412 .27701 0 2.5 Mabsadd L
.51412 .27701 1.875 0 Mabsadd L
.51412 .27701 0 -2.5 Mabsadd L
.51412 .27701 -1.875 0 Mabsadd L closepath F
.51463 .27799 -1.875 0 Mabsadd m
.51463 .27799 0 2.5 Mabsadd L
.51463 .27799 1.875 0 Mabsadd L
.51463 .27799 0 -2.5 Mabsadd L
.51463 .27799 -1.875 0 Mabsadd L closepath F
.51463 .27897 -1.875 0 Mabsadd m
.51463 .27897 0 2.5 Mabsadd L
.51463 .27897 1.875 0 Mabsadd L
.51463 .27897 0 -2.5 Mabsadd L
.51463 .27897 -1.875 0 Mabsadd L closepath F
.51766 .27897 -1.875 0 Mabsadd m
.51766 .27897 0 2.5 Mabsadd L
.51766 .27897 1.875 0 Mabsadd L
.51766 .27897 0 -2.5 Mabsadd L
.51766 .27897 -1.875 0 Mabsadd L closepath F
.51866 .27962 -1.875 0 Mabsadd m
.51866 .27962 0 2.5 Mabsadd L
.51866 .27962 1.875 0 Mabsadd L
.51866 .27962 0 -2.5 Mabsadd L
.51866 .27962 -1.875 0 Mabsadd L closepath F
.51917 .27962 -1.875 0 Mabsadd m
.51917 .27962 0 2.5 Mabsadd L
.51917 .27962 1.875 0 Mabsadd L
.51917 .27962 0 -2.5 Mabsadd L
.51917 .27962 -1.875 0 Mabsadd L closepath F
.51917 .27962 -1.875 0 Mabsadd m
.51917 .27962 0 2.5 Mabsadd L
.51917 .27962 1.875 0 Mabsadd L
.51917 .27962 0 -2.5 Mabsadd L
.51917 .27962 -1.875 0 Mabsadd L closepath F
.51917 .27995 -1.875 0 Mabsadd m
.51917 .27995 0 2.5 Mabsadd L
.51917 .27995 1.875 0 Mabsadd L
.51917 .27995 0 -2.5 Mabsadd L
.51917 .27995 -1.875 0 Mabsadd L closepath F
.51917 .27995 -1.875 0 Mabsadd m
.51917 .27995 0 2.5 Mabsadd L
.51917 .27995 1.875 0 Mabsadd L
.51917 .27995 0 -2.5 Mabsadd L
.51917 .27995 -1.875 0 Mabsadd L closepath F
.51967 .28027 -1.875 0 Mabsadd m
.51967 .28027 0 2.5 Mabsadd L
.51967 .28027 1.875 0 Mabsadd L
.51967 .28027 0 -2.5 Mabsadd L
.51967 .28027 -1.875 0 Mabsadd L closepath F
.52018 .28027 -1.875 0 Mabsadd m
.52018 .28027 0 2.5 Mabsadd L
.52018 .28027 1.875 0 Mabsadd L
.52018 .28027 0 -2.5 Mabsadd L
.52018 .28027 -1.875 0 Mabsadd L closepath F
.52068 .2806 -1.875 0 Mabsadd m
.52068 .2806 0 2.5 Mabsadd L
.52068 .2806 1.875 0 Mabsadd L
.52068 .2806 0 -2.5 Mabsadd L
.52068 .2806 -1.875 0 Mabsadd L closepath F
.52119 .28093 -1.875 0 Mabsadd m
.52119 .28093 0 2.5 Mabsadd L
.52119 .28093 1.875 0 Mabsadd L
.52119 .28093 0 -2.5 Mabsadd L
.52119 .28093 -1.875 0 Mabsadd L closepath F
.5227 .28093 -1.875 0 Mabsadd m
.5227 .28093 0 2.5 Mabsadd L
.5227 .28093 1.875 0 Mabsadd L
.5227 .28093 0 -2.5 Mabsadd L
.5227 .28093 -1.875 0 Mabsadd L closepath F
.5227 .28223 -1.875 0 Mabsadd m
.5227 .28223 0 2.5 Mabsadd L
.5227 .28223 1.875 0 Mabsadd L
.5227 .28223 0 -2.5 Mabsadd L
.5227 .28223 -1.875 0 Mabsadd L closepath F
.52472 .28223 -1.875 0 Mabsadd m
.52472 .28223 0 2.5 Mabsadd L
.52472 .28223 1.875 0 Mabsadd L
.52472 .28223 0 -2.5 Mabsadd L
.52472 .28223 -1.875 0 Mabsadd L closepath F
.52522 .28256 -1.875 0 Mabsadd m
.52522 .28256 0 2.5 Mabsadd L
.52522 .28256 1.875 0 Mabsadd L
.52522 .28256 0 -2.5 Mabsadd L
.52522 .28256 -1.875 0 Mabsadd L closepath F
.52674 .28256 -1.875 0 Mabsadd m
.52674 .28256 0 2.5 Mabsadd L
.52674 .28256 1.875 0 Mabsadd L
.52674 .28256 0 -2.5 Mabsadd L
.52674 .28256 -1.875 0 Mabsadd L closepath F
.52674 .28387 -1.875 0 Mabsadd m
.52674 .28387 0 2.5 Mabsadd L
.52674 .28387 1.875 0 Mabsadd L
.52674 .28387 0 -2.5 Mabsadd L
.52674 .28387 -1.875 0 Mabsadd L closepath F
.52674 .28387 -1.875 0 Mabsadd m
.52674 .28387 0 2.5 Mabsadd L
.52674 .28387 1.875 0 Mabsadd L
.52674 .28387 0 -2.5 Mabsadd L
.52674 .28387 -1.875 0 Mabsadd L closepath F
.52724 .28387 -1.875 0 Mabsadd m
.52724 .28387 0 2.5 Mabsadd L
.52724 .28387 1.875 0 Mabsadd L
.52724 .28387 0 -2.5 Mabsadd L
.52724 .28387 -1.875 0 Mabsadd L closepath F
.52774 .28419 -1.875 0 Mabsadd m
.52774 .28419 0 2.5 Mabsadd L
.52774 .28419 1.875 0 Mabsadd L
.52774 .28419 0 -2.5 Mabsadd L
.52774 .28419 -1.875 0 Mabsadd L closepath F
.52774 .28419 -1.875 0 Mabsadd m
.52774 .28419 0 2.5 Mabsadd L
.52774 .28419 1.875 0 Mabsadd L
.52774 .28419 0 -2.5 Mabsadd L
.52774 .28419 -1.875 0 Mabsadd L closepath F
.52825 .28452 -1.875 0 Mabsadd m
.52825 .28452 0 2.5 Mabsadd L
.52825 .28452 1.875 0 Mabsadd L
.52825 .28452 0 -2.5 Mabsadd L
.52825 .28452 -1.875 0 Mabsadd L closepath F
.52875 .28452 -1.875 0 Mabsadd m
.52875 .28452 0 2.5 Mabsadd L
.52875 .28452 1.875 0 Mabsadd L
.52875 .28452 0 -2.5 Mabsadd L
.52875 .28452 -1.875 0 Mabsadd L closepath F
.52926 .28452 -1.875 0 Mabsadd m
.52926 .28452 0 2.5 Mabsadd L
.52926 .28452 1.875 0 Mabsadd L
.52926 .28452 0 -2.5 Mabsadd L
.52926 .28452 -1.875 0 Mabsadd L closepath F
.52976 .28517 -1.875 0 Mabsadd m
.52976 .28517 0 2.5 Mabsadd L
.52976 .28517 1.875 0 Mabsadd L
.52976 .28517 0 -2.5 Mabsadd L
.52976 .28517 -1.875 0 Mabsadd L closepath F
.53027 .2855 -1.875 0 Mabsadd m
.53027 .2855 0 2.5 Mabsadd L
.53027 .2855 1.875 0 Mabsadd L
.53027 .2855 0 -2.5 Mabsadd L
.53027 .2855 -1.875 0 Mabsadd L closepath F
.53077 .28615 -1.875 0 Mabsadd m
.53077 .28615 0 2.5 Mabsadd L
.53077 .28615 1.875 0 Mabsadd L
.53077 .28615 0 -2.5 Mabsadd L
.53077 .28615 -1.875 0 Mabsadd L closepath F
.53077 .28681 -1.875 0 Mabsadd m
.53077 .28681 0 2.5 Mabsadd L
.53077 .28681 1.875 0 Mabsadd L
.53077 .28681 0 -2.5 Mabsadd L
.53077 .28681 -1.875 0 Mabsadd L closepath F
.53077 .28746 -1.875 0 Mabsadd m
.53077 .28746 0 2.5 Mabsadd L
.53077 .28746 1.875 0 Mabsadd L
.53077 .28746 0 -2.5 Mabsadd L
.53077 .28746 -1.875 0 Mabsadd L closepath F
.53128 .28779 -1.875 0 Mabsadd m
.53128 .28779 0 2.5 Mabsadd L
.53128 .28779 1.875 0 Mabsadd L
.53128 .28779 0 -2.5 Mabsadd L
.53128 .28779 -1.875 0 Mabsadd L closepath F
.53178 .28779 -1.875 0 Mabsadd m
.53178 .28779 0 2.5 Mabsadd L
.53178 .28779 1.875 0 Mabsadd L
.53178 .28779 0 -2.5 Mabsadd L
.53178 .28779 -1.875 0 Mabsadd L closepath F
.53228 .28779 -1.875 0 Mabsadd m
.53228 .28779 0 2.5 Mabsadd L
.53228 .28779 1.875 0 Mabsadd L
.53228 .28779 0 -2.5 Mabsadd L
.53228 .28779 -1.875 0 Mabsadd L closepath F
.53329 .28811 -1.875 0 Mabsadd m
.53329 .28811 0 2.5 Mabsadd L
.53329 .28811 1.875 0 Mabsadd L
.53329 .28811 0 -2.5 Mabsadd L
.53329 .28811 -1.875 0 Mabsadd L closepath F
.5338 .28844 -1.875 0 Mabsadd m
.5338 .28844 0 2.5 Mabsadd L
.5338 .28844 1.875 0 Mabsadd L
.5338 .28844 0 -2.5 Mabsadd L
.5338 .28844 -1.875 0 Mabsadd L closepath F
.5338 .28877 -1.875 0 Mabsadd m
.5338 .28877 0 2.5 Mabsadd L
.5338 .28877 1.875 0 Mabsadd L
.5338 .28877 0 -2.5 Mabsadd L
.5338 .28877 -1.875 0 Mabsadd L closepath F
.5343 .28975 -1.875 0 Mabsadd m
.5343 .28975 0 2.5 Mabsadd L
.5343 .28975 1.875 0 Mabsadd L
.5343 .28975 0 -2.5 Mabsadd L
.5343 .28975 -1.875 0 Mabsadd L closepath F
.5343 .29105 -1.875 0 Mabsadd m
.5343 .29105 0 2.5 Mabsadd L
.5343 .29105 1.875 0 Mabsadd L
.5343 .29105 0 -2.5 Mabsadd L
.5343 .29105 -1.875 0 Mabsadd L closepath F
.53582 .29138 -1.875 0 Mabsadd m
.53582 .29138 0 2.5 Mabsadd L
.53582 .29138 1.875 0 Mabsadd L
.53582 .29138 0 -2.5 Mabsadd L
.53582 .29138 -1.875 0 Mabsadd L closepath F
.53582 .29171 -1.875 0 Mabsadd m
.53582 .29171 0 2.5 Mabsadd L
.53582 .29171 1.875 0 Mabsadd L
.53582 .29171 0 -2.5 Mabsadd L
.53582 .29171 -1.875 0 Mabsadd L closepath F
.53582 .29171 -1.875 0 Mabsadd m
.53582 .29171 0 2.5 Mabsadd L
.53582 .29171 1.875 0 Mabsadd L
.53582 .29171 0 -2.5 Mabsadd L
.53582 .29171 -1.875 0 Mabsadd L closepath F
.53582 .29236 -1.875 0 Mabsadd m
.53582 .29236 0 2.5 Mabsadd L
.53582 .29236 1.875 0 Mabsadd L
.53582 .29236 0 -2.5 Mabsadd L
.53582 .29236 -1.875 0 Mabsadd L closepath F
.53733 .29236 -1.875 0 Mabsadd m
.53733 .29236 0 2.5 Mabsadd L
.53733 .29236 1.875 0 Mabsadd L
.53733 .29236 0 -2.5 Mabsadd L
.53733 .29236 -1.875 0 Mabsadd L closepath F
.53834 .29269 -1.875 0 Mabsadd m
.53834 .29269 0 2.5 Mabsadd L
.53834 .29269 1.875 0 Mabsadd L
.53834 .29269 0 -2.5 Mabsadd L
.53834 .29269 -1.875 0 Mabsadd L closepath F
.53985 .29366 -1.875 0 Mabsadd m
.53985 .29366 0 2.5 Mabsadd L
.53985 .29366 1.875 0 Mabsadd L
.53985 .29366 0 -2.5 Mabsadd L
.53985 .29366 -1.875 0 Mabsadd L closepath F
.54288 .29366 -1.875 0 Mabsadd m
.54288 .29366 0 2.5 Mabsadd L
.54288 .29366 1.875 0 Mabsadd L
.54288 .29366 0 -2.5 Mabsadd L
.54288 .29366 -1.875 0 Mabsadd L closepath F
.54439 .29628 -1.875 0 Mabsadd m
.54439 .29628 0 2.5 Mabsadd L
.54439 .29628 1.875 0 Mabsadd L
.54439 .29628 0 -2.5 Mabsadd L
.54439 .29628 -1.875 0 Mabsadd L closepath F
.54843 .29726 -1.875 0 Mabsadd m
.54843 .29726 0 2.5 Mabsadd L
.54843 .29726 1.875 0 Mabsadd L
.54843 .29726 0 -2.5 Mabsadd L
.54843 .29726 -1.875 0 Mabsadd L closepath F
.54944 .29726 -1.875 0 Mabsadd m
.54944 .29726 0 2.5 Mabsadd L
.54944 .29726 1.875 0 Mabsadd L
.54944 .29726 0 -2.5 Mabsadd L
.54944 .29726 -1.875 0 Mabsadd L closepath F
.54994 .29758 -1.875 0 Mabsadd m
.54994 .29758 0 2.5 Mabsadd L
.54994 .29758 1.875 0 Mabsadd L
.54994 .29758 0 -2.5 Mabsadd L
.54994 .29758 -1.875 0 Mabsadd L closepath F
.54994 .29922 -1.875 0 Mabsadd m
.54994 .29922 0 2.5 Mabsadd L
.54994 .29922 1.875 0 Mabsadd L
.54994 .29922 0 -2.5 Mabsadd L
.54994 .29922 -1.875 0 Mabsadd L closepath F
.54994 .30052 -1.875 0 Mabsadd m
.54994 .30052 0 2.5 Mabsadd L
.54994 .30052 1.875 0 Mabsadd L
.54994 .30052 0 -2.5 Mabsadd L
.54994 .30052 -1.875 0 Mabsadd L closepath F
.55145 .30085 -1.875 0 Mabsadd m
.55145 .30085 0 2.5 Mabsadd L
.55145 .30085 1.875 0 Mabsadd L
.55145 .30085 0 -2.5 Mabsadd L
.55145 .30085 -1.875 0 Mabsadd L closepath F
.55145 .30085 -1.875 0 Mabsadd m
.55145 .30085 0 2.5 Mabsadd L
.55145 .30085 1.875 0 Mabsadd L
.55145 .30085 0 -2.5 Mabsadd L
.55145 .30085 -1.875 0 Mabsadd L closepath F
.55196 .30085 -1.875 0 Mabsadd m
.55196 .30085 0 2.5 Mabsadd L
.55196 .30085 1.875 0 Mabsadd L
.55196 .30085 0 -2.5 Mabsadd L
.55196 .30085 -1.875 0 Mabsadd L closepath F
.55397 .3015 -1.875 0 Mabsadd m
.55397 .3015 0 2.5 Mabsadd L
.55397 .3015 1.875 0 Mabsadd L
.55397 .3015 0 -2.5 Mabsadd L
.55397 .3015 -1.875 0 Mabsadd L closepath F
.55498 .30314 -1.875 0 Mabsadd m
.55498 .30314 0 2.5 Mabsadd L
.55498 .30314 1.875 0 Mabsadd L
.55498 .30314 0 -2.5 Mabsadd L
.55498 .30314 -1.875 0 Mabsadd L closepath F
.5565 .30314 -1.875 0 Mabsadd m
.5565 .30314 0 2.5 Mabsadd L
.5565 .30314 1.875 0 Mabsadd L
.5565 .30314 0 -2.5 Mabsadd L
.5565 .30314 -1.875 0 Mabsadd L closepath F
.55952 .30314 -1.875 0 Mabsadd m
.55952 .30314 0 2.5 Mabsadd L
.55952 .30314 1.875 0 Mabsadd L
.55952 .30314 0 -2.5 Mabsadd L
.55952 .30314 -1.875 0 Mabsadd L closepath F
.56104 .30346 -1.875 0 Mabsadd m
.56104 .30346 0 2.5 Mabsadd L
.56104 .30346 1.875 0 Mabsadd L
.56104 .30346 0 -2.5 Mabsadd L
.56104 .30346 -1.875 0 Mabsadd L closepath F
.56104 .30379 -1.875 0 Mabsadd m
.56104 .30379 0 2.5 Mabsadd L
.56104 .30379 1.875 0 Mabsadd L
.56104 .30379 0 -2.5 Mabsadd L
.56104 .30379 -1.875 0 Mabsadd L closepath F
.56154 .30412 -1.875 0 Mabsadd m
.56154 .30412 0 2.5 Mabsadd L
.56154 .30412 1.875 0 Mabsadd L
.56154 .30412 0 -2.5 Mabsadd L
.56154 .30412 -1.875 0 Mabsadd L closepath F
.56205 .30412 -1.875 0 Mabsadd m
.56205 .30412 0 2.5 Mabsadd L
.56205 .30412 1.875 0 Mabsadd L
.56205 .30412 0 -2.5 Mabsadd L
.56205 .30412 -1.875 0 Mabsadd L closepath F
.56205 .30477 -1.875 0 Mabsadd m
.56205 .30477 0 2.5 Mabsadd L
.56205 .30477 1.875 0 Mabsadd L
.56205 .30477 0 -2.5 Mabsadd L
.56205 .30477 -1.875 0 Mabsadd L closepath F
.56305 .30477 -1.875 0 Mabsadd m
.56305 .30477 0 2.5 Mabsadd L
.56305 .30477 1.875 0 Mabsadd L
.56305 .30477 0 -2.5 Mabsadd L
.56305 .30477 -1.875 0 Mabsadd L closepath F
.56305 .3051 -1.875 0 Mabsadd m
.56305 .3051 0 2.5 Mabsadd L
.56305 .3051 1.875 0 Mabsadd L
.56305 .3051 0 -2.5 Mabsadd L
.56305 .3051 -1.875 0 Mabsadd L closepath F
.56558 .3064 -1.875 0 Mabsadd m
.56558 .3064 0 2.5 Mabsadd L
.56558 .3064 1.875 0 Mabsadd L
.56558 .3064 0 -2.5 Mabsadd L
.56558 .3064 -1.875 0 Mabsadd L closepath F
.56911 .30706 -1.875 0 Mabsadd m
.56911 .30706 0 2.5 Mabsadd L
.56911 .30706 1.875 0 Mabsadd L
.56911 .30706 0 -2.5 Mabsadd L
.56911 .30706 -1.875 0 Mabsadd L closepath F
.56961 .30706 -1.875 0 Mabsadd m
.56961 .30706 0 2.5 Mabsadd L
.56961 .30706 1.875 0 Mabsadd L
.56961 .30706 0 -2.5 Mabsadd L
.56961 .30706 -1.875 0 Mabsadd L closepath F
.57012 .30738 -1.875 0 Mabsadd m
.57012 .30738 0 2.5 Mabsadd L
.57012 .30738 1.875 0 Mabsadd L
.57012 .30738 0 -2.5 Mabsadd L
.57012 .30738 -1.875 0 Mabsadd L closepath F
.57012 .30738 -1.875 0 Mabsadd m
.57012 .30738 0 2.5 Mabsadd L
.57012 .30738 1.875 0 Mabsadd L
.57012 .30738 0 -2.5 Mabsadd L
.57012 .30738 -1.875 0 Mabsadd L closepath F
.57062 .30836 -1.875 0 Mabsadd m
.57062 .30836 0 2.5 Mabsadd L
.57062 .30836 1.875 0 Mabsadd L
.57062 .30836 0 -2.5 Mabsadd L
.57062 .30836 -1.875 0 Mabsadd L closepath F
.57062 .30869 -1.875 0 Mabsadd m
.57062 .30869 0 2.5 Mabsadd L
.57062 .30869 1.875 0 Mabsadd L
.57062 .30869 0 -2.5 Mabsadd L
.57062 .30869 -1.875 0 Mabsadd L closepath F
.57213 .30902 -1.875 0 Mabsadd m
.57213 .30902 0 2.5 Mabsadd L
.57213 .30902 1.875 0 Mabsadd L
.57213 .30902 0 -2.5 Mabsadd L
.57213 .30902 -1.875 0 Mabsadd L closepath F
.57365 .30934 -1.875 0 Mabsadd m
.57365 .30934 0 2.5 Mabsadd L
.57365 .30934 1.875 0 Mabsadd L
.57365 .30934 0 -2.5 Mabsadd L
.57365 .30934 -1.875 0 Mabsadd L closepath F
.57516 .30967 -1.875 0 Mabsadd m
.57516 .30967 0 2.5 Mabsadd L
.57516 .30967 1.875 0 Mabsadd L
.57516 .30967 0 -2.5 Mabsadd L
.57516 .30967 -1.875 0 Mabsadd L closepath F
.57617 .31 -1.875 0 Mabsadd m
.57617 .31 0 2.5 Mabsadd L
.57617 .31 1.875 0 Mabsadd L
.57617 .31 0 -2.5 Mabsadd L
.57617 .31 -1.875 0 Mabsadd L closepath F
.57667 .3113 -1.875 0 Mabsadd m
.57667 .3113 0 2.5 Mabsadd L
.57667 .3113 1.875 0 Mabsadd L
.57667 .3113 0 -2.5 Mabsadd L
.57667 .3113 -1.875 0 Mabsadd L closepath F
.57718 .31196 -1.875 0 Mabsadd m
.57718 .31196 0 2.5 Mabsadd L
.57718 .31196 1.875 0 Mabsadd L
.57718 .31196 0 -2.5 Mabsadd L
.57718 .31196 -1.875 0 Mabsadd L closepath F
.57869 .31196 -1.875 0 Mabsadd m
.57869 .31196 0 2.5 Mabsadd L
.57869 .31196 1.875 0 Mabsadd L
.57869 .31196 0 -2.5 Mabsadd L
.57869 .31196 -1.875 0 Mabsadd L closepath F
.5792 .31228 -1.875 0 Mabsadd m
.5792 .31228 0 2.5 Mabsadd L
.5792 .31228 1.875 0 Mabsadd L
.5792 .31228 0 -2.5 Mabsadd L
.5792 .31228 -1.875 0 Mabsadd L closepath F
.5797 .31261 -1.875 0 Mabsadd m
.5797 .31261 0 2.5 Mabsadd L
.5797 .31261 1.875 0 Mabsadd L
.5797 .31261 0 -2.5 Mabsadd L
.5797 .31261 -1.875 0 Mabsadd L closepath F
.58222 .31392 -1.875 0 Mabsadd m
.58222 .31392 0 2.5 Mabsadd L
.58222 .31392 1.875 0 Mabsadd L
.58222 .31392 0 -2.5 Mabsadd L
.58222 .31392 -1.875 0 Mabsadd L closepath F
.58273 .3149 -1.875 0 Mabsadd m
.58273 .3149 0 2.5 Mabsadd L
.58273 .3149 1.875 0 Mabsadd L
.58273 .3149 0 -2.5 Mabsadd L
.58273 .3149 -1.875 0 Mabsadd L closepath F
.58727 .31588 -1.875 0 Mabsadd m
.58727 .31588 0 2.5 Mabsadd L
.58727 .31588 1.875 0 Mabsadd L
.58727 .31588 0 -2.5 Mabsadd L
.58727 .31588 -1.875 0 Mabsadd L closepath F
.58777 .31718 -1.875 0 Mabsadd m
.58777 .31718 0 2.5 Mabsadd L
.58777 .31718 1.875 0 Mabsadd L
.58777 .31718 0 -2.5 Mabsadd L
.58777 .31718 -1.875 0 Mabsadd L closepath F
.59231 .31784 -1.875 0 Mabsadd m
.59231 .31784 0 2.5 Mabsadd L
.59231 .31784 1.875 0 Mabsadd L
.59231 .31784 0 -2.5 Mabsadd L
.59231 .31784 -1.875 0 Mabsadd L closepath F
.59383 .31816 -1.875 0 Mabsadd m
.59383 .31816 0 2.5 Mabsadd L
.59383 .31816 1.875 0 Mabsadd L
.59383 .31816 0 -2.5 Mabsadd L
.59383 .31816 -1.875 0 Mabsadd L closepath F
.59534 .32012 -1.875 0 Mabsadd m
.59534 .32012 0 2.5 Mabsadd L
.59534 .32012 1.875 0 Mabsadd L
.59534 .32012 0 -2.5 Mabsadd L
.59534 .32012 -1.875 0 Mabsadd L closepath F
.59635 .32045 -1.875 0 Mabsadd m
.59635 .32045 0 2.5 Mabsadd L
.59635 .32045 1.875 0 Mabsadd L
.59635 .32045 0 -2.5 Mabsadd L
.59635 .32045 -1.875 0 Mabsadd L closepath F
.59685 .32045 -1.875 0 Mabsadd m
.59685 .32045 0 2.5 Mabsadd L
.59685 .32045 1.875 0 Mabsadd L
.59685 .32045 0 -2.5 Mabsadd L
.59685 .32045 -1.875 0 Mabsadd L closepath F
.59786 .32078 -1.875 0 Mabsadd m
.59786 .32078 0 2.5 Mabsadd L
.59786 .32078 1.875 0 Mabsadd L
.59786 .32078 0 -2.5 Mabsadd L
.59786 .32078 -1.875 0 Mabsadd L closepath F
.60089 .32306 -1.875 0 Mabsadd m
.60089 .32306 0 2.5 Mabsadd L
.60089 .32306 1.875 0 Mabsadd L
.60089 .32306 0 -2.5 Mabsadd L
.60089 .32306 -1.875 0 Mabsadd L closepath F
.60139 .32502 -1.875 0 Mabsadd m
.60139 .32502 0 2.5 Mabsadd L
.60139 .32502 1.875 0 Mabsadd L
.60139 .32502 0 -2.5 Mabsadd L
.60139 .32502 -1.875 0 Mabsadd L closepath F
.60291 .32568 -1.875 0 Mabsadd m
.60291 .32568 0 2.5 Mabsadd L
.60291 .32568 1.875 0 Mabsadd L
.60291 .32568 0 -2.5 Mabsadd L
.60291 .32568 -1.875 0 Mabsadd L closepath F
.60442 .32633 -1.875 0 Mabsadd m
.60442 .32633 0 2.5 Mabsadd L
.60442 .32633 1.875 0 Mabsadd L
.60442 .32633 0 -2.5 Mabsadd L
.60442 .32633 -1.875 0 Mabsadd L closepath F
.60593 .32829 -1.875 0 Mabsadd m
.60593 .32829 0 2.5 Mabsadd L
.60593 .32829 1.875 0 Mabsadd L
.60593 .32829 0 -2.5 Mabsadd L
.60593 .32829 -1.875 0 Mabsadd L closepath F
.60694 .32894 -1.875 0 Mabsadd m
.60694 .32894 0 2.5 Mabsadd L
.60694 .32894 1.875 0 Mabsadd L
.60694 .32894 0 -2.5 Mabsadd L
.60694 .32894 -1.875 0 Mabsadd L closepath F
.60946 .33058 -1.875 0 Mabsadd m
.60946 .33058 0 2.5 Mabsadd L
.60946 .33058 1.875 0 Mabsadd L
.60946 .33058 0 -2.5 Mabsadd L
.60946 .33058 -1.875 0 Mabsadd L closepath F
.61098 .33286 -1.875 0 Mabsadd m
.61098 .33286 0 2.5 Mabsadd L
.61098 .33286 1.875 0 Mabsadd L
.61098 .33286 0 -2.5 Mabsadd L
.61098 .33286 -1.875 0 Mabsadd L closepath F
.62056 .33351 -1.875 0 Mabsadd m
.62056 .33351 0 2.5 Mabsadd L
.62056 .33351 1.875 0 Mabsadd L
.62056 .33351 0 -2.5 Mabsadd L
.62056 .33351 -1.875 0 Mabsadd L closepath F
.62107 .33613 -1.875 0 Mabsadd m
.62107 .33613 0 2.5 Mabsadd L
.62107 .33613 1.875 0 Mabsadd L
.62107 .33613 0 -2.5 Mabsadd L
.62107 .33613 -1.875 0 Mabsadd L closepath F
.62409 .33613 -1.875 0 Mabsadd m
.62409 .33613 0 2.5 Mabsadd L
.62409 .33613 1.875 0 Mabsadd L
.62409 .33613 0 -2.5 Mabsadd L
.62409 .33613 -1.875 0 Mabsadd L closepath F
.62409 .33645 -1.875 0 Mabsadd m
.62409 .33645 0 2.5 Mabsadd L
.62409 .33645 1.875 0 Mabsadd L
.62409 .33645 0 -2.5 Mabsadd L
.62409 .33645 -1.875 0 Mabsadd L closepath F
.62712 .3407 -1.875 0 Mabsadd m
.62712 .3407 0 2.5 Mabsadd L
.62712 .3407 1.875 0 Mabsadd L
.62712 .3407 0 -2.5 Mabsadd L
.62712 .3407 -1.875 0 Mabsadd L closepath F
.62762 .34299 -1.875 0 Mabsadd m
.62762 .34299 0 2.5 Mabsadd L
.62762 .34299 1.875 0 Mabsadd L
.62762 .34299 0 -2.5 Mabsadd L
.62762 .34299 -1.875 0 Mabsadd L closepath F
.63015 .34299 -1.875 0 Mabsadd m
.63015 .34299 0 2.5 Mabsadd L
.63015 .34299 1.875 0 Mabsadd L
.63015 .34299 0 -2.5 Mabsadd L
.63015 .34299 -1.875 0 Mabsadd L closepath F
.63115 .34331 -1.875 0 Mabsadd m
.63115 .34331 0 2.5 Mabsadd L
.63115 .34331 1.875 0 Mabsadd L
.63115 .34331 0 -2.5 Mabsadd L
.63115 .34331 -1.875 0 Mabsadd L closepath F
.63216 .34527 -1.875 0 Mabsadd m
.63216 .34527 0 2.5 Mabsadd L
.63216 .34527 1.875 0 Mabsadd L
.63216 .34527 0 -2.5 Mabsadd L
.63216 .34527 -1.875 0 Mabsadd L closepath F
.63317 .34919 -1.875 0 Mabsadd m
.63317 .34919 0 2.5 Mabsadd L
.63317 .34919 1.875 0 Mabsadd L
.63317 .34919 0 -2.5 Mabsadd L
.63317 .34919 -1.875 0 Mabsadd L closepath F
.63469 .34985 -1.875 0 Mabsadd m
.63469 .34985 0 2.5 Mabsadd L
.63469 .34985 1.875 0 Mabsadd L
.63469 .34985 0 -2.5 Mabsadd L
.63469 .34985 -1.875 0 Mabsadd L closepath F
.64326 .35083 -1.875 0 Mabsadd m
.64326 .35083 0 2.5 Mabsadd L
.64326 .35083 1.875 0 Mabsadd L
.64326 .35083 0 -2.5 Mabsadd L
.64326 .35083 -1.875 0 Mabsadd L closepath F
.64326 .35475 -1.875 0 Mabsadd m
.64326 .35475 0 2.5 Mabsadd L
.64326 .35475 1.875 0 Mabsadd L
.64326 .35475 0 -2.5 Mabsadd L
.64326 .35475 -1.875 0 Mabsadd L closepath F
.64377 .35475 -1.875 0 Mabsadd m
.64377 .35475 0 2.5 Mabsadd L
.64377 .35475 1.875 0 Mabsadd L
.64377 .35475 0 -2.5 Mabsadd L
.64377 .35475 -1.875 0 Mabsadd L closepath F
.64982 .35671 -1.875 0 Mabsadd m
.64982 .35671 0 2.5 Mabsadd L
.64982 .35671 1.875 0 Mabsadd L
.64982 .35671 0 -2.5 Mabsadd L
.64982 .35671 -1.875 0 Mabsadd L closepath F
.65032 .35736 -1.875 0 Mabsadd m
.65032 .35736 0 2.5 Mabsadd L
.65032 .35736 1.875 0 Mabsadd L
.65032 .35736 0 -2.5 Mabsadd L
.65032 .35736 -1.875 0 Mabsadd L closepath F
.65285 .37141 -1.875 0 Mabsadd m
.65285 .37141 0 2.5 Mabsadd L
.65285 .37141 1.875 0 Mabsadd L
.65285 .37141 0 -2.5 Mabsadd L
.65285 .37141 -1.875 0 Mabsadd L closepath F
.66495 .375 -1.875 0 Mabsadd m
.66495 .375 0 2.5 Mabsadd L
.66495 .375 1.875 0 Mabsadd L
.66495 .375 0 -2.5 Mabsadd L
.66495 .375 -1.875 0 Mabsadd L closepath F
.67151 .38251 -1.875 0 Mabsadd m
.67151 .38251 0 2.5 Mabsadd L
.67151 .38251 1.875 0 Mabsadd L
.67151 .38251 0 -2.5 Mabsadd L
.67151 .38251 -1.875 0 Mabsadd L closepath F
.67706 .38349 -1.875 0 Mabsadd m
.67706 .38349 0 2.5 Mabsadd L
.67706 .38349 1.875 0 Mabsadd L
.67706 .38349 0 -2.5 Mabsadd L
.67706 .38349 -1.875 0 Mabsadd L closepath F
.68513 .38708 -1.875 0 Mabsadd m
.68513 .38708 0 2.5 Mabsadd L
.68513 .38708 1.875 0 Mabsadd L
.68513 .38708 0 -2.5 Mabsadd L
.68513 .38708 -1.875 0 Mabsadd L closepath F
.68614 .38904 -1.875 0 Mabsadd m
.68614 .38904 0 2.5 Mabsadd L
.68614 .38904 1.875 0 Mabsadd L
.68614 .38904 0 -2.5 Mabsadd L
.68614 .38904 -1.875 0 Mabsadd L closepath F
.68866 .39427 -1.875 0 Mabsadd m
.68866 .39427 0 2.5 Mabsadd L
.68866 .39427 1.875 0 Mabsadd L
.68866 .39427 0 -2.5 Mabsadd L
.68866 .39427 -1.875 0 Mabsadd L closepath F
.69925 .39688 -1.875 0 Mabsadd m
.69925 .39688 0 2.5 Mabsadd L
.69925 .39688 1.875 0 Mabsadd L
.69925 .39688 0 -2.5 Mabsadd L
.69925 .39688 -1.875 0 Mabsadd L closepath F
.71035 .40799 -1.875 0 Mabsadd m
.71035 .40799 0 2.5 Mabsadd L
.71035 .40799 1.875 0 Mabsadd L
.71035 .40799 0 -2.5 Mabsadd L
.71035 .40799 -1.875 0 Mabsadd L closepath F
.71994 .45535 -1.875 0 Mabsadd m
.71994 .45535 0 2.5 Mabsadd L
.71994 .45535 1.875 0 Mabsadd L
.71994 .45535 0 -2.5 Mabsadd L
.71994 .45535 -1.875 0 Mabsadd L closepath F
.73305 .48802 -1.875 0 Mabsadd m
.73305 .48802 0 2.5 Mabsadd L
.73305 .48802 1.875 0 Mabsadd L
.73305 .48802 0 -2.5 Mabsadd L
.73305 .48802 -1.875 0 Mabsadd L closepath F
.73507 .48932 -1.875 0 Mabsadd m
.73507 .48932 0 2.5 Mabsadd L
.73507 .48932 1.875 0 Mabsadd L
.73507 .48932 0 -2.5 Mabsadd L
.73507 .48932 -1.875 0 Mabsadd L closepath F
.73507 .55073 -1.875 0 Mabsadd m
.73507 .55073 0 2.5 Mabsadd L
.73507 .55073 1.875 0 Mabsadd L
.73507 .55073 0 -2.5 Mabsadd L
.73507 .55073 -1.875 0 Mabsadd L closepath F
.97619 .60332 -1.875 0 Mabsadd m
.97619 .60332 0 2.5 Mabsadd L
.97619 .60332 1.875 0 Mabsadd L
.97619 .60332 0 -2.5 Mabsadd L
.97619 .60332 -1.875 0 Mabsadd L closepath F
.5 Mabswid
.06717 0 m
.99889 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`0J6QXQ
01XJ6P00500J6QX00`3Kfm/06QXJ01XJ6P1^01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000E01XJ6P80
fm_KF`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K100J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J
6QX0V00J6QX000L06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3Kfm/06QXJ01XJ6P1H01XJ6P030=_K
f`0J6QX06QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00
1`0J6QX20=_Kf`l06QXJ0P3Kfm]H01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX30=_KfiP06QXJ000601XJ6P<0fm_K4@0J6QX00`3Kfm/06QXJ01XJ6P1=01XJ6P@0fm_K1@0J
6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P001`0J6QX0
0`3Kfm/06QXJ01XJ6P0:01XJ6P80fm_K1@0J6QX20=_Kfe<06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J
6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000C01XJ6P@0fm_K1P0J6QX2
0=_Kfe406QXJ103Kfm/901XJ6P<0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00500J6QX30=_K
f`P06QXJ00<0fm_K01XJ6P0J6QX0H`0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P005@0J6QX00`3Kfm/0
6QXJ01XJ6P0801XJ6P80fm_KH`0J6QX20=_KfiT06QXJ000R01XJ6P030=_Kf`0J6QX06QXJ06006QXJ
00<0fm_K01XJ6P0J6QX0V00J6QX001h06QXJ0P3Kfm/301XJ6P80fm_KH00J6QX00`3Kfm/06QXJ01XJ
6P2H01XJ6P007@0J6QX40=_Kf`0501XJ6P3Kfm/0fm_K01XJ6P3Kfm/0G`0J6QX00`3Kfm/06QXJ01XJ
6P2H01XJ6P007P0J6QX70=_Kf`0301XJ6P3Kfm/0fm_K05d06QXJ0P3Kfm^I01XJ6P007`0J6QX00`3K
fm/06QXJ01XJ6P030=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0FP0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ
6P008`0J6QX80=_KfeX06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX002806QXJ203Kfm/00`0J6QX0fm_K
0=_Kf`1H01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000S01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/00P3K
fm/301XJ6P030=_Kf`0J6QX06QXJ05D06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX002L06QXJ0`3Kfm/4
01XJ6P80fm_KE@0J6QX20=_KfiT06QXJ000X01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00P0J6QX00`3K
fm/06QXJ01XJ6P1B01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000W01XJ6PL0fm_K0`0J6QX20=_Kfe80
6QXJ00<0fm_K01XJ6P0J6QX0V00J6QX002P06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ
00<0fm_K01XJ6P3Kfm/0D@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00;00J6QX:0=_Kfdl06QXJ00<0
fm_K01XJ6P0J6QX0V00J6QX002`06QXJ3@3Kfm]<01XJ6P80fm_KV@0J6QX002d06QXJ0P3Kfm/00`0J
6QX0fm_K0=_Kf`080=_Kfd/06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX003<06QXJ1`3Kfm]301XJ6P80
fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00=@0J6QX70=_Kfd006QXJ00@0fm_K01XJ6P0J6QX0
fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00=`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K04406QXJ
00<0fm_K01XJ6P0J6QX00`0J6QX30=_KfiP06QXJ000g01XJ6PP0fm_K=`0J6QX40=_Kf`<06QXJ0P3K
fm/601XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000h01XJ6PT0fm_K?00J6QX00`3Kfm/06QXJ01XJ6P05
01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000i01XJ6PL0fm_K00<06QXJ0=_Kf`0J6QX0>P0J6QX30=_K
f`D06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX003/06QXJ2@3Kfm]101XJ6P030=_Kf`0J6QX06QXJ09P0
6QXJ000m01XJ6PP0fm_K@00J6QX20=_KfiT06QXJ000n01XJ6PT0fm_K?P0J6QX00`3Kfm/06QXJ01XJ
6P2H01XJ6P00?`0J6QX70=_Kf`0301XJ6P3Kfm/06QXJ03`06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX0
04406QXJ1P3Kfm/00`0J6QX0fm_K0=_Kf`0k01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001201XJ6PL0
fm_K00<06QXJ0=_Kf`3Kfm/0>@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00A00J6QX90=_KfcP06QXJ
0P3Kfm^I01XJ6P00A@0J6QX:0=_KfcH06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX004H06QXJ203Kfm/0
0`0J6QX0fm_K01XJ6P0d01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001:01XJ6PD0fm_K00<06QXJ0=_K
f`3Kfm/0<`0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00B`0J6QX50=_Kf`806QXJ00<0fm_K01XJ6P0J
6QX0<00J6QX20=_KfiT06QXJ001<01XJ6PD0fm_K0P0J6QX20=_Kfc006QXJ00<0fm_K01XJ6P0J6QX0
V00J6QX004d06QXJ1@3Kfm/301XJ6P030=_Kf`0J6QX06QXJ02d06QXJ00<0fm_K01XJ6P0J6QX0V00J
6QX004d06QXJ203Kfm/00`0J6QX0fm_K0=_Kf`0]01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001>01XJ
6PP0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0Z01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001@01XJ6PL0
fm_K0P0J6QX20=_KfbX06QXJ0P3Kfm^I01XJ6P00D@0J6QX80=_Kf`806QXJ0P3Kfm/X01XJ6P030=_K
f`0J6QX06QXJ09P06QXJ001D01XJ6PP0fm_K00<06QXJ0=_Kf`0J6QX09P0J6QX00`3Kfm/06QXJ01XJ
6P2H01XJ6P00E@0J6QX;0=_Kfa006QXJ103Kfm/301XJ6P80fm_K100J6QX20=_Kf`H06QXJ00<0fm_K
01XJ6P0J6QX0V00J6QX005L06QXJ2P3Kfm/?01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00@0fm_K01XJ
6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00F00J6QX;0=_Kf`h06QXJ00<0fm_K01XJ
6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P<0fm_KV00J6QX005/06QXJ2@3Kfm/601XJ6P@0
fm_K100J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00
GP0J6QX80=_Kf`X06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P03
0=_Kf`0J6QX06QXJ09P06QXJ001O01XJ6PP0fm_K2P0J6QX20=_Kf`X06QXJ0`3Kfm/501XJ6P030=_K
f`0J6QX06QXJ09P06QXJ001P01XJ6PT0fm_K700J6QX20=_KfiT06QXJ001R01XJ6PT0fm_K6P0J6QX0
0`3Kfm/06QXJ01XJ6P2H01XJ6P00I00J6QX80=_KfaT06QXJ00<0fm_K01XJ6P0J6QX0V00J6QX006D0
6QXJ2@3Kfm/G01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ001W01XJ6PP0fm_K5P0J6QX00`3Kfm/06QXJ
01XJ6P2H01XJ6P00J@0J6QX80=_Kfa@06QXJ0P3Kfm^I01XJ6P00JP0J6QX90=_Kfa806QXJ00<0fm_K
01XJ6P0J6QX0V00J6QX001H06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`@06QXJ0P3Kfm/L01XJ
6P80fm_K6`0J6QX40=_Kf`<06QXJ0P3Kfm/401XJ6Pd0fm_K3`0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ
6P@0fm_K0`0J6QX20=_Kf`@06QXJ0P3Kfm/L01XJ6P80fm_K700J6QX00`3Kfm/06QXJ01XJ6P0201XJ
6P80fm_K100J6QX20=_KfaP06QXJ1@3Kfm/201XJ6P80fm_K200J6QX001H06QXJ00<0fm_K01XJ6P0J
6QX01`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/J01XJ6P040=_Kf`0J6QX06QXJ0=_KfaX06QXJ00<0fm_K
01XJ6P0J6QX02@0J6QX01@3Kfm/06QXJ01XJ6P3Kfm/06QXJ00X0fm_K3P0J6QX00`3Kfm/06QXJ01XJ
6P0I01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00@0fm_K01XJ6P0J6QX0fm_K6P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/K01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K6@0J6QX01@3K
fm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX01@0J6QX001H06QXJ00<0fm_K01XJ
6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0K01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0fm_K01XJ
6P0J6QX02`0J6QX0103Kfm/06QXJ01XJ6P0J6QX:0=_Kf``06QXJ0P3Kfm/K01XJ6P030=_Kf`0J6QX0
6QXJ00/06QXJ00<0fm_K01XJ6P0J6QX06`0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030=_Kf`0J6QX0
6QXJ00X06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0
fm_K01XJ6P0J6QX01@0J6QX000h06QXJ103Kfm/501XJ6P030=_Kf`0J6QX06QXJ00L06QXJ0P3Kfm/E
01XJ6P@0fm_K0`0J6QX20=_KfaD06QXJ103Kfm/401XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0P3Kfm/7
01XJ6PT0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0K01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0P3Kfm/L
01XJ6P80fm_K7@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K6P0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX01@0J6QX001@06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J
6QX00`3Kfm/06QXJ01XJ6P0K01XJ6P030=_Kf`0J6QX06QXJ01X06QXJ00@0fm_K01XJ6P0J6QX0fm_K
2@0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6PP0fm_K200J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P040=_K
f`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX06`0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX06@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0
fm_K00806QXJ00<0fm_K01XJ6P0J6QX01@0J6QX001@06QXJ103Kfm/901XJ6P<0fm_K6`0J6QX30=_K
fa/06QXJ0P3Kfm/:01XJ6P<0fm_K2P0J6QX90=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX06P0J6QX20=_K
f`X06QXJ0`3Kfm/K01XJ6P<0fm_K6@0J6QX40=_Kf`T06QXJ0`3Kfm/H01XJ6P80fm_K100J6QX20=_K
f`P06QXJ001h01XJ6PT0fm_K100J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P00NP0J6QX=0=_KfiT06QXJ
001l01XJ6P/0fm_KV@0J6QX007h06QXJ2P3Kfm^H01XJ6P00P00J6QX;0=_KfiD06QXJ002301XJ6PX0
fm_KT`0J6QX0000301XJ6P3Kfm/0fm_K0?l0fm_K703Kfm/201XJ6P00100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX:0=_Kf`@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0101XJ6P006@0J6QX00`3Kfm/06QXJ01XJ6P0Q
01XJ6P030=_Kf`0J6QX06QXJ02406QXJ00<0fm_K01XJ6P0J6QX08@0J6QX00`3Kfm/06QXJ01XJ6P09
0=_KfaP06QXJ00<0fm_K01XJ6P0J6QX08@0J6QX00`3Kfm/06QXJ01XJ6P0P01XJ6P030=_Kf`0J6QX0
6QXJ02406QXJ00<0fm_K01XJ6P0J6QX02@0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3K
fm/06QXJ0=_Kf`070=_Kfh`06QXJ002501XJ6P80fm_K100J6QX90=_Kfh`06QXJ002501XJ6P030=_K
f`0J6QX06QXJ00D06QXJ2P3Kfm^901XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P/0fm_KQ`0J
6QX008D06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ0=_Kf`070=_KfhH06QXJ002501XJ
6P030=_Kf`0J6QX06QXJ00T06QXJ2P3Kfm^501XJ6P00Q@0J6QX20=_Kf``06QXJ00<0fm_K01XJ6P0J
6QX01`3Kfm^301XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/0
1@3Kfm^201XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_Kf`0J6QX0fm_K00P0fm_KO`0J
6QX008D06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00L0fm_KO@0J6QX0
08D06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_KNP0J6QX008D0
6QXJ0P3Kfm/D01XJ6P030=_Kf`0J6QX0fm_K00T0fm_KN@0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0
500J6QX20=_Kf`806QXJ2@3Kfm]g01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ2@3Kfm]d01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P80fm_K100J6QX8
0=_Kfg<06QXJ002501XJ6P80fm_K6P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6PL0fm_KLP0J6QX008D0
6QXJ00<0fm_K01XJ6P0J6QX06P0J6QX20=_Kf`D06QXJ1P3Kfm]a01XJ6P00Q@0J6QX00`3Kfm/06QXJ
01XJ6P0L01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ1@3Kfm/00`0J6QX0fm_K01XJ6P1]01XJ6P00L00J
6QX40=_Kf`<06QXJ0P3Kfm/401XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P80fm_K1@0J
6QX70=_Kffd06QXJ001`01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J
6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ1`3Kfm]/01XJ6P00L@0J6QX0
0`3Kfm/06QXJ01XJ6P0;01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0`3Kfm/P01XJ6P80fm_K1@0J6QX7
0=_KffX06QXJ001b01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ
02806QXJ0P3Kfm/501XJ6PD0fm_KJP0J6QX007006QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3K
fm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ02@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX70=_K
ffL06QXJ001a01XJ6P80fm_K2P0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX09@0J6QX20=_Kf`@0
6QXJ1`3Kfm]V01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0W01XJ6P030=_Kf`0J6QX06QXJ00806QXJ
1`3Kfm]U01XJ6P00Q@0J6QX20=_KfbT06QXJ0P3Kfm/301XJ6PL0fm_KI00J6QX008D06QXJ00<0fm_K
01XJ6P0J6QX0:P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6PD0fm_KI00J6QX008D06QXJ00<0fm_K01XJ
6P0J6QX0:`0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0H`0J6QX008D06QXJ00<0fm_K01XJ6P0J
6QX0;@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_KI00J6QX008D06QXJ0P3Kfm/_01XJ6P80fm_K
00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P020=_Kff406QXJ002501XJ6P030=_Kf`0J6QX06QXJ03006QXJ
203Kfm]P01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/00`3K
fm]N01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0c01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/0
0`0J6QX0fm_K01XJ6P1J01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX0fm_K
00H0fm_KFP0J6QX008D06QXJ0P3Kfm/g01XJ6PP0fm_KFP0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0
>00J6QX00`3Kfm/06QXJ01XJ6P040=_Kf`0301XJ6P3Kfm/06QXJ05H06QXJ002501XJ6P030=_Kf`0J
6QX06QXJ03T06QXJ2@3Kfm]F01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P0k01XJ6PL0fm_KEP0J6QX0
08D06QXJ00<0fm_K01XJ6P0J6QX0?00J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ
6P0J6QX0DP0J6QX008D06QXJ0P3Kfm/o01XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_KD`0J6QX008D0
6QXJ00<0fm_K01XJ6P0J6QX0?`0J6QX60=_Kfe<06QXJ001m01XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ
01XJ6P1101XJ6P<0fm_KE00J6QX007`06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ
01XJ6P1301XJ6P030=_Kf`0J6QX06QXJ05806QXJ001o01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0`3K
fm]401XJ6P80fm_KDP0J6QX007d06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ04H06QXJ00<0fm_K
01XJ6P0J6QX0C`0J6QX007d06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P1701XJ
6P80fm_KC`0J6QX007d06QXJ0`3Kfm/501XJ6P030=_Kf`0J6QX06QXJ04T06QXJ00<0fm_K01XJ6P0J
6QX0C00J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0BP0J6QX20=_Kfd`06QXJ002501XJ6P80fm_KC@0J
6QX00`3Kfm/06QXJ01XJ6P1901XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P1=01XJ6P80fm_KB@0J6QX0
08D06QXJ00<0fm_K01XJ6P0J6QX0C`0J6QX20=_KfdL06QXJ002501XJ6P030=_Kf`0J6QX06QXJ0540
6QXJ00<0fm_K01XJ6P0J6QX0A00J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0A@0J6QX20=_Kf`/06QXJ
0P3Kfm]401XJ6P00Q@0J6QX20=_KfdD06QXJ0`3Kfm/=01XJ6P030=_Kf`0J6QX06QXJ04406QXJ0025
01XJ6P030=_Kf`0J6QX06QXJ04D06QXJ0P3Kfm/>01XJ6P80fm_K@@0J6QX008D06QXJ00<0fm_K01XJ
6P0J6QX0AP0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_Kf`0J6QX06QXJ03h06QXJ002501XJ6P03
0=_Kf`0J6QX06QXJ05P06QXJ0P3Kfm/n01XJ6P00Q@0J6QX20=_Kfe/06QXJ00<0fm_K01XJ6P0J6QX0
>`0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0F`0J6QX20=_Kfc/06QXJ002501XJ6P030=_Kf`0J6QX0
6QXJ05d06QXJ00<0fm_K01XJ6P0J6QX0>00J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0GP0J6QX20=_K
fcP06QXJ002501XJ6P030=_Kf`0J6QX06QXJ04P06QXJ0`3Kfm/E01XJ6P80fm_K=P0J6QX008D06QXJ
0P3Kfm]801XJ6PD0fm_K5P0J6QX00`3Kfm/06QXJ01XJ6P0c01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ
6P1801XJ6P@0fm_K5`0J6QX20=_Kfc<06QXJ001b01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/4
01XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P1901XJ6P80fm_K6P0J6QX00`3Kfm/06QXJ01XJ6P0`
01XJ6P00LP0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P040=_Kf`0J6QX06QXJ0=_Kf`D06QXJ00<0fm_K
01XJ6P0J6QX0IP0J6QX20=_Kfc006QXJ001b01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX30=_KffP06QXJ00<0fm_K01XJ6P0J6QX0;@0J6QX007<06QXJ00<0fm_K01XJ6P0J
6QX01`0J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0J@0J6QX20=_Kfbd06QXJ001`01XJ6P040=_K
f`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P1[01XJ6P03
0=_Kf`0J6QX06QXJ02X06QXJ001`01XJ6P@0fm_K2@0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0
K00J6QX20=_KfbX06QXJ002501XJ6P030=_Kf`0J6QX06QXJ06h06QXJ0P3Kfm/X01XJ6P00Q@0J6QX2
0=_Kfg406QXJ00<0fm_K01XJ6P0J6QX09@0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0L@0J6QX20=_K
fbD06QXJ002501XJ6P030=_Kf`0J6QX06QXJ07<06QXJ00<0fm_K01XJ6P0J6QX08P0J6QX008D06QXJ
00<0fm_K01XJ6P0J6QX0M00J6QX20=_Kfb806QXJ002501XJ6P030=_Kf`0J6QX06QXJ07H06QXJ00<0
fm_K01XJ6P0J6QX07`0J6QX008D06QXJ0P3Kfm]h01XJ6P80fm_K7`0J6QX008D06QXJ00<0fm_K01XJ
6P0J6QX0N@0J6QX00`3Kfm/06QXJ01XJ6P0L01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P1j01XJ6P80
fm_K700J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0B@0J6QX20=_Kfc406QXJ00<0fm_K01XJ6P0J6QX0
6@0J6QX008D06QXJ0P3Kfm]901XJ6P@0fm_K<@0J6QX20=_KfaT06QXJ002501XJ6P030=_Kf`0J6QX0
6QXJ04T06QXJ0`3Kfm/c01XJ6P80fm_K5`0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0BP0J6QX00`3K
fm/06QXJ01XJ6P0d01XJ6P030=_Kf`0J6QX06QXJ01@06QXJ002501XJ6P030=_Kf`0J6QX06QXJ0880
6QXJ0P3Kfm/D01XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P2401XJ6P030=_Kf`0J6QX06QXJ01406QXJ
002501XJ6P80fm_KQP0J6QX20=_Kfa406QXJ002501XJ6P030=_Kf`0J6QX06QXJ08L06QXJ00<0fm_K
01XJ6P0J6QX03P0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0R00J6QX20=_Kf`h06QXJ001f01XJ6PD0
fm_K0P0J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P00
N00J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0
6QXJ01XJ6P2;01XJ6P80fm_K2`0J6QX007P06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ0`3Kfm^=01XJ6P80fm_K2@0J6QX007P06QXJ00D0fm_K01XJ6P0J6QX0
6QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0S`0J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P00N00J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX00`3Kfm/06QXJ01XJ6P2@01XJ6P80fm_K1P0J6QX007L06QXJ0P3Kfm/401XJ6P80fm_K
1P0J6QX00`3Kfm/06QXJ01XJ6P2B01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ002501XJ6P80fm_KS`0J
6QX20=_Kf`<06QXJ0P3Kfm/301XJ6P00Q@0J6QX00`3Kfm/06QXJ01XJ6P2=01XJ6P<0fm_K1@0J6QX1
0=_Kf`406QXJ0@0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0SP0J6QX20=_Kf`P06QXJ002501XJ6P03
0=_Kf`0J6QX06QXJ08l06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX008D06QXJ00<0fm_K01XJ6P0J6QX0
V00J6QX008D06QXJ0P3Kfm^I01XJ6P00\
\>"],
  ImageRangeCache->{{{65.8125, 295.188}, {793.25, 651.938}} -> {-15.0343, \
79.8345, 0.0697806, 0.107764}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"GraphicsArray", "[", "\[IndentingNewLine]", 
          RowBox[{
            RowBox[{
              RowBox[{"Show", "[", "\[IndentingNewLine]", "\t", 
                
                RowBox[{\(Histogram[#, HistogramScale \[Rule] 1]\), ",", 
                  "\[IndentingNewLine]", "\t", 
                  RowBox[{"Plot", "[", 
                    RowBox[{
                      RowBox[{"PDF", "[", 
                        RowBox[{
                          RowBox[{
                            StyleBox["NormalDistribution",
                              FontColor->RGBColor[0, 1, 0]], 
                            "[", \(pM = Mean[#], pSD = StandardDeviation[#]\),
                             "]"}], ",", "x"}], "]"}], 
                      ",", \({x, Min[#], Max[#]}\)}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "\t", \(PlotLabel \[Rule] 
                    StyleForm[{pM, pSD}, 
                      FontColor \[Rule] RGBColor[0, 1, 0]]\)}], 
                "\[IndentingNewLine]", "]"}], "&"}], "/@", \({X, Y}\)}], 
          "\[IndentingNewLine]", "]"}], "//", "fShow"}], 
      ";", \(Clear[pM, pSD]\)}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.461538 0.0512821 0.0147151 2.87541 [
[.20513 .00222 -6 -9 ]
[.20513 .00222 6 0 ]
[.46154 .00222 -3 -9 ]
[.46154 .00222 3 0 ]
[.71795 .00222 -3 -9 ]
[.71795 .00222 3 0 ]
[.97436 .00222 -6 -9 ]
[.97436 .00222 6 0 ]
[-0.0125 .15849 -24 -4.5 ]
[-0.0125 .15849 0 4.5 ]
[-0.0125 .30226 -18 -4.5 ]
[-0.0125 .30226 0 4.5 ]
[-0.0125 .44603 -24 -4.5 ]
[-0.0125 .44603 0 4.5 ]
[-0.0125 .5898 -18 -4.5 ]
[-0.0125 .5898 0 4.5 ]
[.5 .63053 -61.0938 0 ]
[.5 .63053 61.0938 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.20513 .01472 m
.20513 .02097 L
s
[(-5)] .20513 .00222 0 1 Mshowa
.46154 .01472 m
.46154 .02097 L
s
[(0)] .46154 .00222 0 1 Mshowa
.71795 .01472 m
.71795 .02097 L
s
[(5)] .71795 .00222 0 1 Mshowa
.97436 .01472 m
.97436 .02097 L
s
[(10)] .97436 .00222 0 1 Mshowa
0 .01472 m
1 .01472 L
s
0 .15849 m
.00625 .15849 L
s
[(0.05)] -0.0125 .15849 1 0 Mshowa
0 .30226 m
.00625 .30226 L
s
[(0.1)] -0.0125 .30226 1 0 Mshowa
0 .44603 m
.00625 .44603 L
s
[(0.15)] -0.0125 .44603 1 0 Mshowa
0 .5898 m
.00625 .5898 L
s
[(0.2)] -0.0125 .5898 1 0 Mshowa
.125 Mabswid
0 .04347 m
.00375 .04347 L
s
0 .07222 m
.00375 .07222 L
s
0 .10098 m
.00375 .10098 L
s
0 .12973 m
.00375 .12973 L
s
0 .18724 m
.00375 .18724 L
s
0 .21599 m
.00375 .21599 L
s
0 .24475 m
.00375 .24475 L
s
0 .2735 m
.00375 .2735 L
s
0 .33101 m
.00375 .33101 L
s
0 .35976 m
.00375 .35976 L
s
0 .38852 m
.00375 .38852 L
s
0 .41727 m
.00375 .41727 L
s
0 .47478 m
.00375 .47478 L
s
0 .50353 m
.00375 .50353 L
s
0 .53229 m
.00375 .53229 L
s
0 .56104 m
.00375 .56104 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
.5 .63053 -122.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
63.000 13.000 moveto
(8) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(-) show
75.625 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(0.962213) show
123.625 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(,) show
133.188 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(2.28139) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
175.188 13.000 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
0 .01472 m
0 .02267 L
.02564 .02267 L
.02564 .01472 L
F
0 g
.5 Mabswid
0 .01472 m
0 .02267 L
.02564 .02267 L
.02564 .01472 L
0 .01472 L
s
1 0 0 r
.02564 .01472 m
.02564 .01472 L
.05128 .01472 L
.05128 .01472 L
F
0 g
.02564 .01472 m
.02564 .01472 L
.05128 .01472 L
.05128 .01472 L
.02564 .01472 L
s
1 0 0 r
.05128 .01472 m
.05128 .02267 L
.07692 .02267 L
.07692 .01472 L
F
0 g
.05128 .01472 m
.05128 .02267 L
.07692 .02267 L
.07692 .01472 L
.05128 .01472 L
s
1 0 0 r
.07692 .01472 m
.07692 .02267 L
.10256 .02267 L
.10256 .01472 L
F
0 g
.07692 .01472 m
.07692 .02267 L
.10256 .02267 L
.10256 .01472 L
.07692 .01472 L
s
1 0 0 r
.10256 .01472 m
.10256 .04653 L
.12821 .04653 L
.12821 .01472 L
F
0 g
.10256 .01472 m
.10256 .04653 L
.12821 .04653 L
.12821 .01472 L
.10256 .01472 L
s
1 0 0 r
.12821 .01472 m
.12821 .06244 L
.15385 .06244 L
.15385 .01472 L
F
0 g
.12821 .01472 m
.12821 .06244 L
.15385 .06244 L
.15385 .01472 L
.12821 .01472 L
s
1 0 0 r
.15385 .01472 m
.15385 .05449 L
.17949 .05449 L
.17949 .01472 L
F
0 g
.15385 .01472 m
.15385 .05449 L
.17949 .05449 L
.17949 .01472 L
.15385 .01472 L
s
1 0 0 r
.17949 .01472 m
.17949 .10221 L
.20513 .10221 L
.20513 .01472 L
F
0 g
.17949 .01472 m
.17949 .10221 L
.20513 .10221 L
.20513 .01472 L
.17949 .01472 L
s
1 0 0 r
.20513 .01472 m
.20513 .16584 L
.23077 .16584 L
.23077 .01472 L
F
0 g
.20513 .01472 m
.20513 .16584 L
.23077 .16584 L
.23077 .01472 L
.20513 .01472 L
s
1 0 0 r
.23077 .01472 m
.23077 .13403 L
.25641 .13403 L
.25641 .01472 L
F
0 g
.23077 .01472 m
.23077 .13403 L
.25641 .13403 L
.25641 .01472 L
.23077 .01472 L
s
1 0 0 r
.25641 .01472 m
.25641 .26129 L
.28205 .26129 L
.28205 .01472 L
F
0 g
.25641 .01472 m
.25641 .26129 L
.28205 .26129 L
.28205 .01472 L
.25641 .01472 L
s
1 0 0 r
.28205 .01472 m
.28205 .25334 L
.30769 .25334 L
.30769 .01472 L
F
0 g
.28205 .01472 m
.28205 .25334 L
.30769 .25334 L
.30769 .01472 L
.28205 .01472 L
s
1 0 0 r
.30769 .01472 m
.30769 .39651 L
.33333 .39651 L
.33333 .01472 L
F
0 g
.30769 .01472 m
.30769 .39651 L
.33333 .39651 L
.33333 .01472 L
.30769 .01472 L
s
1 0 0 r
.33333 .01472 m
.33333 .38856 L
.35897 .38856 L
.35897 .01472 L
F
0 g
.33333 .01472 m
.33333 .38856 L
.35897 .38856 L
.35897 .01472 L
.33333 .01472 L
s
1 0 0 r
.35897 .01472 m
.35897 .53173 L
.38462 .53173 L
.38462 .01472 L
F
0 g
.35897 .01472 m
.35897 .53173 L
.38462 .53173 L
.38462 .01472 L
.35897 .01472 L
s
1 0 0 r
.38462 .01472 m
.38462 .60332 L
.41026 .60332 L
.41026 .01472 L
F
0 g
.38462 .01472 m
.38462 .60332 L
.41026 .60332 L
.41026 .01472 L
.38462 .01472 L
s
1 0 0 r
.41026 .01472 m
.41026 .5715 L
.4359 .5715 L
.4359 .01472 L
F
0 g
.41026 .01472 m
.41026 .5715 L
.4359 .5715 L
.4359 .01472 L
.41026 .01472 L
s
1 0 0 r
.4359 .01472 m
.4359 .44424 L
.46154 .44424 L
.46154 .01472 L
F
0 g
.4359 .01472 m
.4359 .44424 L
.46154 .44424 L
.46154 .01472 L
.4359 .01472 L
s
1 0 0 r
.46154 .01472 m
.46154 .44424 L
.48718 .44424 L
.48718 .01472 L
F
0 g
.46154 .01472 m
.46154 .44424 L
.48718 .44424 L
.48718 .01472 L
.46154 .01472 L
s
1 0 0 r
.48718 .01472 m
.48718 .4681 L
.51282 .4681 L
.51282 .01472 L
F
0 g
.48718 .01472 m
.48718 .4681 L
.51282 .4681 L
.51282 .01472 L
.48718 .01472 L
s
1 0 0 r
.51282 .01472 m
.51282 .3647 L
.53846 .3647 L
.53846 .01472 L
F
0 g
.51282 .01472 m
.51282 .3647 L
.53846 .3647 L
.53846 .01472 L
.51282 .01472 L
s
1 0 0 r
.53846 .01472 m
.53846 .18971 L
.5641 .18971 L
.5641 .01472 L
F
0 g
.53846 .01472 m
.53846 .18971 L
.5641 .18971 L
.5641 .01472 L
.53846 .01472 L
s
1 0 0 r
.5641 .01472 m
.5641 .1738 L
.58974 .1738 L
.58974 .01472 L
F
0 g
.5641 .01472 m
.5641 .1738 L
.58974 .1738 L
.58974 .01472 L
.5641 .01472 L
s
1 0 0 r
.58974 .01472 m
.58974 .12607 L
.61538 .12607 L
.61538 .01472 L
F
0 g
.58974 .01472 m
.58974 .12607 L
.61538 .12607 L
.61538 .01472 L
.58974 .01472 L
s
1 0 0 r
.61538 .01472 m
.61538 .10221 L
.64103 .10221 L
.64103 .01472 L
F
0 g
.61538 .01472 m
.61538 .10221 L
.64103 .10221 L
.64103 .01472 L
.61538 .01472 L
s
1 0 0 r
.64103 .01472 m
.64103 .07039 L
.66667 .07039 L
.66667 .01472 L
F
0 g
.64103 .01472 m
.64103 .07039 L
.66667 .07039 L
.66667 .01472 L
.64103 .01472 L
s
1 0 0 r
.66667 .01472 m
.66667 .05449 L
.69231 .05449 L
.69231 .01472 L
F
0 g
.66667 .01472 m
.66667 .05449 L
.69231 .05449 L
.69231 .01472 L
.66667 .01472 L
s
1 0 0 r
.69231 .01472 m
.69231 .03062 L
.71795 .03062 L
.71795 .01472 L
F
0 g
.69231 .01472 m
.69231 .03062 L
.71795 .03062 L
.71795 .01472 L
.69231 .01472 L
s
1 0 0 r
.71795 .01472 m
.71795 .04653 L
.74359 .04653 L
.74359 .01472 L
F
0 g
.71795 .01472 m
.71795 .04653 L
.74359 .04653 L
.74359 .01472 L
.71795 .01472 L
s
1 0 0 r
.74359 .01472 m
.74359 .01472 L
.76923 .01472 L
.76923 .01472 L
F
0 g
.74359 .01472 m
.74359 .01472 L
.76923 .01472 L
.76923 .01472 L
.74359 .01472 L
s
1 0 0 r
.76923 .01472 m
.76923 .01472 L
.79487 .01472 L
.79487 .01472 L
F
0 g
.76923 .01472 m
.76923 .01472 L
.79487 .01472 L
.79487 .01472 L
.76923 .01472 L
s
1 0 0 r
.79487 .01472 m
.79487 .01472 L
.82051 .01472 L
.82051 .01472 L
F
0 g
.79487 .01472 m
.79487 .01472 L
.82051 .01472 L
.82051 .01472 L
.79487 .01472 L
s
1 0 0 r
.82051 .01472 m
.82051 .01472 L
.84615 .01472 L
.84615 .01472 L
F
0 g
.82051 .01472 m
.82051 .01472 L
.84615 .01472 L
.84615 .01472 L
.82051 .01472 L
s
1 0 0 r
.84615 .01472 m
.84615 .01472 L
.87179 .01472 L
.87179 .01472 L
F
0 g
.84615 .01472 m
.84615 .01472 L
.87179 .01472 L
.87179 .01472 L
.84615 .01472 L
s
1 0 0 r
.87179 .01472 m
.87179 .01472 L
.89744 .01472 L
.89744 .01472 L
F
0 g
.87179 .01472 m
.87179 .01472 L
.89744 .01472 L
.89744 .01472 L
.87179 .01472 L
s
1 0 0 r
.89744 .01472 m
.89744 .01472 L
.92308 .01472 L
.92308 .01472 L
F
0 g
.89744 .01472 m
.89744 .01472 L
.92308 .01472 L
.92308 .01472 L
.89744 .01472 L
s
1 0 0 r
.92308 .01472 m
.92308 .01472 L
.94872 .01472 L
.94872 .01472 L
F
0 g
.92308 .01472 m
.92308 .01472 L
.94872 .01472 L
.94872 .01472 L
.92308 .01472 L
s
1 0 0 r
.94872 .01472 m
.94872 .01472 L
.97436 .01472 L
.97436 .01472 L
F
0 g
.94872 .01472 m
.94872 .01472 L
.97436 .01472 L
.97436 .01472 L
.94872 .01472 L
s
1 0 0 r
.97436 .01472 m
.97436 .02267 L
1 .02267 L
1 .01472 L
F
0 g
.97436 .01472 m
.97436 .02267 L
1 .02267 L
1 .01472 L
.97436 .01472 L
s
.01385 .01624 m
.02297 .0167 L
.03297 .01734 L
.0434 .01821 L
.05312 .01924 L
.06396 .02071 L
.07382 .02239 L
.08533 .02486 L
.09596 .02774 L
.11542 .03486 L
.12568 .03978 L
.13655 .04605 L
.15641 .06079 L
.17502 .07913 L
.1956 .10532 L
.21443 .1352 L
.2548 .21814 L
.29363 .31559 L
.33495 .41906 L
.35406 .45913 L
.36411 .47681 L
.37473 .4924 L
.38013 .499 L
.38606 .50515 L
.39152 .50974 L
.3965 .51303 L
.39895 .51432 L
.40161 .51548 L
.40308 .51601 L
.40443 .51643 L
.40581 .51678 L
.4071 .51706 L
.4082 .51724 L
.40938 .51739 L
.4107 .51749 L
.4119 .51753 L
.41309 .51752 L
.41439 .51745 L
.41504 .51738 L
.41574 .5173 L
.417 .51711 L
.41825 .51686 L
.41963 .51652 L
.42242 .51562 L
.425 .51453 L
.42741 .5133 L
.43286 .50975 L
.4387 .50479 L
.44941 .49273 L
.45919 .47856 L
Mistroke
.47853 .44287 L
.49961 .39506 L
.54098 .28904 L
.58082 .19268 L
.60116 .15114 L
.62314 .11367 L
.6426 .08703 L
.66393 .06438 L
.68424 .04839 L
.69545 .04154 L
.70567 .03635 L
.72554 .02864 L
.73647 .02551 L
.74681 .02313 L
.75665 .02131 L
.7671 .01976 L
.78583 .01778 L
.79539 .01707 L
.80567 .01647 L
.81538 .01604 L
.82427 .01573 L
.83426 .01547 L
.84354 .01528 L
.85373 .01512 L
.8646 .015 L
.87504 .01492 L
.88053 .01488 L
.88634 .01485 L
.89701 .01481 L
.90684 .01478 L
.91646 .01476 L
.92176 .01475 L
.92678 .01475 L
.93652 .01474 L
.94541 .01473 L
.95463 .01473 L
.95929 .01472 L
.96444 .01472 L
.97352 .01472 L
.98205 .01472 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.405405 0.0540541 0.0147151 2.21646 [
[.13514 .00222 -6 -9 ]
[.13514 .00222 6 0 ]
[.40541 .00222 -3 -9 ]
[.40541 .00222 3 0 ]
[.67568 .00222 -3 -9 ]
[.67568 .00222 3 0 ]
[.94595 .00222 -6 -9 ]
[.94595 .00222 6 0 ]
[-0.0125 .12554 -24 -4.5 ]
[-0.0125 .12554 0 4.5 ]
[-0.0125 .23636 -18 -4.5 ]
[-0.0125 .23636 0 4.5 ]
[-0.0125 .34718 -24 -4.5 ]
[-0.0125 .34718 0 4.5 ]
[-0.0125 .45801 -18 -4.5 ]
[-0.0125 .45801 0 4.5 ]
[-0.0125 .56883 -24 -4.5 ]
[-0.0125 .56883 0 4.5 ]
[.5 .63053 -61.0938 0 ]
[.5 .63053 61.0938 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.13514 .01472 m
.13514 .02097 L
s
[(-5)] .13514 .00222 0 1 Mshowa
.40541 .01472 m
.40541 .02097 L
s
[(0)] .40541 .00222 0 1 Mshowa
.67568 .01472 m
.67568 .02097 L
s
[(5)] .67568 .00222 0 1 Mshowa
.94595 .01472 m
.94595 .02097 L
s
[(10)] .94595 .00222 0 1 Mshowa
0 .01472 m
1 .01472 L
s
0 .12554 m
.00625 .12554 L
s
[(0.05)] -0.0125 .12554 1 0 Mshowa
0 .23636 m
.00625 .23636 L
s
[(0.1)] -0.0125 .23636 1 0 Mshowa
0 .34718 m
.00625 .34718 L
s
[(0.15)] -0.0125 .34718 1 0 Mshowa
0 .45801 m
.00625 .45801 L
s
[(0.2)] -0.0125 .45801 1 0 Mshowa
0 .56883 m
.00625 .56883 L
s
[(0.25)] -0.0125 .56883 1 0 Mshowa
.125 Mabswid
0 .03688 m
.00375 .03688 L
s
0 .05904 m
.00375 .05904 L
s
0 .08121 m
.00375 .08121 L
s
0 .10337 m
.00375 .10337 L
s
0 .1477 m
.00375 .1477 L
s
0 .16987 m
.00375 .16987 L
s
0 .19203 m
.00375 .19203 L
s
0 .2142 m
.00375 .2142 L
s
0 .25853 m
.00375 .25853 L
s
0 .28069 m
.00375 .28069 L
s
0 .30286 m
.00375 .30286 L
s
0 .32502 m
.00375 .32502 L
s
0 .36935 m
.00375 .36935 L
s
0 .39151 m
.00375 .39151 L
s
0 .41368 m
.00375 .41368 L
s
0 .43584 m
.00375 .43584 L
s
0 .48017 m
.00375 .48017 L
s
0 .50234 m
.00375 .50234 L
s
0 .5245 m
.00375 .5245 L
s
0 .54667 m
.00375 .54667 L
s
0 .591 m
.00375 .591 L
s
0 .61316 m
.00375 .61316 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
.5 .63053 -122.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
63.000 13.000 moveto
(8) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(-) show
75.625 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(0.952717) show
123.625 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(,) show
133.188 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
(2.04193) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.000 setrgbcolor
175.188 13.000 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
0 .01472 m
0 .02698 L
.02703 .02698 L
.02703 .01472 L
F
0 g
.5 Mabswid
0 .01472 m
0 .02698 L
.02703 .02698 L
.02703 .01472 L
0 .01472 L
s
1 0 0 r
.02703 .01472 m
.02703 .02085 L
.05405 .02085 L
.05405 .01472 L
F
0 g
.02703 .01472 m
.02703 .02085 L
.05405 .02085 L
.05405 .01472 L
.02703 .01472 L
s
1 0 0 r
.05405 .01472 m
.05405 .04537 L
.08108 .04537 L
.08108 .01472 L
F
0 g
.05405 .01472 m
.05405 .04537 L
.08108 .04537 L
.08108 .01472 L
.05405 .01472 L
s
1 0 0 r
.08108 .01472 m
.08108 .03924 L
.10811 .03924 L
.10811 .01472 L
F
0 g
.08108 .01472 m
.08108 .03924 L
.10811 .03924 L
.10811 .01472 L
.08108 .01472 L
s
1 0 0 r
.10811 .01472 m
.10811 .08829 L
.13514 .08829 L
.13514 .01472 L
F
0 g
.10811 .01472 m
.10811 .08829 L
.13514 .08829 L
.13514 .01472 L
.10811 .01472 L
s
1 0 0 r
.13514 .01472 m
.13514 .08216 L
.16216 .08216 L
.16216 .01472 L
F
0 g
.13514 .01472 m
.13514 .08216 L
.16216 .08216 L
.16216 .01472 L
.13514 .01472 L
s
1 0 0 r
.16216 .01472 m
.16216 .12508 L
.18919 .12508 L
.18919 .01472 L
F
0 g
.16216 .01472 m
.16216 .12508 L
.18919 .12508 L
.18919 .01472 L
.16216 .01472 L
s
1 0 0 r
.18919 .01472 m
.18919 .11895 L
.21622 .11895 L
.21622 .01472 L
F
0 g
.18919 .01472 m
.18919 .11895 L
.21622 .11895 L
.21622 .01472 L
.18919 .01472 L
s
1 0 0 r
.21622 .01472 m
.21622 .17413 L
.24324 .17413 L
.24324 .01472 L
F
0 g
.21622 .01472 m
.21622 .17413 L
.24324 .17413 L
.24324 .01472 L
.21622 .01472 L
s
1 0 0 r
.24324 .01472 m
.24324 .28449 L
.27027 .28449 L
.27027 .01472 L
F
0 g
.24324 .01472 m
.24324 .28449 L
.27027 .28449 L
.27027 .01472 L
.24324 .01472 L
s
1 0 0 r
.27027 .01472 m
.27027 .31515 L
.2973 .31515 L
.2973 .01472 L
F
0 g
.27027 .01472 m
.27027 .31515 L
.2973 .31515 L
.2973 .01472 L
.27027 .01472 L
s
1 0 0 r
.2973 .01472 m
.2973 .37033 L
.32432 .37033 L
.32432 .01472 L
F
0 g
.2973 .01472 m
.2973 .37033 L
.32432 .37033 L
.32432 .01472 L
.2973 .01472 L
s
1 0 0 r
.32432 .01472 m
.32432 .60332 L
.35135 .60332 L
.35135 .01472 L
F
0 g
.32432 .01472 m
.32432 .60332 L
.35135 .60332 L
.35135 .01472 L
.32432 .01472 L
s
1 0 0 r
.35135 .01472 m
.35135 .55427 L
.37838 .55427 L
.37838 .01472 L
F
0 g
.35135 .01472 m
.35135 .55427 L
.37838 .55427 L
.37838 .01472 L
.35135 .01472 L
s
1 0 0 r
.37838 .01472 m
.37838 .52361 L
.40541 .52361 L
.40541 .01472 L
F
0 g
.37838 .01472 m
.37838 .52361 L
.40541 .52361 L
.40541 .01472 L
.37838 .01472 L
s
1 0 0 r
.40541 .01472 m
.40541 .39486 L
.43243 .39486 L
.43243 .01472 L
F
0 g
.40541 .01472 m
.40541 .39486 L
.43243 .39486 L
.43243 .01472 L
.40541 .01472 L
s
1 0 0 r
.43243 .01472 m
.43243 .33967 L
.45946 .33967 L
.45946 .01472 L
F
0 g
.43243 .01472 m
.43243 .33967 L
.45946 .33967 L
.45946 .01472 L
.43243 .01472 L
s
1 0 0 r
.45946 .01472 m
.45946 .19865 L
.48649 .19865 L
.48649 .01472 L
F
0 g
.45946 .01472 m
.45946 .19865 L
.48649 .19865 L
.48649 .01472 L
.45946 .01472 L
s
1 0 0 r
.48649 .01472 m
.48649 .17413 L
.51351 .17413 L
.51351 .01472 L
F
0 g
.48649 .01472 m
.48649 .17413 L
.51351 .17413 L
.51351 .01472 L
.48649 .01472 L
s
1 0 0 r
.51351 .01472 m
.51351 .08829 L
.54054 .08829 L
.54054 .01472 L
F
0 g
.51351 .01472 m
.51351 .08829 L
.54054 .08829 L
.54054 .01472 L
.51351 .01472 L
s
1 0 0 r
.54054 .01472 m
.54054 .07603 L
.56757 .07603 L
.56757 .01472 L
F
0 g
.54054 .01472 m
.54054 .07603 L
.56757 .07603 L
.56757 .01472 L
.54054 .01472 L
s
1 0 0 r
.56757 .01472 m
.56757 .02698 L
.59459 .02698 L
.59459 .01472 L
F
0 g
.56757 .01472 m
.56757 .02698 L
.59459 .02698 L
.59459 .01472 L
.56757 .01472 L
s
1 0 0 r
.59459 .01472 m
.59459 .04537 L
.62162 .04537 L
.62162 .01472 L
F
0 g
.59459 .01472 m
.59459 .04537 L
.62162 .04537 L
.62162 .01472 L
.59459 .01472 L
s
1 0 0 r
.62162 .01472 m
.62162 .03311 L
.64865 .03311 L
.64865 .01472 L
F
0 g
.62162 .01472 m
.62162 .03311 L
.64865 .03311 L
.64865 .01472 L
.62162 .01472 L
s
1 0 0 r
.64865 .01472 m
.64865 .02085 L
.67568 .02085 L
.67568 .01472 L
F
0 g
.64865 .01472 m
.64865 .02085 L
.67568 .02085 L
.67568 .01472 L
.64865 .01472 L
s
1 0 0 r
.67568 .01472 m
.67568 .01472 L
.7027 .01472 L
.7027 .01472 L
F
0 g
.67568 .01472 m
.67568 .01472 L
.7027 .01472 L
.7027 .01472 L
.67568 .01472 L
s
1 0 0 r
.7027 .01472 m
.7027 .01472 L
.72973 .01472 L
.72973 .01472 L
F
0 g
.7027 .01472 m
.7027 .01472 L
.72973 .01472 L
.72973 .01472 L
.7027 .01472 L
s
1 0 0 r
.72973 .01472 m
.72973 .02085 L
.75676 .02085 L
.75676 .01472 L
F
0 g
.72973 .01472 m
.72973 .02085 L
.75676 .02085 L
.75676 .01472 L
.72973 .01472 L
s
1 0 0 r
.75676 .01472 m
.75676 .01472 L
.78378 .01472 L
.78378 .01472 L
F
0 g
.75676 .01472 m
.75676 .01472 L
.78378 .01472 L
.78378 .01472 L
.75676 .01472 L
s
1 0 0 r
.78378 .01472 m
.78378 .02698 L
.81081 .02698 L
.81081 .01472 L
F
0 g
.78378 .01472 m
.78378 .02698 L
.81081 .02698 L
.81081 .01472 L
.78378 .01472 L
s
1 0 0 r
.81081 .01472 m
.81081 .01472 L
.83784 .01472 L
.83784 .01472 L
F
0 g
.81081 .01472 m
.81081 .01472 L
.83784 .01472 L
.83784 .01472 L
.81081 .01472 L
s
1 0 0 r
.83784 .01472 m
.83784 .01472 L
.86486 .01472 L
.86486 .01472 L
F
0 g
.83784 .01472 m
.83784 .01472 L
.86486 .01472 L
.86486 .01472 L
.83784 .01472 L
s
1 0 0 r
.86486 .01472 m
.86486 .02085 L
.89189 .02085 L
.89189 .01472 L
F
0 g
.86486 .01472 m
.86486 .02085 L
.89189 .02085 L
.89189 .01472 L
.86486 .01472 L
s
1 0 0 r
.89189 .01472 m
.89189 .01472 L
.91892 .01472 L
.91892 .01472 L
F
0 g
.89189 .01472 m
.89189 .01472 L
.91892 .01472 L
.91892 .01472 L
.89189 .01472 L
s
1 0 0 r
.91892 .01472 m
.91892 .01472 L
.94595 .01472 L
.94595 .01472 L
F
0 g
.91892 .01472 m
.91892 .01472 L
.94595 .01472 L
.94595 .01472 L
.91892 .01472 L
s
1 0 0 r
.94595 .01472 m
.94595 .01472 L
.97297 .01472 L
.97297 .01472 L
F
0 g
.94595 .01472 m
.94595 .01472 L
.97297 .01472 L
.97297 .01472 L
.94595 .01472 L
s
1 0 0 r
.97297 .01472 m
.97297 .02085 L
1 .02085 L
1 .01472 L
F
0 g
.97297 .01472 m
.97297 .02085 L
1 .02085 L
1 .01472 L
.97297 .01472 L
s
.00432 .01759 m
.0135 .01844 L
.02356 .01963 L
.03406 .02122 L
.04384 .02309 L
.06466 .02869 L
.07632 .03304 L
.08693 .03795 L
.10652 .04984 L
.12777 .06781 L
.14806 .09079 L
.16957 .12207 L
.20826 .19603 L
.24947 .29148 L
.28912 .37923 L
.29946 .39814 L
.31074 .41587 L
.32151 .4295 L
.33128 .43876 L
.33626 .44226 L
.33888 .44376 L
.34165 .44509 L
.34407 .44604 L
.34535 .44646 L
.34673 .44684 L
.34799 .44714 L
.34915 .44735 L
.35031 .44753 L
.35141 .44765 L
.35264 .44773 L
.35334 .44775 L
.35399 .44776 L
.35532 .44772 L
.35606 .44767 L
.35674 .44761 L
.35789 .44747 L
.35915 .44727 L
.36168 .44668 L
.36448 .44577 L
.36747 .4445 L
.37286 .44142 L
.37831 .4373 L
.38333 .43264 L
.39469 .41919 L
.4153 .3857 L
.4556 .29799 L
.49435 .20746 L
.51591 .1622 L
.5356 .12642 L
.55621 .09545 L
Mistroke
.57531 .07263 L
.59477 .05475 L
.6057 .04681 L
.61598 .04056 L
.62609 .03542 L
.63701 .03086 L
.65605 .02493 L
.6658 .02271 L
.67648 .02077 L
.68764 .0192 L
.69804 .01807 L
.70876 .01718 L
.7189 .01654 L
.728 .0161 L
.73789 .01573 L
.74753 .01546 L
.75815 .01524 L
.76925 .01508 L
.77965 .01497 L
.78973 .01489 L
.80033 .01484 L
.80939 .0148 L
.81927 .01477 L
.8247 .01476 L
.82981 .01475 L
.83937 .01474 L
.84473 .01474 L
.84966 .01473 L
.85504 .01473 L
.86081 .01473 L
.86601 .01472 L
.87075 .01472 L
.88004 .01472 L
.88523 .01472 L
.89088 .01472 L
.89618 .01472 L
.90116 .01472 L
.91076 .01472 L
.91586 .01472 L
.92136 .01472 L
.92682 .01472 L
.93256 .01472 L
.93747 .01472 L
.94284 .01472 L
.94747 .01472 L
.95184 .01472 L
.96002 .01472 L
.9646 .01472 L
.96882 .01472 L
.97838 .01472 L
Mistroke
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{657, 193.313},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:A0000`B000`400?l00000o`00003oo`0J6Q[o
01XJ6Y<06QXJ003o01XJ6_l06QXJT`0J6QX00?l06QXJo`0J6QZC01XJ6P00o`0J6Q[o01XJ6Y<06QXJ
003o01XJ6_l06QXJT`0J6QX00?l06QXJo`0J6QZC01XJ6P00J00J6QX20=_Kfcd06QXJ0P3Kfm]001XJ
6P80fm_K?00J6QX50=_Kf`806QXJ0P3Kfm]/01XJ6P80fm_K@@0J6QX20=_Kfd<06QXJ0P3Kfm]001XJ
6PD0fm_K0P0J6QX20=_Kfb806QXJ001W01XJ6P040=_Kf`0J6QX06QXJ0=_Kfc/06QXJ00@0fm_K01XJ
6P0J6QX0fm_K?P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/m01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0
0P0J6QX00`3Kfm/06QXJ01XJ6P1X01XJ6P040=_Kf`0J6QX06QXJ0=_Kfcl06QXJ00@0fm_K01XJ6P0J
6QX0fm_K@@0J6QX0103Kfm/06QXJ01XJ6P3Kfm]101XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J
6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P00JP0J6QX00`3Kfm/06QXJ01XJ6P0i01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kfd406QXJ00<0fm_K01XJ6P0J6QX0>`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ
00<0fm_K01XJ6P0J6QX0J`0J6QX00`3Kfm/06QXJ01XJ6P0m01XJ6P040=_Kf`0J6QX06QXJ0=_Kfd@0
6QXJ00<0fm_K01XJ6P0J6QX0?`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ
6P0J6QX07`0J6QX006406QXJ103Kfm/301XJ6P80fm_K?00J6QX0103Kfm/06QXJ01XJ6P3Kfm/o01XJ
6P80fm_K?P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX0HP0J6QX4
0=_Kf`<06QXJ0P3Kfm]001XJ6P040=_Kf`0J6QX06QXJ0=_Kfd806QXJ0P3Kfm]201XJ6P050=_Kf`0J
6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P00J00J6QX00`3Kfm/06QXJ01XJ
6P0k01XJ6P040=_Kf`0J6QX06QXJ0=_Kfcl06QXJ00<0fm_K01XJ6P0J6QX0?@0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX0J@0J6QX00`3Kfm/06QXJ01XJ6P0o01XJ6P04
0=_Kf`0J6QX06QXJ0=_Kfd806QXJ00<0fm_K01XJ6P0J6QX0@@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0
fm_K00806QXJ00<0fm_K01XJ6P0J6QX07`0J6QX006P06QXJ0`3Kfm/l01XJ6P80fm_K@00J6QX30=_K
fc`06QXJ0P3Kfm/401XJ6P80fm_KK00J6QX30=_Kfd006QXJ0P3Kfm]301XJ6P<0fm_K@00J6QX20=_K
f`@06QXJ0P3Kfm/R01XJ6P00o`0J6Q[o01XJ6Y<06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJ
A00J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6QL06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJA00J
6QX00`3Kfm/06QXJ01XJ6P3o01XJ6QL06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJA00J6QX0
0`3Kfm/06QXJ01XJ6P3o01XJ6QL06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJA00J6QX00`3K
fm/06QXJ01XJ6P3o01XJ6QL06QXJ000b01XJ6_l0fm_K0P3Kfm]501XJ6_l0fm_K0P3Kfm/H01XJ6P00
<P0J6QX00`3Kfm/0o`000?l000020?l000X0fm_K103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00P0J6QX:0=_Kfb`06QXJ00<0fm_K0?l0003o0000
0`3o001601XJ6PP0fm_K1P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K01XJ6P3Kfm/0203Kfm/301XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0
100J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K0?l0003o0000
103o00000`3Kfm/06QXJ01XJ6P0;01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K0?l0003o0000
103o000I01XJ6P00<P0J6QX70=_Kf`H06QXJ3P3Kfm/60?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000D0fm_K=P0J6QX60=_KfdH06QXJ00<0
fm_K0?l0003o0000103o00080=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`002@3Kfm/<01XJ6PP0fm_K1P0J6QX00`3Kfm/0o`000?l0
00040?l000030=_Kf`0J6QX06QXJ00/06QXJ203Kfm/=01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ1`3K
fm/I01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6PH0fm_K1P3o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000@0fm_K0?l0003o0000o`00103Kfm^601XJ6PP0fm_K1@0J
6QX20=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`00203Kfm/60?l000030=_Kf`3o0000o`0000@0o`00103Kfm/O01XJ6PP0fm_KB00J
6QX003806QXJ00<0fm_K01XJ6P0J6QX05`0J6QX20=_Kf`D0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o000;
0=_Kf`<0o`0000<0fm_K01XJ6P0J6QX0Q00J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P@0fm_K0`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00001@3Kfm]b
01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P030=_Kf`3o0000fm_K0080fm_K0P3o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm/60?l000030=_Kf`0J6QX06QXJ
08@06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX0103Kfm/0o`000?l0003o00040=_Kf`H0o`0000<0fm_K
0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
0?l0003o0000103o00080=_Kfg806QXJ000b01XJ6P030=_Kf`0J6QX06QXJ01L06QXJ00<0fm_K0?l0
003o00000P3o00030=_Kf`D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K01XJ6P0J6QX00`3Kfm/00`0J6QX0fm_K0?l000050?l0
00030=_Kf`0J6QX06QXJ08@06QXJ0P3Kfm/<01XJ6P030=_Kf`3o0000o`0000@0o`00203Kfm/50?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0o`000?l000040?l0
00030=_Kf`0J6QX06QXJ07L06QXJ000b01XJ6P80fm_K600J6QX00`3Kfm/0o`000?l000040?l00080
fm_K103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00030=_Kf`@06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2401XJ6P03
0=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K0?l0003o0000103o0000103Kfm/06QXJ0=_Kf`3Kfm/301XJ
6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0401XJ
6P030=_Kf`3o0000o`000080o`000`3Kfm]i01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6PP0
fm_K00<0o`000=_Kf`3o00000P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000P3o00020=_Kf`H06QXJ203Kfm^601XJ6P030=_Kf`0J6QX06QXJ00/0
6QXJ203Kfm/301XJ6P80fm_K00<06QXJ0=_Kf`3o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`0J6QX06QXJ00@06QXJ203Kfm]i01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0N01XJ6P040=_K
f`3o0000o`000=_Kf`80o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00007
0=_Kf`3o0000o`000?l0003Kfm/0o`000=_Kf`2D01XJ6P030=_Kf`0J6QX06QXJ01P06QXJ0P3Kfm/5
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX01@0J6QX20=_Kfgh06QXJ000b01XJ
6P030=_Kf`0J6QX06QXJ01h06QXJ00@0fm_K0?l0003o0000o`002P3Kfm/50?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000L0fm_KU00J6QX0
0`3Kfm/06QXJ01XJ6P0I01XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ07h06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ
01h06QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`000`3Kfm^H01XJ6P80fm_K6P0J6QX20=_Kf`@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ07l06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ01h0
6QXJ203Kfm/501XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0V00J6QX00`3Kfm/0
6QXJ01XJ6P0I01XJ6P040=_Kf`3o0000fm_K0=_Kf`80o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ08006QXJ000b01XJ6P030=_Kf`0J6QX06QXJ02H0
6QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000030?l00080fm_KVP0J6QX00`3Kfm/0
6QXJ01XJ6P0I01XJ6P070=_Kf`3o0000o`000?l0003Kfm/0o`000=_Kf`060?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000050=_Kf`0J6QX0
6QXJ01XJ6P3Kfm/0P`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX09`0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX0fm_K00D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000P0fm_KVP0J
6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030=_Kf`3o0000o`000080o`000P3Kfm/60?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000040=_Kf`0J
6QX06QXJ0=_Kfh@06QXJ000b01XJ6P80fm_K:@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/50?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00001@3Kfm/06QXJ01XJ6P0J6QX0fm_K09d0
6QXJ00<0fm_K01XJ6P0J6QX06@0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K01XJ6P3Kfm/0Q@0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0:@0J6QX00`3Kfm/06QXJ
0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000103Kfm/06QXJ
01XJ6P3Kfm^N01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0fm_K0?l0003o00000`3o00020=_Kf`D0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000T0fm_KQP0J6QX003806QXJ
00<0fm_K01XJ6P0J6QX0:P0J6QX20=_Kf`D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000040=_Kf`0J6QX06QXJ0=_Kfih06QXJ0P3Kfm/J01XJ6P030=_Kf`3o0000o`0000<0
o`00203Kfm/60?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/0
6QXJ01XJ6P2401XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0[01XJ6P030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX0fm_K09l06QXJ
00<0fm_K01XJ6P0J6QX06@0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX0fm_K00@06QXJ
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX06QXJ00@06QXJ
00<0fm_K01XJ6P0J6QX0Q@0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0:`0J6QX20=_Kf`@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00080fm_KX00J6QX00`3Kfm/06QXJ01XJ
6P0I01XJ6PL0fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00H0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`001`3Kfm/501XJ6P030=_K
f`0J6QX06QXJ08H06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ02/06QXJ0P3Kfm/40?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/06QXJ01XJ6P2O01XJ6P030=_Kf`0J
6QX06QXJ02<06QXJ00@0fm_K01XJ6P0J6QX0fm_K1P3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0901XJ6P030=_K
f`0J6QX06QXJ08H06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ02/06QXJ00<0fm_K0?l0003Kfm/00`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`000080o`000P3Kfm^Q01XJ6P030=_Kf`0J
6QX06QXJ02@06QXJ00<0fm_K01XJ6P3Kfm/01P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J
6QX06QXJ08L06QXJ000b01XJ6P80fm_K;00J6QX70=_Kf`H0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`001`3Kfm^Q01XJ6P030=_Kf`0J6QX0
6QXJ02@06QXJ00<0fm_K01XJ6P3Kfm/01P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX0
6QXJ08P06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ02l06QXJ00<0fm_K01XJ6P3Kfm/01P3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00001@3K
fm/06QXJ01XJ6P0J6QX0fm_K0:<06QXJ0P3Kfm/V01XJ6P80fm_K1P3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P06
01XJ6P030=_Kf`0J6QX06QXJ08T06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03006QXJ0P3Kfm/60?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00040=_Kf`0J6QX06QXJ0=_Kfj@06QXJ00<0fm_K01XJ6P0J6QX09@0J6QX20=_Kf`H0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P2901XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0`01XJ
6P80fm_K1P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ0=_Kf`2U01XJ6P030=_Kf`0J6QX06QXJ02H06QXJ00<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ08X06QXJ000b01XJ6P03
0=_Kf`0J6QX06QXJ03406QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00020=_Kfhd06QXJ0P3Kfm/401XJ6P80
fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ02H06QXJ0P3Kfm/50?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0R`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0
<@0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l00080fm_KS00J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0V
01XJ6P80fm_K1@3o00080=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P03
01XJ6P030=_Kf`0J6QX06QXJ08`06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03406QXJ0P3Kfm/50?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`0J6QX06QXJ08/06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3K
fm/501XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/W01XJ6PP0fm_K1P0J6QX00`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ
6P2<01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0a01XJ6P030=_Kf`3o0000fm_K00@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000P0fm_KS@0J6QX0103Kfm/06QXJ01XJ6P3K
fm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ02T06QXJ
00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2=01XJ6P00<P0J6QX20=_Kfc806QXJ00<0
fm_K0?l0003Kfm/0103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P2<01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ
00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ02T0
6QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000D0fm_K01XJ6P0J6QX06QXJ0=_Kf`2@01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0a01XJ6P04
0=_Kf`3o0000o`000=_Kf`<0o`00203Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ
6P0J6QX0SP0J6QX20=_Kf`X06QXJ0P3Kfm/401XJ6P<0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0Z01XJ
6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0T00J6QX003806QXJ00<0fm_K01XJ6P0J6QX0<@0J6QX0103K
fm/0o`000?l0003Kfm/30?l000030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ0:L06QXJ00<0fm_K01XJ6P0J6QX0:P0J6QX0
0`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
103Kfm/06QXJ01XJ6P3Kfm^A01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0a01XJ6P050=_Kf`3o0000
o`000?l0003Kfm/00P3o00000`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000D0
fm_K01XJ6P0J6QX06QXJ0=_Kf`2Z01XJ6P030=_Kf`0J6QX06QXJ02/06QXJ00<0fm_K01XJ6P0J6QX0
1P0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000@0fm_K01XJ6P0J6QX0
fm_KT@0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0<@0J6QX01@3Kfm/0o`000?l0003o0000fm_K0080
o`0000<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/0ZP0J6QX20=_Kfb`06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P3Kfm/0TP0J6QX001T06QXJ0P3Kfm/401XJ6P80
fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ03406QXJ00<0fm_K0?l0003o
00000P3o00000`3Kfm/0o`000=_Kf`0601XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000@0fm_K01XJ6P0J
6QX0fm_KZ`0J6QX00`3Kfm/06QXJ01XJ6P0/01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0fm_K09806QXJ000H01XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3K
fm/401XJ6P030=_Kf`0J6QX06QXJ03406QXJ00<0fm_K0?l0003o00000P3o00000`3Kfm/0o`000=_K
f`0601XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000@0fm_K01XJ6P0J6QX0fm_KZ`0J6QX00`3Kfm/06QXJ
01XJ6P0/01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l00080fm_KT`0J6QX001P06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ
01XJ6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/b01XJ6P030=_Kf`3o0000o`0000<0
o`000P3Kfm/601XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K01XJ6P3Kfm/0[00J6QX00`3Kfm/0
6QXJ01XJ6P0]01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l00080fm_KT`0J6QX001P06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/301XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0a01XJ6P030=_Kf`3o0000o`00
00<0o`000P3Kfm/601XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K01XJ6P3Kfm/0[00J6QX00`3K
fm/06QXJ01XJ6P0]01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ09806QXJ000H01XJ6P040=_Kf`0J6QX06QXJ0=_K
f`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0
6QXJ03406QXJ203Kfm/601XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`000P3Kfm^]01XJ6P030=_Kf`0J6QX0
6QXJ02h06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K01XJ6P0J6QX0TP0J6QX001T06QXJ0P3Kfm/:01XJ6P80fm_K100J6QX30=_K
f`@06QXJ00<0fm_K01XJ6P0J6QX0>00J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`000P3Kfm^]01XJ6P80fm_K;`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00020=_Kfi@06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03T0
6QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00070=_Kfjh06QXJ00<0fm_K01XJ6P0J6QX0;`0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6PP0fm_K1P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`00203Kfm^D01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0i01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P2/01XJ6P030=_Kf`0J6QX06QXJ02l06QXJ
00<0fm_K01XJ6P0J6QX02@0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ09@06QXJ
000b01XJ6P030=_Kf`0J6QX06QXJ03X06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ
6P0201XJ6P030=_Kf`0J6QX06QXJ0:d06QXJ00<0fm_K01XJ6P0J6QX0<00J6QX00`3Kfm/06QXJ01XJ
6P0801XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0U00J6QX003806QXJ0P3Kfm/k
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2]
01XJ6P030=_Kf`0J6QX06QXJ03006QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00001@3Kfm/06QXJ01XJ6P0J
6QX0fm_K09L06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03/06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`00203Kfm/301XJ6P030=_Kf`0J6QX06QXJ0:h06QXJ00<0
fm_K01XJ6P0J6QX0<@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0
U`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0>`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00D0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ0:h06QXJ
0P3Kfm/b01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000@0fm_K01XJ6P0J6QX0fm_KV00J6QX003806QXJ
00<0fm_K01XJ6P0J6QX0?00J6QX0103Kfm/06QXJ01XJ6P3Kfm/50?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ6P2^01XJ6P030=_Kf`0J6QX06QXJ0380
6QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`00203Kfm/201XJ6P030=_Kf`0J6QX06QXJ09H06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03`06QXJ
00@0fm_K01XJ6P0J6QX0fm_K1@3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ00L0
6QXJ00<0fm_K01XJ6P0J6QX0[`0J6QX00`3Kfm/06QXJ01XJ6P0b01XJ6P030=_Kf`0J6QX06QXJ00H0
6QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ00H0
6QXJ00<0fm_K01XJ6P0J6QX0U`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0?@0J6QX00`3Kfm/06QXJ
0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ
01XJ6P2_01XJ6P030=_Kf`0J6QX06QXJ03<06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ
01XJ6P2G01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0m01XJ6P030=_Kf`0J6QX0fm_K00D0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ0;006QXJ00<0
fm_K01XJ6P0J6QX0<`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ09L06QXJ000b
01XJ6P030=_Kf`0J6QX06QXJ03h06QXJ0P3Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K
0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K
01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P2`01XJ6P80fm_K=@0J6QX00`3Kfm/06QXJ01XJ6P04
01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P05
01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000b01XJ6P80fm_K?`0J6QX20=_Kf`D0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ0;406QXJ00<0fm_K01XJ
6P0J6QX0=00J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ09P06QXJ000b01XJ6P03
0=_Kf`0J6QX06QXJ03h06QXJ0P3Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J
6QX01@0J6QX00`3Kfm/06QXJ01XJ6P2a01XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J
6QX0100J6QX00`3Kfm/06QXJ01XJ6P2I01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P0o01XJ6P030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0501XJ6P030=_K
f`0J6QX06QXJ0;406QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0401XJ6P030=_K
f`0J6QX06QXJ09T06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03l06QXJ00<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0W`0J
6QX20=_Kf`@06QXJ0P3Kfm/301XJ6PD0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0f01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J
6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0VP0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0?`0J6QX2
0=_Kf`@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0
6QXJ09h06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J
6QX06QXJ03H06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P2J01XJ6P00<P0J6QX0
0`3Kfm/06QXJ01XJ6P0o01XJ6P80fm_K103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0W`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J
6QX06QXJ00<06QXJ0P3Kfm/h01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01P3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0VP0J6QX003806QXJ00<0
fm_K01XJ6P0J6QX0?`0J6QX20=_Kf`@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ
6P0301XJ6P030=_Kf`0J6QX06QXJ09l06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ03L06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`060?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2K01XJ6P00
<P0J6QX20=_Kfd006QXJ00<0fm_K0?l0003Kfm/00`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0W`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0=`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K
00H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ
09/06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ03l06QXJ00<0fm_K0?l0003Kfm/00`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0X@0J6QX20=_Kf`X0
6QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ03P06QXJ00@0fm_K01XJ6P0J6QX0fm_K1P3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0WP0J6QX003806QXJ00<0fm_K01XJ
6P0J6QX0?`0J6QX0103Kfm/0o`000?l0003Kfm/20?l000P0fm_K1@3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P2d
01XJ6P030=_Kf`0J6QX06QXJ03P06QXJ00@0fm_K01XJ6P0J6QX0fm_K1P3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0WP0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0?`0J
6QX0103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000D0fm_K01XJ6P0J6QX0
6QXJ0=_Kf`2g01XJ6P030=_Kf`0J6QX06QXJ03T06QXJ00<0fm_K01XJ6P3Kfm/01P3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0WP0J6QX003806QXJ00<0fm_K01XJ6P0J
6QX0?`0J6QX70=_Kf`H06QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000D0fm_K01XJ6P0J6QX06QXJ0=_Kf`2g01XJ6P80fm_K>P0J6QX00`3K
fm/06QXJ0=_Kf`060?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000@0fm_K01XJ6P0J6QX0fm_KW`0J6QX0
03806QXJ00<0fm_K01XJ6P0J6QX0@`0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000040=_Kf`0J6QX06QXJ
0=_KfkP06QXJ00<0fm_K01XJ6P0J6QX0>P0J6QX20=_Kf`H0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
103Kfm/06QXJ01XJ6P3Kfm^O01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1301XJ6P030=_Kf`0J6QX0
6QXJ00H06QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000@0fm_K01XJ6P0J6QX0fm_K^00J6QX00`3Kfm/06QXJ01XJ6P0j01XJ6P80fm_K1P3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0fm_K0:006QXJ000b01XJ6P80fm_KA@0J6QX0
0`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000040=_Kf`0J6QX06QXJ0=_KfkP06QXJ00<0fm_K01XJ6P0J6QX0>`0J
6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P3Kfm/0X00J
6QX003806QXJ00<0fm_K01XJ6P0J6QX0A00J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
fm_K0;T06QXJ00<0fm_K01XJ6P0J6QX0>`0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`000P3Kfm^Q01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1401XJ6P030=_Kf`0J6QX06QXJ
00D06QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K01XJ6P3Kfm/0^@0J6QX20=_Kfc`06QXJ0P3Kfm/50?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`000P3Kfm^Q01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1501XJ6P030=_Kf`0J6QX06QXJ00@0
6QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0
o`000P3Kfm^j01XJ6P030=_Kf`0J6QX06QXJ03/06QXJ203Kfm/60?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00080fm_KX@0J6QX003806QXJ
00<0fm_K01XJ6P0J6QX0A@0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00080fm_K^P0J6QX00`3Kfm/06QXJ
01XJ6P0m01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ
01XJ6P2P01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1601XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`000P3K
fm^j01XJ6P030=_Kf`0J6QX06QXJ03d06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`0J6QX06QXJ0:006QXJ000O01XJ6P80fm_K100J6QX20=_Kf`<06QXJ1@3Kfm/3
01XJ6P030=_Kf`0J6QX06QXJ04H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2i
01XJ6P030=_Kf`0J6QX06QXJ03d06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l00080fm_KXP0J6QX001h06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P03
01XJ6P030=_Kf`0J6QX06QXJ04H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2i
01XJ6P030=_Kf`0J6QX06QXJ03h06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`060?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00080fm_KXP0J
6QX001h06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_KB00J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000030?l00080fm_K^`0J6QX20=_Kfcl06QXJ00D0fm_K01XJ6P0J6QX06QXJ
0=_Kf`060?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000020?l000030=_Kf`3o0000fm_K0:806QXJ000N01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ
00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P1701XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000<0o`00
0P3Kfm^k01XJ6P030=_Kf`0J6QX06QXJ03l06QXJ00@0fm_K01XJ6P0J6QX0fm_K1P3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000P3o00000`3Kfm/0
o`000=_Kf`2R01XJ6P007P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ00<0fm_K01XJ6P0J6QX0B00J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00D0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o00000`3o00000`3Kfm/0o`000?l000030?l00080fm_K^`0J6QX00`3Kfm/06QXJ01XJ6P0o01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000050=_Kf`3o0000o`000?l0003Kfm/00P3o00000`3Kfm/06QXJ01XJ6P2P01XJ6P007`0J6QX2
0=_Kf`X06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ04P06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o00000P3o00000`3Kfm/0o`000=_K
f`2k01XJ6P030=_Kf`0J6QX06QXJ04006QXJ00<0fm_K01XJ6P3Kfm/01`3Kfm/60?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000D0fm_K0?l0003o0000o`000=_Kf`020?l000030=_Kf`0J6QX06QXJ0:006QXJ
000b01XJ6P030=_Kf`0J6QX06QXJ04P06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`050?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000<0o`0000<0fm_K0?l0003o00000P3o00000`3Kfm/0o`000=_Kf`2k01XJ6P030=_K
f`0J6QX06QXJ04006QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000@0fm_K0?l0003o0000fm_K0`3o00000`3Kfm/06QXJ01XJ6P2P01XJ6P00
<P0J6QX00`3Kfm/06QXJ01XJ6P1901XJ6P040=_Kf`0J6QX06QXJ0=_Kf`D0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
00000`3o00001@3Kfm/0o`000?l0003o0000fm_K0080o`0000<0fm_K01XJ6P0J6QX0^@0J6QX00`3K
fm/06QXJ01XJ6P1001XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000040=_Kf`3o0000o`000=_Kf`<0o`0000<0fm_K01XJ6P0J6QX0X00J6QX0
03806QXJ00<0fm_K01XJ6P0J6QX0B@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/50?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000D0fm_K0?l0003o0000o`000=_Kf`020?l000030=_Kf`0J6QX06QXJ0;T06QXJ0P3K
fm]201XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000fm_K00@0o`0000<0fm_K01XJ6P0J6QX0X00J6QX003806QXJ0P3Kfm];
01XJ6P030=_Kf`0J6QX0fm_K00D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00001@3Kfm/0o`000?l0003o
0000fm_K0080o`0000<0fm_K01XJ6P0J6QX0^@0J6QX00`3Kfm/06QXJ01XJ6P1101XJ6P030=_Kf`0J
6QX06QXJ00D06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000fm_K00@0o`0000<0fm_K01XJ6P0J6QX0X00J6QX003806QXJ00<0fm_K01XJ6P0J6QX0BP0J6QX0
0`3Kfm/06QXJ0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000@0fm_K0?l0003o0000fm_K0`3o
00000`3Kfm/06QXJ01XJ6P2i01XJ6P030=_Kf`0J6QX06QXJ04806QXJ00<0fm_K01XJ6P0J6QX0100J
6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`000P3Kfm/50?l000030=_Kf`0J
6QX06QXJ0:006QXJ000b01XJ6P030=_Kf`0J6QX06QXJ04X06QXJ00<0fm_K01XJ6P3Kfm/01@3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000030?l000040=_Kf`3o0000o`000=_Kf`<0o`0000<0fm_K01XJ6P0J6QX0X00J
6QX20=_Kf`@06QXJ0P3Kfm/301XJ6PD0fm_K0P0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0@P0J
6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00080=_Kfj806QXJ000b01XJ6P030=_Kf`0J6QX06QXJ04/06QXJ0P3Kfm/50?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003Kfm/0103o00000`3Kfm/06QXJ01XJ6P2O01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`X06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00<0fm_K01XJ6P0J6QX0@`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2W01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ
6P1;01XJ6P80fm_K1@3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000fm_K00@0o`0000<0
fm_K01XJ6P0J6QX0W`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kfd@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0Y`0J6QX003806QXJ00<0
fm_K01XJ6P0J6QX0C00J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003Kfm/0103o00000`3Kfm/06QXJ01XJ6P2O01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0A00J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00020=_KfjT06QXJ
000b01XJ6P030=_Kf`0J6QX06QXJ04`06QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00030?l00080fm_K1@3o00000`3Kfm/06QXJ01XJ6P2O01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ04@06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00
0P3Kfm^Y01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1<01XJ6P030=_Kf`3o0000o`0000<0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o00000`3o00020=_Kf`D0o`0000<0fm_K01XJ6P0J6QX0X00J6QX20=_Kf`X06QXJ0P3K
fm/401XJ6P<0fm_K100J6QX00`3Kfm/06QXJ01XJ6P1401XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000020?l000030=_Kf`3o0000fm_K0:T06QXJ000b
01XJ6P80fm_KC@0J6QX20=_Kf`@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00003
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00020=_Kf`D0o`0000<0fm_K
01XJ6P0J6QX0^@0J6QX00`3Kfm/06QXJ01XJ6P1501XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01P3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000020?l000030=_Kf`3o0000fm_K0:T06QXJ000b01XJ6P030=_Kf`0J6QX0
6QXJ04`06QXJ0P3Kfm/40?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`00203Kfm^k01XJ6P030=_Kf`0J6QX0
6QXJ04D06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`060?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000050=_Kf`3o0000o`000?l0003Kfm/0
0P3o00000`3Kfm/06QXJ01XJ6P2W01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1<01XJ6P030=_Kf`3o
0000fm_K00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/06QXJ01XJ6P3001XJ6P80fm_KA`0J
6QX00`3Kfm/06QXJ01XJ6P080=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l0
00040?l000050=_Kf`3o0000o`000?l0003Kfm/00P3o00000`3Kfm/06QXJ01XJ6P2W01XJ6P00<P0J
6QX00`3Kfm/06QXJ01XJ6P1<01XJ6P030=_Kf`3o0000fm_K00<0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000P3o
00020=_Kfl806QXJ00<0fm_K01XJ6P0J6QX0AP0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000040=_Kf`3o
0000o`000=_Kf`<0o`0000<0fm_K01XJ6P0J6QX0Y`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0C00J
6QX0103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
0`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`000080o`000P3Kfm_201XJ6P030=_K
f`0J6QX06QXJ04L06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000103Kfm/0o`000?l0003Kfm/30?l00003
0=_Kf`0J6QX06QXJ0:L06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ04`06QXJ00@0fm_K0?l0003o0000
fm_K0P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000020?l00080fm_K`P0J6QX00`3Kfm/06QXJ01XJ6P1701XJ6P03
0=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003Kfm/0103o00000`3Kfm/06QXJ01XJ6P2W01XJ6P00
<P0J6QX00`3Kfm/06QXJ01XJ6P1<01XJ6P040=_Kf`3o0000o`000=_Kf`80o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000L0fm_K0?l0003o
0000o`000=_Kf`3o0000fm_K0<806QXJ00<0fm_K01XJ6P0J6QX0B00J6QX00`3Kfm/06QXJ01XJ6P05
01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000fm_K00@0o`0000<0fm_K01XJ6P0J6QX0Y`0J6QX003806QXJ0P3Kfm]=01XJ
6P060=_Kf`3o0000o`000?l0003Kfm/0o`00203Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000L0
fm_K0?l0003o0000o`000=_Kf`3o0000fm_K0<806QXJ00<0fm_K01XJ6P0J6QX0B00J6QX00`3Kfm/0
6QXJ01XJ6P0501XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000040?l00080fm_K1@3o00000`3Kfm/06QXJ01XJ6P2W01XJ6P00<P0J6QX00`3Kfm/06QXJ
01XJ6P1<01XJ6P070=_Kf`3o0000o`000?l0003Kfm/0o`000=_Kf`0601XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o0000103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`0J6QX0
6QXJ0<006QXJ0P3Kfm]:01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`000P3Kfm/50?l000030=_Kf`0J6QX0
6QXJ0:L06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ04`06QXJ1`3Kfm/601XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o0000103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`0J6QX0
6QXJ0<006QXJ00<0fm_K01XJ6P0J6QX0BP0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000P0fm_KZ@0J6QX0
03806QXJ00<0fm_K01XJ6P0J6QX0D@0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00<0o`0000<0fm_K0?l0003o0000103o0000103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`0J6QX0
6QXJ0<006QXJ00<0fm_K01XJ6P0J6QX0B`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ0:h06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05406QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003Kfm/00`3o00000`3K
fm/06QXJ01XJ6P3001XJ6P030=_Kf`0J6QX06QXJ04/06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00020=_K
fk006QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05806QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003Kfm/00`3o00000`3Kfm/0
6QXJ01XJ6P3001XJ6P030=_Kf`0J6QX06QXJ04`06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`060?l0
00030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00020=_Kfk006QXJ000b01XJ6P03
0=_Kf`0J6QX06QXJ05806QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`000P3Kfm/40?l000030=_Kf`0J6QX06QXJ0<006QXJ0P3Kfm]=01XJ6P05
0=_Kf`0J6QX06QXJ01XJ6P3Kfm/01P3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
0080o`0000<0fm_K0?l0003Kfm/0/00J6QX003806QXJ0P3Kfm]D01XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l00080fm_K103o00000`3Kfm/0
6QXJ01XJ6P3001XJ6P030=_Kf`0J6QX06QXJ04d06QXJ00@0fm_K01XJ6P0J6QX0fm_K1P3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`000080o`0000<0fm_K0?l0003Kfm/0/00J6QX00380
6QXJ00<0fm_K01XJ6P0J6QX0D`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX06QXJ0<00
6QXJ00<0fm_K01XJ6P0J6QX0CP0J6QX00`3Kfm/06QXJ0=_Kf`060?l000030=_Kf`3o0000o`0000@0
o`0000D0fm_K0?l0003o0000o`000=_Kf`020?l000030=_Kf`0J6QX06QXJ0:h06QXJ000b01XJ6P03
0=_Kf`0J6QX06QXJ05<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o00000`3o00000`3Kfm/06QXJ01XJ6P3001XJ6P03
0=_Kf`0J6QX06QXJ04h06QXJ00<0fm_K01XJ6P3Kfm/01P3o00000`3Kfm/0o`000?l000040?l00004
0=_Kf`3o0000o`000=_Kf`<0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX003806QXJ00<0fm_K01XJ6P0J
6QX0E00J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o
0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX06QXJ0<006QXJ00<0fm_K01XJ6P0J
6QX0C`0J6QX20=_Kf`H0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000=_Kf`040?l00003
0=_Kf`0J6QX06QXJ0:h06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05@06QXJ00<0fm_K01XJ6P0J6QX0
0P0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000<0o`000P3Kfm/50?l000030=_K
f`0J6QX06QXJ0<006QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`000P3Kfm/50?l000030=_Kf`0J6QX06QXJ0:h06QXJ000b01XJ6P030=_Kf`0J
6QX06QXJ05D06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`00
00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000<0o`00
0P3Kfm/50?l000030=_Kf`0J6QX06QXJ0<006QXJ0P3Kfm]A01XJ6P80fm_K1@3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX001T06QXJ0P3K
fm/401XJ6P80fm_K0`0J6QX50=_Kf`806QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ05D06QXJ00D0
fm_K01XJ6P0J6QX06QXJ0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`000080o`0000<0fm_K0?l0003Kfm/0
1@3o00000`3Kfm/06QXJ01XJ6P3001XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003Kfm/0
103o00000`3Kfm/0o`000?l000030?l00080fm_K1P3o00000`3Kfm/06QXJ01XJ6P2^01XJ6P00600J
6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ05H06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@3o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`003P3Kfm/50?l000030=_Kf`0J6QX06QXJ
0<006QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l000020=_Kf`80o`0000@0fm_K0?l0
003o0000o`000P3Kfm/00`3o0000fm_K0?l000050?l000030=_Kf`0J6QX06QXJ0:h06QXJ000H01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P80fm_KE`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0701XJ6P040=_Kf`0J6QX06QXJ0=_Kf`D0o`00
00<0fm_K01XJ6P0J6QX0`00J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`000080o`00
1P3Kfm/30?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX001P06QXJ00@0
fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ
01XJ6P1G01XJ6P030=_Kf`0J6QX0fm_K00D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`0J6QX06QXJ00L06QXJ00@0fm_K01XJ6P0J6QX0fm_K1@3o00000`3Kfm/0
6QXJ01XJ6P2]01XJ6P80fm_K100J6QX20=_Kf`<06QXJ103Kfm/401XJ6P030=_Kf`0J6QX06QXJ0500
6QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K01XJ6P0J6QX0[P0J6QX001P06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0E`0J6QX00`3Kfm/0
6QXJ0=_Kf`050?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
6QXJ01XJ6P0601XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@3o00000`3Kfm/06QXJ01XJ6P2/01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P1@
01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`0J6QX06QXJ0:h06QXJ000I01XJ6P80fm_K2P0J6QX20=_Kf`@06QXJ0`3Kfm/401XJ
6P030=_Kf`0J6QX06QXJ05P06QXJ0P3Kfm/50?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ01XJ6P0601XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@3o0000
0`3Kfm/06QXJ01XJ6P2/01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX20=_Kfe406QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0F00J6QX2
0=_Kf`D0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ00D06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`0J6QX0
6QXJ0:`06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J
6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o
0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0F@0J6QX0
0`3Kfm/0o`000?l000030?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00806QXJ1`3Kfm^^01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_K
f`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_K
f`0J6QX06QXJ0:h06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05T06QXJ00<0fm_K0?l0003o00000`3o
00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0100J
6QX00`3Kfm/06QXJ01XJ6P2i01XJ6P80fm_K2P0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0D00J
6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/06QXJ01XJ6P2^01XJ6P00<P0J6QX20=_KfeX06QXJ0P3Kfm/40?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX0
6QXJ0<`06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2^01XJ6P00<P0J6QX00`3K
fm/06QXJ01XJ6P1I01XJ6P80fm_K103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`00
00@0o`0000<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3=01XJ6P80fm_KD@0J6QX00`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/06QXJ01XJ6P2^01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1I01XJ6P030=_Kf`3o0000fm_K00<0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX0cP0J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0:h0
6QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05T06QXJ00<0fm_K0?l0003Kfm/00`3o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`3o0000o`0000@0o`0000D0fm_K01XJ6P0J6QX06QXJ0=_Kf`3A01XJ6P03
0=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l00003
0=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0
F@0J6QX0103Kfm/0o`000?l0003Kfm/20?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o
0000103o00001@3Kfm/06QXJ01XJ6P0J6QX0fm_K0=406QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/06QXJ01XJ6P2^01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1I01XJ6P070=_Kf`3o0000o`000?l0
003Kfm/0o`000=_Kf`060?l000030=_Kf`3o0000o`0000@0o`0000@0fm_K01XJ6P0J6QX0fm_KdP0J
6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0:h06QXJ000b01XJ6P030=_Kf`0J6QX0
6QXJ05T06QXJ00<0fm_K0?l0003o00000P3o00020=_Kf`H0o`0000<0fm_K0?l0003o0000103o0000
0`3Kfm/06QXJ0=_Kf`3C01XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o0000
0`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX0
03806QXJ0P3Kfm]J01XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l00080fm_Ke00J6QX20=_Kfe406QXJ00<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0[P0J6QX00380
6QXJ00<0fm_K01XJ6P0J6QX0F@0J6QX00`3Kfm/0o`000?l000030?l00080fm_K1@3o00000`3Kfm/0
o`000?l000040?l000030=_Kf`0J6QX06QXJ0=<06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0
o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0
6QXJ01XJ6P2^01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1I01XJ6P030=_Kf`3o0000o`0000<0o`00
00<0fm_K0?l0003Kfm/0103o00000`3Kfm/0o`000?l000030?l00080fm_Ke@0J6QX00`3Kfm/06QXJ
01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`00
0?l000040?l000030=_Kf`0J6QX06QXJ0:h06QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05T06QXJ00<0
fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000020=_Kf`80o`0000@0fm_K0?l0003o0000o`00
0P3Kfm/00`3o0000fm_K01XJ6P3D01XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003o0000
103o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0
[P0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0F@0J6QX00`3Kfm/0o`000?l000030?l000030=_Kf`3o
0000o`000080o`001P3Kfm/30?l000030=_Kf`0J6QX06QXJ0=<06QXJ00<0fm_K01XJ6P0J6QX0D00J
6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o
00000`3Kfm/06QXJ01XJ6P2^01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1I01XJ6P030=_Kf`3o0000
o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ0=<06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2^01XJ6P00<P0J6QX00`3K
fm/06QXJ01XJ6P1I01XJ6P030=_Kf`3o0000o`0000<0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0=<06QXJ0P3Kfm]A01XJ6P030=_Kf`3o0000o`00
00@0o`0000<0fm_K0?l0003o0000103o00080=_Kfk006QXJ000b01XJ6P030=_Kf`0J6QX06QXJ05T0
6QXJ00<0fm_K0?l0003o00000`3o00000`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0
o`0000<0fm_K01XJ6P0J6QX0d`0J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0
o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2e01XJ6P00<P0J6QX20=_KfeX06QXJ
1`3Kfm/60?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0d`0J6QX00`3Kfm/06QXJ
01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ
01XJ6P2e01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o0000o`0000@0o`0000<0
fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P3C01XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0
fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0;D06QXJ000b
01XJ6P030=_Kf`0J6QX06QXJ05l06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l00004
0?l000030=_Kf`0J6QX06QXJ0=<06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l00004
0?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0]@0J6QX003806QXJ00<0fm_K01XJ
6P0J6QX0G`0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ
6P0J6QX0d`0J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0
003o0000103o00000`3Kfm/06QXJ01XJ6P2e01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P03
0=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P3C01XJ6P80
fm_KD@0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J
6QX0]@0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0G`0J6QX00`3Kfm/0o`000?l000040?l000030=_K
f`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0d`0J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_K
f`3o0000o`0000@0o`00203Kfm^g01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o
0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P3C01XJ6P030=_Kf`0J
6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2l01XJ6P00<P0J6QX2
0=_Kff006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ0;X06QXJ0P3Kfm/401XJ6P80fm_K0`0J6QX40=_Kf`<06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX0
6QXJ05006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2l01XJ6P00<P0J6QX00`3K
fm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3K
fm/06QXJ01XJ6P2i01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o
00000`3Kfm/06QXJ01XJ6P2l01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o0000
o`0000@0o`0000<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2i01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_KD@0J
6QX00`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0;`06QXJ000b01XJ6P030=_Kf`0J6QX0
6QXJ05l06QXJ00<0fm_K0?l0003o0000103o00080=_Kfk/06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o
0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0_00J6QX003806QXJ00<0fm_K01XJ6P0J6QX0G`0J6QX0
0`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0<006QXJ00@0fm_K01XJ6P0J6QX0fm_K200J
6QX0103Kfm/06QXJ01XJ6P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0
D00J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX06QXJ0;`06QXJ000b01XJ6P030=_Kf`0J
6QX06QXJ05l06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P3101XJ6P80fm_K2P0J
6QX20=_Kf`@06QXJ0`3Kfm/401XJ6P030=_Kf`0J6QX06QXJ05006QXJ00<0fm_K0?l0003o0000103o
00000`3Kfm/06QXJ01XJ6P2l01XJ6P007`0J6QX20=_Kf`@06QXJ0P3Kfm/301XJ6P@0fm_K100J6QX0
0`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0fP0J6QX0
0`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0_00J6QX0
01h06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX0
6QXJ05l06QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P3J01XJ6P030=_Kf`0J6QX0
6QXJ05006QXJ00<0fm_K0?l0003o0000103o00000`3Kfm/06QXJ01XJ6P2l01XJ6P007P0J6QX0103K
fm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ00@06QXJ0P3Kfm]P01XJ6P030=_Kf`3o0000
o`0000@0o`0000<0fm_K01XJ6P0J6QX0fP0J6QX20=_Kfe406QXJ00<0fm_K0?l0003o0000103o0000
0`3Kfm/06QXJ01XJ6P2l01XJ6P007P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX0
6QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0G`0J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ0=X06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX00`3Kfm/0o`000?l000040?l000030=_Kf`0J6QX0
6QXJ0;`06QXJ000N01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J
6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0fP0J
6QX00`3Kfm/06QXJ01XJ6P1@01XJ6P030=_Kf`3o0000o`0000@0o`0000<0fm_K01XJ6P0J6QX0_00J
6QX001l06QXJ0P3Kfm/:01XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6PP0fm_Kg00J6QX0
0`3Kfm/06QXJ01XJ6P1@01XJ6PP0fm_K_P0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0o`0J6QY401XJ
6P030=_Kf`0J6QX06QXJ0?l06QXJ5`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0o`0J6QY401XJ6P03
0=_Kf`0J6QX06QXJ0?l06QXJ5`0J6QX003806QXJ00<0fm_K01XJ6P0J6QX0o`0J6QY401XJ6P80fm_K
o`0J6QXH01XJ6P00<P0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6T@06QXJ00<0fm_K01XJ6P0J6QX0o`0J
6QXG01XJ6P00o`0J6Q[o01XJ6Y<06QXJ003o01XJ6_l06QXJT`0J6QX00?l06QXJo`0J6QZC01XJ6P00
o`0J6Q[o01XJ6Y<06QXJ003o01XJ6_l06QXJT`0J6QX007/06QXJ00<00?l001XJ6P0J6QX0JP0J6QX0
0`00o`006QXJ01XJ6P3F01XJ6P03003o000J6QX06QXJ06X06QXJ00<00?l001XJ6P0J6QX0H00J6QX0
07X06QXJ00<00?l001XJ6P0J6QX0>@0J6QX00`00o`006QXJ01XJ6P0`01XJ6P03003o000J6QX06QXJ
0=@06QXJ00<00?l001XJ6P0J6QX0>@0J6QX00`00o`006QXJ01XJ6P0`01XJ6P03003o000J6QX06QXJ
05l06QXJ001j01XJ6P03003o000J6QX06QXJ00T06QXJ0P00o`0401XJ6P800?l00`0J6QX3003o00<0
6QXJ0`00o`0301XJ6P@00?l00P0J6QX4003o00806QXJ1@00o`0201XJ6P800?l0100J6QX00`00o`00
6QXJ01XJ6P0501XJ6P@00?l00`0J6QX2003o00<06QXJ1000o`0301XJ6P800?l00`0J6QX5003o0080
6QXJ0P00o`0301XJ6P<00?l0100J6QX00`00o`006QXJ01XJ6P3D01XJ6P03003o000J6QX06QXJ00T0
6QXJ0P00o`0401XJ6P800?l00`0J6QX3003o00@06QXJ0P00o`0301XJ6P@00?l0100J6QX01000o`00
6QXJ01XJ6P0J6QX5003o00<06QXJ00<00?l001XJ6P0J6QX00P0J6QX00`00o`006QXJ01XJ6P0501XJ
6P@00?l00`0J6QX2003o00@06QXJ0P00o`0501XJ6P<00?l000<06QXJ003o0000o`000`00o`00100J
6QX00?l0003o0000o`0401XJ6P800?l0100J6QX00`00o`006QXJ01XJ6P1O01XJ6P00NP0J6QX01000
o`006QXJ01XJ6P0J6QX4003o00<06QXJ00@00?l001XJ6P0J6QX00?l02P0J6QX01@00o`006QXJ01XJ
6P0J6QX00?l000806QXJ00@00?l001XJ6P0J6QX00?l01@0J6QX00`00o`006QXJ01XJ6P0501XJ6P05
003o000J6QX06QXJ01XJ6P00o`000P0J6QX00`00o`006QXJ01XJ6P0201XJ6P03003o000J6QX06QXJ
00@06QXJ00<00?l001XJ6P0J6QX02@0J6QX00`00o`006QXJ01XJ6P0301XJ6P04003o000J6QX06QXJ
003o00@06QXJ00D00?l001XJ6P0J6QX06QXJ003o000201XJ6P03003o000J6QX06QXJ00806QXJ00<0
0?l001XJ6P0J6QX00P0J6QX00`00o`006QXJ01XJ6P3D01XJ6P04003o000J6QX06QXJ01XJ6P@00?l0
0`0J6QX01000o`006QXJ01XJ6P00o`0:01XJ6P05003o000J6QX06QXJ01XJ6P00o`000P0J6QX01000
o`006QXJ01XJ6P00o`0701XJ6P03003o000J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX00`0J6QX0
0`00o`006QXJ01XJ6P0301XJ6P03003o000J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX02@0J6QX0
1000o`006QXJ01XJ6P00o`0501XJ6P03003o000J6QX06QXJ00806QXJ00<00?l001XJ6P0J6QX00`0J
6QX01@00o`006QXJ01XJ6P0J6QX00?l000806QXJ00D00?l001XJ6P0J6QX06QXJ003o001Q01XJ6P00
N@0J6QX00`00o`006QXJ01XJ6P0901XJ6P04003o000J6QX06QXJ003o00T06QXJ0`00o`0201XJ6P04
003o000J6QX06QXJ003o00<06QXJ00<00?l001XJ6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P0401XJ
6P03003o000J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX02`0J6QX00`00o`006QXJ01XJ6P0901XJ
6P03003o000J6QX06QXJ00806QXJ00@00?l001XJ6P0J6QX00?l0100J6QX00`00o`006QXJ01XJ6P03
01XJ6P03003o000J6QX06QXJ00806QXJ0`00o`0401XJ6P03003o000J6QX06QXJ0=806QXJ00<00?l0
01XJ6P0J6QX02@0J6QX01000o`006QXJ01XJ6P00o`0901XJ6P<00?l01@0J6QX01@00o`006QXJ01XJ
6P0J6QX00?l000H06QXJ00<00?l001XJ6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P0301XJ6P03003o
000J6QX06QXJ00/06QXJ00<00?l001XJ6P0J6QX0200J6QX01000o`006QXJ01XJ6P00o`0201XJ6PD0
0?l00`0J6QX00`00o`006QXJ01XJ6P0201XJ6P<00?l0100J6QX00`00o`006QXJ01XJ6P0301XJ6P03
003o000J6QX06QXJ05h06QXJ001j01XJ6P03003o000J6QX06QXJ00P06QXJ00@00?l001XJ6P0J6QX0
0?l0200J6QX01000o`006QXJ01XJ6P00o`0201XJ6P<00?l01@0J6QX00`00o`006QXJ01XJ6P0301XJ
6P03003o000J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX0100J6QX00`00o`006QXJ01XJ6P0;01XJ
6P03003o000J6QX06QXJ00T06QXJ00<00?l001XJ6P0J6QX00P0J6QX2003o00D06QXJ00<00?l001XJ
6P0J6QX0100J6QX01000o`006QXJ01XJ6P00o`0201XJ6P05003o000J6QX06QXJ01XJ6P00o`00eP0J
6QX00`00o`006QXJ01XJ6P0801XJ6P04003o000J6QX06QXJ003o00P06QXJ00@00?l001XJ6P0J6QX0
0?l00`0J6QX2003o00D06QXJ00<00?l001XJ6P0J6QX0100J6QX00`00o`006QXJ01XJ6P0201XJ6P03
003o000J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX02`0J6QX00`00o`006QXJ01XJ6P0701XJ6P04
003o000J6QX06QXJ003o00806QXJ00@00?l001XJ6P0J6QX00?l0100J6QX01@00o`006QXJ01XJ6P0J
6QX00?l000806QXJ00<00?l001XJ6P0J6QX00`0J6QX01@00o`006QXJ01XJ6P0J6QX00?l006406QXJ
001j01XJ6P03003o000J6QX06QXJ00P06QXJ00@00?l001XJ6P0J6QX00?l0200J6QX01000o`006QXJ
01XJ6P00o`0301XJ6P03003o000J6QX06QXJ00806QXJ00@00?l001XJ6P0J6QX00?l00P0J6QX01000
o`006QXJ01XJ6P00o`0401XJ6P05003o000J6QX06QXJ01XJ6P00o`000P0J6QX00`00o`006QXJ01XJ
6P0901XJ6P04003o000J6QX06QXJ003o00P06QXJ00@00?l001XJ6P0J6QX00?l00P0J6QX01000o`00
6QXJ01XJ6P00o`0401XJ6P05003o000J6QX06QXJ01XJ6P00o`000P0J6QX01000o`006QXJ01XJ6P00
o`0201XJ6P05003o000J6QX06QXJ01XJ6P00o`00eP0J6QX00`00o`006QXJ01XJ6P0801XJ6P04003o
000J6QX06QXJ003o00P06QXJ00@00?l001XJ6P0J6QX00?l00`0J6QX00`00o`006QXJ01XJ6P0201XJ
6P04003o000J6QX06QXJ003o00806QXJ00@00?l001XJ6P0J6QX00?l0100J6QX01@00o`006QXJ01XJ
6P0J6QX00?l000806QXJ00<00?l001XJ6P0J6QX02@0J6QX01000o`006QXJ01XJ6P00o`0801XJ6P04
003o000J6QX06QXJ003o00<06QXJ00<00?l001XJ6P00o`00100J6QX01@00o`006QXJ01XJ6P0J6QX0
0?l000806QXJ00@00?l001XJ6P0J6QX00?l00P0J6QX01@00o`006QXJ01XJ6P0J6QX00?l006406QXJ
001k01XJ6P03003o000J6QX06QXJ00P06QXJ0P00o`0:01XJ6P<00?l00`0J6QX3003o00<06QXJ0P00
o`0401XJ6P800?l0100J6QX2003o00@06QXJ0P00o`0=01XJ6P800?l02P0J6QX2003o00@06QXJ0P00
o`0401XJ6P800?l0100J6QX2003o00@06QXJ0`00o`0201XJ6P03003o000J6QX06QXJ0=H06QXJ00<0
0?l001XJ6P0J6QX0200J6QX2003o00X06QXJ0`00o`0301XJ6P<00?l00`0J6QX2003o00<06QXJ1000
o`0301XJ6P800?l00`0J6QX4003o00`06QXJ0P00o`0:01XJ6P800?l01@0J6QX2003o00<06QXJ0P00
o`0401XJ6P<00?l00`0J6QX2003o00<06QXJ00<00?l001XJ6P0J6QX0H00J6QX00?l06QXJo`0J6QZC
01XJ6P00o`0J6Q[o01XJ6Y<06QXJ003o01XJ6_l06QXJT`0J6QX00?l06QXJo`0J6QZC01XJ6P00o`0J
6Q[o01XJ6Y<06QXJ003o01XJ6_l06QXJT`0J6QX00?l06QXJo`0J6QZC01XJ6P00\
\>"],
  ImageRangeCache->{{{65.8125, 590.375}, {339.813, 186.188}} -> {-0.319927, \
0.734318, 0.00321842, 0.00321842}, {{79.5, 316.25}, {336.125, 189.813}} -> \
{-19.1061, 0.293027, 0.076093, 0.0013571}, {{339.875, 576.625}, {336.125, \
189.813}} -> {-40.5837, 0.380143, 0.0721908, 0.00176056}}]
}, Open  ]],

Cell[BoxData[
    \(\(p\[Mu] = \(p\[Sigma] = Table[0, {2}]\);\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Median[X], Mode[X], 
      p\[Mu]\[LeftDoubleBracket]1\[RightDoubleBracket] = Mean[X], 
      p\[Sigma]\[LeftDoubleBracket]1\[RightDoubleBracket] = 
        StandardDeviation[X], Skewness[X], KurtosisExcess[X]}\)], "Input"],

Cell[BoxData[
    \({\(-0.975`\), {\(-2.37`\), \(-0.58`\)}, \(-1.0053300824175824`\), 
      2.3343011968926746`, \(-0.037859902589535255`\), 
      0.852742305151962`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({Median[Y], Mode[Y], 
      p\[Mu]\[LeftDoubleBracket]2\[RightDoubleBracket] = Mean[Y], 
      p\[Sigma]\[LeftDoubleBracket]2\[RightDoubleBracket] = 
        StandardDeviation[Y], Skewness[Y], KurtosisExcess[Y]}\)], "Input"],

Cell[BoxData[
    \({\(-0.9`\), \(-1.13`\), \(-1.0066539835164834`\), 2.1365932239767575`, 
      0.011065245020547945`, 3.066116287799339`}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nonparametric\ estimation\ of\ copula\ parameter\)], "Section",
  FontFamily->"Arial"],

Cell["\<\
{ procedure by Genest&MacKey(1986,1993); described in Frees&Valdez(1998) and \
Abid&Naifar(2005) }\
\>", "Text"],

Cell[CellGroupData[{

Cell["Nonparametric estimate Kn", "Subsection"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        StyleBox[\(unobserved\ variable\ Z = H \((X, Y)\)\),
          FontSlant->"Italic"], " ", "*)"}], 
      "\[IndentingNewLine]", \(fZ[i_] := 
        Sum[If[X\[LeftDoubleBracket]j\[RightDoubleBracket] < 
                  X\[LeftDoubleBracket]i\[RightDoubleBracket]\  && \ 
                Y\[LeftDoubleBracket]j\[RightDoubleBracket] < 
                  Y\[LeftDoubleBracket]i\[RightDoubleBracket], 1. , 0], {j, 
              n}]/\((n - 1)\)\[IndentingNewLine]
      \(Z = Table[fZ[i], {i, n}];\)\)}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        StyleBox[\(distribution\ function\ of\ Z\),
          FontSlant->"Italic"], " ", "*)"}], 
      "\[IndentingNewLine]", \(fKn[z_] := 
        Sum[If[Z\[LeftDoubleBracket]i\[RightDoubleBracket] \[LessEqual] z, 1, 
              0], {i, n}]/n\[IndentingNewLine]
      \(Kn = Table[fKn[z], {z, 0, 1, 1/n}];\)\)}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphicsArray[{ListPlot[Z], ListPlot[Kn]}] // fShow;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224977 0.00131182 0.0147151 0.595162 [
[.15368 .00222 -9 -9 ]
[.15368 .00222 9 0 ]
[.28486 .00222 -9 -9 ]
[.28486 .00222 9 0 ]
[.41604 .00222 -9 -9 ]
[.41604 .00222 9 0 ]
[.54723 .00222 -9 -9 ]
[.54723 .00222 9 0 ]
[.67841 .00222 -9 -9 ]
[.67841 .00222 9 0 ]
[.80959 .00222 -9 -9 ]
[.80959 .00222 9 0 ]
[.94077 .00222 -9 -9 ]
[.94077 .00222 9 0 ]
[.01 .13375 -18 -4.5 ]
[.01 .13375 0 4.5 ]
[.01 .25278 -18 -4.5 ]
[.01 .25278 0 4.5 ]
[.01 .37181 -18 -4.5 ]
[.01 .37181 0 4.5 ]
[.01 .49084 -18 -4.5 ]
[.01 .49084 0 4.5 ]
[.01 .60988 -6 -4.5 ]
[.01 .60988 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15368 .01472 m
.15368 .02097 L
s
[(100)] .15368 .00222 0 1 Mshowa
.28486 .01472 m
.28486 .02097 L
s
[(200)] .28486 .00222 0 1 Mshowa
.41604 .01472 m
.41604 .02097 L
s
[(300)] .41604 .00222 0 1 Mshowa
.54723 .01472 m
.54723 .02097 L
s
[(400)] .54723 .00222 0 1 Mshowa
.67841 .01472 m
.67841 .02097 L
s
[(500)] .67841 .00222 0 1 Mshowa
.80959 .01472 m
.80959 .02097 L
s
[(600)] .80959 .00222 0 1 Mshowa
.94077 .01472 m
.94077 .02097 L
s
[(700)] .94077 .00222 0 1 Mshowa
.125 Mabswid
.04873 .01472 m
.04873 .01847 L
s
.07497 .01472 m
.07497 .01847 L
s
.10121 .01472 m
.10121 .01847 L
s
.12744 .01472 m
.12744 .01847 L
s
.17992 .01472 m
.17992 .01847 L
s
.20615 .01472 m
.20615 .01847 L
s
.23239 .01472 m
.23239 .01847 L
s
.25863 .01472 m
.25863 .01847 L
s
.3111 .01472 m
.3111 .01847 L
s
.33733 .01472 m
.33733 .01847 L
s
.36357 .01472 m
.36357 .01847 L
s
.38981 .01472 m
.38981 .01847 L
s
.44228 .01472 m
.44228 .01847 L
s
.46852 .01472 m
.46852 .01847 L
s
.49475 .01472 m
.49475 .01847 L
s
.52099 .01472 m
.52099 .01847 L
s
.57346 .01472 m
.57346 .01847 L
s
.5997 .01472 m
.5997 .01847 L
s
.62593 .01472 m
.62593 .01847 L
s
.65217 .01472 m
.65217 .01847 L
s
.70464 .01472 m
.70464 .01847 L
s
.73088 .01472 m
.73088 .01847 L
s
.75712 .01472 m
.75712 .01847 L
s
.78335 .01472 m
.78335 .01847 L
s
.83583 .01472 m
.83583 .01847 L
s
.86206 .01472 m
.86206 .01847 L
s
.8883 .01472 m
.8883 .01847 L
s
.91453 .01472 m
.91453 .01847 L
s
.96701 .01472 m
.96701 .01847 L
s
.99324 .01472 m
.99324 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.0225 .13375 m
.02875 .13375 L
s
[(0.2)] .01 .13375 1 0 Mshowa
.0225 .25278 m
.02875 .25278 L
s
[(0.4)] .01 .25278 1 0 Mshowa
.0225 .37181 m
.02875 .37181 L
s
[(0.6)] .01 .37181 1 0 Mshowa
.0225 .49084 m
.02875 .49084 L
s
[(0.8)] .01 .49084 1 0 Mshowa
.0225 .60988 m
.02875 .60988 L
s
[(1)] .01 .60988 1 0 Mshowa
.125 Mabswid
.0225 .04447 m
.02625 .04447 L
s
.0225 .07423 m
.02625 .07423 L
s
.0225 .10399 m
.02625 .10399 L
s
.0225 .16351 m
.02625 .16351 L
s
.0225 .19326 m
.02625 .19326 L
s
.0225 .22302 m
.02625 .22302 L
s
.0225 .28254 m
.02625 .28254 L
s
.0225 .3123 m
.02625 .3123 L
s
.0225 .34205 m
.02625 .34205 L
s
.0225 .40157 m
.02625 .40157 L
s
.0225 .43133 m
.02625 .43133 L
s
.0225 .46109 m
.02625 .46109 L
s
.0225 .5206 m
.02625 .5206 L
s
.0225 .55036 m
.02625 .55036 L
s
.0225 .58012 m
.02625 .58012 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02512 .01553 L
.02643 .01635 L
.02774 .01472 L
.02906 .01799 L
.03037 .01717 L
.03168 .01635 L
.03299 .02045 L
.0343 .02045 L
.03562 .02127 L
.03693 .01963 L
.03824 .01799 L
.03955 .02209 L
.04086 .02209 L
.04217 .02537 L
.04349 .02209 L
.0448 .02045 L
.04611 .02455 L
.04742 .02701 L
.04873 .02209 L
.05005 .02947 L
.05136 .02947 L
.05267 .02783 L
.05398 .02619 L
.05529 .02701 L
.05661 .02947 L
.05792 .03111 L
.05923 .02701 L
.06054 .03111 L
.06185 .02045 L
.06316 .02209 L
.06448 .03603 L
.06579 .03111 L
.0671 .03193 L
.06841 .02209 L
.06972 .03275 L
.07104 .03193 L
.07235 .02127 L
.07366 .04423 L
.07497 .03357 L
.07628 .03275 L
.07759 .03521 L
.07891 .03111 L
.08022 .04915 L
.08153 .04997 L
.08284 .03357 L
.08415 .04997 L
.08547 .01963 L
.08678 .03357 L
.08809 .03931 L
Mistroke
.0894 .02865 L
.09071 .04833 L
.09202 .04833 L
.09334 .03439 L
.09465 .03111 L
.09596 .0598 L
.09727 .05243 L
.09858 .05161 L
.0999 .04833 L
.10121 .05652 L
.10252 .02373 L
.10383 .05243 L
.10514 .0557 L
.10645 .05488 L
.10777 .03603 L
.10908 .04505 L
.11039 .05406 L
.1117 .05406 L
.11301 .03357 L
.11433 .01553 L
.11564 .04177 L
.11695 .06964 L
.11826 .06226 L
.11957 .05243 L
.12088 .05652 L
.1222 .06308 L
.12351 .0721 L
.12482 .02619 L
.12613 .04423 L
.12744 .06226 L
.12876 .03029 L
.13007 .07866 L
.13138 .07866 L
.13269 .05406 L
.134 .04833 L
.13531 .07374 L
.13663 .0639 L
.13794 .04669 L
.13925 .08276 L
.14056 .0762 L
.14187 .04587 L
.14319 .06226 L
.1445 .05816 L
.14581 .06964 L
.14712 .05406 L
.14843 .07784 L
.14974 .05488 L
.15106 .02947 L
.15237 .0598 L
.15368 .09341 L
Mistroke
.15499 .04095 L
.1563 .0557 L
.15762 .03685 L
.15893 .0885 L
.16024 .0721 L
.16155 .04669 L
.16286 .09505 L
.16417 .05324 L
.16549 .07784 L
.1668 .03521 L
.16811 .06308 L
.16942 .08276 L
.17073 .04177 L
.17205 .0598 L
.17336 .04177 L
.17467 .08932 L
.17598 .08686 L
.17729 .0598 L
.1786 .0762 L
.17992 .09997 L
.18123 .068 L
.18254 .08112 L
.18385 .09341 L
.18516 .09751 L
.18648 .01799 L
.18779 .0557 L
.1891 .068 L
.19041 .11391 L
.19172 .03357 L
.19303 .09833 L
.19435 .07784 L
.19566 .10817 L
.19697 .07948 L
.19828 .08768 L
.19959 .09587 L
.20091 .05243 L
.20222 .10981 L
.20353 .11719 L
.20484 .0803 L
.20615 .0639 L
.20746 .12047 L
.20878 .12785 L
.21009 .06636 L
.2114 .0762 L
.21271 .09259 L
.21402 .08358 L
.21534 .09833 L
.21665 .13276 L
.21796 .06226 L
.21927 .01963 L
Mistroke
.22058 .04997 L
.22189 .07866 L
.22321 .06718 L
.22452 .04259 L
.22583 .11719 L
.22714 .07374 L
.22845 .1344 L
.22977 .11965 L
.23108 .02783 L
.23239 .07702 L
.2337 .03111 L
.23501 .09997 L
.23632 .0844 L
.23764 .14424 L
.23895 .01717 L
.24026 .10161 L
.24157 .12047 L
.24288 .10243 L
.2442 .09423 L
.24551 .13686 L
.24682 .05816 L
.24813 .08768 L
.24944 .0639 L
.25075 .14588 L
.25207 .14178 L
.25338 .03111 L
.25469 .09095 L
.256 .05816 L
.25731 .05816 L
.25863 .13276 L
.25994 .07702 L
.26125 .0803 L
.26256 .15982 L
.26387 .07374 L
.26518 .10161 L
.2665 .15572 L
.26781 .13358 L
.26912 .10407 L
.27043 .06472 L
.27174 .10243 L
.27306 .10243 L
.27437 .0885 L
.27568 .12621 L
.27699 .07456 L
.2783 .16883 L
.27961 .13686 L
.28093 .15818 L
.28224 .10899 L
.28355 .06472 L
.28486 .16474 L
Mistroke
.28617 .1631 L
.28749 .02455 L
.2888 .068 L
.29011 .10981 L
.29142 .09833 L
.29273 .11801 L
.29404 .1508 L
.29536 .07702 L
.29667 .1303 L
.29798 .15982 L
.29929 .11965 L
.3006 .10161 L
.30192 .09177 L
.30323 .16965 L
.30454 .04751 L
.30585 .11227 L
.30716 .14096 L
.30847 .10899 L
.30979 .10899 L
.3111 .04505 L
.31241 .12703 L
.31372 .14178 L
.31503 .12293 L
.31635 .18687 L
.31766 .10407 L
.31897 .18769 L
.32028 .18441 L
.32159 .11719 L
.3229 .15572 L
.32422 .11965 L
.32553 .14096 L
.32684 .09095 L
.32815 .17785 L
.32946 .10817 L
.33078 .0639 L
.33209 .17293 L
.3334 .08768 L
.33471 .08686 L
.33602 .1385 L
.33733 .17949 L
.33865 .04587 L
.33996 .03029 L
.34127 .1385 L
.34258 .17949 L
.34389 .1631 L
.34521 .16637 L
.34652 .16064 L
.34783 .07866 L
.34914 .11473 L
.35045 .17867 L
Mistroke
.35176 .12703 L
.35308 .07784 L
.35439 .19671 L
.3557 .09505 L
.35701 .12211 L
.35832 .1549 L
.35964 .09669 L
.36095 .16637 L
.36226 .06882 L
.36357 .14096 L
.36488 .13768 L
.36619 .10489 L
.36751 .13686 L
.36882 .20818 L
.37013 .07866 L
.37144 .10735 L
.37275 .23114 L
.37407 .04341 L
.37538 .2049 L
.37669 .17867 L
.378 .09095 L
.37931 .20572 L
.38062 .18769 L
.38194 .09505 L
.38325 .2254 L
.38456 .01881 L
.38587 .19835 L
.38718 .2213 L
.3885 .14588 L
.38981 .23196 L
.39112 .12211 L
.39243 .07948 L
.39374 .23196 L
.39505 .21802 L
.39637 .17703 L
.39768 .12293 L
.39899 .21966 L
.4003 .03849 L
.40161 .19015 L
.40293 .07046 L
.40424 .18359 L
.40555 .13768 L
.40686 .01635 L
.40817 .16719 L
.40948 .24425 L
.4108 .18687 L
.41211 .06308 L
.41342 .08604 L
.41473 .11637 L
.41604 .25737 L
Mistroke
.41736 .10489 L
.41867 .13932 L
.41998 .13194 L
.42129 .16228 L
.4226 .25573 L
.42391 .25573 L
.42523 .11883 L
.42654 .02537 L
.42785 .07374 L
.42916 .16801 L
.43047 .23524 L
.43179 .24261 L
.4331 .19507 L
.43441 .16719 L
.43572 .11883 L
.43703 .18687 L
.43834 .09505 L
.43966 .2172 L
.44097 .24835 L
.44228 .19425 L
.44359 .07046 L
.4449 .18523 L
.44622 .20327 L
.44753 .17867 L
.44884 .2213 L
.45015 .21556 L
.45146 .20818 L
.45277 .04587 L
.45409 .17621 L
.4554 .19343 L
.45671 .28032 L
.45802 .08522 L
.45933 .11473 L
.46065 .20736 L
.46196 .24671 L
.46327 .21802 L
.46458 .1631 L
.46589 .10161 L
.4672 .17949 L
.46852 .13686 L
.46983 .0885 L
.47114 .18441 L
.47245 .18523 L
.47376 .18605 L
.47508 .17293 L
.47639 .11883 L
.4777 .16556 L
.47901 .26229 L
.48032 .02619 L
.48163 .24835 L
Mistroke
.48295 .22212 L
.48426 .04751 L
.48557 .17539 L
.48688 .20818 L
.48819 .13194 L
.48951 .29672 L
.49082 .16965 L
.49213 .25245 L
.49344 .29098 L
.49475 .2254 L
.49606 .10325 L
.49738 .17293 L
.49869 .2131 L
.5 .13604 L
.50131 .20245 L
.50262 .20245 L
.50394 .15818 L
.50525 .22458 L
.50656 .31476 L
.50787 .17375 L
.50918 .2918 L
.51049 .29508 L
.51181 .31312 L
.51312 .11063 L
.51443 .19425 L
.51574 .209 L
.51705 .12047 L
.51837 .20163 L
.51968 .11965 L
.52099 .14916 L
.5223 .22048 L
.52361 .26475 L
.52492 .11719 L
.52624 .14014 L
.52755 .17621 L
.52886 .16146 L
.53017 .27869 L
.53148 .31148 L
.5328 .2213 L
.53411 .12293 L
.53542 .13194 L
.53673 .27787 L
.53804 .22704 L
.53935 .17375 L
.54067 .209 L
.54198 .07538 L
.54329 .17375 L
.5446 .08358 L
.54591 .31476 L
.54723 .14588 L
Mistroke
.54854 .04915 L
.54985 .16801 L
.55116 .22786 L
.55247 .32459 L
.55378 .15408 L
.5551 .10489 L
.55641 .31803 L
.55772 .11719 L
.55903 .18359 L
.56034 .31066 L
.56166 .34099 L
.56297 .32951 L
.56428 .24589 L
.56559 .16228 L
.5669 .33443 L
.56821 .27623 L
.56953 .24507 L
.57084 .29098 L
.57215 .12457 L
.57346 .34919 L
.57477 .24835 L
.57609 .1631 L
.5774 .06144 L
.57871 .35165 L
.58002 .10735 L
.58133 .24999 L
.58264 .35083 L
.58396 .34263 L
.58527 .22212 L
.58658 .21392 L
.58789 .29672 L
.5892 .35656 L
.59052 .18605 L
.59183 .25655 L
.59314 .32705 L
.59445 .30492 L
.59576 .23442 L
.59707 .08522 L
.59839 .11637 L
.5997 .21392 L
.60101 .30246 L
.60232 .23032 L
.60363 .18113 L
.60495 .26639 L
.60626 .02783 L
.60757 .11719 L
.60888 .08522 L
.61019 .33853 L
.6115 .21884 L
.61282 .17211 L
Mistroke
.61413 .22212 L
.61544 .37542 L
.61675 .33115 L
.61806 .2295 L
.61938 .05488 L
.62069 .34181 L
.622 .17211 L
.62331 .2131 L
.62462 .1631 L
.62593 .05324 L
.62725 .12457 L
.62856 .31066 L
.62987 .30574 L
.63118 .2254 L
.63249 .36066 L
.63381 .14506 L
.63512 .28032 L
.63643 .39345 L
.63774 .31967 L
.63905 .3869 L
.64036 .19835 L
.64168 .38608 L
.64299 .34427 L
.6443 .33935 L
.64561 .20408 L
.64692 .2295 L
.64824 .12047 L
.64955 .30738 L
.65086 .37132 L
.65217 .28606 L
.65348 .28852 L
.65479 .30902 L
.65611 .26065 L
.65742 .15408 L
.65873 .33197 L
.66004 .31885 L
.66135 .16637 L
.66267 .31803 L
.66398 .27295 L
.66529 .27705 L
.6666 .38854 L
.66791 .29016 L
.66922 .30656 L
.67054 .09997 L
.67185 .3787 L
.67316 .3828 L
.67447 .06062 L
.67578 .09423 L
.6771 .04997 L
.67841 .14998 L
Mistroke
.67972 .26393 L
.68103 .33525 L
.68234 .40821 L
.68365 .39345 L
.68497 .39182 L
.68628 .26885 L
.68759 .40575 L
.6889 .26885 L
.69021 .40739 L
.69153 .03193 L
.69284 .17867 L
.69415 .13194 L
.69546 .16228 L
.69677 .06472 L
.69808 .18851 L
.6994 .29262 L
.70071 .18441 L
.70202 .19507 L
.70333 .35574 L
.70464 .3828 L
.70596 .41641 L
.70727 .29836 L
.70858 .30984 L
.70989 .03193 L
.7112 .30164 L
.71251 .14752 L
.71383 .10735 L
.71514 .2795 L
.71645 .22622 L
.71776 .20327 L
.71907 .30984 L
.72039 .31558 L
.7217 .16719 L
.72301 .37214 L
.72432 .10407 L
.72563 .44838 L
.72694 .42215 L
.72826 .45002 L
.72957 .40657 L
.73088 .15244 L
.73219 .36148 L
.7335 .30164 L
.73482 .45822 L
.73613 .1467 L
.73744 .35001 L
.73875 .2918 L
.74006 .40411 L
.74137 .19835 L
.74269 .31721 L
.744 .12129 L
Mistroke
.74531 .22786 L
.74662 .24999 L
.74793 .42461 L
.74925 .44428 L
.75056 .22786 L
.75187 .39427 L
.75318 .2377 L
.75449 .44264 L
.7558 .3082 L
.75712 .20327 L
.75843 .08686 L
.75974 .33853 L
.76105 .34099 L
.76236 .42461 L
.76368 .02209 L
.76499 .45166 L
.7663 .19015 L
.76761 .36312 L
.76892 .19589 L
.77023 .32049 L
.77155 .159 L
.77286 .45002 L
.77417 .44756 L
.77548 .47789 L
.77679 .36394 L
.77811 .05243 L
.77942 .31803 L
.78073 .38526 L
.78204 .068 L
.78335 .4574 L
.78466 .47461 L
.78598 .32049 L
.78729 .43608 L
.7886 .03111 L
.78991 .2795 L
.79122 .48445 L
.79254 .36312 L
.79385 .10899 L
.79516 .48199 L
.79647 .31967 L
.79778 .4574 L
.79909 .40739 L
.80041 .36312 L
.80172 .03603 L
.80303 .49101 L
.80434 .44018 L
.80565 .26065 L
.80697 .02537 L
.80828 .50413 L
.80959 .43772 L
Mistroke
.8109 .38854 L
.81221 .42379 L
.81352 .29918 L
.81484 .36148 L
.81615 .49839 L
.81746 .21228 L
.81877 .38854 L
.82008 .50822 L
.8214 .22376 L
.82271 .20245 L
.82402 .43854 L
.82533 .0844 L
.82664 .35411 L
.82795 .34673 L
.82927 .40821 L
.83058 .34345 L
.83189 .20572 L
.8332 .44838 L
.83451 .28032 L
.83583 .45822 L
.83714 .41723 L
.83845 .39591 L
.83976 .29672 L
.84107 .52462 L
.84238 .04505 L
.8437 .40083 L
.84501 .12129 L
.84632 .30984 L
.84763 .4656 L
.84894 .52544 L
.85026 .14834 L
.85157 .37214 L
.85288 .11063 L
.85419 .21556 L
.8555 .47543 L
.85681 .04833 L
.85813 .1344 L
.85944 .25983 L
.86075 .4328 L
.86206 .34755 L
.86337 .51478 L
.86469 .48445 L
.866 .23606 L
.86731 .53446 L
.86862 .46232 L
.86993 .441 L
.87124 .10735 L
.87256 .40411 L
.87387 .48609 L
.87518 .48199 L
Mistroke
.87649 .51314 L
.8778 .38116 L
.87912 .41969 L
.88043 .18441 L
.88174 .3623 L
.88305 .159 L
.88436 .5402 L
.88567 .45412 L
.88699 .0557 L
.8883 .26721 L
.88961 .2959 L
.89092 .34755 L
.89223 .32623 L
.89355 .5115 L
.89486 .1631 L
.89617 .49511 L
.89748 .49757 L
.89879 .52954 L
.9001 .53282 L
.90142 .12211 L
.90273 .0557 L
.90404 .16719 L
.90535 .45166 L
.90666 .48117 L
.90798 .40411 L
.90929 .46887 L
.9106 .56643 L
.91191 .5279 L
.91322 .01472 L
.91453 .27623 L
.91585 .41723 L
.91716 .56807 L
.91847 .56397 L
.91978 .34755 L
.92109 .19261 L
.92241 .12539 L
.92372 .56233 L
.92503 .21638 L
.92634 .40903 L
.92765 .56315 L
.92896 .52216 L
.93028 .13932 L
.93159 .44264 L
.9329 .48773 L
.93421 .15654 L
.93552 .52708 L
.93684 .55577 L
.93815 .52462 L
.93946 .14014 L
.94077 .25737 L
Mistroke
.94208 .02209 L
.94339 .45822 L
.94471 .14014 L
.94602 .56151 L
.94733 .57381 L
.94864 .32951 L
.94995 .58528 L
.95127 .54675 L
.95258 .38854 L
.95389 .16965 L
.9552 .59266 L
.95651 .22376 L
.95783 .56233 L
.95914 .582 L
.96045 .02291 L
.96176 .12047 L
.96307 .48117 L
.96438 .59758 L
.9657 .60086 L
.96701 .52708 L
.96832 .52298 L
.96963 .60086 L
.97094 .21392 L
.97226 .60332 L
.97357 .068 L
.97488 .07374 L
.97619 .49839 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224995 0.00131002 0.0122761 0.591043 [
[.1535 -0.00022 -9 -9 ]
[.1535 -0.00022 9 0 ]
[.2845 -0.00022 -9 -9 ]
[.2845 -0.00022 9 0 ]
[.4155 -0.00022 -9 -9 ]
[.4155 -0.00022 9 0 ]
[.54651 -0.00022 -9 -9 ]
[.54651 -0.00022 9 0 ]
[.67751 -0.00022 -9 -9 ]
[.67751 -0.00022 9 0 ]
[.80851 -0.00022 -9 -9 ]
[.80851 -0.00022 9 0 ]
[.93951 -0.00022 -9 -9 ]
[.93951 -0.00022 9 0 ]
[.01 .13048 -18 -4.5 ]
[.01 .13048 0 4.5 ]
[.01 .24869 -18 -4.5 ]
[.01 .24869 0 4.5 ]
[.01 .3669 -18 -4.5 ]
[.01 .3669 0 4.5 ]
[.01 .48511 -18 -4.5 ]
[.01 .48511 0 4.5 ]
[.01 .60332 -6 -4.5 ]
[.01 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1535 .01228 m
.1535 .01853 L
s
[(100)] .1535 -0.00022 0 1 Mshowa
.2845 .01228 m
.2845 .01853 L
s
[(200)] .2845 -0.00022 0 1 Mshowa
.4155 .01228 m
.4155 .01853 L
s
[(300)] .4155 -0.00022 0 1 Mshowa
.54651 .01228 m
.54651 .01853 L
s
[(400)] .54651 -0.00022 0 1 Mshowa
.67751 .01228 m
.67751 .01853 L
s
[(500)] .67751 -0.00022 0 1 Mshowa
.80851 .01228 m
.80851 .01853 L
s
[(600)] .80851 -0.00022 0 1 Mshowa
.93951 .01228 m
.93951 .01853 L
s
[(700)] .93951 -0.00022 0 1 Mshowa
.125 Mabswid
.0487 .01228 m
.0487 .01603 L
s
.0749 .01228 m
.0749 .01603 L
s
.1011 .01228 m
.1011 .01603 L
s
.1273 .01228 m
.1273 .01603 L
s
.1797 .01228 m
.1797 .01603 L
s
.2059 .01228 m
.2059 .01603 L
s
.2321 .01228 m
.2321 .01603 L
s
.2583 .01228 m
.2583 .01603 L
s
.3107 .01228 m
.3107 .01603 L
s
.3369 .01228 m
.3369 .01603 L
s
.3631 .01228 m
.3631 .01603 L
s
.3893 .01228 m
.3893 .01603 L
s
.4417 .01228 m
.4417 .01603 L
s
.4679 .01228 m
.4679 .01603 L
s
.4941 .01228 m
.4941 .01603 L
s
.52031 .01228 m
.52031 .01603 L
s
.57271 .01228 m
.57271 .01603 L
s
.59891 .01228 m
.59891 .01603 L
s
.62511 .01228 m
.62511 .01603 L
s
.65131 .01228 m
.65131 .01603 L
s
.70371 .01228 m
.70371 .01603 L
s
.72991 .01228 m
.72991 .01603 L
s
.75611 .01228 m
.75611 .01603 L
s
.78231 .01228 m
.78231 .01603 L
s
.83471 .01228 m
.83471 .01603 L
s
.86091 .01228 m
.86091 .01603 L
s
.88711 .01228 m
.88711 .01603 L
s
.91331 .01228 m
.91331 .01603 L
s
.96571 .01228 m
.96571 .01603 L
s
.99191 .01228 m
.99191 .01603 L
s
.25 Mabswid
0 .01228 m
1 .01228 L
s
.0225 .13048 m
.02875 .13048 L
s
[(0.2)] .01 .13048 1 0 Mshowa
.0225 .24869 m
.02875 .24869 L
s
[(0.4)] .01 .24869 1 0 Mshowa
.0225 .3669 m
.02875 .3669 L
s
[(0.6)] .01 .3669 1 0 Mshowa
.0225 .48511 m
.02875 .48511 L
s
[(0.8)] .01 .48511 1 0 Mshowa
.0225 .60332 m
.02875 .60332 L
s
[(1)] .01 .60332 1 0 Mshowa
.125 Mabswid
.0225 .04183 m
.02625 .04183 L
s
.0225 .07138 m
.02625 .07138 L
s
.0225 .10093 m
.02625 .10093 L
s
.0225 .16004 m
.02625 .16004 L
s
.0225 .18959 m
.02625 .18959 L
s
.0225 .21914 m
.02625 .21914 L
s
.0225 .27825 m
.02625 .27825 L
s
.0225 .3078 m
.02625 .3078 L
s
.0225 .33735 m
.02625 .33735 L
s
.0225 .39645 m
.02625 .39645 L
s
.0225 .42601 m
.02625 .42601 L
s
.0225 .45556 m
.02625 .45556 L
s
.0225 .51466 m
.02625 .51466 L
s
.0225 .54421 m
.02625 .54421 L
s
.0225 .57377 m
.02625 .57377 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02512 .01472 L
.02643 .01634 L
.02774 .01878 L
.02905 .02041 L
.03036 .02284 L
.03167 .02366 L
.03298 .0261 L
.03429 .02935 L
.0356 .03097 L
.03691 .03748 L
.03822 .03829 L
.03953 .0391 L
.04084 .04073 L
.04215 .04317 L
.04346 .04561 L
.04477 .04805 L
.04608 .05049 L
.04739 .0513 L
.0487 .05455 L
.05001 .05618 L
.05132 .06268 L
.05263 .06593 L
.05394 .06756 L
.05525 .07162 L
.05656 .07244 L
.05787 .07406 L
.05918 .0765 L
.06049 .07732 L
.0618 .07732 L
.06311 .07813 L
.06442 .07894 L
.06573 .07894 L
.06704 .07975 L
.06835 .08219 L
.06966 .08301 L
.07097 .08382 L
.07228 .08545 L
.07359 .08788 L
.0749 .09032 L
.07621 .09195 L
.07752 .09357 L
.07883 .09764 L
.08014 .09927 L
.08145 .10252 L
.08276 .10252 L
.08407 .10333 L
.08538 .1074 L
.08669 .10902 L
.088 .11227 L
Mistroke
.08931 .11471 L
.09062 .11878 L
.09193 .1204 L
.09324 .1204 L
.09455 .12366 L
.09586 .12366 L
.09717 .12691 L
.09848 .12772 L
.09979 .12853 L
.1011 .13179 L
.10241 .13422 L
.10372 .13748 L
.10503 .13992 L
.10634 .13992 L
.10765 .14073 L
.10896 .14154 L
.11027 .14561 L
.11158 .14642 L
.11289 .14805 L
.1142 .14967 L
.11551 .14967 L
.11682 .1513 L
.11813 .1513 L
.11944 .15536 L
.12075 .15618 L
.12206 .15699 L
.12337 .15943 L
.12468 .16187 L
.12599 .16512 L
.1273 .16918 L
.12861 .17081 L
.12992 .17243 L
.13123 .17325 L
.13254 .17325 L
.13385 .17487 L
.13516 .1765 L
.13647 .17813 L
.13778 .18056 L
.13909 .18138 L
.1404 .18382 L
.14171 .18626 L
.14302 .18869 L
.14433 .18951 L
.14564 .18951 L
.14695 .19195 L
.14826 .19276 L
.14957 .19357 L
.15088 .1952 L
.15219 .19682 L
.1535 .20008 L
Mistroke
.15481 .20089 L
.15612 .2017 L
.15743 .20252 L
.15874 .20495 L
.16005 .20495 L
.16136 .20739 L
.16267 .20739 L
.16398 .21065 L
.16529 .21308 L
.1666 .2139 L
.16791 .21634 L
.16922 .21878 L
.17053 .21878 L
.17184 .21878 L
.17315 .22203 L
.17446 .22365 L
.17577 .22691 L
.17708 .22853 L
.17839 .23016 L
.1797 .23016 L
.18101 .23097 L
.18232 .23097 L
.18363 .23178 L
.18494 .23341 L
.18625 .23341 L
.18756 .23504 L
.18887 .23991 L
.19018 .24073 L
.19149 .24316 L
.1928 .24642 L
.19411 .25048 L
.19542 .25211 L
.19673 .25455 L
.19804 .25699 L
.19935 .25699 L
.20066 .25861 L
.20197 .25942 L
.20328 .26024 L
.20459 .26186 L
.2059 .26268 L
.20721 .26268 L
.20852 .26268 L
.20983 .26349 L
.21114 .26349 L
.21245 .26674 L
.21376 .26837 L
.21507 .26918 L
.21638 .27081 L
.21769 .27081 L
.219 .27162 L
Mistroke
.22031 .27487 L
.22162 .2765 L
.22293 .27812 L
.22424 .27975 L
.22555 .28219 L
.22686 .28463 L
.22817 .28625 L
.22948 .28625 L
.23079 .28625 L
.2321 .28707 L
.23341 .28788 L
.23472 .29032 L
.23603 .29113 L
.23734 .29194 L
.23865 .29276 L
.23996 .29357 L
.24127 .29438 L
.24258 .2952 L
.24389 .2952 L
.2452 .29601 L
.24651 .29601 L
.24782 .29764 L
.24913 .29845 L
.25044 .30007 L
.25175 .30089 L
.25306 .30089 L
.25437 .30251 L
.25568 .30414 L
.25699 .30577 L
.2583 .30658 L
.25961 .30739 L
.26092 .30983 L
.26223 .31471 L
.26354 .31471 L
.26485 .31552 L
.26616 .31633 L
.26747 .31877 L
.26878 .32202 L
.27009 .32365 L
.2714 .32446 L
.27271 .3269 L
.27402 .3269 L
.27533 .3269 L
.27664 .32853 L
.27795 .33097 L
.27926 .33341 L
.28057 .33341 L
.28188 .33422 L
.28319 .33585 L
.2845 .33666 L
Mistroke
.28581 .33747 L
.28712 .34072 L
.28843 .34316 L
.28974 .34316 L
.29105 .34398 L
.29236 .34398 L
.29367 .34398 L
.29498 .3456 L
.29629 .34885 L
.2976 .35048 L
.29891 .35211 L
.30022 .35454 L
.30153 .35617 L
.30284 .35698 L
.30415 .35698 L
.30546 .35861 L
.30677 .35861 L
.30808 .35861 L
.30939 .35942 L
.3107 .36024 L
.31201 .36186 L
.31332 .36349 L
.31463 .3643 L
.31594 .36511 L
.31725 .36511 L
.31856 .36755 L
.31987 .36755 L
.32118 .36755 L
.32249 .36755 L
.3238 .36837 L
.32511 .3708 L
.32642 .37324 L
.32773 .37406 L
.32904 .37487 L
.33035 .3765 L
.33166 .3765 L
.33297 .37731 L
.33428 .37975 L
.33559 .38137 L
.3369 .38137 L
.33821 .38137 L
.33952 .38137 L
.34083 .38219 L
.34214 .38381 L
.34345 .38625 L
.34476 .38625 L
.34607 .38788 L
.34738 .38869 L
.34869 .3895 L
.35 .39113 L
Mistroke
.35131 .39194 L
.35262 .39275 L
.35393 .39357 L
.35524 .39601 L
.35655 .39845 L
.35786 .39845 L
.35917 .40007 L
.36048 .40088 L
.36179 .40332 L
.3631 .40414 L
.36441 .40495 L
.36572 .40739 L
.36703 .40739 L
.36834 .40901 L
.36965 .40983 L
.37096 .41064 L
.37227 .41227 L
.37358 .41227 L
.37489 .41227 L
.3762 .41308 L
.37751 .41389 L
.37882 .41471 L
.38013 .41471 L
.38144 .41552 L
.38275 .41552 L
.38406 .41552 L
.38537 .41552 L
.38668 .41552 L
.38799 .41552 L
.3893 .41633 L
.39061 .41633 L
.39192 .41714 L
.39323 .41796 L
.39454 .41877 L
.39585 .41958 L
.39716 .41958 L
.39847 .42202 L
.39978 .42202 L
.40109 .42365 L
.4024 .42365 L
.40371 .42365 L
.40502 .42446 L
.40633 .42446 L
.40764 .42446 L
.40895 .42446 L
.41026 .42609 L
.41157 .4269 L
.41288 .42853 L
.41419 .42853 L
.4155 .42853 L
Mistroke
.41681 .42934 L
.41812 .43097 L
.41943 .43097 L
.42074 .43178 L
.42205 .43178 L
.42336 .43259 L
.42467 .4334 L
.42598 .4334 L
.42729 .43422 L
.4286 .43503 L
.42991 .43503 L
.43122 .43666 L
.43253 .43666 L
.43384 .43666 L
.43515 .43666 L
.43646 .43666 L
.43777 .43747 L
.43908 .43747 L
.44039 .43747 L
.4417 .43747 L
.44301 .4391 L
.44432 .43991 L
.44563 .44072 L
.44694 .44153 L
.44825 .44316 L
.44956 .4456 L
.45087 .4456 L
.45218 .4456 L
.45349 .4456 L
.4548 .4456 L
.45611 .4456 L
.45742 .4456 L
.45873 .44641 L
.46004 .44641 L
.46135 .44641 L
.46266 .44723 L
.46397 .44723 L
.46528 .44804 L
.46659 .44966 L
.4679 .45129 L
.46921 .4521 L
.47052 .4521 L
.47183 .4521 L
.47314 .45292 L
.47445 .45373 L
.47576 .45617 L
.47707 .45617 L
.47838 .45698 L
.47969 .45779 L
.481 .45779 L
Mistroke
.48231 .45779 L
.48362 .45942 L
.48493 .46023 L
.48624 .46023 L
.48755 .46023 L
.48886 .46105 L
.49017 .46186 L
.49148 .46267 L
.49279 .46348 L
.4941 .4643 L
.49541 .46511 L
.49672 .46755 L
.49803 .46918 L
.49934 .46999 L
.50066 .46999 L
.50197 .4708 L
.50328 .4708 L
.50459 .47243 L
.5059 .47324 L
.50721 .47324 L
.50852 .47405 L
.50983 .47649 L
.51114 .47731 L
.51245 .47893 L
.51376 .48056 L
.51507 .48056 L
.51638 .48056 L
.51769 .48056 L
.519 .48056 L
.52031 .48137 L
.52162 .48137 L
.52293 .48218 L
.52424 .483 L
.52555 .483 L
.52686 .483 L
.52817 .48462 L
.52948 .48462 L
.53079 .48544 L
.5321 .48625 L
.53341 .48625 L
.53472 .48625 L
.53603 .48706 L
.53734 .48787 L
.53865 .48787 L
.53996 .48787 L
.54127 .48787 L
.54258 .4895 L
.54389 .49031 L
.5452 .49031 L
.54651 .49194 L
Mistroke
.54782 .49275 L
.54913 .49357 L
.55044 .49438 L
.55175 .49519 L
.55306 .49519 L
.55437 .49519 L
.55568 .496 L
.55699 .49844 L
.5583 .49844 L
.55961 .49926 L
.56092 .50007 L
.56223 .50088 L
.56354 .5017 L
.56485 .5017 L
.56616 .5017 L
.56747 .50251 L
.56878 .50251 L
.57009 .50332 L
.5714 .50413 L
.57271 .50413 L
.57402 .50413 L
.57533 .50413 L
.57664 .50413 L
.57795 .50495 L
.57926 .50657 L
.58057 .50739 L
.58188 .50983 L
.58319 .51064 L
.5845 .51064 L
.58581 .51064 L
.58712 .51064 L
.58843 .51064 L
.58974 .51064 L
.59105 .51064 L
.59236 .51064 L
.59367 .51064 L
.59498 .51145 L
.59629 .51308 L
.5976 .51308 L
.59891 .51308 L
.60022 .51308 L
.60153 .51389 L
.60284 .51389 L
.60415 .51389 L
.60546 .51389 L
.60677 .5147 L
.60808 .5147 L
.60939 .5147 L
.6107 .51552 L
.61201 .51552 L
Mistroke
.61332 .51714 L
.61463 .51714 L
.61594 .51714 L
.61725 .51796 L
.61856 .51877 L
.61987 .51958 L
.62118 .51958 L
.62249 .52283 L
.6238 .52283 L
.62511 .52283 L
.62642 .52283 L
.62773 .52365 L
.62904 .52365 L
.63035 .52527 L
.63166 .52608 L
.63297 .52608 L
.63428 .5269 L
.63559 .5269 L
.6369 .5269 L
.63821 .5269 L
.63952 .5269 L
.64083 .5269 L
.64214 .52771 L
.64345 .52771 L
.64476 .52771 L
.64607 .52771 L
.64738 .53015 L
.64869 .53015 L
.65 .53096 L
.65131 .53178 L
.65262 .5334 L
.65393 .53503 L
.65524 .53584 L
.65655 .53584 L
.65786 .53584 L
.65917 .53584 L
.66048 .53584 L
.66179 .53584 L
.6631 .53584 L
.66441 .53584 L
.66572 .53584 L
.66703 .53665 L
.66834 .53828 L
.66965 .53828 L
.67096 .53828 L
.67227 .53909 L
.67358 .53909 L
.67489 .53909 L
.6762 .53991 L
.67751 .53991 L
Mistroke
.67882 .54072 L
.68013 .54234 L
.68144 .54234 L
.68275 .54234 L
.68406 .54234 L
.68537 .54234 L
.68668 .54234 L
.68799 .54234 L
.6893 .54234 L
.69061 .54234 L
.69192 .54234 L
.69323 .54316 L
.69454 .54316 L
.69585 .54316 L
.69716 .54316 L
.69847 .54397 L
.69978 .54397 L
.70109 .54478 L
.7024 .5456 L
.70371 .5456 L
.70502 .54641 L
.70633 .54722 L
.70764 .54722 L
.70895 .54885 L
.71026 .54885 L
.71157 .54966 L
.71288 .54966 L
.71419 .54966 L
.7155 .54966 L
.71681 .55047 L
.71812 .5521 L
.71943 .5521 L
.72074 .55373 L
.72205 .55373 L
.72336 .55535 L
.72467 .55535 L
.72598 .55535 L
.72729 .55617 L
.7286 .55617 L
.72991 .55617 L
.73122 .55617 L
.73253 .55779 L
.73384 .56023 L
.73515 .56023 L
.73646 .56023 L
.73777 .56023 L
.73908 .56023 L
.74039 .56104 L
.7417 .56104 L
.74301 .56104 L
Mistroke
.74432 .56104 L
.74563 .56186 L
.74694 .56186 L
.74825 .56186 L
.74956 .56186 L
.75087 .56267 L
.75218 .56267 L
.75349 .56267 L
.7548 .56267 L
.75611 .56267 L
.75742 .56267 L
.75873 .56267 L
.76004 .56348 L
.76135 .5643 L
.76266 .5643 L
.76397 .5643 L
.76528 .56511 L
.76659 .56511 L
.7679 .56511 L
.76921 .56511 L
.77052 .56673 L
.77183 .56836 L
.77314 .56836 L
.77445 .56836 L
.77576 .56999 L
.77707 .56999 L
.77838 .5708 L
.77969 .5708 L
.781 .57161 L
.78231 .57161 L
.78362 .57161 L
.78493 .57161 L
.78624 .57243 L
.78755 .57243 L
.78886 .57243 L
.79017 .57243 L
.79148 .57243 L
.79279 .57324 L
.7941 .57324 L
.79541 .57324 L
.79672 .57405 L
.79803 .57568 L
.79934 .57568 L
.80065 .57568 L
.80196 .57568 L
.80327 .57568 L
.80458 .57568 L
.80589 .57568 L
.8072 .57649 L
.80851 .57649 L
Mistroke
.80982 .57649 L
.81113 .57649 L
.81244 .57649 L
.81375 .5773 L
.81506 .5773 L
.81637 .5773 L
.81768 .5773 L
.81899 .57812 L
.8203 .57812 L
.82161 .57893 L
.82292 .57893 L
.82423 .57974 L
.82554 .57974 L
.82685 .57974 L
.82816 .57974 L
.82947 .57974 L
.83078 .57974 L
.83209 .57974 L
.8334 .57974 L
.83471 .57974 L
.83602 .58056 L
.83733 .58137 L
.83864 .58137 L
.83995 .58299 L
.84126 .58381 L
.84257 .58381 L
.84388 .58543 L
.84519 .58625 L
.8465 .58625 L
.84781 .58706 L
.84912 .58706 L
.85043 .58706 L
.85174 .58706 L
.85305 .58787 L
.85436 .58787 L
.85567 .58869 L
.85698 .58869 L
.85829 .58869 L
.8596 .58869 L
.86091 .58869 L
.86222 .58869 L
.86353 .58869 L
.86484 .5895 L
.86615 .5895 L
.86746 .5895 L
.86877 .5895 L
.87008 .5895 L
.87139 .5895 L
.8727 .5895 L
.87401 .5895 L
Mistroke
.87532 .59031 L
.87663 .59031 L
.87794 .59031 L
.87925 .59031 L
.88056 .59031 L
.88187 .59031 L
.88318 .59031 L
.88449 .59031 L
.8858 .59031 L
.88711 .59031 L
.88842 .59031 L
.88973 .59112 L
.89104 .59112 L
.89235 .59112 L
.89366 .59112 L
.89497 .59112 L
.89628 .59112 L
.89759 .59112 L
.8989 .59194 L
.90021 .59356 L
.90152 .59438 L
.90283 .59519 L
.90414 .59519 L
.90545 .59519 L
.90676 .596 L
.90807 .596 L
.90938 .59681 L
.91069 .59681 L
.912 .59681 L
.91331 .59681 L
.91462 .59681 L
.91593 .59681 L
.91724 .59681 L
.91855 .59763 L
.91986 .59763 L
.92117 .59763 L
.92248 .59763 L
.92379 .59763 L
.9251 .59763 L
.92641 .59763 L
.92772 .59763 L
.92903 .59763 L
.93034 .59763 L
.93165 .59844 L
.93296 .59844 L
.93427 .59844 L
.93558 .59844 L
.93689 .59925 L
.9382 .59925 L
.93951 .59925 L
Mistroke
.94082 .59925 L
.94213 .59925 L
.94344 .59925 L
.94475 .59925 L
.94606 .59925 L
.94737 .59925 L
.94868 .60007 L
.94999 .60007 L
.9513 .60007 L
.95261 .60007 L
.95392 .60007 L
.95523 .60007 L
.95654 .60088 L
.95785 .60088 L
.95916 .60088 L
.96047 .60088 L
.96178 .60251 L
.96309 .60251 L
.9644 .60251 L
.96571 .60332 L
.96702 .60332 L
.96833 .60332 L
.96964 .60332 L
.97095 .60332 L
.97226 .60332 L
.97357 .60332 L
.97488 .60332 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{597.688, 175.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009E0000[b000`400?l00000o`00003oo`0J6Q[o
01XJ6UL06QXJ003o01XJ6_l06QXJE`0J6QX00?l06QXJo`0J6QYG01XJ6P00o`0J6Q[o01XJ6UL06QXJ
003o01XJ6_l06QXJE`0J6QX003h06QXJ1@3Kfm/201XJ6P80fm_K100J6QX20=_Kfa806QXJ103Kfm/3
01XJ6P80fm_K100J6QX20=_Kfa<06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa@06QXJ0`3Kfm/2
01XJ6P80fm_K100J6QX20=_Kfa<06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa806QXJ0`3Kfm/4
01XJ6P80fm_K100J6QX20=_Kfa@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`@06QXJ0P3Kfm]C
01XJ6PD0fm_K0P0J6QX20=_Kf`@06QXJ0P3Kfm/B01XJ6P@0fm_K0`0J6QX20=_Kf`@06QXJ0P3Kfm/C
01XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/E01XJ6P<0fm_K0P0J6QX20=_Kf`@06QXJ0P3Kfm/C
01XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/B01XJ6P<0fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/D
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/401XJ6P80fm_K6@0J6QX004006QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX03`0J
6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0
fm_K4@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K
01XJ6P0J6QX0fm_K500J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`80
6QXJ00<0fm_K01XJ6P0J6QX03`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_K
f`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0
fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P1B01XJ6P050=_Kf`0J
6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00l0
6QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ
0=_Kfa406QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_K
f`0J6QX06QXJ0=_KfaD06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/2
01XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa406QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103K
fm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa<06QXJ00D0fm_K01XJ6P0J6QX06QXJ
0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX05P0J6QX004006QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ
6P0J6QX0400J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K
01XJ6P0J6QX0fm_K4`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0
fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6PD0fm_K00D06QXJ0=_Kf`0J6QX06QXJ0=_Kf`0201XJ
6P040=_Kf`0J6QX06QXJ0=_Kfa@06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa<06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0DP0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ
6P030=_Kf`0J6QX06QXJ00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3K
fm/C01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P03
0=_Kf`0J6QX06QXJ01006QXJ1@3Kfm/01@0J6QX0fm_K01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ
6P0J6QX0fm_K500J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX03`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_K
f`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0
fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P00@00J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P05
0=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0
6QXJ01806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_K
f`0J6QX06QXJ00l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ
6P040=_Kf`0J6QX06QXJ0=_Kfa806QXJ0P3Kfm/301XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0
fm_K01XJ6P0J6QX0fm_K4@0J6QX30=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/D01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J
6QX00`3Kfm/06QXJ01XJ6P1B01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ01406QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX04P0J6QX0103Kfm/06QXJ01XJ6P3K
fm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0400J6QX0103Kfm/06QXJ
01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4P0J6QX2
0=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/A01XJ6P<0fm_K
0`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa@06QXJ00@0fm_K01XJ
6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ01H06QXJ0010
01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_K
f`0J6QX06QXJ00l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ
6P040=_Kf`0J6QX06QXJ0=_Kfa406QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa806QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa806QXJ00<0fm_K01XJ6P0J6QX00P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa806QXJ00<0fm_K01XJ6P0J6QX0
0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa406QXJ00@0fm_K01XJ
6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfe@06QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ
6P0J6QX03`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0
fm_K01XJ6P0J6QX0fm_K4@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_K
f`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P040=_K
f`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K4@0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K600J6QX003l0
6QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa<06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa<0
6QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa@06QXJ0P3Kfm/301XJ6P80fm_K100J6QX20=_Kfa<0
6QXJ0`3Kfm/301XJ6P80fm_K100J6QX20=_Kfa<06QXJ0`3Kfm/301XJ6P80fm_K100J6QX20=_Kfa80
6QXJ103Kfm/301XJ6P80fm_K100J6QX20=_Kfe@06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa<0
6QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa<06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_KfaD0
6QXJ0P3Kfm/301XJ6P80fm_K100J6QX20=_Kfa<06QXJ0`3Kfm/301XJ6P80fm_K100J6QX20=_Kfa<0
6QXJ0`3Kfm/301XJ6P80fm_K100J6QX20=_Kfa806QXJ103Kfm/301XJ6P80fm_K100J6QX20=_KfaT0
6QXJ003o01XJ6_l06QXJE`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0o`0J6Q[o01XJ6Rl06QXJ000U
01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJ9P0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6PH06QXJ000U01XJ
6P030=_Kf`0J6QX06QXJ0?l06QXJ9P0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6PH06QXJ000U01XJ6P03
0=_Kf`0J6QX06QXJ0?l06QXJ9P0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6PH06QXJ000O01XJ6_d0fm_K
:`0J6Q[o0=_Kf`l06QXJ000U01XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/00P0J
6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ0P3Kfm/401XJ6P050=_Kf`0J6QX06QXJ
01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0fm_K00H06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm/5
01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0`
01XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K
01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P050=_K
f`806QXJ00@0fm_K01XJ6P3Kfm/0fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0
fm_K01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P80fm_K5`0J6QX00`3Kfm/06QXJ01XJ
6P0301XJ6P030=_Kf`0J6QX0fm_K02006QXJ00<0fm_K01XJ6P0J6QX07P0J6QX00`3Kfm/06QXJ01XJ
6P0C01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P80fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0i01XJ6P80fm_K7`0J6QX00`3Kfm/06QXJ01XJ
6P0N01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ00<0fm_K01XJ6P0J6QX07`0J6QX00`3Kfm/06QXJ01XJ
6P0N01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ00<0fm_K01XJ6P0J6QX07P0J6QX00`3Kfm/06QXJ01XJ
6P0M01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6PT0fm_K0P0J6QX20=_Kf`806QXJ00@0fm_K
01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00H0
fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/;01XJ6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J
6QX07@0J6QX00`3Kfm/06QXJ01XJ6P0U01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J
6QX05`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0>`0J6QX00`3K
fm/06QXJ0=_Kf`3o01XJ6PH06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P3K
fm/01@3Kfm/01P0J6QX0fm_K0=_Kf`3Kfm/06QXJ0=_Kf`806QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`04
01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX01P3Kfm/06QXJ01XJ6P3K
fm/06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P030=_K
f`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_K
f`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J6QX07@0J6QX00`3Kfm/06QXJ01XJ6P0C01XJ6P050=_K
f`0J6QX06QXJ01XJ6P3Kfm/03@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX05`0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/0>`0J6QX0103Kfm/06QXJ01XJ6P3Kfm_o01XJ6PD06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ
00P06QXJ203Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00@06QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX0fm_K00H06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ
6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ
01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ
01XJ6P0:01XJ6P030=_Kf`0J6QX06QXJ01d06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K00d06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ
0=_KfaT06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K03/06QXJ00@0
fm_K01XJ6P0J6QX0fm_Ko`0J6QX501XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6PH0fm_K00<0
6QXJ0=_Kf`3Kfm/00`3Kfm/00`0J6QX0fm_K0=_Kf`0401XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/0
100J6QX30=_Kf`H06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ
00H06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P070=_Kf`0J6QX06QXJ
01XJ6P3Kfm/06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0fm_K01XJ6P0J6QX07@0J
6QX00`3Kfm/06QXJ01XJ6P0C01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/03@0J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K6@0J6QX00`3Kfm/06QXJ01XJ6P0501XJ
6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0>`0J6QX0103Kfm/06QXJ01XJ6P3Kfm_o01XJ6PD06QXJ000U
01XJ6P80fm_K2`0J6QX00`3Kfm/06QXJ0=_Kf`030=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ
0=_Kf`3Kfm/0100J6QX30=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ0`3Kfm/501XJ6P<0fm_K00@0
6QXJ0=_Kf`0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00X06QXJ
00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0fm_K00@06QXJ
00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P030=_Kf`0J6QX06QXJ01<06QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0=01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00H0fm_K01XJ6P0J
6QX0fm_K01XJ6P3Kfm/I01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_K
f`0k01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6P806QXJ000U01XJ6P030=_Kf`0J6QX0
6QXJ00`06QXJ2P3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`0301XJ6P3Kfm/0fm_K00D0fm_K0P0J6QX3
0=_Kf`D06QXJ0`3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00L0
fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00H06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/0
6QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0fm_K00@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/0
6QXJ01XJ6P0401XJ6P80fm_K7P0J6QX00`3Kfm/06QXJ01XJ6P0C01XJ6P050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/03@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K200J
6QX0103Kfm/06QXJ01XJ6P3Kfm/=01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00D0fm_K01XJ6P0J6QX0
6QXJ0=_Kf`0k01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0o`0J6QX101XJ6P00
9@0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P80fm_K0P0J6QX<0=_Kf`0301XJ6P3Kfm/0fm_K00D0fm_K
0P0J6QX30=_Kf`0301XJ6P3Kfm/06QXJ00806QXJ0`3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P03
0=_Kf`0J6QX06QXJ00H06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00H06QXJ00<0fm_K
01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0fm_K00@06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P80fm_K400J6QX00`3Kfm/06QXJ01XJ6P0;
01XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ6P030=_Kf`0J
6QX06QXJ00/06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_K
f`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K3@0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P050=_Kf`0J6QX0
6QXJ01XJ6P3Kfm/0>`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ0?l06QXJ0@0J
6QX002D06QXJ00<0fm_K01XJ6P0J6QX0400J6QXD0=_Kf`806QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P02
01XJ6P<0fm_K00@06QXJ0=_Kf`0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P070=_Kf`0J
6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0601XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P3K
fm/00`0J6QX00`3Kfm/06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J
6QX0100J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX02`0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ
0=_Kf``06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00@0
fm_K01XJ6P0J6QX0fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`P06QXJ00@0fm_K01XJ
6P0J6QX0fm_K1`0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/01`0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K03/06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6P00
9@0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P030=_Kf`0J6QX06QXJ00806QXJ403Kfm/01P0J6QX0fm_K
0=_Kf`3Kfm/06QXJ0=_Kf`<06QXJ0`3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ00<0fm_K1`0J6QX0
1`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/01P0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_K
f`0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ00@06QXJ0P3Kfm/@01XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00H0fm_K01XJ6P0J6QX0
fm_K01XJ6P3Kfm/<01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0;
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/801XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L06QXJ00D0
fm_K01XJ6P0J6QX06QXJ0=_Kf`0k01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm_o01XJ6P406QXJ
000U01XJ6P030=_Kf`0J6QX06QXJ01D06QXJ403Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ0080fm_K
0P0J6QX30=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/701XJ6P070=_Kf`0J6QX06QXJ01XJ
6P3Kfm/06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX0fm_K00P06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX0
103Kfm/06QXJ0=_Kf`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P060=_Kf`0J
6QX06QXJ0=_Kf`0J6QX0fm_K2`0J6QX20=_Kf`<06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0=01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/801XJ6P040=_K
f`0J6QX06QXJ0=_Kf`L06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L06QXJ00D0fm_K
01XJ6P0J6QX06QXJ0=_Kf`0k01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0oP0J
6QX002D06QXJ00<0fm_K01XJ6P0J6QX05@0J6QXD0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00`3K
fm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`<06QXJ
00<0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/06QXJ0=_Kf`0801XJ6P030=_Kf`0J6QX0fm_K00<06QXJ
00@0fm_K01XJ6P3Kfm/0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@0
6QXJ0P3Kfm/@01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX01P3Kfm/0
6QXJ01XJ6P3Kfm/06QXJ0=_Kf`/06QXJ0P3Kfm/301XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0;
01XJ6P030=_Kf`0J6QX06QXJ0080fm_K00L06QXJ0=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K00P06QXJ
00@0fm_K01XJ6P0J6QX0fm_K1`0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/01`0J6QX0
1@3Kfm/06QXJ01XJ6P0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ0?h06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K
01XJ6P3Kfm/04@3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K
01XJ6P030=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00@06QXJ
00<0fm_K01XJ6P3Kfm/01@0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`<06QXJ103Kfm/301XJ
6P070=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0601XJ6P80fm_K400J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/;01XJ6P80
fm_K0`0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`07
01XJ6P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00L0
fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ
6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX0100J6QX20=_Kfol06QXJ000U01XJ6P80
fm_K6@0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/01`0J6QX0
fm_K0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K0=_Kf`0301XJ6P030=_Kf`0J6QX0
fm_K00@06QXJ00<0fm_K01XJ6P3Kfm/01@0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`<06QXJ
103Kfm/301XJ6P070=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0601XJ6P80fm_K3P0J6QX00`3K
fm/06QXJ0=_Kf`0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3K
fm/;01XJ6P80fm_K0`0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ
6P020=_Kf`0701XJ6P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P040=_Kf`0J6QX06QXJ0=_K
f`L06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L06QXJ00@0fm_K01XJ6P0J6QX06QXJ
0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ0P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ0?d06QXJ
000U01XJ6P030=_Kf`0J6QX06QXJ01P06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QXH0=_Kf`0301XJ6P3K
fm/0fm_K00<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`@06QXJ
00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/201XJ6P090=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3K
fm/06QXJ00D0fm_K0P0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/01P0J6QX20=_Kf`h0
6QXJ00<0fm_K01XJ6P3Kfm/01P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P060=_Kf`0J6QX06QXJ0=_K
f`0J6QX0fm_K2`0J6QX20=_Kf`<06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0fm_K
01XJ6P0J6QX00P3Kfm/01`0J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/0200J6QX0103Kfm/06QXJ
01XJ6P3Kfm/701XJ6P070=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0701XJ6P040=_Kf`0J6QX0
6QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ0P3K
fm_m01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P0J01XJ6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K00<0
6QXJ0=_Kf`3Kfm/02`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K
00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`@06QXJ00@0fm_K01XJ6P3K
fm/06QXJ0P3Kfm/201XJ6P090=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ00D0fm_K
0P0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/01P0J6QX20=_Kf`h06QXJ0`3Kfm/601XJ
6P030=_Kf`0J6QX06QXJ00@06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/;01XJ6P80fm_K0`0J
6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`0701XJ6P3K
fm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00L0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_K
f`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX20=_Kfo`06QXJ000U01XJ6P030=_Kf`0J
6QX06QXJ01h06QXJ0`3Kfm/201XJ6P`0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K
0=_Kf`060=_Kf`0601XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/301XJ6P@0fm_K00<06QXJ0=_K
f`3Kfm/00P0J6QX02@3Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P050=_Kf`806QXJ
00T0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/0100J6QX20=_Kf`h06QXJ0`3Kfm/6
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`/0
6QXJ0P3Kfm/301XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_Kf`0J6QX0fm_K0080
6QXJ0P3Kfm/01`0J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00L0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J6QX0fm_K00L0
6QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ
6P0J6QX0200J6QX20=_Kfo/06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ0`3Kfm/201XJ6P03
0=_Kf`0J6QX0fm_K00T0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`090=_K
f`0301XJ6P3Kfm/0fm_K00<0fm_K0`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ
6P3Kfm/00`3Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`806QXJ00T0fm_K01XJ6P0J6QX06QXJ0=_Kf`0J
6QX0fm_K01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/>01XJ6P<0fm_K1P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/;01XJ6P80fm_K0`0J
6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX02@0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P80fm_K00L0
6QXJ0=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/701XJ6P030=_Kf`0J6QX06QXJ0080fm_K00<06QXJ0=_Kf`0J6QX01P0J6QX0103K
fm/06QXJ01XJ6P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P09
01XJ6P80fm_KnP0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX07P0J6QX00`3Kfm/06QXJ0=_Kf`0401XJ
6PX0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ3P3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`<06QXJ103Kfm/0
1`0J6QX0fm_K0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX00P3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX0fm_K0=_K
f`h06QXJ0`3Kfm/601XJ6P030=_Kf`0J6QX06QXJ00806QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3K
fm/06QXJ0=_Kf`/06QXJ0P3Kfm/301XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_K
f`0J6QX0fm_K00806QXJ0P3Kfm/01`0J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3K
fm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ0080fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P020=_K
f`0301XJ6P3Kfm/06QXJ00H06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX0
6QXJ03D06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P3h01XJ6P009@0J6QX00`3K
fm/06QXJ01XJ6P0U01XJ6PP0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K0=_Kf`030=_K
f`0301XJ6P3Kfm/0fm_K00`0fm_K0`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_K
f`3Kfm/00P3Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/0100J
6QX0fm_K01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX0fm_K0=_Kf`h06QXJ0`3Kfm/601XJ6P030=_Kf`0J
6QX06QXJ00806QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`X06QXJ0`3Kfm/301XJ
6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030=_Kf`0J6QX0fm_K00806QXJ0P3Kfm/01`0J
6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J
6QX06QXJ0080fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`0301XJ6P3Kfm/06QXJ00H06QXJ00@0
fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX0
2`0J6QX00`3Kfm/06QXJ01XJ6P3g01XJ6P009@0J6QX20=_KfbP06QXJ00<0fm_K01XJ6P3Kfm/00`3K
fm/00`0J6QX0fm_K01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`3Kfm/03@3K
fm/201XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3K
fm/06QXJ00D0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX0
0P3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ00T06QXJ0`3Kfm/601XJ6P030=_K
f`0J6QX06QXJ00806QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`X06QXJ0`3Kfm/3
01XJ6P80fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00L06QXJ00<0fm_K01XJ6P3Kfm/00P0J
6QX20=_Kf`0701XJ6P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/601XJ6P030=_Kf`0J6QX06QXJ0080fm_K00<06QXJ0=_Kf`0J
6QX01P0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX20=_K
f``06QXJ00<0fm_K01XJ6P0J6QX0m`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX09`0J6QX00`3Kfm/0
6QXJ0=_Kf`030=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00L06QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/0
6QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/201XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/0203Kfm/0
0`0J6QX0fm_K01XJ6P060=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K
01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ6P0J6QX02@0J6QX40=_Kf`D06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX0203Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K2P0J6QX3
0=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX0
fm_K00806QXJ0P3Kfm/01`0J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K0080
6QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P0601XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX00`3K
fm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0fm_K01XJ6P0J6QX0mP0J6QX002D0
6QXJ00<0fm_K01XJ6P0J6QX09`0J6QX00`3Kfm/06QXJ01XJ6P030=_Kf`0301XJ6P3Kfm/06QXJ0080
fm_K00L06QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/2
01XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/02P3Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`0401XJ6P3Kfm/0
6QXJ01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P020=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P@0fm_K1@0J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/:01XJ6P<0fm_K0`0J6QX2
0=_Kf`806QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX2
0=_Kf`0701XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX20=_Kf`03
01XJ6P3Kfm/06QXJ00H06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ
03D06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX00`3Kfm/06QXJ01XJ6P3e01XJ6P009@0J6QX00`3Kfm/0
6QXJ01XJ6P0W01XJ6P030=_Kf`0J6QX06QXJ00<0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/01`0J6QX0
fm_K0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00L0fm_K0P0J
6QX40=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K01XJ
6P0J6QX20=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00P3Kfm/01P0J6QX0fm_K0=_Kf`3Kfm/06QXJ
0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX40=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX0
203Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K2P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80
fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX0fm_K00806QXJ0P3Kfm/01`0J6QX0
fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0
fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ0P3Kfm/00`0J6QX0fm_K01XJ
6P0601XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_K
f`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX0m@0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0:`0J
6QX20=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00L06QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/06QXJ00<0
fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0=0=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_K
f`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX01P3Kfm/0
0`0J6QX0fm_K01XJ6P0301XJ6P80fm_K00<06QXJ0=_Kf`0J6QX00P0J6QX50=_Kf`@06QXJ00<0fm_K
01XJ6P0J6QX00P0J6QX0203Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K2P0J6QX30=_Kf`<0
6QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX0fm_K0080
6QXJ0P3Kfm/01`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ0P3K
fm/00`0J6QX0fm_K01XJ6P0601XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ
01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ00h06QXJ00<0fm_K01XJ6P0J6QX0m00J6QX002D06QXJ00<0
fm_K01XJ6P0J6QX0;00J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<0
6QXJ0=_Kf`0J6QX00`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00d0fm_K00<06QXJ0=_Kf`3Kfm/0
2P3Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`0301XJ6P3Kfm/06QXJ00<0fm_K00D06QXJ0=_Kf`3Kfm/0
fm_K01XJ6P060=_Kf`0301XJ6P3Kfm/06QXJ00<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ
00D0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ
6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX20=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`806QXJ0P3Kfm/01`0J
6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J
6QX0fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ0P3Kfm/00`0J6QX0fm_K
01XJ6P0601XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P03
0=_Kf`0J6QX06QXJ00h06QXJ0P3Kfm_e01XJ6P004P0J6QX20=_Kf`@06QXJ0P3Kfm/301XJ6P@0fm_K
100J6QX00`3Kfm/06QXJ01XJ6P0/01XJ6P030=_Kf`0J6QX0fm_K00806QXJ00P0fm_K01XJ6P3Kfm/0
6QXJ0=_Kf`0J6QX0fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0=0=_Kf`0301XJ6P3K
fm/0fm_K00X0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0501XJ6P3K
fm/0fm_K0=_Kf`0J6QX01P3Kfm/00`0J6QX0fm_K01XJ6P0301XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0
fm_K01XJ6P050=_Kf`<06QXJ0P3Kfm/401XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3K
fm/501XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX20=_Kf`806QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`806QXJ0P3Kfm/01`0J6QX0
fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0
fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ0P3Kfm/01@0J6QX0fm_K01XJ
6P0J6QX0fm_K00@06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ0240
6QXJ0P3Kfm/401XJ6P80fm_K0`0J6QX40=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`3Kfm/0
6QXJ01XJ6P3c01XJ6P004@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ00D0
6QXJ00<0fm_K01XJ6P0J6QX0;P0J6QX02`3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ
6P3Kfm/06QXJ00<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0=0=_Kf`0301XJ6P3Kfm/0fm_K00X0
fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0501XJ6P3Kfm/0fm_K0=_K
f`0J6QX01P3Kfm/00`0J6QX0fm_K01XJ6P0301XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P05
0=_Kf`<06QXJ0P3Kfm/401XJ6P080=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/501XJ6P03
0=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J
6QX00P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`806QXJ0P3Kfm/01`0J6QX0fm_K0=_Kf`0J
6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K
0P0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P0J6QX0fm_K
00@06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ02006QXJ00@0fm_K
01XJ6P0J6QX0fm_K200J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ01006QXJ00<0
fm_K01XJ6P0J6QX0lP0J6QX001406QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P<0fm_K;P0J6QX02`3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/0
6QXJ00<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0=0=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<0
6QXJ0=_Kf`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K00<0
6QXJ0=_Kf`0J6QX00`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX01@3Kfm/301XJ6P80fm_K
100J6QX0203Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P<0fm_K0`0J6QX20=_Kf`806QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00806QXJ00H0fm_K
01XJ6P0J6QX0fm_K01XJ6P3Kfm/201XJ6P80fm_K00L06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K
00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`806QXJ00D0fm_K01XJ
6P0J6QX06QXJ0=_Kf`0201XJ6P80fm_K00D06QXJ0=_Kf`0J6QX06QXJ0=_Kf`0401XJ6P040=_Kf`0J
6QX06QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0P01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T0
6QXJ00<0fm_K01XJ6P0J6QX01@0J6QX20=_Kfa806QXJ00<0fm_K01XJ6P0J6QX0l@0J6QX001406QXJ
00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ03<0
6QXJ00D0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0201XJ6P80fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0=
0=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P03
0=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K00<06QXJ0=_Kf`3Kfm/00`0J6QX40=_Kf`0301XJ6P3Kfm/0
6QXJ00D0fm_K0`0J6QX20=_Kf`@06QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`D0
6QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K0P0J6QX20=_Kf`0701XJ6P3Kfm/0
fm_K01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/0
0P3Kfm/201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX20=_Kf`0701XJ6P3Kfm/06QXJ01XJ
6P3Kfm/06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ
6P0P01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ
01XJ6P0A01XJ6P030=_Kf`0J6QX06QXJ0?406QXJ000A01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ
00@0fm_K01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0c01XJ6P050=_Kf`0J6QX06QXJ01XJ
6P3Kfm/00P0J6QX20=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K0=_Kf`08
0=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/00`0J6QX0fm_K01XJ6P03
0=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K00<06QXJ0=_Kf`3Kfm/00`0J6QX40=_Kf`0301XJ6P3Kfm/0
6QXJ00D0fm_K0`0J6QX20=_Kf`@06QXJ00P0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`D0
6QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P060=_Kf`0J6QX06QXJ0=_Kf`0J6QX0fm_K0P0J6QX20=_Kf`0701XJ6P3Kfm/0
fm_K01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/0
0P3Kfm/201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX20=_Kf`0801XJ6P3Kfm/06QXJ01XJ
6P3Kfm/06QXJ0=_Kf`0J6QX20=_Kf`<06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ02006QXJ00@0
fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ0140
6QXJ0P3Kfm_b01XJ6P004P0J6QX20=_Kf`X06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ03<06QXJ
00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P80fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P020=_K
f`0401XJ6P3Kfm/06QXJ01XJ6PL0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`05
0=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`08
0=_Kf`0301XJ6P3Kfm/0fm_K00<06QXJ103Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`<06QXJ0P3Kfm/4
01XJ6P0:0=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`<06QXJ00<0fm_K01XJ
6P0J6QX00P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/0
6QXJ0=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K
0`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0fm_K00806QXJ0P3Kfm/0200J6QX0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/06QXJ0P3K
fm/301XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0Q01XJ6P80fm_K2P0J6QX20=_Kf`H06QXJ00<0
fm_K01XJ6P0J6QX04P0J6QX20=_Kfo406QXJ000U01XJ6P030=_Kf`0J6QX06QXJ03X06QXJ0P3Kfm/0
1@0J6QX0fm_K0=_Kf`3Kfm/06QXJ0080fm_K00@06QXJ0=_Kf`0J6QX06QXJ1`3Kfm/00`0J6QX0fm_K
0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00h0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0:0=_Kf`03
01XJ6P3Kfm/0fm_K00<06QXJ103Kfm/00`0J6QX0fm_K01XJ6P050=_Kf`<06QXJ0P3Kfm/401XJ6P0:
0=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0
0P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX01P3Kfm/06QXJ01XJ6P3Kfm/06QXJ0=_K
f`806QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX0
0`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX0fm_K00806QXJ0P3Kfm/0200J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/301XJ
6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ01<06QXJ0P3Kfm_`01XJ
6P009@0J6QX00`3Kfm/06QXJ01XJ6P0j01XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX00`3K
fm/06QXJ0=_Kf`0201XJ6PL0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0>0=_K
f`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX02P3Kfm/00`0J6QX0fm_K0=_Kf`0301XJ6P@0fm_K00<06QXJ
0=_Kf`0J6QX01@3Kfm/301XJ6P80fm_K100J6QX02P3Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0
fm_K01XJ6P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX20=_K
f`806QXJ0P3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K00806QXJ0P3Kfm/0
100J6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_K
f`020=_Kf`806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P80fm_K00P06QXJ0=_Kf`3Kfm/0
6QXJ0=_Kf`0J6QX0fm_K01XJ6P80fm_K0`0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX0
0`3Kfm/06QXJ01XJ6P0D01XJ6P80fm_Kk`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0>P0J6QX00`3K
fm/06QXJ01XJ6P030=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K
0080fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0>0=_Kf`0501XJ6P3Kfm/0fm_K
0=_Kf`0J6QX02P3Kfm/0100J6QX0fm_K0=_Kf`3Kfm/201XJ6P@0fm_K00<06QXJ0=_Kf`0J6QX01@3K
fm/301XJ6P80fm_K100J6QX02P3Kfm/06QXJ0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/3
01XJ6P030=_Kf`0J6QX0fm_K00806QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX20=_Kf`806QXJ0P3Kfm/0
100J6QX0fm_K01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/0
6QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P03
0=_Kf`0J6QX06QXJ0080fm_K0P0J6QX20=_Kf`0601XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ103Kfm/3
01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ01D06QXJ0P3Kfm_^
01XJ6P009@0J6QX20=_Kfc/06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J
6QX0fm_K00806QXJ0P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00D0fm_K00<06QXJ0=_Kf`3Kfm/0
3P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00X0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX60=_K
f`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/301XJ6P80fm_K00T06QXJ0=_K
f`3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P<0fm_K
0`0J6QX20=_Kf`806QXJ0P3Kfm/201XJ6P80fm_K00@06QXJ0=_Kf`0J6QX0fm_K0P0J6QX0103Kfm/0
6QXJ0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`0501XJ6P3Kfm/0
fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`<06QXJ0P3Kfm/201XJ6P030=_Kf`0J
6QX06QXJ03D06QXJ0P3Kfm/G01XJ6P030=_Kf`0J6QX06QXJ0>`06QXJ000U01XJ6P030=_Kf`0J6QX0
6QXJ03d06QXJ00<0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`0701XJ6P3Kfm/0
fm_K0=_Kf`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00h0fm_K00D06QXJ0=_Kf`3Kfm/0
fm_K01XJ6P0:0=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ1P3Kfm/00`0J6QX0fm_K0=_Kf`030=_K
f`0301XJ6P3Kfm/06QXJ0080fm_K0`0J6QX20=_Kf`0901XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_K
f`0J6QX0fm_K00<06QXJ00D0fm_K01XJ6P3Kfm/0fm_K01XJ6P030=_Kf`<06QXJ0P3Kfm/201XJ6P80
fm_K00P06QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P3Kfm/06QXJ
0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0
6QXJ0=_Kf`020=_Kf`806QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ
00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/301XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ
6P030=_Kf`0J6QX06QXJ01L06QXJ00<0fm_K01XJ6P0J6QX0j`0J6QX002D06QXJ00<0fm_K01XJ6P0J
6QX0?@0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ0080fm_K00L06QXJ0=_Kf`3K
fm/0fm_K01XJ6P3Kfm/06QXJ0080fm_K0P0J6QX@0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX03P3K
fm/201XJ6PH0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/00`0J6QX0fm_K01XJ6P020=_Kf`<06QXJ0P3K
fm/02@0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0301XJ6P050=_Kf`0J6QX0fm_K
0=_Kf`0J6QX00`3Kfm/301XJ6P80fm_K0P0J6QX20=_Kf`0801XJ6P3Kfm/0fm_K0=_Kf`0J6QX0fm_K
01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/3
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P030=_Kf`0J6QX0
6QXJ0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J
6QX30=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P030=_Kf`0J
6QX06QXJ0>/06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ04L06QXJ0P3Kfm/01`0J6QX0fm_K0=_Kf`3K
fm/06QXJ0=_Kf`0J6QX00P3Kfm/201XJ6Q00fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P0?0=_Kf`03
01XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/301XJ6P80fm_K00<06QXJ0=_Kf`3K
fm/0103Kfm/00`0J6QX0fm_K01XJ6P0201XJ6P050=_Kf`0J6QX0fm_K0=_Kf`0J6QX00`3Kfm/301XJ
6P80fm_K0P0J6QX20=_Kf`0801XJ6P3Kfm/0fm_K0=_Kf`0J6QX0fm_K01XJ6P3Kfm/201XJ6P040=_K
f`0J6QX0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ
00806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ0080fm_K00D06QXJ0=_K
f`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`806QXJ00<0fm_K
01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P80fm_Kk00J6QX002D06QXJ00<0fm_K01XJ
6P0J6QX0A`0J6QX20=_Kf`0701XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P020=_Kf`806QXJ403K
fm/00`0J6QX0fm_K0=_Kf`0A0=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00<06QXJ0=_Kf`0J6QX00P3K
fm/301XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K01XJ6P0J6QX20=_Kf`0401XJ
6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX20=_Kf`806QXJ0P3Kfm/0200J6QX0fm_K0=_Kf`3Kfm/06QXJ
0=_Kf`0J6QX0fm_K0P0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0
fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX00`3Kfm/0
6QXJ01XJ6P020=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`806QXJ0`3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX0600J6QX20=_K
fn/06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ04L06QXJ0P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ00d0
fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/00`0J6QX0fm_K0=_Kf`080=_Kf`0301XJ6P3Kfm/0fm_K00X0
fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/201XJ6PT0fm_K00@06QXJ0=_Kf`0J6QX06QXJ0P3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P80fm_K00P06QXJ0=_Kf`3Kfm/0fm_K01XJ
6P3Kfm/06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX3
0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`806QXJ00<0fm_K
01XJ6P0J6QX00P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3K
fm/201XJ6P<0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ0P3K
fm_Z01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1701XJ6P80fm_K200J6QX00`3Kfm/06QXJ01XJ6P0=
0=_Kf`0301XJ6P3Kfm/0fm_K00T0fm_K00<06QXJ0=_Kf`3Kfm/0203Kfm/00`0J6QX0fm_K0=_Kf`0:
0=_Kf`0301XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/0203Kfm/0100J6QX0fm_K01XJ6P0J
6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0
fm_K00@06QXJ0=_Kf`0J6QX0fm_K0P0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/0
fm_K01XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J
6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K
0=_Kf`020=_Kf`806QXJ0`3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX0
6P0J6QX20=_KfnT06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ04P06QXJ00<0fm_K01XJ6P0J6QX01P0J
6QX00`3Kfm/06QXJ01XJ6P0=0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX01`3Kfm/301XJ6PP0fm_K
00<06QXJ0=_Kf`3Kfm/02P3Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K
00@06QXJ0=_Kf`0J6QX06QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ0`3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P3Kfm/06QXJ
0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/0
6QXJ0=_Kf`020=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ
00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P<0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ
6P030=_Kf`0J6QX06QXJ01/06QXJ00<0fm_K01XJ6P0J6QX0i`0J6QX002D06QXJ0P3Kfm]B01XJ6P03
0=_Kf`0J6QX06QXJ00T0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K
00D0fm_K0`0J6QX80=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0203Kfm/00`0J6QX0fm_K01XJ6P03
0=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K00@06QXJ0=_Kf`0J6QX06QXJ0P3Kfm/0100J6QX0fm_K0=_K
f`0J6QX30=_Kf`<06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/06QXJ0=_K
f`806QXJ00@0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`<06QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3K
fm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P<0fm_K
0P0J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P80fm_K700J6QX20=_KfnP06QXJ000U01XJ6P030=_Kf`0J
6QX06QXJ05406QXJ00<0fm_K01XJ6P0J6QX02@3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00<0fm_K
00<06QXJ0=_Kf`3Kfm/01@3Kfm/301XJ6PP0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P080=_Kf`03
01XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/0203Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`04
01XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00@06QXJ0=_K
f`3Kfm/0fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`040=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX00`3Kfm/06QXJ0=_K
f`020=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ
0`3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX0700J6QX20=_KfnL06QXJ
000U01XJ6P030=_Kf`0J6QX06QXJ05@06QXJ2@3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00<0fm_K
00<06QXJ0=_Kf`3Kfm/01@3Kfm/301XJ6PP0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P080=_Kf`03
01XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/0203Kfm/00`0J6QX0fm_K01XJ6P030=_Kf`04
01XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00@06QXJ0=_K
f`3Kfm/0fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`040=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K0`0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX0fm_K0080fm_K0P0J6QX00`3Kfm/06QXJ0=_K
f`020=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ
0`3Kfm/201XJ6P030=_Kf`0J6QX06QXJ03D06QXJ00<0fm_K01XJ6P0J6QX07P0J6QX00`3Kfm/06QXJ
01XJ6P3T01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1D01XJ6PT0fm_K00T06QXJ0=_Kf`3Kfm/0fm_K
01XJ6P3Kfm/06QXJ0=_Kf`0J6QX01`3Kfm/301XJ6PH0fm_K00L06QXJ0=_Kf`0J6QX0fm_K01XJ6P3K
fm/06QXJ00P0fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`080=_Kf`0301XJ6P3K
fm/06QXJ00<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/301XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0
103Kfm/0100J6QX0fm_K0=_Kf`3Kfm/201XJ6P030=_Kf`0J6QX0fm_K00@0fm_K00@06QXJ0=_Kf`3K
fm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ
6P030=_Kf`0J6QX0fm_K0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0
fm_K0080fm_K0P0J6QX30=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX00`3Kfm/06QXJ01XJ6P0N
01XJ6P80fm_Ki@0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0E00J6QX20=_Kf`806QXJ1@3Kfm/201XJ
6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P070=_Kf`<06QXJ1P3Kfm/01`0J6QX0fm_K01XJ6P3K
fm/06QXJ0=_Kf`0J6QX0203Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`0301XJ6P3Kfm/0fm_K00P0fm_K
00<06QXJ0=_Kf`0J6QX00`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ01XJ
6P<0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K0=_Kf`3Kfm/201XJ6P030=_Kf`0J6QX0
fm_K00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00806QXJ00<0
fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K
01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`806QXJ00<0fm_K01XJ6P0J6QX0
=@0J6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P80fm_Ki00J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0E@0J
6QX00`3Kfm/06QXJ01XJ6P050=_Kf`806QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ00L0fm_K
0`0J6QX60=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/00`0J6QX0fm_K
0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00h0fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/0100J6QX0fm_K
0=_Kf`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J
6QX0fm_K0=_Kf`3Kfm/201XJ6P030=_Kf`0J6QX0fm_K00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3K
fm/01P0J6QX0fm_K0=_Kf`3Kfm/06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/201XJ6P03
0=_Kf`0J6QX0fm_K0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K
0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX08@0J6QX00`3K
fm/06QXJ01XJ6P3Q01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1E01XJ6P030=_Kf`0J6QX06QXJ00D0
fm_K0P0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX01`3Kfm/301XJ6P80fm_K00<06QXJ0=_K
f`3Kfm/00P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`0301XJ6P3Kfm/0fm_K00h0fm_K00<06QXJ0=_Kf`0J6QX00`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX2
0=_Kf`0401XJ6P3Kfm/06QXJ01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K0=_K
f`3Kfm/201XJ6PL0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01P0J6QX0fm_K0=_Kf`3Kfm/06QXJ
0=_Kf`806QXJ1@3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ
6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0
fm_K01XJ6P0J6QX08@0J6QX00`3Kfm/06QXJ01XJ6P3Q01XJ6P009@0J6QX20=_KfeH06QXJ00<0fm_K
01XJ6P0J6QX01@3Kfm/201XJ6P80fm_K00T06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0J
6QX00`3Kfm/301XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/00P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P3K
fm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00d0fm_K00@06QXJ0=_Kf`3K
fm/06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00P3K
fm/00`0J6QX0fm_K0=_Kf`040=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ1`3Kfm/0100J6QX0fm_K
0=_Kf`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K0P0J6QX50=_Kf`806QXJ00<0fm_K01XJ6P3K
fm/00P3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ
6P<0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX20=_Kfb<06QXJ0P3Kfm_Q01XJ6P009@0J6QX00`3Kfm/0
6QXJ01XJ6P1E01XJ6P050=_Kf`0J6QX06QXJ0=_Kf`0J6QX00P3Kfm/301XJ6P80fm_K00H06QXJ0=_K
f`0J6QX0fm_K01XJ6P3Kfm/301XJ6P<0fm_K0`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00806QXJ0P3K
fm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_K
f`0=0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/01@0J6QX0
fm_K01XJ6P3Kfm/06QXJ0080fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K0=_Kf`3Kfm/2
01XJ6PL0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`806QXJ1@3K
fm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0
8`0J6QX00`3Kfm/06QXJ01XJ6P3O01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1E01XJ6P030=_Kf`0J
6QX06QXJ00806QXJ0P3Kfm/301XJ6P80fm_K00H06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/301XJ6P03
0=_Kf`0J6QX0fm_K00<06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6P80fm_K0P0J6QX00`3Kfm/0
6QXJ0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/03@3Kfm/0100J6QX0
fm_K0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ
6P020=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_K
f`050=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/201XJ6PD0fm_K
0P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0
fm_K0=_Kf`020=_Kf`806QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ02<0
6QXJ0P3Kfm_P01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1J01XJ6P80fm_K0`0J6QX20=_Kf`0601XJ
6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P80fm_K00<06QXJ0=_K
f`3Kfm/00P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`0301XJ6P3Kfm/0fm_K00d0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J
6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00P3Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/01@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`03
01XJ6P3Kfm/0fm_K00<0fm_K0P0J6QX50=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/01@0J6QX0
fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P<0fm_K00<06QXJ0=_K
f`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P0T01XJ6P80fm_Kg`0J6QX002D06QXJ00<0fm_K01XJ6P0J
6QX0G`0J6QX20=_Kf`0601XJ6P3Kfm/06QXJ0=_Kf`0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ0=_Kf`03
01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/00P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/0
0`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00d0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3K
fm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00P3Kfm/00`0J6QX0
fm_K0=_Kf`040=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/00`0J
6QX0fm_K0=_Kf`030=_Kf`806QXJ1@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/0
fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ0`3Kfm/00`0J6QX0fm_K0=_K
f`0g01XJ6P030=_Kf`0J6QX06QXJ02H06QXJ0P3Kfm_M01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1O
01XJ6P80fm_K00H06QXJ0=_Kf`0J6QX0fm_K01XJ6P3Kfm/301XJ6P030=_Kf`0J6QX0fm_K00<06QXJ
0P3Kfm/00`0J6QX0fm_K0=_Kf`0201XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`020=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/03@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`04
01XJ6P3Kfm/0fm_K01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P020=_Kf`0301XJ6P3Kfm/0
fm_K00@0fm_K00<06QXJ0=_Kf`3Kfm/02P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0301XJ6P3K
fm/0fm_K00<0fm_K0P0J6QX50=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0
fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K03L0
6QXJ00<0fm_K01XJ6P0J6QX09`0J6QX00`3Kfm/06QXJ01XJ6P3K01XJ6P004P0J6QX20=_Kf`@06QXJ
0P3Kfm/501XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P80fm_K00<06QXJ0=_Kf`0J6QX0
0P0J6QX01`3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/00`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K
00806QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J
6QX0fm_K0=_Kf`0=0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3K
fm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K00D0fm_K00<06QXJ0=_Kf`3Kfm/0
2P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K0P0J6QX50=_Kf`04
01XJ6P3Kfm/0fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0
fm_K0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K02<06QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX3
0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX09`0J6QX00`3Kfm/06QXJ01XJ6P3K01XJ6P004@0J6QX0103K
fm/06QXJ01XJ6P3Kfm/;01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0H00J6QX0
0`3Kfm/06QXJ0=_Kf`0301XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/01@0J6QX20=_Kf`0301XJ6P3K
fm/0fm_K00806QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/04P3K
fm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K00@06QXJ0=_Kf`0J
6QX0fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`050=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00@06QXJ0=_K
f`3Kfm/06QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`806QXJ1@3Kfm/0100J6QX0fm_K0=_Kf`0J
6QX30=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ
0`3Kfm/00`0J6QX0fm_K0=_Kf`0R01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`/06QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0X01XJ6P030=_Kf`0J6QX06QXJ0=X06QXJ000A01XJ6P040=_K
f`0J6QX06QXJ0=_Kf`P06QXJ1@3Kfm/301XJ6P<0fm_KH00J6QX00`3Kfm/06QXJ0=_Kf`0701XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/0
6QXJ0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K0180fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX20=_Kf`0401XJ6P3Kfm/06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/01@3K
fm/00`0J6QX0fm_K0=_Kf`0:0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0
0`3Kfm/201XJ6PD0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ
00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/08P0J6QX0103K
fm/06QXJ01XJ6P3Kfm/801XJ6PD0fm_K100J6QX20=_KfbT06QXJ00<0fm_K01XJ6P0J6QX0fP0J6QX0
01406QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/401XJ6P030=_Kf`0J
6QX06QXJ06006QXJ00<0fm_K01XJ6P3Kfm/01`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J
6QX06QXJ0080fm_K0P0J6QX20=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/00P3Kfm/00`0J6QX0fm_K0=_K
f`0B0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/0100J6QX0
fm_K01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K00D0fm_K00<06QXJ0=_Kf`3Kfm/02P3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K0P0J6QX50=_Kf`0401XJ6P3Kfm/0
fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K
0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K02806QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ02T06QXJ00<0fm_K01XJ6P0J6QX0f@0J6QX00140
6QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ0=_Kf`0401XJ6P030=_Kf`0J6QX06QXJ
06X06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ0P3Kfm/201XJ
6P030=_Kf`0J6QX0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/02`3Kfm/00`0J6QX0fm_K0=_Kf`040=_K
f`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/0100J6QX0fm_K01XJ
6P3Kfm/201XJ6P030=_Kf`0J6QX0fm_K0180fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/00`0J6QX0
fm_K0=_Kf`030=_Kf`806QXJ1@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/0fm_K
0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`0R
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P3Kfm/01@0J6QX00`3Kfm/06QXJ01XJ
6P0Y01XJ6P80fm_KfP0J6QX001806QXJ0P3Kfm/;01XJ6P80fm_K100J6QX00`3Kfm/06QXJ01XJ6P1Z
01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ0P3Kfm/201XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`02
0=_Kf`0301XJ6P3Kfm/0fm_K00/0fm_K00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K0=_Kf`0J
6QX30=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K00@06QXJ0=_Kf`0J6QX0fm_K0P0J6QX00`3Kfm/0
6QXJ0=_Kf`0E0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX01@3Kfm/201XJ6PD0fm_K00@06QXJ0=_K
f`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3K
fm/201XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/08`0J6QX20=_Kf`/06QXJ0P3Kfm/501XJ6P030=_Kf`0J
6QX06QXJ02X06QXJ0`3Kfm_H01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P1Z01XJ6P030=_Kf`0J6QX0
6QXJ00H06QXJ0P3Kfm/201XJ6P80fm_K100J6QX0103Kfm/06QXJ0=_Kf`0J6QX=0=_Kf`0301XJ6P3K
fm/06QXJ00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`04
01XJ6P3Kfm/0fm_K0=_Kf`806QXJ00<0fm_K01XJ6P3Kfm/05@3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/0
6QXJ00D0fm_K0P0J6QX50=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K
01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K0P0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ
00<0fm_K01XJ6P0J6QX0;00J6QX20=_KfmL06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ06X06QXJ00<0
fm_K01XJ6P0J6QX01P0J6QX20=_Kf`806QXJ0P3Kfm/401XJ6P040=_Kf`0J6QX0fm_K01XJ6Pd0fm_K
00<06QXJ0=_Kf`0J6QX0103Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K00<0
fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0P0J6QX00`3Kfm/06QXJ0=_Kf`0E0=_Kf`0501XJ6P3Kfm/0fm_K
0=_Kf`0J6QX01@3Kfm/201XJ6PD0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_K
f`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/0
=`0J6QX00`3Kfm/06QXJ01XJ6P0]01XJ6P80fm_KeP0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0JP0J
6QX00`3Kfm/06QXJ01XJ6P0601XJ6P80fm_K0P0J6QX20=_Kf`@06QXJ00@0fm_K01XJ6P3Kfm/06QXJ
3@3Kfm/00`0J6QX0fm_K01XJ6P040=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00<06QXJ0=_Kf`3K
fm/00`3Kfm/0100J6QX0fm_K0=_Kf`3Kfm/201XJ6QP0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P05
0=_Kf`806QXJ1@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0
103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ0`3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_K
f`0J6QX06QXJ02h06QXJ0P3Kfm_E01XJ6P009@0J6QX20=_Kff/06QXJ00<0fm_K01XJ6P0J6QX01P0J
6QX20=_Kf`806QXJ0P3Kfm/401XJ6P060=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ2`3Kfm/00`0J6QX0
fm_K01XJ6P040=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/0100J
6QX0fm_K0=_Kf`3Kfm/201XJ6QP0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P060=_Kf`0301XJ6P3K
fm/0fm_K00<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0
fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L0
6QXJ0P3Kfm/`01XJ6P030=_Kf`0J6QX06QXJ0=<06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ07<06QXJ
0P3Kfm/201XJ6P80fm_K100J6QX01P3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P/0fm_K00<06QXJ0=_K
f`0J6QX0103Kfm/0100J6QX0fm_K0=_Kf`0J6QX90=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ103K
fm/00`0J6QX0fm_K0=_Kf`0A0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0303Kfm/0100J6QX0fm_K
0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P0`01XJ
6P030=_Kf`0J6QX06QXJ0=806QXJ000U01XJ6P030=_Kf`0J6QX06QXJ07<06QXJ0P3Kfm/201XJ6P80
fm_K100J6QX01P3Kfm/06QXJ01XJ6P0J6QX0fm_K01XJ6P/0fm_K00<06QXJ0=_Kf`0J6QX0103Kfm/0
100J6QX0fm_K0=_Kf`0J6QX90=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`806QXJ103Kfm/00`0J6QX0fm_K
0=_Kf`0A0=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0303Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_K
f`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0
fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P0`01XJ6P80fm_Kd`0J6QX0
02D06QXJ00<0fm_K01XJ6P0J6QX0L`0J6QX20=_Kf`806QXJ0P3Kfm/401XJ6P060=_Kf`0J6QX06QXJ
01XJ6P3Kfm/06QXJ2`3Kfm/00`0J6QX0fm_K01XJ6P040=_Kf`0301XJ6P3Kfm/0fm_K00X0fm_K00@0
6QXJ0=_Kf`3Kfm/0fm_K0P0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K0140fm_K00D06QXJ0=_Kf`3Kfm/0
fm_K01XJ6P0<0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P<0fm_K00D06QXJ0=_Kf`3Kfm/0fm_K01XJ6P04
0=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0g
01XJ6P030=_Kf`0J6QX06QXJ03806QXJ00<0fm_K01XJ6P0J6QX0d00J6QX002D06QXJ00<0fm_K01XJ
6P0J6QX0L`0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`@06QXJ00H0fm_K01XJ6P0J6QX06QXJ0=_K
f`0J6QX;0=_Kf`0301XJ6P3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3Kfm/02P3Kfm/0100J6QX0fm_K
0=_Kf`3Kfm/301XJ6P<0fm_K00<06QXJ0=_Kf`3Kfm/04@3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ
00`0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<0
6QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0
fm_K01XJ6P0J6QX0<`0J6QX20=_Kfm006QXJ000U01XJ6P030=_Kf`0J6QX06QXJ07L06QXJ0P3Kfm/4
01XJ6P060=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ2`3Kfm/00`0J6QX0fm_K01XJ6P040=_Kf`0301XJ
6P3Kfm/0fm_K00X0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX30=_Kf`0301XJ6P3Kfm/0fm_K0280
fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ
0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K
01XJ6P0J6QX0=00J6QX30=_Kflh06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ07L06QXJ0P3Kfm/401XJ
6P060=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ103Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`<06QXJ103K
fm/00`0J6QX0fm_K0=_Kf`0:0=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`<06QXJ0P3Kfm/201XJ6R@0fm_K
00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_K
f`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ
6P0J6QX0=P0J6QX20=_Kfld06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ07L06QXJ0P3Kfm/401XJ6P06
0=_Kf`0J6QX06QXJ01XJ6P3Kfm/06QXJ103Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`<06QXJ103Kfm/0
0`0J6QX0fm_K0=_Kf`0:0=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`<06QXJ0P3Kfm/201XJ6R@0fm_K00@0
6QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_Kf`3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`3K
fm/00P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J
6QX0=`0J6QX20=_Kfl`06QXJ000U01XJ6P80fm_KN00J6QX20=_Kf`@06QXJ00H0fm_K01XJ6P0J6QX0
6QXJ0=_Kf`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K0`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K
00X0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX20=_Kf`806QXJ903Kfm/0100J6QX0fm_K0=_Kf`0J
6QX30=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX20=_KfcT06QXJ0P3Kfm_;01XJ6P009@0J
6QX00`3Kfm/06QXJ01XJ6P1g01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P3Kfm/00`3K
fm/00`0J6QX0fm_K0=_Kf`040=_Kf`<06QXJ103Kfm/201XJ6P/0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K
0`0J6QX20=_Kf`806QXJ903Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0501XJ6P3Kfm/0fm_K0=_K
f`0J6QX02@3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ
6P0J6QX0>@0J6QX00`3Kfm/06QXJ01XJ6P3901XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2301XJ6P05
0=_Kf`0J6QX0fm_K0=_Kf`0J6QX01P3Kfm/301XJ6P@0fm_K0P0J6QX;0=_Kf`0401XJ6P3Kfm/0fm_K
0=_Kf`<06QXJ0P3Kfm/301XJ6R<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0`3Kfm/01@0J6QX0fm_K0=_K
f`3Kfm/06QXJ00T0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_K
f`0J6QX06QXJ03T06QXJ0P3Kfm_:01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2301XJ6P050=_Kf`0J
6QX0fm_K0=_Kf`0J6QX01P3Kfm/301XJ6P@0fm_K0P0J6QX;0=_Kf`0401XJ6P3Kfm/0fm_K0=_Kf`<0
6QXJ0P3Kfm/301XJ6R<0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`020=_K
f`0301XJ6P3Kfm/0fm_K00L0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ
6P030=_Kf`0J6QX06QXJ03/06QXJ00<0fm_K01XJ6P0J6QX0a`0J6QX002D06QXJ00<0fm_K01XJ6P0J
6QX0Q@0J6QX20=_Kf`0501XJ6P3Kfm/0fm_K0=_Kf`0J6QX00P3Kfm/301XJ6P@0fm_K0P0J6QX50=_K
f`0301XJ6P3Kfm/06QXJ00<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX20=_Kf`<06QXJ8`3Kfm/0
100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0303K
fm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ03/06QXJ0P3Kfm_801XJ6P009@0J6QX0
0`3Kfm/06QXJ01XJ6P2501XJ6P80fm_K00H06QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/401XJ6P@0fm_K
0P0J6QX50=_Kf`0301XJ6P3Kfm/06QXJ00<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX20=_Kf`<0
6QXJ8`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_K
f`3Kfm/0303Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ03`06QXJ0P3Kfm_701XJ
6P009@0J6QX00`3Kfm/06QXJ01XJ6P2501XJ6P030=_Kf`0J6QX06QXJ00<0fm_K00<06QXJ0=_Kf`0J
6QX00`0J6QX40=_Kf`806QXJ1@3Kfm/301XJ6P<0fm_K00@06QXJ0=_Kf`3Kfm/0fm_K0`0J6QX20=_K
f`<06QXJ8`3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ
0=_Kf`3Kfm/0303Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ03d06QXJ0P3Kfm_6
01XJ6P009@0J6QX20=_KfhH06QXJ00<0fm_K01XJ6P0J6QX00`3Kfm/00`0J6QX0fm_K01XJ6P0301XJ
6P@0fm_K0P0J6QX50=_Kf`<06QXJ00@0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/301XJ6P80fm_K0`0J6QX5
0=_Kf`0301XJ6P3Kfm/0fm_K01/0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_K
f`020=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX20=_Kfcl06QXJ0P3K
fm_501XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2801XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0100J6QX2
0=_Kf`<06QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P0201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K0`0J
6QX20=_Kf`<06QXJ1@3Kfm/00`0J6QX0fm_K0=_Kf`0K0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K
00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_Kf`0<0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ
00<0fm_K01XJ6P0J6QX0@00J6QX00`3Kfm/06QXJ01XJ6P3201XJ6P009@0J6QX00`3Kfm/06QXJ01XJ
6P2801XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0100J6QX20=_Kf`<06QXJ0`3Kfm/00`0J6QX0fm_K01XJ
6P0201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K0`0J6QX20=_Kf`<06QXJ1@3Kfm/00`0J6QX0fm_K
0=_Kf`0N0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/0303Kfm/00`0J6QX0
fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ04006QXJ0P3Kfm_301XJ6P009@0J6QX00`3Kfm/06QXJ
01XJ6P2901XJ6P80fm_K00<06QXJ0=_Kf`0J6QX0100J6QX20=_Kf`<06QXJ0`3Kfm/00`0J6QX0fm_K
01XJ6P0201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K0`0J6QX20=_Kf`<06QXJ0`3Kfm/00`0J6QX0
fm_K01XJ6P0P0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/0303Kfm/00`0J
6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ04806QXJ00<0fm_K01XJ6P0J6QX0`00J6QX002D0
6QXJ00<0fm_K01XJ6P0J6QX0S00J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P0201XJ6P040=_Kf`0J6QX0fm_K01XJ6P<0fm_K0`0J6QX00`3K
fm/06QXJ01XJ6P0201XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX0803Kfm/0100J6QX0fm_K0=_Kf`0J6QX4
0=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P12
01XJ6P80fm_K`@0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0TP0J6QX00`3Kfm/06QXJ01XJ6P0201XJ
6P<0fm_K00<06QXJ0=_Kf`0J6QX00P0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`<06QXJ00<0fm_K
01XJ6P0J6QX00P0J6QX30=_Kf`0301XJ6P3Kfm/06QXJ0200fm_K00@06QXJ0=_Kf`3Kfm/06QXJ103K
fm/00`0J6QX0fm_K0=_Kf`0<0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0@`0J
6QX20=_Kfl006QXJ000B01XJ6P80fm_K100J6QX20=_Kf`<06QXJ0`3Kfm/501XJ6P030=_Kf`0J6QX0
6QXJ09806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00806QXJ00@0fm_K
01XJ6P3Kfm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/00`0J6QX0fm_K01XJ
6P0P0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P@0fm_K00<06QXJ0=_Kf`3Kfm/0303Kfm/00`0J6QX0fm_K
0=_Kf`0S01XJ6P80fm_K100J6QX20=_Kf`<06QXJ0`3Kfm/601XJ6P030=_Kf`0J6QX06QXJ04@06QXJ
0`3Kfm^n01XJ6P004@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@0
6QXJ00<0fm_K01XJ6P0J6QX0TP0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P80fm_K00<06QXJ0=_Kf`0J
6QX00P0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_K
f`0301XJ6P3Kfm/06QXJ00D0fm_K00<06QXJ0=_Kf`3Kfm/0603Kfm/0100J6QX0fm_K0=_Kf`0J6QX4
0=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/08P0J6QX0103Kfm/06QXJ01XJ6P3K
fm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX0AP0J6QX20=_Kfkd06QXJ
000A01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX30=_Kfi80
6QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00806QXJ00@0fm_K01XJ6P3K
fm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/00`0J6QX0fm_K01XJ6P050=_K
f`0301XJ6P3Kfm/0fm_K01P0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ103Kfm/00`0J6QX0fm_K0=_Kf`0<
0=_Kf`0301XJ6P3Kfm/0fm_K02806QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ
6P3Kfm/501XJ6P80fm_KB@0J6QX20=_Kfk/06QXJ000A01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ
0`3Kfm/501XJ6P030=_Kf`0J6QX06QXJ09806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX20=_Kf`D06QXJ
00@0fm_K01XJ6P3Kfm/06QXJ0`3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/00`0J6QX0
fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6Q@0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX40=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/08P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/801XJ6P<0fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P1901XJ6P030=_Kf`0J
6QX06QXJ0;T06QXJ000A01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P80fm_K1@0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_Kf`<06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX30=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00@06QXJ0=_Kf`3Kfm/0
6QXJ503Kfm/00`0J6QX0fm_K0=_Kf`060=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3K
fm/0303Kfm/00`0J6QX0fm_K0=_Kf`0R01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ
6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P1:01XJ6P80fm_K^@0J6QX001806QXJ0P3Kfm/:01XJ6P<0
fm_K100J6QX00`3Kfm/06QXJ01XJ6P2H01XJ6P80fm_K1@0J6QX0103Kfm/06QXJ0=_Kf`0J6QX30=_K
f`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00@06QXJ0=_K
f`3Kfm/06QXJ503Kfm/00`0J6QX0fm_K0=_Kf`060=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ
0=_Kf`3Kfm/0303Kfm/00`0J6QX0fm_K0=_Kf`0S01XJ6P80fm_K2P0J6QX30=_Kf`D06QXJ00<0fm_K
01XJ6P0J6QX0B`0J6QX20=_KfkP06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ09P06QXJ0P3Kfm/501XJ
6P040=_Kf`0J6QX06QXJ01XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P<0fm_K00<06QXJ
0=_Kf`0J6QX00P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00l0fm_K00<0
6QXJ0=_Kf`3Kfm/01P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3Kfm/0fm_K00`0fm_K00<0
6QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P1<01XJ6P<0fm_K]P0J6QX002D06QXJ00<0fm_K
01XJ6P0J6QX0V00J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P02
01XJ6P<0fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3K
fm/0fm_K00l0fm_K00<06QXJ0=_Kf`3Kfm/01P3Kfm/00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P3K
fm/0fm_K00`0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P1>01XJ6P80fm_K]@0J
6QX002D06QXJ00<0fm_K01XJ6P0J6QX0X`0J6QX30=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX3
0=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_K
f`0?0=_Kf`0301XJ6P3Kfm/0fm_K00H0fm_K00<06QXJ0=_Kf`3Kfm/00P3Kfm/00`0J6QX0fm_K0=_K
f`0<0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0C`0J6QX20=_Kfk@06QXJ000U
01XJ6P80fm_KY00J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/0
0`0J6QX0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/03`3K
fm/00`0J6QX0fm_K0=_Kf`060=_Kf`0301XJ6P3Kfm/0fm_K0080fm_K00<06QXJ0=_Kf`3Kfm/0303K
fm/00`0J6QX0fm_K0=_Kf`0g01XJ6P80fm_KDP0J6QX00`3Kfm/06QXJ01XJ6P2a01XJ6P009@0J6QX0
0`3Kfm/06QXJ01XJ6P2S01XJ6P030=_Kf`0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX3
0=_Kf`0301XJ6P3Kfm/06QXJ0080fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/00`0J6QX0fm_K0=_K
f`0=0=_Kf`0301XJ6P3Kfm/06QXJ00P0fm_K00<06QXJ0=_Kf`3Kfm/04@3Kfm/00`0J6QX0fm_K0=_K
f`0g01XJ6P030=_Kf`0J6QX06QXJ05406QXJ0P3Kfm^b01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2S
01XJ6P030=_Kf`0J6QX0fm_K00<06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_Kf`<06QXJ0P3Kfm/0
100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00d0fm_K00<06QXJ0=_Kf`0J6QX0203K
fm/00`0J6QX0fm_K0=_Kf`0A0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0DP0J
6QX20=_Kfk406QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0:T06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX3
0=_Kf`<06QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00T0fm_K00L0
6QXJ0=_Kf`3Kfm/0fm_K01XJ6P3Kfm/06QXJ00P0fm_K00<06QXJ0=_Kf`3Kfm/04@3Kfm/00`0J6QX0
fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ05<06QXJ0P3Kfm^`01XJ6P009@0J6QX00`3Kfm/06QXJ
01XJ6P2Y01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0`3Kfm/301XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/0
6QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`090=_Kf`0701XJ6P3Kfm/0fm_K0=_Kf`0J6QX0fm_K01XJ6P08
0=_Kf`0301XJ6P3Kfm/0fm_K0140fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P1D
01XJ6P<0fm_K[P0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0[P0J6QX30=_Kf`<06QXJ0P3Kfm/0100J
6QX0fm_K0=_Kf`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K00T0fm_K00L06QXJ0=_Kf`3Kfm/0fm_K01XJ
6P3Kfm/06QXJ00P0fm_K00<06QXJ0=_Kf`3Kfm/04@3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_K
f`0J6QX06QXJ05H06QXJ1@3Kfm^Z01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2^01XJ6P<0fm_K0`0J
6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K00<06QXJ0=_Kf`3Kfm/02@3Kfm/01`0J6QX0fm_K
0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX01P3Kfm/00`0J6QX0fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0fm_K
03L06QXJ00<0fm_K01XJ6P0J6QX0FP0J6QX30=_KfjP06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0:h0
6QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX01@3Kfm/06QXJ0=_Kf`3Kfm/06QXJ00L0fm_K00D06QXJ0=_K
f`3Kfm/0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/06QXJ00H0fm_K00<06QXJ0=_Kf`0J6QX04`3Kfm/0
0`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ05`06QXJ0P3Kfm^W01XJ6P009@0J6QX20=_K
fjl06QXJ0`3Kfm/301XJ6P80fm_K0P0J6QX01@3Kfm/06QXJ0=_Kf`3Kfm/06QXJ00@0fm_K00@06QXJ
0=_Kf`3Kfm/06QXJ0`3Kfm/01`0J6QX0fm_K0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX01P3Kfm/00`0J6QX0
fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ0P3Kfm]O01XJ6P80fm_KY@0J6QX002D06QXJ
00<0fm_K01XJ6P0J6QX0[P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P050=_Kf`0J6QX0fm_K0=_Kf`0J
6QX0103Kfm/0100J6QX0fm_K0=_Kf`0J6QX30=_Kf`0901XJ6P3Kfm/0fm_K0=_Kf`0J6QX0fm_K01XJ
6P3Kfm/06QXJ00@0fm_K00<06QXJ0=_Kf`0J6QX04`3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_K
f`0J6QX06QXJ06006QXJ0`3Kfm^R01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2^01XJ6P<0fm_K0`0J
6QX20=_Kf`806QXJ00L0fm_K01XJ6P3Kfm/0fm_K01XJ6P3Kfm/06QXJ0080fm_K00@06QXJ0=_Kf`3K
fm/06QXJ0`3Kfm/02@0J6QX0fm_K0=_Kf`3Kfm/06QXJ0=_Kf`0J6QX0fm_K01XJ6P040=_Kf`0301XJ
6P3Kfm/06QXJ01<0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ01XJ6P1R01XJ6P<0fm_K
X00J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0[P0J6QX30=_Kf`<06QXJ0P3Kfm/201XJ6P070=_Kf`0J
6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K0P0J6QX30=_K
f`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX0103Kfm/00`0J6QX0fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0
fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0I00J6QX50=_Kfi`06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ
0:h06QXJ0`3Kfm/701XJ6P070=_Kf`0J6QX0fm_K0=_Kf`0J6QX0fm_K01XJ6P020=_Kf`0401XJ6P3K
fm/0fm_K01XJ6P80fm_K0P0J6QX30=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX0103Kfm/00`0J6QX0
fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0J00J6QX20=_Kfi/0
6QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0:l06QXJ0P3Kfm/701XJ6P070=_Kf`0J6QX0fm_K0=_Kf`0J
6QX0fm_K01XJ6P020=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K0`0J6QX20=_Kf`0501XJ6P3Kfm/0
6QXJ0=_Kf`0J6QX00P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ01<0fm_K00<06QXJ0=_Kf`3Kfm/0
=`0J6QX00`3Kfm/06QXJ01XJ6P1Y01XJ6PD0fm_KU`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0/00J
6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K00<06QXJ0=_Kf`0J6QX00P3Kfm/0100J6QX0fm_K0=_K
f`0J6QX20=_Kf`<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ0080fm_K00D06QXJ0=_Kf`0J
6QX0fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0K@0J6QX20=_K
fiH06QXJ000U01XJ6P80fm_K/@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P80fm_K00<06QXJ0=_Kf`0J
6QX00P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/0
6QXJ0080fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P0C0=_Kf`0301XJ6P3Kfm/0fm_K03L06QXJ0P3K
fm]_01XJ6P80fm_KU@0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0^P0J6QX20=_Kf`0301XJ6P3Kfm/0
6QXJ0080fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/401XJ6P060=_Kf`0J6QX0fm_K01XJ6P3Kfm/0
6QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ00d0fm_K00<06QXJ0=_Kf`3Kfm/00`3Kfm/00`0J
6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ07006QXJ0`3Kfm^B01XJ6P009@0J6QX00`3Kfm/0
6QXJ01XJ6P2k01XJ6P040=_Kf`0J6QX0fm_K01XJ6P80fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/4
01XJ6P060=_Kf`0J6QX0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ00<0
fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`0301XJ6P3Kfm/0fm_K03L0
6QXJ00<0fm_K01XJ6P0J6QX0LP0J6QX30=_Kfi006QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0;/06QXJ
00@0fm_K01XJ6P3Kfm/06QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`0J6QX20=_Kf`@06QXJ00H0fm_K01XJ
6P3Kfm/06QXJ0=_Kf`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K
0=_Kf`070=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_Kf`3Kfm/0=`0J6QX00`3Kfm/06QXJ
01XJ6P1d01XJ6P80fm_KS`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0^`0J6QX0103Kfm/06QXJ0=_K
f`0J6QX20=_Kf`0401XJ6P3Kfm/0fm_K01XJ6P80fm_K100J6QX01P3Kfm/06QXJ0=_Kf`0J6QX0fm_K
01XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00L0fm_K00<0
6QXJ0=_Kf`3Kfm/00`3Kfm/00`0J6QX0fm_K0=_Kf`0g01XJ6P030=_Kf`0J6QX06QXJ07D06QXJ0`3K
fm^=01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P2k01XJ6P040=_Kf`0J6QX06QXJ01XJ6P80fm_K00@0
6QXJ0=_Kf`3Kfm/06QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX0fm_K00<06QXJ0P3Kfm/01@0J6QX0fm_K
01XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/01`3Kfm/00`0J6QX0fm_K0=_Kf`030=_Kf`03
01XJ6P3Kfm/0fm_K03L06QXJ00<0fm_K01XJ6P0J6QX0M`0J6QX20=_Kfh`06QXJ000B01XJ6P80fm_K
100J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ0;l06QXJ0P3Kfm/0100J6QX0fm_K
0=_Kf`0J6QX20=_Kf`@06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_K
f`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`070=_Kf`0301XJ6P3Kfm/0fm_K00<0fm_K00<06QXJ0=_K
f`3Kfm/08`0J6QX20=_Kf`@06QXJ0P3Kfm/401XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P1h01XJ
6P80fm_KR`0J6QX001406QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/4
01XJ6P030=_Kf`0J6QX06QXJ0<806QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0401XJ6P030=_Kf`0J6QX0
fm_K00<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P3Kfm/06QXJ00<0fm_K00<06QXJ0=_Kf`3Kfm/01`3K
fm/00`0J6QX0fm_K0=_Kf`030=_Kf`0301XJ6P3Kfm/0fm_K02806QXJ00@0fm_K01XJ6P0J6QX0fm_K
200J6QX0103Kfm/06QXJ01XJ6P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ07T06QXJ1@3Kfm^701XJ6P00
4@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ0`3Kfm_201XJ
6P80fm_K00<06QXJ0=_Kf`3Kfm/0100J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P80fm_K00D06QXJ0=_K
f`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1@3K
fm/00`0J6QX0fm_K0=_Kf`0R01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0
fm_K1@0J6QX20=_Kfgh06QXJ0`3Kfm^501XJ6P004@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P80
fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P3301XJ6P040=_Kf`0J6QX0fm_K0=_Kf`@06QXJ00<0fm_K01XJ
6P3Kfm/00`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`04
0=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PD0fm_K00<06QXJ0=_Kf`3Kfm/08P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/901XJ6P80fm_K1P0J6QX00`3Kfm/06QXJ01XJ6P1o01XJ6P<0fm_KP`0J6QX001406QXJ00@0
fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ0<<0
6QXJ00@0fm_K01XJ6P3Kfm/0fm_K100J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P80fm_K00D06QXJ0=_K
f`0J6QX0fm_K01XJ6P030=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1@3K
fm/00`0J6QX0fm_K0=_Kf`0R01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0
fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P2201XJ6P<0fm_KP00J6QX001806QXJ0P3Kfm/:01XJ6P80fm_K
1@0J6QX00`3Kfm/06QXJ01XJ6P3301XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P3K
fm/00`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`040=_K
f`0401XJ6P3Kfm/0fm_K01XJ6PD0fm_K00<06QXJ0=_Kf`0J6QX08`0J6QX20=_Kf`X06QXJ0P3Kfm/6
01XJ6P030=_Kf`0J6QX06QXJ08@06QXJ0P3Kfm]o01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P3601XJ
6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX20=_Kf`0501XJ6P3Kfm/06QXJ
0=_Kf`0J6QX00`3Kfm/00`0J6QX0fm_K0=_Kf`040=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PD0fm_K00<0
6QXJ0=_Kf`0J6QX0=`0J6QX00`3Kfm/06QXJ01XJ6P2501XJ6P<0fm_KO@0J6QX002D06QXJ00<0fm_K
01XJ6P0J6QX0b`0J6QX00`3Kfm/06QXJ0=_Kf`0301XJ6P80fm_K00D06QXJ0=_Kf`0J6QX0fm_K01XJ
6P030=_Kf`0301XJ6P3Kfm/0fm_K00@0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1@3Kfm/00`0J6QX0fm_K
01XJ6P0g01XJ6P030=_Kf`0J6QX06QXJ08P06QXJ0`3Kfm]j01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ
6P3;01XJ6P030=_Kf`0J6QX0fm_K00<06QXJ0P3Kfm/0100J6QX0fm_K01XJ6P3Kfm/201XJ6P80fm_K
00<06QXJ0=_Kf`3Kfm/0103Kfm/0100J6QX0fm_K0=_Kf`0J6QX50=_Kf`0301XJ6P3Kfm/06QXJ03L0
6QXJ00<0fm_K01XJ6P0J6QX0RP0J6QX50=_KfgH06QXJ000U01XJ6P80fm_Kc00J6QX00`3Kfm/06QXJ
0=_Kf`0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00`0J6QX00`3Kfm/06QXJ01XJ6P050=_Kf`04
01XJ6P3Kfm/0fm_K01XJ6PD0fm_K00<06QXJ0=_Kf`0J6QX0=`0J6QX20=_Kfhl06QXJ1@3Kfm]b01XJ
6P009@0J6QX00`3Kfm/06QXJ01XJ6P3;01XJ6P030=_Kf`0J6QX0fm_K00@06QXJ00D0fm_K01XJ6P0J
6QX06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX06QXJ00D0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1`3Kfm/h
01XJ6P030=_Kf`0J6QX06QXJ09806QXJ0`3Kfm]`01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P3=01XJ
6P030=_Kf`0J6QX06QXJ00806QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0301XJ6P030=_Kf`0J6QX0
6QXJ00D0fm_K00@06QXJ0=_Kf`3Kfm/06QXJ1`3Kfm/h01XJ6P030=_Kf`0J6QX06QXJ09@06QXJ0`3K
fm]^01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P3B01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00`0J
6QX00`3Kfm/06QXJ01XJ6P050=_Kf`0401XJ6P3Kfm/0fm_K01XJ6PL0fm_K>00J6QX00`3Kfm/06QXJ
01XJ6P2F01XJ6P@0fm_KJ`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0dP0J6QX01@3Kfm/06QXJ01XJ
6P0J6QX0fm_K00H06QXJ1@3Kfm/0100J6QX0fm_K0=_Kf`0J6QX70=_KfcP06QXJ00<0fm_K01XJ6P0J
6QX0VP0J6QX20=_KffT06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0=H06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX50=_Kf`0401XJ6P3Kfm/06QXJ01XJ6PL0fm_K>00J6QX00`3Kfm/06QXJ01XJ6P2L01XJ6P03
0=_Kf`0J6QX06QXJ06H06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0=d06QXJ1@3Kfm/0100J6QX0fm_K
01XJ6P0J6QX70=_KfcP06QXJ00<0fm_K01XJ6P0J6QX0W@0J6QX50=_Kff<06QXJ000U01XJ6P030=_K
f`0J6QX06QXJ0=d06QXJ1@3Kfm/0100J6QX0fm_K01XJ6P0J6QX70=_KfcP06QXJ00<0fm_K01XJ6P0J
6QX0X@0J6QX60=_Kfeh06QXJ000U01XJ6P80fm_KgP0J6QX50=_Kf`0401XJ6P3Kfm/06QXJ01XJ6PL0
fm_K>00J6QX20=_KfjP06QXJ103Kfm]J01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P3M01XJ6PD0fm_K
00@06QXJ0=_Kf`0J6QX06QXJ1`3Kfm/h01XJ6P030=_Kf`0J6QX06QXJ0:X06QXJ103Kfm]G01XJ6P00
9@0J6QX00`3Kfm/06QXJ01XJ6P3M01XJ6PD0fm_K100J6QX70=_KfcP06QXJ00<0fm_K01XJ6P0J6QX0
[@0J6QX20=_KfeH06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0=d06QXJ1@3Kfm/401XJ6PL0fm_K>00J
6QX00`3Kfm/06QXJ01XJ6P2^01XJ6P@0fm_KD`0J6QX002D06QXJ00<0fm_K01XJ6P0J6QX0g@0J6QX2
0=_Kf`L06QXJ1`3Kfm/h01XJ6P030=_Kf`0J6QX06QXJ0;406QXJ1@3Kfm]?01XJ6P009@0J6QX00`3K
fm/06QXJ01XJ6P3V01XJ6PL0fm_K>00J6QX00`3Kfm/06QXJ01XJ6P2e01XJ6PH0fm_KBP0J6QX002D0
6QXJ00<0fm_K01XJ6P0J6QX0iP0J6QX70=_KfcP06QXJ00<0fm_K01XJ6P0J6QX0^P0J6QX30=_KfdP0
6QXJ000U01XJ6P80fm_Kj00J6QX60=_KfcP06QXJ0P3Kfm^m01XJ6PH0fm_K@`0J6QX002D06QXJ00<0
fm_K01XJ6P0J6QX0i`0J6QX60=_KfcP06QXJ00<0fm_K01XJ6P0J6QX0`@0J6QX70=_Kfcd06QXJ000U
01XJ6P030=_Kf`0J6QX06QXJ0>L06QXJ0P3Kfm/0100J6QX0fm_K0=_Kf`3Kfm/h01XJ6P030=_Kf`0J
6QX06QXJ0<L06QXJ1P3Kfm/h01XJ6P009@0J6QX00`3Kfm/06QXJ01XJ6P3X01XJ6P030=_Kf`0J6QX0
fm_K0080fm_K>00J6QX00`3Kfm/06QXJ01XJ6P3<01XJ6P80fm_K=`0J6QX002D06QXJ00<0fm_K01XJ
6P0J6QX0j00J6QX00`3Kfm/06QXJ0=_Kf`020=_KfcP06QXJ00<0fm_K01XJ6P0J6QX0c@0J6QX90=_K
fbl06QXJ000U01XJ6P030=_Kf`0J6QX06QXJ0>X06QXJ0`3Kfm/h01XJ6P030=_Kf`0J6QX06QXJ0=D0
6QXJ1`3Kfm/Y01XJ6P007@0J6QX50=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0j`0J6QX20=_Kfbl06QXJ
1@3Kfm/401XJ6P030=_Kf`0J6QX06QXJ0=`06QXJ203Kfm/Q01XJ6P007`0J6QX00`3Kfm/06QXJ01XJ
6P0301XJ6P030=_Kf`0J6QX06QXJ0?l06QXJ7`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030=_Kf`0J
6QX06QXJ0><06QXJ2@3Kfm/I01XJ6P007`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P<0fm_Ko`0J6QXO
01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ0P3Kfm_/01XJ6PD0fm_K5@0J6QX001l06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6Ql06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3K
fm/06QXJ01XJ6P3o01XJ6PH06QXJ000O01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J
6QX0o`0J6QXO01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX0o`0J6QX601XJ6P00
7P0J6QX20=_Kfol06QXJ9P0J6QX20=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0o`0J6QX601XJ6P00o`0J
6QY>01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJ1P0J6QX00?l06QXJo`0J6QYG01XJ6P00o`0J6Q[o01XJ
6UL06QXJ003o01XJ6_l06QXJE`0J6QX00?l06QXJo`0J6QYG01XJ6P00\
\>"],
  ImageRangeCache->{{{65.8125, 542.938}, {237.063, 97.375}} -> {-0.346683, \
0.41611, 0.00353954, 0.00353954}, {{78.3125, 293.563}, {233.688, 100.688}} -> \
{-364.315, 0.704235, 3.03256, 0.00668419}, {{315.125, 530.375}, {233.688, \
100.688}} -> {-1252.67, 0.704189, 3.01614, 0.00668513}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parametric estimate K\[Phi]", "Subsection"],

Cell[BoxData[{
    FormBox[
      RowBox[{\(\(K\_\[Phi]\) \((z)\)\), "=", 
        RowBox[{
          RowBox[{"z", "-", 
            RowBox[{
              FractionBox[\(\[Phi](z)\), 
                RowBox[{
                  SuperscriptBox["\[Phi]", "\[Prime]",
                    MultilineFunction->None], "(", "z", ")"}]], "        ", 
              "using", " ", "relation", "     ", "\[Tau]"}]}], 
          "=", \(1 + \ 
            4 \(\[Integral]\_0\%1\(\( \[Phi](
                        t)\)\/\(\[Phi]' \((t)\)\)\) \[DifferentialD]t\)\)}]}],
       TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(Procedure : \ \[Tau]\  \[Rule] \ \(\[Theta]\  \[Rule] \ \
\(\[Phi]\  \[Rule] \ \(\(K\_\[Phi]\)\(.\)\)\)\)\), 
      TraditionalForm]}], "DisplayFormula"],

Cell[CellGroupData[{

Cell["Independence copula", "Subsubsection",
  CellDingbat->"\[EmptySmallSquare]"],

Cell[BoxData[{
    \(\(fKi[t_] := 
        If[t \[NotEqual] 0, t\ \((1 - \ Log[t])\), 
          0];\)\), "\[IndentingNewLine]", 
    \(\(Ki = Table[fKi[z], {z, 0, 1, 1/n}];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gumbel copula", "Subsubsection",
  CellDingbat->"\[EmptySmallSquare]"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(NSolve[\[Tau] == \((t - 1)\)/t];\)\), "\[IndentingNewLine]", 
    \(\[Theta]g = 
      t /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)}], "Input"],

Cell[BoxData[
    \(1.302423713003953`\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(fKg[t_] := 
        If[t \[NotEqual] 0, t - t\ Log[t]/\[Theta]g, 
          0];\)\), "\[IndentingNewLine]", 
    \(\(Kg = Table[fKg[z], {z, 0, 1, 1/n}];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clayton copula", "Subsubsection",
  CellDingbat->"\[EmptySmallSquare]"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(NSolve[\[Tau] \[Equal] t/\((t + 2)\)];\)\), "\[IndentingNewLine]", 
    \(\[Theta]c = 
      t /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)}], "Input"],

Cell[BoxData[
    \(0.6048474260079063`\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(fKc[t_] := 
        t - \((t\^\(\[Theta]c + 1\) - 
                t)\)/\[Theta]c;\)\), "\[IndentingNewLine]", 
    \(\(Kc = Table[fKc[z], {z, 0, 1, 1/n}];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frank copula", "Subsubsection",
  CellDingbat->"\[EmptySmallSquare]"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"fD", 
              StyleBox["1",
                FontSize->9]}]], "[", "x_", "]"}], 
        ":=", \(1/x\ Integrate[t/\((Exp[t] - 1)\), {t, 0, x}]\)}], 
      ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"FindRoot", "[", 
        RowBox[{
          RowBox[{"\[Tau]", "\[Equal]", 
            RowBox[{"1", "+", 
              RowBox[{\(4/t\), " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        RowBox[{"fD", 
                          StyleBox["1",
                            FontSize->9]}]], "[", "t", "]"}], "-", "1"}], 
                  ")"}]}]}]}], ",", \({t, 2.2}\)}], "]"}], 
      ";"}], "\[IndentingNewLine]", \(\[Theta]f = Re[t /. %]\)}], "Input"],

Cell[BoxData[
    \(2.1865668664414395`\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(fKf[t_] := 
      If[t \[Equal] 0, 0, 
        t - Log[\((Exp[\(-\[Theta]f\)\ t] - 1)\)/\((Exp[\(-\[Theta]f\)] - 
                    1)\)]*\((Exp[\[Theta]f\ t] - 
                  1)\)/\[Theta]f]\), "\[IndentingNewLine]", 
    \(\(Kf = Table[fKf[z], {z, 0, 1, 1/n}];\)\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparing K's", "Subsection"],

Cell[CellGroupData[{

Cell["Graphically", "Subsubsection",
  CellDingbat->"\[EmptySmallSquare]"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"GraphicsArray", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{"Show", "[", "\[IndentingNewLine]", 
                RowBox[{\(ListPlot[Kn]\), ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox["Ki",
                        FontColor->RGBColor[1, 0.588235, 0]], 
                      ",", \(PlotStyle \[Rule] RGBColor[1, 0.5, 0]\)}], "]"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox["Kg",
                        FontColor->RGBColor[0, 0.588235, 1]], 
                      ",", \(PlotStyle \[Rule] RGBColor[0, 0.5, 1]\)}], "]"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox["Kc",
                        FontColor->RGBColor[0, 1, 0]], 
                      ",", \(PlotStyle \[Rule] RGBColor[0, 1, 0]\)}], "]"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox["Kf",
                        FontColor->RGBColor[1, 0, 1]], 
                      ",", \(PlotStyle \[Rule] RGBColor[1, 0, 1]\)}], "]"}]}],
                 "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
              RowBox[{"Show", "[", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox[\(Ki - Kn\),
                        FontColor->RGBColor[1, 0.588235, 0]], 
                      ",", \(PlotStyle \[Rule] RGBColor[1, 0.5, 0]\)}], "]"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox[\(Kg - Kn\),
                        FontColor->RGBColor[0, 0.588235, 1]], 
                      ",", \(PlotStyle \[Rule] RGBColor[0, 0.5, 1]\)}], "]"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox[\(Kc - Kn\),
                        FontColor->RGBColor[0, 1, 0]], 
                      ",", \(PlotStyle \[Rule] RGBColor[0, 1, 0]\)}], "]"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"ListPlot", "[", 
                    RowBox[{
                      StyleBox[\(Kf - Kn\),
                        FontColor->RGBColor[1, 0, 1]], 
                      ",", \(PlotStyle \[Rule] RGBColor[1, 0, 1]\)}], "]"}]}],
                 "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], "//", 
        "fShow"}], ";"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224995 0.00131002 0.0147151 0.588604 [
[.1535 .00222 -9 -9 ]
[.1535 .00222 9 0 ]
[.2845 .00222 -9 -9 ]
[.2845 .00222 9 0 ]
[.4155 .00222 -9 -9 ]
[.4155 .00222 9 0 ]
[.54651 .00222 -9 -9 ]
[.54651 .00222 9 0 ]
[.67751 .00222 -9 -9 ]
[.67751 .00222 9 0 ]
[.80851 .00222 -9 -9 ]
[.80851 .00222 9 0 ]
[.93951 .00222 -9 -9 ]
[.93951 .00222 9 0 ]
[.01 .13244 -18 -4.5 ]
[.01 .13244 0 4.5 ]
[.01 .25016 -18 -4.5 ]
[.01 .25016 0 4.5 ]
[.01 .36788 -18 -4.5 ]
[.01 .36788 0 4.5 ]
[.01 .4856 -18 -4.5 ]
[.01 .4856 0 4.5 ]
[.01 .60332 -6 -4.5 ]
[.01 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1535 .01472 m
.1535 .02097 L
s
[(100)] .1535 .00222 0 1 Mshowa
.2845 .01472 m
.2845 .02097 L
s
[(200)] .2845 .00222 0 1 Mshowa
.4155 .01472 m
.4155 .02097 L
s
[(300)] .4155 .00222 0 1 Mshowa
.54651 .01472 m
.54651 .02097 L
s
[(400)] .54651 .00222 0 1 Mshowa
.67751 .01472 m
.67751 .02097 L
s
[(500)] .67751 .00222 0 1 Mshowa
.80851 .01472 m
.80851 .02097 L
s
[(600)] .80851 .00222 0 1 Mshowa
.93951 .01472 m
.93951 .02097 L
s
[(700)] .93951 .00222 0 1 Mshowa
.125 Mabswid
.0487 .01472 m
.0487 .01847 L
s
.0749 .01472 m
.0749 .01847 L
s
.1011 .01472 m
.1011 .01847 L
s
.1273 .01472 m
.1273 .01847 L
s
.1797 .01472 m
.1797 .01847 L
s
.2059 .01472 m
.2059 .01847 L
s
.2321 .01472 m
.2321 .01847 L
s
.2583 .01472 m
.2583 .01847 L
s
.3107 .01472 m
.3107 .01847 L
s
.3369 .01472 m
.3369 .01847 L
s
.3631 .01472 m
.3631 .01847 L
s
.3893 .01472 m
.3893 .01847 L
s
.4417 .01472 m
.4417 .01847 L
s
.4679 .01472 m
.4679 .01847 L
s
.4941 .01472 m
.4941 .01847 L
s
.52031 .01472 m
.52031 .01847 L
s
.57271 .01472 m
.57271 .01847 L
s
.59891 .01472 m
.59891 .01847 L
s
.62511 .01472 m
.62511 .01847 L
s
.65131 .01472 m
.65131 .01847 L
s
.70371 .01472 m
.70371 .01847 L
s
.72991 .01472 m
.72991 .01847 L
s
.75611 .01472 m
.75611 .01847 L
s
.78231 .01472 m
.78231 .01847 L
s
.83471 .01472 m
.83471 .01847 L
s
.86091 .01472 m
.86091 .01847 L
s
.88711 .01472 m
.88711 .01847 L
s
.91331 .01472 m
.91331 .01847 L
s
.96571 .01472 m
.96571 .01847 L
s
.99191 .01472 m
.99191 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.0225 .13244 m
.02875 .13244 L
s
[(0.2)] .01 .13244 1 0 Mshowa
.0225 .25016 m
.02875 .25016 L
s
[(0.4)] .01 .25016 1 0 Mshowa
.0225 .36788 m
.02875 .36788 L
s
[(0.6)] .01 .36788 1 0 Mshowa
.0225 .4856 m
.02875 .4856 L
s
[(0.8)] .01 .4856 1 0 Mshowa
.0225 .60332 m
.02875 .60332 L
s
[(1)] .01 .60332 1 0 Mshowa
.125 Mabswid
.0225 .04415 m
.02625 .04415 L
s
.0225 .07358 m
.02625 .07358 L
s
.0225 .10301 m
.02625 .10301 L
s
.0225 .16187 m
.02625 .16187 L
s
.0225 .1913 m
.02625 .1913 L
s
.0225 .22073 m
.02625 .22073 L
s
.0225 .27959 m
.02625 .27959 L
s
.0225 .30902 m
.02625 .30902 L
s
.0225 .33845 m
.02625 .33845 L
s
.0225 .39731 m
.02625 .39731 L
s
.0225 .42674 m
.02625 .42674 L
s
.0225 .45617 m
.02625 .45617 L
s
.0225 .51503 m
.02625 .51503 L
s
.0225 .54446 m
.02625 .54446 L
s
.0225 .57389 m
.02625 .57389 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
.5 Mabswid
.02381 .01714 m
.02512 .01714 L
.02643 .01876 L
.02774 .02119 L
.02905 .02281 L
.03036 .02524 L
.03167 .02605 L
.03298 .02848 L
.03429 .03172 L
.0356 .03334 L
.03691 .03981 L
.03822 .04062 L
.03953 .04143 L
.04084 .04305 L
.04215 .04548 L
.04346 .04791 L
.04477 .05034 L
.04608 .05277 L
.04739 .05358 L
.0487 .05682 L
.05001 .05844 L
.05132 .06491 L
.05263 .06815 L
.05394 .06977 L
.05525 .07382 L
.05656 .07463 L
.05787 .07625 L
.05918 .07868 L
.06049 .07949 L
.0618 .07949 L
.06311 .0803 L
.06442 .08111 L
.06573 .08111 L
.06704 .08191 L
.06835 .08434 L
.06966 .08515 L
.07097 .08596 L
.07228 .08758 L
.07359 .09001 L
.0749 .09244 L
.07621 .09406 L
.07752 .09568 L
.07883 .09973 L
.08014 .10135 L
.08145 .10458 L
.08276 .10458 L
.08407 .10539 L
.08538 .10944 L
.08669 .11106 L
.088 .1143 L
Mistroke
.08931 .11673 L
.09062 .12078 L
.09193 .1224 L
.09324 .1224 L
.09455 .12563 L
.09586 .12563 L
.09717 .12887 L
.09848 .12968 L
.09979 .13049 L
.1011 .13373 L
.10241 .13616 L
.10372 .1394 L
.10503 .14183 L
.10634 .14183 L
.10765 .14264 L
.10896 .14345 L
.11027 .1475 L
.11158 .1483 L
.11289 .14992 L
.1142 .15154 L
.11551 .15154 L
.11682 .15316 L
.11813 .15316 L
.11944 .15721 L
.12075 .15802 L
.12206 .15883 L
.12337 .16126 L
.12468 .16369 L
.12599 .16693 L
.1273 .17097 L
.12861 .17259 L
.12992 .17421 L
.13123 .17502 L
.13254 .17502 L
.13385 .17664 L
.13516 .17826 L
.13647 .17988 L
.13778 .18231 L
.13909 .18312 L
.1404 .18555 L
.14171 .18798 L
.14302 .19041 L
.14433 .19122 L
.14564 .19122 L
.14695 .19364 L
.14826 .19445 L
.14957 .19526 L
.15088 .19688 L
.15219 .1985 L
.1535 .20174 L
Mistroke
.15481 .20255 L
.15612 .20336 L
.15743 .20417 L
.15874 .2066 L
.16005 .2066 L
.16136 .20903 L
.16267 .20903 L
.16398 .21227 L
.16529 .21469 L
.1666 .2155 L
.16791 .21793 L
.16922 .22036 L
.17053 .22036 L
.17184 .22036 L
.17315 .2236 L
.17446 .22522 L
.17577 .22846 L
.17708 .23008 L
.17839 .2317 L
.1797 .2317 L
.18101 .23251 L
.18232 .23251 L
.18363 .23332 L
.18494 .23494 L
.18625 .23494 L
.18756 .23655 L
.18887 .24141 L
.19018 .24222 L
.19149 .24465 L
.1928 .24789 L
.19411 .25194 L
.19542 .25356 L
.19673 .25599 L
.19804 .25841 L
.19935 .25841 L
.20066 .26003 L
.20197 .26084 L
.20328 .26165 L
.20459 .26327 L
.2059 .26408 L
.20721 .26408 L
.20852 .26408 L
.20983 .26489 L
.21114 .26489 L
.21245 .26813 L
.21376 .26975 L
.21507 .27056 L
.21638 .27218 L
.21769 .27218 L
.219 .27299 L
Mistroke
.22031 .27623 L
.22162 .27785 L
.22293 .27947 L
.22424 .28108 L
.22555 .28351 L
.22686 .28594 L
.22817 .28756 L
.22948 .28756 L
.23079 .28756 L
.2321 .28837 L
.23341 .28918 L
.23472 .29161 L
.23603 .29242 L
.23734 .29323 L
.23865 .29404 L
.23996 .29485 L
.24127 .29566 L
.24258 .29647 L
.24389 .29647 L
.2452 .29728 L
.24651 .29728 L
.24782 .2989 L
.24913 .29971 L
.25044 .30133 L
.25175 .30214 L
.25306 .30214 L
.25437 .30375 L
.25568 .30537 L
.25699 .30699 L
.2583 .3078 L
.25961 .30861 L
.26092 .31104 L
.26223 .3159 L
.26354 .3159 L
.26485 .31671 L
.26616 .31752 L
.26747 .31995 L
.26878 .32319 L
.27009 .3248 L
.2714 .32561 L
.27271 .32804 L
.27402 .32804 L
.27533 .32804 L
.27664 .32966 L
.27795 .33209 L
.27926 .33452 L
.28057 .33452 L
.28188 .33533 L
.28319 .33695 L
.2845 .33776 L
Mistroke
.28581 .33857 L
.28712 .34181 L
.28843 .34424 L
.28974 .34424 L
.29105 .34505 L
.29236 .34505 L
.29367 .34505 L
.29498 .34666 L
.29629 .3499 L
.2976 .35152 L
.29891 .35314 L
.30022 .35557 L
.30153 .35719 L
.30284 .358 L
.30415 .358 L
.30546 .35962 L
.30677 .35962 L
.30808 .35962 L
.30939 .36043 L
.3107 .36124 L
.31201 .36286 L
.31332 .36448 L
.31463 .36529 L
.31594 .3661 L
.31725 .3661 L
.31856 .36853 L
.31987 .36853 L
.32118 .36853 L
.32249 .36853 L
.3238 .36933 L
.32511 .37176 L
.32642 .37419 L
.32773 .375 L
.32904 .37581 L
.33035 .37743 L
.33166 .37743 L
.33297 .37824 L
.33428 .38067 L
.33559 .38229 L
.3369 .38229 L
.33821 .38229 L
.33952 .38229 L
.34083 .3831 L
.34214 .38472 L
.34345 .38715 L
.34476 .38715 L
.34607 .38877 L
.34738 .38958 L
.34869 .39039 L
.35 .392 L
Mistroke
.35131 .39281 L
.35262 .39362 L
.35393 .39443 L
.35524 .39686 L
.35655 .39929 L
.35786 .39929 L
.35917 .40091 L
.36048 .40172 L
.36179 .40415 L
.3631 .40496 L
.36441 .40577 L
.36572 .4082 L
.36703 .4082 L
.36834 .40982 L
.36965 .41063 L
.37096 .41144 L
.37227 .41305 L
.37358 .41305 L
.37489 .41305 L
.3762 .41386 L
.37751 .41467 L
.37882 .41548 L
.38013 .41548 L
.38144 .41629 L
.38275 .41629 L
.38406 .41629 L
.38537 .41629 L
.38668 .41629 L
.38799 .41629 L
.3893 .4171 L
.39061 .4171 L
.39192 .41791 L
.39323 .41872 L
.39454 .41953 L
.39585 .42034 L
.39716 .42034 L
.39847 .42277 L
.39978 .42277 L
.40109 .42439 L
.4024 .42439 L
.40371 .42439 L
.40502 .4252 L
.40633 .4252 L
.40764 .4252 L
.40895 .4252 L
.41026 .42682 L
.41157 .42763 L
.41288 .42925 L
.41419 .42925 L
.4155 .42925 L
Mistroke
.41681 .43006 L
.41812 .43168 L
.41943 .43168 L
.42074 .43249 L
.42205 .43249 L
.42336 .4333 L
.42467 .43411 L
.42598 .43411 L
.42729 .43492 L
.4286 .43572 L
.42991 .43572 L
.43122 .43734 L
.43253 .43734 L
.43384 .43734 L
.43515 .43734 L
.43646 .43734 L
.43777 .43815 L
.43908 .43815 L
.44039 .43815 L
.4417 .43815 L
.44301 .43977 L
.44432 .44058 L
.44563 .44139 L
.44694 .4422 L
.44825 .44382 L
.44956 .44625 L
.45087 .44625 L
.45218 .44625 L
.45349 .44625 L
.4548 .44625 L
.45611 .44625 L
.45742 .44625 L
.45873 .44706 L
.46004 .44706 L
.46135 .44706 L
.46266 .44787 L
.46397 .44787 L
.46528 .44868 L
.46659 .4503 L
.4679 .45192 L
.46921 .45273 L
.47052 .45273 L
.47183 .45273 L
.47314 .45354 L
.47445 .45435 L
.47576 .45678 L
.47707 .45678 L
.47838 .45758 L
.47969 .45839 L
.481 .45839 L
Mistroke
.48231 .45839 L
.48362 .46001 L
.48493 .46082 L
.48624 .46082 L
.48755 .46082 L
.48886 .46163 L
.49017 .46244 L
.49148 .46325 L
.49279 .46406 L
.4941 .46487 L
.49541 .46568 L
.49672 .46811 L
.49803 .46973 L
.49934 .47054 L
.50066 .47054 L
.50197 .47135 L
.50328 .47135 L
.50459 .47297 L
.5059 .47378 L
.50721 .47378 L
.50852 .47459 L
.50983 .47702 L
.51114 .47783 L
.51245 .47944 L
.51376 .48106 L
.51507 .48106 L
.51638 .48106 L
.51769 .48106 L
.519 .48106 L
.52031 .48187 L
.52162 .48187 L
.52293 .48268 L
.52424 .48349 L
.52555 .48349 L
.52686 .48349 L
.52817 .48511 L
.52948 .48511 L
.53079 .48592 L
.5321 .48673 L
.53341 .48673 L
.53472 .48673 L
.53603 .48754 L
.53734 .48835 L
.53865 .48835 L
.53996 .48835 L
.54127 .48835 L
.54258 .48997 L
.54389 .49078 L
.5452 .49078 L
.54651 .4924 L
Mistroke
.54782 .49321 L
.54913 .49402 L
.55044 .49483 L
.55175 .49564 L
.55306 .49564 L
.55437 .49564 L
.55568 .49645 L
.55699 .49888 L
.5583 .49888 L
.55961 .49969 L
.56092 .5005 L
.56223 .50131 L
.56354 .50211 L
.56485 .50211 L
.56616 .50211 L
.56747 .50292 L
.56878 .50292 L
.57009 .50373 L
.5714 .50454 L
.57271 .50454 L
.57402 .50454 L
.57533 .50454 L
.57664 .50454 L
.57795 .50535 L
.57926 .50697 L
.58057 .50778 L
.58188 .51021 L
.58319 .51102 L
.5845 .51102 L
.58581 .51102 L
.58712 .51102 L
.58843 .51102 L
.58974 .51102 L
.59105 .51102 L
.59236 .51102 L
.59367 .51102 L
.59498 .51183 L
.59629 .51345 L
.5976 .51345 L
.59891 .51345 L
.60022 .51345 L
.60153 .51426 L
.60284 .51426 L
.60415 .51426 L
.60546 .51426 L
.60677 .51507 L
.60808 .51507 L
.60939 .51507 L
.6107 .51588 L
.61201 .51588 L
Mistroke
.61332 .5175 L
.61463 .5175 L
.61594 .5175 L
.61725 .51831 L
.61856 .51912 L
.61987 .51993 L
.62118 .51993 L
.62249 .52317 L
.6238 .52317 L
.62511 .52317 L
.62642 .52317 L
.62773 .52397 L
.62904 .52397 L
.63035 .52559 L
.63166 .5264 L
.63297 .5264 L
.63428 .52721 L
.63559 .52721 L
.6369 .52721 L
.63821 .52721 L
.63952 .52721 L
.64083 .52721 L
.64214 .52802 L
.64345 .52802 L
.64476 .52802 L
.64607 .52802 L
.64738 .53045 L
.64869 .53045 L
.65 .53126 L
.65131 .53207 L
.65262 .53369 L
.65393 .53531 L
.65524 .53612 L
.65655 .53612 L
.65786 .53612 L
.65917 .53612 L
.66048 .53612 L
.66179 .53612 L
.6631 .53612 L
.66441 .53612 L
.66572 .53612 L
.66703 .53693 L
.66834 .53855 L
.66965 .53855 L
.67096 .53855 L
.67227 .53936 L
.67358 .53936 L
.67489 .53936 L
.6762 .54017 L
.67751 .54017 L
Mistroke
.67882 .54098 L
.68013 .5426 L
.68144 .5426 L
.68275 .5426 L
.68406 .5426 L
.68537 .5426 L
.68668 .5426 L
.68799 .5426 L
.6893 .5426 L
.69061 .5426 L
.69192 .5426 L
.69323 .54341 L
.69454 .54341 L
.69585 .54341 L
.69716 .54341 L
.69847 .54422 L
.69978 .54422 L
.70109 .54503 L
.7024 .54583 L
.70371 .54583 L
.70502 .54664 L
.70633 .54745 L
.70764 .54745 L
.70895 .54907 L
.71026 .54907 L
.71157 .54988 L
.71288 .54988 L
.71419 .54988 L
.7155 .54988 L
.71681 .55069 L
.71812 .55231 L
.71943 .55231 L
.72074 .55393 L
.72205 .55393 L
.72336 .55555 L
.72467 .55555 L
.72598 .55555 L
.72729 .55636 L
.7286 .55636 L
.72991 .55636 L
.73122 .55636 L
.73253 .55798 L
.73384 .56041 L
.73515 .56041 L
.73646 .56041 L
.73777 .56041 L
.73908 .56041 L
.74039 .56122 L
.7417 .56122 L
.74301 .56122 L
Mistroke
.74432 .56122 L
.74563 .56203 L
.74694 .56203 L
.74825 .56203 L
.74956 .56203 L
.75087 .56284 L
.75218 .56284 L
.75349 .56284 L
.7548 .56284 L
.75611 .56284 L
.75742 .56284 L
.75873 .56284 L
.76004 .56365 L
.76135 .56446 L
.76266 .56446 L
.76397 .56446 L
.76528 .56527 L
.76659 .56527 L
.7679 .56527 L
.76921 .56527 L
.77052 .56689 L
.77183 .5685 L
.77314 .5685 L
.77445 .5685 L
.77576 .57012 L
.77707 .57012 L
.77838 .57093 L
.77969 .57093 L
.781 .57174 L
.78231 .57174 L
.78362 .57174 L
.78493 .57174 L
.78624 .57255 L
.78755 .57255 L
.78886 .57255 L
.79017 .57255 L
.79148 .57255 L
.79279 .57336 L
.7941 .57336 L
.79541 .57336 L
.79672 .57417 L
.79803 .57579 L
.79934 .57579 L
.80065 .57579 L
.80196 .57579 L
.80327 .57579 L
.80458 .57579 L
.80589 .57579 L
.8072 .5766 L
.80851 .5766 L
Mistroke
.80982 .5766 L
.81113 .5766 L
.81244 .5766 L
.81375 .57741 L
.81506 .57741 L
.81637 .57741 L
.81768 .57741 L
.81899 .57822 L
.8203 .57822 L
.82161 .57903 L
.82292 .57903 L
.82423 .57984 L
.82554 .57984 L
.82685 .57984 L
.82816 .57984 L
.82947 .57984 L
.83078 .57984 L
.83209 .57984 L
.8334 .57984 L
.83471 .57984 L
.83602 .58065 L
.83733 .58146 L
.83864 .58146 L
.83995 .58308 L
.84126 .58389 L
.84257 .58389 L
.84388 .58551 L
.84519 .58632 L
.8465 .58632 L
.84781 .58713 L
.84912 .58713 L
.85043 .58713 L
.85174 .58713 L
.85305 .58794 L
.85436 .58794 L
.85567 .58875 L
.85698 .58875 L
.85829 .58875 L
.8596 .58875 L
.86091 .58875 L
.86222 .58875 L
.86353 .58875 L
.86484 .58956 L
.86615 .58956 L
.86746 .58956 L
.86877 .58956 L
.87008 .58956 L
.87139 .58956 L
.8727 .58956 L
.87401 .58956 L
Mistroke
.87532 .59036 L
.87663 .59036 L
.87794 .59036 L
.87925 .59036 L
.88056 .59036 L
.88187 .59036 L
.88318 .59036 L
.88449 .59036 L
.8858 .59036 L
.88711 .59036 L
.88842 .59036 L
.88973 .59117 L
.89104 .59117 L
.89235 .59117 L
.89366 .59117 L
.89497 .59117 L
.89628 .59117 L
.89759 .59117 L
.8989 .59198 L
.90021 .5936 L
.90152 .59441 L
.90283 .59522 L
.90414 .59522 L
.90545 .59522 L
.90676 .59603 L
.90807 .59603 L
.90938 .59684 L
.91069 .59684 L
.912 .59684 L
.91331 .59684 L
.91462 .59684 L
.91593 .59684 L
.91724 .59684 L
.91855 .59765 L
.91986 .59765 L
.92117 .59765 L
.92248 .59765 L
.92379 .59765 L
.9251 .59765 L
.92641 .59765 L
.92772 .59765 L
.92903 .59765 L
.93034 .59765 L
.93165 .59846 L
.93296 .59846 L
.93427 .59846 L
.93558 .59846 L
.93689 .59927 L
.9382 .59927 L
.93951 .59927 L
Mistroke
.94082 .59927 L
.94213 .59927 L
.94344 .59927 L
.94475 .59927 L
.94606 .59927 L
.94737 .59927 L
.94868 .60008 L
.94999 .60008 L
.9513 .60008 L
.95261 .60008 L
.95392 .60008 L
.95523 .60008 L
.95654 .60089 L
.95785 .60089 L
.95916 .60089 L
.96047 .60089 L
.96178 .60251 L
.96309 .60251 L
.9644 .60251 L
.96571 .60332 L
.96702 .60332 L
.96833 .60332 L
.96964 .60332 L
.97095 .60332 L
.97226 .60332 L
.97357 .60332 L
.97488 .60332 L
.97619 .60332 L
Mfstroke
1 .5 0 r
.02381 .01472 m
.02512 .02086 L
.02643 .02588 L
.02774 .03048 L
.02905 .0348 L
.03036 .03892 L
.03167 .04288 L
.03298 .0467 L
.03429 .0504 L
.0356 .054 L
.03691 .05752 L
.03822 .06095 L
.03953 .0643 L
.04084 .06759 L
.04215 .07082 L
.04346 .07399 L
.04477 .07711 L
.04608 .08017 L
.04739 .08319 L
.0487 .08616 L
.05001 .08909 L
.05132 .09198 L
.05263 .09483 L
.05394 .09765 L
.05525 .10042 L
.05656 .10317 L
.05787 .10588 L
.05918 .10856 L
.06049 .11121 L
.0618 .11384 L
.06311 .11643 L
.06442 .119 L
.06573 .12154 L
.06704 .12406 L
.06835 .12655 L
.06966 .12902 L
.07097 .13146 L
.07228 .13388 L
.07359 .13628 L
.0749 .13866 L
.07621 .14102 L
.07752 .14336 L
.07883 .14568 L
.08014 .14797 L
.08145 .15025 L
.08276 .15252 L
.08407 .15476 L
.08538 .15699 L
.08669 .15919 L
.088 .16139 L
Mistroke
.08931 .16356 L
.09062 .16572 L
.09193 .16787 L
.09324 .16999 L
.09455 .17211 L
.09586 .1742 L
.09717 .17629 L
.09848 .17835 L
.09979 .18041 L
.1011 .18245 L
.10241 .18448 L
.10372 .18649 L
.10503 .18849 L
.10634 .19047 L
.10765 .19245 L
.10896 .19441 L
.11027 .19636 L
.11158 .19829 L
.11289 .20022 L
.1142 .20213 L
.11551 .20403 L
.11682 .20592 L
.11813 .2078 L
.11944 .20967 L
.12075 .21152 L
.12206 .21337 L
.12337 .2152 L
.12468 .21702 L
.12599 .21883 L
.1273 .22064 L
.12861 .22243 L
.12992 .22421 L
.13123 .22598 L
.13254 .22774 L
.13385 .2295 L
.13516 .23124 L
.13647 .23297 L
.13778 .23469 L
.13909 .23641 L
.1404 .23811 L
.14171 .23981 L
.14302 .2415 L
.14433 .24317 L
.14564 .24484 L
.14695 .2465 L
.14826 .24816 L
.14957 .2498 L
.15088 .25143 L
.15219 .25306 L
.1535 .25468 L
Mistroke
.15481 .25629 L
.15612 .25789 L
.15743 .25949 L
.15874 .26107 L
.16005 .26265 L
.16136 .26422 L
.16267 .26578 L
.16398 .26734 L
.16529 .26889 L
.1666 .27043 L
.16791 .27196 L
.16922 .27348 L
.17053 .275 L
.17184 .27651 L
.17315 .27802 L
.17446 .27951 L
.17577 .281 L
.17708 .28249 L
.17839 .28396 L
.1797 .28543 L
.18101 .28689 L
.18232 .28835 L
.18363 .2898 L
.18494 .29124 L
.18625 .29267 L
.18756 .2941 L
.18887 .29552 L
.19018 .29694 L
.19149 .29835 L
.1928 .29975 L
.19411 .30115 L
.19542 .30254 L
.19673 .30392 L
.19804 .3053 L
.19935 .30667 L
.20066 .30804 L
.20197 .3094 L
.20328 .31075 L
.20459 .3121 L
.2059 .31344 L
.20721 .31478 L
.20852 .31611 L
.20983 .31744 L
.21114 .31876 L
.21245 .32007 L
.21376 .32138 L
.21507 .32268 L
.21638 .32398 L
.21769 .32527 L
.219 .32656 L
Mistroke
.22031 .32784 L
.22162 .32911 L
.22293 .33038 L
.22424 .33165 L
.22555 .3329 L
.22686 .33416 L
.22817 .33541 L
.22948 .33665 L
.23079 .33789 L
.2321 .33912 L
.23341 .34035 L
.23472 .34157 L
.23603 .34279 L
.23734 .344 L
.23865 .34521 L
.23996 .34642 L
.24127 .34761 L
.24258 .34881 L
.24389 .35 L
.2452 .35118 L
.24651 .35236 L
.24782 .35353 L
.24913 .3547 L
.25044 .35587 L
.25175 .35703 L
.25306 .35818 L
.25437 .35933 L
.25568 .36048 L
.25699 .36162 L
.2583 .36276 L
.25961 .36389 L
.26092 .36502 L
.26223 .36614 L
.26354 .36726 L
.26485 .36837 L
.26616 .36948 L
.26747 .37059 L
.26878 .37169 L
.27009 .37279 L
.2714 .37388 L
.27271 .37497 L
.27402 .37606 L
.27533 .37714 L
.27664 .37821 L
.27795 .37928 L
.27926 .38035 L
.28057 .38141 L
.28188 .38247 L
.28319 .38353 L
.2845 .38458 L
Mistroke
.28581 .38563 L
.28712 .38667 L
.28843 .38771 L
.28974 .38874 L
.29105 .38977 L
.29236 .3908 L
.29367 .39182 L
.29498 .39284 L
.29629 .39386 L
.2976 .39487 L
.29891 .39588 L
.30022 .39688 L
.30153 .39788 L
.30284 .39888 L
.30415 .39987 L
.30546 .40086 L
.30677 .40184 L
.30808 .40282 L
.30939 .4038 L
.3107 .40477 L
.31201 .40574 L
.31332 .40671 L
.31463 .40767 L
.31594 .40863 L
.31725 .40958 L
.31856 .41053 L
.31987 .41148 L
.32118 .41243 L
.32249 .41337 L
.3238 .4143 L
.32511 .41524 L
.32642 .41617 L
.32773 .41709 L
.32904 .41802 L
.33035 .41894 L
.33166 .41985 L
.33297 .42076 L
.33428 .42167 L
.33559 .42258 L
.3369 .42348 L
.33821 .42438 L
.33952 .42528 L
.34083 .42617 L
.34214 .42706 L
.34345 .42794 L
.34476 .42883 L
.34607 .4297 L
.34738 .43058 L
.34869 .43145 L
.35 .43232 L
Mistroke
.35131 .43319 L
.35262 .43405 L
.35393 .43491 L
.35524 .43577 L
.35655 .43662 L
.35786 .43747 L
.35917 .43832 L
.36048 .43916 L
.36179 .44 L
.3631 .44084 L
.36441 .44167 L
.36572 .4425 L
.36703 .44333 L
.36834 .44415 L
.36965 .44498 L
.37096 .44579 L
.37227 .44661 L
.37358 .44742 L
.37489 .44823 L
.3762 .44904 L
.37751 .44984 L
.37882 .45064 L
.38013 .45144 L
.38144 .45223 L
.38275 .45303 L
.38406 .45381 L
.38537 .4546 L
.38668 .45538 L
.38799 .45616 L
.3893 .45694 L
.39061 .45771 L
.39192 .45848 L
.39323 .45925 L
.39454 .46002 L
.39585 .46078 L
.39716 .46154 L
.39847 .4623 L
.39978 .46305 L
.40109 .4638 L
.4024 .46455 L
.40371 .4653 L
.40502 .46604 L
.40633 .46678 L
.40764 .46751 L
.40895 .46825 L
.41026 .46898 L
.41157 .46971 L
.41288 .47044 L
.41419 .47116 L
.4155 .47188 L
Mistroke
.41681 .4726 L
.41812 .47331 L
.41943 .47403 L
.42074 .47474 L
.42205 .47544 L
.42336 .47615 L
.42467 .47685 L
.42598 .47755 L
.42729 .47825 L
.4286 .47894 L
.42991 .47963 L
.43122 .48032 L
.43253 .48101 L
.43384 .48169 L
.43515 .48237 L
.43646 .48305 L
.43777 .48372 L
.43908 .4844 L
.44039 .48507 L
.4417 .48574 L
.44301 .4864 L
.44432 .48707 L
.44563 .48773 L
.44694 .48838 L
.44825 .48904 L
.44956 .48969 L
.45087 .49034 L
.45218 .49099 L
.45349 .49164 L
.4548 .49228 L
.45611 .49292 L
.45742 .49356 L
.45873 .4942 L
.46004 .49483 L
.46135 .49546 L
.46266 .49609 L
.46397 .49671 L
.46528 .49734 L
.46659 .49796 L
.4679 .49858 L
.46921 .49919 L
.47052 .49981 L
.47183 .50042 L
.47314 .50103 L
.47445 .50164 L
.47576 .50224 L
.47707 .50284 L
.47838 .50344 L
.47969 .50404 L
.481 .50464 L
Mistroke
.48231 .50523 L
.48362 .50582 L
.48493 .50641 L
.48624 .50699 L
.48755 .50758 L
.48886 .50816 L
.49017 .50874 L
.49148 .50932 L
.49279 .50989 L
.4941 .51046 L
.49541 .51103 L
.49672 .5116 L
.49803 .51217 L
.49934 .51273 L
.50066 .51329 L
.50197 .51385 L
.50328 .51441 L
.50459 .51496 L
.5059 .51551 L
.50721 .51606 L
.50852 .51661 L
.50983 .51716 L
.51114 .5177 L
.51245 .51824 L
.51376 .51878 L
.51507 .51932 L
.51638 .51985 L
.51769 .52039 L
.519 .52092 L
.52031 .52145 L
.52162 .52197 L
.52293 .5225 L
.52424 .52302 L
.52555 .52354 L
.52686 .52406 L
.52817 .52457 L
.52948 .52509 L
.53079 .5256 L
.5321 .52611 L
.53341 .52661 L
.53472 .52712 L
.53603 .52762 L
.53734 .52812 L
.53865 .52862 L
.53996 .52912 L
.54127 .52961 L
.54258 .53011 L
.54389 .5306 L
.5452 .53109 L
.54651 .53157 L
Mistroke
.54782 .53206 L
.54913 .53254 L
.55044 .53302 L
.55175 .5335 L
.55306 .53398 L
.55437 .53445 L
.55568 .53492 L
.55699 .5354 L
.5583 .53586 L
.55961 .53633 L
.56092 .5368 L
.56223 .53726 L
.56354 .53772 L
.56485 .53818 L
.56616 .53863 L
.56747 .53909 L
.56878 .53954 L
.57009 .53999 L
.5714 .54044 L
.57271 .54089 L
.57402 .54134 L
.57533 .54178 L
.57664 .54222 L
.57795 .54266 L
.57926 .5431 L
.58057 .54353 L
.58188 .54397 L
.58319 .5444 L
.5845 .54483 L
.58581 .54526 L
.58712 .54568 L
.58843 .54611 L
.58974 .54653 L
.59105 .54695 L
.59236 .54737 L
.59367 .54778 L
.59498 .5482 L
.59629 .54861 L
.5976 .54902 L
.59891 .54943 L
.60022 .54984 L
.60153 .55025 L
.60284 .55065 L
.60415 .55105 L
.60546 .55145 L
.60677 .55185 L
.60808 .55225 L
.60939 .55264 L
.6107 .55303 L
.61201 .55342 L
Mistroke
.61332 .55381 L
.61463 .5542 L
.61594 .55459 L
.61725 .55497 L
.61856 .55535 L
.61987 .55573 L
.62118 .55611 L
.62249 .55649 L
.6238 .55686 L
.62511 .55724 L
.62642 .55761 L
.62773 .55798 L
.62904 .55835 L
.63035 .55871 L
.63166 .55908 L
.63297 .55944 L
.63428 .5598 L
.63559 .56016 L
.6369 .56052 L
.63821 .56087 L
.63952 .56123 L
.64083 .56158 L
.64214 .56193 L
.64345 .56228 L
.64476 .56263 L
.64607 .56297 L
.64738 .56331 L
.64869 .56366 L
.65 .564 L
.65131 .56434 L
.65262 .56467 L
.65393 .56501 L
.65524 .56534 L
.65655 .56567 L
.65786 .566 L
.65917 .56633 L
.66048 .56666 L
.66179 .56698 L
.6631 .56731 L
.66441 .56763 L
.66572 .56795 L
.66703 .56827 L
.66834 .56859 L
.66965 .5689 L
.67096 .56921 L
.67227 .56953 L
.67358 .56984 L
.67489 .57015 L
.6762 .57045 L
.67751 .57076 L
Mistroke
.67882 .57106 L
.68013 .57136 L
.68144 .57167 L
.68275 .57196 L
.68406 .57226 L
.68537 .57256 L
.68668 .57285 L
.68799 .57314 L
.6893 .57344 L
.69061 .57372 L
.69192 .57401 L
.69323 .5743 L
.69454 .57458 L
.69585 .57487 L
.69716 .57515 L
.69847 .57543 L
.69978 .57571 L
.70109 .57598 L
.7024 .57626 L
.70371 .57653 L
.70502 .5768 L
.70633 .57707 L
.70764 .57734 L
.70895 .57761 L
.71026 .57788 L
.71157 .57814 L
.71288 .5784 L
.71419 .57867 L
.7155 .57892 L
.71681 .57918 L
.71812 .57944 L
.71943 .57969 L
.72074 .57995 L
.72205 .5802 L
.72336 .58045 L
.72467 .5807 L
.72598 .58095 L
.72729 .58119 L
.7286 .58144 L
.72991 .58168 L
.73122 .58192 L
.73253 .58216 L
.73384 .5824 L
.73515 .58264 L
.73646 .58287 L
.73777 .58311 L
.73908 .58334 L
.74039 .58357 L
.7417 .5838 L
.74301 .58403 L
Mistroke
.74432 .58426 L
.74563 .58448 L
.74694 .5847 L
.74825 .58493 L
.74956 .58515 L
.75087 .58537 L
.75218 .58558 L
.75349 .5858 L
.7548 .58602 L
.75611 .58623 L
.75742 .58644 L
.75873 .58665 L
.76004 .58686 L
.76135 .58707 L
.76266 .58728 L
.76397 .58748 L
.76528 .58768 L
.76659 .58789 L
.7679 .58809 L
.76921 .58828 L
.77052 .58848 L
.77183 .58868 L
.77314 .58887 L
.77445 .58907 L
.77576 .58926 L
.77707 .58945 L
.77838 .58964 L
.77969 .58983 L
.781 .59001 L
.78231 .5902 L
.78362 .59038 L
.78493 .59056 L
.78624 .59074 L
.78755 .59092 L
.78886 .5911 L
.79017 .59128 L
.79148 .59145 L
.79279 .59163 L
.7941 .5918 L
.79541 .59197 L
.79672 .59214 L
.79803 .59231 L
.79934 .59248 L
.80065 .59264 L
.80196 .59281 L
.80327 .59297 L
.80458 .59313 L
.80589 .59329 L
.8072 .59345 L
.80851 .59361 L
Mistroke
.80982 .59376 L
.81113 .59392 L
.81244 .59407 L
.81375 .59422 L
.81506 .59437 L
.81637 .59452 L
.81768 .59467 L
.81899 .59482 L
.8203 .59496 L
.82161 .59511 L
.82292 .59525 L
.82423 .59539 L
.82554 .59553 L
.82685 .59567 L
.82816 .59581 L
.82947 .59594 L
.83078 .59608 L
.83209 .59621 L
.8334 .59635 L
.83471 .59648 L
.83602 .59661 L
.83733 .59673 L
.83864 .59686 L
.83995 .59699 L
.84126 .59711 L
.84257 .59723 L
.84388 .59736 L
.84519 .59748 L
.8465 .5976 L
.84781 .59771 L
.84912 .59783 L
.85043 .59795 L
.85174 .59806 L
.85305 .59817 L
.85436 .59828 L
.85567 .59839 L
.85698 .5985 L
.85829 .59861 L
.8596 .59872 L
.86091 .59882 L
.86222 .59893 L
.86353 .59903 L
.86484 .59913 L
.86615 .59923 L
.86746 .59933 L
.86877 .59943 L
.87008 .59952 L
.87139 .59962 L
.8727 .59971 L
.87401 .5998 L
Mistroke
.87532 .59989 L
.87663 .59998 L
.87794 .60007 L
.87925 .60016 L
.88056 .60025 L
.88187 .60033 L
.88318 .60042 L
.88449 .6005 L
.8858 .60058 L
.88711 .60066 L
.88842 .60074 L
.88973 .60082 L
.89104 .60089 L
.89235 .60097 L
.89366 .60104 L
.89497 .60111 L
.89628 .60119 L
.89759 .60126 L
.8989 .60133 L
.90021 .60139 L
.90152 .60146 L
.90283 .60153 L
.90414 .60159 L
.90545 .60165 L
.90676 .60172 L
.90807 .60178 L
.90938 .60184 L
.91069 .60189 L
.912 .60195 L
.91331 .60201 L
.91462 .60206 L
.91593 .60211 L
.91724 .60217 L
.91855 .60222 L
.91986 .60227 L
.92117 .60232 L
.92248 .60236 L
.92379 .60241 L
.9251 .60246 L
.92641 .6025 L
.92772 .60254 L
.92903 .60259 L
.93034 .60263 L
.93165 .60266 L
.93296 .6027 L
.93427 .60274 L
.93558 .60278 L
.93689 .60281 L
.9382 .60284 L
.93951 .60288 L
Mistroke
.94082 .60291 L
.94213 .60294 L
.94344 .60297 L
.94475 .60299 L
.94606 .60302 L
.94737 .60305 L
.94868 .60307 L
.94999 .60309 L
.9513 .60312 L
.95261 .60314 L
.95392 .60316 L
.95523 .60318 L
.95654 .60319 L
.95785 .60321 L
.95916 .60322 L
.96047 .60324 L
.96178 .60325 L
.96309 .60326 L
.9644 .60327 L
.96571 .60328 L
.96702 .60329 L
.96833 .6033 L
.96964 .6033 L
.97095 .60331 L
.97226 .60331 L
.97357 .60332 L
.97488 .60332 L
.97619 .60332 L
Mfstroke
0 .5 1 r
.02381 .01472 m
.02512 .01962 L
.02643 .02366 L
.02774 .02738 L
.02905 .03089 L
.03036 .03424 L
.03167 .03747 L
.03298 .04059 L
.03429 .04362 L
.0356 .04657 L
.03691 .04946 L
.03822 .05228 L
.03953 .05505 L
.04084 .05776 L
.04215 .06043 L
.04346 .06305 L
.04477 .06563 L
.04608 .06817 L
.04739 .07067 L
.0487 .07314 L
.05001 .07558 L
.05132 .07799 L
.05263 .08036 L
.05394 .08271 L
.05525 .08503 L
.05656 .08733 L
.05787 .0896 L
.05918 .09185 L
.06049 .09407 L
.0618 .09627 L
.06311 .09845 L
.06442 .10061 L
.06573 .10275 L
.06704 .10487 L
.06835 .10697 L
.06966 .10905 L
.07097 .11112 L
.07228 .11317 L
.07359 .1152 L
.0749 .11721 L
.07621 .11921 L
.07752 .12119 L
.07883 .12316 L
.08014 .12512 L
.08145 .12705 L
.08276 .12898 L
.08407 .13089 L
.08538 .13279 L
.08669 .13467 L
.088 .13654 L
Mistroke
.08931 .1384 L
.09062 .14025 L
.09193 .14208 L
.09324 .1439 L
.09455 .14571 L
.09586 .14751 L
.09717 .1493 L
.09848 .15107 L
.09979 .15284 L
.1011 .15459 L
.10241 .15634 L
.10372 .15807 L
.10503 .15979 L
.10634 .16151 L
.10765 .16321 L
.10896 .1649 L
.11027 .16659 L
.11158 .16826 L
.11289 .16993 L
.1142 .17158 L
.11551 .17323 L
.11682 .17487 L
.11813 .1765 L
.11944 .17812 L
.12075 .17973 L
.12206 .18134 L
.12337 .18293 L
.12468 .18452 L
.12599 .1861 L
.1273 .18767 L
.12861 .18924 L
.12992 .19079 L
.13123 .19234 L
.13254 .19388 L
.13385 .19542 L
.13516 .19694 L
.13647 .19846 L
.13778 .19997 L
.13909 .20148 L
.1404 .20297 L
.14171 .20446 L
.14302 .20595 L
.14433 .20742 L
.14564 .20889 L
.14695 .21035 L
.14826 .21181 L
.14957 .21326 L
.15088 .2147 L
.15219 .21614 L
.1535 .21757 L
Mistroke
.15481 .219 L
.15612 .22041 L
.15743 .22183 L
.15874 .22323 L
.16005 .22463 L
.16136 .22603 L
.16267 .22741 L
.16398 .2288 L
.16529 .23017 L
.1666 .23154 L
.16791 .23291 L
.16922 .23427 L
.17053 .23562 L
.17184 .23697 L
.17315 .23831 L
.17446 .23965 L
.17577 .24098 L
.17708 .2423 L
.17839 .24363 L
.1797 .24494 L
.18101 .24625 L
.18232 .24756 L
.18363 .24886 L
.18494 .25015 L
.18625 .25144 L
.18756 .25273 L
.18887 .25401 L
.19018 .25528 L
.19149 .25655 L
.1928 .25782 L
.19411 .25908 L
.19542 .26033 L
.19673 .26158 L
.19804 .26283 L
.19935 .26407 L
.20066 .26531 L
.20197 .26654 L
.20328 .26777 L
.20459 .26899 L
.2059 .27021 L
.20721 .27143 L
.20852 .27264 L
.20983 .27384 L
.21114 .27504 L
.21245 .27624 L
.21376 .27743 L
.21507 .27862 L
.21638 .2798 L
.21769 .28098 L
.219 .28216 L
Mistroke
.22031 .28333 L
.22162 .2845 L
.22293 .28566 L
.22424 .28682 L
.22555 .28797 L
.22686 .28912 L
.22817 .29027 L
.22948 .29141 L
.23079 .29255 L
.2321 .29369 L
.23341 .29482 L
.23472 .29594 L
.23603 .29707 L
.23734 .29819 L
.23865 .2993 L
.23996 .30041 L
.24127 .30152 L
.24258 .30263 L
.24389 .30373 L
.2452 .30482 L
.24651 .30592 L
.24782 .30701 L
.24913 .30809 L
.25044 .30917 L
.25175 .31025 L
.25306 .31133 L
.25437 .3124 L
.25568 .31347 L
.25699 .31453 L
.2583 .31559 L
.25961 .31665 L
.26092 .3177 L
.26223 .31876 L
.26354 .3198 L
.26485 .32085 L
.26616 .32189 L
.26747 .32292 L
.26878 .32396 L
.27009 .32499 L
.2714 .32602 L
.27271 .32704 L
.27402 .32806 L
.27533 .32908 L
.27664 .33009 L
.27795 .3311 L
.27926 .33211 L
.28057 .33311 L
.28188 .33411 L
.28319 .33511 L
.2845 .33611 L
Mistroke
.28581 .3371 L
.28712 .33809 L
.28843 .33907 L
.28974 .34006 L
.29105 .34104 L
.29236 .34201 L
.29367 .34299 L
.29498 .34396 L
.29629 .34492 L
.2976 .34589 L
.29891 .34685 L
.30022 .34781 L
.30153 .34876 L
.30284 .34972 L
.30415 .35067 L
.30546 .35161 L
.30677 .35256 L
.30808 .3535 L
.30939 .35444 L
.3107 .35537 L
.31201 .3563 L
.31332 .35723 L
.31463 .35816 L
.31594 .35908 L
.31725 .36001 L
.31856 .36092 L
.31987 .36184 L
.32118 .36275 L
.32249 .36366 L
.3238 .36457 L
.32511 .36547 L
.32642 .36638 L
.32773 .36728 L
.32904 .36817 L
.33035 .36907 L
.33166 .36996 L
.33297 .37085 L
.33428 .37173 L
.33559 .37262 L
.3369 .3735 L
.33821 .37438 L
.33952 .37525 L
.34083 .37612 L
.34214 .37699 L
.34345 .37786 L
.34476 .37873 L
.34607 .37959 L
.34738 .38045 L
.34869 .38131 L
.35 .38216 L
Mistroke
.35131 .38302 L
.35262 .38387 L
.35393 .38472 L
.35524 .38556 L
.35655 .3864 L
.35786 .38724 L
.35917 .38808 L
.36048 .38892 L
.36179 .38975 L
.3631 .39058 L
.36441 .39141 L
.36572 .39224 L
.36703 .39306 L
.36834 .39388 L
.36965 .3947 L
.37096 .39552 L
.37227 .39633 L
.37358 .39714 L
.37489 .39795 L
.3762 .39876 L
.37751 .39956 L
.37882 .40037 L
.38013 .40117 L
.38144 .40197 L
.38275 .40276 L
.38406 .40355 L
.38537 .40435 L
.38668 .40513 L
.38799 .40592 L
.3893 .40671 L
.39061 .40749 L
.39192 .40827 L
.39323 .40905 L
.39454 .40982 L
.39585 .41059 L
.39716 .41137 L
.39847 .41213 L
.39978 .4129 L
.40109 .41367 L
.4024 .41443 L
.40371 .41519 L
.40502 .41595 L
.40633 .4167 L
.40764 .41746 L
.40895 .41821 L
.41026 .41896 L
.41157 .41971 L
.41288 .42045 L
.41419 .4212 L
.4155 .42194 L
Mistroke
.41681 .42268 L
.41812 .42341 L
.41943 .42415 L
.42074 .42488 L
.42205 .42561 L
.42336 .42634 L
.42467 .42707 L
.42598 .42779 L
.42729 .42852 L
.4286 .42924 L
.42991 .42996 L
.43122 .43067 L
.43253 .43139 L
.43384 .4321 L
.43515 .43281 L
.43646 .43352 L
.43777 .43423 L
.43908 .43493 L
.44039 .43564 L
.4417 .43634 L
.44301 .43704 L
.44432 .43773 L
.44563 .43843 L
.44694 .43912 L
.44825 .43981 L
.44956 .4405 L
.45087 .44119 L
.45218 .44188 L
.45349 .44256 L
.4548 .44324 L
.45611 .44392 L
.45742 .4446 L
.45873 .44527 L
.46004 .44595 L
.46135 .44662 L
.46266 .44729 L
.46397 .44796 L
.46528 .44863 L
.46659 .44929 L
.4679 .44996 L
.46921 .45062 L
.47052 .45128 L
.47183 .45193 L
.47314 .45259 L
.47445 .45324 L
.47576 .4539 L
.47707 .45455 L
.47838 .4552 L
.47969 .45584 L
.481 .45649 L
Mistroke
.48231 .45713 L
.48362 .45777 L
.48493 .45841 L
.48624 .45905 L
.48755 .45969 L
.48886 .46032 L
.49017 .46095 L
.49148 .46158 L
.49279 .46221 L
.4941 .46284 L
.49541 .46347 L
.49672 .46409 L
.49803 .46471 L
.49934 .46533 L
.50066 .46595 L
.50197 .46657 L
.50328 .46719 L
.50459 .4678 L
.5059 .46841 L
.50721 .46902 L
.50852 .46963 L
.50983 .47024 L
.51114 .47084 L
.51245 .47145 L
.51376 .47205 L
.51507 .47265 L
.51638 .47325 L
.51769 .47384 L
.519 .47444 L
.52031 .47503 L
.52162 .47563 L
.52293 .47622 L
.52424 .47681 L
.52555 .47739 L
.52686 .47798 L
.52817 .47856 L
.52948 .47914 L
.53079 .47973 L
.5321 .4803 L
.53341 .48088 L
.53472 .48146 L
.53603 .48203 L
.53734 .4826 L
.53865 .48318 L
.53996 .48375 L
.54127 .48431 L
.54258 .48488 L
.54389 .48545 L
.5452 .48601 L
.54651 .48657 L
Mistroke
.54782 .48713 L
.54913 .48769 L
.55044 .48825 L
.55175 .4888 L
.55306 .48936 L
.55437 .48991 L
.55568 .49046 L
.55699 .49101 L
.5583 .49156 L
.55961 .4921 L
.56092 .49265 L
.56223 .49319 L
.56354 .49373 L
.56485 .49427 L
.56616 .49481 L
.56747 .49535 L
.56878 .49588 L
.57009 .49642 L
.5714 .49695 L
.57271 .49748 L
.57402 .49801 L
.57533 .49854 L
.57664 .49907 L
.57795 .49959 L
.57926 .50012 L
.58057 .50064 L
.58188 .50116 L
.58319 .50168 L
.5845 .5022 L
.58581 .50271 L
.58712 .50323 L
.58843 .50374 L
.58974 .50426 L
.59105 .50477 L
.59236 .50528 L
.59367 .50578 L
.59498 .50629 L
.59629 .5068 L
.5976 .5073 L
.59891 .5078 L
.60022 .5083 L
.60153 .5088 L
.60284 .5093 L
.60415 .5098 L
.60546 .51029 L
.60677 .51079 L
.60808 .51128 L
.60939 .51177 L
.6107 .51226 L
.61201 .51275 L
Mistroke
.61332 .51323 L
.61463 .51372 L
.61594 .5142 L
.61725 .51469 L
.61856 .51517 L
.61987 .51565 L
.62118 .51613 L
.62249 .5166 L
.6238 .51708 L
.62511 .51755 L
.62642 .51803 L
.62773 .5185 L
.62904 .51897 L
.63035 .51944 L
.63166 .51991 L
.63297 .52037 L
.63428 .52084 L
.63559 .5213 L
.6369 .52176 L
.63821 .52223 L
.63952 .52269 L
.64083 .52314 L
.64214 .5236 L
.64345 .52406 L
.64476 .52451 L
.64607 .52496 L
.64738 .52542 L
.64869 .52587 L
.65 .52632 L
.65131 .52676 L
.65262 .52721 L
.65393 .52766 L
.65524 .5281 L
.65655 .52854 L
.65786 .52899 L
.65917 .52943 L
.66048 .52986 L
.66179 .5303 L
.6631 .53074 L
.66441 .53117 L
.66572 .53161 L
.66703 .53204 L
.66834 .53247 L
.66965 .5329 L
.67096 .53333 L
.67227 .53376 L
.67358 .53418 L
.67489 .53461 L
.6762 .53503 L
.67751 .53546 L
Mistroke
.67882 .53588 L
.68013 .5363 L
.68144 .53672 L
.68275 .53713 L
.68406 .53755 L
.68537 .53796 L
.68668 .53838 L
.68799 .53879 L
.6893 .5392 L
.69061 .53961 L
.69192 .54002 L
.69323 .54043 L
.69454 .54084 L
.69585 .54124 L
.69716 .54165 L
.69847 .54205 L
.69978 .54245 L
.70109 .54285 L
.7024 .54325 L
.70371 .54365 L
.70502 .54405 L
.70633 .54444 L
.70764 .54484 L
.70895 .54523 L
.71026 .54562 L
.71157 .54601 L
.71288 .5464 L
.71419 .54679 L
.7155 .54718 L
.71681 .54756 L
.71812 .54795 L
.71943 .54833 L
.72074 .54872 L
.72205 .5491 L
.72336 .54948 L
.72467 .54986 L
.72598 .55023 L
.72729 .55061 L
.7286 .55099 L
.72991 .55136 L
.73122 .55174 L
.73253 .55211 L
.73384 .55248 L
.73515 .55285 L
.73646 .55322 L
.73777 .55359 L
.73908 .55395 L
.74039 .55432 L
.7417 .55468 L
.74301 .55504 L
Mistroke
.74432 .55541 L
.74563 .55577 L
.74694 .55613 L
.74825 .55649 L
.74956 .55684 L
.75087 .5572 L
.75218 .55755 L
.75349 .55791 L
.7548 .55826 L
.75611 .55861 L
.75742 .55896 L
.75873 .55931 L
.76004 .55966 L
.76135 .56001 L
.76266 .56036 L
.76397 .5607 L
.76528 .56105 L
.76659 .56139 L
.7679 .56173 L
.76921 .56207 L
.77052 .56241 L
.77183 .56275 L
.77314 .56309 L
.77445 .56342 L
.77576 .56376 L
.77707 .56409 L
.77838 .56443 L
.77969 .56476 L
.781 .56509 L
.78231 .56542 L
.78362 .56575 L
.78493 .56608 L
.78624 .5664 L
.78755 .56673 L
.78886 .56706 L
.79017 .56738 L
.79148 .5677 L
.79279 .56802 L
.7941 .56834 L
.79541 .56866 L
.79672 .56898 L
.79803 .5693 L
.79934 .56961 L
.80065 .56993 L
.80196 .57024 L
.80327 .57056 L
.80458 .57087 L
.80589 .57118 L
.8072 .57149 L
.80851 .5718 L
Mistroke
.80982 .57211 L
.81113 .57241 L
.81244 .57272 L
.81375 .57302 L
.81506 .57333 L
.81637 .57363 L
.81768 .57393 L
.81899 .57423 L
.8203 .57453 L
.82161 .57483 L
.82292 .57513 L
.82423 .57543 L
.82554 .57572 L
.82685 .57602 L
.82816 .57631 L
.82947 .5766 L
.83078 .57689 L
.83209 .57718 L
.8334 .57747 L
.83471 .57776 L
.83602 .57805 L
.83733 .57834 L
.83864 .57862 L
.83995 .57891 L
.84126 .57919 L
.84257 .57947 L
.84388 .57975 L
.84519 .58003 L
.8465 .58031 L
.84781 .58059 L
.84912 .58087 L
.85043 .58115 L
.85174 .58142 L
.85305 .5817 L
.85436 .58197 L
.85567 .58224 L
.85698 .58251 L
.85829 .58278 L
.8596 .58305 L
.86091 .58332 L
.86222 .58359 L
.86353 .58386 L
.86484 .58412 L
.86615 .58439 L
.86746 .58465 L
.86877 .58491 L
.87008 .58518 L
.87139 .58544 L
.8727 .5857 L
.87401 .58596 L
Mistroke
.87532 .58621 L
.87663 .58647 L
.87794 .58673 L
.87925 .58698 L
.88056 .58724 L
.88187 .58749 L
.88318 .58774 L
.88449 .58799 L
.8858 .58824 L
.88711 .58849 L
.88842 .58874 L
.88973 .58899 L
.89104 .58924 L
.89235 .58948 L
.89366 .58973 L
.89497 .58997 L
.89628 .59021 L
.89759 .59046 L
.8989 .5907 L
.90021 .59094 L
.90152 .59118 L
.90283 .59141 L
.90414 .59165 L
.90545 .59189 L
.90676 .59212 L
.90807 .59236 L
.90938 .59259 L
.91069 .59282 L
.912 .59306 L
.91331 .59329 L
.91462 .59352 L
.91593 .59375 L
.91724 .59397 L
.91855 .5942 L
.91986 .59443 L
.92117 .59465 L
.92248 .59488 L
.92379 .5951 L
.9251 .59532 L
.92641 .59555 L
.92772 .59577 L
.92903 .59599 L
.93034 .59621 L
.93165 .59642 L
.93296 .59664 L
.93427 .59686 L
.93558 .59707 L
.93689 .59729 L
.9382 .5975 L
.93951 .59772 L
Mistroke
.94082 .59793 L
.94213 .59814 L
.94344 .59835 L
.94475 .59856 L
.94606 .59877 L
.94737 .59897 L
.94868 .59918 L
.94999 .59939 L
.9513 .59959 L
.95261 .5998 L
.95392 .6 L
.95523 .6002 L
.95654 .6004 L
.95785 .6006 L
.95916 .6008 L
.96047 .601 L
.96178 .6012 L
.96309 .6014 L
.9644 .60159 L
.96571 .60179 L
.96702 .60198 L
.96833 .60218 L
.96964 .60237 L
.97095 .60256 L
.97226 .60275 L
.97357 .60294 L
.97488 .60313 L
.97619 .60332 L
Mfstroke
0 1 0 r
.02381 .01472 m
.02512 .01684 L
.02643 .01894 L
.02774 .02101 L
.02905 .02308 L
.03036 .02513 L
.03167 .02716 L
.03298 .02919 L
.03429 .0312 L
.0356 .0332 L
.03691 .0352 L
.03822 .03718 L
.03953 .03915 L
.04084 .04112 L
.04215 .04307 L
.04346 .04502 L
.04477 .04696 L
.04608 .04889 L
.04739 .05081 L
.0487 .05273 L
.05001 .05463 L
.05132 .05653 L
.05263 .05843 L
.05394 .06031 L
.05525 .06219 L
.05656 .06406 L
.05787 .06593 L
.05918 .06779 L
.06049 .06964 L
.0618 .07148 L
.06311 .07332 L
.06442 .07515 L
.06573 .07698 L
.06704 .0788 L
.06835 .08062 L
.06966 .08242 L
.07097 .08423 L
.07228 .08602 L
.07359 .08781 L
.0749 .0896 L
.07621 .09138 L
.07752 .09315 L
.07883 .09492 L
.08014 .09668 L
.08145 .09844 L
.08276 .10019 L
.08407 .10194 L
.08538 .10368 L
.08669 .10541 L
.088 .10714 L
Mistroke
.08931 .10887 L
.09062 .11059 L
.09193 .1123 L
.09324 .11401 L
.09455 .11572 L
.09586 .11742 L
.09717 .11911 L
.09848 .1208 L
.09979 .12249 L
.1011 .12417 L
.10241 .12584 L
.10372 .12752 L
.10503 .12918 L
.10634 .13084 L
.10765 .1325 L
.10896 .13415 L
.11027 .1358 L
.11158 .13744 L
.11289 .13908 L
.1142 .14071 L
.11551 .14234 L
.11682 .14397 L
.11813 .14559 L
.11944 .1472 L
.12075 .14881 L
.12206 .15042 L
.12337 .15202 L
.12468 .15362 L
.12599 .15521 L
.1273 .1568 L
.12861 .15839 L
.12992 .15997 L
.13123 .16154 L
.13254 .16312 L
.13385 .16468 L
.13516 .16625 L
.13647 .16781 L
.13778 .16936 L
.13909 .17091 L
.1404 .17246 L
.14171 .174 L
.14302 .17554 L
.14433 .17708 L
.14564 .17861 L
.14695 .18014 L
.14826 .18166 L
.14957 .18318 L
.15088 .18469 L
.15219 .1862 L
.1535 .18771 L
Mistroke
.15481 .18921 L
.15612 .19071 L
.15743 .19221 L
.15874 .1937 L
.16005 .19519 L
.16136 .19667 L
.16267 .19815 L
.16398 .19963 L
.16529 .2011 L
.1666 .20257 L
.16791 .20403 L
.16922 .20549 L
.17053 .20695 L
.17184 .2084 L
.17315 .20985 L
.17446 .2113 L
.17577 .21274 L
.17708 .21418 L
.17839 .21561 L
.1797 .21704 L
.18101 .21847 L
.18232 .2199 L
.18363 .22132 L
.18494 .22273 L
.18625 .22415 L
.18756 .22556 L
.18887 .22696 L
.19018 .22836 L
.19149 .22976 L
.1928 .23116 L
.19411 .23255 L
.19542 .23394 L
.19673 .23532 L
.19804 .2367 L
.19935 .23808 L
.20066 .23945 L
.20197 .24082 L
.20328 .24219 L
.20459 .24355 L
.2059 .24492 L
.20721 .24627 L
.20852 .24763 L
.20983 .24898 L
.21114 .25032 L
.21245 .25166 L
.21376 .253 L
.21507 .25434 L
.21638 .25567 L
.21769 .257 L
.219 .25833 L
Mistroke
.22031 .25965 L
.22162 .26097 L
.22293 .26229 L
.22424 .2636 L
.22555 .26491 L
.22686 .26622 L
.22817 .26752 L
.22948 .26882 L
.23079 .27012 L
.2321 .27141 L
.23341 .2727 L
.23472 .27399 L
.23603 .27527 L
.23734 .27655 L
.23865 .27783 L
.23996 .2791 L
.24127 .28037 L
.24258 .28164 L
.24389 .2829 L
.2452 .28416 L
.24651 .28542 L
.24782 .28668 L
.24913 .28793 L
.25044 .28918 L
.25175 .29042 L
.25306 .29166 L
.25437 .2929 L
.25568 .29414 L
.25699 .29537 L
.2583 .2966 L
.25961 .29783 L
.26092 .29905 L
.26223 .30027 L
.26354 .30149 L
.26485 .3027 L
.26616 .30391 L
.26747 .30512 L
.26878 .30632 L
.27009 .30753 L
.2714 .30872 L
.27271 .30992 L
.27402 .31111 L
.27533 .3123 L
.27664 .31349 L
.27795 .31467 L
.27926 .31585 L
.28057 .31703 L
.28188 .31821 L
.28319 .31938 L
.2845 .32055 L
Mistroke
.28581 .32171 L
.28712 .32287 L
.28843 .32403 L
.28974 .32519 L
.29105 .32634 L
.29236 .32749 L
.29367 .32864 L
.29498 .32979 L
.29629 .33093 L
.2976 .33207 L
.29891 .3332 L
.30022 .33434 L
.30153 .33547 L
.30284 .33659 L
.30415 .33772 L
.30546 .33884 L
.30677 .33996 L
.30808 .34107 L
.30939 .34219 L
.3107 .3433 L
.31201 .3444 L
.31332 .34551 L
.31463 .34661 L
.31594 .34771 L
.31725 .3488 L
.31856 .3499 L
.31987 .35099 L
.32118 .35207 L
.32249 .35316 L
.3238 .35424 L
.32511 .35532 L
.32642 .35639 L
.32773 .35747 L
.32904 .35854 L
.33035 .35961 L
.33166 .36067 L
.33297 .36173 L
.33428 .36279 L
.33559 .36385 L
.3369 .3649 L
.33821 .36595 L
.33952 .367 L
.34083 .36804 L
.34214 .36909 L
.34345 .37013 L
.34476 .37116 L
.34607 .3722 L
.34738 .37323 L
.34869 .37426 L
.35 .37528 L
Mistroke
.35131 .37631 L
.35262 .37733 L
.35393 .37835 L
.35524 .37936 L
.35655 .38037 L
.35786 .38138 L
.35917 .38239 L
.36048 .38339 L
.36179 .3844 L
.3631 .38539 L
.36441 .38639 L
.36572 .38738 L
.36703 .38837 L
.36834 .38936 L
.36965 .39035 L
.37096 .39133 L
.37227 .39231 L
.37358 .39329 L
.37489 .39426 L
.3762 .39524 L
.37751 .3962 L
.37882 .39717 L
.38013 .39814 L
.38144 .3991 L
.38275 .40006 L
.38406 .40101 L
.38537 .40197 L
.38668 .40292 L
.38799 .40387 L
.3893 .40481 L
.39061 .40576 L
.39192 .4067 L
.39323 .40763 L
.39454 .40857 L
.39585 .4095 L
.39716 .41043 L
.39847 .41136 L
.39978 .41229 L
.40109 .41321 L
.4024 .41413 L
.40371 .41504 L
.40502 .41596 L
.40633 .41687 L
.40764 .41778 L
.40895 .41869 L
.41026 .41959 L
.41157 .4205 L
.41288 .42139 L
.41419 .42229 L
.4155 .42319 L
Mistroke
.41681 .42408 L
.41812 .42497 L
.41943 .42585 L
.42074 .42674 L
.42205 .42762 L
.42336 .4285 L
.42467 .42938 L
.42598 .43025 L
.42729 .43112 L
.4286 .43199 L
.42991 .43286 L
.43122 .43372 L
.43253 .43458 L
.43384 .43544 L
.43515 .4363 L
.43646 .43715 L
.43777 .438 L
.43908 .43885 L
.44039 .4397 L
.4417 .44054 L
.44301 .44139 L
.44432 .44223 L
.44563 .44306 L
.44694 .4439 L
.44825 .44473 L
.44956 .44556 L
.45087 .44638 L
.45218 .44721 L
.45349 .44803 L
.4548 .44885 L
.45611 .44967 L
.45742 .45048 L
.45873 .45129 L
.46004 .4521 L
.46135 .45291 L
.46266 .45372 L
.46397 .45452 L
.46528 .45532 L
.46659 .45612 L
.4679 .45691 L
.46921 .45771 L
.47052 .4585 L
.47183 .45928 L
.47314 .46007 L
.47445 .46085 L
.47576 .46163 L
.47707 .46241 L
.47838 .46319 L
.47969 .46396 L
.481 .46473 L
Mistroke
.48231 .4655 L
.48362 .46627 L
.48493 .46703 L
.48624 .46779 L
.48755 .46855 L
.48886 .46931 L
.49017 .47006 L
.49148 .47082 L
.49279 .47157 L
.4941 .47231 L
.49541 .47306 L
.49672 .4738 L
.49803 .47454 L
.49934 .47528 L
.50066 .47602 L
.50197 .47675 L
.50328 .47748 L
.50459 .47821 L
.5059 .47893 L
.50721 .47966 L
.50852 .48038 L
.50983 .4811 L
.51114 .48182 L
.51245 .48253 L
.51376 .48324 L
.51507 .48395 L
.51638 .48466 L
.51769 .48537 L
.519 .48607 L
.52031 .48677 L
.52162 .48747 L
.52293 .48816 L
.52424 .48886 L
.52555 .48955 L
.52686 .49024 L
.52817 .49093 L
.52948 .49161 L
.53079 .49229 L
.5321 .49297 L
.53341 .49365 L
.53472 .49433 L
.53603 .495 L
.53734 .49567 L
.53865 .49634 L
.53996 .497 L
.54127 .49767 L
.54258 .49833 L
.54389 .49899 L
.5452 .49965 L
.54651 .5003 L
Mistroke
.54782 .50095 L
.54913 .5016 L
.55044 .50225 L
.55175 .5029 L
.55306 .50354 L
.55437 .50418 L
.55568 .50482 L
.55699 .50546 L
.5583 .50609 L
.55961 .50673 L
.56092 .50736 L
.56223 .50798 L
.56354 .50861 L
.56485 .50923 L
.56616 .50985 L
.56747 .51047 L
.56878 .51109 L
.57009 .5117 L
.5714 .51232 L
.57271 .51293 L
.57402 .51354 L
.57533 .51414 L
.57664 .51474 L
.57795 .51535 L
.57926 .51594 L
.58057 .51654 L
.58188 .51714 L
.58319 .51773 L
.5845 .51832 L
.58581 .51891 L
.58712 .51949 L
.58843 .52007 L
.58974 .52066 L
.59105 .52124 L
.59236 .52181 L
.59367 .52239 L
.59498 .52296 L
.59629 .52353 L
.5976 .5241 L
.59891 .52466 L
.60022 .52523 L
.60153 .52579 L
.60284 .52635 L
.60415 .52691 L
.60546 .52746 L
.60677 .52801 L
.60808 .52856 L
.60939 .52911 L
.6107 .52966 L
.61201 .5302 L
Mistroke
.61332 .53075 L
.61463 .53129 L
.61594 .53182 L
.61725 .53236 L
.61856 .53289 L
.61987 .53342 L
.62118 .53395 L
.62249 .53448 L
.6238 .535 L
.62511 .53553 L
.62642 .53605 L
.62773 .53657 L
.62904 .53708 L
.63035 .5376 L
.63166 .53811 L
.63297 .53862 L
.63428 .53913 L
.63559 .53963 L
.6369 .54014 L
.63821 .54064 L
.63952 .54114 L
.64083 .54163 L
.64214 .54213 L
.64345 .54262 L
.64476 .54311 L
.64607 .5436 L
.64738 .54409 L
.64869 .54457 L
.65 .54505 L
.65131 .54553 L
.65262 .54601 L
.65393 .54649 L
.65524 .54696 L
.65655 .54743 L
.65786 .5479 L
.65917 .54837 L
.66048 .54884 L
.66179 .5493 L
.6631 .54976 L
.66441 .55022 L
.66572 .55068 L
.66703 .55113 L
.66834 .55158 L
.66965 .55204 L
.67096 .55248 L
.67227 .55293 L
.67358 .55338 L
.67489 .55382 L
.6762 .55426 L
.67751 .5547 L
Mistroke
.67882 .55513 L
.68013 .55557 L
.68144 .556 L
.68275 .55643 L
.68406 .55686 L
.68537 .55728 L
.68668 .55771 L
.68799 .55813 L
.6893 .55855 L
.69061 .55897 L
.69192 .55938 L
.69323 .5598 L
.69454 .56021 L
.69585 .56062 L
.69716 .56102 L
.69847 .56143 L
.69978 .56183 L
.70109 .56223 L
.7024 .56263 L
.70371 .56303 L
.70502 .56343 L
.70633 .56382 L
.70764 .56421 L
.70895 .5646 L
.71026 .56499 L
.71157 .56537 L
.71288 .56575 L
.71419 .56613 L
.7155 .56651 L
.71681 .56689 L
.71812 .56727 L
.71943 .56764 L
.72074 .56801 L
.72205 .56838 L
.72336 .56874 L
.72467 .56911 L
.72598 .56947 L
.72729 .56983 L
.7286 .57019 L
.72991 .57055 L
.73122 .5709 L
.73253 .57125 L
.73384 .57161 L
.73515 .57195 L
.73646 .5723 L
.73777 .57265 L
.73908 .57299 L
.74039 .57333 L
.7417 .57367 L
.74301 .574 L
Mistroke
.74432 .57434 L
.74563 .57467 L
.74694 .575 L
.74825 .57533 L
.74956 .57566 L
.75087 .57598 L
.75218 .5763 L
.75349 .57662 L
.7548 .57694 L
.75611 .57726 L
.75742 .57757 L
.75873 .57789 L
.76004 .5782 L
.76135 .57851 L
.76266 .57881 L
.76397 .57912 L
.76528 .57942 L
.76659 .57972 L
.7679 .58002 L
.76921 .58032 L
.77052 .58061 L
.77183 .58091 L
.77314 .5812 L
.77445 .58149 L
.77576 .58177 L
.77707 .58206 L
.77838 .58234 L
.77969 .58262 L
.781 .5829 L
.78231 .58318 L
.78362 .58345 L
.78493 .58373 L
.78624 .584 L
.78755 .58427 L
.78886 .58454 L
.79017 .5848 L
.79148 .58506 L
.79279 .58533 L
.7941 .58559 L
.79541 .58584 L
.79672 .5861 L
.79803 .58635 L
.79934 .58661 L
.80065 .58686 L
.80196 .5871 L
.80327 .58735 L
.80458 .58759 L
.80589 .58784 L
.8072 .58808 L
.80851 .58832 L
Mistroke
.80982 .58855 L
.81113 .58879 L
.81244 .58902 L
.81375 .58925 L
.81506 .58948 L
.81637 .58971 L
.81768 .58993 L
.81899 .59015 L
.8203 .59037 L
.82161 .59059 L
.82292 .59081 L
.82423 .59103 L
.82554 .59124 L
.82685 .59145 L
.82816 .59166 L
.82947 .59187 L
.83078 .59207 L
.83209 .59228 L
.8334 .59248 L
.83471 .59268 L
.83602 .59288 L
.83733 .59307 L
.83864 .59327 L
.83995 .59346 L
.84126 .59365 L
.84257 .59384 L
.84388 .59403 L
.84519 .59421 L
.8465 .5944 L
.84781 .59458 L
.84912 .59476 L
.85043 .59493 L
.85174 .59511 L
.85305 .59528 L
.85436 .59545 L
.85567 .59562 L
.85698 .59579 L
.85829 .59596 L
.8596 .59612 L
.86091 .59628 L
.86222 .59644 L
.86353 .5966 L
.86484 .59676 L
.86615 .59691 L
.86746 .59707 L
.86877 .59722 L
.87008 .59737 L
.87139 .59751 L
.8727 .59766 L
.87401 .5978 L
Mistroke
.87532 .59794 L
.87663 .59808 L
.87794 .59822 L
.87925 .59836 L
.88056 .59849 L
.88187 .59862 L
.88318 .59875 L
.88449 .59888 L
.8858 .59901 L
.88711 .59913 L
.88842 .59926 L
.88973 .59938 L
.89104 .5995 L
.89235 .59961 L
.89366 .59973 L
.89497 .59984 L
.89628 .59996 L
.89759 .60007 L
.8989 .60017 L
.90021 .60028 L
.90152 .60038 L
.90283 .60049 L
.90414 .60059 L
.90545 .60069 L
.90676 .60078 L
.90807 .60088 L
.90938 .60097 L
.91069 .60106 L
.912 .60115 L
.91331 .60124 L
.91462 .60133 L
.91593 .60141 L
.91724 .60149 L
.91855 .60157 L
.91986 .60165 L
.92117 .60173 L
.92248 .60181 L
.92379 .60188 L
.9251 .60195 L
.92641 .60202 L
.92772 .60209 L
.92903 .60215 L
.93034 .60222 L
.93165 .60228 L
.93296 .60234 L
.93427 .6024 L
.93558 .60246 L
.93689 .60251 L
.9382 .60256 L
.93951 .60261 L
Mistroke
.94082 .60266 L
.94213 .60271 L
.94344 .60276 L
.94475 .6028 L
.94606 .60284 L
.94737 .60288 L
.94868 .60292 L
.94999 .60296 L
.9513 .603 L
.95261 .60303 L
.95392 .60306 L
.95523 .60309 L
.95654 .60312 L
.95785 .60314 L
.95916 .60317 L
.96047 .60319 L
.96178 .60321 L
.96309 .60323 L
.9644 .60325 L
.96571 .60326 L
.96702 .60328 L
.96833 .60329 L
.96964 .6033 L
.97095 .6033 L
.97226 .60331 L
.97357 .60332 L
.97488 .60332 L
.97619 .60332 L
Mfstroke
1 0 1 r
.02381 .01472 m
.02512 .02014 L
.02643 .02445 L
.02774 .02835 L
.02905 .03199 L
.03036 .03543 L
.03167 .03871 L
.03298 .04187 L
.03429 .04492 L
.0356 .04788 L
.03691 .05076 L
.03822 .05356 L
.03953 .05629 L
.04084 .05897 L
.04215 .06158 L
.04346 .06415 L
.04477 .06667 L
.04608 .06915 L
.04739 .07158 L
.0487 .07397 L
.05001 .07633 L
.05132 .07865 L
.05263 .08094 L
.05394 .0832 L
.05525 .08543 L
.05656 .08763 L
.05787 .08981 L
.05918 .09196 L
.06049 .09408 L
.0618 .09618 L
.06311 .09826 L
.06442 .10031 L
.06573 .10234 L
.06704 .10436 L
.06835 .10635 L
.06966 .10832 L
.07097 .11028 L
.07228 .11222 L
.07359 .11414 L
.0749 .11604 L
.07621 .11793 L
.07752 .1198 L
.07883 .12166 L
.08014 .1235 L
.08145 .12532 L
.08276 .12714 L
.08407 .12894 L
.08538 .13072 L
.08669 .13249 L
.088 .13425 L
Mistroke
.08931 .136 L
.09062 .13773 L
.09193 .13946 L
.09324 .14117 L
.09455 .14287 L
.09586 .14456 L
.09717 .14623 L
.09848 .1479 L
.09979 .14956 L
.1011 .1512 L
.10241 .15284 L
.10372 .15446 L
.10503 .15608 L
.10634 .15769 L
.10765 .15929 L
.10896 .16087 L
.11027 .16245 L
.11158 .16403 L
.11289 .16559 L
.1142 .16714 L
.11551 .16869 L
.11682 .17022 L
.11813 .17175 L
.11944 .17328 L
.12075 .17479 L
.12206 .17629 L
.12337 .17779 L
.12468 .17928 L
.12599 .18077 L
.1273 .18224 L
.12861 .18371 L
.12992 .18518 L
.13123 .18663 L
.13254 .18808 L
.13385 .18952 L
.13516 .19096 L
.13647 .19239 L
.13778 .19381 L
.13909 .19523 L
.1404 .19664 L
.14171 .19804 L
.14302 .19944 L
.14433 .20083 L
.14564 .20222 L
.14695 .2036 L
.14826 .20497 L
.14957 .20634 L
.15088 .2077 L
.15219 .20906 L
.1535 .21041 L
Mistroke
.15481 .21176 L
.15612 .2131 L
.15743 .21444 L
.15874 .21577 L
.16005 .21709 L
.16136 .21841 L
.16267 .21973 L
.16398 .22104 L
.16529 .22235 L
.1666 .22365 L
.16791 .22494 L
.16922 .22623 L
.17053 .22752 L
.17184 .2288 L
.17315 .23008 L
.17446 .23135 L
.17577 .23262 L
.17708 .23389 L
.17839 .23515 L
.1797 .2364 L
.18101 .23765 L
.18232 .2389 L
.18363 .24014 L
.18494 .24138 L
.18625 .24261 L
.18756 .24384 L
.18887 .24507 L
.19018 .24629 L
.19149 .24751 L
.1928 .24872 L
.19411 .24993 L
.19542 .25114 L
.19673 .25234 L
.19804 .25354 L
.19935 .25473 L
.20066 .25592 L
.20197 .25711 L
.20328 .25829 L
.20459 .25947 L
.2059 .26065 L
.20721 .26182 L
.20852 .26299 L
.20983 .26415 L
.21114 .26532 L
.21245 .26647 L
.21376 .26763 L
.21507 .26878 L
.21638 .26993 L
.21769 .27107 L
.219 .27222 L
Mistroke
.22031 .27335 L
.22162 .27449 L
.22293 .27562 L
.22424 .27675 L
.22555 .27787 L
.22686 .27899 L
.22817 .28011 L
.22948 .28123 L
.23079 .28234 L
.2321 .28345 L
.23341 .28456 L
.23472 .28566 L
.23603 .28676 L
.23734 .28786 L
.23865 .28895 L
.23996 .29004 L
.24127 .29113 L
.24258 .29222 L
.24389 .2933 L
.2452 .29438 L
.24651 .29546 L
.24782 .29653 L
.24913 .2976 L
.25044 .29867 L
.25175 .29973 L
.25306 .3008 L
.25437 .30186 L
.25568 .30291 L
.25699 .30397 L
.2583 .30502 L
.25961 .30607 L
.26092 .30711 L
.26223 .30816 L
.26354 .3092 L
.26485 .31024 L
.26616 .31127 L
.26747 .31231 L
.26878 .31334 L
.27009 .31436 L
.2714 .31539 L
.27271 .31641 L
.27402 .31743 L
.27533 .31845 L
.27664 .31947 L
.27795 .32048 L
.27926 .32149 L
.28057 .3225 L
.28188 .3235 L
.28319 .32451 L
.2845 .32551 L
Mistroke
.28581 .32651 L
.28712 .3275 L
.28843 .3285 L
.28974 .32949 L
.29105 .33048 L
.29236 .33146 L
.29367 .33245 L
.29498 .33343 L
.29629 .33441 L
.2976 .33539 L
.29891 .33636 L
.30022 .33733 L
.30153 .3383 L
.30284 .33927 L
.30415 .34024 L
.30546 .3412 L
.30677 .34216 L
.30808 .34312 L
.30939 .34408 L
.3107 .34503 L
.31201 .34599 L
.31332 .34694 L
.31463 .34789 L
.31594 .34883 L
.31725 .34978 L
.31856 .35072 L
.31987 .35166 L
.32118 .3526 L
.32249 .35353 L
.3238 .35447 L
.32511 .3554 L
.32642 .35633 L
.32773 .35725 L
.32904 .35818 L
.33035 .3591 L
.33166 .36002 L
.33297 .36094 L
.33428 .36186 L
.33559 .36278 L
.3369 .36369 L
.33821 .3646 L
.33952 .36551 L
.34083 .36642 L
.34214 .36732 L
.34345 .36822 L
.34476 .36912 L
.34607 .37002 L
.34738 .37092 L
.34869 .37182 L
.35 .37271 L
Mistroke
.35131 .3736 L
.35262 .37449 L
.35393 .37538 L
.35524 .37626 L
.35655 .37715 L
.35786 .37803 L
.35917 .37891 L
.36048 .37979 L
.36179 .38066 L
.3631 .38154 L
.36441 .38241 L
.36572 .38328 L
.36703 .38415 L
.36834 .38502 L
.36965 .38588 L
.37096 .38674 L
.37227 .38761 L
.37358 .38847 L
.37489 .38932 L
.3762 .39018 L
.37751 .39103 L
.37882 .39188 L
.38013 .39274 L
.38144 .39358 L
.38275 .39443 L
.38406 .39528 L
.38537 .39612 L
.38668 .39696 L
.38799 .3978 L
.3893 .39864 L
.39061 .39947 L
.39192 .40031 L
.39323 .40114 L
.39454 .40197 L
.39585 .4028 L
.39716 .40363 L
.39847 .40445 L
.39978 .40528 L
.40109 .4061 L
.4024 .40692 L
.40371 .40774 L
.40502 .40855 L
.40633 .40937 L
.40764 .41018 L
.40895 .41099 L
.41026 .4118 L
.41157 .41261 L
.41288 .41342 L
.41419 .41422 L
.4155 .41503 L
Mistroke
.41681 .41583 L
.41812 .41663 L
.41943 .41743 L
.42074 .41822 L
.42205 .41902 L
.42336 .41981 L
.42467 .4206 L
.42598 .42139 L
.42729 .42218 L
.4286 .42297 L
.42991 .42375 L
.43122 .42454 L
.43253 .42532 L
.43384 .4261 L
.43515 .42687 L
.43646 .42765 L
.43777 .42843 L
.43908 .4292 L
.44039 .42997 L
.4417 .43074 L
.44301 .43151 L
.44432 .43228 L
.44563 .43304 L
.44694 .4338 L
.44825 .43457 L
.44956 .43533 L
.45087 .43608 L
.45218 .43684 L
.45349 .4376 L
.4548 .43835 L
.45611 .4391 L
.45742 .43985 L
.45873 .4406 L
.46004 .44135 L
.46135 .44209 L
.46266 .44284 L
.46397 .44358 L
.46528 .44432 L
.46659 .44506 L
.4679 .4458 L
.46921 .44654 L
.47052 .44727 L
.47183 .448 L
.47314 .44873 L
.47445 .44946 L
.47576 .45019 L
.47707 .45092 L
.47838 .45164 L
.47969 .45237 L
.481 .45309 L
Mistroke
.48231 .45381 L
.48362 .45453 L
.48493 .45524 L
.48624 .45596 L
.48755 .45667 L
.48886 .45739 L
.49017 .4581 L
.49148 .45881 L
.49279 .45951 L
.4941 .46022 L
.49541 .46092 L
.49672 .46163 L
.49803 .46233 L
.49934 .46303 L
.50066 .46373 L
.50197 .46442 L
.50328 .46512 L
.50459 .46581 L
.5059 .4665 L
.50721 .46719 L
.50852 .46788 L
.50983 .46857 L
.51114 .46926 L
.51245 .46994 L
.51376 .47062 L
.51507 .4713 L
.51638 .47198 L
.51769 .47266 L
.519 .47334 L
.52031 .47401 L
.52162 .47469 L
.52293 .47536 L
.52424 .47603 L
.52555 .4767 L
.52686 .47737 L
.52817 .47803 L
.52948 .47869 L
.53079 .47936 L
.5321 .48002 L
.53341 .48068 L
.53472 .48134 L
.53603 .48199 L
.53734 .48265 L
.53865 .4833 L
.53996 .48395 L
.54127 .4846 L
.54258 .48525 L
.54389 .4859 L
.5452 .48654 L
.54651 .48719 L
Mistroke
.54782 .48783 L
.54913 .48847 L
.55044 .48911 L
.55175 .48975 L
.55306 .49038 L
.55437 .49102 L
.55568 .49165 L
.55699 .49228 L
.5583 .49291 L
.55961 .49354 L
.56092 .49417 L
.56223 .49479 L
.56354 .49542 L
.56485 .49604 L
.56616 .49666 L
.56747 .49728 L
.56878 .4979 L
.57009 .49851 L
.5714 .49913 L
.57271 .49974 L
.57402 .50035 L
.57533 .50096 L
.57664 .50157 L
.57795 .50217 L
.57926 .50278 L
.58057 .50338 L
.58188 .50398 L
.58319 .50458 L
.5845 .50518 L
.58581 .50578 L
.58712 .50638 L
.58843 .50697 L
.58974 .50756 L
.59105 .50815 L
.59236 .50874 L
.59367 .50933 L
.59498 .50992 L
.59629 .5105 L
.5976 .51109 L
.59891 .51167 L
.60022 .51225 L
.60153 .51282 L
.60284 .5134 L
.60415 .51398 L
.60546 .51455 L
.60677 .51512 L
.60808 .51569 L
.60939 .51626 L
.6107 .51683 L
.61201 .51739 L
Mistroke
.61332 .51796 L
.61463 .51852 L
.61594 .51908 L
.61725 .51964 L
.61856 .5202 L
.61987 .52076 L
.62118 .52131 L
.62249 .52186 L
.6238 .52241 L
.62511 .52296 L
.62642 .52351 L
.62773 .52406 L
.62904 .5246 L
.63035 .52515 L
.63166 .52569 L
.63297 .52623 L
.63428 .52677 L
.63559 .5273 L
.6369 .52784 L
.63821 .52837 L
.63952 .52891 L
.64083 .52944 L
.64214 .52996 L
.64345 .53049 L
.64476 .53102 L
.64607 .53154 L
.64738 .53206 L
.64869 .53258 L
.65 .5331 L
.65131 .53362 L
.65262 .53414 L
.65393 .53465 L
.65524 .53516 L
.65655 .53567 L
.65786 .53618 L
.65917 .53669 L
.66048 .5372 L
.66179 .5377 L
.6631 .5382 L
.66441 .5387 L
.66572 .5392 L
.66703 .5397 L
.66834 .5402 L
.66965 .54069 L
.67096 .54118 L
.67227 .54168 L
.67358 .54216 L
.67489 .54265 L
.6762 .54314 L
.67751 .54362 L
Mistroke
.67882 .54411 L
.68013 .54459 L
.68144 .54507 L
.68275 .54554 L
.68406 .54602 L
.68537 .54649 L
.68668 .54697 L
.68799 .54744 L
.6893 .54791 L
.69061 .54837 L
.69192 .54884 L
.69323 .5493 L
.69454 .54976 L
.69585 .55023 L
.69716 .55068 L
.69847 .55114 L
.69978 .5516 L
.70109 .55205 L
.7024 .5525 L
.70371 .55295 L
.70502 .5534 L
.70633 .55385 L
.70764 .55429 L
.70895 .55474 L
.71026 .55518 L
.71157 .55562 L
.71288 .55606 L
.71419 .55649 L
.7155 .55693 L
.71681 .55736 L
.71812 .55779 L
.71943 .55822 L
.72074 .55865 L
.72205 .55907 L
.72336 .5595 L
.72467 .55992 L
.72598 .56034 L
.72729 .56076 L
.7286 .56117 L
.72991 .56159 L
.73122 .562 L
.73253 .56241 L
.73384 .56282 L
.73515 .56323 L
.73646 .56364 L
.73777 .56404 L
.73908 .56444 L
.74039 .56485 L
.7417 .56524 L
.74301 .56564 L
Mistroke
.74432 .56604 L
.74563 .56643 L
.74694 .56682 L
.74825 .56721 L
.74956 .5676 L
.75087 .56798 L
.75218 .56837 L
.75349 .56875 L
.7548 .56913 L
.75611 .56951 L
.75742 .56989 L
.75873 .57026 L
.76004 .57064 L
.76135 .57101 L
.76266 .57138 L
.76397 .57174 L
.76528 .57211 L
.76659 .57247 L
.7679 .57283 L
.76921 .57319 L
.77052 .57355 L
.77183 .57391 L
.77314 .57426 L
.77445 .57461 L
.77576 .57497 L
.77707 .57531 L
.77838 .57566 L
.77969 .57601 L
.781 .57635 L
.78231 .57669 L
.78362 .57703 L
.78493 .57736 L
.78624 .5777 L
.78755 .57803 L
.78886 .57836 L
.79017 .57869 L
.79148 .57902 L
.79279 .57935 L
.7941 .57967 L
.79541 .57999 L
.79672 .58031 L
.79803 .58063 L
.79934 .58094 L
.80065 .58126 L
.80196 .58157 L
.80327 .58188 L
.80458 .58218 L
.80589 .58249 L
.8072 .58279 L
.80851 .58309 L
Mistroke
.80982 .58339 L
.81113 .58369 L
.81244 .58399 L
.81375 .58428 L
.81506 .58457 L
.81637 .58486 L
.81768 .58515 L
.81899 .58543 L
.8203 .58572 L
.82161 .586 L
.82292 .58628 L
.82423 .58655 L
.82554 .58683 L
.82685 .5871 L
.82816 .58737 L
.82947 .58764 L
.83078 .58791 L
.83209 .58817 L
.8334 .58843 L
.83471 .5887 L
.83602 .58895 L
.83733 .58921 L
.83864 .58946 L
.83995 .58972 L
.84126 .58997 L
.84257 .59021 L
.84388 .59046 L
.84519 .5907 L
.8465 .59094 L
.84781 .59118 L
.84912 .59142 L
.85043 .59165 L
.85174 .59189 L
.85305 .59212 L
.85436 .59235 L
.85567 .59257 L
.85698 .5928 L
.85829 .59302 L
.8596 .59324 L
.86091 .59345 L
.86222 .59367 L
.86353 .59388 L
.86484 .59409 L
.86615 .5943 L
.86746 .59451 L
.86877 .59471 L
.87008 .59491 L
.87139 .59511 L
.8727 .59531 L
.87401 .59551 L
Mistroke
.87532 .5957 L
.87663 .59589 L
.87794 .59608 L
.87925 .59626 L
.88056 .59645 L
.88187 .59663 L
.88318 .59681 L
.88449 .59699 L
.8858 .59716 L
.88711 .59733 L
.88842 .5975 L
.88973 .59767 L
.89104 .59784 L
.89235 .598 L
.89366 .59816 L
.89497 .59832 L
.89628 .59847 L
.89759 .59863 L
.8989 .59878 L
.90021 .59893 L
.90152 .59907 L
.90283 .59922 L
.90414 .59936 L
.90545 .5995 L
.90676 .59964 L
.90807 .59977 L
.90938 .5999 L
.91069 .60003 L
.912 .60016 L
.91331 .60029 L
.91462 .60041 L
.91593 .60053 L
.91724 .60065 L
.91855 .60076 L
.91986 .60087 L
.92117 .60099 L
.92248 .60109 L
.92379 .6012 L
.9251 .6013 L
.92641 .6014 L
.92772 .6015 L
.92903 .6016 L
.93034 .60169 L
.93165 .60178 L
.93296 .60187 L
.93427 .60195 L
.93558 .60204 L
.93689 .60212 L
.9382 .60219 L
.93951 .60227 L
Mistroke
.94082 .60234 L
.94213 .60241 L
.94344 .60248 L
.94475 .60255 L
.94606 .60261 L
.94737 .60267 L
.94868 .60272 L
.94999 .60278 L
.9513 .60283 L
.95261 .60288 L
.95392 .60293 L
.95523 .60297 L
.95654 .60301 L
.95785 .60305 L
.95916 .60309 L
.96047 .60312 L
.96178 .60315 L
.96309 .60318 L
.9644 .60321 L
.96571 .60323 L
.96702 .60325 L
.96833 .60327 L
.96964 .60328 L
.97095 .6033 L
.97226 .60331 L
.97357 .60331 L
.97488 .60332 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0224995 0.00131002 0.194787 4.16483 [
[.1535 .18229 -9 -9 ]
[.1535 .18229 9 0 ]
[.2845 .18229 -9 -9 ]
[.2845 .18229 9 0 ]
[.4155 .18229 -9 -9 ]
[.4155 .18229 9 0 ]
[.54651 .18229 -9 -9 ]
[.54651 .18229 9 0 ]
[.67751 .18229 -9 -9 ]
[.67751 .18229 9 0 ]
[.80851 .18229 -9 -9 ]
[.80851 .18229 9 0 ]
[.93951 .18229 -9 -9 ]
[.93951 .18229 9 0 ]
[.01 .02819 -30 -4.5 ]
[.01 .02819 0 4.5 ]
[.01 .11149 -30 -4.5 ]
[.01 .11149 0 4.5 ]
[.01 .27808 -24 -4.5 ]
[.01 .27808 0 4.5 ]
[.01 .36138 -24 -4.5 ]
[.01 .36138 0 4.5 ]
[.01 .44468 -24 -4.5 ]
[.01 .44468 0 4.5 ]
[.01 .52797 -24 -4.5 ]
[.01 .52797 0 4.5 ]
[.01 .61127 -18 -4.5 ]
[.01 .61127 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1535 .19479 m
.1535 .20104 L
s
[(100)] .1535 .18229 0 1 Mshowa
.2845 .19479 m
.2845 .20104 L
s
[(200)] .2845 .18229 0 1 Mshowa
.4155 .19479 m
.4155 .20104 L
s
[(300)] .4155 .18229 0 1 Mshowa
.54651 .19479 m
.54651 .20104 L
s
[(400)] .54651 .18229 0 1 Mshowa
.67751 .19479 m
.67751 .20104 L
s
[(500)] .67751 .18229 0 1 Mshowa
.80851 .19479 m
.80851 .20104 L
s
[(600)] .80851 .18229 0 1 Mshowa
.93951 .19479 m
.93951 .20104 L
s
[(700)] .93951 .18229 0 1 Mshowa
.125 Mabswid
.0487 .19479 m
.0487 .19854 L
s
.0749 .19479 m
.0749 .19854 L
s
.1011 .19479 m
.1011 .19854 L
s
.1273 .19479 m
.1273 .19854 L
s
.1797 .19479 m
.1797 .19854 L
s
.2059 .19479 m
.2059 .19854 L
s
.2321 .19479 m
.2321 .19854 L
s
.2583 .19479 m
.2583 .19854 L
s
.3107 .19479 m
.3107 .19854 L
s
.3369 .19479 m
.3369 .19854 L
s
.3631 .19479 m
.3631 .19854 L
s
.3893 .19479 m
.3893 .19854 L
s
.4417 .19479 m
.4417 .19854 L
s
.4679 .19479 m
.4679 .19854 L
s
.4941 .19479 m
.4941 .19854 L
s
.52031 .19479 m
.52031 .19854 L
s
.57271 .19479 m
.57271 .19854 L
s
.59891 .19479 m
.59891 .19854 L
s
.62511 .19479 m
.62511 .19854 L
s
.65131 .19479 m
.65131 .19854 L
s
.70371 .19479 m
.70371 .19854 L
s
.72991 .19479 m
.72991 .19854 L
s
.75611 .19479 m
.75611 .19854 L
s
.78231 .19479 m
.78231 .19854 L
s
.83471 .19479 m
.83471 .19854 L
s
.86091 .19479 m
.86091 .19854 L
s
.88711 .19479 m
.88711 .19854 L
s
.91331 .19479 m
.91331 .19854 L
s
.96571 .19479 m
.96571 .19854 L
s
.99191 .19479 m
.99191 .19854 L
s
.25 Mabswid
0 .19479 m
1 .19479 L
s
.0225 .02819 m
.02875 .02819 L
s
[(-0.04)] .01 .02819 1 0 Mshowa
.0225 .11149 m
.02875 .11149 L
s
[(-0.02)] .01 .11149 1 0 Mshowa
.0225 .27808 m
.02875 .27808 L
s
[(0.02)] .01 .27808 1 0 Mshowa
.0225 .36138 m
.02875 .36138 L
s
[(0.04)] .01 .36138 1 0 Mshowa
.0225 .44468 m
.02875 .44468 L
s
[(0.06)] .01 .44468 1 0 Mshowa
.0225 .52797 m
.02875 .52797 L
s
[(0.08)] .01 .52797 1 0 Mshowa
.0225 .61127 m
.02875 .61127 L
s
[(0.1)] .01 .61127 1 0 Mshowa
.125 Mabswid
.0225 .04902 m
.02625 .04902 L
s
.0225 .06984 m
.02625 .06984 L
s
.0225 .09067 m
.02625 .09067 L
s
.0225 .13231 m
.02625 .13231 L
s
.0225 .15314 m
.02625 .15314 L
s
.0225 .17396 m
.02625 .17396 L
s
.0225 .21561 m
.02625 .21561 L
s
.0225 .23644 m
.02625 .23644 L
s
.0225 .25726 m
.02625 .25726 L
s
.0225 .29891 m
.02625 .29891 L
s
.0225 .31973 m
.02625 .31973 L
s
.0225 .34056 m
.02625 .34056 L
s
.0225 .3822 m
.02625 .3822 L
s
.0225 .40303 m
.02625 .40303 L
s
.0225 .42385 m
.02625 .42385 L
s
.0225 .4655 m
.02625 .4655 L
s
.0225 .48633 m
.02625 .48633 L
s
.0225 .50715 m
.02625 .50715 L
s
.0225 .5488 m
.02625 .5488 L
s
.0225 .56962 m
.02625 .56962 L
s
.0225 .59045 m
.02625 .59045 L
s
.0225 .00737 m
.02625 .00737 L
s
.25 Mabswid
.0225 0 m
.0225 .61803 L
s
1 .5 0 r
.5 Mabswid
.02381 .1776 m
.02512 .22108 L
.02643 .24515 L
.02774 .2605 L
.02905 .27963 L
.03036 .29159 L
.03167 .31385 L
.03298 .32369 L
.03429 .32698 L
.0356 .34102 L
.03691 .32004 L
.03822 .33859 L
.03953 .35662 L
.04084 .36844 L
.04215 .37409 L
.04346 .37933 L
.04477 .38419 L
.04608 .38869 L
.04739 .40431 L
.0487 .40243 L
.05001 .4117 L
.05132 .38632 L
.05263 .38357 L
.05394 .39202 L
.05525 .38304 L
.05656 .39673 L
.05787 .40447 L
.05918 .40626 L
.06049 .41929 L
.0618 .43784 L
.06311 .45047 L
.06442 .46291 L
.06573 .4809 L
.06704 .49297 L
.06835 .49341 L
.06966 .50515 L
.07097 .51672 L
.07228 .5224 L
.07359 .52219 L
.0749 .52184 L
.07621 .52707 L
.07752 .53215 L
.07883 .51991 L
.08014 .52472 L
.08145 .51794 L
.08276 .53394 L
.08407 .54409 L
.08538 .5312 L
.08669 .53537 L
.088 .52796 L
Mistroke
.08931 .52617 L
.09062 .5128 L
.09193 .51651 L
.09324 .53157 L
.09455 .5236 L
.09586 .53844 L
.09717 .53027 L
.09848 .53917 L
.09979 .54798 L
.1011 .5395 L
.10241 .53665 L
.10372 .52798 L
.10503 .52494 L
.10634 .539 L
.10765 .54724 L
.10896 .55539 L
.11027 .54053 L
.11158 .5485 L
.11289 .55066 L
.1142 .55274 L
.11551 .56619 L
.11682 .5681 L
.11813 .58138 L
.11944 .56594 L
.12075 .57334 L
.12206 .58067 L
.12337 .57645 L
.12468 .57217 L
.12599 .56208 L
.1273 .54618 L
.12861 .54741 L
.12992 .54856 L
.13123 .55536 L
.13254 .56783 L
.13385 .56877 L
.13516 .56964 L
.13647 .57045 L
.13778 .56546 L
.13909 .57186 L
.1404 .56673 L
.14171 .56155 L
.14302 .5563 L
.14433 .56244 L
.14564 .57425 L
.14695 .56882 L
.14826 .57478 L
.14957 .58068 L
.15088 .58079 L
.15219 .58084 L
.1535 .56938 L
Mistroke
.15481 .57504 L
.15612 .58065 L
.15743 .5862 L
.15874 .58023 L
.16005 .5914 L
.16136 .58533 L
.16267 .59639 L
.16398 .58447 L
.16529 .57824 L
.1666 .58341 L
.16791 .57706 L
.16922 .57067 L
.17053 .58141 L
.17184 .5921 L
.17315 .57983 L
.17446 .57896 L
.17577 .56658 L
.17708 .56561 L
.17839 .5646 L
.1797 .57499 L
.18101 .5796 L
.18232 .5899 L
.18363 .59442 L
.18494 .59316 L
.18625 .60332 L
.18756 .60197 L
.18887 .57766 L
.19018 .58195 L
.19149 .57474 L
.1928 .56175 L
.19411 .54299 L
.19542 .54137 L
.19673 .53398 L
.19804 .52655 L
.19935 .53626 L
.20066 .53446 L
.20197 .53836 L
.20328 .54221 L
.20459 .5403 L
.2059 .54407 L
.20721 .55352 L
.20852 .56294 L
.20983 .56659 L
.21114 .57592 L
.21245 .5623 L
.21376 .5601 L
.21507 .56359 L
.21638 .56131 L
.21769 .57045 L
.219 .57382 L
Mistroke
.22031 .55996 L
.22162 .55753 L
.22293 .55505 L
.22424 .55254 L
.22555 .54427 L
.22686 .53595 L
.22817 .53333 L
.22948 .54213 L
.23079 .55089 L
.2321 .55389 L
.23341 .55685 L
.23472 .54832 L
.23603 .55121 L
.23734 .55406 L
.23865 .55688 L
.23996 .55966 L
.24127 .56241 L
.24258 .56513 L
.24389 .57354 L
.2452 .57619 L
.24651 .58453 L
.24782 .58138 L
.24913 .58392 L
.25044 .58071 L
.25175 .58319 L
.25306 .59136 L
.25437 .58805 L
.25568 .5847 L
.25699 .58132 L
.2583 .58363 L
.25961 .58592 L
.26092 .57671 L
.26223 .55029 L
.26354 .55821 L
.26485 .56037 L
.26616 .56249 L
.26747 .55313 L
.26878 .53801 L
.27009 .53432 L
.2714 .53632 L
.27271 .52684 L
.27402 .53451 L
.27533 .54215 L
.27664 .53831 L
.27795 .5287 L
.27926 .51907 L
.28057 .52659 L
.28188 .52836 L
.28319 .52437 L
.2845 .52608 L
Mistroke
.28581 .52776 L
.28712 .51222 L
.28843 .50238 L
.28974 .50971 L
.29105 .51127 L
.29236 .51854 L
.29367 .52578 L
.29498 .52153 L
.29629 .5058 L
.2976 .50149 L
.29891 .49716 L
.30022 .48708 L
.30153 .48269 L
.30284 .48401 L
.30415 .49103 L
.30546 .48657 L
.30677 .49353 L
.30808 .50047 L
.30939 .50166 L
.3107 .50281 L
.31201 .49822 L
.31332 .49359 L
.31463 .49467 L
.31594 .49573 L
.31725 .50249 L
.31856 .49203 L
.31987 .49874 L
.32118 .50542 L
.32249 .51207 L
.3238 .51298 L
.32511 .50239 L
.32642 .49179 L
.32773 .49262 L
.32904 .49342 L
.33035 .48847 L
.33166 .49495 L
.33297 .49568 L
.33428 .48492 L
.33559 .47988 L
.3369 .48626 L
.33821 .49262 L
.33952 .49896 L
.34083 .49954 L
.34214 .49438 L
.34345 .48346 L
.34476 .4897 L
.34607 .48446 L
.34738 .48493 L
.34869 .48537 L
.35 .48006 L
Mistroke
.35131 .48046 L
.35262 .48084 L
.35393 .48119 L
.35524 .47006 L
.35655 .45891 L
.35786 .46492 L
.35917 .45946 L
.36048 .4597 L
.36179 .44846 L
.3631 .44865 L
.36441 .44882 L
.36572 .43752 L
.36703 .44337 L
.36834 .43775 L
.36965 .43784 L
.37096 .4379 L
.37227 .43221 L
.37358 .43796 L
.37489 .44369 L
.3762 .44367 L
.37751 .44362 L
.37882 .44356 L
.38013 .4492 L
.38144 .4491 L
.38275 .4547 L
.38406 .46028 L
.38537 .46583 L
.38668 .47137 L
.38799 .47689 L
.3893 .47666 L
.39061 .48213 L
.39192 .48186 L
.39323 .48157 L
.39454 .48125 L
.39585 .48092 L
.39716 .48629 L
.39847 .47446 L
.39978 .4798 L
.40109 .47365 L
.4024 .47895 L
.40371 .48422 L
.40502 .48375 L
.40633 .48899 L
.40764 .4942 L
.40895 .4994 L
.41026 .49312 L
.41157 .49255 L
.41288 .48623 L
.41419 .49135 L
.4155 .49644 L
Mistroke
.41681 .4958 L
.41812 .4894 L
.41943 .49444 L
.42074 .49374 L
.42205 .49874 L
.42336 .498 L
.42467 .49724 L
.42598 .50218 L
.42729 .50138 L
.4286 .50057 L
.42991 .50546 L
.43122 .49887 L
.43253 .50373 L
.43384 .50857 L
.43515 .51339 L
.43646 .51819 L
.43777 .51724 L
.43908 .522 L
.44039 .52675 L
.4417 .53148 L
.44301 .52473 L
.44432 .52369 L
.44563 .52264 L
.44694 .52157 L
.44825 .51475 L
.44956 .50218 L
.45087 .50679 L
.45218 .51137 L
.45349 .51594 L
.4548 .52049 L
.45611 .52502 L
.45742 .52954 L
.45873 .52831 L
.46004 .53279 L
.46135 .53726 L
.46266 .53598 L
.46397 .54041 L
.46528 .53909 L
.46659 .53203 L
.4679 .52495 L
.46921 .52358 L
.47052 .52793 L
.47183 .53226 L
.47314 .53084 L
.47445 .52941 L
.47576 .5165 L
.47707 .52076 L
.47838 .51928 L
.47969 .51778 L
.481 .52199 L
Mistroke
.48231 .52618 L
.48362 .51891 L
.48493 .51734 L
.48624 .52149 L
.48755 .52562 L
.48886 .524 L
.49017 .52237 L
.49148 .52073 L
.49279 .51906 L
.4941 .51739 L
.49541 .51569 L
.49672 .50252 L
.49803 .49507 L
.49934 .49333 L
.50066 .4973 L
.50197 .49552 L
.50328 .49946 L
.50459 .49193 L
.5059 .49011 L
.50721 .494 L
.50852 .49215 L
.50983 .47883 L
.51114 .47694 L
.51245 .46932 L
.51376 .46167 L
.51507 .46547 L
.51638 .46926 L
.51769 .47303 L
.519 .47678 L
.52031 .47479 L
.52162 .47852 L
.52293 .4765 L
.52424 .47446 L
.52555 .47814 L
.52686 .48181 L
.52817 .474 L
.52948 .47763 L
.53079 .47552 L
.5321 .4734 L
.53341 .47699 L
.53472 .48056 L
.53603 .47839 L
.53734 .47621 L
.53865 .47974 L
.53996 .48326 L
.54127 .48676 L
.54258 .47879 L
.54389 .47654 L
.5452 .47999 L
.54651 .47198 L
Mistroke
.54782 .46968 L
.54913 .46737 L
.55044 .46504 L
.55175 .4627 L
.55306 .46607 L
.55437 .46943 L
.55568 .46705 L
.55699 .45319 L
.5583 .45651 L
.55961 .45408 L
.56092 .45164 L
.56223 .44919 L
.56354 .44672 L
.56485 .44996 L
.56616 .4532 L
.56747 .45069 L
.56878 .45389 L
.57009 .45135 L
.5714 .4488 L
.57271 .45197 L
.57402 .45512 L
.57533 .45825 L
.57664 .46138 L
.57795 .45876 L
.57926 .45039 L
.58057 .44775 L
.58188 .43363 L
.58319 .43096 L
.5845 .434 L
.58581 .43703 L
.58712 .44004 L
.58843 .44304 L
.58974 .44603 L
.59105 .44901 L
.59236 .45197 L
.59367 .45492 L
.59498 .45212 L
.59629 .44359 L
.5976 .4465 L
.59891 .44939 L
.60022 .45228 L
.60153 .44942 L
.60284 .45228 L
.60415 .45512 L
.60546 .45795 L
.60677 .45504 L
.60808 .45785 L
.60939 .46064 L
.6107 .45769 L
.61201 .46046 L
Mistroke
.61332 .45176 L
.61463 .4545 L
.61594 .45723 L
.61725 .45421 L
.61856 .45119 L
.61987 .44815 L
.62118 .45083 L
.62249 .43058 L
.6238 .43323 L
.62511 .43587 L
.62642 .4385 L
.62773 .43539 L
.62904 .43799 L
.63035 .42913 L
.63166 .42598 L
.63297 .42854 L
.63428 .42537 L
.63559 .42791 L
.6369 .43044 L
.63821 .43296 L
.63952 .43546 L
.64083 .43795 L
.64214 .4347 L
.64345 .43717 L
.64476 .43963 L
.64607 .44207 L
.64738 .42732 L
.64869 .42974 L
.65 .42642 L
.65131 .42309 L
.65262 .41401 L
.65393 .40493 L
.65524 .40156 L
.65655 .40391 L
.65786 .40624 L
.65917 .40857 L
.66048 .41088 L
.66179 .41318 L
.6631 .41547 L
.66441 .41775 L
.66572 .42002 L
.66703 .41654 L
.66834 .40733 L
.66965 .40956 L
.67096 .41178 L
.67227 .40826 L
.67358 .41045 L
.67489 .41264 L
.6762 .40908 L
.67751 .41124 L
Mistroke
.67882 .40766 L
.68013 .39835 L
.68144 .40047 L
.68275 .40259 L
.68406 .40469 L
.68537 .40679 L
.68668 .40887 L
.68799 .41094 L
.6893 .413 L
.69061 .41505 L
.69192 .41708 L
.69323 .41338 L
.69454 .41539 L
.69585 .4174 L
.69716 .41939 L
.69847 .41564 L
.69978 .41761 L
.70109 .41384 L
.7024 .41006 L
.70371 .41199 L
.70502 .40819 L
.70633 .40437 L
.70764 .40628 L
.70895 .39671 L
.71026 .39859 L
.71157 .39474 L
.71288 .39659 L
.71419 .39844 L
.7155 .40028 L
.71681 .39638 L
.71812 .38674 L
.71943 .38854 L
.72074 .37888 L
.72205 .38066 L
.72336 .37098 L
.72467 .37274 L
.72598 .37449 L
.72729 .3705 L
.7286 .37223 L
.72991 .37395 L
.73122 .37566 L
.73253 .3659 L
.73384 .3504 L
.73515 .35208 L
.73646 .35375 L
.73777 .3554 L
.73908 .35705 L
.74039 .35296 L
.7417 .35458 L
.74301 .35619 L
Mistroke
.74432 .3578 L
.74563 .35366 L
.74694 .35524 L
.74825 .35682 L
.74956 .35838 L
.75087 .3542 L
.75218 .35574 L
.75349 .35727 L
.7548 .3588 L
.75611 .36031 L
.75742 .36181 L
.75873 .3633 L
.76004 .35905 L
.76135 .35479 L
.76266 .35625 L
.76397 .3577 L
.76528 .35341 L
.76659 .35484 L
.7679 .35626 L
.76921 .35766 L
.77052 .34761 L
.77183 .33754 L
.77314 .33891 L
.77445 .34028 L
.77576 .33018 L
.77707 .33153 L
.77838 .32714 L
.77969 .32847 L
.781 .32406 L
.78231 .32537 L
.78362 .32667 L
.78493 .32796 L
.78624 .32351 L
.78755 .32478 L
.78886 .32604 L
.79017 .32729 L
.79148 .32853 L
.79279 .32403 L
.7941 .32525 L
.79541 .32646 L
.79672 .32193 L
.79803 .31167 L
.79934 .31285 L
.80065 .31402 L
.80196 .31518 L
.80327 .31634 L
.80458 .31748 L
.80589 .31861 L
.8072 .31401 L
.80851 .31512 L
Mistroke
.80982 .31623 L
.81113 .31732 L
.81244 .31841 L
.81375 .31375 L
.81506 .31482 L
.81637 .31588 L
.81768 .31693 L
.81899 .31224 L
.8203 .31326 L
.82161 .30855 L
.82292 .30956 L
.82423 .30484 L
.82554 .30583 L
.82685 .30681 L
.82816 .30778 L
.82947 .30875 L
.83078 .3097 L
.83209 .31064 L
.8334 .31158 L
.83471 .3125 L
.83602 .30769 L
.83733 .30287 L
.83864 .30377 L
.83995 .2932 L
.84126 .28835 L
.84257 .28922 L
.84388 .27863 L
.84519 .27375 L
.8465 .27459 L
.84781 .2697 L
.84912 .27052 L
.85043 .27134 L
.85174 .27215 L
.85305 .26721 L
.85436 .268 L
.85567 .26305 L
.85698 .26382 L
.85829 .26459 L
.8596 .26534 L
.86091 .26608 L
.86222 .26682 L
.86353 .26754 L
.86484 .26253 L
.86615 .26324 L
.86746 .26394 L
.86877 .26463 L
.87008 .26531 L
.87139 .26598 L
.8727 .26664 L
.87401 .2673 L
Mistroke
.87532 .26222 L
.87663 .26285 L
.87794 .26348 L
.87925 .2641 L
.88056 .26471 L
.88187 .26531 L
.88318 .26591 L
.88449 .26649 L
.8858 .26707 L
.88711 .26763 L
.88842 .26819 L
.88973 .26301 L
.89104 .26355 L
.89235 .26409 L
.89366 .26461 L
.89497 .26512 L
.89628 .26563 L
.89759 .26613 L
.8989 .26089 L
.90021 .24991 L
.90152 .24465 L
.90283 .23939 L
.90414 .23984 L
.90545 .24029 L
.90676 .235 L
.90807 .23543 L
.90938 .23012 L
.91069 .23053 L
.912 .23094 L
.91331 .23133 L
.91462 .23172 L
.91593 .2321 L
.91724 .23247 L
.91855 .2271 L
.91986 .22746 L
.92117 .2278 L
.92248 .22814 L
.92379 .22847 L
.9251 .22879 L
.92641 .2291 L
.92772 .2294 L
.92903 .2297 L
.93034 .22998 L
.93165 .22453 L
.93296 .2248 L
.93427 .22507 L
.93558 .22532 L
.93689 .21984 L
.9382 .22007 L
.93951 .2203 L
Mistroke
.94082 .22052 L
.94213 .22074 L
.94344 .22094 L
.94475 .22114 L
.94606 .22132 L
.94737 .2215 L
.94868 .21595 L
.94999 .21611 L
.9513 .21627 L
.95261 .21642 L
.95392 .21655 L
.95523 .21669 L
.95654 .21108 L
.95785 .2112 L
.95916 .2113 L
.96047 .2114 L
.96178 .20004 L
.96309 .20012 L
.9644 .2002 L
.96571 .19453 L
.96702 .19459 L
.96833 .19465 L
.96964 .19469 L
.97095 .19472 L
.97226 .19475 L
.97357 .19477 L
.97488 .19478 L
.97619 .19479 L
Mfstroke
0 .5 1 r
.02381 .1776 m
.02512 .21231 L
.02643 .22947 L
.02774 .23859 L
.02905 .25195 L
.03036 .25847 L
.03167 .27556 L
.03298 .28046 L
.03429 .279 L
.0356 .28844 L
.03691 .26302 L
.03822 .27726 L
.03953 .2911 L
.04084 .29885 L
.04215 .30053 L
.04346 .30189 L
.04477 .30296 L
.04608 .30376 L
.04739 .31575 L
.0487 .31032 L
.05001 .31611 L
.05132 .2873 L
.05263 .28121 L
.05394 .28636 L
.05525 .27415 L
.05656 .28466 L
.05787 .28927 L
.05918 .28798 L
.06049 .29799 L
.0618 .31356 L
.06311 .32326 L
.06442 .33281 L
.06573 .34795 L
.06704 .35722 L
.06835 .3549 L
.06966 .36391 L
.07097 .37279 L
.07228 .37582 L
.07359 .37301 L
.0749 .37007 L
.07621 .37276 L
.07752 .37533 L
.07883 .36061 L
.08014 .36298 L
.08145 .35378 L
.08276 .3674 L
.08407 .37519 L
.08538 .35997 L
.08669 .36184 L
.088 .35216 L
Mistroke
.08931 .34813 L
.09062 .33254 L
.09193 .33406 L
.09324 .34695 L
.09455 .33684 L
.09586 .34957 L
.09717 .3393 L
.09848 .34614 L
.09979 .3529 L
.1011 .3424 L
.10241 .33755 L
.10372 .3269 L
.10503 .32191 L
.10634 .33403 L
.10765 .34036 L
.10896 .34661 L
.11027 .32989 L
.11158 .33601 L
.11289 .33634 L
.1142 .3366 L
.11551 .34825 L
.11682 .34839 L
.11813 .35992 L
.11944 .34275 L
.12075 .34843 L
.12206 .35405 L
.12337 .34816 L
.12468 .34221 L
.12599 .33047 L
.1273 .31294 L
.12861 .31255 L
.12992 .3121 L
.13123 .31733 L
.13254 .32823 L
.13385 .32762 L
.13516 .32696 L
.13647 .32625 L
.13778 .31976 L
.13909 .32467 L
.1404 .31808 L
.14171 .31144 L
.14302 .30475 L
.14433 .30946 L
.14564 .31986 L
.14695 .31303 L
.14826 .3176 L
.14957 .32213 L
.15088 .32089 L
.15219 .3196 L
.1535 .30681 L
Mistroke
.15481 .31115 L
.15612 .31546 L
.15743 .31972 L
.15874 .31248 L
.16005 .32239 L
.16136 .31506 L
.16267 .32488 L
.16398 .31175 L
.16529 .3043 L
.1666 .30827 L
.16791 .30074 L
.16922 .29317 L
.17053 .30274 L
.17184 .31228 L
.17315 .29887 L
.17446 .29687 L
.17577 .28338 L
.17708 .2813 L
.17839 .27919 L
.1797 .2885 L
.18101 .29204 L
.18232 .30128 L
.18363 .30475 L
.18494 .30246 L
.18625 .31158 L
.18756 .30922 L
.18887 .2839 L
.19018 .2872 L
.19149 .279 L
.1928 .26503 L
.19411 .24531 L
.19542 .24274 L
.19673 .2344 L
.19804 .22603 L
.19935 .23482 L
.20066 .23211 L
.20197 .2351 L
.20328 .23806 L
.20459 .23526 L
.2059 .23815 L
.20721 .24675 L
.20852 .25531 L
.20983 .25811 L
.21114 .2666 L
.21245 .25216 L
.21376 .24914 L
.21507 .25181 L
.21638 .24873 L
.21769 .25708 L
.219 .25967 L
Mistroke
.22031 .24504 L
.22162 .24184 L
.22293 .23861 L
.22424 .23535 L
.22555 .22634 L
.22686 .21729 L
.22817 .21395 L
.22948 .22203 L
.23079 .23009 L
.2321 .23239 L
.23341 .23467 L
.23472 .22546 L
.23603 .22767 L
.23734 .22987 L
.23865 .23203 L
.23996 .23417 L
.24127 .23628 L
.24258 .23836 L
.24389 .24615 L
.2452 .24818 L
.24651 .25592 L
.24782 .25217 L
.24913 .25412 L
.25044 .25032 L
.25175 .25223 L
.25306 .25983 L
.25437 .25596 L
.25568 .25206 L
.25699 .24813 L
.2583 .24991 L
.25961 .25167 L
.26092 .24194 L
.26223 .215 L
.26354 .22241 L
.26485 .22407 L
.26616 .2257 L
.26747 .21585 L
.26878 .20025 L
.27009 .19608 L
.2714 .19762 L
.27271 .18768 L
.27402 .1949 L
.27533 .2021 L
.27664 .19782 L
.27795 .18778 L
.27926 .17773 L
.28057 .18483 L
.28188 .18619 L
.28319 .18179 L
.2845 .1831 L
Mistroke
.28581 .18439 L
.28712 .16847 L
.28843 .15826 L
.28974 .16522 L
.29105 .16642 L
.29236 .17333 L
.29367 .18021 L
.29498 .17562 L
.29629 .15955 L
.2976 .15492 L
.29891 .15026 L
.30022 .13986 L
.30153 .13516 L
.30284 .13618 L
.30415 .1429 L
.30546 .13814 L
.30677 .14482 L
.30808 .15147 L
.30939 .15238 L
.3107 .15327 L
.31201 .14841 L
.31332 .14353 L
.31463 .14436 L
.31594 .14517 L
.31725 .15169 L
.31856 .141 L
.31987 .14748 L
.32118 .15394 L
.32249 .16038 L
.3238 .16107 L
.32511 .15029 L
.32642 .13949 L
.32773 .14012 L
.32904 .14074 L
.33035 .1356 L
.33166 .14191 L
.33297 .14247 L
.33428 .13155 L
.33559 .12635 L
.3369 .13258 L
.33821 .1388 L
.33952 .14499 L
.34083 .14544 L
.34214 .14014 L
.34345 .1291 L
.34476 .13522 L
.34607 .12987 L
.34738 .13023 L
.34869 .13057 L
.35 .12516 L
Mistroke
.35131 .12547 L
.35262 .12576 L
.35393 .12603 L
.35524 .11482 L
.35655 .1036 L
.35786 .10955 L
.35917 .10402 L
.36048 .1042 L
.36179 .09291 L
.3631 .09306 L
.36441 .09319 L
.36572 .08185 L
.36703 .08768 L
.36834 .08203 L
.36965 .0821 L
.37096 .08215 L
.37227 .07645 L
.37358 .0822 L
.37489 .08792 L
.3762 .08791 L
.37751 .08787 L
.37882 .08782 L
.38013 .09349 L
.38144 .0934 L
.38275 .09903 L
.38406 .10465 L
.38537 .11025 L
.38668 .11583 L
.38799 .1214 L
.3893 .12122 L
.39061 .12675 L
.39192 .12654 L
.39323 .12632 L
.39454 .12608 L
.39585 .12582 L
.39716 .13128 L
.39847 .11953 L
.39978 .12496 L
.40109 .11891 L
.4024 .12431 L
.40371 .12969 L
.40502 .12932 L
.40633 .13467 L
.40764 .14001 L
.40895 .14533 L
.41026 .13918 L
.41157 .13874 L
.41288 .13255 L
.41419 .13782 L
.4155 .14306 L
Mistroke
.41681 .14256 L
.41812 .13632 L
.41943 .14152 L
.42074 .14098 L
.42205 .14615 L
.42336 .14558 L
.42467 .145 L
.42598 .15013 L
.42729 .14951 L
.4286 .14889 L
.42991 .15397 L
.43122 .14759 L
.43253 .15265 L
.43384 .15769 L
.43515 .16272 L
.43646 .16774 L
.43777 .16701 L
.43908 .172 L
.44039 .17697 L
.4417 .18193 L
.44301 .17542 L
.44432 .17462 L
.44563 .17381 L
.44694 .17299 L
.44825 .16643 L
.44956 .15412 L
.45087 .15898 L
.45218 .16383 L
.45349 .16867 L
.4548 .1735 L
.45611 .17831 L
.45742 .1831 L
.45873 .18216 L
.46004 .18693 L
.46135 .19169 L
.46266 .19071 L
.46397 .19544 L
.46528 .19443 L
.46659 .18767 L
.4679 .18091 L
.46921 .17986 L
.47052 .18453 L
.47183 .18918 L
.47314 .18809 L
.47445 .18699 L
.47576 .17442 L
.47707 .17902 L
.47838 .17788 L
.47969 .17673 L
.481 .1813 L
Mistroke
.48231 .18585 L
.48362 .17893 L
.48493 .17773 L
.48624 .18224 L
.48755 .18674 L
.48886 .1855 L
.49017 .18425 L
.49148 .18299 L
.49279 .18171 L
.4941 .18042 L
.49541 .17912 L
.49672 .16635 L
.49803 .1593 L
.49934 .15796 L
.50066 .16234 L
.50197 .16098 L
.50328 .16533 L
.50459 .15822 L
.5059 .15682 L
.50721 .16114 L
.50852 .15972 L
.50983 .14683 L
.51114 .14538 L
.51245 .13819 L
.51376 .131 L
.51507 .13524 L
.51638 .13948 L
.51769 .1437 L
.519 .14792 L
.52031 .14639 L
.52162 .15058 L
.52293 .14903 L
.52424 .14747 L
.52555 .15162 L
.52686 .15577 L
.52817 .14844 L
.52948 .15256 L
.53079 .15094 L
.5321 .14931 L
.53341 .1534 L
.53472 .15747 L
.53603 .15581 L
.53734 .15413 L
.53865 .15817 L
.53996 .1622 L
.54127 .16622 L
.54258 .15877 L
.54389 .15704 L
.5452 .16103 L
.54651 .15354 L
Mistroke
.54782 .15178 L
.54913 .15 L
.55044 .14821 L
.55175 .14642 L
.55306 .15034 L
.55437 .15425 L
.55568 .15241 L
.55699 .13912 L
.5583 .14299 L
.55961 .14113 L
.56092 .13926 L
.56223 .13737 L
.56354 .13548 L
.56485 .1393 L
.56616 .14311 L
.56747 .14118 L
.56878 .14497 L
.57009 .14303 L
.5714 .14107 L
.57271 .14483 L
.57402 .14858 L
.57533 .15231 L
.57664 .15604 L
.57795 .15403 L
.57926 .14628 L
.58057 .14425 L
.58188 .13075 L
.58319 .12869 L
.5845 .13236 L
.58581 .13602 L
.58712 .13966 L
.58843 .1433 L
.58974 .14692 L
.59105 .15054 L
.59236 .15414 L
.59367 .15773 L
.59498 .15559 L
.59629 .14771 L
.5976 .15127 L
.59891 .15482 L
.60022 .15837 L
.60153 .15617 L
.60284 .1597 L
.60415 .16321 L
.60546 .16672 L
.60677 .16448 L
.60808 .16797 L
.60939 .17144 L
.6107 .16918 L
.61201 .17263 L
Mistroke
.61332 .16462 L
.61463 .16805 L
.61594 .17148 L
.61725 .16917 L
.61856 .16684 L
.61987 .16451 L
.62118 .1679 L
.62249 .14836 L
.6238 .15173 L
.62511 .15508 L
.62642 .15843 L
.62773 .15604 L
.62904 .15937 L
.63035 .15123 L
.63166 .14881 L
.63297 .15212 L
.63428 .14968 L
.63559 .15296 L
.6369 .15623 L
.63821 .15949 L
.63952 .16275 L
.64083 .16599 L
.64214 .1635 L
.64345 .16672 L
.64476 .16994 L
.64607 .17315 L
.64738 .15916 L
.64869 .16235 L
.65 .1598 L
.65131 .15724 L
.65262 .14894 L
.65393 .14064 L
.65524 .13805 L
.65655 .14118 L
.65786 .14431 L
.65917 .14742 L
.66048 .15053 L
.66179 .15363 L
.6631 .15671 L
.66441 .15979 L
.66572 .16286 L
.66703 .1602 L
.66834 .15179 L
.66965 .15483 L
.67096 .15787 L
.67227 .15516 L
.67358 .15818 L
.67489 .16119 L
.6762 .15846 L
.67751 .16145 L
Mistroke
.67882 .1587 L
.68013 .15021 L
.68144 .15318 L
.68275 .15613 L
.68406 .15908 L
.68537 .16202 L
.68668 .16494 L
.68799 .16786 L
.6893 .17078 L
.69061 .17368 L
.69192 .17657 L
.69323 .17373 L
.69454 .17661 L
.69585 .17947 L
.69716 .18233 L
.69847 .17946 L
.69978 .1823 L
.70109 .1794 L
.7024 .1765 L
.70371 .17932 L
.70502 .1764 L
.70633 .17347 L
.70764 .17626 L
.70895 .16758 L
.71026 .17036 L
.71157 .1674 L
.71288 .17015 L
.71419 .1729 L
.7155 .17564 L
.71681 .17265 L
.71812 .16392 L
.71943 .16663 L
.72074 .15788 L
.72205 .16058 L
.72336 .15182 L
.72467 .1545 L
.72598 .15717 L
.72729 .15411 L
.7286 .15677 L
.72991 .15942 L
.73122 .16206 L
.73253 .15324 L
.73384 .13868 L
.73515 .1413 L
.73646 .14391 L
.73777 .14651 L
.73908 .1491 L
.74039 .14596 L
.7417 .14854 L
.74301 .15111 L
Mistroke
.74432 .15367 L
.74563 .15049 L
.74694 .15304 L
.74825 .15558 L
.74956 .1581 L
.75087 .1549 L
.75218 .15741 L
.75349 .15992 L
.7548 .16242 L
.75611 .16491 L
.75742 .16739 L
.75873 .16986 L
.76004 .1666 L
.76135 .16333 L
.76266 .16578 L
.76397 .16822 L
.76528 .16493 L
.76659 .16736 L
.7679 .16978 L
.76921 .17219 L
.77052 .16314 L
.77183 .15407 L
.77314 .15646 L
.77445 .15884 L
.77576 .14976 L
.77707 .15213 L
.77838 .14875 L
.77969 .15111 L
.781 .14772 L
.78231 .15005 L
.78362 .15238 L
.78493 .1547 L
.78624 .15129 L
.78755 .15359 L
.78886 .15589 L
.79017 .15818 L
.79148 .16046 L
.79279 .15701 L
.7941 .15927 L
.79541 .16153 L
.79672 .15806 L
.79803 .14884 L
.79934 .15108 L
.80065 .15331 L
.80196 .15553 L
.80327 .15775 L
.80458 .15996 L
.80589 .16216 L
.8072 .15862 L
.80851 .16081 L
Mistroke
.80982 .16299 L
.81113 .16516 L
.81244 .16732 L
.81375 .16375 L
.81506 .1659 L
.81637 .16804 L
.81768 .17018 L
.81899 .16657 L
.8203 .16869 L
.82161 .16508 L
.82292 .16718 L
.82423 .16355 L
.82554 .16564 L
.82685 .16773 L
.82816 .16981 L
.82947 .17188 L
.83078 .17394 L
.83209 .17599 L
.8334 .17804 L
.83471 .18008 L
.83602 .17639 L
.83733 .17269 L
.83864 .17471 L
.83995 .16526 L
.84126 .16154 L
.84257 .16354 L
.84388 .15407 L
.84519 .15033 L
.8465 .1523 L
.84781 .14855 L
.84912 .15051 L
.85043 .15247 L
.85174 .15442 L
.85305 .15063 L
.85436 .15257 L
.85567 .14877 L
.85698 .15069 L
.85829 .1526 L
.8596 .15451 L
.86091 .15641 L
.86222 .15831 L
.86353 .16019 L
.86484 .15635 L
.86615 .15822 L
.86746 .16009 L
.86877 .16195 L
.87008 .1638 L
.87139 .16565 L
.8727 .16749 L
.87401 .16932 L
Mistroke
.87532 .16542 L
.87663 .16723 L
.87794 .16905 L
.87925 .17085 L
.88056 .17265 L
.88187 .17444 L
.88318 .17623 L
.88449 .17801 L
.8858 .17978 L
.88711 .18155 L
.88842 .18331 L
.88973 .17933 L
.89104 .18107 L
.89235 .18281 L
.89366 .18455 L
.89497 .18627 L
.89628 .18799 L
.89759 .1897 L
.8989 .18568 L
.90021 .17592 L
.90152 .17188 L
.90283 .16784 L
.90414 .16952 L
.90545 .17119 L
.90676 .16713 L
.90807 .16879 L
.90938 .16472 L
.91069 .16636 L
.912 .168 L
.91331 .16964 L
.91462 .17127 L
.91593 .17289 L
.91724 .1745 L
.91855 .17038 L
.91986 .17198 L
.92117 .17358 L
.92248 .17517 L
.92379 .17675 L
.9251 .17832 L
.92641 .17989 L
.92772 .18146 L
.92903 .18301 L
.93034 .18456 L
.93165 .18038 L
.93296 .18192 L
.93427 .18345 L
.93558 .18497 L
.93689 .18076 L
.9382 .18228 L
.93951 .18378 L
Mistroke
.94082 .18528 L
.94213 .18678 L
.94344 .18826 L
.94475 .18974 L
.94606 .19122 L
.94737 .19269 L
.94868 .18842 L
.94999 .18988 L
.9513 .19133 L
.95261 .19277 L
.95392 .19421 L
.95523 .19564 L
.95654 .19134 L
.95785 .19275 L
.95916 .19417 L
.96047 .19557 L
.96178 .18552 L
.96309 .18691 L
.9644 .1883 L
.96571 .18395 L
.96702 .18533 L
.96833 .1867 L
.96964 .18806 L
.97095 .18942 L
.97226 .19077 L
.97357 .19211 L
.97488 .19345 L
.97619 .19479 L
Mfstroke
0 1 0 r
.02381 .1776 m
.02512 .19263 L
.02643 .19601 L
.02774 .19353 L
.02905 .19667 L
.03036 .19398 L
.03167 .20266 L
.03298 .1998 L
.03429 .19113 L
.0356 .19384 L
.03691 .16211 L
.03822 .17041 L
.03953 .17864 L
.04084 .18109 L
.04215 .17774 L
.04346 .17433 L
.04477 .17086 L
.04608 .16733 L
.04739 .17521 L
.0487 .16584 L
.05001 .16788 L
.05132 .1355 L
.05263 .12597 L
.05394 .12786 L
.05525 .11251 L
.05656 .12002 L
.05787 .12176 L
.05918 .11773 L
.06049 .1251 L
.0618 .13816 L
.06311 .14544 L
.06442 .15268 L
.06573 .1656 L
.06704 .17275 L
.06835 .16841 L
.06966 .17547 L
.07097 .1825 L
.07228 .18375 L
.07359 .17923 L
.0749 .17468 L
.07621 .17581 L
.07752 .1769 L
.07883 .16077 L
.08014 .16178 L
.08145 .1513 L
.08276 .16369 L
.08407 .17032 L
.08538 .154 L
.08669 .15482 L
.088 .14415 L
Mistroke
.08931 .13917 L
.09062 .1227 L
.09193 .12338 L
.09324 .13547 L
.09455 .12462 L
.09586 .13665 L
.09717 .12573 L
.09848 .13196 L
.09979 .13815 L
.1011 .12713 L
.10241 .1218 L
.10372 .1107 L
.10503 .10531 L
.10634 .11706 L
.10765 .12305 L
.10896 .12901 L
.11027 .11202 L
.11158 .11792 L
.11289 .11805 L
.1142 .11815 L
.11551 .12968 L
.11682 .12971 L
.11813 .14118 L
.11944 .12396 L
.12075 .12963 L
.12206 .13527 L
.12337 .12942 L
.12468 .12354 L
.12599 .1119 L
.1273 .0945 L
.12861 .09426 L
.12992 .09399 L
.13123 .09941 L
.13254 .11054 L
.13385 .11018 L
.13516 .10978 L
.13647 .10936 L
.13778 .10318 L
.13909 .10843 L
.1404 .10219 L
.14171 .09592 L
.14302 .08962 L
.14433 .09476 L
.14564 .10559 L
.14695 .09921 L
.14826 .10425 L
.14957 .10927 L
.15088 .10853 L
.15219 .10777 L
.1535 .09551 L
Mistroke
.15481 .10042 L
.15612 .1053 L
.15743 .11015 L
.15874 .10352 L
.16005 .11404 L
.16136 .10735 L
.16267 .11782 L
.16398 .10535 L
.16529 .09858 L
.1666 .10324 L
.16791 .09642 L
.16922 .08957 L
.17053 .09988 L
.17184 .11016 L
.17315 .09751 L
.17446 .09628 L
.17577 .08357 L
.17708 .08229 L
.17839 .08098 L
.1797 .09111 L
.18101 .09548 L
.18232 .10556 L
.18363 .10988 L
.18494 .10844 L
.18625 .11844 L
.18756 .11696 L
.18887 .09253 L
.19018 .09672 L
.19149 .08943 L
.1928 .07639 L
.19411 .05759 L
.19542 .05596 L
.19673 .04857 L
.19804 .04115 L
.19935 .0509 L
.20066 .04916 L
.20197 .05313 L
.20328 .05708 L
.20459 .05527 L
.2059 .05916 L
.20721 .06876 L
.20852 .07834 L
.20983 .08216 L
.21114 .09169 L
.21245 .07828 L
.21376 .0763 L
.21507 .08003 L
.21638 .078 L
.21769 .08741 L
.219 .09107 L
Mistroke
.22031 .07751 L
.22162 .07539 L
.22293 .07325 L
.22424 .07108 L
.22555 .06316 L
.22686 .05522 L
.22817 .05298 L
.22948 .06218 L
.23079 .07135 L
.2321 .07477 L
.23341 .07817 L
.23472 .07009 L
.23603 .07344 L
.23734 .07677 L
.23865 .08008 L
.23996 .08336 L
.24127 .08662 L
.24258 .08986 L
.24389 .09881 L
.2452 .102 L
.24651 .1109 L
.24782 .10832 L
.24913 .11145 L
.25044 .10882 L
.25175 .1119 L
.25306 .12069 L
.25437 .118 L
.25568 .11528 L
.25699 .11255 L
.2583 .11552 L
.25961 .11847 L
.26092 .10994 L
.26223 .0842 L
.26354 .09281 L
.26485 .09567 L
.26616 .09851 L
.26747 .08987 L
.26878 .07548 L
.27009 .07253 L
.2714 .07528 L
.27271 .06655 L
.27402 .07499 L
.27533 .08341 L
.27664 .08035 L
.27795 .07154 L
.27926 .0627 L
.28057 .07103 L
.28188 .07362 L
.28319 .07045 L
.2845 .07299 L
Mistroke
.28581 .07551 L
.28712 .06082 L
.28843 .05184 L
.28974 .06002 L
.29105 .06245 L
.29236 .0706 L
.29367 .07872 L
.29498 .07536 L
.29629 .06053 L
.2976 .05713 L
.29891 .05371 L
.30022 .04454 L
.30153 .04108 L
.30284 .04333 L
.30415 .05128 L
.30546 .04776 L
.30677 .05568 L
.30808 .06357 L
.30939 .06572 L
.3107 .06784 L
.31201 .06422 L
.31332 .06057 L
.31463 .06264 L
.31594 .06468 L
.31725 .07244 L
.31856 .06298 L
.31987 .07069 L
.32118 .07839 L
.32249 .08606 L
.3238 .08798 L
.32511 .07843 L
.32642 .06885 L
.32773 .07072 L
.32904 .07256 L
.33035 .06866 L
.33166 .07619 L
.33297 .07798 L
.33428 .06828 L
.33559 .0643 L
.3369 .07175 L
.33821 .07919 L
.33952 .0866 L
.34083 .08827 L
.34214 .08419 L
.34345 .07436 L
.34476 .08169 L
.34607 .07755 L
.34738 .07912 L
.34869 .08067 L
.35 .07648 L
Mistroke
.35131 .07799 L
.35262 .07948 L
.35393 .08095 L
.35524 .07095 L
.35655 .06092 L
.35786 .06807 L
.35917 .06374 L
.36048 .06511 L
.36179 .05501 L
.3631 .05635 L
.36441 .05767 L
.36572 .04752 L
.36703 .05453 L
.36834 .05006 L
.36965 .0513 L
.37096 .05253 L
.37227 .04801 L
.37358 .05492 L
.37489 .06182 L
.3762 .06297 L
.37751 .0641 L
.37882 .06521 L
.38013 .07204 L
.38144 .07311 L
.38275 .0799 L
.38406 .08666 L
.38537 .09341 L
.38668 .10014 L
.38799 .10685 L
.3893 .10782 L
.39061 .11449 L
.39192 .11542 L
.39323 .11633 L
.39454 .11722 L
.39585 .11809 L
.39716 .12467 L
.39847 .11405 L
.39978 .1206 L
.40109 .11567 L
.4024 .12217 L
.40371 .12867 L
.40502 .12941 L
.40633 .13586 L
.40764 .1423 L
.40895 .14872 L
.41026 .14366 L
.41157 .14432 L
.41288 .13922 L
.41419 .14557 L
.4155 .1519 L
Mistroke
.41681 .15248 L
.41812 .14731 L
.41943 .15359 L
.42074 .15411 L
.42205 .16035 L
.42336 .16085 L
.42467 .16132 L
.42598 .1675 L
.42729 .16794 L
.4286 .16836 L
.42991 .1745 L
.43122 .16915 L
.43253 .17525 L
.43384 .18133 L
.43515 .18739 L
.43646 .19343 L
.43777 .19373 L
.43908 .19974 L
.44039 .20573 L
.4417 .2117 L
.44301 .2062 L
.44432 .20641 L
.44563 .2066 L
.44694 .20678 L
.44825 .20121 L
.44956 .18989 L
.45087 .19574 L
.45218 .20157 L
.45349 .20739 L
.4548 .21319 L
.45611 .21897 L
.45742 .22473 L
.45873 .22475 L
.46004 .23048 L
.46135 .2362 L
.46266 .23616 L
.46397 .24184 L
.46528 .24177 L
.46659 .23596 L
.4679 .23013 L
.46921 .23001 L
.47052 .2356 L
.47183 .24118 L
.47314 .24101 L
.47445 .24082 L
.47576 .22916 L
.47707 .23467 L
.47838 .23443 L
.47969 .23418 L
.481 .23963 L
Mistroke
.48231 .24507 L
.48362 .23904 L
.48493 .23872 L
.48624 .24411 L
.48755 .24948 L
.48886 .24911 L
.49017 .24872 L
.49148 .24831 L
.49279 .24789 L
.4941 .24745 L
.49541 .24699 L
.49672 .23506 L
.49803 .22884 L
.49934 .22833 L
.50066 .23354 L
.50197 .233 L
.50328 .23817 L
.50459 .23187 L
.5059 .23128 L
.50721 .2364 L
.50852 .23578 L
.50983 .22368 L
.51114 .22303 L
.51245 .21663 L
.51376 .21021 L
.51507 .21523 L
.51638 .22024 L
.51769 .22523 L
.519 .2302 L
.52031 .22943 L
.52162 .23437 L
.52293 .23357 L
.52424 .23275 L
.52555 .23764 L
.52686 .24252 L
.52817 .23592 L
.52948 .24077 L
.53079 .23987 L
.5321 .23895 L
.53341 .24374 L
.53472 .24852 L
.53603 .24756 L
.53734 .24657 L
.53865 .2513 L
.53996 .25602 L
.54127 .26072 L
.54258 .25394 L
.54389 .25288 L
.5452 .25753 L
.54651 .25071 L
Mistroke
.54782 .2496 L
.54913 .24847 L
.55044 .24733 L
.55175 .24617 L
.55306 .25072 L
.55437 .25526 L
.55568 .25405 L
.55699 .24137 L
.5583 .24586 L
.55961 .24461 L
.56092 .24334 L
.56223 .24205 L
.56354 .24075 L
.56485 .24516 L
.56616 .24956 L
.56747 .24821 L
.56878 .25257 L
.57009 .25119 L
.5714 .24979 L
.57271 .25411 L
.57402 .25841 L
.57533 .26269 L
.57664 .26696 L
.57795 .26549 L
.57926 .25827 L
.58057 .25676 L
.58188 .24378 L
.58319 .24224 L
.5845 .24642 L
.58581 .25058 L
.58712 .25472 L
.58843 .25885 L
.58974 .26297 L
.59105 .26706 L
.59236 .27114 L
.59367 .27521 L
.59498 .27353 L
.59629 .26611 L
.5976 .27013 L
.59891 .27414 L
.60022 .27813 L
.60153 .27637 L
.60284 .28033 L
.60415 .28427 L
.60546 .2882 L
.60677 .28638 L
.60808 .29028 L
.60939 .29416 L
.6107 .2923 L
.61201 .29615 L
Mistroke
.61332 .28853 L
.61463 .29235 L
.61594 .29615 L
.61725 .29421 L
.61856 .29226 L
.61987 .29029 L
.62118 .29403 L
.62249 .27485 L
.6238 .27856 L
.62511 .28226 L
.62642 .28594 L
.62773 .28388 L
.62904 .28754 L
.63035 .27972 L
.63166 .27761 L
.63297 .28122 L
.63428 .27908 L
.63559 .28266 L
.6369 .28622 L
.63821 .28977 L
.63952 .2933 L
.64083 .29682 L
.64214 .29459 L
.64345 .29808 L
.64476 .30155 L
.64607 .30501 L
.64738 .29127 L
.64869 .29469 L
.65 .29238 L
.65131 .29005 L
.65262 .28197 L
.65393 .27388 L
.65524 .27151 L
.65655 .27484 L
.65786 .27817 L
.65917 .28148 L
.66048 .28477 L
.66179 .28805 L
.6631 .29131 L
.66441 .29456 L
.66572 .29779 L
.66703 .29529 L
.66834 .28703 L
.66965 .29022 L
.67096 .2934 L
.67227 .29083 L
.67358 .29397 L
.67489 .29711 L
.6762 .29449 L
.67751 .2976 L
Mistroke
.67882 .29495 L
.68013 .28657 L
.68144 .28963 L
.68275 .29267 L
.68406 .2957 L
.68537 .29871 L
.68668 .30171 L
.68799 .30469 L
.6893 .30766 L
.69061 .31062 L
.69192 .31356 L
.69323 .31076 L
.69454 .31367 L
.69585 .31657 L
.69716 .31945 L
.69847 .31659 L
.69978 .31944 L
.70109 .31655 L
.7024 .31365 L
.70371 .31646 L
.70502 .31353 L
.70633 .31058 L
.70764 .31335 L
.70895 .30464 L
.71026 .30738 L
.71157 .30438 L
.71288 .30709 L
.71419 .30978 L
.7155 .31246 L
.71681 .3094 L
.71812 .30059 L
.71943 .30323 L
.72074 .2944 L
.72205 .29701 L
.72336 .28814 L
.72467 .29072 L
.72598 .29329 L
.72729 .29011 L
.7286 .29265 L
.72991 .29517 L
.73122 .29768 L
.73253 .28872 L
.73384 .27401 L
.73515 .27648 L
.73646 .27893 L
.73777 .28137 L
.73908 .2838 L
.74039 .28048 L
.7417 .28287 L
.74301 .28525 L
Mistroke
.74432 .28762 L
.74563 .28425 L
.74694 .28659 L
.74825 .28891 L
.74956 .29122 L
.75087 .28779 L
.75218 .29007 L
.75349 .29234 L
.7548 .2946 L
.75611 .29684 L
.75742 .29906 L
.75873 .30128 L
.76004 .29775 L
.76135 .2942 L
.76266 .29637 L
.76397 .29853 L
.76528 .29494 L
.76659 .29707 L
.7679 .29919 L
.76921 .30129 L
.77052 .29192 L
.77183 .28253 L
.77314 .28459 L
.77445 .28664 L
.77576 .27721 L
.77707 .27923 L
.77838 .2755 L
.77969 .27749 L
.781 .27374 L
.78231 .2757 L
.78362 .27765 L
.78493 .27958 L
.78624 .27578 L
.78755 .27768 L
.78886 .27958 L
.79017 .28145 L
.79148 .28332 L
.79279 .27944 L
.7941 .28128 L
.79541 .2831 L
.79672 .27919 L
.79803 .26953 L
.79934 .27131 L
.80065 .27308 L
.80196 .27483 L
.80327 .27657 L
.80458 .2783 L
.80589 .28002 L
.8072 .27599 L
.80851 .27768 L
Mistroke
.80982 .27935 L
.81113 .28101 L
.81244 .28265 L
.81375 .27856 L
.81506 .28018 L
.81637 .28178 L
.81768 .28337 L
.81899 .27922 L
.8203 .28079 L
.82161 .27661 L
.82292 .27815 L
.82423 .27394 L
.82554 .27545 L
.82685 .27695 L
.82816 .27843 L
.82947 .2799 L
.83078 .28136 L
.83209 .2828 L
.8334 .28423 L
.83471 .28565 L
.83602 .28132 L
.83733 .27698 L
.83864 .27835 L
.83995 .26826 L
.84126 .26388 L
.84257 .26521 L
.84388 .25508 L
.84519 .25066 L
.8465 .25195 L
.84781 .2475 L
.84912 .24877 L
.85043 .25003 L
.85174 .25127 L
.85305 .24677 L
.85436 .24798 L
.85567 .24345 L
.85698 .24464 L
.85829 .24581 L
.8596 .24698 L
.86091 .24812 L
.86222 .24926 L
.86353 .25038 L
.86484 .24576 L
.86615 .24685 L
.86746 .24793 L
.86877 .249 L
.87008 .25006 L
.87139 .2511 L
.8727 .25213 L
.87401 .25314 L
Mistroke
.87532 .24841 L
.87663 .2494 L
.87794 .25038 L
.87925 .25134 L
.88056 .25229 L
.88187 .25323 L
.88318 .25415 L
.88449 .25506 L
.8858 .25595 L
.88711 .25684 L
.88842 .25771 L
.88973 .25284 L
.89104 .25368 L
.89235 .25451 L
.89366 .25533 L
.89497 .25613 L
.89628 .25692 L
.89759 .2577 L
.8989 .25274 L
.90021 .24203 L
.90152 .23704 L
.90283 .23204 L
.90414 .23275 L
.90545 .23345 L
.90676 .22841 L
.90807 .22908 L
.90938 .22402 L
.91069 .22466 L
.912 .2253 L
.91331 .22592 L
.91462 .22653 L
.91593 .22712 L
.91724 .22771 L
.91855 .22255 L
.91986 .2231 L
.92117 .22365 L
.92248 .22418 L
.92379 .2247 L
.9251 .2252 L
.92641 .22569 L
.92772 .22617 L
.92903 .22664 L
.93034 .22709 L
.93165 .2218 L
.93296 .22223 L
.93427 .22265 L
.93558 .22305 L
.93689 .21771 L
.9382 .21809 L
.93951 .21845 L
Mistroke
.94082 .2188 L
.94213 .21914 L
.94344 .21946 L
.94475 .21977 L
.94606 .22007 L
.94737 .22036 L
.94868 .2149 L
.94999 .21516 L
.9513 .21541 L
.95261 .21565 L
.95392 .21587 L
.95523 .21608 L
.95654 .21055 L
.95785 .21073 L
.95916 .2109 L
.96047 .21106 L
.96178 .19975 L
.96309 .19988 L
.9644 .2 L
.96571 .19438 L
.96702 .19448 L
.96833 .19456 L
.96964 .19463 L
.97095 .19469 L
.97226 .19473 L
.97357 .19476 L
.97488 .19478 L
.97619 .19479 L
Mfstroke
1 0 1 r
.02381 .1776 m
.02512 .21597 L
.02643 .23503 L
.02774 .24544 L
.02905 .25971 L
.03036 .26687 L
.03167 .28439 L
.03298 .28956 L
.03429 .28823 L
.0356 .2977 L
.03691 .27221 L
.03822 .28631 L
.03953 .29993 L
.04084 .30739 L
.04215 .30873 L
.04346 .3097 L
.04477 .31034 L
.04608 .31067 L
.04739 .32216 L
.0487 .31619 L
.05001 .32142 L
.05132 .29202 L
.05263 .28531 L
.05394 .28984 L
.05525 .27697 L
.05656 .28682 L
.05787 .29074 L
.05918 .28876 L
.06049 .29805 L
.0618 .31291 L
.06311 .32187 L
.06442 .33068 L
.06573 .34507 L
.06704 .35358 L
.06835 .3505 L
.06966 .35874 L
.07097 .36685 L
.07228 .3691 L
.07359 .36551 L
.0749 .36179 L
.07621 .36369 L
.07752 .36547 L
.07883 .34996 L
.08014 .35153 L
.08145 .34154 L
.08276 .35437 L
.08407 .36136 L
.08538 .34535 L
.08669 .34643 L
.088 .33597 L
Mistroke
.08931 .33114 L
.09062 .31477 L
.09193 .3155 L
.09324 .32761 L
.09455 .31672 L
.09586 .32866 L
.09717 .31762 L
.09848 .32368 L
.09979 .32967 L
.1011 .31841 L
.10241 .3128 L
.10372 .30139 L
.10503 .29564 L
.10634 .30701 L
.10765 .31259 L
.10896 .3181 L
.11027 .30064 L
.11158 .30602 L
.11289 .30562 L
.1142 .30516 L
.11551 .31609 L
.11682 .31551 L
.11813 .32633 L
.11944 .30846 L
.12075 .31344 L
.12206 .31836 L
.12337 .31178 L
.12468 .30514 L
.12599 .29273 L
.1273 .27453 L
.12861 .27347 L
.12992 .27236 L
.13123 .27693 L
.13254 .28718 L
.13385 .28592 L
.13516 .28462 L
.13647 .28328 L
.13778 .27616 L
.13909 .28045 L
.1404 .27324 L
.14171 .26599 L
.14302 .25869 L
.14433 .26281 L
.14564 .27262 L
.14695 .2652 L
.14826 .2692 L
.14957 .27315 L
.15088 .27134 L
.15219 .26949 L
.1535 .25614 L
Mistroke
.15481 .25994 L
.15612 .26371 L
.15743 .26743 L
.15874 .25966 L
.16005 .26904 L
.16136 .2612 L
.16267 .27051 L
.16398 .25687 L
.16529 .24893 L
.1666 .2524 L
.16791 .24439 L
.16922 .23634 L
.17053 .24544 L
.17184 .25451 L
.17315 .24064 L
.17446 .23819 L
.17577 .22425 L
.17708 .22173 L
.17839 .21919 L
.1797 .22807 L
.18101 .23119 L
.18232 .24001 L
.18363 .24307 L
.18494 .24038 L
.18625 .24911 L
.18756 .24635 L
.18887 .22065 L
.19018 .22357 L
.19149 .215 L
.1928 .20067 L
.19411 .18059 L
.19542 .17766 L
.19673 .16898 L
.19804 .16027 L
.19935 .16872 L
.20066 .16569 L
.20197 .16836 L
.20328 .17101 L
.20459 .1679 L
.2059 .17049 L
.20721 .17878 L
.20852 .18705 L
.20983 .18957 L
.21114 .19779 L
.21245 .18307 L
.21376 .17979 L
.21507 .1822 L
.21638 .17887 L
.21769 .18697 L
.219 .18932 L
Mistroke
.22031 .17446 L
.22162 .17103 L
.22293 .16758 L
.22424 .1641 L
.22555 .15488 L
.22686 .14563 L
.22817 .14208 L
.22948 .14998 L
.23079 .15785 L
.2321 .15997 L
.23341 .16207 L
.23472 .15269 L
.23603 .15474 L
.23734 .15678 L
.23865 .15879 L
.23996 .16078 L
.24127 .16276 L
.24258 .16471 L
.24389 .17237 L
.2452 .17428 L
.24651 .18189 L
.24782 .17803 L
.24913 .17988 L
.25044 .17598 L
.25175 .17779 L
.25306 .18531 L
.25437 .18135 L
.25568 .17738 L
.25699 .17338 L
.2583 .17509 L
.25961 .17679 L
.26092 .167 L
.26223 .14001 L
.26354 .14738 L
.26485 .149 L
.26616 .1506 L
.26747 .14072 L
.26878 .1251 L
.27009 .12092 L
.2714 .12244 L
.27271 .1125 L
.27402 .11972 L
.27533 .12692 L
.27664 .12265 L
.27795 .11263 L
.27926 .10259 L
.28057 .10972 L
.28188 .11111 L
.28319 .10675 L
.2845 .1081 L
Mistroke
.28581 .10944 L
.28712 .09357 L
.28843 .08341 L
.28974 .09043 L
.29105 .0917 L
.29236 .09868 L
.29367 .10564 L
.29498 .10113 L
.29629 .08515 L
.2976 .0806 L
.29891 .07605 L
.30022 .06574 L
.30153 .06115 L
.30284 .06227 L
.30415 .06911 L
.30546 .06447 L
.30677 .07127 L
.30808 .07806 L
.30939 .07911 L
.3107 .08013 L
.31201 .07542 L
.31332 .07069 L
.31463 .07167 L
.31594 .07264 L
.31725 .07932 L
.31856 .0688 L
.31987 .07545 L
.32118 .08208 L
.32249 .0887 L
.3238 .08958 L
.32511 .07898 L
.32642 .06837 L
.32773 .06921 L
.32904 .07002 L
.33035 .0651 L
.33166 .07162 L
.33297 .07239 L
.33428 .0617 L
.33559 .05671 L
.3369 .06317 L
.33821 .06962 L
.33952 .07605 L
.34083 .07674 L
.34214 .07169 L
.34345 .06089 L
.34476 .06727 L
.34607 .06217 L
.34738 .06279 L
.34869 .0634 L
.35 .05826 L
Mistroke
.35131 .05884 L
.35262 .05941 L
.35393 .05996 L
.35524 .04904 L
.35655 .03811 L
.35786 .04435 L
.35917 .03911 L
.36048 .0396 L
.36179 .02861 L
.3631 .02907 L
.36441 .02951 L
.36572 .01849 L
.36703 .02463 L
.36834 .01931 L
.36965 .0197 L
.37096 .02008 L
.37227 .01472 L
.37358 .0208 L
.37489 .02686 L
.3762 .02719 L
.37751 .02751 L
.37882 .02781 L
.38013 .03382 L
.38144 .0341 L
.38275 .04009 L
.38406 .04607 L
.38537 .05203 L
.38668 .05799 L
.38799 .06393 L
.3893 .06413 L
.39061 .07004 L
.39192 .07022 L
.39323 .07038 L
.39454 .07053 L
.39585 .07067 L
.39716 .07652 L
.39847 .06518 L
.39978 .071 L
.40109 .06536 L
.4024 .07117 L
.40371 .07696 L
.40502 .07701 L
.40633 .08278 L
.40764 .08853 L
.40895 .09428 L
.41026 .08855 L
.41157 .08854 L
.41288 .08279 L
.41419 .08849 L
.4155 .09417 L
Mistroke
.41681 .09411 L
.41812 .08831 L
.41943 .09396 L
.42074 .09387 L
.42205 .09949 L
.42336 .09938 L
.42467 .09925 L
.42598 .10483 L
.42729 .10468 L
.4286 .10452 L
.42991 .11007 L
.43122 .10415 L
.43253 .10968 L
.43384 .1152 L
.43515 .12071 L
.43646 .1262 L
.43777 .12596 L
.43908 .13143 L
.44039 .13689 L
.4417 .14233 L
.44301 .13631 L
.44432 .13601 L
.44563 .13569 L
.44694 .13537 L
.44825 .1293 L
.44956 .11749 L
.45087 .12286 L
.45218 .12821 L
.45349 .13356 L
.4548 .13889 L
.45611 .14421 L
.45742 .14952 L
.45873 .14909 L
.46004 .15438 L
.46135 .15966 L
.46266 .15919 L
.46397 .16445 L
.46528 .16396 L
.46659 .15773 L
.4679 .1515 L
.46921 .15098 L
.47052 .15617 L
.47183 .16136 L
.47314 .1608 L
.47445 .16024 L
.47576 .1482 L
.47707 .15335 L
.47838 .15275 L
.47969 .15214 L
.481 .15724 L
Mistroke
.48231 .16234 L
.48362 .15597 L
.48493 .15531 L
.48624 .16037 L
.48755 .16543 L
.48886 .16474 L
.49017 .16404 L
.49148 .16333 L
.49279 .16261 L
.4941 .16187 L
.49541 .16113 L
.49672 .14892 L
.49803 .14242 L
.49934 .14165 L
.50066 .14659 L
.50197 .14579 L
.50328 .15071 L
.50459 .14416 L
.5059 .14332 L
.50721 .14821 L
.50852 .14736 L
.50983 .13503 L
.51114 .13416 L
.51245 .12754 L
.51376 .12091 L
.51507 .12573 L
.51638 .13054 L
.51769 .13534 L
.519 .14013 L
.52031 .13917 L
.52162 .14394 L
.52293 .14296 L
.52424 .14197 L
.52555 .14671 L
.52686 .15143 L
.52817 .14468 L
.52948 .14938 L
.53079 .14834 L
.5321 .14728 L
.53341 .15195 L
.53472 .15661 L
.53603 .15552 L
.53734 .15442 L
.53865 .15905 L
.53996 .16366 L
.54127 .16826 L
.54258 .16139 L
.54389 .16024 L
.5452 .1648 L
.54651 .1579 L
Mistroke
.54782 .15672 L
.54913 .15552 L
.55044 .15432 L
.55175 .1531 L
.55306 .1576 L
.55437 .16209 L
.55568 .16084 L
.55699 .14813 L
.5583 .15258 L
.55961 .1513 L
.56092 .15001 L
.56223 .1487 L
.56354 .14739 L
.56485 .15179 L
.56616 .15618 L
.56747 .15483 L
.56878 .1592 L
.57009 .15783 L
.5714 .15645 L
.57271 .16079 L
.57402 .16511 L
.57533 .16943 L
.57664 .17373 L
.57795 .17229 L
.57926 .16512 L
.58057 .16366 L
.58188 .15073 L
.58319 .14925 L
.5845 .15348 L
.58581 .15771 L
.58712 .16193 L
.58843 .16613 L
.58974 .17032 L
.59105 .1745 L
.59236 .17867 L
.59367 .18283 L
.59498 .18125 L
.59629 .17393 L
.5976 .17806 L
.59891 .18217 L
.60022 .18628 L
.60153 .18464 L
.60284 .18872 L
.60415 .19279 L
.60546 .19685 L
.60677 .19517 L
.60808 .1992 L
.60939 .20323 L
.6107 .20151 L
.61201 .20552 L
Mistroke
.61332 .19805 L
.61463 .20203 L
.61594 .206 L
.61725 .20423 L
.61856 .20245 L
.61987 .20065 L
.62118 .20458 L
.62249 .18558 L
.6238 .18948 L
.62511 .19337 L
.62642 .19725 L
.62773 .19538 L
.62904 .19924 L
.63035 .19163 L
.63166 .18973 L
.63297 .19355 L
.63428 .19163 L
.63559 .19543 L
.6369 .19922 L
.63821 .203 L
.63952 .20676 L
.64083 .21052 L
.64214 .20853 L
.64345 .21226 L
.64476 .21598 L
.64607 .21968 L
.64738 .20619 L
.64869 .20988 L
.65 .20782 L
.65131 .20575 L
.65262 .19795 L
.65393 .19013 L
.65524 .18802 L
.65655 .19164 L
.65786 .19524 L
.65917 .19883 L
.66048 .20241 L
.66179 .20598 L
.6631 .20954 L
.66441 .21308 L
.66572 .21662 L
.66703 .21441 L
.66834 .20646 L
.66965 .20996 L
.67096 .21344 L
.67227 .21119 L
.67358 .21465 L
.67489 .2181 L
.6762 .21581 L
.67751 .21924 L
Mistroke
.67882 .21692 L
.68013 .20887 L
.68144 .21226 L
.68275 .21564 L
.68406 .21901 L
.68537 .22236 L
.68668 .2257 L
.68799 .22903 L
.6893 .23235 L
.69061 .23566 L
.69192 .23896 L
.69323 .23651 L
.69454 .23978 L
.69585 .24304 L
.69716 .24629 L
.69847 .24379 L
.69978 .24701 L
.70109 .24449 L
.7024 .24196 L
.70371 .24515 L
.70502 .24259 L
.70633 .24003 L
.70764 .24317 L
.70895 .23485 L
.71026 .23798 L
.71157 .23536 L
.71288 .23846 L
.71419 .24155 L
.7155 .24462 L
.71681 .24196 L
.71812 .23355 L
.71943 .23659 L
.72074 .22815 L
.72205 .23117 L
.72336 .22271 L
.72467 .22569 L
.72598 .22867 L
.72729 .2259 L
.7286 .22885 L
.72991 .23179 L
.73122 .23471 L
.73253 .22617 L
.73384 .21188 L
.73515 .21477 L
.73646 .21764 L
.73777 .2205 L
.73908 .22335 L
.74039 .22045 L
.7417 .22328 L
.74301 .22608 L
Mistroke
.74432 .22888 L
.74563 .22594 L
.74694 .22871 L
.74825 .23146 L
.74956 .23421 L
.75087 .23121 L
.75218 .23393 L
.75349 .23663 L
.7548 .23933 L
.75611 .24201 L
.75742 .24467 L
.75873 .24732 L
.76004 .24424 L
.76135 .24113 L
.76266 .24375 L
.76397 .24635 L
.76528 .2432 L
.76659 .24578 L
.7679 .24834 L
.76921 .25089 L
.77052 .24196 L
.77183 .23302 L
.77314 .23553 L
.77445 .23802 L
.77576 .22904 L
.77707 .23151 L
.77838 .22823 L
.77969 .23067 L
.781 .22737 L
.78231 .22978 L
.78362 .23218 L
.78493 .23456 L
.78624 .23121 L
.78755 .23356 L
.78886 .23591 L
.79017 .23824 L
.79148 .24055 L
.79279 .23712 L
.7941 .23941 L
.79541 .24168 L
.79672 .23822 L
.79803 .229 L
.79934 .23124 L
.80065 .23345 L
.80196 .23566 L
.80327 .23785 L
.80458 .24002 L
.80589 .24218 L
.8072 .2386 L
.80851 .24074 L
Mistroke
.80982 .24285 L
.81113 .24496 L
.81244 .24705 L
.81375 .2434 L
.81506 .24546 L
.81637 .24751 L
.81768 .24954 L
.81899 .24583 L
.8203 .24783 L
.82161 .24409 L
.82292 .24607 L
.82423 .2423 L
.82554 .24424 L
.82685 .24617 L
.82816 .24809 L
.82947 .24999 L
.83078 .25188 L
.83209 .25375 L
.8334 .25561 L
.83471 .25745 L
.83602 .25355 L
.83733 .24963 L
.83864 .25143 L
.83995 .24175 L
.84126 .23779 L
.84257 .23955 L
.84388 .22982 L
.84519 .22582 L
.8465 .22753 L
.84781 .22349 L
.84912 .22517 L
.85043 .22683 L
.85174 .22847 L
.85305 .22437 L
.85436 .22599 L
.85567 .22186 L
.85698 .22345 L
.85829 .22501 L
.8596 .22657 L
.86091 .22811 L
.86222 .22963 L
.86353 .23114 L
.86484 .2269 L
.86615 .22837 L
.86746 .22983 L
.86877 .23128 L
.87008 .23271 L
.87139 .23412 L
.8727 .23551 L
.87401 .23689 L
Mistroke
.87532 .23253 L
.87663 .23388 L
.87794 .23521 L
.87925 .23653 L
.88056 .23783 L
.88187 .23911 L
.88318 .24038 L
.88449 .24163 L
.8858 .24287 L
.88711 .24409 L
.88842 .24529 L
.88973 .24075 L
.89104 .24192 L
.89235 .24307 L
.89366 .24421 L
.89497 .24533 L
.89628 .24643 L
.89759 .24752 L
.8989 .24286 L
.90021 .23246 L
.90152 .22777 L
.90283 .22306 L
.90414 .22406 L
.90545 .22505 L
.90676 .22029 L
.90807 .22125 L
.90938 .21645 L
.91069 .21737 L
.912 .21827 L
.91331 .21916 L
.91462 .22003 L
.91593 .22088 L
.91724 .22171 L
.91855 .2168 L
.91986 .21759 L
.92117 .21838 L
.92248 .21914 L
.92379 .21989 L
.9251 .22061 L
.92641 .22133 L
.92772 .22202 L
.92903 .2227 L
.93034 .22335 L
.93165 .21827 L
.93296 .21889 L
.93427 .21949 L
.93558 .22008 L
.93689 .21492 L
.9382 .21547 L
.93951 .216 L
Mistroke
.94082 .21652 L
.94213 .21702 L
.94344 .2175 L
.94475 .21796 L
.94606 .2184 L
.94737 .21882 L
.94868 .2135 L
.94999 .21389 L
.9513 .21426 L
.95261 .21461 L
.95392 .21494 L
.95523 .21525 L
.95654 .20982 L
.95785 .21009 L
.95916 .21035 L
.96047 .21059 L
.96178 .19935 L
.96309 .19955 L
.9644 .19974 L
.96571 .19417 L
.96702 .19431 L
.96833 .19444 L
.96964 .19455 L
.97095 .19463 L
.97226 .1947 L
.97357 .19475 L
.97488 .19478 L
.97619 .19479 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{551.5, 162.25},
  ImageMargins->{{43.75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008W0000XR000`400?l00000o`00003oo`0J6Q[o
01XJ6RT06QXJ003o01XJ6_l06QXJ:@0J6QX00?l06QXJo`0J6QXY01XJ6P00o`0J6Q[o01XJ6RT06QXJ
003o01XJ6_l06QXJ:@0J6QX003T06QXJ1@3Kfm/201XJ6P80fm_K100J6QX20=_Kfa006QXJ103Kfm/3
01XJ6P80fm_K100J6QX20=_Kfa006QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa806QXJ0`3Kfm/2
01XJ6P80fm_K100J6QX20=_Kfa006QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfa006QXJ0`3Kfm/4
01XJ6P80fm_K100J6QX20=_Kfa406QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`@06QXJ0P3Kfm_o
01XJ6RT06QXJ000k01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3K
fm/201XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`h06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103K
fm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa806QXJ00@0fm_K01XJ6P0J6QX0fm_K
0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00@0fm_K01XJ6P0J
6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`l06QXJ00@0
fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_K
fa006QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0
fm_K01XJ6P0J6QX0o`0J6QXV01XJ6P00>`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0
fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0>01XJ6P030=_Kf`0J6QX06QXJ00806QXJ
00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/@01XJ6P050=_Kf`0J6QX06QXJ
01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00d06QXJ1@3K
fm/01@0J6QX0fm_K01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K4@0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX03@0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0
fm_K400J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0
0`3Kfm/06QXJ01XJ6P3o01XJ6RH06QXJ000k01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00D0fm_K01XJ6P0J6QX06QXJ
0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX03`0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX03@0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0
fm_K3`0J6QX20=_Kf`<06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/?
01XJ6P<0fm_K0`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kfa406QXJ
00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ
0?l06QXJ9P0J6QX003/06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX03@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J
6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K3P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K400J6QX00`3Kfm/06QXJ0=_K
f`0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K3`0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K400J6QX0
0`3Kfm/06QXJ01XJ6P0201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K
3P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ
6P0J6QX0fm_Ko`0J6QXX01XJ6P00>P0J6QX20=_Kf`@06QXJ0P3Kfm/401XJ6P80fm_K4@0J6QX20=_K
f`@06QXJ0P3Kfm/401XJ6P80fm_K400J6QX20=_Kf`@06QXJ0P3Kfm/401XJ6P80fm_K4P0J6QX20=_K
f`<06QXJ0P3Kfm/401XJ6P80fm_K400J6QX30=_Kf`<06QXJ0P3Kfm/401XJ6P80fm_K4@0J6QX30=_K
f`<06QXJ0P3Kfm/401XJ6P80fm_K3`0J6QX40=_Kf`<06QXJ0P3Kfm/401XJ6P80fm_Ko`0J6QXY01XJ
6P00o`0J6QY101XJ6P030=_Kf`0J6QX06QXJ0>@06QXJ003o01XJ6T406QXJ00<0fm_K01XJ6P0J6QX0
i00J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0o`0J6QXK01XJ6P80fm_Ki@0J6QX002<06QXJ00<0fm_K
01XJ6P0J6QX0o`0J6QXK01XJ6P030=_Kf`0J6QX06QXJ04X06QXJ00<0o`3o01XJ6P0J6QX0U`0J6QX0
02<06QXJ00<0fm_K01XJ6P0J6QX0o`0J6QX201XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/501XJ
6P<0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P1901XJ6P80o`3oV@0J6QX001d06QXJ1P3Kfm/00`3o0?l0
fm_K0=_Kf`3Q0=_Kfal06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/5
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0B@0J6QX20?l0oiT06QXJ000S01XJ
6P030?l0o`00o`006QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ
6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX07`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/8
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ1@3Kfm/301XJ6P80fm_KB@0J6QX20?l0o`0301XJ6P3o
0?l0o`3o09L06QXJ000S01XJ6P030?mo003o0?l06QXJ01/06QXJ00<0fm_K01XJ6P0J6QX0700J6QX0
0`3Kfm/06QXJ01XJ6P0K01XJ6P030=_Kf`0J6QX06QXJ01`06QXJ00<0fm_K01XJ6P0J6QX06`0J6QX0
0`3Kfm/06QXJ01XJ6P0L01XJ6P030=_Kf`0J6QX06QXJ01/06QXJ00<0fm_K01XJ6P0J6QX09@0J6QX4
0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_K
f`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX0B00J6QX01@3o0?l06QXJ01XJ6P0J6QX0o`3o
09L06QXJ000S01XJ6P030=_Kf`3o0?l00?l00?l06QXJ0@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ00<0fm_K01XJ6P3Kfm/0100J6QX00`3Kfm/06QXJ01XJ6P17
01XJ6P030?l0o`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX0U@0J6QX002<06QXJ00@0fm_K0?l0
o`00o`000?l0o`0J6QX101XJ6P80fm_K2P0J6QX20=_Kf`D06QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX0
6QXJ02@06QXJ00<00?l001XJ6P0J6QX04`0J6QX00`00o`006QXJ01XJ6P0:01XJ6P030?l0o`0J6QX0
6QXJ00806QXJ00<0o`3o01XJ6P0J6QX0U@0J6QX002<06QXJ00@0fm_K0?mo003o0?l00?l0o`0J6QXJ
01XJ6P030=_Kf`0J6QX06QXJ02<06QXJ0P00o`0E01XJ6P800?l02P0J6QX20?l0o`D06QXJ00<0o`3o
01XJ6P0J6QX0U00J6QX002<06QXJ00D0fm_K01XJ6P3o0?l0fm_K003o003o01XJ6QT06QXJ0P3Kfm/T
01XJ6P800?l05@0J6QX2003o00X06QXJ00<0o`3o01XJ6P0J6QX00P00o`0201XJ6P030?l0o`0J6QX0
6QXJ09@06QXJ000S01XJ6P80fm_K00@0o`3o01XJ6P00o`000?l0o`0J6QXH01XJ6P030=_Kf`0J6QX0
6QXJ02<06QXJ0`00o`0401XJ6P03003o000J6QX06QXJ00/06QXJ00<00?l001XJ6P00o`000P00o`09
01XJ6P030?l0o`0J6QX00?l000800?l00P0J6QX00`3o0?l06QXJ01XJ6P2D01XJ6P008`0J6QX01@3K
fm/06QXJ0?mo003o0?l06QXJ00800?l0o`0J6QXG01XJ6P030=_Kf`0J6QX06QXJ02<06QXJ00<00?l0
01XJ6P00o`00100J6QX00`00o`006QXJ01XJ6P0:01XJ6P800?l000@06QXJ003o000J6QX00?l01@0J
6QX00`3o0?l06QXJ01XJ6P020?l0o`0401XJ6P00o`006QXJ003o00806QXJ00<0o`3o01XJ6P0J6QX0
U00J6QX002<06QXJ00L0fm_K01XJ6P0J6QX0o`3o001oo`3Kfm/00?l00?l06QXJ5`0J6QX00`3Kfm/0
6QXJ01XJ6P0S01XJ6P03003o000J6QX00?l000@06QXJ0P00o`0:01XJ6P@00?l00P3o0?l3003o00<0
6QXJ00H0o`3o01XJ6P3o0?l0o`3o01XJ6P00o`0301XJ6P04003o000J6QX06QXJ0?l0oiD06QXJ000S
01XJ6P060=_Kf`0J6QX06QXJ0?mo003o0?l06QXJ0P00o`3o01XJ6QH06QXJ00<0fm_K01XJ6P0J6QX0
8P0J6QX01@00o`006QXJ01XJ6P0J6QX00?l000806QXJ00<00?l001XJ6P00o`00200J6QX6003o0080
o`3o00@00?l001XJ6P3o0?l06QXJ1@3o0?l00`0J6QX00?l0003o000401XJ6P05003o000J6QX0o`3o
01XJ6P3o0?l0T`0J6QX002<06QXJ00P0fm_K01XJ6P0J6QX0ogl00?l0o`00Ool0fm_K003o0?l06QXJ
5P0J6QX20=_Kfb<06QXJ00D00?l001XJ6P0J6QX06QXJ003o000201XJ6P04003o000J6QX00?l0003o
00L06QXJ1P00o`000`3o0?l06QXJ0?l0o`020?l0o`05003o003o0?l0o`3o003o003o0?l00P0J6QX0
0`00o`006QXJ01XJ6P0301XJ6P03003o000J6QX0o`3o00<0o`3oTP0J6QX002<06QXJ00T0fm_K01XJ
6P0J6QX06QXJ0?mo003o0?l0fm_K01XJ6P00o`00o`0J6QXE01XJ6P030=_Kf`0J6QX06QXJ02806QXJ
00@00?l001XJ6P0J6QX06QXJ1000o`000`0J6QX00?l0003o000601XJ6P<00?l000H06QXJ003o0000
o`000?l00?l0o`0J6QX50?l0o`800?l000@0o`3o003o0000o`000?l00`0J6QX00`00Ool06QXJ003o
000301XJ6P80o`3oTP0J6QX002<06QXJ00D0fm_K01XJ6P0J6QX06QXJ0?mo00020?l0o`030=_Kf`0J
6QX00?l00?l06QXJ500J6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P04003o000J6QX06QXJ003o00<06QXJ
1000o`0301XJ6P03003o000J6QX06QXJ00<06QXJ0`00o`0301XJ6P05003o003o0?l06QXJ0?l0o`0J
6QX00`3o0?l201XJ6P@00?l00P0J6QX2001oo`0301XJ6P00o`006QXJ00@06QXJ0P3o0?n@01XJ6P00
8`0J6QX20=_Kf`<06QXJ00D0ogl00?l0o`3Kfm/0fm_K003o003o01XJ6Q@06QXJ00<0fm_K01XJ6P0J
6QX07`0J6QX01000o`006QXJ01XJ6P00o`0301XJ6P<00?l0100J6QX00`00o`006QXJ01XJ6P0201XJ
6P800?l000@06QXJ003o000J6QX06QXJ0P3o0?l501XJ6P050?l0o`0J6QX06QXJ01XJ6P00o`001@0J
6QX2001oo`806QXJ00<00?l001XJ6P0J6QX00P0J6QX20?l0oi006QXJ000S01XJ6P030=_Kf`0J6QX0
6QXJ00806QXJ00<0ogl00?l0o`00Ool00P3Kfm/00`00o`006QXJ01XJ6P3o01XJ6Q406QXJ0P3Kfm/H
01XJ6P03003o000J6QX06QXJ00<06QXJ0P00o`00100J6QX00?l001XJ6P00o`0401XJ6P800?l0100J
6QX00`00o`006QXJ01XJ6P0201XJ6P800?l00`0J6QX30?l0o`D06QXJ00D0o`3o01XJ6P0J6QX06QXJ
003o000401XJ6P8007oo00@06QXJ001oo`00Ool00?l0100J6QX30?l0ohl06QXJ000S01XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00<0ogl00?l0o`0J6QX00P3Kfm/00`00o`006QXJ01XJ6P3o01XJ6Q006QXJ
00<0fm_K01XJ6P0J6QX0500J6QX2003o000501XJ6P00o`000?l001XJ6P00o`000P0J6QX2003o0004
01XJ6P00o`006QXJ003o00X06QXJ00<00?l001XJ6P0J6QX00P0J6QX2003o00<06QXJ0`3o0?l>01XJ
6P06001oo`0J6QX06QXJ01XJ6P00Ool00?l0100J6QX0103o0?l06QXJ0?l0o`3o0?n>01XJ6P008`0J
6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030?mo003o0?l0o`3o00806QXJ0P00o`3o01XJ6Q406QXJ00<0
fm_K01XJ6P0J6QX0500J6QX2003o000601XJ6P00o`000?l001XJ6P00o`006QXJ0`00o`00100J6QX0
0?l001XJ6P00o`0;01XJ6P04003o000J6QX06QXJ01XJ6P800?l00`0J6QX30?l0o`d06QXJ00<007oo
01XJ6P0J6QX00P0J6QX00`00Ool00?l001XJ6P0601XJ6P80o`3oS@0J6QX002<06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX00`3oO`006QXJ0?l0o`0301XJ6P800?l0mP0J6QX20=_Kf`@06QXJ0P3Kfm/401XJ
6P80fm_K0`0J6QX40=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`00o`006QXJ01XJ6P0201XJ
6P/00?l000@06QXJ003o000J6QX00?l02`0J6QX01@00o`006QXJ01XJ6P0J6QX00?l000<06QXJ103o
0?l=01XJ6P03001oo`0J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX01P0J6QX20?l0oh`06QXJ000S
01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0ogl001XJ6P3o0?l00P0J6QX00`3Kfm/00?l001XJ6P3d
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ
01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00l06QXJ00<00?l001XJ6P0J6QX00P0J6QX9003o000301XJ
6P00o`006QXJ00800?l0300J6QX2003o00806QXJ00<00?l001XJ6P0J6QX00`3o0?l00`0J6QX0o`3o
01XJ6P0<01XJ6P03001oo`0J6QX06QXJ00<06QXJ00<007oo003o000J6QX01`0J6QX00`3o0?l06QXJ
01XJ6P2:01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P040?mo000J6QX0o`3o0?l0o`806QXJ
0P00o`3d01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX00`3K
fm/06QXJ01XJ6P0401XJ6P80fm_K1@0J6QX00`00o`006QXJ01XJ6P0801XJ6P800?l00`0J6QX2003o
00D06QXJ0P00o`001@0J6QX00?l001XJ6P0J6QX00?l000`06QXJ0P00o`00100J6QX00?l001XJ6P0J
6QX30?l0o`l06QXJ00<007oo01XJ6P0J6QX0100J6QX01000Ool00?l001XJ6P00o`0601XJ6P030?l0
o`0J6QX06QXJ08X06QXJ000S01XJ6P80fm_K1P0J6QX00`3oO`006QXJ0?l0o`0201XJ6P030=_Kf`00
o`000?l00>d06QXJ103Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0
fm_K100J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00@06QXJ0P00o`0901XJ6P<0
0?l000<06QXJ003o000J6QX01`0J6QX00`00o`006QXJ01XJ6P0201XJ6P03003o000J6QX06QXJ00/0
6QXJ0`00o`0201XJ6P80o`3o400J6QX00`00Ool06QXJ01XJ6P0401XJ6P04001oo`00o`000?l0003o
00L06QXJ00@0o`3o01XJ6P0J6QX0o`3oR00J6QX002<06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX0103o
O`006QXJ001oo`3o0?l201XJ6P030=_Kf`00o`000?l00?806QXJ00@0fm_K01XJ6P0J6QX0fm_K200J
6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P0J
6QX0100J6QX2003o00H06QXJ00<00?l001XJ6P0J6QX00`00o`000`0J6QX00?l001XJ6P0K01XJ6P04
003o000J6QX06QXJ01XJ6P80o`3o400J6QX00`00Ool06QXJ01XJ6P0501XJ6P04001oo`00o`000?l0
003o00H06QXJ00@0o`3o01XJ6P0J6QX0o`3o3@0J6QX00`3o0?l06QXJ01XJ6P1h01XJ6P008`0J6QX0
0`3Kfm/06QXJ01XJ6P0601XJ6P040?mo000J6QX0o`3o0?l0o`806QXJ00<0fm_K003o000J6QX0lP0J
6QX20=_Kf`X06QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P800?l01P0J
6QX3003o000301XJ6P00o`000?l000800?l07`0J6QX00`3o0?l06QXJ0?l0o`0<01XJ6P03001oo`0J
6QX06QXJ008007oo1`0J6QX2001oo`800?l01P0J6QX20?l0o`0301XJ6P3o0?l0o`3o00`06QXJ0P3o
0?mi01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P040?mo000J6QX06QXJ0?l0o`806QXJ00<0
fm_K01XJ6P00o`00o`0J6QX<01XJ6P80fm_K100J6QX00`00o`006QXJ003o000601XJ6P<00?l000<0
6QXJ003o0000o`000P00o`0O01XJ6P030?l0o`0J6QX06QXJ00`06QXJ00@007oo01XJ6P00Ool007oo
2P0J6QX01000Ool00?l001XJ6P00Ool501XJ6P040?l0o`0J6QX0o`3o0?l0o``06QXJ0P3o0?l=01XJ
6P8007ooJP0J6QX001006QXJ0P3Kfm/401XJ6P80fm_K0`0J6QX40=_Kf`@06QXJ00<0fm_K01XJ6P0J
6QX01`0J6QX0103oO`006QXJ01XJ6P3o0?l201XJ6P030=_Kf`00o`000?l00?l06QXJ2`0J6QX00`3K
fm/06QXJ01XJ6P0301XJ6P04003o000J6QX06QXJ003o00D06QXJ0`00o`0301XJ6P800?l07`0J6QX0
0`3o0?l06QXJ01XJ6P0401XJ6P8007oo1@0J6QX4001oo`d06QXJ00<00?l0001oo`00Ool0100J6QX4
0?l0o`/06QXJ0`3o0?l901XJ6P04001oo`0J6QX06QXJ01XJ6P8007ooJP0J6QX000l06QXJ00@0fm_K
01XJ6P0J6QX0fm_K200J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0
ogl001XJ6P0J6QX00P3o0?l201XJ6P030=_Kf`00o`000?l00?l06QXJ2P0J6QX00`3Kfm/06QXJ01XJ
6P0301XJ6P04003o000J6QX06QXJ003o00D06QXJ00<00?l001XJ6P00o`000`0J6QX00`00o`006QXJ
01XJ6P0M01XJ6P80o`3o1P0J6QX2001oo`806QXJ00H007oo01XJ6P00Ool007oo01XJ6P00Ool>01XJ
6P800?l00P00Ool301XJ6P040?l0o`0J6QX06QXJ0?l0o`T06QXJ00@0o`3o01XJ6P3o0?l007oo0P3o
0?l701XJ6P@007oo00@06QXJ001oo`0J6QX007oo3@0J6QX2001ooa006QXJ00<007oo01XJ6P0J6QX0
A`0J6QX000l06QXJ00@0fm_K01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P80fm_K
2@0J6QX0103oO`006QXJ01XJ6P3o0?l201XJ6P80fm_K00<00?l001XJ6P0J6QX0o`0J6QX801XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ00@00?l001XJ6P0J6QX00?l0100J6QX00`00o`006QXJ01XJ6P0401XJ
6PD0fm_K0P0J6QX20=_Kf`@06QXJ0P3Kfm/901XJ6P030?l0o`0J6QX06QXJ00806QXJ0`3Kfm/20?l0
o`806QXJ0P3Kfm/201XJ6PD007oo00D06QXJ001oo`00Ool06QXJ001oo`0901XJ6P80fm_K0`0J6QX2
003o00<007oo0P0J6QX01@3o0?l0fm_K01XJ6P0J6QX0o`3o00P06QXJ0`3o0?l2001oo`80o`3o00<0
fm_K01XJ6P0J6QX00P3Kfm/00`0J6QX007oo01XJ6P02001oo`040=_Kf`00Ool06QXJ001oo`/06QXJ
0P3Kfm/2001oo`806QXJ0P3Kfm/401XJ6P80fm_K1P0J6QX2001oo`H06QXJ0`3Kfm/401XJ6P80fm_K
100J6QX20=_Kfa006QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20=_Kf`@06QXJ0P3Kfm/F01XJ6P003`0J
6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0
200J6QX20?mo000301XJ6P00Ool0o`3o00806QXJ00<0fm_K01XJ6P00o`00o`0J6QX901XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00@00?l001XJ6P0J6QX00?l0100J6QX00`00o`006QXJ01XJ6P0601XJ6P05
0=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0
6QXJ00H06QXJ0P3o0?l301XJ6P030=_Kf`0J6QX06QXJ0080o`3o00P06QXJ0=_Kf`0J6QX06QXJ0=_K
f`0J6QX007oo0=_Kf`D007oo2`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P<00?l000@0fm_K001o
o`00Ool0fm_K0P0J6QX00`3Kfm/06QXJ0?l0o`0301XJ6P030?l0o`0J6QX06QXJ00806QXJ0`3o0?l0
0`0J6QX007oo001oo`020?l0o`0301XJ6P3Kfm/06QXJ008007oo0P3o0?l00`3Kfm/06QXJ001oo`02
0?l0o`03001oo`0J6QX007oo00@06QXJ00D007oo01XJ6P00Ool007oo0=_Kf`0201XJ6P<007oo00@0
fm_K01XJ6P0J6QX007oo0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/501XJ6P<007oo1@0J6QX0103Kfm/0
07oo001oo`00Ool201XJ6P04001oo`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K1000
Ool;01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P03
0=_Kf`0J6QX06QXJ01<06QXJ000?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J
6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P050?mo000J6QX06QXJ001oo`3o0?l00P0J6QX0
0`3Kfm/00?l0003o003o01XJ6PP06QXJ0P3Kfm/401XJ6P04003o000J6QX06QXJ003o00<06QXJ0P00
o`0801XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P03
0=_Kf`0J6QX06QXJ00H06QXJ0`3o0?l301XJ6P030=_Kf`0J6QX0o`3o00806QXJ00T0fm_K01XJ6P0J
6QX0fm_K01XJ6P00Ool0fm_K001oo`0J6QX00`00Ool=01XJ6P060=_Kf`0J6QX06QXJ01XJ6P3Kfm/0
6QXJ0P00o`000`0J6QX007oo0=_Kf`0201XJ6P06001oo`0J6QX0o`3o01XJ6P3o0?l06QXJ0`3o0?l2
01XJ6P030?l0o`0J6QX007oo00<0fm_K00D0o`3o001oo`3o0?l0o`3o01XJ6P030?l0o`0401XJ6P3o
0?l06QXJ001oo`80o`3o00<06QXJ001oo`00Ool0100J6QX4001oo`<06QXJ00<007oo01XJ6P00Ool0
0P00Ool01@0J6QX007oo01XJ6P0J6QX0fm_K00806QXJ00P0fm_K01XJ6P0J6QX06QXJ001oo`0J6QX0
07oo01XJ6P<007oo0`0J6QX5001oo`0501XJ6P00Ool007oo01XJ6P3Kfm/00P0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/5001oo`X06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00<0fm_K01XJ6P0J6QX04`0J6QX001006QXJ0P3Kfm/:01XJ6P80fm_K1@0J6QX00`3K
fm/06QXJ01XJ6P0:01XJ6P030?mo000J6QX06QXJ0080o`3o00<06QXJ0=_Kf`3Kfm/00P00o`3o01XJ
6PL06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX01000o`006QXJ01XJ6P00o`0301XJ6P800?l0200J6QX0
1@3Kfm/06QXJ01XJ6P0J6QX0fm_K00806QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX00`3Kfm/06QXJ
01XJ6P0501XJ6P030?l0o`0J6QX0o`3o0080o`3o0`0J6QX01@3Kfm/0o`3o01XJ6P0J6QX0fm_K0080
6QXJ0P00Ool01P0J6QX0fm_K01XJ6P0J6QX0fm_K001oo`l06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J
6QX01000o`006QXJ01XJ6P00Ool201XJ6P03001oo`0J6QX06QXJ00H0o`3o00<06QXJ0?l0o`00Ool0
0P00Ool01@3Kfm/06QXJ01XJ6P00Ool06QXJ0080o`3o00D007oo0?l0o`3o0?l0o`3o01XJ6P020?l0
o`04001oo`3o0?l0o`3o01XJ6P<007oo0`0J6QX5001oo`040=_Kf`00Ool007oo01XJ6PH007oo00D0
6QXJ0=_Kf`0J6QX06QXJ0=_Kf`0201XJ6P<007oo0`0J6QX2001oo`<06QXJ0P00Ool00`3Kfm/06QXJ
001oo`04001oo`040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K001oo`0J6QX00P0J6QX2001oo`X0
6QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX0
6QXJ01<06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00@0ogl001XJ6P0J6QX06QXJ0P3o0?l0
0`0J6QX0fm_K01XJ6P02003o0?l06QXJ1P0J6QX0103Kfm/06QXJ01XJ6P00o`0201XJ6P04003o000J
6QX06QXJ003o00806QXJ0P00o`0901XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0?l0o`@06QXJ00L0o`3o01XJ6P3o0?l06QXJ0?l0
o`0J6QX0fm_K00806QXJ00D0o`3o01XJ6P0J6QX0fm_K01XJ6P03001oo`0601XJ6P3Kfm/06QXJ01XJ
6P3Kfm/007oo300J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00800?l000@0
6QXJ001oo`0J6QX06QXJ0P00Ool00`0J6QX0o`3o0?l0o`060?l0o`<007oo00@06QXJ0=_Kf`0J6QX0
fm_K0P0J6QX20?l0o`0:01XJ6P3o0?l0o`3o01XJ6P3Kfm/0o`3o01XJ6P3o0?l06QXJ0?l0o`806QXJ
00D007oo01XJ6P0J6QX06QXJ001oo`0301XJ6P<007oo0`0J6QX01`00Ool06QXJ001oo`3Kfm/007oo
01XJ6P3Kfm/00P0J6QX01P3Kfm/06QXJ001oo`00Ool06QXJ001oo`D06QXJ0P00Ool00`0J6QX007oo
0=_Kf`0301XJ6P03001oo`3Kfm/007oo00<007oo00H06QXJ001oo`0J6QX06QXJ0=_Kf`00Ool401XJ
6P8007oo1P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00@0
fm_K01XJ6P0J6QX0fm_K5@0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX20?mo00806QXJ00@0
07oo0?l0o`0J6QX06QXJ0P3Kfm/2003o0?l06QXJ1@0J6QX01@3Kfm/06QXJ01XJ6P00o`006QXJ0080
0?l00P0J6QX2003o000301XJ6P00o`000?l000P06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kf`80
6QXJ0`3o0?l301XJ6P050?l0o`0J6QX06QXJ01XJ6P3o0?l00P0J6QX20=_Kf`050?l0o`0J6QX06QXJ
01XJ6P3Kfm/00`00Ool201XJ6P80fm_K3`0J6QX20=_Kf`@06QXJ0P3Kfm/00`0J6QX00?l0003o0002
001oo`030=_Kf`00Ool007oo00L06QXJ00@0o`3o01XJ6P00Ool007oo0`0J6QX20=_Kf`806QXJ0P3o
0?l00`3Kfm/06QXJ01XJ6P0201XJ6P050=_Kf`3o0?l0o`3o01XJ6P3o0?l00`0J6QX4001oo`<06QXJ
0`00Ool0103Kfm/06QXJ01XJ6P0J6QX20=_Kf`0401XJ6P00Ool007oo01XJ6P80fm_K1000Ool701XJ
6P@007oo0`3Kfm/301XJ6P80fm_K1000Ool20=_Kf`03001oo`0J6QX06QXJ00@06QXJ0P00Ool501XJ
6P<007oo00@0fm_K01XJ6P0J6QX06QXJ0P3Kfm/401XJ6P80fm_K5P0J6QX002<06QXJ00<0fm_K01XJ
6P0J6QX02`0J6QX01P3oO`006QXJ01XJ6P0J6QX007oo0?l0o`806QXJ0P3Kfm/00`00o`006QXJ01XJ
6P3o01XJ6P<06QXJ00H0fm_K01XJ6P0J6QX00?l001XJ6P00o`0401XJ6P04003o000J6QX00?l0003o
01P06QXJ00<0o`3o01XJ6P3o0?l00`0J6QX00`3o0?l06QXJ01XJ6P0201XJ6P040?l0o`0J6QX06QXJ
0?l0o`D06QXJ0`00OolM01XJ6P04003o000J6QX007oo01XJ6P8007oo2@0J6QX00`00Ool06QXJ01XJ
6P0>01XJ6P040?l0o`0J6QX06QXJ0?l0o`<06QXJ0`00Ool501XJ6P8007oo200J6QX01000Ool06QXJ
01XJ6P0J6QX3001oo`P06QXJ00@007oo01XJ6P00Ool007oo2@0J6QX01P00Ool06QXJ01XJ6P00Ool0
6QXJ001oo`L06QXJ0P00Ool401XJ6PD007oo800J6QX002<06QXJ0P3Kfm/=01XJ6P060?mo000J6QX0
6QXJ01XJ6P00Ool0o`3o0P0J6QX00`3Kfm/00?l0003o003o01XJ6P@06QXJ00<0o`3o0=_Kf`0J6QX0
0`00o`0401XJ6P<00?l06@0J6QX00`3o0?l06QXJ0?l0o`0301XJ6P030?l0o`0J6QX06QXJ00806QXJ
103o0?l401XJ6P@007oo7@0J6QX01P00o`006QXJ001oo`00Ool06QXJ001oo`@06QXJ0`00Ool00`0J
6QX007oo01XJ6P0@01XJ6P060?l0o`0J6QX06QXJ0?l0o`0J6QX0o`3o4`0J6QX2001oo`0501XJ6P00
Ool007oo01XJ6P00Ool0600J6QX3001oo`T06QXJ00D007oo01XJ6P0J6QX06QXJ001oo`0201XJ6P<0
07oo7`0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0300J6QX20?mo00<06QXJ0P3o0?l201XJ6P030=_K
f`00o`000?l00?l06QXJ0`0J6QX00`3o0?l06QXJ01XJ6P02003o00H06QXJ00<00?l001XJ6P0J6QX0
600J6QX00`3o0?l06QXJ01XJ6P040?l0o`@06QXJ0`3o0?l501XJ6P8007oo00<06QXJ001oo`0J6QX0
7@0J6QX00`00o`0007oo01XJ6P0201XJ6P04001oo`0J6QX007oo01XJ6P<007oo00<06QXJ001oo`0J
6QX0500J6QX20?l0oa@06QXJ0`00OolL01XJ6P03001oo`0J6QX06QXJ00P06QXJ1000Ool501XJ6P@0
07oo700J6QX002<06QXJ00<0fm_K01XJ6P0J6QX03@0J6QX01@3oO`006QXJ01XJ6P0J6QX007oo0080
o`3o00<06QXJ0=_Kf`0J6QX00P00o`3o01XJ6P806QXJ00@0o`3o01XJ6P0J6QX00?l01`0J6QX00`00
o`006QXJ01XJ6P0H01XJ6P030?l0o`0J6QX06QXJ00<0o`3o1`0J6QX00`3o0?l06QXJ01XJ6P0201XJ
6P<007oo800J6QX00`00o`006QXJ01XJ6P0201XJ6P03001oo`0J6QX007oo00<007oo00<06QXJ001o
o`0J6QX05@0J6QX30?l0o`<06QXJ00<0o`3o01XJ6P0J6QX0>00J6QX3001oo`H06QXJ1000Ool301XJ
6P<007oo5@0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX01@3oO`006QXJ01XJ6P0J6QX007oo
0080o`3o0P3Kfm/00`0J6QX00?l001XJ6P3o01XJ6P406QXJ00@0o`3o01XJ6P00o`000?l08@0J6QX0
103o0?l06QXJ01XJ6P0J6QX30?l0o`/06QXJ0P00OolR01XJ6P05003o000J6QX06QXJ003o000J6QX0
1000OolL01XJ6P040?l0o`0J6QX06QXJ01XJ6P@0o`3o0`0J6QX20?l0oc@06QXJ00<007oo01XJ6P0J
6QX01`0J6QX8001ooa@06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ00h06QXJ00<0ogl001XJ6P0J6QX0
0P0J6QX01`00Ool0o`3o0?l0o`0J6QX0fm_K01XJ6P00o`00n`0J6QX50=_Kf`040?l0o`00o`000?l0
003o0240fm_K00@0o`3o0=_Kf`3Kfm/0fm_K0P3o0?l<0=_Kf`8007oo8P3Kfm/2003o00040=_Kf`00
o`00fm_K0=_Kf`8007oo7@3Kfm/20?l0o`80fm_K103o0?l30=_Kf`80o`3o?`3Kfm/4001oo`<0o`3o
1P3Kfm/>01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P030?mo000J6QX06QXJ00806QXJ00<0
07oo0?l0o`0J6QX00P3Kfm/00`0J6QX00?l001XJ6P3n01XJ6P030?l0o`00o`000?l000<06QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX0o`3o00806QXJ00<0
fm_K01XJ6P3o0?l00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX007oo008007oo00<0
6QXJ0=_Kf`0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0
0?l001XJ6P00o`000`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0
fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00D0
fm_K01XJ6P3o0?l0o`3o01XJ6P040?l0o`<06QXJ0P3o0?l301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ
00<0fm_K01XJ6P0J6QX00P0J6QX20?l0o`D06QXJ00<0fm_K01XJ6P0J6QX03P0J6QX002<06QXJ00<0
fm_K01XJ6P0J6QX03`0J6QX20?mo00@06QXJ00@007oo0?l0o`0J6QX0fm_K0P0J6QX00`00o`006QXJ
01XJ6P3l01XJ6P030?l0o`0J6QX00?l001X06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ
01XJ6P0>01XJ6P05001oo`0J6QX007oo01XJ6P3Kfm/0700J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P04
003o000J6QX00?l0003o01@06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX40?l0o`<06QXJ00H0o`3o01XJ
6P0J6QX0o`3o01XJ6P3o0?l201XJ6P030=_Kf`0J6QX06QXJ01X06QXJ00<0fm_K01XJ6P0J6QX06P0J
6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ01D06QXJ000S01XJ6P80fm_K4@0J6QX2
0?mo00<06QXJ0P00Ool00`3o0?l06QXJ0=_Kf`0201XJ6P03003o000J6QX06QXJ0?/06QXJ00<0o`3o
01XJ6P0J6QX08P0J6QX00`3o0?l06QXJ01XJ6P0>01XJ6P03001oo`0J6QX06QXJ02<06QXJ1000o`0R
01XJ6P80o`3o100J6QX40?l0o`0301XJ6P3o0?l0o`3o00806QXJ00<0o`3o01XJ6P0J6QX0>`0J6QX0
0`3o0?l06QXJ01XJ6P0E01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P030?mo000J6QX06QXJ
00806QXJ0P00Ool0103o0?l06QXJ0=_Kf`0J6QX2003o0?`06QXJ00<0o`3o01XJ6P0J6QX08P0J6QX0
0`3o0?l06QXJ01XJ6P0501XJ6P03001oo`0J6QX06QXJ00H06QXJ00<007oo01XJ6P0J6QX08`0J6QX0
1000o`006QXJ01XJ6P00o`0<01XJ6P03003o000J6QX06QXJ01T06QXJ0`3o0?l301XJ6P80o`3o00<0
6QXJ0?l0o`0J6QX02P0J6QX00`3o0?l06QXJ01XJ6P0/01XJ6P@0o`3o5`0J6QX002<06QXJ00<0fm_K
01XJ6P0J6QX04@0J6QX20?mo00@06QXJ00H007oo0?l0o`3o0?l06QXJ0=_Kf`0J6QX2003o0?/06QXJ
00<0o`3o0=_Kf`0J6QX08P0J6QX00`3o0?l06QXJ01XJ6P0501XJ6P03001oo`0J6QX06QXJ00D06QXJ
0P00OolX01XJ6P03003o000J6QX06QXJ00X06QXJ0P00o`0K01XJ6P80o`3o0`0J6QX00`3o0?l06QXJ
0?l0o`020?l0o`X06QXJ00<0o`3o01XJ6P0J6QX0900J6QX00`3o0?l06QXJ0?l0o`0201XJ6PH0o`3o
600J6QX002<06QXJ00<0fm_K01XJ6P0J6QX04P0J6QX00`3oO`006QXJ01XJ6P0301XJ6P03001oo`3o
0?l0o`3o0080fm_K00<06QXJ003o0000o`00nP0J6QX00`3o0?l06QXJ01XJ6P0O01XJ6P040?l0o`0J
6QX06QXJ0?l0o`L06QXJ0P00Ool601XJ6P8007oo:@0J6QX00`00o`006QXJ01XJ6P0901XJ6P800?l0
700J6QX00`3o0?l06QXJ01XJ6P0301XJ6P030?l0o`0J6QX0o`3o00P06QXJ00<0o`3o01XJ6P3o0?l0
0P3o0?lH01XJ6P030?l0o`0J6QX06QXJ00L06QXJ103o0?l01@00o`00o`3o0?l0o`3o0?l0ogl00080
0?l06P0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX04`0J6QX00`3oO`006QXJ01XJ6P0301XJ6P03001o
o`3o0?l0o`3o0080fm_K00<06QXJ003o000J6QX0n@0J6QX00`3o0?l007oo01XJ6P0O01XJ6P060?l0
o`0J6QX06QXJ0?l0o`0J6QX007oo1@0J6QX3001oo`D06QXJ0P00OolY01XJ6P03003o000J6QX06QXJ
00P06QXJ00<00?l001XJ6P00o`00900J6QX00`3o0?l06QXJ01XJ6P0501XJ6P80o`3o00@06QXJ0?l0
o`0J6QX0o`3o1`0J6QX00`3o0?l06QXJ01XJ6P0;01XJ6PH0o`3o1`0J6QX20?l0o`D00?l000<0ogl0
01XJ6P0J6QX06`0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`3oO`006QXJ01XJ6P0301XJ
6P07001oo`3o0?l0o`3o01XJ6P3Kfm/06QXJ003o003i01XJ6P030?mo003o0?l06QXJ01l06QXJ0P3o
0?l0100J6QX0o`3o001oo`00Ool401XJ6P03001oo`0J6QX007oo008007oo100J6QX00`00Ool06QXJ
01XJ6P0X01XJ6P05003o000J6QX00?l001XJ6P00o`00100J6QX3003o000301XJ6P00o`000?l002@0
6QXJ00<0o`3o01XJ6P0J6QX0100J6QX30?l0o`806QXJ0`3o0?l401XJ6P<0o`3o0P0J6QX00`3o0?l0
6QXJ01XJ6P0701XJ6P040?l0o`0J6QX0o`3o01XJ6P<0o`3o1P0J6QX01@3o0?l00?l00?mo003oO`00
6QXJ0080ogl07P0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0500J6QX20?mo00D06QXJ00<007oo0?l0
o`3o0?l00P3Kfm/00`0J6QX00?l001XJ6P3g01XJ6P030=_Kf`3o0?l06QXJ01d06QXJ0P3o0?l0100J
6QX0o`3o0?l0o`0J6QX3001oo`<06QXJ00D007oo01XJ6P00Ool06QXJ001oo`0401XJ6P03001oo`0J
6QX06QXJ02T06QXJ1@00o`0301XJ6P<00?l00P0J6QX2003o02<06QXJ0P3o0?l201XJ6P@0o`3o00<0
6QXJ0?l0o`0J6QX00P0J6QX20?l0o`<06QXJ0P3o0?l0100J6QX0o`3o0?l0o`0J6QX20?l0o`P06QXJ
00<0o`3o01XJ6P0J6QX00`0J6QX30?l0o`@06QXJ00@0o`3o003o000J6QX0ogl08@0J6QX002<06QXJ
0P3Kfm/F01XJ6P030?mo000J6QX06QXJ00@06QXJ00@007oo0?l0o`3o0?l0fm_K0P0J6QX00`00o`00
6QXJ01XJ6P3e01XJ6P030=_Kf`3o0?l06QXJ01d06QXJ0P3o0?l01`0J6QX0o`3o0?l0o`0J6QX007oo
01XJ6P00Ool00`0J6QX01@00Ool06QXJ01XJ6P0J6QX007oo00@06QXJ00<007oo01XJ6P0J6QX0:@0J
6QX6003o00806QXJ0P00o`0401XJ6P800?l01@0J6QX2003o01`06QXJ00<0o`3o01XJ6P0J6QX00`3o
0?l801XJ6P80o`3o00<06QXJ0?l0o`3o0?l00P0J6QX50?l0o`L06QXJ00<0o`3o01XJ6P0J6QX01@0J
6QX30?l0o`0401XJ6P3o0?l00?l00?mo02<06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0
ogl001XJ6P0J6QX00`0J6QX2001oo`80o`3o00@0fm_K01XJ6P0J6QX00?l0mP0J6QX00`3Kfm/0o`3o
01XJ6P0M01XJ6P80o`3o00L06QXJ0?l0o`3o0?l06QXJ001oo`0J6QX007oo00<06QXJ00D007oo01XJ
6P0J6QX06QXJ001oo`0401XJ6P03001oo`0J6QX06QXJ02T06QXJ0P00o`0201XJ6P800?l000<06QXJ
003o000J6QX01@0J6QX00`00o`006QXJ003o000401XJ6P<00?l00P0J6QX2003o01L06QXJ103o0?l0
0`0J6QX0o`3o01XJ6P0701XJ6P@0o`3o100J6QX00`3o0?l06QXJ01XJ6P050?l0o`806QXJ00L0o`3o
01XJ6P0J6QX06QXJ003o000J6QX00?l000<06QXJ103o0?l00`00o`006QXJ01XJ6P0R01XJ6P008`0J
6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P80ogl01@0J6QX2001oo`80o`3o00@0fm_K01XJ6P00o`000?l0
m@0J6QX00`3Kfm/0o`3o01XJ6P0L01XJ6P<0o`3o0P0J6QX00`3o0?l06QXJ001oo`0201XJ6P@007oo
100J6QX2001oo`0301XJ6P00Ool06QXJ03406QXJ0P00o`0801XJ6P800?l000D06QXJ003o0000o`00
0?l001XJ6P02003o000301XJ6P00o`000?l001P06QXJ00<0o`3o01XJ6P0J6QX02P0J6QX0103o0?l0
6QXJ0?l0o`3o0?l801XJ6PD0o`3o00<06QXJ0?l0o`0J6QX00P00o`000`0J6QX00?l0003o0003003o
00<06QXJ00<0o`3o0?mo000J6QX08`0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX20?mo00D0
6QXJ0P00Ool20?l0o`80fm_K00<06QXJ003o000J6QX0l`0J6QX00`3Kfm/0o`3o01XJ6P0L01XJ6P<0
o`3o100J6QX00`00Ool06QXJ01XJ6P03001oo`D06QXJ1000Oolm01XJ6PD00?l000@06QXJ003o0000
o`006QXJ0`00o`0W01XJ6P030?l0o`0J6QX06QXJ00X06QXJ0`3o0?l3003o00<06QXJ1`00o`000`3o
O`006QXJ01XJ6P0R01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0H01XJ6P030?mo000J6QX06QXJ00@0
6QXJ0P00Ool20?l0o`040=_Kf`0J6QX06QXJ003o0?<06QXJ00<0fm_K0?l0o`00Ool05`0J6QX01P3o
0?l06QXJ01XJ6P3o0?l06QXJ0?l0o`D06QXJ00@007oo01XJ6P0J6QX06QXJ0`00Ool501XJ6P<007oo
?P0J6QX2003o000301XJ6P00o`006QXJ00<06QXJ0P00o`000`0J6QX00?l001XJ6P0d01XJ6P030?l0
o`0J6QX00?l000P06QXJ1000o`0U01XJ6P00400J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P<0fm_K0`0J
6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030?mo000J6QX06QXJ00@06QXJ0P00Ool20?l0o`040=_Kf`0J
6QX06QXJ003o0?806QXJ00@0fm_K0?l0o`00Ool007oo5P0J6QX20?l0o`0401XJ6P3o0?l0o`3o0?l0
o`D06QXJ00@007oo01XJ6P0J6QX06QXJ0`00Ool701XJ6P03001oo`0J6QX06QXJ03`06QXJ00<00?l0
01XJ6P0J6QX01@0J6QX01000o`006QXJ01XJ6P00o`0g01XJ6P07003o000J6QX06QXJ0?mo000J6QX0
ogl001XJ6P020?mo000401XJ6P3oO`00ogl00?mo02D06QXJ000?01XJ6P040=_Kf`0J6QX06QXJ0=_K
f`/06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P80ogl01P0J6QX2001o
o`80o`3o0P0J6QX2003o0?406QXJ00@0fm_K0?mo003o0?l007oo5P0J6QX20?l0o`0401XJ6P3o0?l0
o`3o0?l0o`D06QXJ00<007oo01XJ6P0J6QX00P0J6QX00`00Ool06QXJ01XJ6P1=01XJ6P06003o000J
6QX06QXJ003o000J6QX00?l0=00J6QX2003o000301XJ6P3oO`00ogl000T0ogl09@0J6QX000l06QXJ
00@0fm_K01XJ6P0J6QX0fm_K200J6QX50=_Kf`<06QXJ0P3Kfm/K01XJ6P80ogl01P0J6QX2001oo`80
o`3o0P0J6QX2003o0=L06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kf`<06QXJ103Kfm/401XJ6P04
0=_Kf`3oO`00o`3o0?l0oa@06QXJ00<0o`3o01XJ6P3o0?l01@3o0?l501XJ6P03001oo`0J6QX06QXJ
05H06QXJ0P00o`0<01XJ6P03003o000J6QX06QXJ01`06QXJ0P00o`0701XJ6P04003o000J6QX0ogl0
0?mo02l06QXJ000?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J
6QX00`3Kfm/06QXJ01XJ6P0K01XJ6P80ogl01P0J6QX2001oo`040=_Kf`3o0?l06QXJ01XJ6P800?l0
e@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ00<0fm_K01XJ
6P0J6QX01@0J6QX0103Kfm/0ogl00?l0o`3o0?l301XJ6P030?l0o`0J6QX06QXJ00d06QXJ103o0?l:
01XJ6P03001oo`0J6QX06QXJ05H06QXJ0`00o`0301XJ6P03003o000J6QX00?l000@06QXJ0P00o`0@
01XJ6P03003o000J6QX06QXJ00H06QXJ1000o`00100J6QX00?l0003o0000o`0201XJ6P800?l00P0J
6QX00`00o`00ogl00?mo000`01XJ6P003`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J
6QX0fm_K00@06QXJ00<0fm_K01XJ6P0J6QX0700J6QX00`3oO`006QXJ01XJ6P0501XJ6P8007oo00@0
fm_K0?l0o`0J6QX06QXJ0P00o`3D01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J
6QX0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P040=_Kf`3oO`00o`3o0?l0o`<06QXJ00<0o`3o
01XJ6P0J6QX03@0J6QX40?l0o`L06QXJ00@007oo01XJ6P0J6QX007ooF@0J6QX2003o00<06QXJ1000
o`0301XJ6P800?l0400J6QX2003o00L06QXJ00<00?l001XJ6P00o`003000o`000`3oO`006QXJ01XJ
6P0_01XJ6P00400J6QX20=_Kf`/06QXJ0P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ01d06QXJ00<0ogl0
01XJ6P0J6QX01@0J6QX2001oo`040=_Kf`3o0?l0o`3o01XJ6P800?l0d`0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0203Kfm/0
ogl00?l0o`3o0?l007oo01XJ6P00Ool0o`3o3`0J6QX30?l0o`P06QXJ00@007oo01XJ6P0J6QX007oo
FP0J6QX2003o00806QXJ1000o`0301XJ6P03003o000J6QX00?l000<06QXJ00<00?l001XJ6P0J6QX0
2@0J6QX4003o00@06QXJ0P00o`0301XJ6P04003o000J6QX06QXJ01XJ6P800?l00`0J6QX00`00o`00
6QXJ0?mo000a01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0M01XJ6P80ogl0200J6QX01@00Ool06QXJ
0?l0o`3o0?l06QXJ00800?l0dP0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX01P3Kfm/06QXJ0?l0o`3o0?l007oo01XJ6P<0
o`3o3P0J6QX20?l0o`T06QXJ0P00Ool00`0J6QX007oo01XJ6P1J01XJ6P800?l000L06QXJ003o000J
6QX00?l001XJ6P00o`006QXJ00800?l000H06QXJ003o0000o`000?l001XJ6P00o`0901XJ6P04003o
000J6QX00?l001XJ6P<00?l00`0J6QX00`00o`006QXJ01XJ6P0=01XJ6P030?mo000J6QX06QXJ02l0
6QXJ000S01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ0P3oO`0701XJ6P8007oo00@06QXJ0?l0o`3o0?l0
6QXJ0P00o`3B01XJ6P80fm_K2P0J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX0o`3o0080
o`3o00@06QXJ0?l0o`0J6QX0o`3o2@0J6QX00`3o0?l06QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ
00H06QXJ0P00Ool0100J6QX007oo01XJ6P00OomK01XJ6P@00?l00`0J6QX3003o00<06QXJ1@00o`07
01XJ6P<00?l0100J6QX5003o00h06QXJ00<0ogl001XJ6P0J6QX0<00J6QX002<06QXJ00<0fm_K01XJ
6P0J6QX07`0J6QX20?mo00P06QXJ00D007oo01XJ6P3o0?l0o`3o01XJ6P02003o0>X06QXJ0P3Kfm/0
1`3oO`00o`3o0?l0o`0J6QX0o`3o01XJ6P3o0?l02@0J6QX00`3o0?l06QXJ01XJ6P0201XJ6P030?l0
o`0J6QX06QXJ00H06QXJ0P00Ool00`0J6QX007oo001oo`1M01XJ6P800?l0100J6QX3003o00<06QXJ
00D00?l001XJ6P00o`006QXJ003o000701XJ6P03003o000J6QX00?l000D06QXJ1000o`0>01XJ6P03
0?mo000J6QX06QXJ03006QXJ000S01XJ6P80fm_K8@0J6QX20?mo00P06QXJ00D007oo0=_Kf`3o0?l0
o`3o01XJ6P02003o0>T06QXJ00T0fm_K01XJ6P3oO`006QXJ0?l0o`00Ool0o`3o01XJ6P3o0?l02@0J
6QX20?l0o`806QXJ00D0o`3o01XJ6P0J6QX06QXJ001oo`0401XJ6P<007oo00<06QXJ001oo`00Ool0
I00J6QX2003o00L06QXJ0P00o`0301XJ6P@00?l01`0J6QX01000o`006QXJ01XJ6P00o`0;01XJ6P04
0?mo000J6QX06QXJ0?mo03806QXJ000S01XJ6P030=_Kf`0J6QX06QXJ02406QXJ0P3oO`0801XJ6P80
07oo00<06QXJ0?l0o`0J6QX00P00o`3X01XJ6P070=_Kf`0J6QX0ogl001XJ6P3o0?l007oo0?l0o`02
01XJ6P030?l0o`0J6QX06QXJ00H06QXJ1@3o0?l301XJ6P8007oo00<06QXJ001oo`0J6QX00`00Ool2
01XJ6P03001oo`0J6QX06QXJ06<06QXJ00<00?l001XJ6P0J6QX01P0J6QX01000o`006QXJ01XJ6P0J
6QX3003o01H06QXJ103oO`0c01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0R01XJ6P80ogl0200J6QX2
001oo`030=_Kf`3o0?l0o`3o00800?l0i`0J6QX00`3Kfm/06QXJ0?mo000201XJ6P80o`3o0P0J6QX0
0`3o0?l06QXJ01XJ6P0601XJ6PD0o`3o0P00Ool0100J6QX007oo001oo`0J6QX3001oo`0501XJ6P00
Ool06QXJ01XJ6P00Ool0KP0J6QX2003o000501XJ6P00o`000?l001XJ6P00o`004@0J6QX0103oO`00
6QXJ01XJ6P0J6QX50?mo03<06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ02<06QXJ00<0ogl001XJ6P0J
6QX01`0J6QX2001oo`030=_Kf`3o0?l0o`3o00800?l0iP0J6QX00`3Kfm/06QXJ0?mo000201XJ6P80
o`3o0P0J6QX00`3o0?l06QXJ01XJ6P0301XJ6P<0o`3o00<06QXJ0?l0o`3o0?l00P3o0?l2001oo`03
01XJ6P00Ool007oo00@007ooM00J6QX3003o01@06QXJ1@3oO`0g01XJ6P008`0J6QX00`3Kfm/06QXJ
01XJ6P0T01XJ6P030?mo000J6QX06QXJ00L06QXJ0P00Ool01@3Kfm/0o`3o0?l0o`0J6QX00?l00>D0
6QXJ0P3Kfm/20?mo000301XJ6P3o0?l0o`3o00806QXJ00<0o`3o01XJ6P0J6QX00`0J6QX30?l0o`05
001oo`0J6QX06QXJ0?l0o`0J6QX02@00Oome01XJ6P03003o000J6QX06QXJ01<06QXJ00<0ogl001XJ
6P3oO`00>@0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX09@0J6QX00`3oO`006QXJ01XJ6P0701XJ6P80
07oo00D06QXJ0?l0o`3o0?l06QXJ003o003T01XJ6P040=_Kf`0J6QX0ogl00?mo00D06QXJ00<0o`3o
01XJ6P0J6QX00`0J6QX30?l0o`05001oo`0J6QX06QXJ0?l0o`0J6QX01000Ool401XJ6P03001oo`0J
6QX06QXJ08D06QXJ103oO`0l01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0V01XJ6P030?mo000J6QX0
6QXJ00P06QXJ00<007oo01XJ6P3Kfm/00P3o0?l00`00o`006QXJ01XJ6P3Q01XJ6P040=_Kf`0J6QX0
ogl00?mo00D06QXJ00<0o`3o01XJ6P0J6QX00`0J6QX30?l0o`8007oo0`0J6QX2001oohd06QXJ0`3o
O`000`0J6QX0ogl001XJ6P0k01XJ6P008`0J6QX20=_KfbP06QXJ00<0ogl001XJ6P0J6QX0200J6QX2
001oo`030=_Kf`3o0?l0o`3o00800?l0h@0J6QX0103Kfm/06QXJ01XJ6P3oO`0501XJ6P030?l0o`0J
6QX06QXJ00806QXJ00@0o`3o001oo`0J6QX06QXJ0`00Ool201XJ6P03001oo`0J6QX06QXJ08`06QXJ
00<0ogl001XJ6P0J6QX0?P0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX09`0J6QX20?mo00X06QXJ0P00
Ool00`3Kfm/0o`3o0?l0o`02003o0>006QXJ0P3Kfm/00`0J6QX0ogl001XJ6P0401XJ6P030?l0o`0J
6QX06QXJ00806QXJ00@0o`3o001oo`00Ool06QXJ0`00Ool00`0J6QX007oo01XJ6P2=01XJ6P80ogl0
@00J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0:00J6QX20?mo00X06QXJ0P00Ool00`3Kfm/0o`3o0?l0
o`02003o0=l06QXJ00@0fm_K01XJ6P0J6QX0ogl01@0J6QX0103o0?l06QXJ01XJ6P0J6QX20?l0o`<0
07oo00<06QXJ001oo`00Ool00P00Oon>01XJ6P030?mo000J6QX06QXJ03l06QXJ000S01XJ6P030=_K
f`0J6QX06QXJ02X06QXJ00<0ogl001XJ6P0J6QX0200J6QX2001oo`050=_Kf`0J6QX0o`3o0?l0o`00
o`00gP0J6QX0103Kfm/06QXJ01XJ6P3oO`0501XJ6P030?l0o`0J6QX06QXJ00<0o`3o0`00Ool00`0J
6QX007oo001oo`02001oohh06QXJ00<0ogl001XJ6P0J6QX0?`0J6QX002<06QXJ00<0fm_K01XJ6P0J
6QX0:P0J6QX20?mo00/06QXJ0P00Ool0100J6QX0o`3o0?l0o`00o`3401XJ6P80fm_K100J6QX20=_K
f`@06QXJ0P3Kfm/501XJ6P<0fm_K0`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0ogl000@06QXJ00<007oo
0?l0o`0J6QX00P3o0?l01000Ool06QXJ01XJ6P00Ool301XJ6P8007ooQP0J6QX30?mo000401XJ6P3o
O`006QXJ01XJ6P80ogl0@@0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0:`0J6QX20?mo00/06QXJ0P00
Ool0100J6QX0o`3o0?l0o`00o`3201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J
6QX0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050=_Kf`0J6QX06QXJ01XJ6P3oO`001@0J6QX0
1@3o0?l06QXJ0?l0o`3o0?l007oo00H06QXJ00<007oo01XJ6P0J6QX0Q@0J6QX90?mo04406QXJ000S
01XJ6P80fm_K;P0J6QX00`3oO`006QXJ01XJ6P0901XJ6P8007oo00@06QXJ0?l0o`3o0?l0o`3o`@0J
6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ1@3Kfm/301XJ6P80
fm_K0P0J6QX00`3oO`006QXJ01XJ6P0301XJ6P@0o`3o00<007oo01XJ6P0J6QX0100J6QX00`00Ool0
6QXJ01XJ6P2501XJ6P030?mo000J6QX06QXJ00806QXJ00<0ogl001XJ6P0J6QX0@P0J6QX002<06QXJ
00<0fm_K01XJ6P0J6QX0;P0J6QX00`3oO`006QXJ01XJ6P0901XJ6P040=_Kf`00Ool007oo01XJ6P80
o`3o00<00?l001XJ6P0J6QX0_@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX01@3Kfm/06QXJ01XJ6P0J6QX0ogl000D06QXJ
00<007oo0?l0o`3o0?l00P00Oon>01XJ6P030?mo000J6QX06QXJ04L06QXJ000S01XJ6P030=_Kf`0J
6QX06QXJ02l06QXJ00<0ogl001XJ6P0J6QX02@0J6QX0103Kfm/007oo001oo`0J6QX20?l0o`03003o
000J6QX06QXJ0;`06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/301XJ
6P030=_Kf`0J6QX0fm_K00@06QXJ00D0fm_K01XJ6P0J6QX06QXJ0?mo000601XJ6P030?l0o`00Ool0
07oo08d06QXJ0P3oO`1:01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0`01XJ6P80ogl02P0J6QX00`3K
fm/007oo001oo`0201XJ6P80o`3o_P0J6QX20=_Kf`X06QXJ0P3Kfm/501XJ6P80fm_K100J6QX01@3K
fm/06QXJ01XJ6P0J6QX0ogl000H06QXJ0`00Oon<01XJ6P<0ogl0BP0J6QX002<06QXJ00<0fm_K01XJ
6P0J6QX0<@0J6QX00`3oO`006QXJ01XJ6P0901XJ6P050=_Kf`0J6QX007oo001oo`0J6QX00P3o0?oF
01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0ogl001XJ6P0J6QX0TP0J6QX00`3oO`006QXJ01XJ6P1:
01XJ6P00400J6QX20=_Kf`@06QXJ0P3Kfm/301XJ6P<0fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P0b01XJ
6P80ogl02P0J6QX20=_Kf`8007oo00@06QXJ0?l0o`3o0?l0o`3oe00J6QX20=_Kf`<06QXJ0`3oO`2B
01XJ6P030?mo000J6QX06QXJ04X06QXJ000?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K
01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0c01XJ6P80ogl02`0J6QX01@3Kfm/06QXJ001o
o`00Ool06QXJ0080o`3od`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P<0ogl0T@0J6QX20?mo04`06QXJ
000?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX20=_KfcD0
6QXJ0P3oO`0:01XJ6P<0fm_K0P00Ool00`0J6QX0o`3o0?l0o`3B01XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ0`3oO`2@01XJ6P80ogl0C@0J6QX000l06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX30=_Kf`D0
6QXJ00<0fm_K01XJ6P0J6QX0=@0J6QX20?mo00`06QXJ00D0fm_K001oo`00Ool007oo003o00020?l0
om006QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30?mo08T06QXJ00<0ogl001XJ6P0J6QX00`0J6QX30?mo
04d06QXJ000?01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3K
fm/06QXJ01XJ6P0g01XJ6P80ogl02P0J6QX20=_Kf`0401XJ6P00Ool007oo003o00<0o`3ocP0J6QX2
0=_Kf`<06QXJ0P3oO`000`0J6QX0ogl001XJ6P2201XJ6P030?mo000J6QX06QXJ00806QXJ0P3oO`04
01XJ6P030?mo000J6QX0ogl004d06QXJ000@01XJ6P80fm_K2P0J6QX30=_Kf`@06QXJ00<0fm_K01XJ
6P0J6QX0>00J6QX20?mo00X06QXJ0P3Kfm/01@0J6QX007oo001oo`00Ool00?l00080o`3oc@0J6QX0
0`3Kfm/06QXJ01XJ6P0301XJ6P030?mo000J6QX0ogl008806QXJ0P3oO`000`0J6QX0ogl00?mo0003
0?mo00@06QXJ00<0ogl001XJ6P0J6QX0C@0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0>@0J6QX20?mo
00/06QXJ0P3Kfm/0100J6QX007oo001oo`00o`020?l0ol`06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0
0`3oO`006QXJ0?mo002201XJ6P030?mo000J6QX0ogl000<0ogl00P0J6QX20?mo000301XJ6P3oO`00
6QXJ04l06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ03X06QXJ0P3oO`0;01XJ6P80fm_K0P0J6QX00`00
Ool00?l0003o00020?l0olX06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3oO`006QXJ01XJ6P2001XJ
6P040?mo000J6QX0ogl00?mo00@06QXJ103oO`1@01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P0l01XJ
6P030?mo000J6QX06QXJ00X06QXJ0P3Kfm/0100J6QX007oo001oo`00o`030?l0olP06QXJ00<0fm_K
01XJ6P0J6QX01@0J6QX00`3oO`006QXJ01XJ6P2001XJ6P040?mo000J6QX06QXJ0?mo00H06QXJ00<0
ogl001XJ6P0J6QX0C`0J6QX002<06QXJ0P3Kfm/n01XJ6P80ogl02`0J6QX01@3Kfm/06QXJ01XJ6P0J
6QX007oo00800?l00P3o0?o701XJ6P80fm_K1P0J6QX00`3oO`006QXJ01XJ6P1k01XJ6P80ogl00P0J
6QX20?mo05/06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ03h06QXJ0P3oO`0;01XJ6P050=_Kf`0J6QX0
6QXJ01XJ6P00Ool00P00o`030?l0olD06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3oO`006QXJ01XJ
6P1a01XJ6P030?mo000J6QX06QXJ00D06QXJ00@0ogl001XJ6P3oO`00ogl00P0J6QX00`3oO`006QXJ
01XJ6P1J01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1001XJ6P030?mo000J6QX06QXJ00T06QXJ00<0
fm_K01XJ6P0J6QX00P0J6QX00`00Ool00?l0003o00020?l0oj/06QXJ0P3Kfm/401XJ6P80fm_K100J
6QX20=_Kf`<06QXJ0`3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0ogl001XJ6P0J6QX0@@0J
6QX00`3oO`006QXJ01XJ6P0[01XJ6P80ogl01`0J6QX30?mo000401XJ6P3oO`00ogl00?mo05`06QXJ
000S01XJ6P030=_Kf`0J6QX06QXJ04406QXJ0P3oO`0:01XJ6P80fm_K0`0J6QX00`00Ool00?l0003o
00030?l0ojP06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3oO`006QXJ01XJ6P1001XJ
6P80ogl0;@0J6QX30?mo00H06QXJ0`3oO`00100J6QX0ogl00?mo003oO`1L01XJ6P008`0J6QX00`3K
fm/06QXJ01XJ6P1201XJ6P80ogl02P0J6QX30=_Kf`<06QXJ00<007oo003o000J6QX00`3o0?nV01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0P0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/401XJ6P80fm_K1`0J6QX00`3oO`006QXJ01XJ6P0o01XJ6P80ogl000<06QXJ0?mo003oO`00
:`0J6QX01@3oO`006QXJ0?mo000J6QX0ogl000@06QXJ00<0ogl001XJ6P0J6QX00`0J6QX00`3oO`00
6QXJ01XJ6P1J01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1301XJ6P<0ogl02P0J6QX40=_Kf`806QXJ
0P00o`000`0J6QX0o`3o0?l0o`2U01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J
6QX0fm_K0P0J6QX30=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3oO`006QXJ01XJ6P0o01XJ
6P050?mo000J6QX06QXJ01XJ6P3oO`009`0J6QX01P3oO`006QXJ0?mo000J6QX0ogl001XJ6P@0ogl0
0`0J6QX00`3oO`006QXJ01XJ6P1P01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1501XJ6P80ogl03@0J
6QX20=_Kf`0401XJ6P00o`000?l0003o00<0o`3oX`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P04
0=_Kf`0J6QX06QXJ0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0601XJ
6P030?mo000J6QX06QXJ03l06QXJ00D0ogl001XJ6P0J6QX06QXJ0?mo000V01XJ6P@0ogl000@06QXJ
0?mo000J6QX06QXJ0`3oO`00100J6QX0ogl00?mo003oO`1R01XJ6P008`0J6QX20=_KfdP06QXJ00<0
ogl001XJ6P0J6QX0300J6QX20=_Kf`0401XJ6P00o`000?l0001oo`80o`3oX`0J6QX20=_Kf`X06QXJ
0P3Kfm/401XJ6P<0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030?mo000J6QX06QXJ03h06QXJ
00<0ogl001XJ6P0J6QX00P0J6QX00`3oO`006QXJ01XJ6P0T01XJ6P050?mo000J6QX06QXJ01XJ6P3o
O`000`0J6QX00`3oO`006QXJ0?mo00030?mo06<06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ04P06QXJ
0P3oO`0>01XJ6P80fm_K0`00o`000`00Ool0o`3o0?l0o`2j01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ
00<0ogl001XJ6P0J6QX0?P0J6QX00`3oO`006QXJ01XJ6P0301XJ6P030?mo000J6QX06QXJ01T06QXJ
00<0ogl001XJ6P0J6QX01P0J6QX20?mo00<06QXJ00<0ogl001XJ6P0J6QX0100J6QX20?mo06@06QXJ
000S01XJ6P030=_Kf`0J6QX06QXJ04T06QXJ0`3oO`0>01XJ6P80fm_K0P00o`02001oo`80o`3o^00J
6QX20=_Kf`L06QXJ00<0ogl001XJ6P0J6QX0?@0J6QX20?mo00D06QXJ00<0ogl001XJ6P0J6QX06@0J
6QX20?mo00H06QXJ0`3oO`1`01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1;01XJ6P80ogl0400J6QX3
003o0004001oo`3o0?l0o`3o0?l0okH06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3oO`006QXJ01XJ
6P0m01XJ6P030?mo000J6QX06QXJ00@06QXJ00<0ogl001XJ6P0J6QX06@0J6QX20?mo00H06QXJ0P3o
O`1a01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1=01XJ6P80ogl0400J6QX2003o008007oo0P3o0?ne
01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0ogl001XJ6P0J6QX0?@0J6QX00`3oO`006QXJ01XJ6P05
01XJ6P030?mo000J6QX0ogl001P06QXJ203oO`1c01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1>01XJ
6P80ogl0400J6QX3003o008007oo0P3o0?nc01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0ogl001XJ
6P0J6QX0>@0J6QX00`3oO`006QXJ01XJ6P020?mo00L06QXJ103oO`0F01XJ6P030?mo000J6QX06QXJ
00H0ogl0L`0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0D00J6QX20?mo01006QXJ0`00o`02001oo`80
o`3o/@0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030?mo000J6QX06QXJ03406QXJ0P3oO`0601XJ6P04
0?mo000J6QX0ogl00?mo00P06QXJ103oO`0F01XJ6P050?mo000J6QX06QXJ01XJ6P3oO`000P0J6QX0
0`3oO`006QXJ01XJ6P1b01XJ6P008`0J6QX20=_Kfe806QXJ0`3oO`0@01XJ6P800?l000<0fm_K001o
o`3o0?l00P3o0?n_01XJ6P80fm_K200J6QX00`3oO`006QXJ01XJ6P0`01XJ6P80ogl01@0J6QX40?mo
00/06QXJ00<0ogl001XJ6P3oO`000P3oO`0C01XJ6P030?mo000J6QX06QXJ00@06QXJ00<0ogl001XJ
6P0J6QX0LP0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0D`0J6QX30?mo00l06QXJ0`00o`000`3Kfm/0
07oo0?l0o`020?l0ojd06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3oO`006QXJ01XJ6P0`01XJ6PD0
ogl000D06QXJ0?mo003oO`006QXJ0?mo000>01XJ6P@0ogl0400J6QX30?mo07/06QXJ000S01XJ6P03
0=_Kf`0J6QX06QXJ05D06QXJ0P3oO`0@01XJ6P800?l000<06QXJ0=_Kf`00Ool00`3o0?n[01XJ6P03
0=_Kf`0J6QX06QXJ00L06QXJ00<0ogl001XJ6P0J6QX0<00J6QX00`3oO`006QXJ0?mo00050?mo0003
01XJ6P3oO`006QXJ00d06QXJ00<0ogl001XJ6P3oO`000`3oO`0>01XJ6P80ogl0O00J6QX002<06QXJ
00<0fm_K01XJ6P0J6QX0EP0J6QX30?mo01006QXJ0P00o`020=_Kf`03001oo`3o0?l0o`3o0:X06QXJ
00<0fm_K01XJ6P0J6QX01`0J6QX00`3oO`006QXJ01XJ6P0^01XJ6P060?mo000J6QX0ogl001XJ6P3o
O`006QXJ0`3oO`0E01XJ6P80ogl00`0J6QX00`3oO`006QXJ01XJ6P0801XJ6P030?mo000J6QX06QXJ
07/06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ05P06QXJ0`3oO`0@01XJ6P800?l00P3Kfm/01000Ool0
o`3o0?l0o`3o0?nW01XJ6P80fm_K200J6QX00`3oO`006QXJ01XJ6P0]01XJ6P<0ogl01@0J6QX00`3o
O`006QXJ01XJ6P0E01XJ6P80ogl00P0J6QX00`3oO`006QXJ01XJ6P0801XJ6P030?mo000J6QX06QXJ
07/06QXJ000@01XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ05X0
6QXJ0`3oO`0?01XJ6P<00?l000<0fm_K01XJ6P00Ool00P3o0?nV01XJ6P030=_Kf`0J6QX06QXJ00L0
6QXJ00<0ogl001XJ6P0J6QX00P0J6QX00`3oO`006QXJ01XJ6P0X01XJ6P<0ogl01@0J6QX00`3oO`00
6QXJ01XJ6P0F01XJ6P030?mo000J6QX06QXJ0080ogl0200J6QX00`3oO`006QXJ01XJ6P1l01XJ6P00
3`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ
6P0J6QX0G00J6QX30?mo00l06QXJ0P00o`030=_Kf`0401XJ6P3o0?l0o`3o0?l0oj<06QXJ00<0fm_K
01XJ6P0J6QX0200J6QX01@3oO`006QXJ01XJ6P0J6QX0ogl002X06QXJ0`3oO`0N01XJ6P80ogl000<0
6QXJ0?mo003oO`00100J6QX30?mo000301XJ6P3oO`006QXJ07d06QXJ000?01XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX20=_Kfel06QXJ0`3oO`0?01XJ6P<00?l0
0`3Kfm/20?l0o`03001oo`0J6QX06QXJ08H06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kf`@06QXJ
0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0`3oO`000`0J6QX0ogl001XJ6P0X01XJ6P@0ogl0
7P0J6QX20?mo000301XJ6P3oO`00ogl000@06QXJ1@3oO`1n01XJ6P003`0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/901XJ6P80fm_K1@0J6QX00`3Kfm/06QXJ01XJ6P1P01XJ6P<0ogl03`0J6QX2003o00806QXJ
0P3Kfm/20?l0o`03001oo`0J6QX06QXJ08<06QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/0
6QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ00<0fm_K01XJ6P0J6QX0200J6QX3
0?mo000501XJ6P3oO`00ogl001XJ6P3oO`00500J6QX00`3oO`006QXJ01XJ6P0=01XJ6P@0ogl000<0
6QXJ0?mo000J6QX07P0J6QX20?mo00806QXJ00@0ogl001XJ6P3oO`006QXJ0P3oO`000`0J6QX0ogl0
01XJ6P1n01XJ6P003`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@0
6QXJ00<0fm_K01XJ6P0J6QX0HP0J6QX30?mo00l06QXJ0P00o`00100J6QX0fm_K0=_Kf`3Kfm/30?l0
o`03001oo`0J6QX06QXJ08006QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3K
fm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`@06QXJ0P3Kfm/:01XJ6PD0ogl000<06QXJ0?mo000J6QX0
4P0J6QX20?mo00l06QXJ103oO`0Q01XJ6P060?mo000J6QX06QXJ01XJ6P3oO`006QXJ0`3oO`2201XJ
6P00400J6QX20=_Kf`X06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ06@06QXJ0`3oO`0?01XJ6P80
0?l000@06QXJ0=_Kf`3Kfm/06QXJ0`3o0?l00`00Ool06QXJ01XJ6P1n01XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX20=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX02@0J
6QX50?mo000301XJ6P3oO`006QXJ01806QXJ0P3oO`0501XJ6P030?mo000J6QX06QXJ00L06QXJ0P3o
O`0W01XJ6P@0ogl0P`0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0IP0J6QX30?mo00l06QXJ0P00o`00
100J6QX0fm_K0=_Kf`3Kfm/30?l0o`8007ooO@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_K
f`0J6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K100J6QX00`3Kfm/06QXJ01XJ6P0:01XJ
6P030?mo000J6QX06QXJ00@0ogl04P0J6QX30?mo00@06QXJ00<0ogl001XJ6P0J6QX01P0J6QX30?mo
02P06QXJ0P3oO`2401XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1X01XJ6P<0ogl03`0J6QX2003o0080
6QXJ0P3Kfm/30?l0o`8007ooO00J6QX20=_Kf`X06QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX00`3Kfm/0
6QXJ01XJ6P0:01XJ6P040?mo000J6QX06QXJ01XJ6P<0ogl04P0J6QX00`3oO`006QXJ0?mo000401XJ
6P80ogl01`0J6QX00`3oO`006QXJ0?mo002^01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P1[01XJ6P<0
ogl03P0J6QX2003o000401XJ6P3Kfm/0fm_K0=_Kf`<0o`3o0`00OonB01XJ6P80fm_K3`0J6QX0103o
O`006QXJ0?mo003oO`0201XJ6P80ogl03@0J6QX00`3oO`006QXJ0?mo000301XJ6P040?mo000J6QX0
ogl00?mo00H06QXJ00<0ogl001XJ6P0J6QX0[P0J6QX002<06QXJ0P3Kfm]^01XJ6P<0ogl03P0J6QX3
003o00@06QXJ0`3o0?l3001oohl06QXJ00<0fm_K01XJ6P0J6QX0400J6QX20?mo00806QXJ0P3oO`0<
01XJ6P050?mo000J6QX06QXJ01XJ6P3oO`000P0J6QX0103oO`006QXJ0?mo003oO`0501XJ6P80ogl0
/00J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0K`0J6QX40?mo00d06QXJ0`00o`0401XJ6P<0o`3o1000
Oon<01XJ6P030=_Kf`0J6QX06QXJ01006QXJ0P3oO`0201XJ6P80ogl000<06QXJ0?mo000J6QX02@0J
6QX01@3oO`006QXJ01XJ6P0J6QX0ogl000806QXJ00D0ogl001XJ6P3oO`006QXJ0?mo000401XJ6P80
ogl0/00J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0LP0J6QX30?mo00d06QXJ0`00o`0401XJ6P<0o`3o
00@0fm_K001oo`00Ool007ooRP0J6QX00`3Kfm/06QXJ01XJ6P0A01XJ6P030?mo000J6QX06QXJ0080
ogl000<06QXJ0?mo003oO`002@0J6QX0103oO`006QXJ01XJ6P0J6QX40?mo00<06QXJ00<0ogl001XJ
6P0J6QX00P0J6QX20?mo0;006QXJ000S01XJ6P030=_Kf`0J6QX06QXJ07@06QXJ103oO`0=01XJ6P<0
0?l0100J6QX30?l0o`040=_Kf`00Ool007oo001oohL06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX30?mo
000301XJ6P3oO`00ogl00080ogl01P0J6QX0103oO`006QXJ01XJ6P3oO`0301XJ6P@0ogl00`0J6QX0
0`3oO`006QXJ01XJ6P0201XJ6P030?mo000J6QX06QXJ0:l06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ
07L06QXJ0`3oO`0=01XJ6P<00?l0100J6QX40?l0o`030=_Kf`00Ool007oo008007ooP`0J6QX20=_K
fa<06QXJ0P3oO`000`0J6QX0ogl00?mo00020?mo000701XJ6P3oO`006QXJ01XJ6P3oO`006QXJ0?mo
000201XJ6P040?mo000J6QX06QXJ01XJ6P<0ogl0100J6QX00`3oO`006QXJ01XJ6P0201XJ6P030?mo
000J6QX06QXJ0:l06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ07X06QXJ103oO`0<01XJ6P<00?l0100J
6QX30?l0o`80fm_K1000Oon001XJ6P030=_Kf`0J6QX06QXJ01806QXJ0P3oO`0401XJ6P<0ogl00P0J
6QX20?mo000401XJ6P3oO`006QXJ0?mo00@06QXJ0P3oO`0501XJ6P050?mo000J6QX06QXJ01XJ6P3o
O`00/@0J6QX002<06QXJ0P3Kfm]n01XJ6P<0ogl0300J6QX4003o00<06QXJ103o0?l20=_Kf`@007oo
O@0J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P80ogl01@0J6QX60?mo000401XJ6P3oO`006QXJ0?mo00/0
6QXJ0P3oO`000`0J6QX0ogl00?mo002a01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P2001XJ6P@0ogl0
2`0J6QX3003o00@06QXJ103o0?l00`0J6QX0fm_K001oo`03001oogX06QXJ00<0fm_K01XJ6P0J6QX0
4P0J6QX00`3oO`006QXJ01XJ6P0501XJ6PD0ogl000@06QXJ0?mo000J6QX0ogl02`0J6QX40?mo0;80
6QXJ000S01XJ6P030=_Kf`0J6QX06QXJ08<06QXJ103oO`0;01XJ6P<00?l0100J6QX30?l0o`0401XJ
6P3Kfm/0fm_K0=_Kf`@007ooMP0J6QX00`3Kfm/06QXJ01XJ6P0K01XJ6P80ogl000H06QXJ0?mo000J
6QX0ogl001XJ6P3oO`0<01XJ6P<0ogl0/P0J6QX002<06QXJ00<0fm_K01XJ6P0J6QX0QP0J6QX40?mo
00X06QXJ1000o`0401XJ6P<0o`3o103Kfm/5001oog806QXJ0P3Kfm/L01XJ6P80ogl000<06QXJ0?mo
000J6QX00P3oO`0>01XJ6P030?mo000J6QX06QXJ0;406QXJ000S01XJ6P030=_Kf`0J6QX06QXJ08X0
6QXJ103oO`0901XJ6P@00?l0100J6QX30?l0o`@0fm_K00<06QXJ001oo`00Ool00P00Oom_01XJ6P03
0=_Kf`0J6QX06QXJ01`06QXJ00<0ogl001XJ6P0J6QX00P0J6QX00`3oO`006QXJ01XJ6P3001XJ6P00
8`0J6QX00`3Kfm/06QXJ01XJ6P2=01XJ6PD0ogl02@0J6QX4003o00<06QXJ103o0?l50=_Kf`@007oo
F00J6QX20=_Kf`@06QXJ0P3Kfm/301XJ6PD0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0Q01XJ6P030?mo
000J6QX06QXJ0<006QXJ000S01XJ6P030=_Kf`0J6QX06QXJ09406QXJ1@3oO`0801XJ6P@00?l00`0J
6QX40?l0o`806QXJ0P3Kfm/201XJ6P@007ooD`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_K
f`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0i00J6QX002<06QXJ0P3Kfm^F01XJ6PD0ogl01`0J
6QX5003o00806QXJ1@3o0?l50=_Kf`0301XJ6P00Ool007oo00<007ooCP0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm_U01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ
6P2I01XJ6PH0ogl01P0J6QX5003o00806QXJ1@3o0?l60=_Kf`D007ooBP0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0i00J6QX002<06QXJ00<0
fm_K01XJ6P0J6QX0WP0J6QX70?mo00D06QXJ1@00o`000`0J6QX0o`3o0?l0o`030?l0o`806QXJ103K
fm/6001oodD06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ0>@06QXJ000S01XJ6P030=_Kf`0J6QX06QXJ0:@06QXJ1`3oO`0301XJ6PH00?l01P3o
0?l00`0J6QX0fm_K0=_Kf`020=_Kf`0301XJ6P00Ool007oo00@007oo@@0J6QX20=_Kf`X06QXJ0P3K
fm_/01XJ6P008`0J6QX00`3Kfm/06QXJ01XJ6P2Z01XJ6PP0ogl000<06QXJ003o0000o`001000o`06
0?l0o`H0fm_K1P00Oooo01XJ6SL06QXJ000K01XJ6PD0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P2a01XJ
6PP0ogl01@00o`070?l0o`@06QXJ0P3Kfm/6001oool06QXJ<@0J6QX001d06QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX00`3Kfm/06QXJ01XJ6P2j01XJ6PH0ogl01@00o`090?l0o`80fm_K1`00Oooo01XJ6R/0
6QXJ000M01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm_701XJ6P@0ogl00`00o`0?0?l0ool06QXJ
9P0J6QX001d06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6_l06QXJ0`0J
6QX001d06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6_l06QXJ0`0J6QX0
01`06QXJ0P3Kfm/501XJ6P030=_Kf`0J6QX06QXJ0?l06QXJo`0J6QX301XJ6P008`0J6QX00`3Kfm/0
6QXJ01XJ6P3o01XJ6_l06QXJ0`0J6QX00?l06QXJo`0J6QXY01XJ6P00o`0J6Q[o01XJ6RT06QXJ003o
01XJ6_l06QXJ:@0J6QX00?l06QXJo`0J6QXY01XJ6P00\
\>"],
  ImageRangeCache->{{{66.4375, 506.625}, {504.188, 375.438}} -> {-0.375431, \
1.78749, 0.00384023, 0.00384023}, {{78.1875, 276.563}, {501.063, 378.5}} -> \
{-389.87, 3.31648, 3.28619, 0.00731387}, {{296.438, 494.813}, {501.063, \
378.5}} -> {-1398.28, 0.453065, 3.46711, 0.00109056}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"Show", "[", "\[IndentingNewLine]", 
          
          RowBox[{\(Plot[z - fKn[z], {z, 0, 1}]\), ",", "\[IndentingNewLine]",
             
            RowBox[{"Plot", "[", 
              RowBox[{
                RowBox[{"z", "-", 
                  StyleBox[\(fKi[z]\),
                    FontColor->RGBColor[1, 0.588235, 0]]}], 
                ",", \({z, 0, 1}\), 
                ",", \(PlotStyle \[Rule] RGBColor[1, 0.5, 0]\)}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Plot", "[", 
              RowBox[{
                RowBox[{"z", "-", 
                  StyleBox[\(fKg[z]\),
                    FontColor->RGBColor[0, 0.588235, 1]]}], 
                ",", \({z, 0, 1}\), 
                ",", \(PlotStyle \[Rule] RGBColor[0, 0.5, 1]\)}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Plot", "[", 
              RowBox[{
                RowBox[{"z", "-", 
                  StyleBox[\(fKc[z]\),
                    FontColor->RGBColor[0, 1, 0]]}], ",", \({z, 0, 1}\), 
                ",", \(PlotStyle \[Rule] RGBColor[0, 1, 0]\)}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Plot", "[", 
              RowBox[{
                RowBox[{"z", "-", 
                  StyleBox[\(fKf[z]\),
                    FontColor->RGBColor[1, 0, 1]]}], ",", \({z, 0, 1}\), 
                ",", \(PlotStyle \[Rule] RGBColor[1, 0, 1]\)}], "]"}]}], 
          "]"}], "//", "fShow"}], ";"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.603319 1.59999 [
[.21429 .59082 -9 -9 ]
[.21429 .59082 9 0 ]
[.40476 .59082 -9 -9 ]
[.40476 .59082 9 0 ]
[.59524 .59082 -9 -9 ]
[.59524 .59082 9 0 ]
[.78571 .59082 -9 -9 ]
[.78571 .59082 9 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.01131 .04332 -30 -4.5 ]
[.01131 .04332 0 4.5 ]
[.01131 .12332 -24 -4.5 ]
[.01131 .12332 0 4.5 ]
[.01131 .20332 -30 -4.5 ]
[.01131 .20332 0 4.5 ]
[.01131 .28332 -24 -4.5 ]
[.01131 .28332 0 4.5 ]
[.01131 .36332 -30 -4.5 ]
[.01131 .36332 0 4.5 ]
[.01131 .44332 -24 -4.5 ]
[.01131 .44332 0 4.5 ]
[.01131 .52332 -30 -4.5 ]
[.01131 .52332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .60332 m
.21429 .60957 L
s
[(0.2)] .21429 .59082 0 1 Mshowa
.40476 .60332 m
.40476 .60957 L
s
[(0.4)] .40476 .59082 0 1 Mshowa
.59524 .60332 m
.59524 .60957 L
s
[(0.6)] .59524 .59082 0 1 Mshowa
.78571 .60332 m
.78571 .60957 L
s
[(0.8)] .78571 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(1)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.2619 .60332 m
.2619 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.5 .60332 m
.5 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.7381 .60332 m
.7381 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.02381 .04332 m
.03006 .04332 L
s
[(-0.35)] .01131 .04332 1 0 Mshowa
.02381 .12332 m
.03006 .12332 L
s
[(-0.3)] .01131 .12332 1 0 Mshowa
.02381 .20332 m
.03006 .20332 L
s
[(-0.25)] .01131 .20332 1 0 Mshowa
.02381 .28332 m
.03006 .28332 L
s
[(-0.2)] .01131 .28332 1 0 Mshowa
.02381 .36332 m
.03006 .36332 L
s
[(-0.15)] .01131 .36332 1 0 Mshowa
.02381 .44332 m
.03006 .44332 L
s
[(-0.1)] .01131 .44332 1 0 Mshowa
.02381 .52332 m
.03006 .52332 L
s
[(-0.05)] .01131 .52332 1 0 Mshowa
.125 Mabswid
.02381 .05932 m
.02756 .05932 L
s
.02381 .07532 m
.02756 .07532 L
s
.02381 .09132 m
.02756 .09132 L
s
.02381 .10732 m
.02756 .10732 L
s
.02381 .13932 m
.02756 .13932 L
s
.02381 .15532 m
.02756 .15532 L
s
.02381 .17132 m
.02756 .17132 L
s
.02381 .18732 m
.02756 .18732 L
s
.02381 .21932 m
.02756 .21932 L
s
.02381 .23532 m
.02756 .23532 L
s
.02381 .25132 m
.02756 .25132 L
s
.02381 .26732 m
.02756 .26732 L
s
.02381 .29932 m
.02756 .29932 L
s
.02381 .31532 m
.02756 .31532 L
s
.02381 .33132 m
.02756 .33132 L
s
.02381 .34732 m
.02756 .34732 L
s
.02381 .37932 m
.02756 .37932 L
s
.02381 .39532 m
.02756 .39532 L
s
.02381 .41132 m
.02756 .41132 L
s
.02381 .42732 m
.02756 .42732 L
s
.02381 .45932 m
.02756 .45932 L
s
.02381 .47532 m
.02756 .47532 L
s
.02381 .49132 m
.02756 .49132 L
s
.02381 .50732 m
.02756 .50732 L
s
.02381 .53932 m
.02756 .53932 L
s
.02381 .55532 m
.02756 .55532 L
s
.02381 .57132 m
.02756 .57132 L
s
.02381 .58732 m
.02756 .58732 L
s
.02381 .02732 m
.02756 .02732 L
s
.02381 .01132 m
.02756 .01132 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .59672 m
.06244 .48996 L
.10458 .39348 L
.14415 .32572 L
.18221 .27741 L
.18352 .27741 L
.18475 .27507 L
.18603 .27722 L
.18671 .27396 L
.18744 .27519 L
.18823 .26331 L
.18898 .26457 L
.18965 .2635 L
.19039 .26474 L
.19107 .25929 L
.1918 .25171 L
.19311 .24291 L
.19381 .24408 L
.19445 .24075 L
.19515 .24193 L
.1959 .23658 L
.19715 .23208 L
.19785 .23327 L
.19852 .23438 L
.19975 .23206 L
.20088 .23395 L
.20219 .23394 L
.20342 .23381 L
.20453 .23127 L
.20575 .23112 L
.20702 .23326 L
.20822 .23528 L
.20934 .23495 L
.21036 .23667 L
.21148 .22975 L
.21266 .23173 L
.21386 .22935 L
.21515 .22931 L
.21636 .22695 L
.21746 .2288 L
.21876 .22878 L
.21949 .2212 L
.22017 .22233 L
.2214 .22001 L
.22272 .21782 L
.22396 .2155 L
.22513 .21087 L
.2262 .20607 L
.22734 .20358 L
.22857 .20565 L
Mistroke
.22972 .20757 L
.23042 .20875 L
.23108 .20765 L
.23231 .20972 L
.2334 .20936 L
.23456 .2047 L
.23554 .20415 L
.23662 .20377 L
.23779 .20352 L
.23904 .20342 L
.24021 .20539 L
.24128 .20499 L
.24255 .20492 L
.24319 .206 L
.2439 .20718 L
.24515 .20708 L
.24632 .20904 L
.24698 .20577 L
.24769 .20695 L
.24895 .20686 L
.24965 .20364 L
.2503 .20473 L
.25102 .20374 L
.25178 .20502 L
.25307 .20718 L
.25379 .204 L
.25446 .20512 L
.25569 .20278 L
.25699 .20056 L
.25815 .20031 L
.25924 .19994 L
.26043 .19534 L
.26171 .18429 L
.26292 .18633 L
.26362 .18749 L
.26427 .18638 L
.26496 .18754 L
.26568 .18656 L
.26698 .18214 L
.2682 .17538 L
.26933 .17288 L
.27054 .17272 L
.27118 .17379 L
.27187 .16834 L
.27261 .16959 L
.2733 .17074 L
.27403 .17198 L
.27484 .17334 L
.27555 .17453 L
.27621 .17123 L
Mistroke
.27691 .17241 L
.27766 .16706 L
.27833 .16159 L
.27907 .16283 L
.27972 .16392 L
.28041 .16508 L
.28171 .16507 L
.28292 .16271 L
.28419 .16264 L
.28483 .16371 L
.28554 .16269 L
.2863 .15517 L
.28701 .15636 L
.28766 .15085 L
.28836 .15203 L
.28962 .15414 L
.29033 .15314 L
.29099 .15424 L
.29217 .15623 L
.29348 .15842 L
.29473 .15613 L
.2959 .1493 L
.29714 .14698 L
.29848 .14482 L
.29971 .14028 L
.30087 .13783 L
.30191 .13958 L
.30304 .13928 L
.30429 .14138 L
.30544 .13891 L
.30668 .141 L
.308 .14321 L
.30914 .14292 L
.3102 .14251 L
.31137 .14006 L
.31262 .13777 L
.31332 .13894 L
.31396 .13782 L
.31467 .13902 L
.31543 .13808 L
.31615 .13929 L
.31683 .14043 L
.31809 .13596 L
.31935 .13806 L
.3205 .14 L
.32176 .14212 L
.3224 .14319 L
.32309 .14216 L
.32439 .13774 L
.32508 .13889 L
Mistroke
.32581 .13351 L
.32644 .13458 L
.32714 .13355 L
.32837 .13342 L
.32911 .13465 L
.3299 .13158 L
.33064 .13283 L
.33133 .13398 L
.33199 .13509 L
.33271 .1341 L
.33402 .1297 L
.33471 .13086 L
.33536 .12755 L
.33657 .12959 L
.33799 .13197 L
.3393 .13416 L
.34044 .13389 L
.34165 .13152 L
.34287 .12696 L
.34355 .12811 L
.3442 .1292 L
.34546 .12691 L
.34609 .12798 L
.3468 .12696 L
.34805 .12686 L
.3492 .12439 L
.34986 .1255 L
.35055 .12446 L
.35125 .12563 L
.35201 .12471 L
.35272 .1259 L
.35339 .12483 L
.35464 .12033 L
.35583 .11573 L
.35712 .11789 L
.35779 .11902 L
.3585 .11581 L
.35977 .11574 L
.36094 .11771 L
.36204 .11295 L
.36325 .11278 L
.36454 .11275 L
.36577 .10822 L
.36692 .11015 L
.36818 .10785 L
.36888 .10683 L
.36951 .1079 L
.37068 .10766 L
.37195 .10538 L
.37314 .10739 L
Mistroke
.37423 .10923 L
.3753 .11102 L
.37629 .11048 L
.37738 .11011 L
.37855 .10987 L
.37977 .11192 L
.38093 .11167 L
.38197 .11341 L
.38309 .11531 L
.38543 .11924 L
.38666 .12131 L
.38795 .12348 L
.38909 .12319 L
.39033 .12527 L
.39146 .12497 L
.39251 .12453 L
.39316 .12562 L
.39387 .12461 L
.39515 .12455 L
.39639 .12664 L
.39754 .12857 L
.39878 .12405 L
.39948 .12524 L
.40014 .12634 L
.40084 .12311 L
.40147 .12418 L
.4029 .12657 L
.40419 .12874 L
.4054 .12858 L
.40667 .1307 L
.40806 .13305 L
.40875 .1342 L
.40947 .13541 L
.41026 .13233 L
.41098 .13135 L
.41227 .12912 L
.413 .13035 L
.41369 .13149 L
.41432 .13256 L
.41502 .13373 L
.41627 .13364 L
.4175 .13129 L
.41863 .13319 L
.41985 .13525 L
.42055 .13421 L
.4212 .1353 L
.42251 .13751 L
.42324 .13654 L
.42392 .13547 L
.4252 .13764 L
Mistroke
.42642 .13967 L
.42751 .1393 L
.42868 .13908 L
.42997 .14124 L
.43062 .13793 L
.43133 .13913 L
.43377 .14322 L
.43494 .14519 L
.43605 .14705 L
.43733 .147 L
.43849 .14896 L
.44061 .15251 L
.4418 .15452 L
.44291 .15197 L
.44409 .15176 L
.44537 .15171 L
.44658 .15154 L
.44769 .14899 L
.44891 .14445 L
.44961 .14562 L
.45025 .14671 L
.45296 .15125 L
.45808 .15766 L
.45947 .16 L
.46078 .16219 L
.46143 .16329 L
.46214 .16227 L
.46292 .16358 L
.46363 .16478 L
.46433 .16596 L
.46498 .16484 L
.46644 .1629 L
.46774 .16067 L
.46846 .16188 L
.46911 .16078 L
.47036 .16288 L
.47102 .16399 L
.47171 .16515 L
.47299 .16509 L
.47416 .16486 L
.47534 .16024 L
.47645 .16211 L
.47773 .16206 L
.4789 .16402 L
.48019 .16399 L
.48092 .16521 L
.48159 .16634 L
.48281 .16838 L
.4841 .16615 L
.48524 .16588 L
Mistroke
.48629 .16764 L
.48751 .16968 L
.48866 .16942 L
.48972 .169 L
.49071 .17065 L
.49179 .17026 L
.49294 .17 L
.4942 .16992 L
.49491 .16892 L
.49557 .17002 L
.49678 .16544 L
.49805 .16318 L
.49919 .1629 L
.50026 .16469 L
.50143 .16446 L
.50269 .16657 L
.5039 .16861 L
.50459 .16537 L
.50524 .16646 L
.50655 .16646 L
.50729 .1677 L
.50796 .16663 L
.5091 .16854 L
.51034 .16402 L
.51164 .164 L
.51285 .16163 L
.51354 .15839 L
.51429 .15965 L
.51565 .16193 L
.51819 .16621 L
.51894 .16746 L
.51964 .16863 L
.52036 .16766 L
.52116 .169 L
.52249 .16902 L
.52323 .17027 L
.52391 .16921 L
.52515 .17129 L
.52647 .17351 L
.52771 .1712 L
.52884 .17309 L
.52953 .17426 L
.53017 .17313 L
.53087 .17431 L
.53161 .17335 L
.53286 .17544 L
.53356 .17662 L
.53422 .17773 L
.5355 .17768 L
.53667 .17965 L
Mistroke
.53793 .17956 L
.53864 .18075 L
.53929 .18185 L
.54048 .18384 L
.54159 .1857 L
.54274 .18325 L
.54402 .18319 L
.5452 .18517 L
.54646 .18289 L
.54765 .18268 L
.54873 .18229 L
.55 .18222 L
.55071 .18343 L
.55137 .18233 L
.55258 .18437 L
.55387 .18653 L
.5551 .18639 L
.55642 .18201 L
.55766 .1841 L
.5588 .18601 L
.55949 .18498 L
.56013 .18605 L
.56084 .18503 L
.56159 .18629 L
.5623 .18529 L
.56297 .18422 L
.56423 .18632 L
.5654 .18829 L
.56648 .19012 L
.56762 .18983 L
.56887 .19192 L
.56994 .19153 L
.57092 .19098 L
.57206 .19288 L
.57313 .19468 L
.57536 .19843 L
.57649 .20033 L
.57773 .20022 L
.57838 .2013 L
.57908 .19807 L
.58034 .19798 L
.58159 .19349 L
.58274 .19321 L
.58402 .19537 L
.58524 .19741 L
.5875 .20122 L
.59015 .20566 L
.59131 .20761 L
.59258 .20975 L
.59368 .2116 L
Mistroke
.59471 .21113 L
.5958 .20856 L
.59697 .21052 L
.60172 .2163 L
.60728 .22345 L
.60861 .22568 L
.60934 .2269 L
.61002 .22805 L
.61123 .22787 L
.61187 .22895 L
.61256 .23011 L
.61376 .22773 L
.61503 .22985 L
.61611 .23167 L
.61729 .23146 L
.61858 .23142 L
.6193 .23264 L
.61996 .23154 L
.62124 .23369 L
.62244 .2269 L
.62355 .22877 L
.62475 .23078 L
.62543 .23192 L
.62608 .23301 L
.62729 .23285 L
.62856 .23499 L
.62974 .23697 L
.63104 .23475 L
.63176 .23376 L
.63242 .23487 L
.64162 .24812 L
.64292 .2481 L
.64413 .25013 L
.64539 .25225 L
.6461 .25345 L
.64677 .25458 L
.64751 .2492 L
.64817 .25033 L
.64889 .25153 L
.64967 .25064 L
.65034 .25177 L
.65106 .25077 L
.65234 .24852 L
.65353 .24612 L
.65481 .24607 L
.65602 .24811 L
.65713 .24997 L
.66242 .25885 L
.66359 .26083 L
.66487 .26296 L
Mistroke
.66607 .26498 L
.66717 .26464 L
.66846 .26241 L
.66912 .2635 L
.66983 .2647 L
.67108 .2668 L
.67225 .26656 L
.67343 .26854 L
.67455 .27043 L
.67555 .27212 L
.67665 .27176 L
.67784 .27376 L
.6791 .27368 L
.68018 .27109 L
.68138 .2731 L
.68664 .28193 L
.69218 .29124 L
.69691 .29699 L
.69821 .29697 L
.69893 .29819 L
.69959 .29929 L
.70088 .29925 L
.70209 .29909 L
.7032 .30096 L
.70443 .30302 L
.70571 .30297 L
.70691 .30278 L
.70803 .30466 L
.70905 .30198 L
.71023 .30397 L
.71136 .30365 L
.71256 .30568 L
.71385 .30784 L
.71496 .30971 L
.71616 .31173 L
.7169 .31077 L
.71758 .31191 L
.71823 .3086 L
.71892 .30975 L
.7201 .31175 L
.72141 .30954 L
.72208 .31066 L
.72281 .31189 L
.7235 .30864 L
.72413 .30971 L
.72541 .31186 L
.72662 .31388 L
.7279 .31384 L
.72858 .31499 L
.72932 .31623 L
Mistroke
.73005 .31745 L
.73082 .31874 L
.73148 .31985 L
.73219 .31665 L
.73351 .31227 L
.73471 .31428 L
.73741 .31881 L
.74226 .32475 L
.78225 .36334 L
.82073 .41038 L
.86167 .45054 L
.90109 .50356 L
.93899 .55183 L
.97619 .60332 L
Mfstroke
1 .5 0 r
.02381 .60332 m
.02846 .56176 L
.03279 .53298 L
.04262 .47931 L
.06244 .39531 L
.08451 .32259 L
.10458 .26852 L
.14357 .18614 L
.1835 .12424 L
.22192 .08074 L
.24175 .06336 L
.26278 .04824 L
.28254 .03687 L
.30062 .0287 L
.32003 .02214 L
.33073 .01944 L
.34091 .01746 L
.35049 .01609 L
.35585 .01553 L
.35838 .01532 L
.36071 .01515 L
.36288 .01502 L
.36526 .01491 L
.36765 .01482 L
.36896 .01478 L
.37018 .01475 L
.37134 .01473 L
.37243 .01472 L
.37341 .01472 L
.37448 .01472 L
.37565 .01472 L
.37688 .01473 L
.37794 .01475 L
.3791 .01477 L
.38145 .01484 L
.38402 .01495 L
.3867 .01509 L
.38919 .01525 L
.39845 .0161 L
.40373 .01675 L
.40853 .01746 L
.4193 .0194 L
.43849 .02408 L
.45928 .03083 L
.5002 .04891 L
.53961 .07191 L
.57749 .09881 L
.61783 .13224 L
.65666 .16876 L
.69793 .21197 L
Mistroke
.73769 .25762 L
.77594 .30505 L
.81664 .35909 L
.85582 .41445 L
.89745 .47667 L
.93757 .53977 L
.97617 .60329 L
.97619 .60332 L
Mfstroke
0 .5 1 r
.02381 .60332 m
.02846 .57141 L
.03279 .54931 L
.04262 .50811 L
.06244 .44361 L
.08451 .38777 L
.10458 .34626 L
.14357 .28301 L
.1835 .23548 L
.22192 .20208 L
.24175 .18874 L
.26278 .17713 L
.28254 .1684 L
.30062 .16213 L
.32003 .15709 L
.33073 .15502 L
.34091 .15349 L
.35049 .15245 L
.35585 .15202 L
.35838 .15186 L
.36071 .15173 L
.36288 .15163 L
.36526 .15154 L
.36765 .15147 L
.36896 .15144 L
.37018 .15142 L
.37134 .1514 L
.37243 .15139 L
.37341 .15139 L
.37448 .15139 L
.37565 .15139 L
.37688 .1514 L
.37794 .15142 L
.3791 .15143 L
.38145 .15149 L
.38402 .15157 L
.3867 .15167 L
.38919 .1518 L
.39845 .15245 L
.40373 .15295 L
.40853 .15349 L
.4193 .15499 L
.43849 .15858 L
.45928 .16376 L
.5002 .17764 L
.53961 .19531 L
.57749 .21596 L
.61783 .24162 L
.65666 .26966 L
.69793 .30285 L
Mistroke
.73769 .33789 L
.77594 .3743 L
.81664 .4158 L
.85582 .45831 L
.89745 .50608 L
.93757 .55453 L
.97617 .6033 L
.97619 .60332 L
Mfstroke
0 1 0 r
.02381 .60332 m
.06244 .51145 L
.10458 .42942 L
.14415 .36471 L
.18221 .31202 L
.22272 .26509 L
.26171 .22809 L
.30316 .19693 L
.32392 .18432 L
.34309 .17438 L
.36292 .16579 L
.3815 .15926 L
.40022 .15414 L
.4108 .15188 L
.42085 .15015 L
.43053 .14887 L
.43601 .14831 L
.4411 .1479 L
.4458 .1476 L
.45006 .14741 L
.45243 .14734 L
.45376 .14731 L
.45499 .14728 L
.45606 .14726 L
.45724 .14725 L
.45847 .14724 L
.45962 .14724 L
.46088 .14725 L
.46152 .14725 L
.46222 .14726 L
.46346 .14727 L
.46463 .14729 L
.46725 .14736 L
.47007 .14746 L
.47259 .14757 L
.47524 .14772 L
.47997 .14805 L
.48884 .14889 L
.49853 .15015 L
.51814 .15376 L
.53909 .15918 L
.56044 .16633 L
.58059 .17457 L
.61906 .19422 L
.65997 .22066 L
.69938 .25138 L
.73726 .28566 L
.7776 .32717 L
.81643 .3719 L
.8577 .42448 L
Mistroke
.89747 .47993 L
.93571 .53765 L
.97619 .60332 L
Mfstroke
1 0 1 r
.02381 .60332 m
.02605 .58384 L
.02846 .56858 L
.03279 .54583 L
.04262 .50501 L
.06244 .444 L
.08451 .39318 L
.10458 .35625 L
.14451 .29967 L
.18292 .25968 L
.22379 .22806 L
.26314 .20577 L
.30098 .19047 L
.32039 .18466 L
.34126 .17981 L
.35137 .17796 L
.3624 .1763 L
.37282 .17506 L
.38249 .17419 L
.38756 .17384 L
.39306 .17354 L
.39558 .17344 L
.39824 .17334 L
.40054 .17328 L
.40181 .17325 L
.40301 .17322 L
.40416 .1732 L
.40541 .17318 L
.40655 .17317 L
.4076 .17316 L
.40859 .17316 L
.40967 .17316 L
.41081 .17316 L
.41188 .17316 L
.41307 .17317 L
.41433 .17318 L
.4154 .1732 L
.41657 .17322 L
.41918 .17327 L
.42162 .17334 L
.42667 .17353 L
.43214 .17382 L
.44207 .17454 L
.45175 .17548 L
.46066 .17656 L
.47943 .17949 L
.50007 .18374 L
.54041 .19507 L
.57923 .20976 L
.62051 .22947 L
Mistroke
.66027 .25253 L
.69851 .27861 L
.73921 .31076 L
.77839 .34619 L
.82003 .38897 L
.86015 .43552 L
.89875 .48561 L
.9398 .545 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{543.5, 335.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008O0001Cb000`400?l00000o`00003oo`0J6Q[o
01XJ6R406QXJ003o01XJ6_l06QXJ8@0J6QX00?l06QXJo`0J6QXQ01XJ6P00o`0J6Q[o01XJ6R406QXJ
003o01XJ6_l06QXJ8@0J6QX00?l06QXJo`0J6QXQ01XJ6P00o`0J6Q[o01XJ6R406QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ0?l06QXJn@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0o`0J6Q[i01XJ6P00900J
6QX00`3Kfm/06QXJ01XJ6P3o01XJ6_T06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJn@0J6QX0
02@06QXJ00<0fm_K01XJ6P0J6QX0o`0J6Q[i01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P3o01XJ6_T0
6QXJ000T01XJ6P<0fm_Ko`0J6Q[i01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P2a01XJ6PD0ogl0o`0J
6QY301XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P2T01XJ6Pd0ogl0100J6QX<0?mo0?l06QXJ>00J6QX0
02@06QXJ00<0fm_K01XJ6P0J6QX0W`0J6QX50?mo01d06QXJ1P3oO`3o01XJ6S806QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ09X06QXJ1@3oO`0X01XJ6PH0ogl0o`0J6QX/01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P2F01XJ6P@0ogl0<`0J6QX50?mo0?l06QXJ9`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0T`0J
6QX30?mo03`06QXJ103oO`3o01XJ6R<06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ09406QXJ0P3oO`13
01XJ6P<0ogl0o`0J6QXP01XJ6P00900J6QX30=_Kfhh06QXJ0`3oO`1801XJ6P80ogl0o`0J6QXN01XJ
6P00900J6QX00`3Kfm/06QXJ01XJ6P2;01XJ6P<0ogl0C@0J6QX30?mo0?l06QXJ6`0J6QX002@06QXJ
00<0fm_K01XJ6P0J6QX0R@0J6QX20?mo05<06QXJ0`3oO`3o01XJ6QP06QXJ000T01XJ6P030=_Kf`0J
6QX06QXJ08L06QXJ0P3oO`1H01XJ6P80ogl0o`0J6QXF01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P25
01XJ6P80ogl0G00J6QX20?mo0?l06QXJ500J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0P`0J6QX20?mo
06006QXJ0`3oO`3o01XJ6Q406QXJ000801XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/401XJ6P80
fm_K200J6QX00`3Kfm/06QXJ01XJ6P2101XJ6P80ogl0I@0J6QX20?mo0?l06QXJ3`0J6QX000L06QXJ
00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX0O`0J6QX20?mo06T06QXJ0P3oO`3o01XJ6Pd06QXJ000701XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P05
01XJ6P@0fm_KO@0J6QX00`3oO`006QXJ01XJ6P1[01XJ6P<0ogl0o`0J6QX:01XJ6P0000<06QXJ0=_K
f`3Kfm/00P3Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`/06QXJ00@0fm_K01XJ6P0J6QX06QXJ0P3K
fm/801XJ6P030=_Kf`0J6QX06QXJ07`06QXJ0P3oO`1a01XJ6P80ogl0o`0J6QX801XJ6P001`0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ00<0fm_K01XJ6P0J6QX0
1`0J6QX00`3Kfm/06QXJ01XJ6P1j01XJ6P80ogl0M@0J6QX20?mo0?l06QXJ1P0J6QX000P06QXJ0P3K
fm/:01XJ6P80fm_K100J6QX30=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX0N@0J6QX00`3oO`006QXJ01XJ
6P1g01XJ6P80ogl0o`0J6QX401XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P1g01XJ6P80ogl0O00J6QX2
0?mo0?l06QXJ0P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0MP0J6QX00`3oO`006QXJ01XJ6P1n01XJ
6P80ogl0o`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0M@0J6QX00`3oO`006QXJ01XJ6P2101XJ6P03
0?mo000J6QX06QXJ0?`06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ07<06QXJ0P3oO`2501XJ6P80ogl0
o00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0LP0J6QX00`3oO`006QXJ01XJ6P2701XJ6P80ogl0nP0J
6QX002@06QXJ0`3Kfm]a01XJ6P030?mo000J6QX06QXJ08X06QXJ00<0ogl001XJ6P0J6QX0m`0J6QX0
02@06QXJ00<0fm_K01XJ6P0J6QX0K`0J6QX20?mo08h06QXJ0P3oO`3g01XJ6P00900J6QX00`3Kfm/0
6QXJ01XJ6P1^01XJ6P030?mo000J6QX06QXJ09006QXJ0P3oO`3e01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P1]01XJ6P030?mo000J6QX06QXJ09<06QXJ00<0ogl001XJ6P0J6QX0lP0J6QX002@06QXJ00<0
fm_K01XJ6P0J6QX0K00J6QX00`3oO`006QXJ01XJ6P2E01XJ6P80ogl0lP0J6QX002@06QXJ00<0fm_K
01XJ6P0J6QX0J`0J6QX00`3oO`006QXJ01XJ6P2H01XJ6P80ogl0l00J6QX002@06QXJ00<0fm_K01XJ
6P0J6QX0JP0J6QX00`3oO`006QXJ01XJ6P2K01XJ6P030?mo000J6QX06QXJ0>d06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ06P06QXJ0P3oO`2O01XJ6P80ogl0k@0J6QX002@06QXJ0`3Kfm]W01XJ6P030?mo
000J6QX06QXJ0:406QXJ00<0ogl001XJ6P0J6QX0jP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0IP0J
6QX00`3oO`006QXJ01XJ6P2S01XJ6P030?mo000J6QX06QXJ0>T06QXJ000T01XJ6P030=_Kf`0J6QX0
6QXJ06D06QXJ00<0ogl001XJ6P0J6QX0Y@0J6QX20?mo0>T06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ
06@06QXJ00<0ogl001XJ6P0J6QX0Z00J6QX00`3oO`006QXJ01XJ6P3V01XJ6P00900J6QX00`3Kfm/0
6QXJ01XJ6P1S01XJ6P030?mo000J6QX06QXJ0:X06QXJ0P3oO`3V01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P1R01XJ6P030?mo000J6QX06QXJ0:d06QXJ00<0ogl001XJ6P0J6QX0h`0J6QX002@06QXJ00<0
fm_K01XJ6P0J6QX0H@0J6QX00`3oO`006QXJ01XJ6P2_01XJ6P80ogl0h`0J6QX002@06QXJ00<0fm_K
01XJ6P0J6QX0H00J6QX00`3oO`006QXJ01XJ6P2b01XJ6P030?mo000J6QX06QXJ0>006QXJ000T01XJ
6P<0fm_KG`0J6QX00`3oO`006QXJ01XJ6P2d01XJ6P030?mo000J6QX06QXJ0=l06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ05l06QXJ00<0ogl001XJ6P0J6QX0]@0J6QX20?mo0=l06QXJ000T01XJ6P030=_K
f`0J6QX06QXJ05h06QXJ00<0ogl001XJ6P0J6QX0^00J6QX00`3oO`006QXJ01XJ6P3L01XJ6P00900J
6QX00`3Kfm/06QXJ01XJ6P1M01XJ6P030?mo000J6QX06QXJ0;X06QXJ0P3oO`3L01XJ6P00900J6QX0
0`3Kfm/06QXJ01XJ6P1L01XJ6P030?mo000J6QX06QXJ0;d06QXJ00<0ogl001XJ6P0J6QX0f@0J6QX0
02@06QXJ00<0fm_K01XJ6P0J6QX0F`0J6QX00`3oO`006QXJ01XJ6P2o01XJ6P030?mo000J6QX06QXJ
0=P06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ05X06QXJ00<0ogl001XJ6P0J6QX0`@0J6QX20?mo0=P0
6QXJ000T01XJ6P030=_Kf`0J6QX06QXJ05T06QXJ00<0ogl001XJ6P0J6QX0E@0J6QX00`3Kfm/06QXJ
01XJ6P1/01XJ6P030?mo000J6QX06QXJ0=D06QXJ000T01XJ6P<0fm_KF00J6QX00`3oO`006QXJ01XJ
6P1E01XJ6P80fm_KK`0J6QX00`3oO`006QXJ01XJ6P3D01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P1G
01XJ6P030?mo000J6QX06QXJ05@06QXJ1P3Kfm]^01XJ6P030?mo000J6QX06QXJ0=<06QXJ000T01XJ
6P030=_Kf`0J6QX06QXJ05H06QXJ00<0ogl001XJ6P0J6QX0E@0J6QX20=_Kf`<06QXJ0`3Kfm]]01XJ
6P80ogl0d`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0E@0J6QX00`3oO`006QXJ01XJ6P1D01XJ6P<0
fm_K1P0J6QX20=_Kffh06QXJ00<0ogl001XJ6P0J6QX0d00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
E@0J6QX00`3oO`006QXJ01XJ6P1D01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0
K00J6QX00`3oO`006QXJ01XJ6P3?01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P1D01XJ6P030?mo000J
6QX06QXJ05806QXJ103Kfm/:01XJ6P030=_Kf`0J6QX06QXJ06d06QXJ00<0ogl001XJ6P0J6QX0cP0J
6QX002@06QXJ00<0fm_K01XJ6P0J6QX0D`0J6QX00`3oO`006QXJ01XJ6P1B01XJ6P050=_Kf`0J6QX0
fm_K01XJ6P3Kfm/02P0J6QX00`3Kfm/06QXJ01XJ6P1^01XJ6P030?mo000J6QX06QXJ0<d06QXJ000>
01XJ6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ05806QXJ00<0ogl0
01XJ6P0J6QX0D`0J6QX00`3Kfm/06QXJ0=_Kf`0=01XJ6P030=_Kf`0J6QX06QXJ06h06QXJ0P3oO`3=
01XJ6P003@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00<0
fm_K01XJ6P0J6QX0D@0J6QX00`3oO`006QXJ01XJ6P1D01XJ6P030=_Kf`0J6QX06QXJ00h06QXJ00<0
fm_K01XJ6P0J6QX0K`0J6QX00`3oO`006QXJ01XJ6P3:01XJ6P003@0J6QX0103Kfm/06QXJ01XJ6P3K
fm/:01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ103Kfm]?01XJ6P030?mo000J6QX06QXJ05<06QXJ0`3K
fm/A01XJ6P050=_Kf`0J6QX0fm_K0=_Kf`0J6QX00`3Kfm]Z01XJ6P030?mo000J6QX06QXJ0<T06QXJ
000701XJ6P@0fm_K0P0J6QX0103Kfm/06QXJ01XJ6P3Kfm/;01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ
00<0fm_K01XJ6P0J6QX0C`0J6QX00`3oO`006QXJ01XJ6P1C01XJ6P@0fm_K4P0J6QX20=_Kf`0301XJ
6P3Kfm/0fm_K0080fm_KJ`0J6QX00`3oO`006QXJ01XJ6P3801XJ6P003@0J6QX0103Kfm/06QXJ01XJ
6P3Kfm/801XJ6P040=_Kf`0J6QX06QXJ0=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX0C`0J6QX00`3oO`00
6QXJ01XJ6P1<01XJ6P040=_Kf`0J6QX06QXJ01XJ6P@0fm_K6@0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0
fm_K06X06QXJ0P3oO`3801XJ6P003P0J6QX20=_Kf`X06QXJ0P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ
04h06QXJ00<0ogl001XJ6P0J6QX0C@0J6QX20=_Kf`806QXJ0P3Kfm/N01XJ6P80fm_K0P0J6QX20=_K
ffP06QXJ00<0ogl001XJ6P0J6QX0a@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0C@0J6QX00`3oO`00
6QXJ01XJ6P1<01XJ6P<0fm_K00@06QXJ0=_Kf`0J6QX0fm_K800J6QX00`3Kfm/06QXJ0=_Kf`020=_K
f`0301XJ6P3Kfm/06QXJ06H06QXJ00<0ogl001XJ6P0J6QX0a00J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0C@0J6QX00`3oO`006QXJ01XJ6P1:01XJ6P@0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0P01XJ6P80
fm_K00@06QXJ0=_Kf`3Kfm/06QXJ0P3Kfm]V01XJ6P030?mo000J6QX06QXJ0<<06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ04`06QXJ00<0ogl001XJ6P0J6QX0A`0J6QX0103Kfm/06QXJ01XJ6P0J6QX20=_K
f`0301XJ6P3Kfm/06QXJ02H06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX30=_KffH06QXJ00<0ogl001XJ
6P0J6QX0`P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0B`0J6QX00`3oO`006QXJ01XJ6P0o01XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ0P3Kfm/01@0J6QX0fm_K01XJ6P0J6QX0fm_K03806QXJ0P3Kfm/201XJ
6P030=_Kf`0J6QX06QXJ06406QXJ00<0ogl001XJ6P0J6QX0`@0J6QX002@06QXJ0`3Kfm];01XJ6P03
0?mo000J6QX06QXJ03h06QXJ103Kfm/201XJ6P@0fm_K00@06QXJ0=_Kf`0J6QX0fm_K=00J6QX30=_K
ff@06QXJ00<0ogl001XJ6P0J6QX0`00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0BP0J6QX00`3oO`00
6QXJ01XJ6P0o01XJ6P040=_Kf`0J6QX0fm_K01XJ6P80fm_K0`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/g
01XJ6P030=_Kf`0J6QX06QXJ06<06QXJ00<0ogl001XJ6P0J6QX0_`0J6QX002@06QXJ00<0fm_K01XJ
6P0J6QX0B@0J6QX00`3oO`006QXJ01XJ6P0o01XJ6P030=_Kf`0J6QX06QXJ00806QXJ0P3Kfm/501XJ
6P80fm_K>00J6QX00`3Kfm/06QXJ01XJ6P1S01XJ6P030?mo000J6QX06QXJ0;h06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ04T06QXJ00<0ogl001XJ6P0J6QX0?`0J6QX00`3Kfm/06QXJ01XJ6P1401XJ6P03
0=_Kf`0J6QX06QXJ00@06QXJ0P3Kfm]M01XJ6P030?mo000J6QX06QXJ0;d06QXJ000T01XJ6P030=_K
f`0J6QX06QXJ04P06QXJ00<0ogl001XJ6P0J6QX0@00J6QX00`3Kfm/06QXJ01XJ6P1501XJ6P040=_K
f`0J6QX06QXJ01XJ6Q400?l0D@0J6QX00`3oO`006QXJ01XJ6P2l01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P1701XJ6P030?mo000J6QX06QXJ04006QXJ00<0fm_K01XJ6P0J6QX0@@0J6QX9003o00806QXJ
0P3Kfm/=01XJ6PT00?l0B@0J6QX00`3oO`006QXJ01XJ6P2k01XJ6P00900J6QX00`3Kfm/06QXJ01XJ
6P1701XJ6P030?mo000J6QX06QXJ03`06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0Q01XJ6Ph007oo
3`0J6QX5003o00H06QXJ00D0fm_K01XJ6P0J6QX06QXJ0=_Kf`0201XJ6P030=_Kf`0J6QX06QXJ01<0
6QXJ1@00o`1501XJ6P80ogl0^`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0AP0J6QX00`3oO`006QXJ
01XJ6P0m01XJ6P80fm_K00<06QXJ0=_Kf`0J6QX0500J6QX=001oo`h06QXJ2P00Ool5003o00`06QXJ
0`3Kfm/401XJ6P030=_Kf`0J6QX06QXJ01L06QXJ1@00o`1201XJ6P030?mo000J6QX06QXJ0;P06QXJ
000T01XJ6P<0fm_KA@0J6QX00`3oO`006QXJ01XJ6P0m01XJ6P050=_Kf`0J6QX0fm_K01XJ6P3Kfm/0
400J6QX5001ooal06QXJ1P00o`0301XJ6PH007oo2@0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P030=_K
f`0J6QX06QXJ01`06QXJ1@00o`0n01XJ6P030?mo000J6QX06QXJ0;L06QXJ000T01XJ6P030=_Kf`0J
6QX06QXJ04D06QXJ00<0ogl001XJ6P0J6QX0?@0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf``06QXJ1000
OolO01XJ6PD00?l03`0J6QX5001oo`/06QXJ00<0fm_K01XJ6P0J6QX0800J6QX6003o03T06QXJ00<0
ogl001XJ6P0J6QX0]P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0A00J6QX00`3oO`006QXJ01XJ6P0n
01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/0200J6QX4001ooal06QXJ1000o`0I01XJ6P@007oo200J
6QX00`3Kfm/06QXJ01XJ6P0J01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ1000o`0f01XJ6P030?mo000J
6QX06QXJ0;D06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ04@06QXJ00<0ogl001XJ6P0J6QX0?P0J6QX0
0`3Kfm/06QXJ01XJ6P0601XJ6P@007oo8@0J6QX2003o02406QXJ1000Ool501XJ6P040=_Kf`0J6QX0
6QXJ01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P80fm_K3P0J6QX3003o03@06QXJ00<0
ogl001XJ6P0J6QX0]00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0@`0J6QX00`3oO`006QXJ01XJ6P0k
01XJ6P030=_Kf`0J6QX0fm_K0080fm_K1@0J6QX3001oob<06QXJ0P00o`0W01XJ6P@007oo00@06QXJ
0=_Kf`3Kfm/06QXJ0`3Kfm/0100J6QX0fm_K01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00<0fm_K01XJ6P3Kfm/0400J6QX2003o03<06QXJ00<0ogl001XJ6P0J6QX0/`0J6QX002@06QXJ00<0
fm_K01XJ6P0J6QX0@P0J6QX00`3oO`006QXJ01XJ6P0l01XJ6P@0fm_K0`0J6QX3001oob@06QXJ0P00
o`0]01XJ6P<007oo0P3Kfm/201XJ6P80fm_K0P0J6QX20=_Kf`L06QXJ00@0fm_K01XJ6P3Kfm/0fm_K
0`0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ01406QXJ0`00o`0a01XJ6P030?mo000J6QX06QXJ0;806QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ04806QXJ00<0ogl001XJ6P0J6QX0?00J6QX0103Kfm/06QXJ01XJ
6P0J6QX3001oob@06QXJ0`00o`0b01XJ6P<007oo1P0J6QX00`3Kfm/06QXJ0=_Kf`0501XJ6P030=_K
f`0J6QX06QXJ00D0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P<00?l0;`0J6QX00`3oO`006QXJ
01XJ6P2a01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P1101XJ6P030?mo000J6QX06QXJ03X06QXJ00D0
fm_K01XJ6P0J6QX0fm_K01XJ6P02001oob@06QXJ0`00o`0h01XJ6P<007oo100J6QX0103Kfm/06QXJ
0=_Kf`3Kfm/201XJ6P80fm_K0`0J6QX0103Kfm/06QXJ0=_Kf`3Kfm/401XJ6P80fm_K5@0J6QX3003o
02d06QXJ00<0ogl001XJ6P0J6QX0/00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0@00J6QX00`3oO`00
6QXJ01XJ6P0k01XJ6P030=_Kf`0J6QX0fm_K008007oo900J6QX2003o03h06QXJ0`00Ool301XJ6PH0
fm_K3@0J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P800?l0;00J6QX00`3oO`006QXJ01XJ6P2_01XJ6P00
900J6QX30=_Kfd006QXJ00<0ogl001XJ6P0J6QX0>@0J6QX20=_Kf`0301XJ6P00Ool007oo02<06QXJ
0`00o`1301XJ6P<007oo500J6QX20=_KfaL06QXJ0`00o`0Z01XJ6P030?mo000J6QX06QXJ0:h06QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ03l06QXJ00<0ogl001XJ6P0J6QX0>P0J6QX0103Kfm/007oo001o
o`3Kfm/R01XJ6P800?l04@0J6QXT0?l0oa@06QXJ0`00OolB01XJ6P<0fm_K600J6QX2003o02T06QXJ
00<0ogl001XJ6P0J6QX0[@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0?P0J6QX00`3oO`006QXJ01XJ
6P0j01XJ6P8007oo8`0J6QX2003o00P06QXJ2`3o0?lT01XJ6PT0o`3o3P0J6QX3001ooa806QXJ00<0
fm_K01XJ6P0J6QX05`0J6QX2003o02P06QXJ00<0ogl001XJ6P0J6QX0[00J6QX002@06QXJ00<0fm_K
01XJ6P0J6QX0?P0J6QX00`3oO`006QXJ01XJ6P0h01XJ6P8007oo00<06QXJ0=_Kf`0J6QX0800J6QX2
003o00D06QXJ1@3o0?lh01XJ6PD0o`3o300J6QX3001ooa006QXJ00<0fm_K01XJ6P0J6QX0600J6QX2
003o02L06QXJ00<0ogl001XJ6P0J6QX0Z`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0?@0J6QX00`3o
O`006QXJ01XJ6P0g01XJ6P8007oo0P0J6QX00`3Kfm/06QXJ01XJ6P0N01XJ6P800?l00`0J6QX40?l0
od806QXJ1@3o0?l:01XJ6P8007oo3`0J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P800?l09@0J6QX00`3o
O`006QXJ01XJ6P2[01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0l01XJ6P030?mo000J6QX06QXJ03H0
6QXJ0P00Ool401XJ6P030=_Kf`0J6QX06QXJ01`06QXJ0P00o`000`0J6QX0o`3o0?l0o`020?l0od/0
6QXJ1P3o0?l601XJ6P8007oo3P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K0P0J6QX00`3Kfm/0
6QXJ01XJ6P0A01XJ6P800?l0900J6QX00`3oO`006QXJ01XJ6P2Z01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P0l01XJ6P030?mo000J6QX06QXJ03@06QXJ0P00Ool301XJ6P040=_Kf`0J6QX06QXJ0=_Kfad0
6QXJ103o0?mE01XJ6P@0o`3o100J6QX2001oo`d06QXJ203Kfm/0100J6QX0fm_K01XJ6P3Kfm/B01XJ
6P03003o000J6QX06QXJ02806QXJ00<0ogl001XJ6P0J6QX0Z@0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0>`0J6QX00`3oO`006QXJ01XJ6P0c01XJ6P8007oo1@0J6QX30=_Kfa/06QXJ0`3o0?mM01XJ6P@0
o`3o0P0J6QX2001oo`/06QXJ00<0fm_K01XJ6P3Kfm/00`0J6QX20=_Kf`0301XJ6P3Kfm/0fm_K0080
fm_K4P0J6QX2003o02<06QXJ00<0ogl001XJ6P0J6QX0Z00J6QX002@06QXJ0`3Kfm/k01XJ6P030?mo
000J6QX06QXJ03406QXJ0P00Ool701XJ6P<0fm_K600J6QX30?l0o`03003o000J6QX06QXJ06406QXJ
0`3o0?l0100J6QX007oo001oo`00Ool?01XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J
6QX04@0J6QX2003o02806QXJ00<0ogl001XJ6P0J6QX0Y`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
>P0J6QX00`3oO`006QXJ01XJ6P0a01XJ6P03001oo`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0
500J6QX40?l0o`0301XJ6P00o`000?l006L06QXJ103o0?l2001ooa<06QXJ0P3Kfm/D01XJ6P800?l0
8@0J6QX00`3oO`006QXJ01XJ6P2V01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0j01XJ6P030?mo000J
6QX06QXJ02l06QXJ0P00Ool:01XJ6P030=_Kf`0J6QX06QXJ01406QXJ0`3o0?l301XJ6P800?l0K@0J
6QX30?l0o`03001oo`0J6QX06QXJ01406QXJ0P3Kfm/D01XJ6P800?l0800J6QX00`3oO`006QXJ01XJ
6P2U01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0i01XJ6P030?mo000J6QX06QXJ02l06QXJ00<007oo
01XJ6P0J6QX02P0J6QX00`3Kfm/06QXJ01XJ6P0?01XJ6P80o`3o1@0J6QX00`00o`006QXJ01XJ6P1`
01XJ6P@0o`3o4@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K400J6QX2003o01l06QXJ00<0ogl0
01XJ6P0J6QX0Y00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0>@0J6QX00`3oO`006QXJ01XJ6P0^01XJ
6P03001oo`0J6QX06QXJ00/06QXJ00<0fm_K01XJ6P0J6QX0300J6QX30?l0o`D06QXJ0P00o`1f01XJ
6P04001oo`3o0?l0o`3o0?l0o`l06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/B01XJ6P03003o
000J6QX06QXJ01d06QXJ00<0ogl001XJ6P0J6QX0X`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0>00J
6QX00`3oO`006QXJ01XJ6P0]01XJ6P8007oo3@0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P80o`3o1`0J
6QX00`00o`006QXJ01XJ6P1h01XJ6P8007oo0P3o0?l=01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`806QXJ
00<0fm_K01XJ6P0J6QX0400J6QX2003o01h06QXJ00<0ogl001XJ6P0J6QX0XP0J6QX000P06QXJ0P3K
fm/401XJ6P80fm_K0`0J6QX40=_Kf`<06QXJ0P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ03P06QXJ00<0
ogl001XJ6P0J6QX0;00J6QX00`00Ool06QXJ01XJ6P0=01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ0`3o
0?l701XJ6P800?l0O@0J6QX2001oo`<0o`3o2`0J6QX00`3Kfm/06QXJ0=_Kf`0201XJ6P030=_Kf`0J
6QX06QXJ01806QXJ0P00o`0M01XJ6P030?mo000J6QX06QXJ0:406QXJ000701XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/701XJ6P030=_K
f`0J6QX06QXJ03L06QXJ00<0ogl001XJ6P0J6QX0:`0J6QX2001oo`l06QXJ00<0fm_K01XJ6P0J6QX0
1`0J6QX20?l0o`T06QXJ00<00?l001XJ6P0J6QX0O`0J6QX2001oo`0301XJ6P3o0?l0o`3o00T06QXJ
0P3Kfm/401XJ6P030=_Kf`0J6QX06QXJ01<06QXJ00<00?l001XJ6P0J6QX06`0J6QX00`3oO`006QXJ
01XJ6P2P01XJ6P001`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX06QXJ00D06QXJ
00<0fm_K01XJ6P0J6QX01@0J6QX40=_KfcH06QXJ00<0ogl001XJ6P0J6QX0:P0J6QX00`00Ool06QXJ
0=_Kf`0401XJ6P<0fm_K100J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00H06QXJ0`3o0?l:01XJ6P03003o
000J6QX06QXJ08806QXJ0P00Ool0100J6QX0o`3o0?l0o`3o0?l=01XJ6P030=_Kf`0J6QX06QXJ01<0
6QXJ0P00o`0K01XJ6P030?mo000J6QX06QXJ0:006QXJ00000`0J6QX0fm_K0=_Kf`020=_Kf`806QXJ
00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P80fm_K200J6QX00`3Kfm/0
6QXJ01XJ6P0f01XJ6P030?mo000J6QX06QXJ02X06QXJ00<007oo01XJ6P0J6QX00P3Kfm/201XJ6P80
fm_K00<06QXJ0=_Kf`3Kfm/00`0J6QX40=_Kf`D06QXJ0P3o0?l;01XJ6P800?l0Q`0J6QX01000Ool0
6QXJ01XJ6P0J6QX20?l0o``06QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`00o`006QXJ01XJ6P0I01XJ
6P030?mo000J6QX06QXJ09l06QXJ000701XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ
6P0J6QX0fm_K0`0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ03H06QXJ00<0ogl0
01XJ6P0J6QX0:@0J6QX02@00Ool06QXJ01XJ6P0J6QX0fm_K01XJ6P3Kfm/06QXJ0=_Kf`0401XJ6P@0
fm_K00<06QXJ0=_Kf`0J6QX00`0J6QX20?l0o``06QXJ00<00?l001XJ6P0J6QX0R00J6QX2001oo`<0
6QXJ0`3o0?l901XJ6P030=_Kf`0J6QX06QXJ01D06QXJ0P00o`0J01XJ6P030?mo000J6QX06QXJ09h0
6QXJ000801XJ6P80fm_K2P0J6QX20=_Kf`@06QXJ0`3Kfm/701XJ6P030=_Kf`0J6QX06QXJ03D06QXJ
00<0ogl001XJ6P0J6QX0:00J6QX2001oo`<06QXJ00H0fm_K01XJ6P0J6QX0fm_K01XJ6P3Kfm/501XJ
6P030=_Kf`0J6QX06QXJ00@06QXJ0P3o0?l=01XJ6P03003o000J6QX06QXJ08/06QXJ0P00Ool401XJ
6P80o`3o1`0J6QX00`3Kfm/06QXJ0=_Kf`0G01XJ6P800?l06@0J6QX00`3oO`006QXJ01XJ6P2M01XJ
6P00900J6QX00`3Kfm/06QXJ01XJ6P0e01XJ6P030?mo000J6QX06QXJ02L06QXJ00<007oo01XJ6P0J
6QX00`0J6QX01@3Kfm/06QXJ01XJ6P0J6QX0fm_K00/06QXJ0P3o0?l=01XJ6P800?l0T00J6QX2001o
o`@06QXJ0`3o0?l501XJ6P<0fm_K600J6QX00`00o`006QXJ01XJ6P0G01XJ6P030?mo000J6QX06QXJ
09`06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ03@06QXJ00<0ogl001XJ6P0J6QX09`0J6QX00`00Ool0
6QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00/06QXJ0P3o0?l>01XJ6P03003o000J6QX06QXJ0980
6QXJ0P00Ool501XJ6P80o`3o0`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/H01XJ6P800?l0600J6QX00`3o
O`006QXJ01XJ6P2K01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0d01XJ6P030?mo000J6QX06QXJ02H0
6QXJ00<007oo01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P80o`3o3P0J6QX2003o09L0
6QXJ0P00Ool501XJ6P80o`3o1@0J6QX00`3Kfm/06QXJ01XJ6P0G01XJ6P03003o000J6QX06QXJ01H0
6QXJ00<0ogl001XJ6P0J6QX0VP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0=00J6QX00`3oO`006QXJ
01XJ6P0U01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3o0?l06QXJ
01XJ6P0=01XJ6P03003o000J6QX06QXJ09T06QXJ00<007oo01XJ6P0J6QX0100J6QX20?l0o`@06QXJ
00<0fm_K01XJ6P0J6QX05`0J6QX2003o01L06QXJ00<0ogl001XJ6P0J6QX0V@0J6QX002@06QXJ00<0
fm_K01XJ6P0J6QX0<`0J6QX00`3oO`006QXJ01XJ6P0U01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0
fm_K01XJ6P0J6QX01`0J6QX20?l0o`l06QXJ00<00?l001XJ6P0J6QX0V`0J6QX2001oo`H06QXJ0P3o
0?l201XJ6P030=_Kf`0J6QX06QXJ01T06QXJ0P00o`0F01XJ6P030?mo000J6QX06QXJ09P06QXJ000T
01XJ6P<0fm_K<`0J6QX00`3oO`006QXJ01XJ6P0S01XJ6P8007oo200J6QX00`3Kfm/06QXJ01XJ6P06
01XJ6P80o`3o3`0J6QX2003o0:006QXJ0P00Ool601XJ6P80o`3o00<06QXJ0=_Kf`0J6QX06`0J6QX0
0`00o`006QXJ01XJ6P0D01XJ6P030?mo000J6QX06QXJ09L06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ
03806QXJ00<0ogl001XJ6P0J6QX08`0J6QX00`00Ool06QXJ01XJ6P0701XJ6P80fm_K1P0J6QX20?l0
oa006QXJ00<00?l001XJ6P0J6QX0XP0J6QX00`00Ool06QXJ01XJ6P0501XJ6P80o`3o7@0J6QX00`00
o`006QXJ01XJ6P0D01XJ6P030?mo000J6QX06QXJ09H06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ0380
6QXJ00<0ogl001XJ6P0J6QX08P0J6QX00`00Ool06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00<0
6QXJ0P3o0?lA01XJ6P03003o000J6QX06QXJ0:@06QXJ0P00Ool701XJ6P80o`3o700J6QX2003o01@0
6QXJ00<0ogl001XJ6P0J6QX0UP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0<@0J6QX00`3oO`006QXJ
01XJ6P0R01XJ6P03001oo`0J6QX06QXJ00P06QXJ0P3Kfm/301XJ6P80o`3o4@0J6QX2003o0:T06QXJ
00<007oo01XJ6P0J6QX01@0J6QX00`3Kfm/0o`3o0?l0o`0401XJ6P030=_Kf`0J6QX06QXJ01D06QXJ
00<00?l001XJ6P0J6QX04P0J6QX00`3oO`006QXJ01XJ6P2E01XJ6P00900J6QX00`3Kfm/06QXJ01XJ
6P0a01XJ6P030?mo000J6QX06QXJ02406QXJ00<007oo01XJ6P0J6QX0200J6QX30=_Kf`806QXJ00<0
o`3o01XJ6P0J6QX0400J6QX00`00o`006QXJ01XJ6P2Z01XJ6P8007oo1P0J6QX0103Kfm/06QXJ0?l0
o`3o0?l201XJ6P80fm_K5`0J6QX00`00o`006QXJ01XJ6P0B01XJ6P030?mo000J6QX06QXJ09@06QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ03006QXJ00<0ogl001XJ6P0J6QX0800J6QX2001oo`T06QXJ0`3K
fm/201XJ6P80o`3o4P0J6QX00`00o`006QXJ01XJ6P2]01XJ6P8007oo1@0J6QX20=_Kf`0301XJ6P3o
0?l0o`3o0080fm_K600J6QX00`00o`006QXJ01XJ6P0B01XJ6P030?mo000J6QX06QXJ09<06QXJ000T
01XJ6P030=_Kf`0J6QX06QXJ03006QXJ00<0ogl001XJ6P0J6QX07`0J6QX00`00Ool06QXJ01XJ6P02
01XJ6P80fm_K0P0J6QX00`3Kfm/06QXJ01XJ6P020=_Kf`806QXJ00<0o`3o01XJ6P0J6QX04@0J6QX0
0`00o`006QXJ01XJ6P2`01XJ6P03001oo`0J6QX06QXJ00@06QXJ0`3Kfm/20?l0o`030=_Kf`0J6QX0
6QXJ01H06QXJ0P00o`0C01XJ6P030?mo000J6QX06QXJ09806QXJ000T01XJ6P030=_Kf`0J6QX06QXJ
02l06QXJ00<0ogl001XJ6P0J6QX07`0J6QX00`00Ool06QXJ01XJ6P0201XJ6PD0fm_K00@06QXJ0=_K
f`0J6QX0fm_K0P0J6QX00`3o0?l06QXJ01XJ6P0A01XJ6P03003o000J6QX06QXJ0;806QXJ0P00Ool7
01XJ6P060=_Kf`0J6QX0o`3o0?l0o`0J6QX0fm_K5`0J6QX00`00o`006QXJ01XJ6P0A01XJ6P030?mo
000J6QX06QXJ09406QXJ000T01XJ6P<0fm_K;`0J6QX00`3oO`006QXJ01XJ6P0N01XJ6P03001oo`0J
6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0100J6QX20=_Kf`80o`3o4`0J6QX00`00o`006QXJ01XJ
6P2e01XJ6P03001oo`0J6QX06QXJ00L06QXJ00<0fm_K0?l0o`3o0?l0600J6QX00`00o`006QXJ01XJ
6P0A01XJ6P030?mo000J6QX06QXJ09006QXJ000T01XJ6P030=_Kf`0J6QX06QXJ02h06QXJ00<0ogl0
01XJ6P0J6QX07P0J6QX00`00Ool06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0o`3o
01XJ6P0J6QX04P0J6QX00`00o`006QXJ01XJ6P2g01XJ6P8007oo200J6QX00`3Kfm/06QXJ0?l0o`0H
01XJ6P03003o000J6QX06QXJ01406QXJ00<0ogl001XJ6P0J6QX0S`0J6QX002@06QXJ00<0fm_K01XJ
6P0J6QX0;P0J6QX00`3oO`006QXJ01XJ6P0M01XJ6P03001oo`0J6QX06QXJ00D06QXJ00<0fm_K01XJ
6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0B01XJ6P03003o000J6QX06QXJ0;X06QXJ0P00Ool901XJ
6P80o`3o5`0J6QX2003o01806QXJ00<0ogl001XJ6P0J6QX0SP0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0;P0J6QX00`3oO`006QXJ01XJ6P0L01XJ6P03001oo`0J6QX06QXJ00D06QXJ0P3Kfm/401XJ6P80
o`3o500J6QX00`00o`006QXJ01XJ6P2m01XJ6P03001oo`0J6QX06QXJ00H06QXJ00@0fm_K01XJ6P3o
0?l0o`3o5`0J6QX00`00o`006QXJ01XJ6P0@01XJ6P030?mo000J6QX06QXJ08d06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ02d06QXJ00<0ogl001XJ6P0J6QX07@0J6QX00`00Ool06QXJ01XJ6P0501XJ6P03
0=_Kf`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX04`0J6QX00`00o`006QXJ01XJ6P2o01XJ6P03
001oo`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX00P3o0?lF01XJ6P03003o000J6QX06QXJ0100
6QXJ00<0ogl001XJ6P0J6QX0S00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0;@0J6QX00`3oO`006QXJ
01XJ6P0L01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX00P3o0?lE01XJ6P03003o
000J6QX06QXJ0<406QXJ0P00Ool701XJ6P050=_Kf`0J6QX06QXJ01XJ6P3o0?l00P0J6QX20=_Kfa80
6QXJ00<00?l001XJ6P0J6QX0400J6QX00`3oO`006QXJ01XJ6P2;01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P0/01XJ6P030?mo000J6QX06QXJ01`06QXJ00<007oo01XJ6P0J6QX01P0J6QX0103Kfm/06QXJ
01XJ6P3o0?lE01XJ6P800?l0aP0J6QX00`00Ool06QXJ01XJ6P0501XJ6P80fm_K0P0J6QX20?l0o`03
0=_Kf`0J6QX0fm_K01806QXJ0P00o`0@01XJ6P030?mo000J6QX06QXJ08/06QXJ000T01XJ6P030=_K
f`0J6QX06QXJ02`06QXJ00<0ogl001XJ6P0J6QX06`0J6QX00`00Ool06QXJ01XJ6P0701XJ6P030=_K
f`0J6QX0o`3o01D06QXJ00<00?l001XJ6P0J6QX0a`0J6QX00`00Ool06QXJ01XJ6P0501XJ6P030=_K
f`0J6QX0fm_K00806QXJ0P3o0?l00`3Kfm/06QXJ01XJ6P0B01XJ6P03003o000J6QX06QXJ00h06QXJ
00<0ogl001XJ6P0J6QX0RP0J6QX002@06QXJ0`3Kfm/[01XJ6P030?mo000J6QX06QXJ01/06QXJ00<0
07oo01XJ6P0J6QX0200J6QX20?l0oaD06QXJ00<00?l001XJ6P0J6QX0b@0J6QX2001oo`H06QXJ103K
fm/201XJ6P80o`3o500J6QX00`00o`006QXJ01XJ6P0>01XJ6P030?mo000J6QX06QXJ08T06QXJ000T
01XJ6P030=_Kf`0J6QX06QXJ02/06QXJ00<0ogl001XJ6P0J6QX06P0J6QX00`00Ool06QXJ01XJ6P08
01XJ6P030?l0o`3Kfm/06QXJ01@06QXJ00<00?l001XJ6P0J6QX0c00J6QX00`00Ool06QXJ01XJ6P03
01XJ6P80fm_K1@0J6QX00`3Kfm/0o`3o01XJ6P0C01XJ6P03003o000J6QX06QXJ00h06QXJ00<0ogl0
01XJ6P0J6QX0R00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0:P0J6QX00`3oO`006QXJ01XJ6P0K01XJ
6P03001oo`0J6QX06QXJ00L06QXJ00<0o`3o01XJ6P3Kfm/0500J6QX00`00o`006QXJ01XJ6P3>01XJ
6P03001oo`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3Kfm/0o`3o0?l0o`0C01XJ
6P03003o000J6QX06QXJ00h06QXJ00<0ogl001XJ6P0J6QX0Q`0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0:P0J6QX00`3oO`006QXJ01XJ6P0J01XJ6P03001oo`0J6QX06QXJ00H06QXJ0P3o0?l201XJ6P03
0=_Kf`0J6QX06QXJ01406QXJ00<00?l001XJ6P0J6QX0d00J6QX2001oo`X06QXJ00@0fm_K01XJ6P0J
6QX0o`3o4`0J6QX00`00o`006QXJ01XJ6P0>01XJ6P030?mo000J6QX06QXJ08H06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ02T06QXJ00<0ogl001XJ6P0J6QX06P0J6QX00`00Ool06QXJ01XJ6P0601XJ6P03
0?l0o`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX0400J6QX00`00o`006QXJ01XJ6P3C01XJ6P03
001oo`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX00P3o0?lB01XJ6P03003o000J6QX06QXJ00h0
6QXJ00<0ogl001XJ6P0J6QX0Q@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0:@0J6QX00`3oO`006QXJ
01XJ6P0I01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0o`3o01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ
01XJ6P0?01XJ6P03003o000J6QX06QXJ0=D06QXJ00<007oo01XJ6P0J6QX0200J6QX01@3Kfm/06QXJ
01XJ6P0J6QX0o`3o01806QXJ0P00o`0?01XJ6P030?mo000J6QX06QXJ08@06QXJ000T01XJ6P030=_K
f`0J6QX06QXJ02P06QXJ00<0ogl001XJ6P0J6QX06@0J6QX00`00Ool06QXJ01XJ6P0601XJ6P030?l0
o`0J6QX06QXJ00806QXJ0P3Kfm/A01XJ6P03003o000J6QX06QXJ0=L06QXJ0P00Ool801XJ6P030=_K
f`0J6QX0fm_K00806QXJ0P3o0?lB01XJ6P03003o000J6QX06QXJ00`06QXJ00<0ogl001XJ6P0J6QX0
Q00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0:00J6QX00`3oO`006QXJ01XJ6P0H01XJ6P03001oo`0J
6QX06QXJ00H06QXJ00<0o`3o01XJ6P0J6QX00`0J6QX20=_Kfa006QXJ00<00?l001XJ6P0J6QX0fP0J
6QX00`00Ool06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX0fm_K00<06QXJ00<0o`3o01XJ6P0J6QX0400J
6QX00`00o`006QXJ01XJ6P0<01XJ6P030?mo000J6QX06QXJ08<06QXJ000T01XJ6P<0fm_K9`0J6QX0
0`3oO`006QXJ01XJ6P0I01XJ6P03001oo`0J6QX06QXJ00D06QXJ00<0o`3o01XJ6P0J6QX0100J6QX0
0`3Kfm/06QXJ01XJ6P0>01XJ6P03003o000J6QX06QXJ0=`06QXJ00<007oo01XJ6P0J6QX0200J6QX0
103Kfm/06QXJ01XJ6P0J6QX20?l0oa406QXJ00<00?l001XJ6P0J6QX0300J6QX00`3oO`006QXJ01XJ
6P2201XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0W01XJ6P030?mo000J6QX06QXJ01P06QXJ00<007oo
01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<00?l0
01XJ6P0J6QX0gP0J6QX2001oo`T06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX20?l0oa006QXJ00<00?l0
01XJ6P0J6QX0300J6QX00`3oO`006QXJ01XJ6P2101XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0W01XJ
6P030?mo000J6QX06QXJ01L06QXJ00<007oo01XJ6P0J6QX01P0J6QX00`3o0?l06QXJ01XJ6P0501XJ
6P030=_Kf`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0h@0J6QX00`00Ool06QXJ01XJ6P0601XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`<06QXJ00<0o`3o01XJ6P0J6QX03P0J6QX00`00o`006QXJ01XJ6P0<
01XJ6P030?mo000J6QX06QXJ08006QXJ000T01XJ6P030=_Kf`0J6QX06QXJ02H06QXJ00<0ogl001XJ
6P0J6QX05`0J6QX00`00Ool06QXJ01XJ6P0601XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ
6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3R01XJ6P03001oo`0J6QX06QXJ00H06QXJ00@0fm_K01XJ
6P3Kfm/0fm_K0`0J6QX20?l0o`l06QXJ00<00?l001XJ6P0J6QX02`0J6QX00`3oO`006QXJ01XJ6P20
01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0V01XJ6P030?mo000J6QX06QXJ01H06QXJ00<007oo01XJ
6P0J6QX01P0J6QX00`3o0?l06QXJ01XJ6P0501XJ6P<0fm_K3@0J6QX00`00o`006QXJ01XJ6P3T01XJ
6P8007oo1`0J6QX20=_Kf`0301XJ6P3Kfm/06QXJ00<06QXJ00<0o`3o01XJ6P0J6QX03@0J6QX00`00
o`006QXJ01XJ6P0;01XJ6P030?mo000J6QX06QXJ07l06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ02D0
6QXJ00<0ogl001XJ6P0J6QX05P0J6QX00`00Ool06QXJ01XJ6P0601XJ6P030?l0o`0J6QX06QXJ00H0
6QXJ0P3Kfm/=01XJ6P03003o000J6QX06QXJ0>L06QXJ00<007oo01XJ6P0J6QX01`0J6QX00`3Kfm/0
6QXJ01XJ6P0301XJ6P80o`3o3P0J6QX00`00o`006QXJ01XJ6P0;01XJ6P030?mo000J6QX06QXJ07h0
6QXJ000T01XJ6P030=_Kf`0J6QX06QXJ02D06QXJ00<0ogl001XJ6P0J6QX05P0J6QX00`00Ool06QXJ
01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00H06QXJ0`3Kfm/<01XJ6P03003o000J6QX06QXJ0>T06QXJ
00<007oo01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00`06QXJ
0P00o`0<01XJ6P030?mo000J6QX06QXJ07d06QXJ000>01XJ6P80fm_K100J6QX20=_Kf`<06QXJ103K
fm/701XJ6P030=_Kf`0J6QX06QXJ02D06QXJ00<0ogl001XJ6P0J6QX05@0J6QX00`00Ool06QXJ01XJ
6P0501XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ
6P3[01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ01XJ
6P0=01XJ6P03003o000J6QX06QXJ00X06QXJ00<0ogl001XJ6P0J6QX0O00J6QX000d06QXJ00@0fm_K
01XJ6P0J6QX0fm_K200J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ02@06QXJ00<0
ogl001XJ6P0J6QX05@0J6QX00`00Ool06QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3]01XJ6P8007oo1`0J6QX00`3Kfm/06QXJ01XJ
6P0501XJ6P80o`3o3P0J6QX00`00o`006QXJ01XJ6P0901XJ6P030?mo000J6QX06QXJ07`06QXJ000=
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX40=_Kfb<06QXJ00<0
ogl001XJ6P0J6QX0500J6QX00`00Ool06QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0
fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3_01XJ6P03001oo`0J6QX06QXJ00@06QXJ00<0
fm_K01XJ6P0J6QX01`0J6QX00`3o0?l06QXJ01XJ6P0<01XJ6P03003o000J6QX06QXJ00T06QXJ00<0
ogl001XJ6P0J6QX0N`0J6QX000L06QXJ103Kfm/201XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0
fm_K01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0S01XJ6P030?mo000J6QX06QXJ01@06QXJ00<0
07oo01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0
0?l001XJ6P0J6QX0l@0J6QX00`00Ool06QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0
o`3o01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P0901XJ6P030?mo000J6QX06QXJ07X06QXJ000=
01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ
01XJ6P0S01XJ6P030?mo000J6QX06QXJ01@06QXJ00<007oo01XJ6P0J6QX0100J6QX00`3o0?l06QXJ
01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0l`0J6QX00`00Ool06QXJ
01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0o`3o01XJ6P0J6QX0300J6QX00`00o`006QXJ
01XJ6P0901XJ6P030?mo000J6QX06QXJ07T06QXJ000>01XJ6P80fm_K2P0J6QX20=_Kf`P06QXJ00<0
fm_K01XJ6P0J6QX08`0J6QX00`3oO`006QXJ01XJ6P0C01XJ6P03001oo`0J6QX06QXJ00D06QXJ00<0
o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P03003o000J6QX06QXJ0?D06QXJ00<0
07oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P80o`3o3@0J6QX00`00o`006QXJ01XJ
6P0901XJ6P030?mo000J6QX06QXJ07P06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ02806QXJ00<0ogl0
01XJ6P0J6QX04`0J6QX00`00Ool06QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0fm_K
01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3g01XJ6P8007oo0`0J6QX00`3Kfm/06QXJ01XJ6P0:
01XJ6P030?l0o`0J6QX06QXJ00/06QXJ00<00?l001XJ6P0J6QX0200J6QX00`3oO`006QXJ01XJ6P1h
01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0R01XJ6P030?mo000J6QX06QXJ01<06QXJ00<007oo01XJ
6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<00?l001XJ
6P0J6QX0nP0J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00`06QXJ00<0o`3o01XJ6P0J6QX02`0J6QX0
0`00o`006QXJ01XJ6P0801XJ6P030?mo000J6QX06QXJ07L06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ
02406QXJ00<0ogl001XJ6P0J6QX04`0J6QX00`00Ool06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ
00L06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3k01XJ6P05001oo`0J6QX06QXJ
01XJ6P3Kfm/0300J6QX00`3o0?l06QXJ01XJ6P0;01XJ6P03003o000J6QX06QXJ00P06QXJ00<0ogl0
01XJ6P0J6QX0MP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX08@0J6QX00`3oO`006QXJ01XJ6P0C01XJ
6P03001oo`0J6QX06QXJ00<06QXJ00<0o`3o01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ
6P03003o000J6QX06QXJ0?d06QXJ00@007oo01XJ6P0J6QX06QXJ0P3Kfm/;01XJ6P030?l0o`0J6QX0
6QXJ00/06QXJ00<00?l001XJ6P0J6QX0200J6QX00`3oO`006QXJ01XJ6P1e01XJ6P00900J6QX30=_K
fb406QXJ00<0ogl001XJ6P0J6QX04P0J6QX00`00Ool06QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ
00L06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3o01XJ6P8007oo0P0J6QX30=_K
f`X06QXJ0P3o0?l<01XJ6P03003o000J6QX06QXJ00P06QXJ00<0ogl001XJ6P0J6QX0M00J6QX002@0
6QXJ00<0fm_K01XJ6P0J6QX0800J6QX00`3oO`006QXJ01XJ6P0B01XJ6P03001oo`0J6QX06QXJ00<0
6QXJ00<0o`3o01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P03003o000J6QX06QXJ0?l0
6QXJ0`0J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00806QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3o
0?l06QXJ01XJ6P0:01XJ6P03003o000J6QX06QXJ00L06QXJ00<0ogl001XJ6P0J6QX0M00J6QX002@0
6QXJ00<0fm_K01XJ6P0J6QX0800J6QX00`3oO`006QXJ01XJ6P0B01XJ6P03001oo`0J6QX06QXJ00<0
6QXJ00<0o`3o01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P03003o000J6QX06QXJ0?l0
6QXJ1@0J6QX01000Ool06QXJ01XJ6P0J6QX40=_Kf`T06QXJ00<0o`3o01XJ6P0J6QX02P0J6QX00`00
o`006QXJ01XJ6P0701XJ6P030?mo000J6QX06QXJ07<06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ0200
6QXJ00<0ogl001XJ6P0J6QX04@0J6QX00`00Ool06QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00L0
6QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`00o`006QXJ01XJ6P3o01XJ6PL06QXJ00<007oo01XJ6P0J
6QX00P0J6QX00`3Kfm/06QXJ0=_Kf`0901XJ6P030?l0o`0J6QX06QXJ00X06QXJ00<00?l001XJ6P0J
6QX01`0J6QX00`3oO`006QXJ01XJ6P1b01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P030?mo
000J6QX06QXJ01406QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3o0?l06QXJ01XJ6P0701XJ6P030=_K
f`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0o`0J6QX801XJ6P03001oo`0J6QX06QXJ00@06QXJ
00<0fm_K01XJ6P0J6QX01`0J6QX20?l0o`/06QXJ00<00?l001XJ6P0J6QX01`0J6QX00`3oO`006QXJ
01XJ6P1a01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0O01XJ6P030?mo000J6QX06QXJ01406QXJ00<0
07oo01XJ6P0J6QX00P0J6QX00`3o0?l06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<0
0?l001XJ6P0J6QX0o`0J6QX:01XJ6P8007oo100J6QX0103Kfm/06QXJ0=_Kf`0J6QX20=_Kf`H06QXJ
00<0o`3o01XJ6P0J6QX02@0J6QX00`00o`006QXJ01XJ6P0601XJ6P030?mo000J6QX06QXJ07406QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ01h06QXJ00<0ogl001XJ6P0J6QX04@0J6QX00`00Ool06QXJ01XJ
6P0301XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ
6P3o01XJ6Pd06QXJ00<007oo01XJ6P0J6QX00P0J6QX50=_Kf`L06QXJ00<0o`3o01XJ6P0J6QX02@0J
6QX00`00o`006QXJ01XJ6P0601XJ6P030?mo000J6QX06QXJ07006QXJ000T01XJ6P030=_Kf`0J6QX0
6QXJ01h06QXJ00<0ogl001XJ6P0J6QX04@0J6QX00`00Ool06QXJ01XJ6P0201XJ6P030?l0o`0J6QX0
6QXJ00L06QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`00o`006QXJ01XJ6P3o01XJ6Pl06QXJ00<007oo
01XJ6P0J6QX00P0J6QX01@3Kfm/06QXJ0=_Kf`0J6QX0fm_K00<06QXJ00D0fm_K01XJ6P0J6QX06QXJ
0?l0o`0;01XJ6P03003o000J6QX06QXJ00H06QXJ00<0ogl001XJ6P0J6QX0K`0J6QX002@06QXJ0`3K
fm/N01XJ6P030?mo000J6QX06QXJ01006QXJ00<007oo01XJ6P0J6QX00P0J6QX00`3o0?l06QXJ01XJ
6P0701XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<00?l001XJ6P0J6QX0o`0J6QXA01XJ6P03001oo`0J
6QX06QXJ00D06QXJ0P3Kfm/00`0J6QX0fm_K0=_Kf`0401XJ6P030?l0o`0J6QX06QXJ00T06QXJ00<0
0?l001XJ6P0J6QX01P0J6QX00`3oO`006QXJ01XJ6P1^01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0M
01XJ6P030?mo000J6QX06QXJ01006QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3o0?l06QXJ01XJ6P06
01XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0o`0J6QXB01XJ6P03001oo`0J6QX0
6QXJ00H06QXJ0P3Kfm/00`0J6QX0fm_K01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00T06QXJ00<00?l0
01XJ6P0J6QX01@0J6QX00`3oO`006QXJ01XJ6P1^01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0M01XJ
6P030?mo000J6QX06QXJ01006QXJ00<007oo01XJ6P0J6QX00P0J6QX00`3o0?l06QXJ01XJ6P0601XJ
6P030=_Kf`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0o`0J6QXD01XJ6P03001oo`0J6QX06QXJ
00D06QXJ0P3Kfm/201XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX02@0J6QX00`00
o`006QXJ01XJ6P0501XJ6P030?mo000J6QX06QXJ06d06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01`0
6QXJ00<0ogl001XJ6P0J6QX0400J6QX00`00Ool06QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00H0
6QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ6P3o01XJ6QH06QXJ0P00Ool601XJ6P05
0=_Kf`0J6QX06QXJ01XJ6P3Kfm/0100J6QX20?l0o`X06QXJ00<00?l001XJ6P0J6QX01@0J6QX00`3o
O`006QXJ01XJ6P1/01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0L01XJ6P030?mo000J6QX06QXJ00l0
6QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3o0?l06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00/0
6QXJ00<00?l001XJ6P0J6QX0o`0J6QXI01XJ6P03001oo`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J
6QX0100J6QX00`3o0?l06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ00D06QXJ00<0ogl001XJ6P0J
6QX0J`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0700J6QX00`3oO`006QXJ01XJ6P0?01XJ6P03001o
o`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ6P03003o
000J6QX06QXJ0?l06QXJ6P0J6QX00`00Ool06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00<0o`3o01XJ6P0J6QX0200J6QX00`00o`006QXJ01XJ6P0401XJ6P030?mo000J6QX06QXJ06/06QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ01/06QXJ00<0ogl001XJ6P0J6QX03`0J6QX00`00Ool06QXJ01XJ
6P0201XJ6P030?l0o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`00o`006QXJ01XJ
6P3o01XJ6Q`06QXJ00<007oo01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J
6QX06QXJ00P06QXJ00<00?l001XJ6P0J6QX0100J6QX00`3oO`006QXJ01XJ6P1Z01XJ6P00900J6QX0
0`3Kfm/06QXJ01XJ6P0K01XJ6P030?mo000J6QX06QXJ00l06QXJ00D007oo01XJ6P0J6QX06QXJ0?l0
o`0801XJ6P030=_Kf`0J6QX06QXJ00`06QXJ00<00?l001XJ6P0J6QX0o`0J6QXN01XJ6P03001oo`0J
6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0801XJ6P03003o000J
6QX06QXJ00@06QXJ00<0ogl001XJ6P0J6QX0J@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX06`0J6QX0
0`3oO`006QXJ01XJ6P0>01XJ6P03001oo`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX01P0J6QX0
0`3Kfm/06QXJ01XJ6P0;01XJ6P03003o000J6QX06QXJ0?l06QXJ800J6QX00`00Ool06QXJ01XJ6P07
01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0o`3o01XJ6P0J6QX0200J6QX00`00o`006QXJ01XJ6P04
01XJ6P030?mo000J6QX06QXJ06P06QXJ000T01XJ6P<0fm_K6`0J6QX00`3oO`006QXJ01XJ6P0=01XJ
6P03001oo`0J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0<01XJ
6P03003o000J6QX06QXJ0?l06QXJ8@0J6QX2001oo`P06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3o
0?l06QXJ01XJ6P0701XJ6P03003o000J6QX06QXJ00@06QXJ00<0ogl001XJ6P0J6QX0J00J6QX002@0
6QXJ00<0fm_K01XJ6P0J6QX06P0J6QX00`3oO`006QXJ01XJ6P0>01XJ6P05001oo`0J6QX06QXJ01XJ
6P3o0?l02@0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P03003o000J6QX06QXJ0?l06QXJ900J6QX00`00
Ool06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0o`3o01XJ6P0J6QX01`0J6QX00`00
o`006QXJ01XJ6P0401XJ6P030?mo000J6QX06QXJ06L06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01X0
6QXJ00<0ogl001XJ6P0J6QX03@0J6QX00`00Ool06QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00H0
6QXJ00<0fm_K01XJ6P0J6QX02`0J6QX00`00o`006QXJ01XJ6P3o01XJ6RH06QXJ00<007oo01XJ6P0J
6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<00?l001XJ6P0J
6QX0100J6QX00`3oO`006QXJ01XJ6P1V01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0J01XJ6P030?mo
000J6QX06QXJ00`06QXJ00<007oo01XJ6P0J6QX00P0J6QX00`3o0?l06QXJ01XJ6P0701XJ6P030=_K
f`0J6QX06QXJ00X06QXJ00<00?l001XJ6P0J6QX0o`0J6QXX01XJ6P03001oo`0J6QX06QXJ00H06QXJ
00<0fm_K01XJ6P0J6QX0100J6QX20?l0o`P06QXJ00<00?l001XJ6P0J6QX0100J6QX00`3oO`006QXJ
01XJ6P1U01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0I01XJ6P030?mo000J6QX06QXJ00d06QXJ00D0
07oo01XJ6P0J6QX06QXJ0?l0o`0901XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<00?l001XJ6P0J6QX0
o`0J6QXY01XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ
01XJ6P0601XJ6P03003o000J6QX06QXJ00<06QXJ00<0ogl001XJ6P0J6QX0I@0J6QX002@06QXJ00<0
fm_K01XJ6P0J6QX06@0J6QX00`3oO`006QXJ01XJ6P0<01XJ6P03001oo`0J6QX06QXJ00806QXJ00<0
o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0;01XJ6P03003o000J6QX06QXJ0?l06QXJ:`0J
6QX00`00Ool06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0o`3o01XJ6P0J6QX01P0J
6QX00`00o`006QXJ01XJ6P0301XJ6P030?mo000J6QX06QXJ06@06QXJ000T01XJ6P030=_Kf`0J6QX0
6QXJ01T06QXJ00<0ogl001XJ6P0J6QX0300J6QX01@00Ool06QXJ01XJ6P0J6QX0o`3o00T06QXJ00<0
fm_K01XJ6P0J6QX02P0J6QX00`00o`006QXJ01XJ6P3o01XJ6Rd06QXJ00<007oo01XJ6P0J6QX01P0J
6QX20=_Kf`H06QXJ00<0o`3o01XJ6P0J6QX01@0J6QX00`00o`006QXJ01XJ6P0401XJ6P030?mo000J
6QX06QXJ06<06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01T06QXJ00<0ogl001XJ6P0J6QX02`0J6QX0
1@00Ool06QXJ01XJ6P0J6QX0o`3o00T06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX00`00o`006QXJ01XJ
6P3o01XJ6Rl06QXJ00<007oo01XJ6P0J6QX01`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J
6QX06QXJ00D06QXJ00<00?l001XJ6P0J6QX0100J6QX00`3oO`006QXJ01XJ6P1R01XJ6P00900J6QX3
0=_KfaP06QXJ00<0ogl001XJ6P0J6QX02`0J6QX01@00Ool06QXJ01XJ6P0J6QX0o`3o00X06QXJ00<0
fm_K01XJ6P0J6QX02P0J6QX00`00o`006QXJ01XJ6P3o01XJ6S006QXJ00<007oo01XJ6P0J6QX01`0J
6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00D06QXJ00<00?l001XJ6P0J6QX00`0J
6QX00`3oO`006QXJ01XJ6P1R01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0H01XJ6P030?mo000J6QX0
6QXJ00/06QXJ00D007oo01XJ6P0J6QX06QXJ0?l0o`0901XJ6P030=_Kf`0J6QX06QXJ00X06QXJ00<0
0?l001XJ6P0J6QX0o`0J6QXb01XJ6P03001oo`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX00`3o0?l06QXJ01XJ6P0501XJ6P03003o000J6QX06QXJ00<06QXJ00<0ogl001XJ6P0J6QX0H@0J
6QX002@06QXJ00<0fm_K01XJ6P0J6QX0600J6QX00`3oO`006QXJ01XJ6P0:01XJ6P05001oo`0J6QX0
6QXJ01XJ6P3o0?l02P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P03003o000J6QX06QXJ0?l06QXJ=00J
6QX00`00Ool06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0o`3o01XJ6P0J6QX01@0J
6QX00`00o`006QXJ01XJ6P0301XJ6P030?mo000J6QX06QXJ06006QXJ000T01XJ6P030=_Kf`0J6QX0
6QXJ01L06QXJ00<0ogl001XJ6P0J6QX02`0J6QX01000Ool06QXJ01XJ6P3o0?l:01XJ6P030=_Kf`0J
6QX06QXJ00T06QXJ00<00?l001XJ6P0J6QX0o`0J6QXf01XJ6P03001oo`0J6QX06QXJ00L06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0501XJ6P03003o000J6QX06QXJ00<06QXJ00<0
ogl001XJ6P0J6QX0G`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX05`0J6QX00`3oO`006QXJ01XJ6P0:
01XJ6P05001oo`0J6QX06QXJ01XJ6P3o0?l02@0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P03003o000J
6QX06QXJ0?l06QXJ=`0J6QX00`00Ool06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0
o`3o01XJ6P0J6QX0100J6QX00`00o`006QXJ01XJ6P0301XJ6P030?mo000J6QX06QXJ05l06QXJ000T
01XJ6P030=_Kf`0J6QX06QXJ01L06QXJ00<0ogl001XJ6P0J6QX02P0J6QX01000Ool06QXJ01XJ6P3o
0?l:01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<00?l001XJ6P0J6QX0o`0J6QXi01XJ6P8007oo200J
6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX00`0J
6QX00`3oO`006QXJ01XJ6P1N01XJ6P00200J6QX20=_Kf`@06QXJ0P3Kfm/301XJ6PD0fm_K0P0J6QX2
0=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3oO`006QXJ01XJ6P0:01XJ6P04001oo`0J6QX0
6QXJ0?l0o`X06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX00`00o`006QXJ01XJ6P3o01XJ6S`06QXJ00<0
07oo01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00@06QXJ00<0
0?l001XJ6P0J6QX00`0J6QX00`3oO`006QXJ01XJ6P1M01XJ6P001`0J6QX0103Kfm/06QXJ01XJ6P3K
fm/:01XJ6P050=_Kf`0J6QX06QXJ01XJ6P3Kfm/00P0J6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030=_K
f`0J6QX06QXJ01H06QXJ00<0ogl001XJ6P0J6QX02P0J6QX01000Ool06QXJ01XJ6P3o0?l:01XJ6P03
0=_Kf`0J6QX06QXJ00P06QXJ00<00?l001XJ6P0J6QX0o`0J6QXn01XJ6P03001oo`0J6QX06QXJ00H0
6QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0401XJ6P03003o000J6QX06QXJ00<0
6QXJ00<0ogl001XJ6P0J6QX0G00J6QX000L06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/0
6QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00D06QXJ103Kfm/E01XJ6P030?mo000J6QX06QXJ00T0
6QXJ00@007oo01XJ6P0J6QX0o`3o2P0J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P03003o000J6QX06QXJ
0?l06QXJ?`0J6QX00`00Ool06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0o`3o01XJ
6P0J6QX0100J6QX00`00o`006QXJ01XJ6P0201XJ6P030?mo000J6QX06QXJ05`06QXJ00000`0J6QX0
fm_K0=_Kf`020=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ
6P80fm_K200J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030?mo000J6QX06QXJ00T06QXJ00@007oo01XJ
6P0J6QX0o`3o2P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ0?l06QXJ@@0J6QX0
0`00Ool06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<0o`3o01XJ6P0J6QX0100J6QX0
0`00o`006QXJ01XJ6P0201XJ6P030?mo000J6QX06QXJ05/06QXJ000701XJ6P040=_Kf`0J6QX06QXJ
0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P030=_Kf`0J6QX0
6QXJ01D06QXJ00<0ogl001XJ6P0J6QX02@0J6QX01000Ool06QXJ01XJ6P3o0?l:01XJ6P030=_Kf`0J
6QX06QXJ00P06QXJ00<00?l001XJ6P0J6QX0o`0J6QY301XJ6P03001oo`0J6QX06QXJ00H06QXJ00<0
fm_K01XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0301XJ6P03003o000J6QX06QXJ00<06QXJ00<0
ogl001XJ6P0J6QX0FP0J6QX000P06QXJ0P3Kfm/:01XJ6P80fm_K100J6QX30=_Kf`L06QXJ00<0fm_K
01XJ6P0J6QX05@0J6QX00`3oO`006QXJ01XJ6P0901XJ6P04001oo`0J6QX06QXJ0?l0o`T06QXJ00<0
fm_K01XJ6P0J6QX02@0J6QX00`00o`006QXJ01XJ6P3o01XJ6T@06QXJ00<007oo01XJ6P0J6QX01@0J
6QX00`3Kfm/06QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX00P0J
6QX00`3oO`006QXJ01XJ6P1J01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P030?mo000J6QX0
6QXJ00P06QXJ00@007oo01XJ6P0J6QX0o`3o2P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P03003o000J
6QX06QXJ0?l06QXJAP0J6QX00`00Ool06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0
o`3o01XJ6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P0201XJ6P030?mo000J6QX06QXJ05T06QXJ000T
01XJ6P030=_Kf`0J6QX06QXJ01@06QXJ00<0ogl001XJ6P0J6QX02@0J6QX00`00Ool06QXJ0?l0o`0:
01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<00?l001XJ6P0J6QX0o`0J6QY701XJ6P03001oo`0J6QX0
6QXJ00D06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`3o0?l06QXJ01XJ6P0301XJ6P03003o000J6QX0
6QXJ00806QXJ00<0ogl001XJ6P0J6QX0F00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0500J6QX00`3o
O`006QXJ01XJ6P0801XJ6P04001oo`0J6QX06QXJ0?l0o`X06QXJ00<0fm_K01XJ6P0J6QX0200J6QX0
0`00o`006QXJ01XJ6P3o01XJ6TT06QXJ00<007oo01XJ6P0J6QX01@0J6QX00`3Kfm/06QXJ01XJ6P05
01XJ6P030?l0o`0J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX00P0J6QX00`3oO`006QXJ01XJ6P1G
01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0D01XJ6P030?mo000J6QX06QXJ00P06QXJ00<007oo01XJ
6P3o0?l02P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ0?l06QXJB`0J6QX00`00
Ool06QXJ01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0o`3o01XJ6P0J6QX00`0J6QX01@00
o`006QXJ01XJ6P0J6QX0ogl005T06QXJ000T01XJ6P<0fm_K500J6QX00`3oO`006QXJ01XJ6P0701XJ
6P04001oo`0J6QX06QXJ0?l0o`X06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`00o`006QXJ01XJ6P3o
01XJ6T`06QXJ00<007oo01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030?l0o`0J6QX0
6QXJ00806QXJ00<00?l001XJ6P0J6QX00P0J6QX00`3oO`006QXJ01XJ6P1F01XJ6P00900J6QX00`3K
fm/06QXJ01XJ6P0C01XJ6P030?mo000J6QX06QXJ00P06QXJ00<007oo01XJ6P3o0?l02P0J6QX00`3K
fm/06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ0?l06QXJCP0J6QX00`00Ool06QXJ01XJ6P0401XJ
6P030=_Kf`0J6QX06QXJ00H06QXJ00<0o`3o01XJ6P0J6QX00P0J6QX00`00o`006QXJ01XJ6P0201XJ
6P030?mo000J6QX06QXJ05D06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01<06QXJ00<0ogl001XJ6P0J
6QX01`0J6QX00`00Ool06QXJ0?l0o`0:01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<00?l001XJ6P0J
6QX0o`0J6QY?01XJ6P03001oo`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX00`3o0?l0
6QXJ01XJ6P0201XJ6P05003o000J6QX06QXJ01XJ6P3oO`00E`0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX04`0J6QX00`3oO`006QXJ01XJ6P0701XJ6P03001oo`0J6QX0o`3o00X06QXJ00<0fm_K01XJ6P0J
6QX0200J6QX00`00o`006QXJ01XJ6P3o01XJ6U406QXJ00<007oo01XJ6P0J6QX0100J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P030?l0o`0J6QX06QXJ00806QXJ00D00?l001XJ6P0J6QX06QXJ0?mo001F01XJ
6P00900J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030?mo000J6QX06QXJ00L06QXJ00<007oo01XJ6P3o
0?l02P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ0?l06QXJD`0J6QX00`00Ool0
6QXJ01XJ6P0401XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00D0o`3o01XJ6P0J6QX06QXJ003o000401XJ
6P030?mo000J6QX06QXJ05<06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01806QXJ00<0ogl001XJ6P0J
6QX01`0J6QX00`00Ool06QXJ0?l0o`0:01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<00?l001XJ6P0J
6QX0o`0J6QYD01XJ6P03001oo`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX01@3o0?l0
6QXJ01XJ6P0J6QX00?l000<06QXJ00<0ogl001XJ6P0J6QX0D`0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX04P0J6QX00`3oO`006QXJ01XJ6P0701XJ6P03001oo`3o0?l06QXJ00T06QXJ00<0fm_K01XJ6P0J
6QX0200J6QX00`00o`006QXJ01XJ6P3o01XJ6UH06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/0
6QXJ01XJ6P0701XJ6P050?l0o`0J6QX06QXJ01XJ6P00o`000`0J6QX00`3oO`006QXJ01XJ6P1B01XJ
6P00900J6QX00`3Kfm/06QXJ01XJ6P0B01XJ6P030?mo000J6QX06QXJ00H06QXJ00<007oo01XJ6P3o
0?l02P0J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P03003o000J6QX06QXJ0?l06QXJE`0J6QX00`00Ool0
6QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00D0o`3o01XJ6P0J6QX06QXJ003o000301XJ
6P030?mo000J6QX06QXJ05406QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01406QXJ00<0ogl001XJ6P0J
6QX01`0J6QX00`00Ool0o`3o01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<00?l001XJ6P0J
6QX0o`0J6QYI01XJ6P03001oo`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX01@3o0?l0
6QXJ01XJ6P0J6QX00?l000806QXJ00<0ogl001XJ6P0J6QX0D@0J6QX002@06QXJ0`3Kfm/A01XJ6P03
0?mo000J6QX06QXJ00H06QXJ00<007oo01XJ6P3o0?l02P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P03
003o000J6QX06QXJ0?l06QXJF`0J6QX00`00Ool06QXJ01XJ6P0301XJ6P030=_Kf`0J6QX06QXJ00H0
6QXJ00D0o`3o01XJ6P0J6QX06QXJ003o000301XJ6P030?mo000J6QX06QXJ05006QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ01406QXJ00<0ogl001XJ6P0J6QX01P0J6QX00`00Ool0o`3o01XJ6P0901XJ6P03
0=_Kf`0J6QX06QXJ00P06QXJ00<00?l001XJ6P0J6QX0o`0J6QYL01XJ6P03001oo`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX01`0J6QX01@3o0?l06QXJ01XJ6P0J6QX00?l000<06QXJ00<0ogl001XJ
6P0J6QX0C`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX04@0J6QX00`3oO`006QXJ01XJ6P0601XJ6P03
001oo`3o0?l06QXJ00T06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`00o`006QXJ01XJ6P3o01XJ6Uh0
6QXJ00<007oo01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P050?l0o`0J6QX06QXJ01XJ
6P00o`000P0J6QX00`3oO`006QXJ01XJ6P1?01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0@01XJ6P03
0?mo000J6QX06QXJ00H06QXJ00<007oo0?l0o`0J6QX02@0J6QX00`3Kfm/06QXJ01XJ6P0701XJ6P03
003o000J6QX06QXJ0?l06QXJH00J6QX00`00Ool06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00L0
6QXJ00D0o`3o01XJ6P0J6QX06QXJ003o000201XJ6P030?mo000J6QX06QXJ04h06QXJ000T01XJ6P03
0=_Kf`0J6QX06QXJ01006QXJ00<0ogl001XJ6P0J6QX01P0J6QX00`00Ool0o`3o01XJ6P0901XJ6P03
0=_Kf`0J6QX06QXJ00L06QXJ00<00?l001XJ6P0J6QX0o`0J6QYQ01XJ6P03001oo`0J6QX06QXJ0080
6QXJ00<0fm_K01XJ6P0J6QX01`0J6QX0103o0?l06QXJ01XJ6P00o`0301XJ6P030?mo000J6QX06QXJ
04d06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01006QXJ00<0ogl001XJ6P0J6QX01P0J6QX00`3o0?l0
6QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<00?l001XJ6P0J6QX0o`0J6QYS01XJ6P03
001oo`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX01`0J6QX0103o0?l06QXJ01XJ6P00o`0301XJ
6P030?mo000J6QX06QXJ04`06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ01006QXJ00<0ogl001XJ6P0J
6QX01@0J6QX00`00Ool0o`3o01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<00?l001XJ6P0J
6QX0o`0J6QYT01XJ6P05001oo`0J6QX06QXJ01XJ6P3Kfm/02@0J6QX01@3o0?l06QXJ01XJ6P0J6QX0
0?l000806QXJ00<0ogl001XJ6P0J6QX0C00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX03`0J6QX00`3o
O`006QXJ01XJ6P0601XJ6P03001oo`3o0?l06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`00
o`006QXJ01XJ6P3o01XJ6VH06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0901XJ6P050?l0o`0J6QX0
6QXJ01XJ6P00o`000P0J6QX00`3oO`006QXJ01XJ6P1;01XJ6P00900J6QX30=_Kf`l06QXJ00<0ogl0
01XJ6P0J6QX01@0J6QX00`00Ool0o`3o01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<00?l0
01XJ6P0J6QX0o`0J6QYX01XJ6P05001oo`0J6QX06QXJ01XJ6P3Kfm/02@0J6QX01@3o0?l06QXJ01XJ
6P0J6QX00?l000806QXJ00<0ogl001XJ6P0J6QX0BP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX03`0J
6QX00`3oO`006QXJ01XJ6P0501XJ6P03001oo`3o0?l06QXJ00T06QXJ00<0fm_K01XJ6P0J6QX01P0J
6QX00`00o`006QXJ01XJ6P3o01XJ6VT06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0901XJ6P040?l0
o`0J6QX06QXJ003o00806QXJ00<0ogl001XJ6P0J6QX0BP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
3`0J6QX00`3oO`006QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0
1P0J6QX00`00o`006QXJ01XJ6P3o01XJ6V/06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0901XJ6P04
0?l0o`0J6QX06QXJ003o00806QXJ00<0ogl001XJ6P0J6QX0B@0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX03P0J6QX00`3oO`006QXJ01XJ6P0501XJ6P03001oo`3o0?l06QXJ00T06QXJ00<0fm_K01XJ6P0J
6QX01P0J6QX00`00o`006QXJ01XJ6P3o01XJ6V`06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0901XJ
6P040?l0o`0J6QX06QXJ003o00806QXJ00<0ogl001XJ6P0J6QX0B00J6QX002@06QXJ00<0fm_K01XJ
6P0J6QX03P0J6QX00`3oO`006QXJ01XJ6P0501XJ6P030?l0o`0J6QX06QXJ00P06QXJ00<0fm_K01XJ
6P0J6QX01P0J6QX00`00o`006QXJ01XJ6P3o01XJ6Vh06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`08
01XJ6P070?l0o`0J6QX06QXJ01XJ6P00o`006QXJ0?mo001:01XJ6P00900J6QX00`3Kfm/06QXJ01XJ
6P0>01XJ6P030?mo000J6QX06QXJ00D06QXJ00<0o`3o01XJ6P0J6QX0200J6QX00`3Kfm/06QXJ01XJ
6P0501XJ6P03003o000J6QX06QXJ0?l06QXJL00J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00P06QXJ
00@0o`3o01XJ6P0J6QX00?l00P0J6QX00`3oO`006QXJ01XJ6P1701XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P0>01XJ6P030?mo000J6QX06QXJ00@06QXJ00<007oo0?l0o`0J6QX0200J6QX00`3Kfm/06QXJ
01XJ6P0601XJ6P03003o000J6QX06QXJ0?l06QXJL@0J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00P0
6QXJ00@0o`3o01XJ6P0J6QX00?l00P0J6QX00`3oO`006QXJ01XJ6P1601XJ6P00900J6QX00`3Kfm/0
6QXJ01XJ6P0>01XJ6P030?mo000J6QX06QXJ00@06QXJ00<0o`3o01XJ6P0J6QX0200J6QX00`3Kfm/0
6QXJ01XJ6P0501XJ6P03003o000J6QX06QXJ0?l06QXJL`0J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K
00P06QXJ00H0o`3o01XJ6P0J6QX00?l001XJ6P3oO`1801XJ6P00900J6QX30=_Kf`d06QXJ00<0ogl0
01XJ6P0J6QX0100J6QX00`00Ool0o`3o01XJ6P0901XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<00?l0
01XJ6P0J6QX0o`0J6QYc01XJ6P03001oo`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX01P0J6QX0
1P3o0?l06QXJ01XJ6P00o`006QXJ0?mo04L06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00d06QXJ00<0
ogl001XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00<0
0?l001XJ6P0J6QX0o`0J6QYe01XJ6P03001oo`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX01P0J
6QX00`3o0?l06QXJ003o000201XJ6P030?mo000J6QX06QXJ04@06QXJ000T01XJ6P030=_Kf`0J6QX0
6QXJ00d06QXJ00<0ogl001XJ6P0J6QX0100J6QX00`3o0?l06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX0
6QXJ00@06QXJ00<00?l001XJ6P0J6QX0o`0J6QYg01XJ6P03001oo`0J6QX06QXJ00806QXJ0P3Kfm/6
01XJ6P060?l0o`0J6QX06QXJ003o000J6QX0ogl0AP0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX03@0J
6QX00`3oO`006QXJ01XJ6P0301XJ6P03001oo`3o0?l06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX01@0J
6QX00`00o`006QXJ01XJ6P3o01XJ6WP06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ
6P0401XJ6P060?l0o`0J6QX06QXJ003o000J6QX0ogl0A@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
300J6QX00`3oO`006QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00P06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`00o`006QXJ01XJ6P3o01XJ6WX06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ
01XJ6P0401XJ6P060?l0o`0J6QX06QXJ003o000J6QX0ogl0A00J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0300J6QX00`3oO`006QXJ01XJ6P0401XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J
6QX01@0J6QX00`00o`006QXJ01XJ6P3o01XJ6W/06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/0
6QXJ01XJ6P0401XJ6P030?l0o`0J6QX00?l000806QXJ00<0ogl001XJ6P0J6QX0@@0J6QX002@06QXJ
00<0fm_K01XJ6P0J6QX0300J6QX00`3oO`006QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00P06QXJ
00<0fm_K01XJ6P0J6QX0100J6QX00`00o`006QXJ01XJ6P3o01XJ6Wd06QXJ00<007oo01XJ6P0J6QX0
0`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P050?l0o`0J6QX00?l001XJ6P3oO`00@`0J6QX000h06QXJ
0P3Kfm/401XJ6P80fm_K0`0J6QX50=_Kf`H06QXJ00<0fm_K01XJ6P0J6QX0300J6QX00`3oO`006QXJ
01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX00`00o`006QXJ
01XJ6P3o01XJ6Wh06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0401XJ6P050?l0
o`0J6QX00?l001XJ6P3oO`00@P0J6QX000d06QXJ00@0fm_K01XJ6P0J6QX0fm_K2P0J6QX00`3Kfm/0
6QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0ogl001XJ6P0J6QX00`0J6QX00`3o0?l0
6QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX0o`0J6QZ001XJ6P03
001oo`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX01P3o0?l06QXJ01XJ6P00o`006QXJ
0?mo04406QXJ000=01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`X06QXJ00<0fm_K01XJ6P0J6QX01P0J6QX4
0=_Kf`X06QXJ00<0ogl001XJ6P0J6QX00`0J6QX00`3o0?l06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX0
6QXJ00@06QXJ00<00?l001XJ6P0J6QX0o`0J6QZ101XJ6P03001oo`0J6QX06QXJ00<06QXJ00<0fm_K
01XJ6P0J6QX00`0J6QX01@3o0?l06QXJ003o000J6QX0ogl004406QXJ000701XJ6P@0fm_K0P0J6QX0
103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX02`0J
6QX00`3oO`006QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX00`00o`006QXJ01XJ6P3o01XJ6X<06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ
6P0301XJ6P050?l0o`0J6QX00?l001XJ6P3oO`00@00J6QX000d06QXJ00@0fm_K01XJ6P0J6QX0fm_K
2P0J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00/06QXJ00<0ogl001XJ6P0J6QX0
0P0J6QX00`3o0?l06QXJ01XJ6P0801XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX0
o`0J6QZ301XJ6P03001oo`0J6QX06QXJ00@06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX01@3o0?l06QXJ
003o000J6QX0ogl003l06QXJ000>01XJ6P80fm_K2P0J6QX20=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX0
2P0J6QX00`3oO`006QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`00o`006QXJ01XJ6P3o01XJ6XD06QXJ00<007oo01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P050?l0o`0J6QX00?l001XJ6P3oO`00?`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
2P0J6QX00`3oO`006QXJ01XJ6P0301XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`00o`006QXJ01XJ6P3o01XJ6XH06QXJ00<007oo01XJ6P0J6QX0100J6QX00`3Kfm/06QXJ
01XJ6P0201XJ6P050?l0o`0J6QX00?l001XJ6P3oO`00?P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
2P0J6QX00`3oO`006QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`00o`006QXJ01XJ6P3o01XJ6XP06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P050?l0o`0J6QX00?l001XJ6P3oO`00?@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
2P0J6QX00`3oO`006QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`00o`006QXJ01XJ6P3o01XJ6XT06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P040?l0o`0J6QX00?l00?mo03d06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ
00<0ogl001XJ6P0J6QX00P0J6QX00`3o0?l06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ
00<00?l001XJ6P0J6QX0o`0J6QZ;01XJ6P03001oo`0J6QX06QXJ00<06QXJ00<0fm_K01XJ6P0J6QX0
0P0J6QX01@3o0?l06QXJ003o000J6QX0ogl003`06QXJ000T01XJ6P<0fm_K2@0J6QX00`3oO`006QXJ
01XJ6P0201XJ6P030?l0o`00Ool06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`00o`006QXJ
01XJ6P3o01XJ6X`06QXJ00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050?l0
o`0J6QX00?l001XJ6P3oO`00>`0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX02@0J6QX00`3oO`006QXJ
01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00L06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`00o`006QXJ
01XJ6P3o01XJ6Xh06QXJ00<007oo01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040?l0
o`0J6QX00?l00?mo03/06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00T06QXJ00<0ogl001XJ6P0J6QX0
0P0J6QX00`3o0?l06QXJ01XJ6P0601XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX0
o`0J6QZ?01XJ6P03001oo`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103o0?l00?l0
01XJ6P3oO`0j01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0901XJ6P030?mo000J6QX06QXJ00806QXJ
00<0o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P03003o000J6QX06QXJ0?l06QXJ
T@0J6QX00`00Ool06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00@0o`3o003o000J6QX0
ogl0>@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3oO`006QXJ01XJ6P0201XJ6P030?l0
o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX0100J6QX00`00o`006QXJ01XJ6P3o01XJ6Y406QXJ
00<007oo01XJ6P0J6QX00`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P050?l0o`0J6QX00?l001XJ6P3o
O`00>00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0200J6QX00`3oO`006QXJ01XJ6P0201XJ6P030?l0
o`0J6QX06QXJ00H06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P3o01XJ6Y<06QXJ
00<007oo01XJ6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P040?l0o`0J6QX00?l00?mo03P0
6QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00P06QXJ00<0ogl001XJ6P0J6QX00P0J6QX00`3o0?l06QXJ
01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00<00?l001XJ6P0J6QX0o`0J6QZD01XJ6P03001o
o`0J6QX06QXJ00806QXJ00<0fm_K01XJ6P0J6QX00`0J6QX0103o0?l00?l001XJ6P3oO`0g01XJ6P00
900J6QX00`3Kfm/06QXJ01XJ6P0801XJ6P050?mo000J6QX06QXJ01XJ6P3o0?l0200J6QX00`3Kfm/0
6QXJ01XJ6P0301XJ6P03003o000J6QX06QXJ0?l06QXJUP0J6QX00`00Ool06QXJ01XJ6P0201XJ6P03
0=_Kf`0J6QX06QXJ00<06QXJ00@0o`3o003o000J6QX0ogl0=P0J6QX002@06QXJ0`3Kfm/701XJ6P03
0?mo000J6QX06QXJ00806QXJ00<0o`3o01XJ6P0J6QX01P0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P03
003o000J6QX06QXJ0?l06QXJU`0J6QX00`00Ool06QXJ01XJ6P0201XJ6P030=_Kf`0J6QX06QXJ0080
6QXJ00@0o`3o01XJ6P00o`00ogl0=P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX00`3oO`00
6QXJ01XJ6P0201XJ6P030?l0o`0J6QX06QXJ00D06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`00o`00
6QXJ01XJ6P3o01XJ6YT06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0501XJ6P040?l0o`0J6QX00?l0
0?mo03D06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00H0ogl001XJ6P0J6QX06QXJ0?l0o`00
Ool701XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX0o`0J6QZJ01XJ6P05001oo`0J
6QX06QXJ01XJ6P3Kfm/01@0J6QX0103o0?l00?l001XJ6P3oO`0d01XJ6P00900J6QX00`3Kfm/06QXJ
01XJ6P0701XJ6P050?mo000J6QX06QXJ01XJ6P3o0?l01`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P03
003o000J6QX06QXJ0?l06QXJW00J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00D06QXJ00<0o`3o003o
003oO`00=00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX01`0J6QX01@3oO`006QXJ01XJ6P0J6QX0o`3o
00L06QXJ00<0fm_K01XJ6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P3o01XJ6Y`06QXJ00<007oo01XJ
6P0J6QX00P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P040?l0o`0J6QX00?l00?mo03<06QXJ000T01XJ
6P030=_Kf`0J6QX06QXJ00H06QXJ00H0ogl001XJ6P0J6QX06QXJ0?l0o`00Ool601XJ6P030=_Kf`0J
6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX0o`0J6QZN01XJ6P05001oo`0J6QX06QXJ01XJ6P3Kfm/0
1@0J6QX0103o0?l00?l001XJ6P3oO`0b01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0601XJ6P050?mo
000J6QX06QXJ01XJ6P3o0?l01`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P03003o000J6QX06QXJ0?l0
6QXJW`0J6QX01@00Ool06QXJ01XJ6P0J6QX0fm_K00D06QXJ00<0o`3o003o003oO`00<P0J6QX002@0
6QXJ00<0fm_K01XJ6P0J6QX01P0J6QX01@3oO`006QXJ01XJ6P0J6QX0o`3o00H06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX00`00o`006QXJ01XJ6P3o01XJ6Z406QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`05
01XJ6P030?l0o`00o`00ogl003406QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00D0ogl001XJ
6P0J6QX0o`3o001oo`0601XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00<00?l001XJ6P0J6QX0o`0J6QZR
01XJ6P05001oo`0J6QX06QXJ01XJ6P3Kfm/0100J6QX00`3o0?l00?l00?mo000a01XJ6P00900J6QX3
0=_Kf`H06QXJ00@0ogl001XJ6P0J6QX0o`3o1`0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P03003o000J
6QX06QXJ0?l06QXJY00J6QX01000Ool06QXJ01XJ6P3Kfm/501XJ6P030?l0o`00o`00ogl003006QXJ
000T01XJ6P030=_Kf`0J6QX06QXJ00H06QXJ00@0ogl001XJ6P0J6QX0o`3o1P0J6QX00`3Kfm/06QXJ
01XJ6P0301XJ6P03003o000J6QX06QXJ0?l06QXJY@0J6QX01000Ool06QXJ01XJ6P3Kfm/501XJ6P03
0?l0o`00o`00ogl002l06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00D0ogl001XJ6P0J6QX0
6QXJ0?l0o`0601XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<00?l001XJ6P0J6QX0o`0J6QZW01XJ6P04
001oo`0J6QX06QXJ0=_Kf`@06QXJ00<0o`3o003o003oO`00;`0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX01@0J6QX01@3oO`006QXJ01XJ6P3o0?l007oo00H06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`00
o`006QXJ01XJ6P3o01XJ6ZL06QXJ00D007oo01XJ6P0J6QX06QXJ0=_Kf`0401XJ6P030?l0o`00o`00
ogl002h06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00@0ogl001XJ6P0J6QX0o`3o1P0J6QX0
0`3Kfm/06QXJ01XJ6P0201XJ6P03003o000J6QX06QXJ0?l06QXJZ@0J6QX01000Ool06QXJ01XJ6P3K
fm/501XJ6P030?l0o`00o`00ogl002d06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00D06QXJ00@0ogl0
01XJ6P0J6QX0o`3o1P0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P03003o000J6QX06QXJ0?l06QXJZP0J
6QX01000Ool06QXJ01XJ6P3Kfm/501XJ6P030?l0o`3oO`006QXJ02`06QXJ000T01XJ6P030=_Kf`0J
6QX06QXJ00D06QXJ00@0ogl001XJ6P3o0?l007oo1@0J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P03003o
000J6QX06QXJ0?l06QXJ[00J6QX01000Ool06QXJ01XJ6P3Kfm/401XJ6P030?l0o`00o`00ogl002`0
6QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00@06QXJ00@0ogl001XJ6P0J6QX0o`3o1P0J6QX00`3Kfm/0
6QXJ01XJ6P0201XJ6P03003o000J6QX06QXJ0?l06QXJ[@0J6QX01000Ool06QXJ01XJ6P3Kfm/401XJ
6P030?l0o`00o`00ogl002/06QXJ000T01XJ6P<0fm_K100J6QX0103oO`006QXJ01XJ6P3o0?l601XJ
6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZa01XJ6P04001oo`0J6QX06QXJ0=_Kf`@06QXJ00<0
o`3o0?mo000J6QX0:P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX0103oO`006QXJ01XJ6P3o
0?l501XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<00?l001XJ6P0J6QX0o`0J6QZ`01XJ6P03001oo`0J
6QX0fm_K00@06QXJ00<0o`3o003o003oO`00:P0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0100J6QX0
103oO`006QXJ0?l0o`00Ool501XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZd01XJ6P03001o
o`0J6QX0fm_K00@06QXJ00<0o`3o003o000J6QX0:@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0100J
6QX00`3oO`006QXJ0?l0o`0601XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZd01XJ6P04001o
o`0J6QX06QXJ0=_Kf`@06QXJ00<0o`3o0?mo000J6QX0:00J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0
100J6QX00`3oO`006QXJ0?l0o`0501XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZf01XJ6P04
001oo`0J6QX06QXJ0=_Kf`<06QXJ00<0o`3o003o003oO`00:00J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX00`0J6QX0103oO`006QXJ01XJ6P3o0?l501XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZg
01XJ6P03001oo`0J6QX0fm_K00@06QXJ00<0o`3o003o000J6QX09`0J6QX000P06QXJ0P3Kfm/401XJ
6P80fm_K100J6QX20=_Kf`@06QXJ0P3Kfm/801XJ6P030=_Kf`0J6QX06QXJ00<06QXJ00@0ogl001XJ
6P3o0?l007oo1@0J6QX0103Kfm/06QXJ01XJ6P00o`3o01XJ6[T06QXJ00<007oo01XJ6P3Kfm/0100J
6QX00`3o0?l0ogl001XJ6P0V01XJ6P001`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ6P040=_Kf`0J
6QX06QXJ0=_Kf`806QXJ00@0fm_K01XJ6P0J6QX0fm_K1`0J6QX00`3Kfm/06QXJ01XJ6P0301XJ6P03
0?mo000J6QX0o`3o00D06QXJ00D0fm_K01XJ6P0J6QX06QXJ003o003o01XJ6[X06QXJ00<007oo01XJ
6P3Kfm/0100J6QX00`3o0?l0ogl001XJ6P0U01XJ6P001`0J6QX0103Kfm/06QXJ01XJ6P3Kfm/801XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`D06QXJ00<0fm_K01XJ6P0J6QX01@0J6QX40=_Kf`806QXJ00<0ogl0
01XJ6P3o0?l01@0J6QX0103Kfm/06QXJ01XJ6P00o`3o01XJ6[`06QXJ00<007oo01XJ6P3Kfm/00`0J
6QX00`3o0?l00?l001XJ6P0U01XJ6P0000<06QXJ0=_Kf`3Kfm/00P3Kfm/201XJ6P040=_Kf`0J6QX0
6QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K0`0J6QX20=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX0
0`0J6QX00`3oO`006QXJ0?l0o`0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZl01XJ6P03
001oo`0J6QX0fm_K00@06QXJ00<0o`3o0?mo000J6QX0900J6QX000L06QXJ00@0fm_K01XJ6P0J6QX0
fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm/301XJ6P030=_Kf`0J6QX06QXJ00L06QXJ00<0fm_K01XJ
6P0J6QX00`0J6QX00`3oO`00o`3o001oo`0401XJ6P050=_Kf`0J6QX06QXJ01XJ6P00o`00o`0J6QZm
01XJ6P03001oo`0J6QX0fm_K00@06QXJ00<0o`3o0?mo000J6QX08`0J6QX000P06QXJ0P3Kfm/:01XJ
6P80fm_K100J6QX30=_Kf`L06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3oO`006QXJ0?l0o`0501XJ
6P040=_Kf`0J6QX06QXJ003o0?l06QXJ_`0J6QX00`00Ool06QXJ0=_Kf`0301XJ6P030?l0o`00o`00
6QXJ02<06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0ogl001XJ6P3o0?l0100J6QX01@3K
fm/06QXJ01XJ6P0J6QX00?l00?l06QXJ`00J6QX00`00Ool06QXJ0=_Kf`0301XJ6P030?l0o`3oO`00
6QXJ02806QXJ000T01XJ6P030=_Kf`0J6QX06QXJ00806QXJ00<0ogl001XJ6P3o0?l0100J6QX0103K
fm/06QXJ01XJ6P00o`3o01XJ6/806QXJ00<007oo0=_Kf`0J6QX00`0J6QX00`3o0?l06QXJ01XJ6P0Q
01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0201XJ6P030?mo003o0?l007oo00@06QXJ00@0fm_K01XJ
6P0J6QX00?l0o`0J6Q[301XJ6P03001oo`3Kfm/06QXJ00806QXJ00<0o`3o003o000J6QX08@0J6QX0
02@06QXJ00<0fm_K01XJ6P0J6QX00P0J6QX00`3oO`00o`3o001oo`0301XJ6P050=_Kf`0J6QX06QXJ
01XJ6P00o`00o`0J6Q[301XJ6P03001oo`0J6QX0fm_K00<06QXJ00<0o`3o0?mo000J6QX0800J6QX0
02@06QXJ0`3Kfm/0100J6QX0ogl001XJ6P3o0?l401XJ6P040=_Kf`0J6QX06QXJ003o0?l06QXJa@0J
6QX00`00Ool06QXJ0=_Kf`0301XJ6P030?l0o`0J6QX06QXJ01l06QXJ000T01XJ6P070=_Kf`0J6QX0
6QXJ01XJ6P3oO`006QXJ0?l0o`0401XJ6P040=_Kf`0J6QX06QXJ003o0?l06QXJaP0J6QX00`00Ool0
fm_K01XJ6P0301XJ6P030?l0o`0J6QX06QXJ01h06QXJ000T01XJ6P070=_Kf`0J6QX06QXJ01XJ6P3o
O`00o`3o001oo`0301XJ6P040=_Kf`0J6QX06QXJ003o0?l06QXJb00J6QX00`00Ool0fm_K01XJ6P02
01XJ6P030?l0o`3oO`006QXJ01h06QXJ000T01XJ6P070=_Kf`0J6QX06QXJ01XJ6P3oO`00o`3o001o
o`0301XJ6P040=_Kf`0J6QX06QXJ003o0?l06QXJb@0J6QX00`00Ool0fm_K01XJ6P0201XJ6P030?l0
o`0J6QX06QXJ01d06QXJ000T01XJ6P060=_Kf`0J6QX06QXJ01XJ6P3oO`00o`3o0`0J6QX0103Kfm/0
6QXJ01XJ6P00o`3o01XJ6//06QXJ00H007oo0=_Kf`0J6QX06QXJ003o003o0?lN01XJ6P00900J6QX0
1P3Kfm/06QXJ01XJ6P3oO`006QXJ0?l0o`<06QXJ00@0fm_K01XJ6P0J6QX00?l0o`0J6Q[;01XJ6P03
001oo`3Kfm/06QXJ00806QXJ00<0o`3o01XJ6P0J6QX0700J6QX002@06QXJ00H0fm_K01XJ6P0J6QX0
ogl00?l0o`00Ool301XJ6P040=_Kf`0J6QX06QXJ003o0?l06QXJc00J6QX00`00Ool0fm_K01XJ6P02
01XJ6P030?l0o`0J6QX06QXJ01/06QXJ000T01XJ6P060=_Kf`0J6QX06QXJ0?mo003o0?l007oo0P0J
6QX0103Kfm/06QXJ01XJ6P00o`3o01XJ6/h06QXJ00H007oo0=_Kf`0J6QX06QXJ0?l0o`3oO`0L01XJ
6P00900J6QX01@3Kfm/06QXJ01XJ6P3oO`00o`3o00<06QXJ00@0fm_K01XJ6P0J6QX00?l0o`0J6Q[?
01XJ6P05001oo`3Kfm/06QXJ01XJ6P3o0?l0700J6QX002@06QXJ0`3Kfm/00`3oO`00o`3o01XJ6P02
01XJ6P030=_Kf`0J6QX00?l00?l06QXJd@0J6QX01@00Ool06QXJ01XJ6P0J6QX0o`3o01/06QXJ000T
01XJ6P050=_Kf`0J6QX0ogl00?l0o`00Ool00P0J6QX0103Kfm/06QXJ01XJ6P00o`3o01XJ6]806QXJ
00@007oo01XJ6P0J6QX0o`3o6`0J6QX002@06QXJ00D0fm_K01XJ6P3oO`00o`3o001oo`0201XJ6P04
0=_Kf`0J6QX06QXJ003o0?l06QXJdP0J6QX01@00Ool0fm_K01XJ6P0J6QX0o`3o01X06QXJ000T01XJ
6P040=_Kf`0J6QX0ogl00?l0o`<06QXJ00<0fm_K01XJ6P00o`00o`0J6Q[D01XJ6P05001oo`3Kfm/0
6QXJ003o003o0?l06@0J6QX002@06QXJ00@0fm_K01XJ6P3oO`00o`3o0P0J6QX0103Kfm/06QXJ01XJ
6P00o`3o01XJ6]D06QXJ00@007oo01XJ6P0J6QX0o`3o6@0J6QX002@06QXJ00@0fm_K01XJ6P3o0?l0
07oo0P0J6QX00`3Kfm/06QXJ003o003o01XJ6]L06QXJ00@007oo01XJ6P0J6QX0o`3o600J6QX002@0
6QXJ00H0fm_K01XJ6P3o0?l007oo01XJ6P3Kfm/201XJ6P03003o000J6QX06QXJ0?l06QXJe@0J6QX0
1000Ool0fm_K01XJ6P3o0?lH01XJ6P00900J6QX00`3Kfm/06QXJ0?l0o`0201XJ6P030=_Kf`0J6QX0
0?l00?l06QXJf@0J6QX01000Ool0fm_K01XJ6P3o0?lG01XJ6P00900J6QX20=_Kf`060?l0o`0J6QX0
6QXJ0=_Kf`0J6QX00?l0o`0J6Q[J01XJ6P04001oo`0J6QX00?l00?l0oaH06QXJ000T01XJ6P050=_K
f`3oO`00o`3o01XJ6P3Kfm/00P0J6QX00`00o`006QXJ01XJ6P3o01XJ6]T06QXJ00<007oo01XJ6P3o
0?l05P0J6QX002@06QXJ00L0fm_K0?mo003o0?l06QXJ0=_Kf`0J6QX00?l005D06QXJ0P3Kfm/401XJ
6P80fm_K0`0J6QX40=_Kfe<06QXJ0P3Kfm/401XJ6P80fm_K1@0J6QX30=_Kfe<06QXJ0P3Kfm/401XJ
6P80fm_K0`0J6QX30=_KfeD06QXJ0P3Kfm/401XJ6P80fm_K100J6QX20=_Kfe006QXJ00@007oo0=_K
f`0J6QX0o`3o1P0J6QX50=_Kf`X06QXJ000T01XJ6P070=_Kf`3o0?l007oo01XJ6P3Kfm/06QXJ003o
001D01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00<0fm_K01XJ6P0J6QX0D`0J6QX0103Kfm/06QXJ
01XJ6P3Kfm/;01XJ6P030=_Kf`0J6QX06QXJ05406QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103K
fm/06QXJ01XJ6P3Kfm]C01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J6QX0fm_K
D00J6QX01000Ool0fm_K0?l0o`3oO`0701XJ6P030=_Kf`0J6QX06QXJ00X06QXJ000T01XJ6P060=_K
f`3o0?l007oo0=_Kf`0J6QX00?l0E@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX0
6QXJ05806QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX50=_Kfe806QXJ00@0fm_K01XJ6P0J6QX0fm_K
200J6QX0103Kfm/06QXJ01XJ6P3Kfm]C01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ
6P0J6QX0fm_KD@0J6QX00`00Ool06QXJ0?l0o`0701XJ6P030=_Kf`0J6QX06QXJ00X06QXJ000T01XJ
6P060=_Kf`3o0?l06QXJ0=_Kf`0J6QX00?l0E@0J6QX0103Kfm/06QXJ01XJ6P3Kfm/:01XJ6P030=_K
f`0J6QX06QXJ05406QXJ00@0fm_K01XJ6P0J6QX0fm_K200J6QX0103Kfm/06QXJ01XJ6P3Kfm]C01XJ
6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ0`3Kfm]D01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`T06QXJ0P3K
fm]C01XJ6P03001oo`0J6QX0o`3o00H06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX002@06QXJ00H0fm_K
0?l0o`0J6QX0fm_K01XJ6P00o`1E01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ00@0fm_K01XJ6P0J
6QX0fm_KDP0J6QX0103Kfm/06QXJ01XJ6P3Kfm/901XJ6P030=_Kf`0J6QX0fm_K05<06QXJ00@0fm_K
01XJ6P0J6QX0fm_K2@0J6QX00`3Kfm/06QXJ01XJ6P1C01XJ6P040=_Kf`0J6QX06QXJ0=_Kf`P06QXJ
00@0fm_K01XJ6P0J6QX0fm_KD`0J6QX00`00Ool0o`3o01XJ6P0501XJ6P030=_Kf`0J6QX06QXJ00X0
6QXJ000T01XJ6P050=_Kf`3o0?l0fm_K01XJ6P00o`00E`0J6QX20=_Kf`X06QXJ0P3Kfm]D01XJ6P80
fm_K2`0J6QX20=_Kfe@06QXJ0P3Kfm/:01XJ6P<0fm_KE00J6QX20=_Kf`X06QXJ0P3Kfm]D01XJ6P03
001oo`3Kfm/0o`3o00@06QXJ0P3Kfm/<01XJ6P00900J6QX01@3Kfm/0o`3o0=_Kf`0J6QX00?l00?l0
6QXJh`0J6QX00`00Ool0o`3o0?mo000A01XJ6P00900J6QX0103Kfm/0o`3o01XJ6P00o`3o01XJ6^D0
6QXJ00<007oo0?l0o`0J6QX0400J6QX002@06QXJ00@0fm_K0?l0o`0J6QX00?l0o`0J6Q[V01XJ6P03
001oo`3o0?l06QXJ00l06QXJ000T01XJ6P030=_Kf`3o0?l00?l00?l06QXJi`0J6QX00`00Ool0o`3o
01XJ6P0?01XJ6P00900J6QX00`3o0?l007oo003o003o01XJ6^P06QXJ00<007oo0?l0o`0J6QX03P0J
6QX002@06QXJ00<0o`3o01XJ6P00o`00o`0J6Q[Y01XJ6P03001oo`3o0?l06QXJ00d06QXJ000T01XJ
6P030?l0o`00o`006QXJ0?l06QXJjP0J6QX00`3o0?l06QXJ01XJ6P0<01XJ6P00900J6QX00`3o0?l0
0?l001XJ6P3o01XJ6^X06QXJ00<007oo0?l0o`0J6QX0300J6QX002@06QXJ00<0o`3o01XJ6P0J6QX0
o`0J6Q[[01XJ6P030?l0o`00Ool06QXJ00/06QXJ000H01XJ6P`0fm_K00<0o`3o0=_Kf`3Kfm/0o`3K
fm_/0=_Kf`030?l0o`3Kfm/0fm_K00X0fm_K000T01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0E01XJ6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K
01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0:01XJ6P00900J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01D06QXJ00<0fm_K01XJ6P0J6QX05P0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ6P0J6QX05@0J6QX00`3Kfm/06QXJ01XJ6P0F01XJ
6P030=_Kf`0J6QX06QXJ01H06QXJ00<0fm_K01XJ6P0J6QX02P0J6QX002@06QXJ00<0fm_K01XJ6P0J
6QX0H00J6QX00`3Kfm/06QXJ01XJ6P1O01XJ6P030=_Kf`0J6QX06QXJ06006QXJ00<0fm_K01XJ6P0J
6QX0H00J6QX00`3Kfm/06QXJ01XJ6P1P01XJ6P030=_Kf`0J6QX06QXJ00X06QXJ000T01XJ6P030=_K
f`0J6QX06QXJ0?l06QXJn@0J6QX002@06QXJ00<0fm_K01XJ6P0J6QX0o`0J6Q[i01XJ6P00900J6QX0
0`3Kfm/06QXJ01XJ6P3o01XJ6_T06QXJ000T01XJ6P030=_Kf`0J6QX06QXJ0?l06QXJn@0J6QX00?l0
6QXJo`0J6QXQ01XJ6P00o`0J6Q[o01XJ6R406QXJ003o01XJ6_l06QXJ8@0J6QX00?l06QXJo`0J6QXQ
01XJ6P00o`0J6Q[o01XJ6R406QXJ003o01XJ6_l06QXJ8@0J6QX00?l06QXJo`0J6QXQ01XJ6P00\
\>"],
  ImageRangeCache->{{{65.8125, 499.563}, {428.563, 160.813}} -> {-0.240677, \
-0.143317, 0.00202686, 0.00120647}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphicsArray[{\[IndentingNewLine]{QuantilePlot[Kn, Ki], 
              QuantilePlot[Kn, Kg]}, \[IndentingNewLine]{QuantilePlot[Kn, 
                Kc], QuantilePlot[Kn, Kf]}}] // fShow;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0198632 0.956327 0.0147151 0.588604 [
[.21113 .00222 -9 -9 ]
[.21113 .00222 9 0 ]
[.40239 .00222 -9 -9 ]
[.40239 .00222 9 0 ]
[.59366 .00222 -9 -9 ]
[.59366 .00222 9 0 ]
[.78493 .00222 -9 -9 ]
[.78493 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.00736 .13244 -18 -4.5 ]
[.00736 .13244 0 4.5 ]
[.00736 .25016 -18 -4.5 ]
[.00736 .25016 0 4.5 ]
[.00736 .36788 -18 -4.5 ]
[.00736 .36788 0 4.5 ]
[.00736 .4856 -18 -4.5 ]
[.00736 .4856 0 4.5 ]
[.00736 .60332 -6 -4.5 ]
[.00736 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21113 .01472 m
.21113 .02097 L
s
[(0.2)] .21113 .00222 0 1 Mshowa
.40239 .01472 m
.40239 .02097 L
s
[(0.4)] .40239 .00222 0 1 Mshowa
.59366 .01472 m
.59366 .02097 L
s
[(0.6)] .59366 .00222 0 1 Mshowa
.78493 .01472 m
.78493 .02097 L
s
[(0.8)] .78493 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.06768 .01472 m
.06768 .01847 L
s
.1155 .01472 m
.1155 .01847 L
s
.16331 .01472 m
.16331 .01847 L
s
.25895 .01472 m
.25895 .01847 L
s
.30676 .01472 m
.30676 .01847 L
s
.35458 .01472 m
.35458 .01847 L
s
.45021 .01472 m
.45021 .01847 L
s
.49803 .01472 m
.49803 .01847 L
s
.54584 .01472 m
.54584 .01847 L
s
.64148 .01472 m
.64148 .01847 L
s
.68929 .01472 m
.68929 .01847 L
s
.73711 .01472 m
.73711 .01847 L
s
.83274 .01472 m
.83274 .01847 L
s
.88056 .01472 m
.88056 .01847 L
s
.92837 .01472 m
.92837 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.01986 .13244 m
.02611 .13244 L
s
[(0.2)] .00736 .13244 1 0 Mshowa
.01986 .25016 m
.02611 .25016 L
s
[(0.4)] .00736 .25016 1 0 Mshowa
.01986 .36788 m
.02611 .36788 L
s
[(0.6)] .00736 .36788 1 0 Mshowa
.01986 .4856 m
.02611 .4856 L
s
[(0.8)] .00736 .4856 1 0 Mshowa
.01986 .60332 m
.02611 .60332 L
s
[(1)] .00736 .60332 1 0 Mshowa
.125 Mabswid
.01986 .04415 m
.02361 .04415 L
s
.01986 .07358 m
.02361 .07358 L
s
.01986 .10301 m
.02361 .10301 L
s
.01986 .16187 m
.02361 .16187 L
s
.01986 .1913 m
.02361 .1913 L
s
.01986 .22073 m
.02361 .22073 L
s
.01986 .27959 m
.02361 .27959 L
s
.01986 .30902 m
.02361 .30902 L
s
.01986 .33845 m
.02361 .33845 L
s
.01986 .39731 m
.02361 .39731 L
s
.01986 .42674 m
.02361 .42674 L
s
.01986 .45617 m
.02361 .45617 L
s
.01986 .51503 m
.02361 .51503 L
s
.01986 .54446 m
.02361 .54446 L
s
.01986 .57389 m
.02361 .57389 L
s
.25 Mabswid
.01986 0 m
.01986 .61803 L
s
.0001 w
.02381 .01472 -1.875 0 Mabsadd m
.02381 .01472 0 2.5 Mabsadd L
.02381 .01472 1.875 0 Mabsadd L
.02381 .01472 0 -2.5 Mabsadd L
.02381 .01472 -1.875 0 Mabsadd L closepath F
.02381 .01684 -1.875 0 Mabsadd m
.02381 .01684 0 2.5 Mabsadd L
.02381 .01684 1.875 0 Mabsadd L
.02381 .01684 0 -2.5 Mabsadd L
.02381 .01684 -1.875 0 Mabsadd L closepath F
.02644 .01894 -1.875 0 Mabsadd m
.02644 .01894 0 2.5 Mabsadd L
.02644 .01894 1.875 0 Mabsadd L
.02644 .01894 0 -2.5 Mabsadd L
.02644 .01894 -1.875 0 Mabsadd L closepath F
.03039 .02101 -1.875 0 Mabsadd m
.03039 .02101 0 2.5 Mabsadd L
.03039 .02101 1.875 0 Mabsadd L
.03039 .02101 0 -2.5 Mabsadd L
.03039 .02101 -1.875 0 Mabsadd L closepath F
.03302 .02308 -1.875 0 Mabsadd m
.03302 .02308 0 2.5 Mabsadd L
.03302 .02308 1.875 0 Mabsadd L
.03302 .02308 0 -2.5 Mabsadd L
.03302 .02308 -1.875 0 Mabsadd L closepath F
.03696 .02513 -1.875 0 Mabsadd m
.03696 .02513 0 2.5 Mabsadd L
.03696 .02513 1.875 0 Mabsadd L
.03696 .02513 0 -2.5 Mabsadd L
.03696 .02513 -1.875 0 Mabsadd L closepath F
.03828 .02716 -1.875 0 Mabsadd m
.03828 .02716 0 2.5 Mabsadd L
.03828 .02716 1.875 0 Mabsadd L
.03828 .02716 0 -2.5 Mabsadd L
.03828 .02716 -1.875 0 Mabsadd L closepath F
.04223 .02919 -1.875 0 Mabsadd m
.04223 .02919 0 2.5 Mabsadd L
.04223 .02919 1.875 0 Mabsadd L
.04223 .02919 0 -2.5 Mabsadd L
.04223 .02919 -1.875 0 Mabsadd L closepath F
.04749 .0312 -1.875 0 Mabsadd m
.04749 .0312 0 2.5 Mabsadd L
.04749 .0312 1.875 0 Mabsadd L
.04749 .0312 0 -2.5 Mabsadd L
.04749 .0312 -1.875 0 Mabsadd L closepath F
.05012 .0332 -1.875 0 Mabsadd m
.05012 .0332 0 2.5 Mabsadd L
.05012 .0332 1.875 0 Mabsadd L
.05012 .0332 0 -2.5 Mabsadd L
.05012 .0332 -1.875 0 Mabsadd L closepath F
.06064 .0352 -1.875 0 Mabsadd m
.06064 .0352 0 2.5 Mabsadd L
.06064 .0352 1.875 0 Mabsadd L
.06064 .0352 0 -2.5 Mabsadd L
.06064 .0352 -1.875 0 Mabsadd L closepath F
.06196 .03718 -1.875 0 Mabsadd m
.06196 .03718 0 2.5 Mabsadd L
.06196 .03718 1.875 0 Mabsadd L
.06196 .03718 0 -2.5 Mabsadd L
.06196 .03718 -1.875 0 Mabsadd L closepath F
.06327 .03915 -1.875 0 Mabsadd m
.06327 .03915 0 2.5 Mabsadd L
.06327 .03915 1.875 0 Mabsadd L
.06327 .03915 0 -2.5 Mabsadd L
.06327 .03915 -1.875 0 Mabsadd L closepath F
.0659 .04112 -1.875 0 Mabsadd m
.0659 .04112 0 2.5 Mabsadd L
.0659 .04112 1.875 0 Mabsadd L
.0659 .04112 0 -2.5 Mabsadd L
.0659 .04112 -1.875 0 Mabsadd L closepath F
.06985 .04307 -1.875 0 Mabsadd m
.06985 .04307 0 2.5 Mabsadd L
.06985 .04307 1.875 0 Mabsadd L
.06985 .04307 0 -2.5 Mabsadd L
.06985 .04307 -1.875 0 Mabsadd L closepath F
.0738 .04502 -1.875 0 Mabsadd m
.0738 .04502 0 2.5 Mabsadd L
.0738 .04502 1.875 0 Mabsadd L
.0738 .04502 0 -2.5 Mabsadd L
.0738 .04502 -1.875 0 Mabsadd L closepath F
.07774 .04696 -1.875 0 Mabsadd m
.07774 .04696 0 2.5 Mabsadd L
.07774 .04696 1.875 0 Mabsadd L
.07774 .04696 0 -2.5 Mabsadd L
.07774 .04696 -1.875 0 Mabsadd L closepath F
.08169 .04889 -1.875 0 Mabsadd m
.08169 .04889 0 2.5 Mabsadd L
.08169 .04889 1.875 0 Mabsadd L
.08169 .04889 0 -2.5 Mabsadd L
.08169 .04889 -1.875 0 Mabsadd L closepath F
.083 .05081 -1.875 0 Mabsadd m
.083 .05081 0 2.5 Mabsadd L
.083 .05081 1.875 0 Mabsadd L
.083 .05081 0 -2.5 Mabsadd L
.083 .05081 -1.875 0 Mabsadd L closepath F
.08827 .05273 -1.875 0 Mabsadd m
.08827 .05273 0 2.5 Mabsadd L
.08827 .05273 1.875 0 Mabsadd L
.08827 .05273 0 -2.5 Mabsadd L
.08827 .05273 -1.875 0 Mabsadd L closepath F
.0909 .05463 -1.875 0 Mabsadd m
.0909 .05463 0 2.5 Mabsadd L
.0909 .05463 1.875 0 Mabsadd L
.0909 .05463 0 -2.5 Mabsadd L
.0909 .05463 -1.875 0 Mabsadd L closepath F
.10142 .05653 -1.875 0 Mabsadd m
.10142 .05653 0 2.5 Mabsadd L
.10142 .05653 1.875 0 Mabsadd L
.10142 .05653 0 -2.5 Mabsadd L
.10142 .05653 -1.875 0 Mabsadd L closepath F
.10668 .05843 -1.875 0 Mabsadd m
.10668 .05843 0 2.5 Mabsadd L
.10668 .05843 1.875 0 Mabsadd L
.10668 .05843 0 -2.5 Mabsadd L
.10668 .05843 -1.875 0 Mabsadd L closepath F
.10931 .06031 -1.875 0 Mabsadd m
.10931 .06031 0 2.5 Mabsadd L
.10931 .06031 1.875 0 Mabsadd L
.10931 .06031 0 -2.5 Mabsadd L
.10931 .06031 -1.875 0 Mabsadd L closepath F
.11589 .06219 -1.875 0 Mabsadd m
.11589 .06219 0 2.5 Mabsadd L
.11589 .06219 1.875 0 Mabsadd L
.11589 .06219 0 -2.5 Mabsadd L
.11589 .06219 -1.875 0 Mabsadd L closepath F
.11721 .06406 -1.875 0 Mabsadd m
.11721 .06406 0 2.5 Mabsadd L
.11721 .06406 1.875 0 Mabsadd L
.11721 .06406 0 -2.5 Mabsadd L
.11721 .06406 -1.875 0 Mabsadd L closepath F
.11984 .06593 -1.875 0 Mabsadd m
.11984 .06593 0 2.5 Mabsadd L
.11984 .06593 1.875 0 Mabsadd L
.11984 .06593 0 -2.5 Mabsadd L
.11984 .06593 -1.875 0 Mabsadd L closepath F
.12378 .06779 -1.875 0 Mabsadd m
.12378 .06779 0 2.5 Mabsadd L
.12378 .06779 1.875 0 Mabsadd L
.12378 .06779 0 -2.5 Mabsadd L
.12378 .06779 -1.875 0 Mabsadd L closepath F
.1251 .06964 -1.875 0 Mabsadd m
.1251 .06964 0 2.5 Mabsadd L
.1251 .06964 1.875 0 Mabsadd L
.1251 .06964 0 -2.5 Mabsadd L
.1251 .06964 -1.875 0 Mabsadd L closepath F
.1251 .07148 -1.875 0 Mabsadd m
.1251 .07148 0 2.5 Mabsadd L
.1251 .07148 1.875 0 Mabsadd L
.1251 .07148 0 -2.5 Mabsadd L
.1251 .07148 -1.875 0 Mabsadd L closepath F
.12641 .07332 -1.875 0 Mabsadd m
.12641 .07332 0 2.5 Mabsadd L
.12641 .07332 1.875 0 Mabsadd L
.12641 .07332 0 -2.5 Mabsadd L
.12641 .07332 -1.875 0 Mabsadd L closepath F
.12773 .07515 -1.875 0 Mabsadd m
.12773 .07515 0 2.5 Mabsadd L
.12773 .07515 1.875 0 Mabsadd L
.12773 .07515 0 -2.5 Mabsadd L
.12773 .07515 -1.875 0 Mabsadd L closepath F
.12773 .07698 -1.875 0 Mabsadd m
.12773 .07698 0 2.5 Mabsadd L
.12773 .07698 1.875 0 Mabsadd L
.12773 .07698 0 -2.5 Mabsadd L
.12773 .07698 -1.875 0 Mabsadd L closepath F
.12904 .0788 -1.875 0 Mabsadd m
.12904 .0788 0 2.5 Mabsadd L
.12904 .0788 1.875 0 Mabsadd L
.12904 .0788 0 -2.5 Mabsadd L
.12904 .0788 -1.875 0 Mabsadd L closepath F
.13299 .08062 -1.875 0 Mabsadd m
.13299 .08062 0 2.5 Mabsadd L
.13299 .08062 1.875 0 Mabsadd L
.13299 .08062 0 -2.5 Mabsadd L
.13299 .08062 -1.875 0 Mabsadd L closepath F
.13431 .08242 -1.875 0 Mabsadd m
.13431 .08242 0 2.5 Mabsadd L
.13431 .08242 1.875 0 Mabsadd L
.13431 .08242 0 -2.5 Mabsadd L
.13431 .08242 -1.875 0 Mabsadd L closepath F
.13562 .08423 -1.875 0 Mabsadd m
.13562 .08423 0 2.5 Mabsadd L
.13562 .08423 1.875 0 Mabsadd L
.13562 .08423 0 -2.5 Mabsadd L
.13562 .08423 -1.875 0 Mabsadd L closepath F
.13825 .08602 -1.875 0 Mabsadd m
.13825 .08602 0 2.5 Mabsadd L
.13825 .08602 1.875 0 Mabsadd L
.13825 .08602 0 -2.5 Mabsadd L
.13825 .08602 -1.875 0 Mabsadd L closepath F
.1422 .08781 -1.875 0 Mabsadd m
.1422 .08781 0 2.5 Mabsadd L
.1422 .08781 1.875 0 Mabsadd L
.1422 .08781 0 -2.5 Mabsadd L
.1422 .08781 -1.875 0 Mabsadd L closepath F
.14615 .0896 -1.875 0 Mabsadd m
.14615 .0896 0 2.5 Mabsadd L
.14615 .0896 1.875 0 Mabsadd L
.14615 .0896 0 -2.5 Mabsadd L
.14615 .0896 -1.875 0 Mabsadd L closepath F
.14878 .09138 -1.875 0 Mabsadd m
.14878 .09138 0 2.5 Mabsadd L
.14878 .09138 1.875 0 Mabsadd L
.14878 .09138 0 -2.5 Mabsadd L
.14878 .09138 -1.875 0 Mabsadd L closepath F
.15141 .09315 -1.875 0 Mabsadd m
.15141 .09315 0 2.5 Mabsadd L
.15141 .09315 1.875 0 Mabsadd L
.15141 .09315 0 -2.5 Mabsadd L
.15141 .09315 -1.875 0 Mabsadd L closepath F
.15798 .09492 -1.875 0 Mabsadd m
.15798 .09492 0 2.5 Mabsadd L
.15798 .09492 1.875 0 Mabsadd L
.15798 .09492 0 -2.5 Mabsadd L
.15798 .09492 -1.875 0 Mabsadd L closepath F
.16062 .09668 -1.875 0 Mabsadd m
.16062 .09668 0 2.5 Mabsadd L
.16062 .09668 1.875 0 Mabsadd L
.16062 .09668 0 -2.5 Mabsadd L
.16062 .09668 -1.875 0 Mabsadd L closepath F
.16588 .09844 -1.875 0 Mabsadd m
.16588 .09844 0 2.5 Mabsadd L
.16588 .09844 1.875 0 Mabsadd L
.16588 .09844 0 -2.5 Mabsadd L
.16588 .09844 -1.875 0 Mabsadd L closepath F
.16588 .10019 -1.875 0 Mabsadd m
.16588 .10019 0 2.5 Mabsadd L
.16588 .10019 1.875 0 Mabsadd L
.16588 .10019 0 -2.5 Mabsadd L
.16588 .10019 -1.875 0 Mabsadd L closepath F
.16719 .10194 -1.875 0 Mabsadd m
.16719 .10194 0 2.5 Mabsadd L
.16719 .10194 1.875 0 Mabsadd L
.16719 .10194 0 -2.5 Mabsadd L
.16719 .10194 -1.875 0 Mabsadd L closepath F
.17377 .10368 -1.875 0 Mabsadd m
.17377 .10368 0 2.5 Mabsadd L
.17377 .10368 1.875 0 Mabsadd L
.17377 .10368 0 -2.5 Mabsadd L
.17377 .10368 -1.875 0 Mabsadd L closepath F
.1764 .10541 -1.875 0 Mabsadd m
.1764 .10541 0 2.5 Mabsadd L
.1764 .10541 1.875 0 Mabsadd L
.1764 .10541 0 -2.5 Mabsadd L
.1764 .10541 -1.875 0 Mabsadd L closepath F
.18166 .10714 -1.875 0 Mabsadd m
.18166 .10714 0 2.5 Mabsadd L
.18166 .10714 1.875 0 Mabsadd L
.18166 .10714 0 -2.5 Mabsadd L
.18166 .10714 -1.875 0 Mabsadd L closepath F
.18561 .10887 -1.875 0 Mabsadd m
.18561 .10887 0 2.5 Mabsadd L
.18561 .10887 1.875 0 Mabsadd L
.18561 .10887 0 -2.5 Mabsadd L
.18561 .10887 -1.875 0 Mabsadd L closepath F
.19219 .11059 -1.875 0 Mabsadd m
.19219 .11059 0 2.5 Mabsadd L
.19219 .11059 1.875 0 Mabsadd L
.19219 .11059 0 -2.5 Mabsadd L
.19219 .11059 -1.875 0 Mabsadd L closepath F
.19482 .1123 -1.875 0 Mabsadd m
.19482 .1123 0 2.5 Mabsadd L
.19482 .1123 1.875 0 Mabsadd L
.19482 .1123 0 -2.5 Mabsadd L
.19482 .1123 -1.875 0 Mabsadd L closepath F
.19482 .11401 -1.875 0 Mabsadd m
.19482 .11401 0 2.5 Mabsadd L
.19482 .11401 1.875 0 Mabsadd L
.19482 .11401 0 -2.5 Mabsadd L
.19482 .11401 -1.875 0 Mabsadd L closepath F
.20008 .11572 -1.875 0 Mabsadd m
.20008 .11572 0 2.5 Mabsadd L
.20008 .11572 1.875 0 Mabsadd L
.20008 .11572 0 -2.5 Mabsadd L
.20008 .11572 -1.875 0 Mabsadd L closepath F
.20008 .11742 -1.875 0 Mabsadd m
.20008 .11742 0 2.5 Mabsadd L
.20008 .11742 1.875 0 Mabsadd L
.20008 .11742 0 -2.5 Mabsadd L
.20008 .11742 -1.875 0 Mabsadd L closepath F
.20534 .11911 -1.875 0 Mabsadd m
.20534 .11911 0 2.5 Mabsadd L
.20534 .11911 1.875 0 Mabsadd L
.20534 .11911 0 -2.5 Mabsadd L
.20534 .11911 -1.875 0 Mabsadd L closepath F
.20666 .1208 -1.875 0 Mabsadd m
.20666 .1208 0 2.5 Mabsadd L
.20666 .1208 1.875 0 Mabsadd L
.20666 .1208 0 -2.5 Mabsadd L
.20666 .1208 -1.875 0 Mabsadd L closepath F
.20797 .12249 -1.875 0 Mabsadd m
.20797 .12249 0 2.5 Mabsadd L
.20797 .12249 1.875 0 Mabsadd L
.20797 .12249 0 -2.5 Mabsadd L
.20797 .12249 -1.875 0 Mabsadd L closepath F
.21323 .12417 -1.875 0 Mabsadd m
.21323 .12417 0 2.5 Mabsadd L
.21323 .12417 1.875 0 Mabsadd L
.21323 .12417 0 -2.5 Mabsadd L
.21323 .12417 -1.875 0 Mabsadd L closepath F
.21718 .12584 -1.875 0 Mabsadd m
.21718 .12584 0 2.5 Mabsadd L
.21718 .12584 1.875 0 Mabsadd L
.21718 .12584 0 -2.5 Mabsadd L
.21718 .12584 -1.875 0 Mabsadd L closepath F
.22244 .12752 -1.875 0 Mabsadd m
.22244 .12752 0 2.5 Mabsadd L
.22244 .12752 1.875 0 Mabsadd L
.22244 .12752 0 -2.5 Mabsadd L
.22244 .12752 -1.875 0 Mabsadd L closepath F
.22639 .12918 -1.875 0 Mabsadd m
.22639 .12918 0 2.5 Mabsadd L
.22639 .12918 1.875 0 Mabsadd L
.22639 .12918 0 -2.5 Mabsadd L
.22639 .12918 -1.875 0 Mabsadd L closepath F
.22639 .13084 -1.875 0 Mabsadd m
.22639 .13084 0 2.5 Mabsadd L
.22639 .13084 1.875 0 Mabsadd L
.22639 .13084 0 -2.5 Mabsadd L
.22639 .13084 -1.875 0 Mabsadd L closepath F
.2277 .1325 -1.875 0 Mabsadd m
.2277 .1325 0 2.5 Mabsadd L
.2277 .1325 1.875 0 Mabsadd L
.2277 .1325 0 -2.5 Mabsadd L
.2277 .1325 -1.875 0 Mabsadd L closepath F
.22902 .13415 -1.875 0 Mabsadd m
.22902 .13415 0 2.5 Mabsadd L
.22902 .13415 1.875 0 Mabsadd L
.22902 .13415 0 -2.5 Mabsadd L
.22902 .13415 -1.875 0 Mabsadd L closepath F
.2356 .1358 -1.875 0 Mabsadd m
.2356 .1358 0 2.5 Mabsadd L
.2356 .1358 1.875 0 Mabsadd L
.2356 .1358 0 -2.5 Mabsadd L
.2356 .1358 -1.875 0 Mabsadd L closepath F
.23691 .13744 -1.875 0 Mabsadd m
.23691 .13744 0 2.5 Mabsadd L
.23691 .13744 1.875 0 Mabsadd L
.23691 .13744 0 -2.5 Mabsadd L
.23691 .13744 -1.875 0 Mabsadd L closepath F
.23954 .13908 -1.875 0 Mabsadd m
.23954 .13908 0 2.5 Mabsadd L
.23954 .13908 1.875 0 Mabsadd L
.23954 .13908 0 -2.5 Mabsadd L
.23954 .13908 -1.875 0 Mabsadd L closepath F
.24217 .14071 -1.875 0 Mabsadd m
.24217 .14071 0 2.5 Mabsadd L
.24217 .14071 1.875 0 Mabsadd L
.24217 .14071 0 -2.5 Mabsadd L
.24217 .14071 -1.875 0 Mabsadd L closepath F
.24217 .14234 -1.875 0 Mabsadd m
.24217 .14234 0 2.5 Mabsadd L
.24217 .14234 1.875 0 Mabsadd L
.24217 .14234 0 -2.5 Mabsadd L
.24217 .14234 -1.875 0 Mabsadd L closepath F
.2448 .14397 -1.875 0 Mabsadd m
.2448 .14397 0 2.5 Mabsadd L
.2448 .14397 1.875 0 Mabsadd L
.2448 .14397 0 -2.5 Mabsadd L
.2448 .14397 -1.875 0 Mabsadd L closepath F
.2448 .14559 -1.875 0 Mabsadd m
.2448 .14559 0 2.5 Mabsadd L
.2448 .14559 1.875 0 Mabsadd L
.2448 .14559 0 -2.5 Mabsadd L
.2448 .14559 -1.875 0 Mabsadd L closepath F
.25138 .1472 -1.875 0 Mabsadd m
.25138 .1472 0 2.5 Mabsadd L
.25138 .1472 1.875 0 Mabsadd L
.25138 .1472 0 -2.5 Mabsadd L
.25138 .1472 -1.875 0 Mabsadd L closepath F
.2527 .14881 -1.875 0 Mabsadd m
.2527 .14881 0 2.5 Mabsadd L
.2527 .14881 1.875 0 Mabsadd L
.2527 .14881 0 -2.5 Mabsadd L
.2527 .14881 -1.875 0 Mabsadd L closepath F
.25401 .15042 -1.875 0 Mabsadd m
.25401 .15042 0 2.5 Mabsadd L
.25401 .15042 1.875 0 Mabsadd L
.25401 .15042 0 -2.5 Mabsadd L
.25401 .15042 -1.875 0 Mabsadd L closepath F
.25796 .15202 -1.875 0 Mabsadd m
.25796 .15202 0 2.5 Mabsadd L
.25796 .15202 1.875 0 Mabsadd L
.25796 .15202 0 -2.5 Mabsadd L
.25796 .15202 -1.875 0 Mabsadd L closepath F
.2619 .15362 -1.875 0 Mabsadd m
.2619 .15362 0 2.5 Mabsadd L
.2619 .15362 1.875 0 Mabsadd L
.2619 .15362 0 -2.5 Mabsadd L
.2619 .15362 -1.875 0 Mabsadd L closepath F
.26717 .15521 -1.875 0 Mabsadd m
.26717 .15521 0 2.5 Mabsadd L
.26717 .15521 1.875 0 Mabsadd L
.26717 .15521 0 -2.5 Mabsadd L
.26717 .15521 -1.875 0 Mabsadd L closepath F
.27374 .1568 -1.875 0 Mabsadd m
.27374 .1568 0 2.5 Mabsadd L
.27374 .1568 1.875 0 Mabsadd L
.27374 .1568 0 -2.5 Mabsadd L
.27374 .1568 -1.875 0 Mabsadd L closepath F
.27637 .15839 -1.875 0 Mabsadd m
.27637 .15839 0 2.5 Mabsadd L
.27637 .15839 1.875 0 Mabsadd L
.27637 .15839 0 -2.5 Mabsadd L
.27637 .15839 -1.875 0 Mabsadd L closepath F
.27901 .15997 -1.875 0 Mabsadd m
.27901 .15997 0 2.5 Mabsadd L
.27901 .15997 1.875 0 Mabsadd L
.27901 .15997 0 -2.5 Mabsadd L
.27901 .15997 -1.875 0 Mabsadd L closepath F
.28032 .16154 -1.875 0 Mabsadd m
.28032 .16154 0 2.5 Mabsadd L
.28032 .16154 1.875 0 Mabsadd L
.28032 .16154 0 -2.5 Mabsadd L
.28032 .16154 -1.875 0 Mabsadd L closepath F
.28032 .16312 -1.875 0 Mabsadd m
.28032 .16312 0 2.5 Mabsadd L
.28032 .16312 1.875 0 Mabsadd L
.28032 .16312 0 -2.5 Mabsadd L
.28032 .16312 -1.875 0 Mabsadd L closepath F
.28295 .16468 -1.875 0 Mabsadd m
.28295 .16468 0 2.5 Mabsadd L
.28295 .16468 1.875 0 Mabsadd L
.28295 .16468 0 -2.5 Mabsadd L
.28295 .16468 -1.875 0 Mabsadd L closepath F
.28558 .16625 -1.875 0 Mabsadd m
.28558 .16625 0 2.5 Mabsadd L
.28558 .16625 1.875 0 Mabsadd L
.28558 .16625 0 -2.5 Mabsadd L
.28558 .16625 -1.875 0 Mabsadd L closepath F
.28821 .16781 -1.875 0 Mabsadd m
.28821 .16781 0 2.5 Mabsadd L
.28821 .16781 1.875 0 Mabsadd L
.28821 .16781 0 -2.5 Mabsadd L
.28821 .16781 -1.875 0 Mabsadd L closepath F
.29216 .16936 -1.875 0 Mabsadd m
.29216 .16936 0 2.5 Mabsadd L
.29216 .16936 1.875 0 Mabsadd L
.29216 .16936 0 -2.5 Mabsadd L
.29216 .16936 -1.875 0 Mabsadd L closepath F
.29348 .17091 -1.875 0 Mabsadd m
.29348 .17091 0 2.5 Mabsadd L
.29348 .17091 1.875 0 Mabsadd L
.29348 .17091 0 -2.5 Mabsadd L
.29348 .17091 -1.875 0 Mabsadd L closepath F
.29742 .17246 -1.875 0 Mabsadd m
.29742 .17246 0 2.5 Mabsadd L
.29742 .17246 1.875 0 Mabsadd L
.29742 .17246 0 -2.5 Mabsadd L
.29742 .17246 -1.875 0 Mabsadd L closepath F
.30137 .174 -1.875 0 Mabsadd m
.30137 .174 0 2.5 Mabsadd L
.30137 .174 1.875 0 Mabsadd L
.30137 .174 0 -2.5 Mabsadd L
.30137 .174 -1.875 0 Mabsadd L closepath F
.30531 .17554 -1.875 0 Mabsadd m
.30531 .17554 0 2.5 Mabsadd L
.30531 .17554 1.875 0 Mabsadd L
.30531 .17554 0 -2.5 Mabsadd L
.30531 .17554 -1.875 0 Mabsadd L closepath F
.30663 .17708 -1.875 0 Mabsadd m
.30663 .17708 0 2.5 Mabsadd L
.30663 .17708 1.875 0 Mabsadd L
.30663 .17708 0 -2.5 Mabsadd L
.30663 .17708 -1.875 0 Mabsadd L closepath F
.30663 .17861 -1.875 0 Mabsadd m
.30663 .17861 0 2.5 Mabsadd L
.30663 .17861 1.875 0 Mabsadd L
.30663 .17861 0 -2.5 Mabsadd L
.30663 .17861 -1.875 0 Mabsadd L closepath F
.31058 .18014 -1.875 0 Mabsadd m
.31058 .18014 0 2.5 Mabsadd L
.31058 .18014 1.875 0 Mabsadd L
.31058 .18014 0 -2.5 Mabsadd L
.31058 .18014 -1.875 0 Mabsadd L closepath F
.31189 .18166 -1.875 0 Mabsadd m
.31189 .18166 0 2.5 Mabsadd L
.31189 .18166 1.875 0 Mabsadd L
.31189 .18166 0 -2.5 Mabsadd L
.31189 .18166 -1.875 0 Mabsadd L closepath F
.31321 .18318 -1.875 0 Mabsadd m
.31321 .18318 0 2.5 Mabsadd L
.31321 .18318 1.875 0 Mabsadd L
.31321 .18318 0 -2.5 Mabsadd L
.31321 .18318 -1.875 0 Mabsadd L closepath F
.31584 .18469 -1.875 0 Mabsadd m
.31584 .18469 0 2.5 Mabsadd L
.31584 .18469 1.875 0 Mabsadd L
.31584 .18469 0 -2.5 Mabsadd L
.31584 .18469 -1.875 0 Mabsadd L closepath F
.31847 .1862 -1.875 0 Mabsadd m
.31847 .1862 0 2.5 Mabsadd L
.31847 .1862 1.875 0 Mabsadd L
.31847 .1862 0 -2.5 Mabsadd L
.31847 .1862 -1.875 0 Mabsadd L closepath F
.32373 .18771 -1.875 0 Mabsadd m
.32373 .18771 0 2.5 Mabsadd L
.32373 .18771 1.875 0 Mabsadd L
.32373 .18771 0 -2.5 Mabsadd L
.32373 .18771 -1.875 0 Mabsadd L closepath F
.32505 .18921 -1.875 0 Mabsadd m
.32505 .18921 0 2.5 Mabsadd L
.32505 .18921 1.875 0 Mabsadd L
.32505 .18921 0 -2.5 Mabsadd L
.32505 .18921 -1.875 0 Mabsadd L closepath F
.32636 .19071 -1.875 0 Mabsadd m
.32636 .19071 0 2.5 Mabsadd L
.32636 .19071 1.875 0 Mabsadd L
.32636 .19071 0 -2.5 Mabsadd L
.32636 .19071 -1.875 0 Mabsadd L closepath F
.32768 .19221 -1.875 0 Mabsadd m
.32768 .19221 0 2.5 Mabsadd L
.32768 .19221 1.875 0 Mabsadd L
.32768 .19221 0 -2.5 Mabsadd L
.32768 .19221 -1.875 0 Mabsadd L closepath F
.33162 .1937 -1.875 0 Mabsadd m
.33162 .1937 0 2.5 Mabsadd L
.33162 .1937 1.875 0 Mabsadd L
.33162 .1937 0 -2.5 Mabsadd L
.33162 .1937 -1.875 0 Mabsadd L closepath F
.33162 .19519 -1.875 0 Mabsadd m
.33162 .19519 0 2.5 Mabsadd L
.33162 .19519 1.875 0 Mabsadd L
.33162 .19519 0 -2.5 Mabsadd L
.33162 .19519 -1.875 0 Mabsadd L closepath F
.33557 .19667 -1.875 0 Mabsadd m
.33557 .19667 0 2.5 Mabsadd L
.33557 .19667 1.875 0 Mabsadd L
.33557 .19667 0 -2.5 Mabsadd L
.33557 .19667 -1.875 0 Mabsadd L closepath F
.33557 .19815 -1.875 0 Mabsadd m
.33557 .19815 0 2.5 Mabsadd L
.33557 .19815 1.875 0 Mabsadd L
.33557 .19815 0 -2.5 Mabsadd L
.33557 .19815 -1.875 0 Mabsadd L closepath F
.34083 .19963 -1.875 0 Mabsadd m
.34083 .19963 0 2.5 Mabsadd L
.34083 .19963 1.875 0 Mabsadd L
.34083 .19963 0 -2.5 Mabsadd L
.34083 .19963 -1.875 0 Mabsadd L closepath F
.34478 .2011 -1.875 0 Mabsadd m
.34478 .2011 0 2.5 Mabsadd L
.34478 .2011 1.875 0 Mabsadd L
.34478 .2011 0 -2.5 Mabsadd L
.34478 .2011 -1.875 0 Mabsadd L closepath F
.34609 .20257 -1.875 0 Mabsadd m
.34609 .20257 0 2.5 Mabsadd L
.34609 .20257 1.875 0 Mabsadd L
.34609 .20257 0 -2.5 Mabsadd L
.34609 .20257 -1.875 0 Mabsadd L closepath F
.35004 .20403 -1.875 0 Mabsadd m
.35004 .20403 0 2.5 Mabsadd L
.35004 .20403 1.875 0 Mabsadd L
.35004 .20403 0 -2.5 Mabsadd L
.35004 .20403 -1.875 0 Mabsadd L closepath F
.35399 .20549 -1.875 0 Mabsadd m
.35399 .20549 0 2.5 Mabsadd L
.35399 .20549 1.875 0 Mabsadd L
.35399 .20549 0 -2.5 Mabsadd L
.35399 .20549 -1.875 0 Mabsadd L closepath F
.35399 .20695 -1.875 0 Mabsadd m
.35399 .20695 0 2.5 Mabsadd L
.35399 .20695 1.875 0 Mabsadd L
.35399 .20695 0 -2.5 Mabsadd L
.35399 .20695 -1.875 0 Mabsadd L closepath F
.35399 .2084 -1.875 0 Mabsadd m
.35399 .2084 0 2.5 Mabsadd L
.35399 .2084 1.875 0 Mabsadd L
.35399 .2084 0 -2.5 Mabsadd L
.35399 .2084 -1.875 0 Mabsadd L closepath F
.35925 .20985 -1.875 0 Mabsadd m
.35925 .20985 0 2.5 Mabsadd L
.35925 .20985 1.875 0 Mabsadd L
.35925 .20985 0 -2.5 Mabsadd L
.35925 .20985 -1.875 0 Mabsadd L closepath F
.36188 .2113 -1.875 0 Mabsadd m
.36188 .2113 0 2.5 Mabsadd L
.36188 .2113 1.875 0 Mabsadd L
.36188 .2113 0 -2.5 Mabsadd L
.36188 .2113 -1.875 0 Mabsadd L closepath F
.36714 .21274 -1.875 0 Mabsadd m
.36714 .21274 0 2.5 Mabsadd L
.36714 .21274 1.875 0 Mabsadd L
.36714 .21274 0 -2.5 Mabsadd L
.36714 .21274 -1.875 0 Mabsadd L closepath F
.36977 .21418 -1.875 0 Mabsadd m
.36977 .21418 0 2.5 Mabsadd L
.36977 .21418 1.875 0 Mabsadd L
.36977 .21418 0 -2.5 Mabsadd L
.36977 .21418 -1.875 0 Mabsadd L closepath F
.3724 .21561 -1.875 0 Mabsadd m
.3724 .21561 0 2.5 Mabsadd L
.3724 .21561 1.875 0 Mabsadd L
.3724 .21561 0 -2.5 Mabsadd L
.3724 .21561 -1.875 0 Mabsadd L closepath F
.3724 .21704 -1.875 0 Mabsadd m
.3724 .21704 0 2.5 Mabsadd L
.3724 .21704 1.875 0 Mabsadd L
.3724 .21704 0 -2.5 Mabsadd L
.3724 .21704 -1.875 0 Mabsadd L closepath F
.37372 .21847 -1.875 0 Mabsadd m
.37372 .21847 0 2.5 Mabsadd L
.37372 .21847 1.875 0 Mabsadd L
.37372 .21847 0 -2.5 Mabsadd L
.37372 .21847 -1.875 0 Mabsadd L closepath F
.37372 .2199 -1.875 0 Mabsadd m
.37372 .2199 0 2.5 Mabsadd L
.37372 .2199 1.875 0 Mabsadd L
.37372 .2199 0 -2.5 Mabsadd L
.37372 .2199 -1.875 0 Mabsadd L closepath F
.37503 .22132 -1.875 0 Mabsadd m
.37503 .22132 0 2.5 Mabsadd L
.37503 .22132 1.875 0 Mabsadd L
.37503 .22132 0 -2.5 Mabsadd L
.37503 .22132 -1.875 0 Mabsadd L closepath F
.37766 .22273 -1.875 0 Mabsadd m
.37766 .22273 0 2.5 Mabsadd L
.37766 .22273 1.875 0 Mabsadd L
.37766 .22273 0 -2.5 Mabsadd L
.37766 .22273 -1.875 0 Mabsadd L closepath F
.37766 .22415 -1.875 0 Mabsadd m
.37766 .22415 0 2.5 Mabsadd L
.37766 .22415 1.875 0 Mabsadd L
.37766 .22415 0 -2.5 Mabsadd L
.37766 .22415 -1.875 0 Mabsadd L closepath F
.38029 .22556 -1.875 0 Mabsadd m
.38029 .22556 0 2.5 Mabsadd L
.38029 .22556 1.875 0 Mabsadd L
.38029 .22556 0 -2.5 Mabsadd L
.38029 .22556 -1.875 0 Mabsadd L closepath F
.38819 .22696 -1.875 0 Mabsadd m
.38819 .22696 0 2.5 Mabsadd L
.38819 .22696 1.875 0 Mabsadd L
.38819 .22696 0 -2.5 Mabsadd L
.38819 .22696 -1.875 0 Mabsadd L closepath F
.3895 .22836 -1.875 0 Mabsadd m
.3895 .22836 0 2.5 Mabsadd L
.3895 .22836 1.875 0 Mabsadd L
.3895 .22836 0 -2.5 Mabsadd L
.3895 .22836 -1.875 0 Mabsadd L closepath F
.39345 .22976 -1.875 0 Mabsadd m
.39345 .22976 0 2.5 Mabsadd L
.39345 .22976 1.875 0 Mabsadd L
.39345 .22976 0 -2.5 Mabsadd L
.39345 .22976 -1.875 0 Mabsadd L closepath F
.39871 .23116 -1.875 0 Mabsadd m
.39871 .23116 0 2.5 Mabsadd L
.39871 .23116 1.875 0 Mabsadd L
.39871 .23116 0 -2.5 Mabsadd L
.39871 .23116 -1.875 0 Mabsadd L closepath F
.40529 .23255 -1.875 0 Mabsadd m
.40529 .23255 0 2.5 Mabsadd L
.40529 .23255 1.875 0 Mabsadd L
.40529 .23255 0 -2.5 Mabsadd L
.40529 .23255 -1.875 0 Mabsadd L closepath F
.40792 .23394 -1.875 0 Mabsadd m
.40792 .23394 0 2.5 Mabsadd L
.40792 .23394 1.875 0 Mabsadd L
.40792 .23394 0 -2.5 Mabsadd L
.40792 .23394 -1.875 0 Mabsadd L closepath F
.41187 .23532 -1.875 0 Mabsadd m
.41187 .23532 0 2.5 Mabsadd L
.41187 .23532 1.875 0 Mabsadd L
.41187 .23532 0 -2.5 Mabsadd L
.41187 .23532 -1.875 0 Mabsadd L closepath F
.41581 .2367 -1.875 0 Mabsadd m
.41581 .2367 0 2.5 Mabsadd L
.41581 .2367 1.875 0 Mabsadd L
.41581 .2367 0 -2.5 Mabsadd L
.41581 .2367 -1.875 0 Mabsadd L closepath F
.41581 .23808 -1.875 0 Mabsadd m
.41581 .23808 0 2.5 Mabsadd L
.41581 .23808 1.875 0 Mabsadd L
.41581 .23808 0 -2.5 Mabsadd L
.41581 .23808 -1.875 0 Mabsadd L closepath F
.41844 .23945 -1.875 0 Mabsadd m
.41844 .23945 0 2.5 Mabsadd L
.41844 .23945 1.875 0 Mabsadd L
.41844 .23945 0 -2.5 Mabsadd L
.41844 .23945 -1.875 0 Mabsadd L closepath F
.41976 .24082 -1.875 0 Mabsadd m
.41976 .24082 0 2.5 Mabsadd L
.41976 .24082 1.875 0 Mabsadd L
.41976 .24082 0 -2.5 Mabsadd L
.41976 .24082 -1.875 0 Mabsadd L closepath F
.42107 .24219 -1.875 0 Mabsadd m
.42107 .24219 0 2.5 Mabsadd L
.42107 .24219 1.875 0 Mabsadd L
.42107 .24219 0 -2.5 Mabsadd L
.42107 .24219 -1.875 0 Mabsadd L closepath F
.4237 .24355 -1.875 0 Mabsadd m
.4237 .24355 0 2.5 Mabsadd L
.4237 .24355 1.875 0 Mabsadd L
.4237 .24355 0 -2.5 Mabsadd L
.4237 .24355 -1.875 0 Mabsadd L closepath F
.42502 .24492 -1.875 0 Mabsadd m
.42502 .24492 0 2.5 Mabsadd L
.42502 .24492 1.875 0 Mabsadd L
.42502 .24492 0 -2.5 Mabsadd L
.42502 .24492 -1.875 0 Mabsadd L closepath F
.42502 .24627 -1.875 0 Mabsadd m
.42502 .24627 0 2.5 Mabsadd L
.42502 .24627 1.875 0 Mabsadd L
.42502 .24627 0 -2.5 Mabsadd L
.42502 .24627 -1.875 0 Mabsadd L closepath F
.42502 .24763 -1.875 0 Mabsadd m
.42502 .24763 0 2.5 Mabsadd L
.42502 .24763 1.875 0 Mabsadd L
.42502 .24763 0 -2.5 Mabsadd L
.42502 .24763 -1.875 0 Mabsadd L closepath F
.42634 .24898 -1.875 0 Mabsadd m
.42634 .24898 0 2.5 Mabsadd L
.42634 .24898 1.875 0 Mabsadd L
.42634 .24898 0 -2.5 Mabsadd L
.42634 .24898 -1.875 0 Mabsadd L closepath F
.42634 .25032 -1.875 0 Mabsadd m
.42634 .25032 0 2.5 Mabsadd L
.42634 .25032 1.875 0 Mabsadd L
.42634 .25032 0 -2.5 Mabsadd L
.42634 .25032 -1.875 0 Mabsadd L closepath F
.4316 .25166 -1.875 0 Mabsadd m
.4316 .25166 0 2.5 Mabsadd L
.4316 .25166 1.875 0 Mabsadd L
.4316 .25166 0 -2.5 Mabsadd L
.4316 .25166 -1.875 0 Mabsadd L closepath F
.43423 .253 -1.875 0 Mabsadd m
.43423 .253 0 2.5 Mabsadd L
.43423 .253 1.875 0 Mabsadd L
.43423 .253 0 -2.5 Mabsadd L
.43423 .253 -1.875 0 Mabsadd L closepath F
.43554 .25434 -1.875 0 Mabsadd m
.43554 .25434 0 2.5 Mabsadd L
.43554 .25434 1.875 0 Mabsadd L
.43554 .25434 0 -2.5 Mabsadd L
.43554 .25434 -1.875 0 Mabsadd L closepath F
.43817 .25567 -1.875 0 Mabsadd m
.43817 .25567 0 2.5 Mabsadd L
.43817 .25567 1.875 0 Mabsadd L
.43817 .25567 0 -2.5 Mabsadd L
.43817 .25567 -1.875 0 Mabsadd L closepath F
.43817 .257 -1.875 0 Mabsadd m
.43817 .257 0 2.5 Mabsadd L
.43817 .257 1.875 0 Mabsadd L
.43817 .257 0 -2.5 Mabsadd L
.43817 .257 -1.875 0 Mabsadd L closepath F
.43949 .25833 -1.875 0 Mabsadd m
.43949 .25833 0 2.5 Mabsadd L
.43949 .25833 1.875 0 Mabsadd L
.43949 .25833 0 -2.5 Mabsadd L
.43949 .25833 -1.875 0 Mabsadd L closepath F
.44475 .25965 -1.875 0 Mabsadd m
.44475 .25965 0 2.5 Mabsadd L
.44475 .25965 1.875 0 Mabsadd L
.44475 .25965 0 -2.5 Mabsadd L
.44475 .25965 -1.875 0 Mabsadd L closepath F
.44738 .26097 -1.875 0 Mabsadd m
.44738 .26097 0 2.5 Mabsadd L
.44738 .26097 1.875 0 Mabsadd L
.44738 .26097 0 -2.5 Mabsadd L
.44738 .26097 -1.875 0 Mabsadd L closepath F
.45001 .26229 -1.875 0 Mabsadd m
.45001 .26229 0 2.5 Mabsadd L
.45001 .26229 1.875 0 Mabsadd L
.45001 .26229 0 -2.5 Mabsadd L
.45001 .26229 -1.875 0 Mabsadd L closepath F
.45264 .2636 -1.875 0 Mabsadd m
.45264 .2636 0 2.5 Mabsadd L
.45264 .2636 1.875 0 Mabsadd L
.45264 .2636 0 -2.5 Mabsadd L
.45264 .2636 -1.875 0 Mabsadd L closepath F
.45659 .26491 -1.875 0 Mabsadd m
.45659 .26491 0 2.5 Mabsadd L
.45659 .26491 1.875 0 Mabsadd L
.45659 .26491 0 -2.5 Mabsadd L
.45659 .26491 -1.875 0 Mabsadd L closepath F
.46054 .26622 -1.875 0 Mabsadd m
.46054 .26622 0 2.5 Mabsadd L
.46054 .26622 1.875 0 Mabsadd L
.46054 .26622 0 -2.5 Mabsadd L
.46054 .26622 -1.875 0 Mabsadd L closepath F
.46317 .26752 -1.875 0 Mabsadd m
.46317 .26752 0 2.5 Mabsadd L
.46317 .26752 1.875 0 Mabsadd L
.46317 .26752 0 -2.5 Mabsadd L
.46317 .26752 -1.875 0 Mabsadd L closepath F
.46317 .26882 -1.875 0 Mabsadd m
.46317 .26882 0 2.5 Mabsadd L
.46317 .26882 1.875 0 Mabsadd L
.46317 .26882 0 -2.5 Mabsadd L
.46317 .26882 -1.875 0 Mabsadd L closepath F
.46317 .27012 -1.875 0 Mabsadd m
.46317 .27012 0 2.5 Mabsadd L
.46317 .27012 1.875 0 Mabsadd L
.46317 .27012 0 -2.5 Mabsadd L
.46317 .27012 -1.875 0 Mabsadd L closepath F
.46448 .27141 -1.875 0 Mabsadd m
.46448 .27141 0 2.5 Mabsadd L
.46448 .27141 1.875 0 Mabsadd L
.46448 .27141 0 -2.5 Mabsadd L
.46448 .27141 -1.875 0 Mabsadd L closepath F
.4658 .2727 -1.875 0 Mabsadd m
.4658 .2727 0 2.5 Mabsadd L
.4658 .2727 1.875 0 Mabsadd L
.4658 .2727 0 -2.5 Mabsadd L
.4658 .2727 -1.875 0 Mabsadd L closepath F
.46974 .27399 -1.875 0 Mabsadd m
.46974 .27399 0 2.5 Mabsadd L
.46974 .27399 1.875 0 Mabsadd L
.46974 .27399 0 -2.5 Mabsadd L
.46974 .27399 -1.875 0 Mabsadd L closepath F
.47106 .27527 -1.875 0 Mabsadd m
.47106 .27527 0 2.5 Mabsadd L
.47106 .27527 1.875 0 Mabsadd L
.47106 .27527 0 -2.5 Mabsadd L
.47106 .27527 -1.875 0 Mabsadd L closepath F
.47238 .27655 -1.875 0 Mabsadd m
.47238 .27655 0 2.5 Mabsadd L
.47238 .27655 1.875 0 Mabsadd L
.47238 .27655 0 -2.5 Mabsadd L
.47238 .27655 -1.875 0 Mabsadd L closepath F
.47369 .27783 -1.875 0 Mabsadd m
.47369 .27783 0 2.5 Mabsadd L
.47369 .27783 1.875 0 Mabsadd L
.47369 .27783 0 -2.5 Mabsadd L
.47369 .27783 -1.875 0 Mabsadd L closepath F
.47501 .2791 -1.875 0 Mabsadd m
.47501 .2791 0 2.5 Mabsadd L
.47501 .2791 1.875 0 Mabsadd L
.47501 .2791 0 -2.5 Mabsadd L
.47501 .2791 -1.875 0 Mabsadd L closepath F
.47632 .28037 -1.875 0 Mabsadd m
.47632 .28037 0 2.5 Mabsadd L
.47632 .28037 1.875 0 Mabsadd L
.47632 .28037 0 -2.5 Mabsadd L
.47632 .28037 -1.875 0 Mabsadd L closepath F
.47764 .28164 -1.875 0 Mabsadd m
.47764 .28164 0 2.5 Mabsadd L
.47764 .28164 1.875 0 Mabsadd L
.47764 .28164 0 -2.5 Mabsadd L
.47764 .28164 -1.875 0 Mabsadd L closepath F
.47764 .2829 -1.875 0 Mabsadd m
.47764 .2829 0 2.5 Mabsadd L
.47764 .2829 1.875 0 Mabsadd L
.47764 .2829 0 -2.5 Mabsadd L
.47764 .2829 -1.875 0 Mabsadd L closepath F
.47895 .28416 -1.875 0 Mabsadd m
.47895 .28416 0 2.5 Mabsadd L
.47895 .28416 1.875 0 Mabsadd L
.47895 .28416 0 -2.5 Mabsadd L
.47895 .28416 -1.875 0 Mabsadd L closepath F
.47895 .28542 -1.875 0 Mabsadd m
.47895 .28542 0 2.5 Mabsadd L
.47895 .28542 1.875 0 Mabsadd L
.47895 .28542 0 -2.5 Mabsadd L
.47895 .28542 -1.875 0 Mabsadd L closepath F
.48158 .28668 -1.875 0 Mabsadd m
.48158 .28668 0 2.5 Mabsadd L
.48158 .28668 1.875 0 Mabsadd L
.48158 .28668 0 -2.5 Mabsadd L
.48158 .28668 -1.875 0 Mabsadd L closepath F
.4829 .28793 -1.875 0 Mabsadd m
.4829 .28793 0 2.5 Mabsadd L
.4829 .28793 1.875 0 Mabsadd L
.4829 .28793 0 -2.5 Mabsadd L
.4829 .28793 -1.875 0 Mabsadd L closepath F
.48553 .28918 -1.875 0 Mabsadd m
.48553 .28918 0 2.5 Mabsadd L
.48553 .28918 1.875 0 Mabsadd L
.48553 .28918 0 -2.5 Mabsadd L
.48553 .28918 -1.875 0 Mabsadd L closepath F
.48685 .29042 -1.875 0 Mabsadd m
.48685 .29042 0 2.5 Mabsadd L
.48685 .29042 1.875 0 Mabsadd L
.48685 .29042 0 -2.5 Mabsadd L
.48685 .29042 -1.875 0 Mabsadd L closepath F
.48685 .29166 -1.875 0 Mabsadd m
.48685 .29166 0 2.5 Mabsadd L
.48685 .29166 1.875 0 Mabsadd L
.48685 .29166 0 -2.5 Mabsadd L
.48685 .29166 -1.875 0 Mabsadd L closepath F
.48948 .2929 -1.875 0 Mabsadd m
.48948 .2929 0 2.5 Mabsadd L
.48948 .2929 1.875 0 Mabsadd L
.48948 .2929 0 -2.5 Mabsadd L
.48948 .2929 -1.875 0 Mabsadd L closepath F
.49211 .29414 -1.875 0 Mabsadd m
.49211 .29414 0 2.5 Mabsadd L
.49211 .29414 1.875 0 Mabsadd L
.49211 .29414 0 -2.5 Mabsadd L
.49211 .29414 -1.875 0 Mabsadd L closepath F
.49474 .29537 -1.875 0 Mabsadd m
.49474 .29537 0 2.5 Mabsadd L
.49474 .29537 1.875 0 Mabsadd L
.49474 .29537 0 -2.5 Mabsadd L
.49474 .29537 -1.875 0 Mabsadd L closepath F
.49605 .2966 -1.875 0 Mabsadd m
.49605 .2966 0 2.5 Mabsadd L
.49605 .2966 1.875 0 Mabsadd L
.49605 .2966 0 -2.5 Mabsadd L
.49605 .2966 -1.875 0 Mabsadd L closepath F
.49737 .29783 -1.875 0 Mabsadd m
.49737 .29783 0 2.5 Mabsadd L
.49737 .29783 1.875 0 Mabsadd L
.49737 .29783 0 -2.5 Mabsadd L
.49737 .29783 -1.875 0 Mabsadd L closepath F
.50132 .29905 -1.875 0 Mabsadd m
.50132 .29905 0 2.5 Mabsadd L
.50132 .29905 1.875 0 Mabsadd L
.50132 .29905 0 -2.5 Mabsadd L
.50132 .29905 -1.875 0 Mabsadd L closepath F
.50921 .30027 -1.875 0 Mabsadd m
.50921 .30027 0 2.5 Mabsadd L
.50921 .30027 1.875 0 Mabsadd L
.50921 .30027 0 -2.5 Mabsadd L
.50921 .30027 -1.875 0 Mabsadd L closepath F
.50921 .30149 -1.875 0 Mabsadd m
.50921 .30149 0 2.5 Mabsadd L
.50921 .30149 1.875 0 Mabsadd L
.50921 .30149 0 -2.5 Mabsadd L
.50921 .30149 -1.875 0 Mabsadd L closepath F
.51052 .3027 -1.875 0 Mabsadd m
.51052 .3027 0 2.5 Mabsadd L
.51052 .3027 1.875 0 Mabsadd L
.51052 .3027 0 -2.5 Mabsadd L
.51052 .3027 -1.875 0 Mabsadd L closepath F
.51184 .30391 -1.875 0 Mabsadd m
.51184 .30391 0 2.5 Mabsadd L
.51184 .30391 1.875 0 Mabsadd L
.51184 .30391 0 -2.5 Mabsadd L
.51184 .30391 -1.875 0 Mabsadd L closepath F
.51579 .30512 -1.875 0 Mabsadd m
.51579 .30512 0 2.5 Mabsadd L
.51579 .30512 1.875 0 Mabsadd L
.51579 .30512 0 -2.5 Mabsadd L
.51579 .30512 -1.875 0 Mabsadd L closepath F
.52105 .30632 -1.875 0 Mabsadd m
.52105 .30632 0 2.5 Mabsadd L
.52105 .30632 1.875 0 Mabsadd L
.52105 .30632 0 -2.5 Mabsadd L
.52105 .30632 -1.875 0 Mabsadd L closepath F
.52368 .30753 -1.875 0 Mabsadd m
.52368 .30753 0 2.5 Mabsadd L
.52368 .30753 1.875 0 Mabsadd L
.52368 .30753 0 -2.5 Mabsadd L
.52368 .30753 -1.875 0 Mabsadd L closepath F
.52499 .30872 -1.875 0 Mabsadd m
.52499 .30872 0 2.5 Mabsadd L
.52499 .30872 1.875 0 Mabsadd L
.52499 .30872 0 -2.5 Mabsadd L
.52499 .30872 -1.875 0 Mabsadd L closepath F
.52894 .30992 -1.875 0 Mabsadd m
.52894 .30992 0 2.5 Mabsadd L
.52894 .30992 1.875 0 Mabsadd L
.52894 .30992 0 -2.5 Mabsadd L
.52894 .30992 -1.875 0 Mabsadd L closepath F
.52894 .31111 -1.875 0 Mabsadd m
.52894 .31111 0 2.5 Mabsadd L
.52894 .31111 1.875 0 Mabsadd L
.52894 .31111 0 -2.5 Mabsadd L
.52894 .31111 -1.875 0 Mabsadd L closepath F
.52894 .3123 -1.875 0 Mabsadd m
.52894 .3123 0 2.5 Mabsadd L
.52894 .3123 1.875 0 Mabsadd L
.52894 .3123 0 -2.5 Mabsadd L
.52894 .3123 -1.875 0 Mabsadd L closepath F
.53157 .31349 -1.875 0 Mabsadd m
.53157 .31349 0 2.5 Mabsadd L
.53157 .31349 1.875 0 Mabsadd L
.53157 .31349 0 -2.5 Mabsadd L
.53157 .31349 -1.875 0 Mabsadd L closepath F
.53552 .31467 -1.875 0 Mabsadd m
.53552 .31467 0 2.5 Mabsadd L
.53552 .31467 1.875 0 Mabsadd L
.53552 .31467 0 -2.5 Mabsadd L
.53552 .31467 -1.875 0 Mabsadd L closepath F
.53946 .31585 -1.875 0 Mabsadd m
.53946 .31585 0 2.5 Mabsadd L
.53946 .31585 1.875 0 Mabsadd L
.53946 .31585 0 -2.5 Mabsadd L
.53946 .31585 -1.875 0 Mabsadd L closepath F
.53946 .31703 -1.875 0 Mabsadd m
.53946 .31703 0 2.5 Mabsadd L
.53946 .31703 1.875 0 Mabsadd L
.53946 .31703 0 -2.5 Mabsadd L
.53946 .31703 -1.875 0 Mabsadd L closepath F
.54078 .31821 -1.875 0 Mabsadd m
.54078 .31821 0 2.5 Mabsadd L
.54078 .31821 1.875 0 Mabsadd L
.54078 .31821 0 -2.5 Mabsadd L
.54078 .31821 -1.875 0 Mabsadd L closepath F
.54341 .31938 -1.875 0 Mabsadd m
.54341 .31938 0 2.5 Mabsadd L
.54341 .31938 1.875 0 Mabsadd L
.54341 .31938 0 -2.5 Mabsadd L
.54341 .31938 -1.875 0 Mabsadd L closepath F
.54473 .32055 -1.875 0 Mabsadd m
.54473 .32055 0 2.5 Mabsadd L
.54473 .32055 1.875 0 Mabsadd L
.54473 .32055 0 -2.5 Mabsadd L
.54473 .32055 -1.875 0 Mabsadd L closepath F
.54604 .32171 -1.875 0 Mabsadd m
.54604 .32171 0 2.5 Mabsadd L
.54604 .32171 1.875 0 Mabsadd L
.54604 .32171 0 -2.5 Mabsadd L
.54604 .32171 -1.875 0 Mabsadd L closepath F
.5513 .32287 -1.875 0 Mabsadd m
.5513 .32287 0 2.5 Mabsadd L
.5513 .32287 1.875 0 Mabsadd L
.5513 .32287 0 -2.5 Mabsadd L
.5513 .32287 -1.875 0 Mabsadd L closepath F
.55525 .32403 -1.875 0 Mabsadd m
.55525 .32403 0 2.5 Mabsadd L
.55525 .32403 1.875 0 Mabsadd L
.55525 .32403 0 -2.5 Mabsadd L
.55525 .32403 -1.875 0 Mabsadd L closepath F
.55525 .32519 -1.875 0 Mabsadd m
.55525 .32519 0 2.5 Mabsadd L
.55525 .32519 1.875 0 Mabsadd L
.55525 .32519 0 -2.5 Mabsadd L
.55525 .32519 -1.875 0 Mabsadd L closepath F
.55656 .32634 -1.875 0 Mabsadd m
.55656 .32634 0 2.5 Mabsadd L
.55656 .32634 1.875 0 Mabsadd L
.55656 .32634 0 -2.5 Mabsadd L
.55656 .32634 -1.875 0 Mabsadd L closepath F
.55656 .32749 -1.875 0 Mabsadd m
.55656 .32749 0 2.5 Mabsadd L
.55656 .32749 1.875 0 Mabsadd L
.55656 .32749 0 -2.5 Mabsadd L
.55656 .32749 -1.875 0 Mabsadd L closepath F
.55656 .32864 -1.875 0 Mabsadd m
.55656 .32864 0 2.5 Mabsadd L
.55656 .32864 1.875 0 Mabsadd L
.55656 .32864 0 -2.5 Mabsadd L
.55656 .32864 -1.875 0 Mabsadd L closepath F
.55919 .32979 -1.875 0 Mabsadd m
.55919 .32979 0 2.5 Mabsadd L
.55919 .32979 1.875 0 Mabsadd L
.55919 .32979 0 -2.5 Mabsadd L
.55919 .32979 -1.875 0 Mabsadd L closepath F
.56446 .33093 -1.875 0 Mabsadd m
.56446 .33093 0 2.5 Mabsadd L
.56446 .33093 1.875 0 Mabsadd L
.56446 .33093 0 -2.5 Mabsadd L
.56446 .33093 -1.875 0 Mabsadd L closepath F
.56709 .33207 -1.875 0 Mabsadd m
.56709 .33207 0 2.5 Mabsadd L
.56709 .33207 1.875 0 Mabsadd L
.56709 .33207 0 -2.5 Mabsadd L
.56709 .33207 -1.875 0 Mabsadd L closepath F
.56972 .3332 -1.875 0 Mabsadd m
.56972 .3332 0 2.5 Mabsadd L
.56972 .3332 1.875 0 Mabsadd L
.56972 .3332 0 -2.5 Mabsadd L
.56972 .3332 -1.875 0 Mabsadd L closepath F
.57366 .33434 -1.875 0 Mabsadd m
.57366 .33434 0 2.5 Mabsadd L
.57366 .33434 1.875 0 Mabsadd L
.57366 .33434 0 -2.5 Mabsadd L
.57366 .33434 -1.875 0 Mabsadd L closepath F
.5763 .33547 -1.875 0 Mabsadd m
.5763 .33547 0 2.5 Mabsadd L
.5763 .33547 1.875 0 Mabsadd L
.5763 .33547 0 -2.5 Mabsadd L
.5763 .33547 -1.875 0 Mabsadd L closepath F
.57761 .33659 -1.875 0 Mabsadd m
.57761 .33659 0 2.5 Mabsadd L
.57761 .33659 1.875 0 Mabsadd L
.57761 .33659 0 -2.5 Mabsadd L
.57761 .33659 -1.875 0 Mabsadd L closepath F
.57761 .33772 -1.875 0 Mabsadd m
.57761 .33772 0 2.5 Mabsadd L
.57761 .33772 1.875 0 Mabsadd L
.57761 .33772 0 -2.5 Mabsadd L
.57761 .33772 -1.875 0 Mabsadd L closepath F
.58024 .33884 -1.875 0 Mabsadd m
.58024 .33884 0 2.5 Mabsadd L
.58024 .33884 1.875 0 Mabsadd L
.58024 .33884 0 -2.5 Mabsadd L
.58024 .33884 -1.875 0 Mabsadd L closepath F
.58024 .33996 -1.875 0 Mabsadd m
.58024 .33996 0 2.5 Mabsadd L
.58024 .33996 1.875 0 Mabsadd L
.58024 .33996 0 -2.5 Mabsadd L
.58024 .33996 -1.875 0 Mabsadd L closepath F
.58024 .34107 -1.875 0 Mabsadd m
.58024 .34107 0 2.5 Mabsadd L
.58024 .34107 1.875 0 Mabsadd L
.58024 .34107 0 -2.5 Mabsadd L
.58024 .34107 -1.875 0 Mabsadd L closepath F
.58156 .34219 -1.875 0 Mabsadd m
.58156 .34219 0 2.5 Mabsadd L
.58156 .34219 1.875 0 Mabsadd L
.58156 .34219 0 -2.5 Mabsadd L
.58156 .34219 -1.875 0 Mabsadd L closepath F
.58287 .3433 -1.875 0 Mabsadd m
.58287 .3433 0 2.5 Mabsadd L
.58287 .3433 1.875 0 Mabsadd L
.58287 .3433 0 -2.5 Mabsadd L
.58287 .3433 -1.875 0 Mabsadd L closepath F
.5855 .3444 -1.875 0 Mabsadd m
.5855 .3444 0 2.5 Mabsadd L
.5855 .3444 1.875 0 Mabsadd L
.5855 .3444 0 -2.5 Mabsadd L
.5855 .3444 -1.875 0 Mabsadd L closepath F
.58813 .34551 -1.875 0 Mabsadd m
.58813 .34551 0 2.5 Mabsadd L
.58813 .34551 1.875 0 Mabsadd L
.58813 .34551 0 -2.5 Mabsadd L
.58813 .34551 -1.875 0 Mabsadd L closepath F
.58945 .34661 -1.875 0 Mabsadd m
.58945 .34661 0 2.5 Mabsadd L
.58945 .34661 1.875 0 Mabsadd L
.58945 .34661 0 -2.5 Mabsadd L
.58945 .34661 -1.875 0 Mabsadd L closepath F
.59077 .34771 -1.875 0 Mabsadd m
.59077 .34771 0 2.5 Mabsadd L
.59077 .34771 1.875 0 Mabsadd L
.59077 .34771 0 -2.5 Mabsadd L
.59077 .34771 -1.875 0 Mabsadd L closepath F
.59077 .3488 -1.875 0 Mabsadd m
.59077 .3488 0 2.5 Mabsadd L
.59077 .3488 1.875 0 Mabsadd L
.59077 .3488 0 -2.5 Mabsadd L
.59077 .3488 -1.875 0 Mabsadd L closepath F
.59471 .3499 -1.875 0 Mabsadd m
.59471 .3499 0 2.5 Mabsadd L
.59471 .3499 1.875 0 Mabsadd L
.59471 .3499 0 -2.5 Mabsadd L
.59471 .3499 -1.875 0 Mabsadd L closepath F
.59471 .35099 -1.875 0 Mabsadd m
.59471 .35099 0 2.5 Mabsadd L
.59471 .35099 1.875 0 Mabsadd L
.59471 .35099 0 -2.5 Mabsadd L
.59471 .35099 -1.875 0 Mabsadd L closepath F
.59471 .35207 -1.875 0 Mabsadd m
.59471 .35207 0 2.5 Mabsadd L
.59471 .35207 1.875 0 Mabsadd L
.59471 .35207 0 -2.5 Mabsadd L
.59471 .35207 -1.875 0 Mabsadd L closepath F
.59471 .35316 -1.875 0 Mabsadd m
.59471 .35316 0 2.5 Mabsadd L
.59471 .35316 1.875 0 Mabsadd L
.59471 .35316 0 -2.5 Mabsadd L
.59471 .35316 -1.875 0 Mabsadd L closepath F
.59603 .35424 -1.875 0 Mabsadd m
.59603 .35424 0 2.5 Mabsadd L
.59603 .35424 1.875 0 Mabsadd L
.59603 .35424 0 -2.5 Mabsadd L
.59603 .35424 -1.875 0 Mabsadd L closepath F
.59997 .35532 -1.875 0 Mabsadd m
.59997 .35532 0 2.5 Mabsadd L
.59997 .35532 1.875 0 Mabsadd L
.59997 .35532 0 -2.5 Mabsadd L
.59997 .35532 -1.875 0 Mabsadd L closepath F
.60392 .35639 -1.875 0 Mabsadd m
.60392 .35639 0 2.5 Mabsadd L
.60392 .35639 1.875 0 Mabsadd L
.60392 .35639 0 -2.5 Mabsadd L
.60392 .35639 -1.875 0 Mabsadd L closepath F
.60524 .35747 -1.875 0 Mabsadd m
.60524 .35747 0 2.5 Mabsadd L
.60524 .35747 1.875 0 Mabsadd L
.60524 .35747 0 -2.5 Mabsadd L
.60524 .35747 -1.875 0 Mabsadd L closepath F
.60655 .35854 -1.875 0 Mabsadd m
.60655 .35854 0 2.5 Mabsadd L
.60655 .35854 1.875 0 Mabsadd L
.60655 .35854 0 -2.5 Mabsadd L
.60655 .35854 -1.875 0 Mabsadd L closepath F
.60918 .35961 -1.875 0 Mabsadd m
.60918 .35961 0 2.5 Mabsadd L
.60918 .35961 1.875 0 Mabsadd L
.60918 .35961 0 -2.5 Mabsadd L
.60918 .35961 -1.875 0 Mabsadd L closepath F
.60918 .36067 -1.875 0 Mabsadd m
.60918 .36067 0 2.5 Mabsadd L
.60918 .36067 1.875 0 Mabsadd L
.60918 .36067 0 -2.5 Mabsadd L
.60918 .36067 -1.875 0 Mabsadd L closepath F
.6105 .36173 -1.875 0 Mabsadd m
.6105 .36173 0 2.5 Mabsadd L
.6105 .36173 1.875 0 Mabsadd L
.6105 .36173 0 -2.5 Mabsadd L
.6105 .36173 -1.875 0 Mabsadd L closepath F
.61444 .36279 -1.875 0 Mabsadd m
.61444 .36279 0 2.5 Mabsadd L
.61444 .36279 1.875 0 Mabsadd L
.61444 .36279 0 -2.5 Mabsadd L
.61444 .36279 -1.875 0 Mabsadd L closepath F
.61707 .36385 -1.875 0 Mabsadd m
.61707 .36385 0 2.5 Mabsadd L
.61707 .36385 1.875 0 Mabsadd L
.61707 .36385 0 -2.5 Mabsadd L
.61707 .36385 -1.875 0 Mabsadd L closepath F
.61707 .3649 -1.875 0 Mabsadd m
.61707 .3649 0 2.5 Mabsadd L
.61707 .3649 1.875 0 Mabsadd L
.61707 .3649 0 -2.5 Mabsadd L
.61707 .3649 -1.875 0 Mabsadd L closepath F
.61707 .36595 -1.875 0 Mabsadd m
.61707 .36595 0 2.5 Mabsadd L
.61707 .36595 1.875 0 Mabsadd L
.61707 .36595 0 -2.5 Mabsadd L
.61707 .36595 -1.875 0 Mabsadd L closepath F
.61707 .367 -1.875 0 Mabsadd m
.61707 .367 0 2.5 Mabsadd L
.61707 .367 1.875 0 Mabsadd L
.61707 .367 0 -2.5 Mabsadd L
.61707 .367 -1.875 0 Mabsadd L closepath F
.61839 .36804 -1.875 0 Mabsadd m
.61839 .36804 0 2.5 Mabsadd L
.61839 .36804 1.875 0 Mabsadd L
.61839 .36804 0 -2.5 Mabsadd L
.61839 .36804 -1.875 0 Mabsadd L closepath F
.62102 .36909 -1.875 0 Mabsadd m
.62102 .36909 0 2.5 Mabsadd L
.62102 .36909 1.875 0 Mabsadd L
.62102 .36909 0 -2.5 Mabsadd L
.62102 .36909 -1.875 0 Mabsadd L closepath F
.62497 .37013 -1.875 0 Mabsadd m
.62497 .37013 0 2.5 Mabsadd L
.62497 .37013 1.875 0 Mabsadd L
.62497 .37013 0 -2.5 Mabsadd L
.62497 .37013 -1.875 0 Mabsadd L closepath F
.62497 .37116 -1.875 0 Mabsadd m
.62497 .37116 0 2.5 Mabsadd L
.62497 .37116 1.875 0 Mabsadd L
.62497 .37116 0 -2.5 Mabsadd L
.62497 .37116 -1.875 0 Mabsadd L closepath F
.6276 .3722 -1.875 0 Mabsadd m
.6276 .3722 0 2.5 Mabsadd L
.6276 .3722 1.875 0 Mabsadd L
.6276 .3722 0 -2.5 Mabsadd L
.6276 .3722 -1.875 0 Mabsadd L closepath F
.62891 .37323 -1.875 0 Mabsadd m
.62891 .37323 0 2.5 Mabsadd L
.62891 .37323 1.875 0 Mabsadd L
.62891 .37323 0 -2.5 Mabsadd L
.62891 .37323 -1.875 0 Mabsadd L closepath F
.63023 .37426 -1.875 0 Mabsadd m
.63023 .37426 0 2.5 Mabsadd L
.63023 .37426 1.875 0 Mabsadd L
.63023 .37426 0 -2.5 Mabsadd L
.63023 .37426 -1.875 0 Mabsadd L closepath F
.63286 .37528 -1.875 0 Mabsadd m
.63286 .37528 0 2.5 Mabsadd L
.63286 .37528 1.875 0 Mabsadd L
.63286 .37528 0 -2.5 Mabsadd L
.63286 .37528 -1.875 0 Mabsadd L closepath F
.63418 .37631 -1.875 0 Mabsadd m
.63418 .37631 0 2.5 Mabsadd L
.63418 .37631 1.875 0 Mabsadd L
.63418 .37631 0 -2.5 Mabsadd L
.63418 .37631 -1.875 0 Mabsadd L closepath F
.63549 .37733 -1.875 0 Mabsadd m
.63549 .37733 0 2.5 Mabsadd L
.63549 .37733 1.875 0 Mabsadd L
.63549 .37733 0 -2.5 Mabsadd L
.63549 .37733 -1.875 0 Mabsadd L closepath F
.63681 .37835 -1.875 0 Mabsadd m
.63681 .37835 0 2.5 Mabsadd L
.63681 .37835 1.875 0 Mabsadd L
.63681 .37835 0 -2.5 Mabsadd L
.63681 .37835 -1.875 0 Mabsadd L closepath F
.64075 .37936 -1.875 0 Mabsadd m
.64075 .37936 0 2.5 Mabsadd L
.64075 .37936 1.875 0 Mabsadd L
.64075 .37936 0 -2.5 Mabsadd L
.64075 .37936 -1.875 0 Mabsadd L closepath F
.6447 .38037 -1.875 0 Mabsadd m
.6447 .38037 0 2.5 Mabsadd L
.6447 .38037 1.875 0 Mabsadd L
.6447 .38037 0 -2.5 Mabsadd L
.6447 .38037 -1.875 0 Mabsadd L closepath F
.6447 .38138 -1.875 0 Mabsadd m
.6447 .38138 0 2.5 Mabsadd L
.6447 .38138 1.875 0 Mabsadd L
.6447 .38138 0 -2.5 Mabsadd L
.6447 .38138 -1.875 0 Mabsadd L closepath F
.64733 .38239 -1.875 0 Mabsadd m
.64733 .38239 0 2.5 Mabsadd L
.64733 .38239 1.875 0 Mabsadd L
.64733 .38239 0 -2.5 Mabsadd L
.64733 .38239 -1.875 0 Mabsadd L closepath F
.64865 .38339 -1.875 0 Mabsadd m
.64865 .38339 0 2.5 Mabsadd L
.64865 .38339 1.875 0 Mabsadd L
.64865 .38339 0 -2.5 Mabsadd L
.64865 .38339 -1.875 0 Mabsadd L closepath F
.65259 .3844 -1.875 0 Mabsadd m
.65259 .3844 0 2.5 Mabsadd L
.65259 .3844 1.875 0 Mabsadd L
.65259 .3844 0 -2.5 Mabsadd L
.65259 .3844 -1.875 0 Mabsadd L closepath F
.65391 .38539 -1.875 0 Mabsadd m
.65391 .38539 0 2.5 Mabsadd L
.65391 .38539 1.875 0 Mabsadd L
.65391 .38539 0 -2.5 Mabsadd L
.65391 .38539 -1.875 0 Mabsadd L closepath F
.65522 .38639 -1.875 0 Mabsadd m
.65522 .38639 0 2.5 Mabsadd L
.65522 .38639 1.875 0 Mabsadd L
.65522 .38639 0 -2.5 Mabsadd L
.65522 .38639 -1.875 0 Mabsadd L closepath F
.65917 .38738 -1.875 0 Mabsadd m
.65917 .38738 0 2.5 Mabsadd L
.65917 .38738 1.875 0 Mabsadd L
.65917 .38738 0 -2.5 Mabsadd L
.65917 .38738 -1.875 0 Mabsadd L closepath F
.65917 .38837 -1.875 0 Mabsadd m
.65917 .38837 0 2.5 Mabsadd L
.65917 .38837 1.875 0 Mabsadd L
.65917 .38837 0 -2.5 Mabsadd L
.65917 .38837 -1.875 0 Mabsadd L closepath F
.6618 .38936 -1.875 0 Mabsadd m
.6618 .38936 0 2.5 Mabsadd L
.6618 .38936 1.875 0 Mabsadd L
.6618 .38936 0 -2.5 Mabsadd L
.6618 .38936 -1.875 0 Mabsadd L closepath F
.66311 .39035 -1.875 0 Mabsadd m
.66311 .39035 0 2.5 Mabsadd L
.66311 .39035 1.875 0 Mabsadd L
.66311 .39035 0 -2.5 Mabsadd L
.66311 .39035 -1.875 0 Mabsadd L closepath F
.66443 .39133 -1.875 0 Mabsadd m
.66443 .39133 0 2.5 Mabsadd L
.66443 .39133 1.875 0 Mabsadd L
.66443 .39133 0 -2.5 Mabsadd L
.66443 .39133 -1.875 0 Mabsadd L closepath F
.66706 .39231 -1.875 0 Mabsadd m
.66706 .39231 0 2.5 Mabsadd L
.66706 .39231 1.875 0 Mabsadd L
.66706 .39231 0 -2.5 Mabsadd L
.66706 .39231 -1.875 0 Mabsadd L closepath F
.66706 .39329 -1.875 0 Mabsadd m
.66706 .39329 0 2.5 Mabsadd L
.66706 .39329 1.875 0 Mabsadd L
.66706 .39329 0 -2.5 Mabsadd L
.66706 .39329 -1.875 0 Mabsadd L closepath F
.66706 .39426 -1.875 0 Mabsadd m
.66706 .39426 0 2.5 Mabsadd L
.66706 .39426 1.875 0 Mabsadd L
.66706 .39426 0 -2.5 Mabsadd L
.66706 .39426 -1.875 0 Mabsadd L closepath F
.66838 .39524 -1.875 0 Mabsadd m
.66838 .39524 0 2.5 Mabsadd L
.66838 .39524 1.875 0 Mabsadd L
.66838 .39524 0 -2.5 Mabsadd L
.66838 .39524 -1.875 0 Mabsadd L closepath F
.66969 .3962 -1.875 0 Mabsadd m
.66969 .3962 0 2.5 Mabsadd L
.66969 .3962 1.875 0 Mabsadd L
.66969 .3962 0 -2.5 Mabsadd L
.66969 .3962 -1.875 0 Mabsadd L closepath F
.67101 .39717 -1.875 0 Mabsadd m
.67101 .39717 0 2.5 Mabsadd L
.67101 .39717 1.875 0 Mabsadd L
.67101 .39717 0 -2.5 Mabsadd L
.67101 .39717 -1.875 0 Mabsadd L closepath F
.67101 .39814 -1.875 0 Mabsadd m
.67101 .39814 0 2.5 Mabsadd L
.67101 .39814 1.875 0 Mabsadd L
.67101 .39814 0 -2.5 Mabsadd L
.67101 .39814 -1.875 0 Mabsadd L closepath F
.67232 .3991 -1.875 0 Mabsadd m
.67232 .3991 0 2.5 Mabsadd L
.67232 .3991 1.875 0 Mabsadd L
.67232 .3991 0 -2.5 Mabsadd L
.67232 .3991 -1.875 0 Mabsadd L closepath F
.67232 .40006 -1.875 0 Mabsadd m
.67232 .40006 0 2.5 Mabsadd L
.67232 .40006 1.875 0 Mabsadd L
.67232 .40006 0 -2.5 Mabsadd L
.67232 .40006 -1.875 0 Mabsadd L closepath F
.67232 .40101 -1.875 0 Mabsadd m
.67232 .40101 0 2.5 Mabsadd L
.67232 .40101 1.875 0 Mabsadd L
.67232 .40101 0 -2.5 Mabsadd L
.67232 .40101 -1.875 0 Mabsadd L closepath F
.67232 .40197 -1.875 0 Mabsadd m
.67232 .40197 0 2.5 Mabsadd L
.67232 .40197 1.875 0 Mabsadd L
.67232 .40197 0 -2.5 Mabsadd L
.67232 .40197 -1.875 0 Mabsadd L closepath F
.67232 .40292 -1.875 0 Mabsadd m
.67232 .40292 0 2.5 Mabsadd L
.67232 .40292 1.875 0 Mabsadd L
.67232 .40292 0 -2.5 Mabsadd L
.67232 .40292 -1.875 0 Mabsadd L closepath F
.67232 .40387 -1.875 0 Mabsadd m
.67232 .40387 0 2.5 Mabsadd L
.67232 .40387 1.875 0 Mabsadd L
.67232 .40387 0 -2.5 Mabsadd L
.67232 .40387 -1.875 0 Mabsadd L closepath F
.67364 .40481 -1.875 0 Mabsadd m
.67364 .40481 0 2.5 Mabsadd L
.67364 .40481 1.875 0 Mabsadd L
.67364 .40481 0 -2.5 Mabsadd L
.67364 .40481 -1.875 0 Mabsadd L closepath F
.67364 .40576 -1.875 0 Mabsadd m
.67364 .40576 0 2.5 Mabsadd L
.67364 .40576 1.875 0 Mabsadd L
.67364 .40576 0 -2.5 Mabsadd L
.67364 .40576 -1.875 0 Mabsadd L closepath F
.67495 .4067 -1.875 0 Mabsadd m
.67495 .4067 0 2.5 Mabsadd L
.67495 .4067 1.875 0 Mabsadd L
.67495 .4067 0 -2.5 Mabsadd L
.67495 .4067 -1.875 0 Mabsadd L closepath F
.67627 .40763 -1.875 0 Mabsadd m
.67627 .40763 0 2.5 Mabsadd L
.67627 .40763 1.875 0 Mabsadd L
.67627 .40763 0 -2.5 Mabsadd L
.67627 .40763 -1.875 0 Mabsadd L closepath F
.67758 .40857 -1.875 0 Mabsadd m
.67758 .40857 0 2.5 Mabsadd L
.67758 .40857 1.875 0 Mabsadd L
.67758 .40857 0 -2.5 Mabsadd L
.67758 .40857 -1.875 0 Mabsadd L closepath F
.6789 .4095 -1.875 0 Mabsadd m
.6789 .4095 0 2.5 Mabsadd L
.6789 .4095 1.875 0 Mabsadd L
.6789 .4095 0 -2.5 Mabsadd L
.6789 .4095 -1.875 0 Mabsadd L closepath F
.6789 .41043 -1.875 0 Mabsadd m
.6789 .41043 0 2.5 Mabsadd L
.6789 .41043 1.875 0 Mabsadd L
.6789 .41043 0 -2.5 Mabsadd L
.6789 .41043 -1.875 0 Mabsadd L closepath F
.68285 .41136 -1.875 0 Mabsadd m
.68285 .41136 0 2.5 Mabsadd L
.68285 .41136 1.875 0 Mabsadd L
.68285 .41136 0 -2.5 Mabsadd L
.68285 .41136 -1.875 0 Mabsadd L closepath F
.68285 .41229 -1.875 0 Mabsadd m
.68285 .41229 0 2.5 Mabsadd L
.68285 .41229 1.875 0 Mabsadd L
.68285 .41229 0 -2.5 Mabsadd L
.68285 .41229 -1.875 0 Mabsadd L closepath F
.68548 .41321 -1.875 0 Mabsadd m
.68548 .41321 0 2.5 Mabsadd L
.68548 .41321 1.875 0 Mabsadd L
.68548 .41321 0 -2.5 Mabsadd L
.68548 .41321 -1.875 0 Mabsadd L closepath F
.68548 .41413 -1.875 0 Mabsadd m
.68548 .41413 0 2.5 Mabsadd L
.68548 .41413 1.875 0 Mabsadd L
.68548 .41413 0 -2.5 Mabsadd L
.68548 .41413 -1.875 0 Mabsadd L closepath F
.68548 .41504 -1.875 0 Mabsadd m
.68548 .41504 0 2.5 Mabsadd L
.68548 .41504 1.875 0 Mabsadd L
.68548 .41504 0 -2.5 Mabsadd L
.68548 .41504 -1.875 0 Mabsadd L closepath F
.68679 .41596 -1.875 0 Mabsadd m
.68679 .41596 0 2.5 Mabsadd L
.68679 .41596 1.875 0 Mabsadd L
.68679 .41596 0 -2.5 Mabsadd L
.68679 .41596 -1.875 0 Mabsadd L closepath F
.68679 .41687 -1.875 0 Mabsadd m
.68679 .41687 0 2.5 Mabsadd L
.68679 .41687 1.875 0 Mabsadd L
.68679 .41687 0 -2.5 Mabsadd L
.68679 .41687 -1.875 0 Mabsadd L closepath F
.68679 .41778 -1.875 0 Mabsadd m
.68679 .41778 0 2.5 Mabsadd L
.68679 .41778 1.875 0 Mabsadd L
.68679 .41778 0 -2.5 Mabsadd L
.68679 .41778 -1.875 0 Mabsadd L closepath F
.68679 .41869 -1.875 0 Mabsadd m
.68679 .41869 0 2.5 Mabsadd L
.68679 .41869 1.875 0 Mabsadd L
.68679 .41869 0 -2.5 Mabsadd L
.68679 .41869 -1.875 0 Mabsadd L closepath F
.68942 .41959 -1.875 0 Mabsadd m
.68942 .41959 0 2.5 Mabsadd L
.68942 .41959 1.875 0 Mabsadd L
.68942 .41959 0 -2.5 Mabsadd L
.68942 .41959 -1.875 0 Mabsadd L closepath F
.69074 .4205 -1.875 0 Mabsadd m
.69074 .4205 0 2.5 Mabsadd L
.69074 .4205 1.875 0 Mabsadd L
.69074 .4205 0 -2.5 Mabsadd L
.69074 .4205 -1.875 0 Mabsadd L closepath F
.69337 .42139 -1.875 0 Mabsadd m
.69337 .42139 0 2.5 Mabsadd L
.69337 .42139 1.875 0 Mabsadd L
.69337 .42139 0 -2.5 Mabsadd L
.69337 .42139 -1.875 0 Mabsadd L closepath F
.69337 .42229 -1.875 0 Mabsadd m
.69337 .42229 0 2.5 Mabsadd L
.69337 .42229 1.875 0 Mabsadd L
.69337 .42229 0 -2.5 Mabsadd L
.69337 .42229 -1.875 0 Mabsadd L closepath F
.69337 .42319 -1.875 0 Mabsadd m
.69337 .42319 0 2.5 Mabsadd L
.69337 .42319 1.875 0 Mabsadd L
.69337 .42319 0 -2.5 Mabsadd L
.69337 .42319 -1.875 0 Mabsadd L closepath F
.69469 .42408 -1.875 0 Mabsadd m
.69469 .42408 0 2.5 Mabsadd L
.69469 .42408 1.875 0 Mabsadd L
.69469 .42408 0 -2.5 Mabsadd L
.69469 .42408 -1.875 0 Mabsadd L closepath F
.69732 .42497 -1.875 0 Mabsadd m
.69732 .42497 0 2.5 Mabsadd L
.69732 .42497 1.875 0 Mabsadd L
.69732 .42497 0 -2.5 Mabsadd L
.69732 .42497 -1.875 0 Mabsadd L closepath F
.69732 .42585 -1.875 0 Mabsadd m
.69732 .42585 0 2.5 Mabsadd L
.69732 .42585 1.875 0 Mabsadd L
.69732 .42585 0 -2.5 Mabsadd L
.69732 .42585 -1.875 0 Mabsadd L closepath F
.69863 .42674 -1.875 0 Mabsadd m
.69863 .42674 0 2.5 Mabsadd L
.69863 .42674 1.875 0 Mabsadd L
.69863 .42674 0 -2.5 Mabsadd L
.69863 .42674 -1.875 0 Mabsadd L closepath F
.69863 .42762 -1.875 0 Mabsadd m
.69863 .42762 0 2.5 Mabsadd L
.69863 .42762 1.875 0 Mabsadd L
.69863 .42762 0 -2.5 Mabsadd L
.69863 .42762 -1.875 0 Mabsadd L closepath F
.69995 .4285 -1.875 0 Mabsadd m
.69995 .4285 0 2.5 Mabsadd L
.69995 .4285 1.875 0 Mabsadd L
.69995 .4285 0 -2.5 Mabsadd L
.69995 .4285 -1.875 0 Mabsadd L closepath F
.70126 .42938 -1.875 0 Mabsadd m
.70126 .42938 0 2.5 Mabsadd L
.70126 .42938 1.875 0 Mabsadd L
.70126 .42938 0 -2.5 Mabsadd L
.70126 .42938 -1.875 0 Mabsadd L closepath F
.70126 .43025 -1.875 0 Mabsadd m
.70126 .43025 0 2.5 Mabsadd L
.70126 .43025 1.875 0 Mabsadd L
.70126 .43025 0 -2.5 Mabsadd L
.70126 .43025 -1.875 0 Mabsadd L closepath F
.70258 .43112 -1.875 0 Mabsadd m
.70258 .43112 0 2.5 Mabsadd L
.70258 .43112 1.875 0 Mabsadd L
.70258 .43112 0 -2.5 Mabsadd L
.70258 .43112 -1.875 0 Mabsadd L closepath F
.70389 .43199 -1.875 0 Mabsadd m
.70389 .43199 0 2.5 Mabsadd L
.70389 .43199 1.875 0 Mabsadd L
.70389 .43199 0 -2.5 Mabsadd L
.70389 .43199 -1.875 0 Mabsadd L closepath F
.70389 .43286 -1.875 0 Mabsadd m
.70389 .43286 0 2.5 Mabsadd L
.70389 .43286 1.875 0 Mabsadd L
.70389 .43286 0 -2.5 Mabsadd L
.70389 .43286 -1.875 0 Mabsadd L closepath F
.70652 .43372 -1.875 0 Mabsadd m
.70652 .43372 0 2.5 Mabsadd L
.70652 .43372 1.875 0 Mabsadd L
.70652 .43372 0 -2.5 Mabsadd L
.70652 .43372 -1.875 0 Mabsadd L closepath F
.70652 .43458 -1.875 0 Mabsadd m
.70652 .43458 0 2.5 Mabsadd L
.70652 .43458 1.875 0 Mabsadd L
.70652 .43458 0 -2.5 Mabsadd L
.70652 .43458 -1.875 0 Mabsadd L closepath F
.70652 .43544 -1.875 0 Mabsadd m
.70652 .43544 0 2.5 Mabsadd L
.70652 .43544 1.875 0 Mabsadd L
.70652 .43544 0 -2.5 Mabsadd L
.70652 .43544 -1.875 0 Mabsadd L closepath F
.70652 .4363 -1.875 0 Mabsadd m
.70652 .4363 0 2.5 Mabsadd L
.70652 .4363 1.875 0 Mabsadd L
.70652 .4363 0 -2.5 Mabsadd L
.70652 .4363 -1.875 0 Mabsadd L closepath F
.70652 .43715 -1.875 0 Mabsadd m
.70652 .43715 0 2.5 Mabsadd L
.70652 .43715 1.875 0 Mabsadd L
.70652 .43715 0 -2.5 Mabsadd L
.70652 .43715 -1.875 0 Mabsadd L closepath F
.70784 .438 -1.875 0 Mabsadd m
.70784 .438 0 2.5 Mabsadd L
.70784 .438 1.875 0 Mabsadd L
.70784 .438 0 -2.5 Mabsadd L
.70784 .438 -1.875 0 Mabsadd L closepath F
.70784 .43885 -1.875 0 Mabsadd m
.70784 .43885 0 2.5 Mabsadd L
.70784 .43885 1.875 0 Mabsadd L
.70784 .43885 0 -2.5 Mabsadd L
.70784 .43885 -1.875 0 Mabsadd L closepath F
.70784 .4397 -1.875 0 Mabsadd m
.70784 .4397 0 2.5 Mabsadd L
.70784 .4397 1.875 0 Mabsadd L
.70784 .4397 0 -2.5 Mabsadd L
.70784 .4397 -1.875 0 Mabsadd L closepath F
.70784 .44054 -1.875 0 Mabsadd m
.70784 .44054 0 2.5 Mabsadd L
.70784 .44054 1.875 0 Mabsadd L
.70784 .44054 0 -2.5 Mabsadd L
.70784 .44054 -1.875 0 Mabsadd L closepath F
.71047 .44139 -1.875 0 Mabsadd m
.71047 .44139 0 2.5 Mabsadd L
.71047 .44139 1.875 0 Mabsadd L
.71047 .44139 0 -2.5 Mabsadd L
.71047 .44139 -1.875 0 Mabsadd L closepath F
.71179 .44223 -1.875 0 Mabsadd m
.71179 .44223 0 2.5 Mabsadd L
.71179 .44223 1.875 0 Mabsadd L
.71179 .44223 0 -2.5 Mabsadd L
.71179 .44223 -1.875 0 Mabsadd L closepath F
.7131 .44306 -1.875 0 Mabsadd m
.7131 .44306 0 2.5 Mabsadd L
.7131 .44306 1.875 0 Mabsadd L
.7131 .44306 0 -2.5 Mabsadd L
.7131 .44306 -1.875 0 Mabsadd L closepath F
.71442 .4439 -1.875 0 Mabsadd m
.71442 .4439 0 2.5 Mabsadd L
.71442 .4439 1.875 0 Mabsadd L
.71442 .4439 0 -2.5 Mabsadd L
.71442 .4439 -1.875 0 Mabsadd L closepath F
.71705 .44473 -1.875 0 Mabsadd m
.71705 .44473 0 2.5 Mabsadd L
.71705 .44473 1.875 0 Mabsadd L
.71705 .44473 0 -2.5 Mabsadd L
.71705 .44473 -1.875 0 Mabsadd L closepath F
.72099 .44556 -1.875 0 Mabsadd m
.72099 .44556 0 2.5 Mabsadd L
.72099 .44556 1.875 0 Mabsadd L
.72099 .44556 0 -2.5 Mabsadd L
.72099 .44556 -1.875 0 Mabsadd L closepath F
.72099 .44638 -1.875 0 Mabsadd m
.72099 .44638 0 2.5 Mabsadd L
.72099 .44638 1.875 0 Mabsadd L
.72099 .44638 0 -2.5 Mabsadd L
.72099 .44638 -1.875 0 Mabsadd L closepath F
.72099 .44721 -1.875 0 Mabsadd m
.72099 .44721 0 2.5 Mabsadd L
.72099 .44721 1.875 0 Mabsadd L
.72099 .44721 0 -2.5 Mabsadd L
.72099 .44721 -1.875 0 Mabsadd L closepath F
.72099 .44803 -1.875 0 Mabsadd m
.72099 .44803 0 2.5 Mabsadd L
.72099 .44803 1.875 0 Mabsadd L
.72099 .44803 0 -2.5 Mabsadd L
.72099 .44803 -1.875 0 Mabsadd L closepath F
.72099 .44885 -1.875 0 Mabsadd m
.72099 .44885 0 2.5 Mabsadd L
.72099 .44885 1.875 0 Mabsadd L
.72099 .44885 0 -2.5 Mabsadd L
.72099 .44885 -1.875 0 Mabsadd L closepath F
.72099 .44967 -1.875 0 Mabsadd m
.72099 .44967 0 2.5 Mabsadd L
.72099 .44967 1.875 0 Mabsadd L
.72099 .44967 0 -2.5 Mabsadd L
.72099 .44967 -1.875 0 Mabsadd L closepath F
.72099 .45048 -1.875 0 Mabsadd m
.72099 .45048 0 2.5 Mabsadd L
.72099 .45048 1.875 0 Mabsadd L
.72099 .45048 0 -2.5 Mabsadd L
.72099 .45048 -1.875 0 Mabsadd L closepath F
.72231 .45129 -1.875 0 Mabsadd m
.72231 .45129 0 2.5 Mabsadd L
.72231 .45129 1.875 0 Mabsadd L
.72231 .45129 0 -2.5 Mabsadd L
.72231 .45129 -1.875 0 Mabsadd L closepath F
.72231 .4521 -1.875 0 Mabsadd m
.72231 .4521 0 2.5 Mabsadd L
.72231 .4521 1.875 0 Mabsadd L
.72231 .4521 0 -2.5 Mabsadd L
.72231 .4521 -1.875 0 Mabsadd L closepath F
.72231 .45291 -1.875 0 Mabsadd m
.72231 .45291 0 2.5 Mabsadd L
.72231 .45291 1.875 0 Mabsadd L
.72231 .45291 0 -2.5 Mabsadd L
.72231 .45291 -1.875 0 Mabsadd L closepath F
.72363 .45372 -1.875 0 Mabsadd m
.72363 .45372 0 2.5 Mabsadd L
.72363 .45372 1.875 0 Mabsadd L
.72363 .45372 0 -2.5 Mabsadd L
.72363 .45372 -1.875 0 Mabsadd L closepath F
.72363 .45452 -1.875 0 Mabsadd m
.72363 .45452 0 2.5 Mabsadd L
.72363 .45452 1.875 0 Mabsadd L
.72363 .45452 0 -2.5 Mabsadd L
.72363 .45452 -1.875 0 Mabsadd L closepath F
.72494 .45532 -1.875 0 Mabsadd m
.72494 .45532 0 2.5 Mabsadd L
.72494 .45532 1.875 0 Mabsadd L
.72494 .45532 0 -2.5 Mabsadd L
.72494 .45532 -1.875 0 Mabsadd L closepath F
.72757 .45612 -1.875 0 Mabsadd m
.72757 .45612 0 2.5 Mabsadd L
.72757 .45612 1.875 0 Mabsadd L
.72757 .45612 0 -2.5 Mabsadd L
.72757 .45612 -1.875 0 Mabsadd L closepath F
.7302 .45691 -1.875 0 Mabsadd m
.7302 .45691 0 2.5 Mabsadd L
.7302 .45691 1.875 0 Mabsadd L
.7302 .45691 0 -2.5 Mabsadd L
.7302 .45691 -1.875 0 Mabsadd L closepath F
.73152 .45771 -1.875 0 Mabsadd m
.73152 .45771 0 2.5 Mabsadd L
.73152 .45771 1.875 0 Mabsadd L
.73152 .45771 0 -2.5 Mabsadd L
.73152 .45771 -1.875 0 Mabsadd L closepath F
.73152 .4585 -1.875 0 Mabsadd m
.73152 .4585 0 2.5 Mabsadd L
.73152 .4585 1.875 0 Mabsadd L
.73152 .4585 0 -2.5 Mabsadd L
.73152 .4585 -1.875 0 Mabsadd L closepath F
.73152 .45928 -1.875 0 Mabsadd m
.73152 .45928 0 2.5 Mabsadd L
.73152 .45928 1.875 0 Mabsadd L
.73152 .45928 0 -2.5 Mabsadd L
.73152 .45928 -1.875 0 Mabsadd L closepath F
.73283 .46007 -1.875 0 Mabsadd m
.73283 .46007 0 2.5 Mabsadd L
.73283 .46007 1.875 0 Mabsadd L
.73283 .46007 0 -2.5 Mabsadd L
.73283 .46007 -1.875 0 Mabsadd L closepath F
.73415 .46085 -1.875 0 Mabsadd m
.73415 .46085 0 2.5 Mabsadd L
.73415 .46085 1.875 0 Mabsadd L
.73415 .46085 0 -2.5 Mabsadd L
.73415 .46085 -1.875 0 Mabsadd L closepath F
.7381 .46163 -1.875 0 Mabsadd m
.7381 .46163 0 2.5 Mabsadd L
.7381 .46163 1.875 0 Mabsadd L
.7381 .46163 0 -2.5 Mabsadd L
.7381 .46163 -1.875 0 Mabsadd L closepath F
.7381 .46241 -1.875 0 Mabsadd m
.7381 .46241 0 2.5 Mabsadd L
.7381 .46241 1.875 0 Mabsadd L
.7381 .46241 0 -2.5 Mabsadd L
.7381 .46241 -1.875 0 Mabsadd L closepath F
.73941 .46319 -1.875 0 Mabsadd m
.73941 .46319 0 2.5 Mabsadd L
.73941 .46319 1.875 0 Mabsadd L
.73941 .46319 0 -2.5 Mabsadd L
.73941 .46319 -1.875 0 Mabsadd L closepath F
.74073 .46396 -1.875 0 Mabsadd m
.74073 .46396 0 2.5 Mabsadd L
.74073 .46396 1.875 0 Mabsadd L
.74073 .46396 0 -2.5 Mabsadd L
.74073 .46396 -1.875 0 Mabsadd L closepath F
.74073 .46473 -1.875 0 Mabsadd m
.74073 .46473 0 2.5 Mabsadd L
.74073 .46473 1.875 0 Mabsadd L
.74073 .46473 0 -2.5 Mabsadd L
.74073 .46473 -1.875 0 Mabsadd L closepath F
.74073 .4655 -1.875 0 Mabsadd m
.74073 .4655 0 2.5 Mabsadd L
.74073 .4655 1.875 0 Mabsadd L
.74073 .4655 0 -2.5 Mabsadd L
.74073 .4655 -1.875 0 Mabsadd L closepath F
.74336 .46627 -1.875 0 Mabsadd m
.74336 .46627 0 2.5 Mabsadd L
.74336 .46627 1.875 0 Mabsadd L
.74336 .46627 0 -2.5 Mabsadd L
.74336 .46627 -1.875 0 Mabsadd L closepath F
.74467 .46703 -1.875 0 Mabsadd m
.74467 .46703 0 2.5 Mabsadd L
.74467 .46703 1.875 0 Mabsadd L
.74467 .46703 0 -2.5 Mabsadd L
.74467 .46703 -1.875 0 Mabsadd L closepath F
.74467 .46779 -1.875 0 Mabsadd m
.74467 .46779 0 2.5 Mabsadd L
.74467 .46779 1.875 0 Mabsadd L
.74467 .46779 0 -2.5 Mabsadd L
.74467 .46779 -1.875 0 Mabsadd L closepath F
.74467 .46855 -1.875 0 Mabsadd m
.74467 .46855 0 2.5 Mabsadd L
.74467 .46855 1.875 0 Mabsadd L
.74467 .46855 0 -2.5 Mabsadd L
.74467 .46855 -1.875 0 Mabsadd L closepath F
.74599 .46931 -1.875 0 Mabsadd m
.74599 .46931 0 2.5 Mabsadd L
.74599 .46931 1.875 0 Mabsadd L
.74599 .46931 0 -2.5 Mabsadd L
.74599 .46931 -1.875 0 Mabsadd L closepath F
.7473 .47006 -1.875 0 Mabsadd m
.7473 .47006 0 2.5 Mabsadd L
.7473 .47006 1.875 0 Mabsadd L
.7473 .47006 0 -2.5 Mabsadd L
.7473 .47006 -1.875 0 Mabsadd L closepath F
.74862 .47082 -1.875 0 Mabsadd m
.74862 .47082 0 2.5 Mabsadd L
.74862 .47082 1.875 0 Mabsadd L
.74862 .47082 0 -2.5 Mabsadd L
.74862 .47082 -1.875 0 Mabsadd L closepath F
.74993 .47157 -1.875 0 Mabsadd m
.74993 .47157 0 2.5 Mabsadd L
.74993 .47157 1.875 0 Mabsadd L
.74993 .47157 0 -2.5 Mabsadd L
.74993 .47157 -1.875 0 Mabsadd L closepath F
.75125 .47231 -1.875 0 Mabsadd m
.75125 .47231 0 2.5 Mabsadd L
.75125 .47231 1.875 0 Mabsadd L
.75125 .47231 0 -2.5 Mabsadd L
.75125 .47231 -1.875 0 Mabsadd L closepath F
.75257 .47306 -1.875 0 Mabsadd m
.75257 .47306 0 2.5 Mabsadd L
.75257 .47306 1.875 0 Mabsadd L
.75257 .47306 0 -2.5 Mabsadd L
.75257 .47306 -1.875 0 Mabsadd L closepath F
.75651 .4738 -1.875 0 Mabsadd m
.75651 .4738 0 2.5 Mabsadd L
.75651 .4738 1.875 0 Mabsadd L
.75651 .4738 0 -2.5 Mabsadd L
.75651 .4738 -1.875 0 Mabsadd L closepath F
.75914 .47454 -1.875 0 Mabsadd m
.75914 .47454 0 2.5 Mabsadd L
.75914 .47454 1.875 0 Mabsadd L
.75914 .47454 0 -2.5 Mabsadd L
.75914 .47454 -1.875 0 Mabsadd L closepath F
.76046 .47528 -1.875 0 Mabsadd m
.76046 .47528 0 2.5 Mabsadd L
.76046 .47528 1.875 0 Mabsadd L
.76046 .47528 0 -2.5 Mabsadd L
.76046 .47528 -1.875 0 Mabsadd L closepath F
.76046 .47602 -1.875 0 Mabsadd m
.76046 .47602 0 2.5 Mabsadd L
.76046 .47602 1.875 0 Mabsadd L
.76046 .47602 0 -2.5 Mabsadd L
.76046 .47602 -1.875 0 Mabsadd L closepath F
.76177 .47675 -1.875 0 Mabsadd m
.76177 .47675 0 2.5 Mabsadd L
.76177 .47675 1.875 0 Mabsadd L
.76177 .47675 0 -2.5 Mabsadd L
.76177 .47675 -1.875 0 Mabsadd L closepath F
.76177 .47748 -1.875 0 Mabsadd m
.76177 .47748 0 2.5 Mabsadd L
.76177 .47748 1.875 0 Mabsadd L
.76177 .47748 0 -2.5 Mabsadd L
.76177 .47748 -1.875 0 Mabsadd L closepath F
.7644 .47821 -1.875 0 Mabsadd m
.7644 .47821 0 2.5 Mabsadd L
.7644 .47821 1.875 0 Mabsadd L
.7644 .47821 0 -2.5 Mabsadd L
.7644 .47821 -1.875 0 Mabsadd L closepath F
.76572 .47893 -1.875 0 Mabsadd m
.76572 .47893 0 2.5 Mabsadd L
.76572 .47893 1.875 0 Mabsadd L
.76572 .47893 0 -2.5 Mabsadd L
.76572 .47893 -1.875 0 Mabsadd L closepath F
.76572 .47966 -1.875 0 Mabsadd m
.76572 .47966 0 2.5 Mabsadd L
.76572 .47966 1.875 0 Mabsadd L
.76572 .47966 0 -2.5 Mabsadd L
.76572 .47966 -1.875 0 Mabsadd L closepath F
.76703 .48038 -1.875 0 Mabsadd m
.76703 .48038 0 2.5 Mabsadd L
.76703 .48038 1.875 0 Mabsadd L
.76703 .48038 0 -2.5 Mabsadd L
.76703 .48038 -1.875 0 Mabsadd L closepath F
.77098 .4811 -1.875 0 Mabsadd m
.77098 .4811 0 2.5 Mabsadd L
.77098 .4811 1.875 0 Mabsadd L
.77098 .4811 0 -2.5 Mabsadd L
.77098 .4811 -1.875 0 Mabsadd L closepath F
.7723 .48182 -1.875 0 Mabsadd m
.7723 .48182 0 2.5 Mabsadd L
.7723 .48182 1.875 0 Mabsadd L
.7723 .48182 0 -2.5 Mabsadd L
.7723 .48182 -1.875 0 Mabsadd L closepath F
.77493 .48253 -1.875 0 Mabsadd m
.77493 .48253 0 2.5 Mabsadd L
.77493 .48253 1.875 0 Mabsadd L
.77493 .48253 0 -2.5 Mabsadd L
.77493 .48253 -1.875 0 Mabsadd L closepath F
.77756 .48324 -1.875 0 Mabsadd m
.77756 .48324 0 2.5 Mabsadd L
.77756 .48324 1.875 0 Mabsadd L
.77756 .48324 0 -2.5 Mabsadd L
.77756 .48324 -1.875 0 Mabsadd L closepath F
.77756 .48395 -1.875 0 Mabsadd m
.77756 .48395 0 2.5 Mabsadd L
.77756 .48395 1.875 0 Mabsadd L
.77756 .48395 0 -2.5 Mabsadd L
.77756 .48395 -1.875 0 Mabsadd L closepath F
.77756 .48466 -1.875 0 Mabsadd m
.77756 .48466 0 2.5 Mabsadd L
.77756 .48466 1.875 0 Mabsadd L
.77756 .48466 0 -2.5 Mabsadd L
.77756 .48466 -1.875 0 Mabsadd L closepath F
.77756 .48537 -1.875 0 Mabsadd m
.77756 .48537 0 2.5 Mabsadd L
.77756 .48537 1.875 0 Mabsadd L
.77756 .48537 0 -2.5 Mabsadd L
.77756 .48537 -1.875 0 Mabsadd L closepath F
.77756 .48607 -1.875 0 Mabsadd m
.77756 .48607 0 2.5 Mabsadd L
.77756 .48607 1.875 0 Mabsadd L
.77756 .48607 0 -2.5 Mabsadd L
.77756 .48607 -1.875 0 Mabsadd L closepath F
.77887 .48677 -1.875 0 Mabsadd m
.77887 .48677 0 2.5 Mabsadd L
.77887 .48677 1.875 0 Mabsadd L
.77887 .48677 0 -2.5 Mabsadd L
.77887 .48677 -1.875 0 Mabsadd L closepath F
.77887 .48747 -1.875 0 Mabsadd m
.77887 .48747 0 2.5 Mabsadd L
.77887 .48747 1.875 0 Mabsadd L
.77887 .48747 0 -2.5 Mabsadd L
.77887 .48747 -1.875 0 Mabsadd L closepath F
.78019 .48816 -1.875 0 Mabsadd m
.78019 .48816 0 2.5 Mabsadd L
.78019 .48816 1.875 0 Mabsadd L
.78019 .48816 0 -2.5 Mabsadd L
.78019 .48816 -1.875 0 Mabsadd L closepath F
.7815 .48886 -1.875 0 Mabsadd m
.7815 .48886 0 2.5 Mabsadd L
.7815 .48886 1.875 0 Mabsadd L
.7815 .48886 0 -2.5 Mabsadd L
.7815 .48886 -1.875 0 Mabsadd L closepath F
.7815 .48955 -1.875 0 Mabsadd m
.7815 .48955 0 2.5 Mabsadd L
.7815 .48955 1.875 0 Mabsadd L
.7815 .48955 0 -2.5 Mabsadd L
.7815 .48955 -1.875 0 Mabsadd L closepath F
.7815 .49024 -1.875 0 Mabsadd m
.7815 .49024 0 2.5 Mabsadd L
.7815 .49024 1.875 0 Mabsadd L
.7815 .49024 0 -2.5 Mabsadd L
.7815 .49024 -1.875 0 Mabsadd L closepath F
.78414 .49093 -1.875 0 Mabsadd m
.78414 .49093 0 2.5 Mabsadd L
.78414 .49093 1.875 0 Mabsadd L
.78414 .49093 0 -2.5 Mabsadd L
.78414 .49093 -1.875 0 Mabsadd L closepath F
.78414 .49161 -1.875 0 Mabsadd m
.78414 .49161 0 2.5 Mabsadd L
.78414 .49161 1.875 0 Mabsadd L
.78414 .49161 0 -2.5 Mabsadd L
.78414 .49161 -1.875 0 Mabsadd L closepath F
.78545 .49229 -1.875 0 Mabsadd m
.78545 .49229 0 2.5 Mabsadd L
.78545 .49229 1.875 0 Mabsadd L
.78545 .49229 0 -2.5 Mabsadd L
.78545 .49229 -1.875 0 Mabsadd L closepath F
.78677 .49297 -1.875 0 Mabsadd m
.78677 .49297 0 2.5 Mabsadd L
.78677 .49297 1.875 0 Mabsadd L
.78677 .49297 0 -2.5 Mabsadd L
.78677 .49297 -1.875 0 Mabsadd L closepath F
.78677 .49365 -1.875 0 Mabsadd m
.78677 .49365 0 2.5 Mabsadd L
.78677 .49365 1.875 0 Mabsadd L
.78677 .49365 0 -2.5 Mabsadd L
.78677 .49365 -1.875 0 Mabsadd L closepath F
.78677 .49433 -1.875 0 Mabsadd m
.78677 .49433 0 2.5 Mabsadd L
.78677 .49433 1.875 0 Mabsadd L
.78677 .49433 0 -2.5 Mabsadd L
.78677 .49433 -1.875 0 Mabsadd L closepath F
.78808 .495 -1.875 0 Mabsadd m
.78808 .495 0 2.5 Mabsadd L
.78808 .495 1.875 0 Mabsadd L
.78808 .495 0 -2.5 Mabsadd L
.78808 .495 -1.875 0 Mabsadd L closepath F
.7894 .49567 -1.875 0 Mabsadd m
.7894 .49567 0 2.5 Mabsadd L
.7894 .49567 1.875 0 Mabsadd L
.7894 .49567 0 -2.5 Mabsadd L
.7894 .49567 -1.875 0 Mabsadd L closepath F
.7894 .49634 -1.875 0 Mabsadd m
.7894 .49634 0 2.5 Mabsadd L
.7894 .49634 1.875 0 Mabsadd L
.7894 .49634 0 -2.5 Mabsadd L
.7894 .49634 -1.875 0 Mabsadd L closepath F
.7894 .497 -1.875 0 Mabsadd m
.7894 .497 0 2.5 Mabsadd L
.7894 .497 1.875 0 Mabsadd L
.7894 .497 0 -2.5 Mabsadd L
.7894 .497 -1.875 0 Mabsadd L closepath F
.7894 .49767 -1.875 0 Mabsadd m
.7894 .49767 0 2.5 Mabsadd L
.7894 .49767 1.875 0 Mabsadd L
.7894 .49767 0 -2.5 Mabsadd L
.7894 .49767 -1.875 0 Mabsadd L closepath F
.79203 .49833 -1.875 0 Mabsadd m
.79203 .49833 0 2.5 Mabsadd L
.79203 .49833 1.875 0 Mabsadd L
.79203 .49833 0 -2.5 Mabsadd L
.79203 .49833 -1.875 0 Mabsadd L closepath F
.79334 .49899 -1.875 0 Mabsadd m
.79334 .49899 0 2.5 Mabsadd L
.79334 .49899 1.875 0 Mabsadd L
.79334 .49899 0 -2.5 Mabsadd L
.79334 .49899 -1.875 0 Mabsadd L closepath F
.79334 .49965 -1.875 0 Mabsadd m
.79334 .49965 0 2.5 Mabsadd L
.79334 .49965 1.875 0 Mabsadd L
.79334 .49965 0 -2.5 Mabsadd L
.79334 .49965 -1.875 0 Mabsadd L closepath F
.79597 .5003 -1.875 0 Mabsadd m
.79597 .5003 0 2.5 Mabsadd L
.79597 .5003 1.875 0 Mabsadd L
.79597 .5003 0 -2.5 Mabsadd L
.79597 .5003 -1.875 0 Mabsadd L closepath F
.79729 .50095 -1.875 0 Mabsadd m
.79729 .50095 0 2.5 Mabsadd L
.79729 .50095 1.875 0 Mabsadd L
.79729 .50095 0 -2.5 Mabsadd L
.79729 .50095 -1.875 0 Mabsadd L closepath F
.79861 .5016 -1.875 0 Mabsadd m
.79861 .5016 0 2.5 Mabsadd L
.79861 .5016 1.875 0 Mabsadd L
.79861 .5016 0 -2.5 Mabsadd L
.79861 .5016 -1.875 0 Mabsadd L closepath F
.79992 .50225 -1.875 0 Mabsadd m
.79992 .50225 0 2.5 Mabsadd L
.79992 .50225 1.875 0 Mabsadd L
.79992 .50225 0 -2.5 Mabsadd L
.79992 .50225 -1.875 0 Mabsadd L closepath F
.80124 .5029 -1.875 0 Mabsadd m
.80124 .5029 0 2.5 Mabsadd L
.80124 .5029 1.875 0 Mabsadd L
.80124 .5029 0 -2.5 Mabsadd L
.80124 .5029 -1.875 0 Mabsadd L closepath F
.80124 .50354 -1.875 0 Mabsadd m
.80124 .50354 0 2.5 Mabsadd L
.80124 .50354 1.875 0 Mabsadd L
.80124 .50354 0 -2.5 Mabsadd L
.80124 .50354 -1.875 0 Mabsadd L closepath F
.80124 .50418 -1.875 0 Mabsadd m
.80124 .50418 0 2.5 Mabsadd L
.80124 .50418 1.875 0 Mabsadd L
.80124 .50418 0 -2.5 Mabsadd L
.80124 .50418 -1.875 0 Mabsadd L closepath F
.80255 .50482 -1.875 0 Mabsadd m
.80255 .50482 0 2.5 Mabsadd L
.80255 .50482 1.875 0 Mabsadd L
.80255 .50482 0 -2.5 Mabsadd L
.80255 .50482 -1.875 0 Mabsadd L closepath F
.8065 .50546 -1.875 0 Mabsadd m
.8065 .50546 0 2.5 Mabsadd L
.8065 .50546 1.875 0 Mabsadd L
.8065 .50546 0 -2.5 Mabsadd L
.8065 .50546 -1.875 0 Mabsadd L closepath F
.8065 .50609 -1.875 0 Mabsadd m
.8065 .50609 0 2.5 Mabsadd L
.8065 .50609 1.875 0 Mabsadd L
.8065 .50609 0 -2.5 Mabsadd L
.8065 .50609 -1.875 0 Mabsadd L closepath F
.80781 .50673 -1.875 0 Mabsadd m
.80781 .50673 0 2.5 Mabsadd L
.80781 .50673 1.875 0 Mabsadd L
.80781 .50673 0 -2.5 Mabsadd L
.80781 .50673 -1.875 0 Mabsadd L closepath F
.80913 .50736 -1.875 0 Mabsadd m
.80913 .50736 0 2.5 Mabsadd L
.80913 .50736 1.875 0 Mabsadd L
.80913 .50736 0 -2.5 Mabsadd L
.80913 .50736 -1.875 0 Mabsadd L closepath F
.81044 .50798 -1.875 0 Mabsadd m
.81044 .50798 0 2.5 Mabsadd L
.81044 .50798 1.875 0 Mabsadd L
.81044 .50798 0 -2.5 Mabsadd L
.81044 .50798 -1.875 0 Mabsadd L closepath F
.81176 .50861 -1.875 0 Mabsadd m
.81176 .50861 0 2.5 Mabsadd L
.81176 .50861 1.875 0 Mabsadd L
.81176 .50861 0 -2.5 Mabsadd L
.81176 .50861 -1.875 0 Mabsadd L closepath F
.81176 .50923 -1.875 0 Mabsadd m
.81176 .50923 0 2.5 Mabsadd L
.81176 .50923 1.875 0 Mabsadd L
.81176 .50923 0 -2.5 Mabsadd L
.81176 .50923 -1.875 0 Mabsadd L closepath F
.81176 .50985 -1.875 0 Mabsadd m
.81176 .50985 0 2.5 Mabsadd L
.81176 .50985 1.875 0 Mabsadd L
.81176 .50985 0 -2.5 Mabsadd L
.81176 .50985 -1.875 0 Mabsadd L closepath F
.81308 .51047 -1.875 0 Mabsadd m
.81308 .51047 0 2.5 Mabsadd L
.81308 .51047 1.875 0 Mabsadd L
.81308 .51047 0 -2.5 Mabsadd L
.81308 .51047 -1.875 0 Mabsadd L closepath F
.81308 .51109 -1.875 0 Mabsadd m
.81308 .51109 0 2.5 Mabsadd L
.81308 .51109 1.875 0 Mabsadd L
.81308 .51109 0 -2.5 Mabsadd L
.81308 .51109 -1.875 0 Mabsadd L closepath F
.81439 .5117 -1.875 0 Mabsadd m
.81439 .5117 0 2.5 Mabsadd L
.81439 .5117 1.875 0 Mabsadd L
.81439 .5117 0 -2.5 Mabsadd L
.81439 .5117 -1.875 0 Mabsadd L closepath F
.81571 .51232 -1.875 0 Mabsadd m
.81571 .51232 0 2.5 Mabsadd L
.81571 .51232 1.875 0 Mabsadd L
.81571 .51232 0 -2.5 Mabsadd L
.81571 .51232 -1.875 0 Mabsadd L closepath F
.81571 .51293 -1.875 0 Mabsadd m
.81571 .51293 0 2.5 Mabsadd L
.81571 .51293 1.875 0 Mabsadd L
.81571 .51293 0 -2.5 Mabsadd L
.81571 .51293 -1.875 0 Mabsadd L closepath F
.81571 .51354 -1.875 0 Mabsadd m
.81571 .51354 0 2.5 Mabsadd L
.81571 .51354 1.875 0 Mabsadd L
.81571 .51354 0 -2.5 Mabsadd L
.81571 .51354 -1.875 0 Mabsadd L closepath F
.81571 .51414 -1.875 0 Mabsadd m
.81571 .51414 0 2.5 Mabsadd L
.81571 .51414 1.875 0 Mabsadd L
.81571 .51414 0 -2.5 Mabsadd L
.81571 .51414 -1.875 0 Mabsadd L closepath F
.81571 .51474 -1.875 0 Mabsadd m
.81571 .51474 0 2.5 Mabsadd L
.81571 .51474 1.875 0 Mabsadd L
.81571 .51474 0 -2.5 Mabsadd L
.81571 .51474 -1.875 0 Mabsadd L closepath F
.81702 .51535 -1.875 0 Mabsadd m
.81702 .51535 0 2.5 Mabsadd L
.81702 .51535 1.875 0 Mabsadd L
.81702 .51535 0 -2.5 Mabsadd L
.81702 .51535 -1.875 0 Mabsadd L closepath F
.81965 .51594 -1.875 0 Mabsadd m
.81965 .51594 0 2.5 Mabsadd L
.81965 .51594 1.875 0 Mabsadd L
.81965 .51594 0 -2.5 Mabsadd L
.81965 .51594 -1.875 0 Mabsadd L closepath F
.82097 .51654 -1.875 0 Mabsadd m
.82097 .51654 0 2.5 Mabsadd L
.82097 .51654 1.875 0 Mabsadd L
.82097 .51654 0 -2.5 Mabsadd L
.82097 .51654 -1.875 0 Mabsadd L closepath F
.82491 .51714 -1.875 0 Mabsadd m
.82491 .51714 0 2.5 Mabsadd L
.82491 .51714 1.875 0 Mabsadd L
.82491 .51714 0 -2.5 Mabsadd L
.82491 .51714 -1.875 0 Mabsadd L closepath F
.82623 .51773 -1.875 0 Mabsadd m
.82623 .51773 0 2.5 Mabsadd L
.82623 .51773 1.875 0 Mabsadd L
.82623 .51773 0 -2.5 Mabsadd L
.82623 .51773 -1.875 0 Mabsadd L closepath F
.82623 .51832 -1.875 0 Mabsadd m
.82623 .51832 0 2.5 Mabsadd L
.82623 .51832 1.875 0 Mabsadd L
.82623 .51832 0 -2.5 Mabsadd L
.82623 .51832 -1.875 0 Mabsadd L closepath F
.82623 .51891 -1.875 0 Mabsadd m
.82623 .51891 0 2.5 Mabsadd L
.82623 .51891 1.875 0 Mabsadd L
.82623 .51891 0 -2.5 Mabsadd L
.82623 .51891 -1.875 0 Mabsadd L closepath F
.82623 .51949 -1.875 0 Mabsadd m
.82623 .51949 0 2.5 Mabsadd L
.82623 .51949 1.875 0 Mabsadd L
.82623 .51949 0 -2.5 Mabsadd L
.82623 .51949 -1.875 0 Mabsadd L closepath F
.82623 .52007 -1.875 0 Mabsadd m
.82623 .52007 0 2.5 Mabsadd L
.82623 .52007 1.875 0 Mabsadd L
.82623 .52007 0 -2.5 Mabsadd L
.82623 .52007 -1.875 0 Mabsadd L closepath F
.82623 .52066 -1.875 0 Mabsadd m
.82623 .52066 0 2.5 Mabsadd L
.82623 .52066 1.875 0 Mabsadd L
.82623 .52066 0 -2.5 Mabsadd L
.82623 .52066 -1.875 0 Mabsadd L closepath F
.82623 .52124 -1.875 0 Mabsadd m
.82623 .52124 0 2.5 Mabsadd L
.82623 .52124 1.875 0 Mabsadd L
.82623 .52124 0 -2.5 Mabsadd L
.82623 .52124 -1.875 0 Mabsadd L closepath F
.82623 .52181 -1.875 0 Mabsadd m
.82623 .52181 0 2.5 Mabsadd L
.82623 .52181 1.875 0 Mabsadd L
.82623 .52181 0 -2.5 Mabsadd L
.82623 .52181 -1.875 0 Mabsadd L closepath F
.82623 .52239 -1.875 0 Mabsadd m
.82623 .52239 0 2.5 Mabsadd L
.82623 .52239 1.875 0 Mabsadd L
.82623 .52239 0 -2.5 Mabsadd L
.82623 .52239 -1.875 0 Mabsadd L closepath F
.82755 .52296 -1.875 0 Mabsadd m
.82755 .52296 0 2.5 Mabsadd L
.82755 .52296 1.875 0 Mabsadd L
.82755 .52296 0 -2.5 Mabsadd L
.82755 .52296 -1.875 0 Mabsadd L closepath F
.83018 .52353 -1.875 0 Mabsadd m
.83018 .52353 0 2.5 Mabsadd L
.83018 .52353 1.875 0 Mabsadd L
.83018 .52353 0 -2.5 Mabsadd L
.83018 .52353 -1.875 0 Mabsadd L closepath F
.83018 .5241 -1.875 0 Mabsadd m
.83018 .5241 0 2.5 Mabsadd L
.83018 .5241 1.875 0 Mabsadd L
.83018 .5241 0 -2.5 Mabsadd L
.83018 .5241 -1.875 0 Mabsadd L closepath F
.83018 .52466 -1.875 0 Mabsadd m
.83018 .52466 0 2.5 Mabsadd L
.83018 .52466 1.875 0 Mabsadd L
.83018 .52466 0 -2.5 Mabsadd L
.83018 .52466 -1.875 0 Mabsadd L closepath F
.83018 .52523 -1.875 0 Mabsadd m
.83018 .52523 0 2.5 Mabsadd L
.83018 .52523 1.875 0 Mabsadd L
.83018 .52523 0 -2.5 Mabsadd L
.83018 .52523 -1.875 0 Mabsadd L closepath F
.83149 .52579 -1.875 0 Mabsadd m
.83149 .52579 0 2.5 Mabsadd L
.83149 .52579 1.875 0 Mabsadd L
.83149 .52579 0 -2.5 Mabsadd L
.83149 .52579 -1.875 0 Mabsadd L closepath F
.83149 .52635 -1.875 0 Mabsadd m
.83149 .52635 0 2.5 Mabsadd L
.83149 .52635 1.875 0 Mabsadd L
.83149 .52635 0 -2.5 Mabsadd L
.83149 .52635 -1.875 0 Mabsadd L closepath F
.83149 .52691 -1.875 0 Mabsadd m
.83149 .52691 0 2.5 Mabsadd L
.83149 .52691 1.875 0 Mabsadd L
.83149 .52691 0 -2.5 Mabsadd L
.83149 .52691 -1.875 0 Mabsadd L closepath F
.83149 .52746 -1.875 0 Mabsadd m
.83149 .52746 0 2.5 Mabsadd L
.83149 .52746 1.875 0 Mabsadd L
.83149 .52746 0 -2.5 Mabsadd L
.83149 .52746 -1.875 0 Mabsadd L closepath F
.83281 .52801 -1.875 0 Mabsadd m
.83281 .52801 0 2.5 Mabsadd L
.83281 .52801 1.875 0 Mabsadd L
.83281 .52801 0 -2.5 Mabsadd L
.83281 .52801 -1.875 0 Mabsadd L closepath F
.83281 .52856 -1.875 0 Mabsadd m
.83281 .52856 0 2.5 Mabsadd L
.83281 .52856 1.875 0 Mabsadd L
.83281 .52856 0 -2.5 Mabsadd L
.83281 .52856 -1.875 0 Mabsadd L closepath F
.83281 .52911 -1.875 0 Mabsadd m
.83281 .52911 0 2.5 Mabsadd L
.83281 .52911 1.875 0 Mabsadd L
.83281 .52911 0 -2.5 Mabsadd L
.83281 .52911 -1.875 0 Mabsadd L closepath F
.83412 .52966 -1.875 0 Mabsadd m
.83412 .52966 0 2.5 Mabsadd L
.83412 .52966 1.875 0 Mabsadd L
.83412 .52966 0 -2.5 Mabsadd L
.83412 .52966 -1.875 0 Mabsadd L closepath F
.83412 .5302 -1.875 0 Mabsadd m
.83412 .5302 0 2.5 Mabsadd L
.83412 .5302 1.875 0 Mabsadd L
.83412 .5302 0 -2.5 Mabsadd L
.83412 .5302 -1.875 0 Mabsadd L closepath F
.83675 .53075 -1.875 0 Mabsadd m
.83675 .53075 0 2.5 Mabsadd L
.83675 .53075 1.875 0 Mabsadd L
.83675 .53075 0 -2.5 Mabsadd L
.83675 .53075 -1.875 0 Mabsadd L closepath F
.83675 .53129 -1.875 0 Mabsadd m
.83675 .53129 0 2.5 Mabsadd L
.83675 .53129 1.875 0 Mabsadd L
.83675 .53129 0 -2.5 Mabsadd L
.83675 .53129 -1.875 0 Mabsadd L closepath F
.83675 .53182 -1.875 0 Mabsadd m
.83675 .53182 0 2.5 Mabsadd L
.83675 .53182 1.875 0 Mabsadd L
.83675 .53182 0 -2.5 Mabsadd L
.83675 .53182 -1.875 0 Mabsadd L closepath F
.83807 .53236 -1.875 0 Mabsadd m
.83807 .53236 0 2.5 Mabsadd L
.83807 .53236 1.875 0 Mabsadd L
.83807 .53236 0 -2.5 Mabsadd L
.83807 .53236 -1.875 0 Mabsadd L closepath F
.83938 .53289 -1.875 0 Mabsadd m
.83938 .53289 0 2.5 Mabsadd L
.83938 .53289 1.875 0 Mabsadd L
.83938 .53289 0 -2.5 Mabsadd L
.83938 .53289 -1.875 0 Mabsadd L closepath F
.8407 .53342 -1.875 0 Mabsadd m
.8407 .53342 0 2.5 Mabsadd L
.8407 .53342 1.875 0 Mabsadd L
.8407 .53342 0 -2.5 Mabsadd L
.8407 .53342 -1.875 0 Mabsadd L closepath F
.8407 .53395 -1.875 0 Mabsadd m
.8407 .53395 0 2.5 Mabsadd L
.8407 .53395 1.875 0 Mabsadd L
.8407 .53395 0 -2.5 Mabsadd L
.8407 .53395 -1.875 0 Mabsadd L closepath F
.84596 .53448 -1.875 0 Mabsadd m
.84596 .53448 0 2.5 Mabsadd L
.84596 .53448 1.875 0 Mabsadd L
.84596 .53448 0 -2.5 Mabsadd L
.84596 .53448 -1.875 0 Mabsadd L closepath F
.84596 .535 -1.875 0 Mabsadd m
.84596 .535 0 2.5 Mabsadd L
.84596 .535 1.875 0 Mabsadd L
.84596 .535 0 -2.5 Mabsadd L
.84596 .535 -1.875 0 Mabsadd L closepath F
.84596 .53553 -1.875 0 Mabsadd m
.84596 .53553 0 2.5 Mabsadd L
.84596 .53553 1.875 0 Mabsadd L
.84596 .53553 0 -2.5 Mabsadd L
.84596 .53553 -1.875 0 Mabsadd L closepath F
.84596 .53605 -1.875 0 Mabsadd m
.84596 .53605 0 2.5 Mabsadd L
.84596 .53605 1.875 0 Mabsadd L
.84596 .53605 0 -2.5 Mabsadd L
.84596 .53605 -1.875 0 Mabsadd L closepath F
.84728 .53657 -1.875 0 Mabsadd m
.84728 .53657 0 2.5 Mabsadd L
.84728 .53657 1.875 0 Mabsadd L
.84728 .53657 0 -2.5 Mabsadd L
.84728 .53657 -1.875 0 Mabsadd L closepath F
.84728 .53708 -1.875 0 Mabsadd m
.84728 .53708 0 2.5 Mabsadd L
.84728 .53708 1.875 0 Mabsadd L
.84728 .53708 0 -2.5 Mabsadd L
.84728 .53708 -1.875 0 Mabsadd L closepath F
.84991 .5376 -1.875 0 Mabsadd m
.84991 .5376 0 2.5 Mabsadd L
.84991 .5376 1.875 0 Mabsadd L
.84991 .5376 0 -2.5 Mabsadd L
.84991 .5376 -1.875 0 Mabsadd L closepath F
.85122 .53811 -1.875 0 Mabsadd m
.85122 .53811 0 2.5 Mabsadd L
.85122 .53811 1.875 0 Mabsadd L
.85122 .53811 0 -2.5 Mabsadd L
.85122 .53811 -1.875 0 Mabsadd L closepath F
.85122 .53862 -1.875 0 Mabsadd m
.85122 .53862 0 2.5 Mabsadd L
.85122 .53862 1.875 0 Mabsadd L
.85122 .53862 0 -2.5 Mabsadd L
.85122 .53862 -1.875 0 Mabsadd L closepath F
.85254 .53913 -1.875 0 Mabsadd m
.85254 .53913 0 2.5 Mabsadd L
.85254 .53913 1.875 0 Mabsadd L
.85254 .53913 0 -2.5 Mabsadd L
.85254 .53913 -1.875 0 Mabsadd L closepath F
.85254 .53963 -1.875 0 Mabsadd m
.85254 .53963 0 2.5 Mabsadd L
.85254 .53963 1.875 0 Mabsadd L
.85254 .53963 0 -2.5 Mabsadd L
.85254 .53963 -1.875 0 Mabsadd L closepath F
.85254 .54014 -1.875 0 Mabsadd m
.85254 .54014 0 2.5 Mabsadd L
.85254 .54014 1.875 0 Mabsadd L
.85254 .54014 0 -2.5 Mabsadd L
.85254 .54014 -1.875 0 Mabsadd L closepath F
.85254 .54064 -1.875 0 Mabsadd m
.85254 .54064 0 2.5 Mabsadd L
.85254 .54064 1.875 0 Mabsadd L
.85254 .54064 0 -2.5 Mabsadd L
.85254 .54064 -1.875 0 Mabsadd L closepath F
.85254 .54114 -1.875 0 Mabsadd m
.85254 .54114 0 2.5 Mabsadd L
.85254 .54114 1.875 0 Mabsadd L
.85254 .54114 0 -2.5 Mabsadd L
.85254 .54114 -1.875 0 Mabsadd L closepath F
.85254 .54163 -1.875 0 Mabsadd m
.85254 .54163 0 2.5 Mabsadd L
.85254 .54163 1.875 0 Mabsadd L
.85254 .54163 0 -2.5 Mabsadd L
.85254 .54163 -1.875 0 Mabsadd L closepath F
.85385 .54213 -1.875 0 Mabsadd m
.85385 .54213 0 2.5 Mabsadd L
.85385 .54213 1.875 0 Mabsadd L
.85385 .54213 0 -2.5 Mabsadd L
.85385 .54213 -1.875 0 Mabsadd L closepath F
.85385 .54262 -1.875 0 Mabsadd m
.85385 .54262 0 2.5 Mabsadd L
.85385 .54262 1.875 0 Mabsadd L
.85385 .54262 0 -2.5 Mabsadd L
.85385 .54262 -1.875 0 Mabsadd L closepath F
.85385 .54311 -1.875 0 Mabsadd m
.85385 .54311 0 2.5 Mabsadd L
.85385 .54311 1.875 0 Mabsadd L
.85385 .54311 0 -2.5 Mabsadd L
.85385 .54311 -1.875 0 Mabsadd L closepath F
.85385 .5436 -1.875 0 Mabsadd m
.85385 .5436 0 2.5 Mabsadd L
.85385 .5436 1.875 0 Mabsadd L
.85385 .5436 0 -2.5 Mabsadd L
.85385 .5436 -1.875 0 Mabsadd L closepath F
.8578 .54409 -1.875 0 Mabsadd m
.8578 .54409 0 2.5 Mabsadd L
.8578 .54409 1.875 0 Mabsadd L
.8578 .54409 0 -2.5 Mabsadd L
.8578 .54409 -1.875 0 Mabsadd L closepath F
.8578 .54457 -1.875 0 Mabsadd m
.8578 .54457 0 2.5 Mabsadd L
.8578 .54457 1.875 0 Mabsadd L
.8578 .54457 0 -2.5 Mabsadd L
.8578 .54457 -1.875 0 Mabsadd L closepath F
.85912 .54505 -1.875 0 Mabsadd m
.85912 .54505 0 2.5 Mabsadd L
.85912 .54505 1.875 0 Mabsadd L
.85912 .54505 0 -2.5 Mabsadd L
.85912 .54505 -1.875 0 Mabsadd L closepath F
.86043 .54553 -1.875 0 Mabsadd m
.86043 .54553 0 2.5 Mabsadd L
.86043 .54553 1.875 0 Mabsadd L
.86043 .54553 0 -2.5 Mabsadd L
.86043 .54553 -1.875 0 Mabsadd L closepath F
.86306 .54601 -1.875 0 Mabsadd m
.86306 .54601 0 2.5 Mabsadd L
.86306 .54601 1.875 0 Mabsadd L
.86306 .54601 0 -2.5 Mabsadd L
.86306 .54601 -1.875 0 Mabsadd L closepath F
.86569 .54649 -1.875 0 Mabsadd m
.86569 .54649 0 2.5 Mabsadd L
.86569 .54649 1.875 0 Mabsadd L
.86569 .54649 0 -2.5 Mabsadd L
.86569 .54649 -1.875 0 Mabsadd L closepath F
.86701 .54696 -1.875 0 Mabsadd m
.86701 .54696 0 2.5 Mabsadd L
.86701 .54696 1.875 0 Mabsadd L
.86701 .54696 0 -2.5 Mabsadd L
.86701 .54696 -1.875 0 Mabsadd L closepath F
.86701 .54743 -1.875 0 Mabsadd m
.86701 .54743 0 2.5 Mabsadd L
.86701 .54743 1.875 0 Mabsadd L
.86701 .54743 0 -2.5 Mabsadd L
.86701 .54743 -1.875 0 Mabsadd L closepath F
.86701 .5479 -1.875 0 Mabsadd m
.86701 .5479 0 2.5 Mabsadd L
.86701 .5479 1.875 0 Mabsadd L
.86701 .5479 0 -2.5 Mabsadd L
.86701 .5479 -1.875 0 Mabsadd L closepath F
.86701 .54837 -1.875 0 Mabsadd m
.86701 .54837 0 2.5 Mabsadd L
.86701 .54837 1.875 0 Mabsadd L
.86701 .54837 0 -2.5 Mabsadd L
.86701 .54837 -1.875 0 Mabsadd L closepath F
.86701 .54884 -1.875 0 Mabsadd m
.86701 .54884 0 2.5 Mabsadd L
.86701 .54884 1.875 0 Mabsadd L
.86701 .54884 0 -2.5 Mabsadd L
.86701 .54884 -1.875 0 Mabsadd L closepath F
.86701 .5493 -1.875 0 Mabsadd m
.86701 .5493 0 2.5 Mabsadd L
.86701 .5493 1.875 0 Mabsadd L
.86701 .5493 0 -2.5 Mabsadd L
.86701 .5493 -1.875 0 Mabsadd L closepath F
.86701 .54976 -1.875 0 Mabsadd m
.86701 .54976 0 2.5 Mabsadd L
.86701 .54976 1.875 0 Mabsadd L
.86701 .54976 0 -2.5 Mabsadd L
.86701 .54976 -1.875 0 Mabsadd L closepath F
.86701 .55022 -1.875 0 Mabsadd m
.86701 .55022 0 2.5 Mabsadd L
.86701 .55022 1.875 0 Mabsadd L
.86701 .55022 0 -2.5 Mabsadd L
.86701 .55022 -1.875 0 Mabsadd L closepath F
.86701 .55068 -1.875 0 Mabsadd m
.86701 .55068 0 2.5 Mabsadd L
.86701 .55068 1.875 0 Mabsadd L
.86701 .55068 0 -2.5 Mabsadd L
.86701 .55068 -1.875 0 Mabsadd L closepath F
.86832 .55113 -1.875 0 Mabsadd m
.86832 .55113 0 2.5 Mabsadd L
.86832 .55113 1.875 0 Mabsadd L
.86832 .55113 0 -2.5 Mabsadd L
.86832 .55113 -1.875 0 Mabsadd L closepath F
.87096 .55158 -1.875 0 Mabsadd m
.87096 .55158 0 2.5 Mabsadd L
.87096 .55158 1.875 0 Mabsadd L
.87096 .55158 0 -2.5 Mabsadd L
.87096 .55158 -1.875 0 Mabsadd L closepath F
.87096 .55204 -1.875 0 Mabsadd m
.87096 .55204 0 2.5 Mabsadd L
.87096 .55204 1.875 0 Mabsadd L
.87096 .55204 0 -2.5 Mabsadd L
.87096 .55204 -1.875 0 Mabsadd L closepath F
.87096 .55248 -1.875 0 Mabsadd m
.87096 .55248 0 2.5 Mabsadd L
.87096 .55248 1.875 0 Mabsadd L
.87096 .55248 0 -2.5 Mabsadd L
.87096 .55248 -1.875 0 Mabsadd L closepath F
.87227 .55293 -1.875 0 Mabsadd m
.87227 .55293 0 2.5 Mabsadd L
.87227 .55293 1.875 0 Mabsadd L
.87227 .55293 0 -2.5 Mabsadd L
.87227 .55293 -1.875 0 Mabsadd L closepath F
.87227 .55338 -1.875 0 Mabsadd m
.87227 .55338 0 2.5 Mabsadd L
.87227 .55338 1.875 0 Mabsadd L
.87227 .55338 0 -2.5 Mabsadd L
.87227 .55338 -1.875 0 Mabsadd L closepath F
.87227 .55382 -1.875 0 Mabsadd m
.87227 .55382 0 2.5 Mabsadd L
.87227 .55382 1.875 0 Mabsadd L
.87227 .55382 0 -2.5 Mabsadd L
.87227 .55382 -1.875 0 Mabsadd L closepath F
.87359 .55426 -1.875 0 Mabsadd m
.87359 .55426 0 2.5 Mabsadd L
.87359 .55426 1.875 0 Mabsadd L
.87359 .55426 0 -2.5 Mabsadd L
.87359 .55426 -1.875 0 Mabsadd L closepath F
.87359 .5547 -1.875 0 Mabsadd m
.87359 .5547 0 2.5 Mabsadd L
.87359 .5547 1.875 0 Mabsadd L
.87359 .5547 0 -2.5 Mabsadd L
.87359 .5547 -1.875 0 Mabsadd L closepath F
.8749 .55513 -1.875 0 Mabsadd m
.8749 .55513 0 2.5 Mabsadd L
.8749 .55513 1.875 0 Mabsadd L
.8749 .55513 0 -2.5 Mabsadd L
.8749 .55513 -1.875 0 Mabsadd L closepath F
.87753 .55557 -1.875 0 Mabsadd m
.87753 .55557 0 2.5 Mabsadd L
.87753 .55557 1.875 0 Mabsadd L
.87753 .55557 0 -2.5 Mabsadd L
.87753 .55557 -1.875 0 Mabsadd L closepath F
.87753 .556 -1.875 0 Mabsadd m
.87753 .556 0 2.5 Mabsadd L
.87753 .556 1.875 0 Mabsadd L
.87753 .556 0 -2.5 Mabsadd L
.87753 .556 -1.875 0 Mabsadd L closepath F
.87753 .55643 -1.875 0 Mabsadd m
.87753 .55643 0 2.5 Mabsadd L
.87753 .55643 1.875 0 Mabsadd L
.87753 .55643 0 -2.5 Mabsadd L
.87753 .55643 -1.875 0 Mabsadd L closepath F
.87753 .55686 -1.875 0 Mabsadd m
.87753 .55686 0 2.5 Mabsadd L
.87753 .55686 1.875 0 Mabsadd L
.87753 .55686 0 -2.5 Mabsadd L
.87753 .55686 -1.875 0 Mabsadd L closepath F
.87753 .55728 -1.875 0 Mabsadd m
.87753 .55728 0 2.5 Mabsadd L
.87753 .55728 1.875 0 Mabsadd L
.87753 .55728 0 -2.5 Mabsadd L
.87753 .55728 -1.875 0 Mabsadd L closepath F
.87753 .55771 -1.875 0 Mabsadd m
.87753 .55771 0 2.5 Mabsadd L
.87753 .55771 1.875 0 Mabsadd L
.87753 .55771 0 -2.5 Mabsadd L
.87753 .55771 -1.875 0 Mabsadd L closepath F
.87753 .55813 -1.875 0 Mabsadd m
.87753 .55813 0 2.5 Mabsadd L
.87753 .55813 1.875 0 Mabsadd L
.87753 .55813 0 -2.5 Mabsadd L
.87753 .55813 -1.875 0 Mabsadd L closepath F
.87753 .55855 -1.875 0 Mabsadd m
.87753 .55855 0 2.5 Mabsadd L
.87753 .55855 1.875 0 Mabsadd L
.87753 .55855 0 -2.5 Mabsadd L
.87753 .55855 -1.875 0 Mabsadd L closepath F
.87753 .55897 -1.875 0 Mabsadd m
.87753 .55897 0 2.5 Mabsadd L
.87753 .55897 1.875 0 Mabsadd L
.87753 .55897 0 -2.5 Mabsadd L
.87753 .55897 -1.875 0 Mabsadd L closepath F
.87753 .55938 -1.875 0 Mabsadd m
.87753 .55938 0 2.5 Mabsadd L
.87753 .55938 1.875 0 Mabsadd L
.87753 .55938 0 -2.5 Mabsadd L
.87753 .55938 -1.875 0 Mabsadd L closepath F
.87885 .5598 -1.875 0 Mabsadd m
.87885 .5598 0 2.5 Mabsadd L
.87885 .5598 1.875 0 Mabsadd L
.87885 .5598 0 -2.5 Mabsadd L
.87885 .5598 -1.875 0 Mabsadd L closepath F
.87885 .56021 -1.875 0 Mabsadd m
.87885 .56021 0 2.5 Mabsadd L
.87885 .56021 1.875 0 Mabsadd L
.87885 .56021 0 -2.5 Mabsadd L
.87885 .56021 -1.875 0 Mabsadd L closepath F
.87885 .56062 -1.875 0 Mabsadd m
.87885 .56062 0 2.5 Mabsadd L
.87885 .56062 1.875 0 Mabsadd L
.87885 .56062 0 -2.5 Mabsadd L
.87885 .56062 -1.875 0 Mabsadd L closepath F
.87885 .56102 -1.875 0 Mabsadd m
.87885 .56102 0 2.5 Mabsadd L
.87885 .56102 1.875 0 Mabsadd L
.87885 .56102 0 -2.5 Mabsadd L
.87885 .56102 -1.875 0 Mabsadd L closepath F
.88016 .56143 -1.875 0 Mabsadd m
.88016 .56143 0 2.5 Mabsadd L
.88016 .56143 1.875 0 Mabsadd L
.88016 .56143 0 -2.5 Mabsadd L
.88016 .56143 -1.875 0 Mabsadd L closepath F
.88016 .56183 -1.875 0 Mabsadd m
.88016 .56183 0 2.5 Mabsadd L
.88016 .56183 1.875 0 Mabsadd L
.88016 .56183 0 -2.5 Mabsadd L
.88016 .56183 -1.875 0 Mabsadd L closepath F
.88148 .56223 -1.875 0 Mabsadd m
.88148 .56223 0 2.5 Mabsadd L
.88148 .56223 1.875 0 Mabsadd L
.88148 .56223 0 -2.5 Mabsadd L
.88148 .56223 -1.875 0 Mabsadd L closepath F
.88279 .56263 -1.875 0 Mabsadd m
.88279 .56263 0 2.5 Mabsadd L
.88279 .56263 1.875 0 Mabsadd L
.88279 .56263 0 -2.5 Mabsadd L
.88279 .56263 -1.875 0 Mabsadd L closepath F
.88279 .56303 -1.875 0 Mabsadd m
.88279 .56303 0 2.5 Mabsadd L
.88279 .56303 1.875 0 Mabsadd L
.88279 .56303 0 -2.5 Mabsadd L
.88279 .56303 -1.875 0 Mabsadd L closepath F
.88411 .56343 -1.875 0 Mabsadd m
.88411 .56343 0 2.5 Mabsadd L
.88411 .56343 1.875 0 Mabsadd L
.88411 .56343 0 -2.5 Mabsadd L
.88411 .56343 -1.875 0 Mabsadd L closepath F
.88542 .56382 -1.875 0 Mabsadd m
.88542 .56382 0 2.5 Mabsadd L
.88542 .56382 1.875 0 Mabsadd L
.88542 .56382 0 -2.5 Mabsadd L
.88542 .56382 -1.875 0 Mabsadd L closepath F
.88542 .56421 -1.875 0 Mabsadd m
.88542 .56421 0 2.5 Mabsadd L
.88542 .56421 1.875 0 Mabsadd L
.88542 .56421 0 -2.5 Mabsadd L
.88542 .56421 -1.875 0 Mabsadd L closepath F
.88806 .5646 -1.875 0 Mabsadd m
.88806 .5646 0 2.5 Mabsadd L
.88806 .5646 1.875 0 Mabsadd L
.88806 .5646 0 -2.5 Mabsadd L
.88806 .5646 -1.875 0 Mabsadd L closepath F
.88806 .56499 -1.875 0 Mabsadd m
.88806 .56499 0 2.5 Mabsadd L
.88806 .56499 1.875 0 Mabsadd L
.88806 .56499 0 -2.5 Mabsadd L
.88806 .56499 -1.875 0 Mabsadd L closepath F
.88937 .56537 -1.875 0 Mabsadd m
.88937 .56537 0 2.5 Mabsadd L
.88937 .56537 1.875 0 Mabsadd L
.88937 .56537 0 -2.5 Mabsadd L
.88937 .56537 -1.875 0 Mabsadd L closepath F
.88937 .56575 -1.875 0 Mabsadd m
.88937 .56575 0 2.5 Mabsadd L
.88937 .56575 1.875 0 Mabsadd L
.88937 .56575 0 -2.5 Mabsadd L
.88937 .56575 -1.875 0 Mabsadd L closepath F
.88937 .56613 -1.875 0 Mabsadd m
.88937 .56613 0 2.5 Mabsadd L
.88937 .56613 1.875 0 Mabsadd L
.88937 .56613 0 -2.5 Mabsadd L
.88937 .56613 -1.875 0 Mabsadd L closepath F
.88937 .56651 -1.875 0 Mabsadd m
.88937 .56651 0 2.5 Mabsadd L
.88937 .56651 1.875 0 Mabsadd L
.88937 .56651 0 -2.5 Mabsadd L
.88937 .56651 -1.875 0 Mabsadd L closepath F
.89069 .56689 -1.875 0 Mabsadd m
.89069 .56689 0 2.5 Mabsadd L
.89069 .56689 1.875 0 Mabsadd L
.89069 .56689 0 -2.5 Mabsadd L
.89069 .56689 -1.875 0 Mabsadd L closepath F
.89332 .56727 -1.875 0 Mabsadd m
.89332 .56727 0 2.5 Mabsadd L
.89332 .56727 1.875 0 Mabsadd L
.89332 .56727 0 -2.5 Mabsadd L
.89332 .56727 -1.875 0 Mabsadd L closepath F
.89332 .56764 -1.875 0 Mabsadd m
.89332 .56764 0 2.5 Mabsadd L
.89332 .56764 1.875 0 Mabsadd L
.89332 .56764 0 -2.5 Mabsadd L
.89332 .56764 -1.875 0 Mabsadd L closepath F
.89595 .56801 -1.875 0 Mabsadd m
.89595 .56801 0 2.5 Mabsadd L
.89595 .56801 1.875 0 Mabsadd L
.89595 .56801 0 -2.5 Mabsadd L
.89595 .56801 -1.875 0 Mabsadd L closepath F
.89595 .56838 -1.875 0 Mabsadd m
.89595 .56838 0 2.5 Mabsadd L
.89595 .56838 1.875 0 Mabsadd L
.89595 .56838 0 -2.5 Mabsadd L
.89595 .56838 -1.875 0 Mabsadd L closepath F
.89858 .56874 -1.875 0 Mabsadd m
.89858 .56874 0 2.5 Mabsadd L
.89858 .56874 1.875 0 Mabsadd L
.89858 .56874 0 -2.5 Mabsadd L
.89858 .56874 -1.875 0 Mabsadd L closepath F
.89858 .56911 -1.875 0 Mabsadd m
.89858 .56911 0 2.5 Mabsadd L
.89858 .56911 1.875 0 Mabsadd L
.89858 .56911 0 -2.5 Mabsadd L
.89858 .56911 -1.875 0 Mabsadd L closepath F
.89858 .56947 -1.875 0 Mabsadd m
.89858 .56947 0 2.5 Mabsadd L
.89858 .56947 1.875 0 Mabsadd L
.89858 .56947 0 -2.5 Mabsadd L
.89858 .56947 -1.875 0 Mabsadd L closepath F
.89989 .56983 -1.875 0 Mabsadd m
.89989 .56983 0 2.5 Mabsadd L
.89989 .56983 1.875 0 Mabsadd L
.89989 .56983 0 -2.5 Mabsadd L
.89989 .56983 -1.875 0 Mabsadd L closepath F
.89989 .57019 -1.875 0 Mabsadd m
.89989 .57019 0 2.5 Mabsadd L
.89989 .57019 1.875 0 Mabsadd L
.89989 .57019 0 -2.5 Mabsadd L
.89989 .57019 -1.875 0 Mabsadd L closepath F
.89989 .57055 -1.875 0 Mabsadd m
.89989 .57055 0 2.5 Mabsadd L
.89989 .57055 1.875 0 Mabsadd L
.89989 .57055 0 -2.5 Mabsadd L
.89989 .57055 -1.875 0 Mabsadd L closepath F
.89989 .5709 -1.875 0 Mabsadd m
.89989 .5709 0 2.5 Mabsadd L
.89989 .5709 1.875 0 Mabsadd L
.89989 .5709 0 -2.5 Mabsadd L
.89989 .5709 -1.875 0 Mabsadd L closepath F
.90253 .57125 -1.875 0 Mabsadd m
.90253 .57125 0 2.5 Mabsadd L
.90253 .57125 1.875 0 Mabsadd L
.90253 .57125 0 -2.5 Mabsadd L
.90253 .57125 -1.875 0 Mabsadd L closepath F
.90647 .57161 -1.875 0 Mabsadd m
.90647 .57161 0 2.5 Mabsadd L
.90647 .57161 1.875 0 Mabsadd L
.90647 .57161 0 -2.5 Mabsadd L
.90647 .57161 -1.875 0 Mabsadd L closepath F
.90647 .57195 -1.875 0 Mabsadd m
.90647 .57195 0 2.5 Mabsadd L
.90647 .57195 1.875 0 Mabsadd L
.90647 .57195 0 -2.5 Mabsadd L
.90647 .57195 -1.875 0 Mabsadd L closepath F
.90647 .5723 -1.875 0 Mabsadd m
.90647 .5723 0 2.5 Mabsadd L
.90647 .5723 1.875 0 Mabsadd L
.90647 .5723 0 -2.5 Mabsadd L
.90647 .5723 -1.875 0 Mabsadd L closepath F
.90647 .57265 -1.875 0 Mabsadd m
.90647 .57265 0 2.5 Mabsadd L
.90647 .57265 1.875 0 Mabsadd L
.90647 .57265 0 -2.5 Mabsadd L
.90647 .57265 -1.875 0 Mabsadd L closepath F
.90647 .57299 -1.875 0 Mabsadd m
.90647 .57299 0 2.5 Mabsadd L
.90647 .57299 1.875 0 Mabsadd L
.90647 .57299 0 -2.5 Mabsadd L
.90647 .57299 -1.875 0 Mabsadd L closepath F
.90779 .57333 -1.875 0 Mabsadd m
.90779 .57333 0 2.5 Mabsadd L
.90779 .57333 1.875 0 Mabsadd L
.90779 .57333 0 -2.5 Mabsadd L
.90779 .57333 -1.875 0 Mabsadd L closepath F
.90779 .57367 -1.875 0 Mabsadd m
.90779 .57367 0 2.5 Mabsadd L
.90779 .57367 1.875 0 Mabsadd L
.90779 .57367 0 -2.5 Mabsadd L
.90779 .57367 -1.875 0 Mabsadd L closepath F
.90779 .574 -1.875 0 Mabsadd m
.90779 .574 0 2.5 Mabsadd L
.90779 .574 1.875 0 Mabsadd L
.90779 .574 0 -2.5 Mabsadd L
.90779 .574 -1.875 0 Mabsadd L closepath F
.90779 .57434 -1.875 0 Mabsadd m
.90779 .57434 0 2.5 Mabsadd L
.90779 .57434 1.875 0 Mabsadd L
.90779 .57434 0 -2.5 Mabsadd L
.90779 .57434 -1.875 0 Mabsadd L closepath F
.9091 .57467 -1.875 0 Mabsadd m
.9091 .57467 0 2.5 Mabsadd L
.9091 .57467 1.875 0 Mabsadd L
.9091 .57467 0 -2.5 Mabsadd L
.9091 .57467 -1.875 0 Mabsadd L closepath F
.9091 .575 -1.875 0 Mabsadd m
.9091 .575 0 2.5 Mabsadd L
.9091 .575 1.875 0 Mabsadd L
.9091 .575 0 -2.5 Mabsadd L
.9091 .575 -1.875 0 Mabsadd L closepath F
.9091 .57533 -1.875 0 Mabsadd m
.9091 .57533 0 2.5 Mabsadd L
.9091 .57533 1.875 0 Mabsadd L
.9091 .57533 0 -2.5 Mabsadd L
.9091 .57533 -1.875 0 Mabsadd L closepath F
.9091 .57566 -1.875 0 Mabsadd m
.9091 .57566 0 2.5 Mabsadd L
.9091 .57566 1.875 0 Mabsadd L
.9091 .57566 0 -2.5 Mabsadd L
.9091 .57566 -1.875 0 Mabsadd L closepath F
.91042 .57598 -1.875 0 Mabsadd m
.91042 .57598 0 2.5 Mabsadd L
.91042 .57598 1.875 0 Mabsadd L
.91042 .57598 0 -2.5 Mabsadd L
.91042 .57598 -1.875 0 Mabsadd L closepath F
.91042 .5763 -1.875 0 Mabsadd m
.91042 .5763 0 2.5 Mabsadd L
.91042 .5763 1.875 0 Mabsadd L
.91042 .5763 0 -2.5 Mabsadd L
.91042 .5763 -1.875 0 Mabsadd L closepath F
.91042 .57662 -1.875 0 Mabsadd m
.91042 .57662 0 2.5 Mabsadd L
.91042 .57662 1.875 0 Mabsadd L
.91042 .57662 0 -2.5 Mabsadd L
.91042 .57662 -1.875 0 Mabsadd L closepath F
.91042 .57694 -1.875 0 Mabsadd m
.91042 .57694 0 2.5 Mabsadd L
.91042 .57694 1.875 0 Mabsadd L
.91042 .57694 0 -2.5 Mabsadd L
.91042 .57694 -1.875 0 Mabsadd L closepath F
.91042 .57726 -1.875 0 Mabsadd m
.91042 .57726 0 2.5 Mabsadd L
.91042 .57726 1.875 0 Mabsadd L
.91042 .57726 0 -2.5 Mabsadd L
.91042 .57726 -1.875 0 Mabsadd L closepath F
.91042 .57757 -1.875 0 Mabsadd m
.91042 .57757 0 2.5 Mabsadd L
.91042 .57757 1.875 0 Mabsadd L
.91042 .57757 0 -2.5 Mabsadd L
.91042 .57757 -1.875 0 Mabsadd L closepath F
.91042 .57789 -1.875 0 Mabsadd m
.91042 .57789 0 2.5 Mabsadd L
.91042 .57789 1.875 0 Mabsadd L
.91042 .57789 0 -2.5 Mabsadd L
.91042 .57789 -1.875 0 Mabsadd L closepath F
.91173 .5782 -1.875 0 Mabsadd m
.91173 .5782 0 2.5 Mabsadd L
.91173 .5782 1.875 0 Mabsadd L
.91173 .5782 0 -2.5 Mabsadd L
.91173 .5782 -1.875 0 Mabsadd L closepath F
.91305 .57851 -1.875 0 Mabsadd m
.91305 .57851 0 2.5 Mabsadd L
.91305 .57851 1.875 0 Mabsadd L
.91305 .57851 0 -2.5 Mabsadd L
.91305 .57851 -1.875 0 Mabsadd L closepath F
.91305 .57881 -1.875 0 Mabsadd m
.91305 .57881 0 2.5 Mabsadd L
.91305 .57881 1.875 0 Mabsadd L
.91305 .57881 0 -2.5 Mabsadd L
.91305 .57881 -1.875 0 Mabsadd L closepath F
.91305 .57912 -1.875 0 Mabsadd m
.91305 .57912 0 2.5 Mabsadd L
.91305 .57912 1.875 0 Mabsadd L
.91305 .57912 0 -2.5 Mabsadd L
.91305 .57912 -1.875 0 Mabsadd L closepath F
.91436 .57942 -1.875 0 Mabsadd m
.91436 .57942 0 2.5 Mabsadd L
.91436 .57942 1.875 0 Mabsadd L
.91436 .57942 0 -2.5 Mabsadd L
.91436 .57942 -1.875 0 Mabsadd L closepath F
.91436 .57972 -1.875 0 Mabsadd m
.91436 .57972 0 2.5 Mabsadd L
.91436 .57972 1.875 0 Mabsadd L
.91436 .57972 0 -2.5 Mabsadd L
.91436 .57972 -1.875 0 Mabsadd L closepath F
.91436 .58002 -1.875 0 Mabsadd m
.91436 .58002 0 2.5 Mabsadd L
.91436 .58002 1.875 0 Mabsadd L
.91436 .58002 0 -2.5 Mabsadd L
.91436 .58002 -1.875 0 Mabsadd L closepath F
.91436 .58032 -1.875 0 Mabsadd m
.91436 .58032 0 2.5 Mabsadd L
.91436 .58032 1.875 0 Mabsadd L
.91436 .58032 0 -2.5 Mabsadd L
.91436 .58032 -1.875 0 Mabsadd L closepath F
.917 .58061 -1.875 0 Mabsadd m
.917 .58061 0 2.5 Mabsadd L
.917 .58061 1.875 0 Mabsadd L
.917 .58061 0 -2.5 Mabsadd L
.917 .58061 -1.875 0 Mabsadd L closepath F
.91963 .58091 -1.875 0 Mabsadd m
.91963 .58091 0 2.5 Mabsadd L
.91963 .58091 1.875 0 Mabsadd L
.91963 .58091 0 -2.5 Mabsadd L
.91963 .58091 -1.875 0 Mabsadd L closepath F
.91963 .5812 -1.875 0 Mabsadd m
.91963 .5812 0 2.5 Mabsadd L
.91963 .5812 1.875 0 Mabsadd L
.91963 .5812 0 -2.5 Mabsadd L
.91963 .5812 -1.875 0 Mabsadd L closepath F
.91963 .58149 -1.875 0 Mabsadd m
.91963 .58149 0 2.5 Mabsadd L
.91963 .58149 1.875 0 Mabsadd L
.91963 .58149 0 -2.5 Mabsadd L
.91963 .58149 -1.875 0 Mabsadd L closepath F
.92226 .58177 -1.875 0 Mabsadd m
.92226 .58177 0 2.5 Mabsadd L
.92226 .58177 1.875 0 Mabsadd L
.92226 .58177 0 -2.5 Mabsadd L
.92226 .58177 -1.875 0 Mabsadd L closepath F
.92226 .58206 -1.875 0 Mabsadd m
.92226 .58206 0 2.5 Mabsadd L
.92226 .58206 1.875 0 Mabsadd L
.92226 .58206 0 -2.5 Mabsadd L
.92226 .58206 -1.875 0 Mabsadd L closepath F
.92357 .58234 -1.875 0 Mabsadd m
.92357 .58234 0 2.5 Mabsadd L
.92357 .58234 1.875 0 Mabsadd L
.92357 .58234 0 -2.5 Mabsadd L
.92357 .58234 -1.875 0 Mabsadd L closepath F
.92357 .58262 -1.875 0 Mabsadd m
.92357 .58262 0 2.5 Mabsadd L
.92357 .58262 1.875 0 Mabsadd L
.92357 .58262 0 -2.5 Mabsadd L
.92357 .58262 -1.875 0 Mabsadd L closepath F
.92489 .5829 -1.875 0 Mabsadd m
.92489 .5829 0 2.5 Mabsadd L
.92489 .5829 1.875 0 Mabsadd L
.92489 .5829 0 -2.5 Mabsadd L
.92489 .5829 -1.875 0 Mabsadd L closepath F
.92489 .58318 -1.875 0 Mabsadd m
.92489 .58318 0 2.5 Mabsadd L
.92489 .58318 1.875 0 Mabsadd L
.92489 .58318 0 -2.5 Mabsadd L
.92489 .58318 -1.875 0 Mabsadd L closepath F
.92489 .58345 -1.875 0 Mabsadd m
.92489 .58345 0 2.5 Mabsadd L
.92489 .58345 1.875 0 Mabsadd L
.92489 .58345 0 -2.5 Mabsadd L
.92489 .58345 -1.875 0 Mabsadd L closepath F
.92489 .58373 -1.875 0 Mabsadd m
.92489 .58373 0 2.5 Mabsadd L
.92489 .58373 1.875 0 Mabsadd L
.92489 .58373 0 -2.5 Mabsadd L
.92489 .58373 -1.875 0 Mabsadd L closepath F
.9262 .584 -1.875 0 Mabsadd m
.9262 .584 0 2.5 Mabsadd L
.9262 .584 1.875 0 Mabsadd L
.9262 .584 0 -2.5 Mabsadd L
.9262 .584 -1.875 0 Mabsadd L closepath F
.9262 .58427 -1.875 0 Mabsadd m
.9262 .58427 0 2.5 Mabsadd L
.9262 .58427 1.875 0 Mabsadd L
.9262 .58427 0 -2.5 Mabsadd L
.9262 .58427 -1.875 0 Mabsadd L closepath F
.9262 .58454 -1.875 0 Mabsadd m
.9262 .58454 0 2.5 Mabsadd L
.9262 .58454 1.875 0 Mabsadd L
.9262 .58454 0 -2.5 Mabsadd L
.9262 .58454 -1.875 0 Mabsadd L closepath F
.9262 .5848 -1.875 0 Mabsadd m
.9262 .5848 0 2.5 Mabsadd L
.9262 .5848 1.875 0 Mabsadd L
.9262 .5848 0 -2.5 Mabsadd L
.9262 .5848 -1.875 0 Mabsadd L closepath F
.9262 .58506 -1.875 0 Mabsadd m
.9262 .58506 0 2.5 Mabsadd L
.9262 .58506 1.875 0 Mabsadd L
.9262 .58506 0 -2.5 Mabsadd L
.9262 .58506 -1.875 0 Mabsadd L closepath F
.92752 .58533 -1.875 0 Mabsadd m
.92752 .58533 0 2.5 Mabsadd L
.92752 .58533 1.875 0 Mabsadd L
.92752 .58533 0 -2.5 Mabsadd L
.92752 .58533 -1.875 0 Mabsadd L closepath F
.92752 .58559 -1.875 0 Mabsadd m
.92752 .58559 0 2.5 Mabsadd L
.92752 .58559 1.875 0 Mabsadd L
.92752 .58559 0 -2.5 Mabsadd L
.92752 .58559 -1.875 0 Mabsadd L closepath F
.92752 .58584 -1.875 0 Mabsadd m
.92752 .58584 0 2.5 Mabsadd L
.92752 .58584 1.875 0 Mabsadd L
.92752 .58584 0 -2.5 Mabsadd L
.92752 .58584 -1.875 0 Mabsadd L closepath F
.92883 .5861 -1.875 0 Mabsadd m
.92883 .5861 0 2.5 Mabsadd L
.92883 .5861 1.875 0 Mabsadd L
.92883 .5861 0 -2.5 Mabsadd L
.92883 .5861 -1.875 0 Mabsadd L closepath F
.93147 .58635 -1.875 0 Mabsadd m
.93147 .58635 0 2.5 Mabsadd L
.93147 .58635 1.875 0 Mabsadd L
.93147 .58635 0 -2.5 Mabsadd L
.93147 .58635 -1.875 0 Mabsadd L closepath F
.93147 .58661 -1.875 0 Mabsadd m
.93147 .58661 0 2.5 Mabsadd L
.93147 .58661 1.875 0 Mabsadd L
.93147 .58661 0 -2.5 Mabsadd L
.93147 .58661 -1.875 0 Mabsadd L closepath F
.93147 .58686 -1.875 0 Mabsadd m
.93147 .58686 0 2.5 Mabsadd L
.93147 .58686 1.875 0 Mabsadd L
.93147 .58686 0 -2.5 Mabsadd L
.93147 .58686 -1.875 0 Mabsadd L closepath F
.93147 .5871 -1.875 0 Mabsadd m
.93147 .5871 0 2.5 Mabsadd L
.93147 .5871 1.875 0 Mabsadd L
.93147 .5871 0 -2.5 Mabsadd L
.93147 .5871 -1.875 0 Mabsadd L closepath F
.93147 .58735 -1.875 0 Mabsadd m
.93147 .58735 0 2.5 Mabsadd L
.93147 .58735 1.875 0 Mabsadd L
.93147 .58735 0 -2.5 Mabsadd L
.93147 .58735 -1.875 0 Mabsadd L closepath F
.93147 .58759 -1.875 0 Mabsadd m
.93147 .58759 0 2.5 Mabsadd L
.93147 .58759 1.875 0 Mabsadd L
.93147 .58759 0 -2.5 Mabsadd L
.93147 .58759 -1.875 0 Mabsadd L closepath F
.93147 .58784 -1.875 0 Mabsadd m
.93147 .58784 0 2.5 Mabsadd L
.93147 .58784 1.875 0 Mabsadd L
.93147 .58784 0 -2.5 Mabsadd L
.93147 .58784 -1.875 0 Mabsadd L closepath F
.93278 .58808 -1.875 0 Mabsadd m
.93278 .58808 0 2.5 Mabsadd L
.93278 .58808 1.875 0 Mabsadd L
.93278 .58808 0 -2.5 Mabsadd L
.93278 .58808 -1.875 0 Mabsadd L closepath F
.93278 .58832 -1.875 0 Mabsadd m
.93278 .58832 0 2.5 Mabsadd L
.93278 .58832 1.875 0 Mabsadd L
.93278 .58832 0 -2.5 Mabsadd L
.93278 .58832 -1.875 0 Mabsadd L closepath F
.93278 .58855 -1.875 0 Mabsadd m
.93278 .58855 0 2.5 Mabsadd L
.93278 .58855 1.875 0 Mabsadd L
.93278 .58855 0 -2.5 Mabsadd L
.93278 .58855 -1.875 0 Mabsadd L closepath F
.93278 .58879 -1.875 0 Mabsadd m
.93278 .58879 0 2.5 Mabsadd L
.93278 .58879 1.875 0 Mabsadd L
.93278 .58879 0 -2.5 Mabsadd L
.93278 .58879 -1.875 0 Mabsadd L closepath F
.93278 .58902 -1.875 0 Mabsadd m
.93278 .58902 0 2.5 Mabsadd L
.93278 .58902 1.875 0 Mabsadd L
.93278 .58902 0 -2.5 Mabsadd L
.93278 .58902 -1.875 0 Mabsadd L closepath F
.9341 .58925 -1.875 0 Mabsadd m
.9341 .58925 0 2.5 Mabsadd L
.9341 .58925 1.875 0 Mabsadd L
.9341 .58925 0 -2.5 Mabsadd L
.9341 .58925 -1.875 0 Mabsadd L closepath F
.9341 .58948 -1.875 0 Mabsadd m
.9341 .58948 0 2.5 Mabsadd L
.9341 .58948 1.875 0 Mabsadd L
.9341 .58948 0 -2.5 Mabsadd L
.9341 .58948 -1.875 0 Mabsadd L closepath F
.9341 .58971 -1.875 0 Mabsadd m
.9341 .58971 0 2.5 Mabsadd L
.9341 .58971 1.875 0 Mabsadd L
.9341 .58971 0 -2.5 Mabsadd L
.9341 .58971 -1.875 0 Mabsadd L closepath F
.9341 .58993 -1.875 0 Mabsadd m
.9341 .58993 0 2.5 Mabsadd L
.9341 .58993 1.875 0 Mabsadd L
.9341 .58993 0 -2.5 Mabsadd L
.9341 .58993 -1.875 0 Mabsadd L closepath F
.93541 .59015 -1.875 0 Mabsadd m
.93541 .59015 0 2.5 Mabsadd L
.93541 .59015 1.875 0 Mabsadd L
.93541 .59015 0 -2.5 Mabsadd L
.93541 .59015 -1.875 0 Mabsadd L closepath F
.93541 .59037 -1.875 0 Mabsadd m
.93541 .59037 0 2.5 Mabsadd L
.93541 .59037 1.875 0 Mabsadd L
.93541 .59037 0 -2.5 Mabsadd L
.93541 .59037 -1.875 0 Mabsadd L closepath F
.93673 .59059 -1.875 0 Mabsadd m
.93673 .59059 0 2.5 Mabsadd L
.93673 .59059 1.875 0 Mabsadd L
.93673 .59059 0 -2.5 Mabsadd L
.93673 .59059 -1.875 0 Mabsadd L closepath F
.93673 .59081 -1.875 0 Mabsadd m
.93673 .59081 0 2.5 Mabsadd L
.93673 .59081 1.875 0 Mabsadd L
.93673 .59081 0 -2.5 Mabsadd L
.93673 .59081 -1.875 0 Mabsadd L closepath F
.93804 .59103 -1.875 0 Mabsadd m
.93804 .59103 0 2.5 Mabsadd L
.93804 .59103 1.875 0 Mabsadd L
.93804 .59103 0 -2.5 Mabsadd L
.93804 .59103 -1.875 0 Mabsadd L closepath F
.93804 .59124 -1.875 0 Mabsadd m
.93804 .59124 0 2.5 Mabsadd L
.93804 .59124 1.875 0 Mabsadd L
.93804 .59124 0 -2.5 Mabsadd L
.93804 .59124 -1.875 0 Mabsadd L closepath F
.93804 .59145 -1.875 0 Mabsadd m
.93804 .59145 0 2.5 Mabsadd L
.93804 .59145 1.875 0 Mabsadd L
.93804 .59145 0 -2.5 Mabsadd L
.93804 .59145 -1.875 0 Mabsadd L closepath F
.93804 .59166 -1.875 0 Mabsadd m
.93804 .59166 0 2.5 Mabsadd L
.93804 .59166 1.875 0 Mabsadd L
.93804 .59166 0 -2.5 Mabsadd L
.93804 .59166 -1.875 0 Mabsadd L closepath F
.93804 .59187 -1.875 0 Mabsadd m
.93804 .59187 0 2.5 Mabsadd L
.93804 .59187 1.875 0 Mabsadd L
.93804 .59187 0 -2.5 Mabsadd L
.93804 .59187 -1.875 0 Mabsadd L closepath F
.93804 .59207 -1.875 0 Mabsadd m
.93804 .59207 0 2.5 Mabsadd L
.93804 .59207 1.875 0 Mabsadd L
.93804 .59207 0 -2.5 Mabsadd L
.93804 .59207 -1.875 0 Mabsadd L closepath F
.93804 .59228 -1.875 0 Mabsadd m
.93804 .59228 0 2.5 Mabsadd L
.93804 .59228 1.875 0 Mabsadd L
.93804 .59228 0 -2.5 Mabsadd L
.93804 .59228 -1.875 0 Mabsadd L closepath F
.93804 .59248 -1.875 0 Mabsadd m
.93804 .59248 0 2.5 Mabsadd L
.93804 .59248 1.875 0 Mabsadd L
.93804 .59248 0 -2.5 Mabsadd L
.93804 .59248 -1.875 0 Mabsadd L closepath F
.93804 .59268 -1.875 0 Mabsadd m
.93804 .59268 0 2.5 Mabsadd L
.93804 .59268 1.875 0 Mabsadd L
.93804 .59268 0 -2.5 Mabsadd L
.93804 .59268 -1.875 0 Mabsadd L closepath F
.93936 .59288 -1.875 0 Mabsadd m
.93936 .59288 0 2.5 Mabsadd L
.93936 .59288 1.875 0 Mabsadd L
.93936 .59288 0 -2.5 Mabsadd L
.93936 .59288 -1.875 0 Mabsadd L closepath F
.94067 .59307 -1.875 0 Mabsadd m
.94067 .59307 0 2.5 Mabsadd L
.94067 .59307 1.875 0 Mabsadd L
.94067 .59307 0 -2.5 Mabsadd L
.94067 .59307 -1.875 0 Mabsadd L closepath F
.94067 .59327 -1.875 0 Mabsadd m
.94067 .59327 0 2.5 Mabsadd L
.94067 .59327 1.875 0 Mabsadd L
.94067 .59327 0 -2.5 Mabsadd L
.94067 .59327 -1.875 0 Mabsadd L closepath F
.9433 .59346 -1.875 0 Mabsadd m
.9433 .59346 0 2.5 Mabsadd L
.9433 .59346 1.875 0 Mabsadd L
.9433 .59346 0 -2.5 Mabsadd L
.9433 .59346 -1.875 0 Mabsadd L closepath F
.94462 .59365 -1.875 0 Mabsadd m
.94462 .59365 0 2.5 Mabsadd L
.94462 .59365 1.875 0 Mabsadd L
.94462 .59365 0 -2.5 Mabsadd L
.94462 .59365 -1.875 0 Mabsadd L closepath F
.94462 .59384 -1.875 0 Mabsadd m
.94462 .59384 0 2.5 Mabsadd L
.94462 .59384 1.875 0 Mabsadd L
.94462 .59384 0 -2.5 Mabsadd L
.94462 .59384 -1.875 0 Mabsadd L closepath F
.94725 .59403 -1.875 0 Mabsadd m
.94725 .59403 0 2.5 Mabsadd L
.94725 .59403 1.875 0 Mabsadd L
.94725 .59403 0 -2.5 Mabsadd L
.94725 .59403 -1.875 0 Mabsadd L closepath F
.94857 .59421 -1.875 0 Mabsadd m
.94857 .59421 0 2.5 Mabsadd L
.94857 .59421 1.875 0 Mabsadd L
.94857 .59421 0 -2.5 Mabsadd L
.94857 .59421 -1.875 0 Mabsadd L closepath F
.94857 .5944 -1.875 0 Mabsadd m
.94857 .5944 0 2.5 Mabsadd L
.94857 .5944 1.875 0 Mabsadd L
.94857 .5944 0 -2.5 Mabsadd L
.94857 .5944 -1.875 0 Mabsadd L closepath F
.94988 .59458 -1.875 0 Mabsadd m
.94988 .59458 0 2.5 Mabsadd L
.94988 .59458 1.875 0 Mabsadd L
.94988 .59458 0 -2.5 Mabsadd L
.94988 .59458 -1.875 0 Mabsadd L closepath F
.94988 .59476 -1.875 0 Mabsadd m
.94988 .59476 0 2.5 Mabsadd L
.94988 .59476 1.875 0 Mabsadd L
.94988 .59476 0 -2.5 Mabsadd L
.94988 .59476 -1.875 0 Mabsadd L closepath F
.94988 .59493 -1.875 0 Mabsadd m
.94988 .59493 0 2.5 Mabsadd L
.94988 .59493 1.875 0 Mabsadd L
.94988 .59493 0 -2.5 Mabsadd L
.94988 .59493 -1.875 0 Mabsadd L closepath F
.94988 .59511 -1.875 0 Mabsadd m
.94988 .59511 0 2.5 Mabsadd L
.94988 .59511 1.875 0 Mabsadd L
.94988 .59511 0 -2.5 Mabsadd L
.94988 .59511 -1.875 0 Mabsadd L closepath F
.9512 .59528 -1.875 0 Mabsadd m
.9512 .59528 0 2.5 Mabsadd L
.9512 .59528 1.875 0 Mabsadd L
.9512 .59528 0 -2.5 Mabsadd L
.9512 .59528 -1.875 0 Mabsadd L closepath F
.9512 .59545 -1.875 0 Mabsadd m
.9512 .59545 0 2.5 Mabsadd L
.9512 .59545 1.875 0 Mabsadd L
.9512 .59545 0 -2.5 Mabsadd L
.9512 .59545 -1.875 0 Mabsadd L closepath F
.95251 .59562 -1.875 0 Mabsadd m
.95251 .59562 0 2.5 Mabsadd L
.95251 .59562 1.875 0 Mabsadd L
.95251 .59562 0 -2.5 Mabsadd L
.95251 .59562 -1.875 0 Mabsadd L closepath F
.95251 .59579 -1.875 0 Mabsadd m
.95251 .59579 0 2.5 Mabsadd L
.95251 .59579 1.875 0 Mabsadd L
.95251 .59579 0 -2.5 Mabsadd L
.95251 .59579 -1.875 0 Mabsadd L closepath F
.95251 .59596 -1.875 0 Mabsadd m
.95251 .59596 0 2.5 Mabsadd L
.95251 .59596 1.875 0 Mabsadd L
.95251 .59596 0 -2.5 Mabsadd L
.95251 .59596 -1.875 0 Mabsadd L closepath F
.95251 .59612 -1.875 0 Mabsadd m
.95251 .59612 0 2.5 Mabsadd L
.95251 .59612 1.875 0 Mabsadd L
.95251 .59612 0 -2.5 Mabsadd L
.95251 .59612 -1.875 0 Mabsadd L closepath F
.95251 .59628 -1.875 0 Mabsadd m
.95251 .59628 0 2.5 Mabsadd L
.95251 .59628 1.875 0 Mabsadd L
.95251 .59628 0 -2.5 Mabsadd L
.95251 .59628 -1.875 0 Mabsadd L closepath F
.95251 .59644 -1.875 0 Mabsadd m
.95251 .59644 0 2.5 Mabsadd L
.95251 .59644 1.875 0 Mabsadd L
.95251 .59644 0 -2.5 Mabsadd L
.95251 .59644 -1.875 0 Mabsadd L closepath F
.95251 .5966 -1.875 0 Mabsadd m
.95251 .5966 0 2.5 Mabsadd L
.95251 .5966 1.875 0 Mabsadd L
.95251 .5966 0 -2.5 Mabsadd L
.95251 .5966 -1.875 0 Mabsadd L closepath F
.95383 .59676 -1.875 0 Mabsadd m
.95383 .59676 0 2.5 Mabsadd L
.95383 .59676 1.875 0 Mabsadd L
.95383 .59676 0 -2.5 Mabsadd L
.95383 .59676 -1.875 0 Mabsadd L closepath F
.95383 .59691 -1.875 0 Mabsadd m
.95383 .59691 0 2.5 Mabsadd L
.95383 .59691 1.875 0 Mabsadd L
.95383 .59691 0 -2.5 Mabsadd L
.95383 .59691 -1.875 0 Mabsadd L closepath F
.95383 .59707 -1.875 0 Mabsadd m
.95383 .59707 0 2.5 Mabsadd L
.95383 .59707 1.875 0 Mabsadd L
.95383 .59707 0 -2.5 Mabsadd L
.95383 .59707 -1.875 0 Mabsadd L closepath F
.95383 .59722 -1.875 0 Mabsadd m
.95383 .59722 0 2.5 Mabsadd L
.95383 .59722 1.875 0 Mabsadd L
.95383 .59722 0 -2.5 Mabsadd L
.95383 .59722 -1.875 0 Mabsadd L closepath F
.95383 .59737 -1.875 0 Mabsadd m
.95383 .59737 0 2.5 Mabsadd L
.95383 .59737 1.875 0 Mabsadd L
.95383 .59737 0 -2.5 Mabsadd L
.95383 .59737 -1.875 0 Mabsadd L closepath F
.95383 .59751 -1.875 0 Mabsadd m
.95383 .59751 0 2.5 Mabsadd L
.95383 .59751 1.875 0 Mabsadd L
.95383 .59751 0 -2.5 Mabsadd L
.95383 .59751 -1.875 0 Mabsadd L closepath F
.95383 .59766 -1.875 0 Mabsadd m
.95383 .59766 0 2.5 Mabsadd L
.95383 .59766 1.875 0 Mabsadd L
.95383 .59766 0 -2.5 Mabsadd L
.95383 .59766 -1.875 0 Mabsadd L closepath F
.95383 .5978 -1.875 0 Mabsadd m
.95383 .5978 0 2.5 Mabsadd L
.95383 .5978 1.875 0 Mabsadd L
.95383 .5978 0 -2.5 Mabsadd L
.95383 .5978 -1.875 0 Mabsadd L closepath F
.95514 .59794 -1.875 0 Mabsadd m
.95514 .59794 0 2.5 Mabsadd L
.95514 .59794 1.875 0 Mabsadd L
.95514 .59794 0 -2.5 Mabsadd L
.95514 .59794 -1.875 0 Mabsadd L closepath F
.95514 .59808 -1.875 0 Mabsadd m
.95514 .59808 0 2.5 Mabsadd L
.95514 .59808 1.875 0 Mabsadd L
.95514 .59808 0 -2.5 Mabsadd L
.95514 .59808 -1.875 0 Mabsadd L closepath F
.95514 .59822 -1.875 0 Mabsadd m
.95514 .59822 0 2.5 Mabsadd L
.95514 .59822 1.875 0 Mabsadd L
.95514 .59822 0 -2.5 Mabsadd L
.95514 .59822 -1.875 0 Mabsadd L closepath F
.95514 .59836 -1.875 0 Mabsadd m
.95514 .59836 0 2.5 Mabsadd L
.95514 .59836 1.875 0 Mabsadd L
.95514 .59836 0 -2.5 Mabsadd L
.95514 .59836 -1.875 0 Mabsadd L closepath F
.95514 .59849 -1.875 0 Mabsadd m
.95514 .59849 0 2.5 Mabsadd L
.95514 .59849 1.875 0 Mabsadd L
.95514 .59849 0 -2.5 Mabsadd L
.95514 .59849 -1.875 0 Mabsadd L closepath F
.95514 .59862 -1.875 0 Mabsadd m
.95514 .59862 0 2.5 Mabsadd L
.95514 .59862 1.875 0 Mabsadd L
.95514 .59862 0 -2.5 Mabsadd L
.95514 .59862 -1.875 0 Mabsadd L closepath F
.95514 .59875 -1.875 0 Mabsadd m
.95514 .59875 0 2.5 Mabsadd L
.95514 .59875 1.875 0 Mabsadd L
.95514 .59875 0 -2.5 Mabsadd L
.95514 .59875 -1.875 0 Mabsadd L closepath F
.95514 .59888 -1.875 0 Mabsadd m
.95514 .59888 0 2.5 Mabsadd L
.95514 .59888 1.875 0 Mabsadd L
.95514 .59888 0 -2.5 Mabsadd L
.95514 .59888 -1.875 0 Mabsadd L closepath F
.95514 .59901 -1.875 0 Mabsadd m
.95514 .59901 0 2.5 Mabsadd L
.95514 .59901 1.875 0 Mabsadd L
.95514 .59901 0 -2.5 Mabsadd L
.95514 .59901 -1.875 0 Mabsadd L closepath F
.95514 .59913 -1.875 0 Mabsadd m
.95514 .59913 0 2.5 Mabsadd L
.95514 .59913 1.875 0 Mabsadd L
.95514 .59913 0 -2.5 Mabsadd L
.95514 .59913 -1.875 0 Mabsadd L closepath F
.95514 .59926 -1.875 0 Mabsadd m
.95514 .59926 0 2.5 Mabsadd L
.95514 .59926 1.875 0 Mabsadd L
.95514 .59926 0 -2.5 Mabsadd L
.95514 .59926 -1.875 0 Mabsadd L closepath F
.95646 .59938 -1.875 0 Mabsadd m
.95646 .59938 0 2.5 Mabsadd L
.95646 .59938 1.875 0 Mabsadd L
.95646 .59938 0 -2.5 Mabsadd L
.95646 .59938 -1.875 0 Mabsadd L closepath F
.95646 .5995 -1.875 0 Mabsadd m
.95646 .5995 0 2.5 Mabsadd L
.95646 .5995 1.875 0 Mabsadd L
.95646 .5995 0 -2.5 Mabsadd L
.95646 .5995 -1.875 0 Mabsadd L closepath F
.95646 .59961 -1.875 0 Mabsadd m
.95646 .59961 0 2.5 Mabsadd L
.95646 .59961 1.875 0 Mabsadd L
.95646 .59961 0 -2.5 Mabsadd L
.95646 .59961 -1.875 0 Mabsadd L closepath F
.95646 .59973 -1.875 0 Mabsadd m
.95646 .59973 0 2.5 Mabsadd L
.95646 .59973 1.875 0 Mabsadd L
.95646 .59973 0 -2.5 Mabsadd L
.95646 .59973 -1.875 0 Mabsadd L closepath F
.95646 .59984 -1.875 0 Mabsadd m
.95646 .59984 0 2.5 Mabsadd L
.95646 .59984 1.875 0 Mabsadd L
.95646 .59984 0 -2.5 Mabsadd L
.95646 .59984 -1.875 0 Mabsadd L closepath F
.95646 .59996 -1.875 0 Mabsadd m
.95646 .59996 0 2.5 Mabsadd L
.95646 .59996 1.875 0 Mabsadd L
.95646 .59996 0 -2.5 Mabsadd L
.95646 .59996 -1.875 0 Mabsadd L closepath F
.95646 .60007 -1.875 0 Mabsadd m
.95646 .60007 0 2.5 Mabsadd L
.95646 .60007 1.875 0 Mabsadd L
.95646 .60007 0 -2.5 Mabsadd L
.95646 .60007 -1.875 0 Mabsadd L closepath F
.95777 .60017 -1.875 0 Mabsadd m
.95777 .60017 0 2.5 Mabsadd L
.95777 .60017 1.875 0 Mabsadd L
.95777 .60017 0 -2.5 Mabsadd L
.95777 .60017 -1.875 0 Mabsadd L closepath F
.96041 .60028 -1.875 0 Mabsadd m
.96041 .60028 0 2.5 Mabsadd L
.96041 .60028 1.875 0 Mabsadd L
.96041 .60028 0 -2.5 Mabsadd L
.96041 .60028 -1.875 0 Mabsadd L closepath F
.96172 .60038 -1.875 0 Mabsadd m
.96172 .60038 0 2.5 Mabsadd L
.96172 .60038 1.875 0 Mabsadd L
.96172 .60038 0 -2.5 Mabsadd L
.96172 .60038 -1.875 0 Mabsadd L closepath F
.96304 .60049 -1.875 0 Mabsadd m
.96304 .60049 0 2.5 Mabsadd L
.96304 .60049 1.875 0 Mabsadd L
.96304 .60049 0 -2.5 Mabsadd L
.96304 .60049 -1.875 0 Mabsadd L closepath F
.96304 .60059 -1.875 0 Mabsadd m
.96304 .60059 0 2.5 Mabsadd L
.96304 .60059 1.875 0 Mabsadd L
.96304 .60059 0 -2.5 Mabsadd L
.96304 .60059 -1.875 0 Mabsadd L closepath F
.96304 .60069 -1.875 0 Mabsadd m
.96304 .60069 0 2.5 Mabsadd L
.96304 .60069 1.875 0 Mabsadd L
.96304 .60069 0 -2.5 Mabsadd L
.96304 .60069 -1.875 0 Mabsadd L closepath F
.96435 .60078 -1.875 0 Mabsadd m
.96435 .60078 0 2.5 Mabsadd L
.96435 .60078 1.875 0 Mabsadd L
.96435 .60078 0 -2.5 Mabsadd L
.96435 .60078 -1.875 0 Mabsadd L closepath F
.96435 .60088 -1.875 0 Mabsadd m
.96435 .60088 0 2.5 Mabsadd L
.96435 .60088 1.875 0 Mabsadd L
.96435 .60088 0 -2.5 Mabsadd L
.96435 .60088 -1.875 0 Mabsadd L closepath F
.96567 .60097 -1.875 0 Mabsadd m
.96567 .60097 0 2.5 Mabsadd L
.96567 .60097 1.875 0 Mabsadd L
.96567 .60097 0 -2.5 Mabsadd L
.96567 .60097 -1.875 0 Mabsadd L closepath F
.96567 .60106 -1.875 0 Mabsadd m
.96567 .60106 0 2.5 Mabsadd L
.96567 .60106 1.875 0 Mabsadd L
.96567 .60106 0 -2.5 Mabsadd L
.96567 .60106 -1.875 0 Mabsadd L closepath F
.96567 .60115 -1.875 0 Mabsadd m
.96567 .60115 0 2.5 Mabsadd L
.96567 .60115 1.875 0 Mabsadd L
.96567 .60115 0 -2.5 Mabsadd L
.96567 .60115 -1.875 0 Mabsadd L closepath F
.96567 .60124 -1.875 0 Mabsadd m
.96567 .60124 0 2.5 Mabsadd L
.96567 .60124 1.875 0 Mabsadd L
.96567 .60124 0 -2.5 Mabsadd L
.96567 .60124 -1.875 0 Mabsadd L closepath F
.96567 .60133 -1.875 0 Mabsadd m
.96567 .60133 0 2.5 Mabsadd L
.96567 .60133 1.875 0 Mabsadd L
.96567 .60133 0 -2.5 Mabsadd L
.96567 .60133 -1.875 0 Mabsadd L closepath F
.96567 .60141 -1.875 0 Mabsadd m
.96567 .60141 0 2.5 Mabsadd L
.96567 .60141 1.875 0 Mabsadd L
.96567 .60141 0 -2.5 Mabsadd L
.96567 .60141 -1.875 0 Mabsadd L closepath F
.96567 .60149 -1.875 0 Mabsadd m
.96567 .60149 0 2.5 Mabsadd L
.96567 .60149 1.875 0 Mabsadd L
.96567 .60149 0 -2.5 Mabsadd L
.96567 .60149 -1.875 0 Mabsadd L closepath F
.96698 .60157 -1.875 0 Mabsadd m
.96698 .60157 0 2.5 Mabsadd L
.96698 .60157 1.875 0 Mabsadd L
.96698 .60157 0 -2.5 Mabsadd L
.96698 .60157 -1.875 0 Mabsadd L closepath F
.96698 .60165 -1.875 0 Mabsadd m
.96698 .60165 0 2.5 Mabsadd L
.96698 .60165 1.875 0 Mabsadd L
.96698 .60165 0 -2.5 Mabsadd L
.96698 .60165 -1.875 0 Mabsadd L closepath F
.96698 .60173 -1.875 0 Mabsadd m
.96698 .60173 0 2.5 Mabsadd L
.96698 .60173 1.875 0 Mabsadd L
.96698 .60173 0 -2.5 Mabsadd L
.96698 .60173 -1.875 0 Mabsadd L closepath F
.96698 .60181 -1.875 0 Mabsadd m
.96698 .60181 0 2.5 Mabsadd L
.96698 .60181 1.875 0 Mabsadd L
.96698 .60181 0 -2.5 Mabsadd L
.96698 .60181 -1.875 0 Mabsadd L closepath F
.96698 .60188 -1.875 0 Mabsadd m
.96698 .60188 0 2.5 Mabsadd L
.96698 .60188 1.875 0 Mabsadd L
.96698 .60188 0 -2.5 Mabsadd L
.96698 .60188 -1.875 0 Mabsadd L closepath F
.96698 .60195 -1.875 0 Mabsadd m
.96698 .60195 0 2.5 Mabsadd L
.96698 .60195 1.875 0 Mabsadd L
.96698 .60195 0 -2.5 Mabsadd L
.96698 .60195 -1.875 0 Mabsadd L closepath F
.96698 .60202 -1.875 0 Mabsadd m
.96698 .60202 0 2.5 Mabsadd L
.96698 .60202 1.875 0 Mabsadd L
.96698 .60202 0 -2.5 Mabsadd L
.96698 .60202 -1.875 0 Mabsadd L closepath F
.96698 .60209 -1.875 0 Mabsadd m
.96698 .60209 0 2.5 Mabsadd L
.96698 .60209 1.875 0 Mabsadd L
.96698 .60209 0 -2.5 Mabsadd L
.96698 .60209 -1.875 0 Mabsadd L closepath F
.96698 .60215 -1.875 0 Mabsadd m
.96698 .60215 0 2.5 Mabsadd L
.96698 .60215 1.875 0 Mabsadd L
.96698 .60215 0 -2.5 Mabsadd L
.96698 .60215 -1.875 0 Mabsadd L closepath F
.96698 .60222 -1.875 0 Mabsadd m
.96698 .60222 0 2.5 Mabsadd L
.96698 .60222 1.875 0 Mabsadd L
.96698 .60222 0 -2.5 Mabsadd L
.96698 .60222 -1.875 0 Mabsadd L closepath F
.9683 .60228 -1.875 0 Mabsadd m
.9683 .60228 0 2.5 Mabsadd L
.9683 .60228 1.875 0 Mabsadd L
.9683 .60228 0 -2.5 Mabsadd L
.9683 .60228 -1.875 0 Mabsadd L closepath F
.9683 .60234 -1.875 0 Mabsadd m
.9683 .60234 0 2.5 Mabsadd L
.9683 .60234 1.875 0 Mabsadd L
.9683 .60234 0 -2.5 Mabsadd L
.9683 .60234 -1.875 0 Mabsadd L closepath F
.9683 .6024 -1.875 0 Mabsadd m
.9683 .6024 0 2.5 Mabsadd L
.9683 .6024 1.875 0 Mabsadd L
.9683 .6024 0 -2.5 Mabsadd L
.9683 .6024 -1.875 0 Mabsadd L closepath F
.9683 .60246 -1.875 0 Mabsadd m
.9683 .60246 0 2.5 Mabsadd L
.9683 .60246 1.875 0 Mabsadd L
.9683 .60246 0 -2.5 Mabsadd L
.9683 .60246 -1.875 0 Mabsadd L closepath F
.96961 .60251 -1.875 0 Mabsadd m
.96961 .60251 0 2.5 Mabsadd L
.96961 .60251 1.875 0 Mabsadd L
.96961 .60251 0 -2.5 Mabsadd L
.96961 .60251 -1.875 0 Mabsadd L closepath F
.96961 .60256 -1.875 0 Mabsadd m
.96961 .60256 0 2.5 Mabsadd L
.96961 .60256 1.875 0 Mabsadd L
.96961 .60256 0 -2.5 Mabsadd L
.96961 .60256 -1.875 0 Mabsadd L closepath F
.96961 .60261 -1.875 0 Mabsadd m
.96961 .60261 0 2.5 Mabsadd L
.96961 .60261 1.875 0 Mabsadd L
.96961 .60261 0 -2.5 Mabsadd L
.96961 .60261 -1.875 0 Mabsadd L closepath F
.96961 .60266 -1.875 0 Mabsadd m
.96961 .60266 0 2.5 Mabsadd L
.96961 .60266 1.875 0 Mabsadd L
.96961 .60266 0 -2.5 Mabsadd L
.96961 .60266 -1.875 0 Mabsadd L closepath F
.96961 .60271 -1.875 0 Mabsadd m
.96961 .60271 0 2.5 Mabsadd L
.96961 .60271 1.875 0 Mabsadd L
.96961 .60271 0 -2.5 Mabsadd L
.96961 .60271 -1.875 0 Mabsadd L closepath F
.96961 .60276 -1.875 0 Mabsadd m
.96961 .60276 0 2.5 Mabsadd L
.96961 .60276 1.875 0 Mabsadd L
.96961 .60276 0 -2.5 Mabsadd L
.96961 .60276 -1.875 0 Mabsadd L closepath F
.96961 .6028 -1.875 0 Mabsadd m
.96961 .6028 0 2.5 Mabsadd L
.96961 .6028 1.875 0 Mabsadd L
.96961 .6028 0 -2.5 Mabsadd L
.96961 .6028 -1.875 0 Mabsadd L closepath F
.96961 .60284 -1.875 0 Mabsadd m
.96961 .60284 0 2.5 Mabsadd L
.96961 .60284 1.875 0 Mabsadd L
.96961 .60284 0 -2.5 Mabsadd L
.96961 .60284 -1.875 0 Mabsadd L closepath F
.96961 .60288 -1.875 0 Mabsadd m
.96961 .60288 0 2.5 Mabsadd L
.96961 .60288 1.875 0 Mabsadd L
.96961 .60288 0 -2.5 Mabsadd L
.96961 .60288 -1.875 0 Mabsadd L closepath F
.97093 .60292 -1.875 0 Mabsadd m
.97093 .60292 0 2.5 Mabsadd L
.97093 .60292 1.875 0 Mabsadd L
.97093 .60292 0 -2.5 Mabsadd L
.97093 .60292 -1.875 0 Mabsadd L closepath F
.97093 .60296 -1.875 0 Mabsadd m
.97093 .60296 0 2.5 Mabsadd L
.97093 .60296 1.875 0 Mabsadd L
.97093 .60296 0 -2.5 Mabsadd L
.97093 .60296 -1.875 0 Mabsadd L closepath F
.97093 .603 -1.875 0 Mabsadd m
.97093 .603 0 2.5 Mabsadd L
.97093 .603 1.875 0 Mabsadd L
.97093 .603 0 -2.5 Mabsadd L
.97093 .603 -1.875 0 Mabsadd L closepath F
.97093 .60303 -1.875 0 Mabsadd m
.97093 .60303 0 2.5 Mabsadd L
.97093 .60303 1.875 0 Mabsadd L
.97093 .60303 0 -2.5 Mabsadd L
.97093 .60303 -1.875 0 Mabsadd L closepath F
.97093 .60306 -1.875 0 Mabsadd m
.97093 .60306 0 2.5 Mabsadd L
.97093 .60306 1.875 0 Mabsadd L
.97093 .60306 0 -2.5 Mabsadd L
.97093 .60306 -1.875 0 Mabsadd L closepath F
.97093 .60309 -1.875 0 Mabsadd m
.97093 .60309 0 2.5 Mabsadd L
.97093 .60309 1.875 0 Mabsadd L
.97093 .60309 0 -2.5 Mabsadd L
.97093 .60309 -1.875 0 Mabsadd L closepath F
.97224 .60312 -1.875 0 Mabsadd m
.97224 .60312 0 2.5 Mabsadd L
.97224 .60312 1.875 0 Mabsadd L
.97224 .60312 0 -2.5 Mabsadd L
.97224 .60312 -1.875 0 Mabsadd L closepath F
.97224 .60314 -1.875 0 Mabsadd m
.97224 .60314 0 2.5 Mabsadd L
.97224 .60314 1.875 0 Mabsadd L
.97224 .60314 0 -2.5 Mabsadd L
.97224 .60314 -1.875 0 Mabsadd L closepath F
.97224 .60317 -1.875 0 Mabsadd m
.97224 .60317 0 2.5 Mabsadd L
.97224 .60317 1.875 0 Mabsadd L
.97224 .60317 0 -2.5 Mabsadd L
.97224 .60317 -1.875 0 Mabsadd L closepath F
.97224 .60319 -1.875 0 Mabsadd m
.97224 .60319 0 2.5 Mabsadd L
.97224 .60319 1.875 0 Mabsadd L
.97224 .60319 0 -2.5 Mabsadd L
.97224 .60319 -1.875 0 Mabsadd L closepath F
.97488 .60321 -1.875 0 Mabsadd m
.97488 .60321 0 2.5 Mabsadd L
.97488 .60321 1.875 0 Mabsadd L
.97488 .60321 0 -2.5 Mabsadd L
.97488 .60321 -1.875 0 Mabsadd L closepath F
.97488 .60323 -1.875 0 Mabsadd m
.97488 .60323 0 2.5 Mabsadd L
.97488 .60323 1.875 0 Mabsadd L
.97488 .60323 0 -2.5 Mabsadd L
.97488 .60323 -1.875 0 Mabsadd L closepath F
.97488 .60325 -1.875 0 Mabsadd m
.97488 .60325 0 2.5 Mabsadd L
.97488 .60325 1.875 0 Mabsadd L
.97488 .60325 0 -2.5 Mabsadd L
.97488 .60325 -1.875 0 Mabsadd L closepath F
.97619 .60326 -1.875 0 Mabsadd m
.97619 .60326 0 2.5 Mabsadd L
.97619 .60326 1.875 0 Mabsadd L
.97619 .60326 0 -2.5 Mabsadd L
.97619 .60326 -1.875 0 Mabsadd L closepath F
.97619 .60328 -1.875 0 Mabsadd m
.97619 .60328 0 2.5 Mabsadd L
.97619 .60328 1.875 0 Mabsadd L
.97619 .60328 0 -2.5 Mabsadd L
.97619 .60328 -1.875 0 Mabsadd L closepath F
.97619 .60329 -1.875 0 Mabsadd m
.97619 .60329 0 2.5 Mabsadd L
.97619 .60329 1.875 0 Mabsadd L
.97619 .60329 0 -2.5 Mabsadd L
.97619 .60329 -1.875 0 Mabsadd L closepath F
.97619 .6033 -1.875 0 Mabsadd m
.97619 .6033 0 2.5 Mabsadd L
.97619 .6033 1.875 0 Mabsadd L
.97619 .6033 0 -2.5 Mabsadd L
.97619 .6033 -1.875 0 Mabsadd L closepath F
.97619 .6033 -1.875 0 Mabsadd m
.97619 .6033 0 2.5 Mabsadd L
.97619 .6033 1.875 0 Mabsadd L
.97619 .6033 0 -2.5 Mabsadd L
.97619 .6033 -1.875 0 Mabsadd L closepath F
.97619 .60331 -1.875 0 Mabsadd m
.97619 .60331 0 2.5 Mabsadd L
.97619 .60331 1.875 0 Mabsadd L
.97619 .60331 0 -2.5 Mabsadd L
.97619 .60331 -1.875 0 Mabsadd L closepath F
.97619 .60332 -1.875 0 Mabsadd m
.97619 .60332 0 2.5 Mabsadd L
.97619 .60332 1.875 0 Mabsadd L
.97619 .60332 0 -2.5 Mabsadd L
.97619 .60332 -1.875 0 Mabsadd L closepath F
.97619 .60332 -1.875 0 Mabsadd m
.97619 .60332 0 2.5 Mabsadd L
.97619 .60332 1.875 0 Mabsadd L
.97619 .60332 0 -2.5 Mabsadd L
.97619 .60332 -1.875 0 Mabsadd L closepath F
.97619 .60332 -1.875 0 Mabsadd m
.97619 .60332 0 2.5 Mabsadd L
.97619 .60332 1.875 0 Mabsadd L
.97619 .60332 0 -2.5 Mabsadd L
.97619 .60332 -1.875 0 Mabsadd L closepath F
.5 Mabswid
.01986 .01472 m
.97619 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0198632 0.956327 0.0147151 0.588604 [
[.21113 .00222 -9 -9 ]
[.21113 .00222 9 0 ]
[.40239 .00222 -9 -9 ]
[.40239 .00222 9 0 ]
[.59366 .00222 -9 -9 ]
[.59366 .00222 9 0 ]
[.78493 .00222 -9 -9 ]
[.78493 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.00736 .13244 -18 -4.5 ]
[.00736 .13244 0 4.5 ]
[.00736 .25016 -18 -4.5 ]
[.00736 .25016 0 4.5 ]
[.00736 .36788 -18 -4.5 ]
[.00736 .36788 0 4.5 ]
[.00736 .4856 -18 -4.5 ]
[.00736 .4856 0 4.5 ]
[.00736 .60332 -6 -4.5 ]
[.00736 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21113 .01472 m
.21113 .02097 L
s
[(0.2)] .21113 .00222 0 1 Mshowa
.40239 .01472 m
.40239 .02097 L
s
[(0.4)] .40239 .00222 0 1 Mshowa
.59366 .01472 m
.59366 .02097 L
s
[(0.6)] .59366 .00222 0 1 Mshowa
.78493 .01472 m
.78493 .02097 L
s
[(0.8)] .78493 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.06768 .01472 m
.06768 .01847 L
s
.1155 .01472 m
.1155 .01847 L
s
.16331 .01472 m
.16331 .01847 L
s
.25895 .01472 m
.25895 .01847 L
s
.30676 .01472 m
.30676 .01847 L
s
.35458 .01472 m
.35458 .01847 L
s
.45021 .01472 m
.45021 .01847 L
s
.49803 .01472 m
.49803 .01847 L
s
.54584 .01472 m
.54584 .01847 L
s
.64148 .01472 m
.64148 .01847 L
s
.68929 .01472 m
.68929 .01847 L
s
.73711 .01472 m
.73711 .01847 L
s
.83274 .01472 m
.83274 .01847 L
s
.88056 .01472 m
.88056 .01847 L
s
.92837 .01472 m
.92837 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.01986 .13244 m
.02611 .13244 L
s
[(0.2)] .00736 .13244 1 0 Mshowa
.01986 .25016 m
.02611 .25016 L
s
[(0.4)] .00736 .25016 1 0 Mshowa
.01986 .36788 m
.02611 .36788 L
s
[(0.6)] .00736 .36788 1 0 Mshowa
.01986 .4856 m
.02611 .4856 L
s
[(0.8)] .00736 .4856 1 0 Mshowa
.01986 .60332 m
.02611 .60332 L
s
[(1)] .00736 .60332 1 0 Mshowa
.125 Mabswid
.01986 .04415 m
.02361 .04415 L
s
.01986 .07358 m
.02361 .07358 L
s
.01986 .10301 m
.02361 .10301 L
s
.01986 .16187 m
.02361 .16187 L
s
.01986 .1913 m
.02361 .1913 L
s
.01986 .22073 m
.02361 .22073 L
s
.01986 .27959 m
.02361 .27959 L
s
.01986 .30902 m
.02361 .30902 L
s
.01986 .33845 m
.02361 .33845 L
s
.01986 .39731 m
.02361 .39731 L
s
.01986 .42674 m
.02361 .42674 L
s
.01986 .45617 m
.02361 .45617 L
s
.01986 .51503 m
.02361 .51503 L
s
.01986 .54446 m
.02361 .54446 L
s
.01986 .57389 m
.02361 .57389 L
s
.25 Mabswid
.01986 0 m
.01986 .61803 L
s
.0001 w
.02381 .01472 -1.875 0 Mabsadd m
.02381 .01472 0 2.5 Mabsadd L
.02381 .01472 1.875 0 Mabsadd L
.02381 .01472 0 -2.5 Mabsadd L
.02381 .01472 -1.875 0 Mabsadd L closepath F
.02381 .02014 -1.875 0 Mabsadd m
.02381 .02014 0 2.5 Mabsadd L
.02381 .02014 1.875 0 Mabsadd L
.02381 .02014 0 -2.5 Mabsadd L
.02381 .02014 -1.875 0 Mabsadd L closepath F
.02644 .02445 -1.875 0 Mabsadd m
.02644 .02445 0 2.5 Mabsadd L
.02644 .02445 1.875 0 Mabsadd L
.02644 .02445 0 -2.5 Mabsadd L
.02644 .02445 -1.875 0 Mabsadd L closepath F
.03039 .02835 -1.875 0 Mabsadd m
.03039 .02835 0 2.5 Mabsadd L
.03039 .02835 1.875 0 Mabsadd L
.03039 .02835 0 -2.5 Mabsadd L
.03039 .02835 -1.875 0 Mabsadd L closepath F
.03302 .03199 -1.875 0 Mabsadd m
.03302 .03199 0 2.5 Mabsadd L
.03302 .03199 1.875 0 Mabsadd L
.03302 .03199 0 -2.5 Mabsadd L
.03302 .03199 -1.875 0 Mabsadd L closepath F
.03696 .03543 -1.875 0 Mabsadd m
.03696 .03543 0 2.5 Mabsadd L
.03696 .03543 1.875 0 Mabsadd L
.03696 .03543 0 -2.5 Mabsadd L
.03696 .03543 -1.875 0 Mabsadd L closepath F
.03828 .03871 -1.875 0 Mabsadd m
.03828 .03871 0 2.5 Mabsadd L
.03828 .03871 1.875 0 Mabsadd L
.03828 .03871 0 -2.5 Mabsadd L
.03828 .03871 -1.875 0 Mabsadd L closepath F
.04223 .04187 -1.875 0 Mabsadd m
.04223 .04187 0 2.5 Mabsadd L
.04223 .04187 1.875 0 Mabsadd L
.04223 .04187 0 -2.5 Mabsadd L
.04223 .04187 -1.875 0 Mabsadd L closepath F
.04749 .04492 -1.875 0 Mabsadd m
.04749 .04492 0 2.5 Mabsadd L
.04749 .04492 1.875 0 Mabsadd L
.04749 .04492 0 -2.5 Mabsadd L
.04749 .04492 -1.875 0 Mabsadd L closepath F
.05012 .04788 -1.875 0 Mabsadd m
.05012 .04788 0 2.5 Mabsadd L
.05012 .04788 1.875 0 Mabsadd L
.05012 .04788 0 -2.5 Mabsadd L
.05012 .04788 -1.875 0 Mabsadd L closepath F
.06064 .05076 -1.875 0 Mabsadd m
.06064 .05076 0 2.5 Mabsadd L
.06064 .05076 1.875 0 Mabsadd L
.06064 .05076 0 -2.5 Mabsadd L
.06064 .05076 -1.875 0 Mabsadd L closepath F
.06196 .05356 -1.875 0 Mabsadd m
.06196 .05356 0 2.5 Mabsadd L
.06196 .05356 1.875 0 Mabsadd L
.06196 .05356 0 -2.5 Mabsadd L
.06196 .05356 -1.875 0 Mabsadd L closepath F
.06327 .05629 -1.875 0 Mabsadd m
.06327 .05629 0 2.5 Mabsadd L
.06327 .05629 1.875 0 Mabsadd L
.06327 .05629 0 -2.5 Mabsadd L
.06327 .05629 -1.875 0 Mabsadd L closepath F
.0659 .05897 -1.875 0 Mabsadd m
.0659 .05897 0 2.5 Mabsadd L
.0659 .05897 1.875 0 Mabsadd L
.0659 .05897 0 -2.5 Mabsadd L
.0659 .05897 -1.875 0 Mabsadd L closepath F
.06985 .06158 -1.875 0 Mabsadd m
.06985 .06158 0 2.5 Mabsadd L
.06985 .06158 1.875 0 Mabsadd L
.06985 .06158 0 -2.5 Mabsadd L
.06985 .06158 -1.875 0 Mabsadd L closepath F
.0738 .06415 -1.875 0 Mabsadd m
.0738 .06415 0 2.5 Mabsadd L
.0738 .06415 1.875 0 Mabsadd L
.0738 .06415 0 -2.5 Mabsadd L
.0738 .06415 -1.875 0 Mabsadd L closepath F
.07774 .06667 -1.875 0 Mabsadd m
.07774 .06667 0 2.5 Mabsadd L
.07774 .06667 1.875 0 Mabsadd L
.07774 .06667 0 -2.5 Mabsadd L
.07774 .06667 -1.875 0 Mabsadd L closepath F
.08169 .06915 -1.875 0 Mabsadd m
.08169 .06915 0 2.5 Mabsadd L
.08169 .06915 1.875 0 Mabsadd L
.08169 .06915 0 -2.5 Mabsadd L
.08169 .06915 -1.875 0 Mabsadd L closepath F
.083 .07158 -1.875 0 Mabsadd m
.083 .07158 0 2.5 Mabsadd L
.083 .07158 1.875 0 Mabsadd L
.083 .07158 0 -2.5 Mabsadd L
.083 .07158 -1.875 0 Mabsadd L closepath F
.08827 .07397 -1.875 0 Mabsadd m
.08827 .07397 0 2.5 Mabsadd L
.08827 .07397 1.875 0 Mabsadd L
.08827 .07397 0 -2.5 Mabsadd L
.08827 .07397 -1.875 0 Mabsadd L closepath F
.0909 .07633 -1.875 0 Mabsadd m
.0909 .07633 0 2.5 Mabsadd L
.0909 .07633 1.875 0 Mabsadd L
.0909 .07633 0 -2.5 Mabsadd L
.0909 .07633 -1.875 0 Mabsadd L closepath F
.10142 .07865 -1.875 0 Mabsadd m
.10142 .07865 0 2.5 Mabsadd L
.10142 .07865 1.875 0 Mabsadd L
.10142 .07865 0 -2.5 Mabsadd L
.10142 .07865 -1.875 0 Mabsadd L closepath F
.10668 .08094 -1.875 0 Mabsadd m
.10668 .08094 0 2.5 Mabsadd L
.10668 .08094 1.875 0 Mabsadd L
.10668 .08094 0 -2.5 Mabsadd L
.10668 .08094 -1.875 0 Mabsadd L closepath F
.10931 .0832 -1.875 0 Mabsadd m
.10931 .0832 0 2.5 Mabsadd L
.10931 .0832 1.875 0 Mabsadd L
.10931 .0832 0 -2.5 Mabsadd L
.10931 .0832 -1.875 0 Mabsadd L closepath F
.11589 .08543 -1.875 0 Mabsadd m
.11589 .08543 0 2.5 Mabsadd L
.11589 .08543 1.875 0 Mabsadd L
.11589 .08543 0 -2.5 Mabsadd L
.11589 .08543 -1.875 0 Mabsadd L closepath F
.11721 .08763 -1.875 0 Mabsadd m
.11721 .08763 0 2.5 Mabsadd L
.11721 .08763 1.875 0 Mabsadd L
.11721 .08763 0 -2.5 Mabsadd L
.11721 .08763 -1.875 0 Mabsadd L closepath F
.11984 .08981 -1.875 0 Mabsadd m
.11984 .08981 0 2.5 Mabsadd L
.11984 .08981 1.875 0 Mabsadd L
.11984 .08981 0 -2.5 Mabsadd L
.11984 .08981 -1.875 0 Mabsadd L closepath F
.12378 .09196 -1.875 0 Mabsadd m
.12378 .09196 0 2.5 Mabsadd L
.12378 .09196 1.875 0 Mabsadd L
.12378 .09196 0 -2.5 Mabsadd L
.12378 .09196 -1.875 0 Mabsadd L closepath F
.1251 .09408 -1.875 0 Mabsadd m
.1251 .09408 0 2.5 Mabsadd L
.1251 .09408 1.875 0 Mabsadd L
.1251 .09408 0 -2.5 Mabsadd L
.1251 .09408 -1.875 0 Mabsadd L closepath F
.1251 .09618 -1.875 0 Mabsadd m
.1251 .09618 0 2.5 Mabsadd L
.1251 .09618 1.875 0 Mabsadd L
.1251 .09618 0 -2.5 Mabsadd L
.1251 .09618 -1.875 0 Mabsadd L closepath F
.12641 .09826 -1.875 0 Mabsadd m
.12641 .09826 0 2.5 Mabsadd L
.12641 .09826 1.875 0 Mabsadd L
.12641 .09826 0 -2.5 Mabsadd L
.12641 .09826 -1.875 0 Mabsadd L closepath F
.12773 .10031 -1.875 0 Mabsadd m
.12773 .10031 0 2.5 Mabsadd L
.12773 .10031 1.875 0 Mabsadd L
.12773 .10031 0 -2.5 Mabsadd L
.12773 .10031 -1.875 0 Mabsadd L closepath F
.12773 .10234 -1.875 0 Mabsadd m
.12773 .10234 0 2.5 Mabsadd L
.12773 .10234 1.875 0 Mabsadd L
.12773 .10234 0 -2.5 Mabsadd L
.12773 .10234 -1.875 0 Mabsadd L closepath F
.12904 .10436 -1.875 0 Mabsadd m
.12904 .10436 0 2.5 Mabsadd L
.12904 .10436 1.875 0 Mabsadd L
.12904 .10436 0 -2.5 Mabsadd L
.12904 .10436 -1.875 0 Mabsadd L closepath F
.13299 .10635 -1.875 0 Mabsadd m
.13299 .10635 0 2.5 Mabsadd L
.13299 .10635 1.875 0 Mabsadd L
.13299 .10635 0 -2.5 Mabsadd L
.13299 .10635 -1.875 0 Mabsadd L closepath F
.13431 .10832 -1.875 0 Mabsadd m
.13431 .10832 0 2.5 Mabsadd L
.13431 .10832 1.875 0 Mabsadd L
.13431 .10832 0 -2.5 Mabsadd L
.13431 .10832 -1.875 0 Mabsadd L closepath F
.13562 .11028 -1.875 0 Mabsadd m
.13562 .11028 0 2.5 Mabsadd L
.13562 .11028 1.875 0 Mabsadd L
.13562 .11028 0 -2.5 Mabsadd L
.13562 .11028 -1.875 0 Mabsadd L closepath F
.13825 .11222 -1.875 0 Mabsadd m
.13825 .11222 0 2.5 Mabsadd L
.13825 .11222 1.875 0 Mabsadd L
.13825 .11222 0 -2.5 Mabsadd L
.13825 .11222 -1.875 0 Mabsadd L closepath F
.1422 .11414 -1.875 0 Mabsadd m
.1422 .11414 0 2.5 Mabsadd L
.1422 .11414 1.875 0 Mabsadd L
.1422 .11414 0 -2.5 Mabsadd L
.1422 .11414 -1.875 0 Mabsadd L closepath F
.14615 .11604 -1.875 0 Mabsadd m
.14615 .11604 0 2.5 Mabsadd L
.14615 .11604 1.875 0 Mabsadd L
.14615 .11604 0 -2.5 Mabsadd L
.14615 .11604 -1.875 0 Mabsadd L closepath F
.14878 .11793 -1.875 0 Mabsadd m
.14878 .11793 0 2.5 Mabsadd L
.14878 .11793 1.875 0 Mabsadd L
.14878 .11793 0 -2.5 Mabsadd L
.14878 .11793 -1.875 0 Mabsadd L closepath F
.15141 .1198 -1.875 0 Mabsadd m
.15141 .1198 0 2.5 Mabsadd L
.15141 .1198 1.875 0 Mabsadd L
.15141 .1198 0 -2.5 Mabsadd L
.15141 .1198 -1.875 0 Mabsadd L closepath F
.15798 .12166 -1.875 0 Mabsadd m
.15798 .12166 0 2.5 Mabsadd L
.15798 .12166 1.875 0 Mabsadd L
.15798 .12166 0 -2.5 Mabsadd L
.15798 .12166 -1.875 0 Mabsadd L closepath F
.16062 .1235 -1.875 0 Mabsadd m
.16062 .1235 0 2.5 Mabsadd L
.16062 .1235 1.875 0 Mabsadd L
.16062 .1235 0 -2.5 Mabsadd L
.16062 .1235 -1.875 0 Mabsadd L closepath F
.16588 .12532 -1.875 0 Mabsadd m
.16588 .12532 0 2.5 Mabsadd L
.16588 .12532 1.875 0 Mabsadd L
.16588 .12532 0 -2.5 Mabsadd L
.16588 .12532 -1.875 0 Mabsadd L closepath F
.16588 .12714 -1.875 0 Mabsadd m
.16588 .12714 0 2.5 Mabsadd L
.16588 .12714 1.875 0 Mabsadd L
.16588 .12714 0 -2.5 Mabsadd L
.16588 .12714 -1.875 0 Mabsadd L closepath F
.16719 .12894 -1.875 0 Mabsadd m
.16719 .12894 0 2.5 Mabsadd L
.16719 .12894 1.875 0 Mabsadd L
.16719 .12894 0 -2.5 Mabsadd L
.16719 .12894 -1.875 0 Mabsadd L closepath F
.17377 .13072 -1.875 0 Mabsadd m
.17377 .13072 0 2.5 Mabsadd L
.17377 .13072 1.875 0 Mabsadd L
.17377 .13072 0 -2.5 Mabsadd L
.17377 .13072 -1.875 0 Mabsadd L closepath F
.1764 .13249 -1.875 0 Mabsadd m
.1764 .13249 0 2.5 Mabsadd L
.1764 .13249 1.875 0 Mabsadd L
.1764 .13249 0 -2.5 Mabsadd L
.1764 .13249 -1.875 0 Mabsadd L closepath F
.18166 .13425 -1.875 0 Mabsadd m
.18166 .13425 0 2.5 Mabsadd L
.18166 .13425 1.875 0 Mabsadd L
.18166 .13425 0 -2.5 Mabsadd L
.18166 .13425 -1.875 0 Mabsadd L closepath F
.18561 .136 -1.875 0 Mabsadd m
.18561 .136 0 2.5 Mabsadd L
.18561 .136 1.875 0 Mabsadd L
.18561 .136 0 -2.5 Mabsadd L
.18561 .136 -1.875 0 Mabsadd L closepath F
.19219 .13773 -1.875 0 Mabsadd m
.19219 .13773 0 2.5 Mabsadd L
.19219 .13773 1.875 0 Mabsadd L
.19219 .13773 0 -2.5 Mabsadd L
.19219 .13773 -1.875 0 Mabsadd L closepath F
.19482 .13946 -1.875 0 Mabsadd m
.19482 .13946 0 2.5 Mabsadd L
.19482 .13946 1.875 0 Mabsadd L
.19482 .13946 0 -2.5 Mabsadd L
.19482 .13946 -1.875 0 Mabsadd L closepath F
.19482 .14117 -1.875 0 Mabsadd m
.19482 .14117 0 2.5 Mabsadd L
.19482 .14117 1.875 0 Mabsadd L
.19482 .14117 0 -2.5 Mabsadd L
.19482 .14117 -1.875 0 Mabsadd L closepath F
.20008 .14287 -1.875 0 Mabsadd m
.20008 .14287 0 2.5 Mabsadd L
.20008 .14287 1.875 0 Mabsadd L
.20008 .14287 0 -2.5 Mabsadd L
.20008 .14287 -1.875 0 Mabsadd L closepath F
.20008 .14456 -1.875 0 Mabsadd m
.20008 .14456 0 2.5 Mabsadd L
.20008 .14456 1.875 0 Mabsadd L
.20008 .14456 0 -2.5 Mabsadd L
.20008 .14456 -1.875 0 Mabsadd L closepath F
.20534 .14623 -1.875 0 Mabsadd m
.20534 .14623 0 2.5 Mabsadd L
.20534 .14623 1.875 0 Mabsadd L
.20534 .14623 0 -2.5 Mabsadd L
.20534 .14623 -1.875 0 Mabsadd L closepath F
.20666 .1479 -1.875 0 Mabsadd m
.20666 .1479 0 2.5 Mabsadd L
.20666 .1479 1.875 0 Mabsadd L
.20666 .1479 0 -2.5 Mabsadd L
.20666 .1479 -1.875 0 Mabsadd L closepath F
.20797 .14956 -1.875 0 Mabsadd m
.20797 .14956 0 2.5 Mabsadd L
.20797 .14956 1.875 0 Mabsadd L
.20797 .14956 0 -2.5 Mabsadd L
.20797 .14956 -1.875 0 Mabsadd L closepath F
.21323 .1512 -1.875 0 Mabsadd m
.21323 .1512 0 2.5 Mabsadd L
.21323 .1512 1.875 0 Mabsadd L
.21323 .1512 0 -2.5 Mabsadd L
.21323 .1512 -1.875 0 Mabsadd L closepath F
.21718 .15284 -1.875 0 Mabsadd m
.21718 .15284 0 2.5 Mabsadd L
.21718 .15284 1.875 0 Mabsadd L
.21718 .15284 0 -2.5 Mabsadd L
.21718 .15284 -1.875 0 Mabsadd L closepath F
.22244 .15446 -1.875 0 Mabsadd m
.22244 .15446 0 2.5 Mabsadd L
.22244 .15446 1.875 0 Mabsadd L
.22244 .15446 0 -2.5 Mabsadd L
.22244 .15446 -1.875 0 Mabsadd L closepath F
.22639 .15608 -1.875 0 Mabsadd m
.22639 .15608 0 2.5 Mabsadd L
.22639 .15608 1.875 0 Mabsadd L
.22639 .15608 0 -2.5 Mabsadd L
.22639 .15608 -1.875 0 Mabsadd L closepath F
.22639 .15769 -1.875 0 Mabsadd m
.22639 .15769 0 2.5 Mabsadd L
.22639 .15769 1.875 0 Mabsadd L
.22639 .15769 0 -2.5 Mabsadd L
.22639 .15769 -1.875 0 Mabsadd L closepath F
.2277 .15929 -1.875 0 Mabsadd m
.2277 .15929 0 2.5 Mabsadd L
.2277 .15929 1.875 0 Mabsadd L
.2277 .15929 0 -2.5 Mabsadd L
.2277 .15929 -1.875 0 Mabsadd L closepath F
.22902 .16087 -1.875 0 Mabsadd m
.22902 .16087 0 2.5 Mabsadd L
.22902 .16087 1.875 0 Mabsadd L
.22902 .16087 0 -2.5 Mabsadd L
.22902 .16087 -1.875 0 Mabsadd L closepath F
.2356 .16245 -1.875 0 Mabsadd m
.2356 .16245 0 2.5 Mabsadd L
.2356 .16245 1.875 0 Mabsadd L
.2356 .16245 0 -2.5 Mabsadd L
.2356 .16245 -1.875 0 Mabsadd L closepath F
.23691 .16403 -1.875 0 Mabsadd m
.23691 .16403 0 2.5 Mabsadd L
.23691 .16403 1.875 0 Mabsadd L
.23691 .16403 0 -2.5 Mabsadd L
.23691 .16403 -1.875 0 Mabsadd L closepath F
.23954 .16559 -1.875 0 Mabsadd m
.23954 .16559 0 2.5 Mabsadd L
.23954 .16559 1.875 0 Mabsadd L
.23954 .16559 0 -2.5 Mabsadd L
.23954 .16559 -1.875 0 Mabsadd L closepath F
.24217 .16714 -1.875 0 Mabsadd m
.24217 .16714 0 2.5 Mabsadd L
.24217 .16714 1.875 0 Mabsadd L
.24217 .16714 0 -2.5 Mabsadd L
.24217 .16714 -1.875 0 Mabsadd L closepath F
.24217 .16869 -1.875 0 Mabsadd m
.24217 .16869 0 2.5 Mabsadd L
.24217 .16869 1.875 0 Mabsadd L
.24217 .16869 0 -2.5 Mabsadd L
.24217 .16869 -1.875 0 Mabsadd L closepath F
.2448 .17022 -1.875 0 Mabsadd m
.2448 .17022 0 2.5 Mabsadd L
.2448 .17022 1.875 0 Mabsadd L
.2448 .17022 0 -2.5 Mabsadd L
.2448 .17022 -1.875 0 Mabsadd L closepath F
.2448 .17175 -1.875 0 Mabsadd m
.2448 .17175 0 2.5 Mabsadd L
.2448 .17175 1.875 0 Mabsadd L
.2448 .17175 0 -2.5 Mabsadd L
.2448 .17175 -1.875 0 Mabsadd L closepath F
.25138 .17328 -1.875 0 Mabsadd m
.25138 .17328 0 2.5 Mabsadd L
.25138 .17328 1.875 0 Mabsadd L
.25138 .17328 0 -2.5 Mabsadd L
.25138 .17328 -1.875 0 Mabsadd L closepath F
.2527 .17479 -1.875 0 Mabsadd m
.2527 .17479 0 2.5 Mabsadd L
.2527 .17479 1.875 0 Mabsadd L
.2527 .17479 0 -2.5 Mabsadd L
.2527 .17479 -1.875 0 Mabsadd L closepath F
.25401 .17629 -1.875 0 Mabsadd m
.25401 .17629 0 2.5 Mabsadd L
.25401 .17629 1.875 0 Mabsadd L
.25401 .17629 0 -2.5 Mabsadd L
.25401 .17629 -1.875 0 Mabsadd L closepath F
.25796 .17779 -1.875 0 Mabsadd m
.25796 .17779 0 2.5 Mabsadd L
.25796 .17779 1.875 0 Mabsadd L
.25796 .17779 0 -2.5 Mabsadd L
.25796 .17779 -1.875 0 Mabsadd L closepath F
.2619 .17928 -1.875 0 Mabsadd m
.2619 .17928 0 2.5 Mabsadd L
.2619 .17928 1.875 0 Mabsadd L
.2619 .17928 0 -2.5 Mabsadd L
.2619 .17928 -1.875 0 Mabsadd L closepath F
.26717 .18077 -1.875 0 Mabsadd m
.26717 .18077 0 2.5 Mabsadd L
.26717 .18077 1.875 0 Mabsadd L
.26717 .18077 0 -2.5 Mabsadd L
.26717 .18077 -1.875 0 Mabsadd L closepath F
.27374 .18224 -1.875 0 Mabsadd m
.27374 .18224 0 2.5 Mabsadd L
.27374 .18224 1.875 0 Mabsadd L
.27374 .18224 0 -2.5 Mabsadd L
.27374 .18224 -1.875 0 Mabsadd L closepath F
.27637 .18371 -1.875 0 Mabsadd m
.27637 .18371 0 2.5 Mabsadd L
.27637 .18371 1.875 0 Mabsadd L
.27637 .18371 0 -2.5 Mabsadd L
.27637 .18371 -1.875 0 Mabsadd L closepath F
.27901 .18518 -1.875 0 Mabsadd m
.27901 .18518 0 2.5 Mabsadd L
.27901 .18518 1.875 0 Mabsadd L
.27901 .18518 0 -2.5 Mabsadd L
.27901 .18518 -1.875 0 Mabsadd L closepath F
.28032 .18663 -1.875 0 Mabsadd m
.28032 .18663 0 2.5 Mabsadd L
.28032 .18663 1.875 0 Mabsadd L
.28032 .18663 0 -2.5 Mabsadd L
.28032 .18663 -1.875 0 Mabsadd L closepath F
.28032 .18808 -1.875 0 Mabsadd m
.28032 .18808 0 2.5 Mabsadd L
.28032 .18808 1.875 0 Mabsadd L
.28032 .18808 0 -2.5 Mabsadd L
.28032 .18808 -1.875 0 Mabsadd L closepath F
.28295 .18952 -1.875 0 Mabsadd m
.28295 .18952 0 2.5 Mabsadd L
.28295 .18952 1.875 0 Mabsadd L
.28295 .18952 0 -2.5 Mabsadd L
.28295 .18952 -1.875 0 Mabsadd L closepath F
.28558 .19096 -1.875 0 Mabsadd m
.28558 .19096 0 2.5 Mabsadd L
.28558 .19096 1.875 0 Mabsadd L
.28558 .19096 0 -2.5 Mabsadd L
.28558 .19096 -1.875 0 Mabsadd L closepath F
.28821 .19239 -1.875 0 Mabsadd m
.28821 .19239 0 2.5 Mabsadd L
.28821 .19239 1.875 0 Mabsadd L
.28821 .19239 0 -2.5 Mabsadd L
.28821 .19239 -1.875 0 Mabsadd L closepath F
.29216 .19381 -1.875 0 Mabsadd m
.29216 .19381 0 2.5 Mabsadd L
.29216 .19381 1.875 0 Mabsadd L
.29216 .19381 0 -2.5 Mabsadd L
.29216 .19381 -1.875 0 Mabsadd L closepath F
.29348 .19523 -1.875 0 Mabsadd m
.29348 .19523 0 2.5 Mabsadd L
.29348 .19523 1.875 0 Mabsadd L
.29348 .19523 0 -2.5 Mabsadd L
.29348 .19523 -1.875 0 Mabsadd L closepath F
.29742 .19664 -1.875 0 Mabsadd m
.29742 .19664 0 2.5 Mabsadd L
.29742 .19664 1.875 0 Mabsadd L
.29742 .19664 0 -2.5 Mabsadd L
.29742 .19664 -1.875 0 Mabsadd L closepath F
.30137 .19804 -1.875 0 Mabsadd m
.30137 .19804 0 2.5 Mabsadd L
.30137 .19804 1.875 0 Mabsadd L
.30137 .19804 0 -2.5 Mabsadd L
.30137 .19804 -1.875 0 Mabsadd L closepath F
.30531 .19944 -1.875 0 Mabsadd m
.30531 .19944 0 2.5 Mabsadd L
.30531 .19944 1.875 0 Mabsadd L
.30531 .19944 0 -2.5 Mabsadd L
.30531 .19944 -1.875 0 Mabsadd L closepath F
.30663 .20083 -1.875 0 Mabsadd m
.30663 .20083 0 2.5 Mabsadd L
.30663 .20083 1.875 0 Mabsadd L
.30663 .20083 0 -2.5 Mabsadd L
.30663 .20083 -1.875 0 Mabsadd L closepath F
.30663 .20222 -1.875 0 Mabsadd m
.30663 .20222 0 2.5 Mabsadd L
.30663 .20222 1.875 0 Mabsadd L
.30663 .20222 0 -2.5 Mabsadd L
.30663 .20222 -1.875 0 Mabsadd L closepath F
.31058 .2036 -1.875 0 Mabsadd m
.31058 .2036 0 2.5 Mabsadd L
.31058 .2036 1.875 0 Mabsadd L
.31058 .2036 0 -2.5 Mabsadd L
.31058 .2036 -1.875 0 Mabsadd L closepath F
.31189 .20497 -1.875 0 Mabsadd m
.31189 .20497 0 2.5 Mabsadd L
.31189 .20497 1.875 0 Mabsadd L
.31189 .20497 0 -2.5 Mabsadd L
.31189 .20497 -1.875 0 Mabsadd L closepath F
.31321 .20634 -1.875 0 Mabsadd m
.31321 .20634 0 2.5 Mabsadd L
.31321 .20634 1.875 0 Mabsadd L
.31321 .20634 0 -2.5 Mabsadd L
.31321 .20634 -1.875 0 Mabsadd L closepath F
.31584 .2077 -1.875 0 Mabsadd m
.31584 .2077 0 2.5 Mabsadd L
.31584 .2077 1.875 0 Mabsadd L
.31584 .2077 0 -2.5 Mabsadd L
.31584 .2077 -1.875 0 Mabsadd L closepath F
.31847 .20906 -1.875 0 Mabsadd m
.31847 .20906 0 2.5 Mabsadd L
.31847 .20906 1.875 0 Mabsadd L
.31847 .20906 0 -2.5 Mabsadd L
.31847 .20906 -1.875 0 Mabsadd L closepath F
.32373 .21041 -1.875 0 Mabsadd m
.32373 .21041 0 2.5 Mabsadd L
.32373 .21041 1.875 0 Mabsadd L
.32373 .21041 0 -2.5 Mabsadd L
.32373 .21041 -1.875 0 Mabsadd L closepath F
.32505 .21176 -1.875 0 Mabsadd m
.32505 .21176 0 2.5 Mabsadd L
.32505 .21176 1.875 0 Mabsadd L
.32505 .21176 0 -2.5 Mabsadd L
.32505 .21176 -1.875 0 Mabsadd L closepath F
.32636 .2131 -1.875 0 Mabsadd m
.32636 .2131 0 2.5 Mabsadd L
.32636 .2131 1.875 0 Mabsadd L
.32636 .2131 0 -2.5 Mabsadd L
.32636 .2131 -1.875 0 Mabsadd L closepath F
.32768 .21444 -1.875 0 Mabsadd m
.32768 .21444 0 2.5 Mabsadd L
.32768 .21444 1.875 0 Mabsadd L
.32768 .21444 0 -2.5 Mabsadd L
.32768 .21444 -1.875 0 Mabsadd L closepath F
.33162 .21577 -1.875 0 Mabsadd m
.33162 .21577 0 2.5 Mabsadd L
.33162 .21577 1.875 0 Mabsadd L
.33162 .21577 0 -2.5 Mabsadd L
.33162 .21577 -1.875 0 Mabsadd L closepath F
.33162 .21709 -1.875 0 Mabsadd m
.33162 .21709 0 2.5 Mabsadd L
.33162 .21709 1.875 0 Mabsadd L
.33162 .21709 0 -2.5 Mabsadd L
.33162 .21709 -1.875 0 Mabsadd L closepath F
.33557 .21841 -1.875 0 Mabsadd m
.33557 .21841 0 2.5 Mabsadd L
.33557 .21841 1.875 0 Mabsadd L
.33557 .21841 0 -2.5 Mabsadd L
.33557 .21841 -1.875 0 Mabsadd L closepath F
.33557 .21973 -1.875 0 Mabsadd m
.33557 .21973 0 2.5 Mabsadd L
.33557 .21973 1.875 0 Mabsadd L
.33557 .21973 0 -2.5 Mabsadd L
.33557 .21973 -1.875 0 Mabsadd L closepath F
.34083 .22104 -1.875 0 Mabsadd m
.34083 .22104 0 2.5 Mabsadd L
.34083 .22104 1.875 0 Mabsadd L
.34083 .22104 0 -2.5 Mabsadd L
.34083 .22104 -1.875 0 Mabsadd L closepath F
.34478 .22235 -1.875 0 Mabsadd m
.34478 .22235 0 2.5 Mabsadd L
.34478 .22235 1.875 0 Mabsadd L
.34478 .22235 0 -2.5 Mabsadd L
.34478 .22235 -1.875 0 Mabsadd L closepath F
.34609 .22365 -1.875 0 Mabsadd m
.34609 .22365 0 2.5 Mabsadd L
.34609 .22365 1.875 0 Mabsadd L
.34609 .22365 0 -2.5 Mabsadd L
.34609 .22365 -1.875 0 Mabsadd L closepath F
.35004 .22494 -1.875 0 Mabsadd m
.35004 .22494 0 2.5 Mabsadd L
.35004 .22494 1.875 0 Mabsadd L
.35004 .22494 0 -2.5 Mabsadd L
.35004 .22494 -1.875 0 Mabsadd L closepath F
.35399 .22623 -1.875 0 Mabsadd m
.35399 .22623 0 2.5 Mabsadd L
.35399 .22623 1.875 0 Mabsadd L
.35399 .22623 0 -2.5 Mabsadd L
.35399 .22623 -1.875 0 Mabsadd L closepath F
.35399 .22752 -1.875 0 Mabsadd m
.35399 .22752 0 2.5 Mabsadd L
.35399 .22752 1.875 0 Mabsadd L
.35399 .22752 0 -2.5 Mabsadd L
.35399 .22752 -1.875 0 Mabsadd L closepath F
.35399 .2288 -1.875 0 Mabsadd m
.35399 .2288 0 2.5 Mabsadd L
.35399 .2288 1.875 0 Mabsadd L
.35399 .2288 0 -2.5 Mabsadd L
.35399 .2288 -1.875 0 Mabsadd L closepath F
.35925 .23008 -1.875 0 Mabsadd m
.35925 .23008 0 2.5 Mabsadd L
.35925 .23008 1.875 0 Mabsadd L
.35925 .23008 0 -2.5 Mabsadd L
.35925 .23008 -1.875 0 Mabsadd L closepath F
.36188 .23135 -1.875 0 Mabsadd m
.36188 .23135 0 2.5 Mabsadd L
.36188 .23135 1.875 0 Mabsadd L
.36188 .23135 0 -2.5 Mabsadd L
.36188 .23135 -1.875 0 Mabsadd L closepath F
.36714 .23262 -1.875 0 Mabsadd m
.36714 .23262 0 2.5 Mabsadd L
.36714 .23262 1.875 0 Mabsadd L
.36714 .23262 0 -2.5 Mabsadd L
.36714 .23262 -1.875 0 Mabsadd L closepath F
.36977 .23389 -1.875 0 Mabsadd m
.36977 .23389 0 2.5 Mabsadd L
.36977 .23389 1.875 0 Mabsadd L
.36977 .23389 0 -2.5 Mabsadd L
.36977 .23389 -1.875 0 Mabsadd L closepath F
.3724 .23515 -1.875 0 Mabsadd m
.3724 .23515 0 2.5 Mabsadd L
.3724 .23515 1.875 0 Mabsadd L
.3724 .23515 0 -2.5 Mabsadd L
.3724 .23515 -1.875 0 Mabsadd L closepath F
.3724 .2364 -1.875 0 Mabsadd m
.3724 .2364 0 2.5 Mabsadd L
.3724 .2364 1.875 0 Mabsadd L
.3724 .2364 0 -2.5 Mabsadd L
.3724 .2364 -1.875 0 Mabsadd L closepath F
.37372 .23765 -1.875 0 Mabsadd m
.37372 .23765 0 2.5 Mabsadd L
.37372 .23765 1.875 0 Mabsadd L
.37372 .23765 0 -2.5 Mabsadd L
.37372 .23765 -1.875 0 Mabsadd L closepath F
.37372 .2389 -1.875 0 Mabsadd m
.37372 .2389 0 2.5 Mabsadd L
.37372 .2389 1.875 0 Mabsadd L
.37372 .2389 0 -2.5 Mabsadd L
.37372 .2389 -1.875 0 Mabsadd L closepath F
.37503 .24014 -1.875 0 Mabsadd m
.37503 .24014 0 2.5 Mabsadd L
.37503 .24014 1.875 0 Mabsadd L
.37503 .24014 0 -2.5 Mabsadd L
.37503 .24014 -1.875 0 Mabsadd L closepath F
.37766 .24138 -1.875 0 Mabsadd m
.37766 .24138 0 2.5 Mabsadd L
.37766 .24138 1.875 0 Mabsadd L
.37766 .24138 0 -2.5 Mabsadd L
.37766 .24138 -1.875 0 Mabsadd L closepath F
.37766 .24261 -1.875 0 Mabsadd m
.37766 .24261 0 2.5 Mabsadd L
.37766 .24261 1.875 0 Mabsadd L
.37766 .24261 0 -2.5 Mabsadd L
.37766 .24261 -1.875 0 Mabsadd L closepath F
.38029 .24384 -1.875 0 Mabsadd m
.38029 .24384 0 2.5 Mabsadd L
.38029 .24384 1.875 0 Mabsadd L
.38029 .24384 0 -2.5 Mabsadd L
.38029 .24384 -1.875 0 Mabsadd L closepath F
.38819 .24507 -1.875 0 Mabsadd m
.38819 .24507 0 2.5 Mabsadd L
.38819 .24507 1.875 0 Mabsadd L
.38819 .24507 0 -2.5 Mabsadd L
.38819 .24507 -1.875 0 Mabsadd L closepath F
.3895 .24629 -1.875 0 Mabsadd m
.3895 .24629 0 2.5 Mabsadd L
.3895 .24629 1.875 0 Mabsadd L
.3895 .24629 0 -2.5 Mabsadd L
.3895 .24629 -1.875 0 Mabsadd L closepath F
.39345 .24751 -1.875 0 Mabsadd m
.39345 .24751 0 2.5 Mabsadd L
.39345 .24751 1.875 0 Mabsadd L
.39345 .24751 0 -2.5 Mabsadd L
.39345 .24751 -1.875 0 Mabsadd L closepath F
.39871 .24872 -1.875 0 Mabsadd m
.39871 .24872 0 2.5 Mabsadd L
.39871 .24872 1.875 0 Mabsadd L
.39871 .24872 0 -2.5 Mabsadd L
.39871 .24872 -1.875 0 Mabsadd L closepath F
.40529 .24993 -1.875 0 Mabsadd m
.40529 .24993 0 2.5 Mabsadd L
.40529 .24993 1.875 0 Mabsadd L
.40529 .24993 0 -2.5 Mabsadd L
.40529 .24993 -1.875 0 Mabsadd L closepath F
.40792 .25114 -1.875 0 Mabsadd m
.40792 .25114 0 2.5 Mabsadd L
.40792 .25114 1.875 0 Mabsadd L
.40792 .25114 0 -2.5 Mabsadd L
.40792 .25114 -1.875 0 Mabsadd L closepath F
.41187 .25234 -1.875 0 Mabsadd m
.41187 .25234 0 2.5 Mabsadd L
.41187 .25234 1.875 0 Mabsadd L
.41187 .25234 0 -2.5 Mabsadd L
.41187 .25234 -1.875 0 Mabsadd L closepath F
.41581 .25354 -1.875 0 Mabsadd m
.41581 .25354 0 2.5 Mabsadd L
.41581 .25354 1.875 0 Mabsadd L
.41581 .25354 0 -2.5 Mabsadd L
.41581 .25354 -1.875 0 Mabsadd L closepath F
.41581 .25473 -1.875 0 Mabsadd m
.41581 .25473 0 2.5 Mabsadd L
.41581 .25473 1.875 0 Mabsadd L
.41581 .25473 0 -2.5 Mabsadd L
.41581 .25473 -1.875 0 Mabsadd L closepath F
.41844 .25592 -1.875 0 Mabsadd m
.41844 .25592 0 2.5 Mabsadd L
.41844 .25592 1.875 0 Mabsadd L
.41844 .25592 0 -2.5 Mabsadd L
.41844 .25592 -1.875 0 Mabsadd L closepath F
.41976 .25711 -1.875 0 Mabsadd m
.41976 .25711 0 2.5 Mabsadd L
.41976 .25711 1.875 0 Mabsadd L
.41976 .25711 0 -2.5 Mabsadd L
.41976 .25711 -1.875 0 Mabsadd L closepath F
.42107 .25829 -1.875 0 Mabsadd m
.42107 .25829 0 2.5 Mabsadd L
.42107 .25829 1.875 0 Mabsadd L
.42107 .25829 0 -2.5 Mabsadd L
.42107 .25829 -1.875 0 Mabsadd L closepath F
.4237 .25947 -1.875 0 Mabsadd m
.4237 .25947 0 2.5 Mabsadd L
.4237 .25947 1.875 0 Mabsadd L
.4237 .25947 0 -2.5 Mabsadd L
.4237 .25947 -1.875 0 Mabsadd L closepath F
.42502 .26065 -1.875 0 Mabsadd m
.42502 .26065 0 2.5 Mabsadd L
.42502 .26065 1.875 0 Mabsadd L
.42502 .26065 0 -2.5 Mabsadd L
.42502 .26065 -1.875 0 Mabsadd L closepath F
.42502 .26182 -1.875 0 Mabsadd m
.42502 .26182 0 2.5 Mabsadd L
.42502 .26182 1.875 0 Mabsadd L
.42502 .26182 0 -2.5 Mabsadd L
.42502 .26182 -1.875 0 Mabsadd L closepath F
.42502 .26299 -1.875 0 Mabsadd m
.42502 .26299 0 2.5 Mabsadd L
.42502 .26299 1.875 0 Mabsadd L
.42502 .26299 0 -2.5 Mabsadd L
.42502 .26299 -1.875 0 Mabsadd L closepath F
.42634 .26415 -1.875 0 Mabsadd m
.42634 .26415 0 2.5 Mabsadd L
.42634 .26415 1.875 0 Mabsadd L
.42634 .26415 0 -2.5 Mabsadd L
.42634 .26415 -1.875 0 Mabsadd L closepath F
.42634 .26532 -1.875 0 Mabsadd m
.42634 .26532 0 2.5 Mabsadd L
.42634 .26532 1.875 0 Mabsadd L
.42634 .26532 0 -2.5 Mabsadd L
.42634 .26532 -1.875 0 Mabsadd L closepath F
.4316 .26647 -1.875 0 Mabsadd m
.4316 .26647 0 2.5 Mabsadd L
.4316 .26647 1.875 0 Mabsadd L
.4316 .26647 0 -2.5 Mabsadd L
.4316 .26647 -1.875 0 Mabsadd L closepath F
.43423 .26763 -1.875 0 Mabsadd m
.43423 .26763 0 2.5 Mabsadd L
.43423 .26763 1.875 0 Mabsadd L
.43423 .26763 0 -2.5 Mabsadd L
.43423 .26763 -1.875 0 Mabsadd L closepath F
.43554 .26878 -1.875 0 Mabsadd m
.43554 .26878 0 2.5 Mabsadd L
.43554 .26878 1.875 0 Mabsadd L
.43554 .26878 0 -2.5 Mabsadd L
.43554 .26878 -1.875 0 Mabsadd L closepath F
.43817 .26993 -1.875 0 Mabsadd m
.43817 .26993 0 2.5 Mabsadd L
.43817 .26993 1.875 0 Mabsadd L
.43817 .26993 0 -2.5 Mabsadd L
.43817 .26993 -1.875 0 Mabsadd L closepath F
.43817 .27107 -1.875 0 Mabsadd m
.43817 .27107 0 2.5 Mabsadd L
.43817 .27107 1.875 0 Mabsadd L
.43817 .27107 0 -2.5 Mabsadd L
.43817 .27107 -1.875 0 Mabsadd L closepath F
.43949 .27222 -1.875 0 Mabsadd m
.43949 .27222 0 2.5 Mabsadd L
.43949 .27222 1.875 0 Mabsadd L
.43949 .27222 0 -2.5 Mabsadd L
.43949 .27222 -1.875 0 Mabsadd L closepath F
.44475 .27335 -1.875 0 Mabsadd m
.44475 .27335 0 2.5 Mabsadd L
.44475 .27335 1.875 0 Mabsadd L
.44475 .27335 0 -2.5 Mabsadd L
.44475 .27335 -1.875 0 Mabsadd L closepath F
.44738 .27449 -1.875 0 Mabsadd m
.44738 .27449 0 2.5 Mabsadd L
.44738 .27449 1.875 0 Mabsadd L
.44738 .27449 0 -2.5 Mabsadd L
.44738 .27449 -1.875 0 Mabsadd L closepath F
.45001 .27562 -1.875 0 Mabsadd m
.45001 .27562 0 2.5 Mabsadd L
.45001 .27562 1.875 0 Mabsadd L
.45001 .27562 0 -2.5 Mabsadd L
.45001 .27562 -1.875 0 Mabsadd L closepath F
.45264 .27675 -1.875 0 Mabsadd m
.45264 .27675 0 2.5 Mabsadd L
.45264 .27675 1.875 0 Mabsadd L
.45264 .27675 0 -2.5 Mabsadd L
.45264 .27675 -1.875 0 Mabsadd L closepath F
.45659 .27787 -1.875 0 Mabsadd m
.45659 .27787 0 2.5 Mabsadd L
.45659 .27787 1.875 0 Mabsadd L
.45659 .27787 0 -2.5 Mabsadd L
.45659 .27787 -1.875 0 Mabsadd L closepath F
.46054 .27899 -1.875 0 Mabsadd m
.46054 .27899 0 2.5 Mabsadd L
.46054 .27899 1.875 0 Mabsadd L
.46054 .27899 0 -2.5 Mabsadd L
.46054 .27899 -1.875 0 Mabsadd L closepath F
.46317 .28011 -1.875 0 Mabsadd m
.46317 .28011 0 2.5 Mabsadd L
.46317 .28011 1.875 0 Mabsadd L
.46317 .28011 0 -2.5 Mabsadd L
.46317 .28011 -1.875 0 Mabsadd L closepath F
.46317 .28123 -1.875 0 Mabsadd m
.46317 .28123 0 2.5 Mabsadd L
.46317 .28123 1.875 0 Mabsadd L
.46317 .28123 0 -2.5 Mabsadd L
.46317 .28123 -1.875 0 Mabsadd L closepath F
.46317 .28234 -1.875 0 Mabsadd m
.46317 .28234 0 2.5 Mabsadd L
.46317 .28234 1.875 0 Mabsadd L
.46317 .28234 0 -2.5 Mabsadd L
.46317 .28234 -1.875 0 Mabsadd L closepath F
.46448 .28345 -1.875 0 Mabsadd m
.46448 .28345 0 2.5 Mabsadd L
.46448 .28345 1.875 0 Mabsadd L
.46448 .28345 0 -2.5 Mabsadd L
.46448 .28345 -1.875 0 Mabsadd L closepath F
.4658 .28456 -1.875 0 Mabsadd m
.4658 .28456 0 2.5 Mabsadd L
.4658 .28456 1.875 0 Mabsadd L
.4658 .28456 0 -2.5 Mabsadd L
.4658 .28456 -1.875 0 Mabsadd L closepath F
.46974 .28566 -1.875 0 Mabsadd m
.46974 .28566 0 2.5 Mabsadd L
.46974 .28566 1.875 0 Mabsadd L
.46974 .28566 0 -2.5 Mabsadd L
.46974 .28566 -1.875 0 Mabsadd L closepath F
.47106 .28676 -1.875 0 Mabsadd m
.47106 .28676 0 2.5 Mabsadd L
.47106 .28676 1.875 0 Mabsadd L
.47106 .28676 0 -2.5 Mabsadd L
.47106 .28676 -1.875 0 Mabsadd L closepath F
.47238 .28786 -1.875 0 Mabsadd m
.47238 .28786 0 2.5 Mabsadd L
.47238 .28786 1.875 0 Mabsadd L
.47238 .28786 0 -2.5 Mabsadd L
.47238 .28786 -1.875 0 Mabsadd L closepath F
.47369 .28895 -1.875 0 Mabsadd m
.47369 .28895 0 2.5 Mabsadd L
.47369 .28895 1.875 0 Mabsadd L
.47369 .28895 0 -2.5 Mabsadd L
.47369 .28895 -1.875 0 Mabsadd L closepath F
.47501 .29004 -1.875 0 Mabsadd m
.47501 .29004 0 2.5 Mabsadd L
.47501 .29004 1.875 0 Mabsadd L
.47501 .29004 0 -2.5 Mabsadd L
.47501 .29004 -1.875 0 Mabsadd L closepath F
.47632 .29113 -1.875 0 Mabsadd m
.47632 .29113 0 2.5 Mabsadd L
.47632 .29113 1.875 0 Mabsadd L
.47632 .29113 0 -2.5 Mabsadd L
.47632 .29113 -1.875 0 Mabsadd L closepath F
.47764 .29222 -1.875 0 Mabsadd m
.47764 .29222 0 2.5 Mabsadd L
.47764 .29222 1.875 0 Mabsadd L
.47764 .29222 0 -2.5 Mabsadd L
.47764 .29222 -1.875 0 Mabsadd L closepath F
.47764 .2933 -1.875 0 Mabsadd m
.47764 .2933 0 2.5 Mabsadd L
.47764 .2933 1.875 0 Mabsadd L
.47764 .2933 0 -2.5 Mabsadd L
.47764 .2933 -1.875 0 Mabsadd L closepath F
.47895 .29438 -1.875 0 Mabsadd m
.47895 .29438 0 2.5 Mabsadd L
.47895 .29438 1.875 0 Mabsadd L
.47895 .29438 0 -2.5 Mabsadd L
.47895 .29438 -1.875 0 Mabsadd L closepath F
.47895 .29546 -1.875 0 Mabsadd m
.47895 .29546 0 2.5 Mabsadd L
.47895 .29546 1.875 0 Mabsadd L
.47895 .29546 0 -2.5 Mabsadd L
.47895 .29546 -1.875 0 Mabsadd L closepath F
.48158 .29653 -1.875 0 Mabsadd m
.48158 .29653 0 2.5 Mabsadd L
.48158 .29653 1.875 0 Mabsadd L
.48158 .29653 0 -2.5 Mabsadd L
.48158 .29653 -1.875 0 Mabsadd L closepath F
.4829 .2976 -1.875 0 Mabsadd m
.4829 .2976 0 2.5 Mabsadd L
.4829 .2976 1.875 0 Mabsadd L
.4829 .2976 0 -2.5 Mabsadd L
.4829 .2976 -1.875 0 Mabsadd L closepath F
.48553 .29867 -1.875 0 Mabsadd m
.48553 .29867 0 2.5 Mabsadd L
.48553 .29867 1.875 0 Mabsadd L
.48553 .29867 0 -2.5 Mabsadd L
.48553 .29867 -1.875 0 Mabsadd L closepath F
.48685 .29973 -1.875 0 Mabsadd m
.48685 .29973 0 2.5 Mabsadd L
.48685 .29973 1.875 0 Mabsadd L
.48685 .29973 0 -2.5 Mabsadd L
.48685 .29973 -1.875 0 Mabsadd L closepath F
.48685 .3008 -1.875 0 Mabsadd m
.48685 .3008 0 2.5 Mabsadd L
.48685 .3008 1.875 0 Mabsadd L
.48685 .3008 0 -2.5 Mabsadd L
.48685 .3008 -1.875 0 Mabsadd L closepath F
.48948 .30186 -1.875 0 Mabsadd m
.48948 .30186 0 2.5 Mabsadd L
.48948 .30186 1.875 0 Mabsadd L
.48948 .30186 0 -2.5 Mabsadd L
.48948 .30186 -1.875 0 Mabsadd L closepath F
.49211 .30291 -1.875 0 Mabsadd m
.49211 .30291 0 2.5 Mabsadd L
.49211 .30291 1.875 0 Mabsadd L
.49211 .30291 0 -2.5 Mabsadd L
.49211 .30291 -1.875 0 Mabsadd L closepath F
.49474 .30397 -1.875 0 Mabsadd m
.49474 .30397 0 2.5 Mabsadd L
.49474 .30397 1.875 0 Mabsadd L
.49474 .30397 0 -2.5 Mabsadd L
.49474 .30397 -1.875 0 Mabsadd L closepath F
.49605 .30502 -1.875 0 Mabsadd m
.49605 .30502 0 2.5 Mabsadd L
.49605 .30502 1.875 0 Mabsadd L
.49605 .30502 0 -2.5 Mabsadd L
.49605 .30502 -1.875 0 Mabsadd L closepath F
.49737 .30607 -1.875 0 Mabsadd m
.49737 .30607 0 2.5 Mabsadd L
.49737 .30607 1.875 0 Mabsadd L
.49737 .30607 0 -2.5 Mabsadd L
.49737 .30607 -1.875 0 Mabsadd L closepath F
.50132 .30711 -1.875 0 Mabsadd m
.50132 .30711 0 2.5 Mabsadd L
.50132 .30711 1.875 0 Mabsadd L
.50132 .30711 0 -2.5 Mabsadd L
.50132 .30711 -1.875 0 Mabsadd L closepath F
.50921 .30816 -1.875 0 Mabsadd m
.50921 .30816 0 2.5 Mabsadd L
.50921 .30816 1.875 0 Mabsadd L
.50921 .30816 0 -2.5 Mabsadd L
.50921 .30816 -1.875 0 Mabsadd L closepath F
.50921 .3092 -1.875 0 Mabsadd m
.50921 .3092 0 2.5 Mabsadd L
.50921 .3092 1.875 0 Mabsadd L
.50921 .3092 0 -2.5 Mabsadd L
.50921 .3092 -1.875 0 Mabsadd L closepath F
.51052 .31024 -1.875 0 Mabsadd m
.51052 .31024 0 2.5 Mabsadd L
.51052 .31024 1.875 0 Mabsadd L
.51052 .31024 0 -2.5 Mabsadd L
.51052 .31024 -1.875 0 Mabsadd L closepath F
.51184 .31127 -1.875 0 Mabsadd m
.51184 .31127 0 2.5 Mabsadd L
.51184 .31127 1.875 0 Mabsadd L
.51184 .31127 0 -2.5 Mabsadd L
.51184 .31127 -1.875 0 Mabsadd L closepath F
.51579 .31231 -1.875 0 Mabsadd m
.51579 .31231 0 2.5 Mabsadd L
.51579 .31231 1.875 0 Mabsadd L
.51579 .31231 0 -2.5 Mabsadd L
.51579 .31231 -1.875 0 Mabsadd L closepath F
.52105 .31334 -1.875 0 Mabsadd m
.52105 .31334 0 2.5 Mabsadd L
.52105 .31334 1.875 0 Mabsadd L
.52105 .31334 0 -2.5 Mabsadd L
.52105 .31334 -1.875 0 Mabsadd L closepath F
.52368 .31436 -1.875 0 Mabsadd m
.52368 .31436 0 2.5 Mabsadd L
.52368 .31436 1.875 0 Mabsadd L
.52368 .31436 0 -2.5 Mabsadd L
.52368 .31436 -1.875 0 Mabsadd L closepath F
.52499 .31539 -1.875 0 Mabsadd m
.52499 .31539 0 2.5 Mabsadd L
.52499 .31539 1.875 0 Mabsadd L
.52499 .31539 0 -2.5 Mabsadd L
.52499 .31539 -1.875 0 Mabsadd L closepath F
.52894 .31641 -1.875 0 Mabsadd m
.52894 .31641 0 2.5 Mabsadd L
.52894 .31641 1.875 0 Mabsadd L
.52894 .31641 0 -2.5 Mabsadd L
.52894 .31641 -1.875 0 Mabsadd L closepath F
.52894 .31743 -1.875 0 Mabsadd m
.52894 .31743 0 2.5 Mabsadd L
.52894 .31743 1.875 0 Mabsadd L
.52894 .31743 0 -2.5 Mabsadd L
.52894 .31743 -1.875 0 Mabsadd L closepath F
.52894 .31845 -1.875 0 Mabsadd m
.52894 .31845 0 2.5 Mabsadd L
.52894 .31845 1.875 0 Mabsadd L
.52894 .31845 0 -2.5 Mabsadd L
.52894 .31845 -1.875 0 Mabsadd L closepath F
.53157 .31947 -1.875 0 Mabsadd m
.53157 .31947 0 2.5 Mabsadd L
.53157 .31947 1.875 0 Mabsadd L
.53157 .31947 0 -2.5 Mabsadd L
.53157 .31947 -1.875 0 Mabsadd L closepath F
.53552 .32048 -1.875 0 Mabsadd m
.53552 .32048 0 2.5 Mabsadd L
.53552 .32048 1.875 0 Mabsadd L
.53552 .32048 0 -2.5 Mabsadd L
.53552 .32048 -1.875 0 Mabsadd L closepath F
.53946 .32149 -1.875 0 Mabsadd m
.53946 .32149 0 2.5 Mabsadd L
.53946 .32149 1.875 0 Mabsadd L
.53946 .32149 0 -2.5 Mabsadd L
.53946 .32149 -1.875 0 Mabsadd L closepath F
.53946 .3225 -1.875 0 Mabsadd m
.53946 .3225 0 2.5 Mabsadd L
.53946 .3225 1.875 0 Mabsadd L
.53946 .3225 0 -2.5 Mabsadd L
.53946 .3225 -1.875 0 Mabsadd L closepath F
.54078 .3235 -1.875 0 Mabsadd m
.54078 .3235 0 2.5 Mabsadd L
.54078 .3235 1.875 0 Mabsadd L
.54078 .3235 0 -2.5 Mabsadd L
.54078 .3235 -1.875 0 Mabsadd L closepath F
.54341 .32451 -1.875 0 Mabsadd m
.54341 .32451 0 2.5 Mabsadd L
.54341 .32451 1.875 0 Mabsadd L
.54341 .32451 0 -2.5 Mabsadd L
.54341 .32451 -1.875 0 Mabsadd L closepath F
.54473 .32551 -1.875 0 Mabsadd m
.54473 .32551 0 2.5 Mabsadd L
.54473 .32551 1.875 0 Mabsadd L
.54473 .32551 0 -2.5 Mabsadd L
.54473 .32551 -1.875 0 Mabsadd L closepath F
.54604 .32651 -1.875 0 Mabsadd m
.54604 .32651 0 2.5 Mabsadd L
.54604 .32651 1.875 0 Mabsadd L
.54604 .32651 0 -2.5 Mabsadd L
.54604 .32651 -1.875 0 Mabsadd L closepath F
.5513 .3275 -1.875 0 Mabsadd m
.5513 .3275 0 2.5 Mabsadd L
.5513 .3275 1.875 0 Mabsadd L
.5513 .3275 0 -2.5 Mabsadd L
.5513 .3275 -1.875 0 Mabsadd L closepath F
.55525 .3285 -1.875 0 Mabsadd m
.55525 .3285 0 2.5 Mabsadd L
.55525 .3285 1.875 0 Mabsadd L
.55525 .3285 0 -2.5 Mabsadd L
.55525 .3285 -1.875 0 Mabsadd L closepath F
.55525 .32949 -1.875 0 Mabsadd m
.55525 .32949 0 2.5 Mabsadd L
.55525 .32949 1.875 0 Mabsadd L
.55525 .32949 0 -2.5 Mabsadd L
.55525 .32949 -1.875 0 Mabsadd L closepath F
.55656 .33048 -1.875 0 Mabsadd m
.55656 .33048 0 2.5 Mabsadd L
.55656 .33048 1.875 0 Mabsadd L
.55656 .33048 0 -2.5 Mabsadd L
.55656 .33048 -1.875 0 Mabsadd L closepath F
.55656 .33146 -1.875 0 Mabsadd m
.55656 .33146 0 2.5 Mabsadd L
.55656 .33146 1.875 0 Mabsadd L
.55656 .33146 0 -2.5 Mabsadd L
.55656 .33146 -1.875 0 Mabsadd L closepath F
.55656 .33245 -1.875 0 Mabsadd m
.55656 .33245 0 2.5 Mabsadd L
.55656 .33245 1.875 0 Mabsadd L
.55656 .33245 0 -2.5 Mabsadd L
.55656 .33245 -1.875 0 Mabsadd L closepath F
.55919 .33343 -1.875 0 Mabsadd m
.55919 .33343 0 2.5 Mabsadd L
.55919 .33343 1.875 0 Mabsadd L
.55919 .33343 0 -2.5 Mabsadd L
.55919 .33343 -1.875 0 Mabsadd L closepath F
.56446 .33441 -1.875 0 Mabsadd m
.56446 .33441 0 2.5 Mabsadd L
.56446 .33441 1.875 0 Mabsadd L
.56446 .33441 0 -2.5 Mabsadd L
.56446 .33441 -1.875 0 Mabsadd L closepath F
.56709 .33539 -1.875 0 Mabsadd m
.56709 .33539 0 2.5 Mabsadd L
.56709 .33539 1.875 0 Mabsadd L
.56709 .33539 0 -2.5 Mabsadd L
.56709 .33539 -1.875 0 Mabsadd L closepath F
.56972 .33636 -1.875 0 Mabsadd m
.56972 .33636 0 2.5 Mabsadd L
.56972 .33636 1.875 0 Mabsadd L
.56972 .33636 0 -2.5 Mabsadd L
.56972 .33636 -1.875 0 Mabsadd L closepath F
.57366 .33733 -1.875 0 Mabsadd m
.57366 .33733 0 2.5 Mabsadd L
.57366 .33733 1.875 0 Mabsadd L
.57366 .33733 0 -2.5 Mabsadd L
.57366 .33733 -1.875 0 Mabsadd L closepath F
.5763 .3383 -1.875 0 Mabsadd m
.5763 .3383 0 2.5 Mabsadd L
.5763 .3383 1.875 0 Mabsadd L
.5763 .3383 0 -2.5 Mabsadd L
.5763 .3383 -1.875 0 Mabsadd L closepath F
.57761 .33927 -1.875 0 Mabsadd m
.57761 .33927 0 2.5 Mabsadd L
.57761 .33927 1.875 0 Mabsadd L
.57761 .33927 0 -2.5 Mabsadd L
.57761 .33927 -1.875 0 Mabsadd L closepath F
.57761 .34024 -1.875 0 Mabsadd m
.57761 .34024 0 2.5 Mabsadd L
.57761 .34024 1.875 0 Mabsadd L
.57761 .34024 0 -2.5 Mabsadd L
.57761 .34024 -1.875 0 Mabsadd L closepath F
.58024 .3412 -1.875 0 Mabsadd m
.58024 .3412 0 2.5 Mabsadd L
.58024 .3412 1.875 0 Mabsadd L
.58024 .3412 0 -2.5 Mabsadd L
.58024 .3412 -1.875 0 Mabsadd L closepath F
.58024 .34216 -1.875 0 Mabsadd m
.58024 .34216 0 2.5 Mabsadd L
.58024 .34216 1.875 0 Mabsadd L
.58024 .34216 0 -2.5 Mabsadd L
.58024 .34216 -1.875 0 Mabsadd L closepath F
.58024 .34312 -1.875 0 Mabsadd m
.58024 .34312 0 2.5 Mabsadd L
.58024 .34312 1.875 0 Mabsadd L
.58024 .34312 0 -2.5 Mabsadd L
.58024 .34312 -1.875 0 Mabsadd L closepath F
.58156 .34408 -1.875 0 Mabsadd m
.58156 .34408 0 2.5 Mabsadd L
.58156 .34408 1.875 0 Mabsadd L
.58156 .34408 0 -2.5 Mabsadd L
.58156 .34408 -1.875 0 Mabsadd L closepath F
.58287 .34503 -1.875 0 Mabsadd m
.58287 .34503 0 2.5 Mabsadd L
.58287 .34503 1.875 0 Mabsadd L
.58287 .34503 0 -2.5 Mabsadd L
.58287 .34503 -1.875 0 Mabsadd L closepath F
.5855 .34599 -1.875 0 Mabsadd m
.5855 .34599 0 2.5 Mabsadd L
.5855 .34599 1.875 0 Mabsadd L
.5855 .34599 0 -2.5 Mabsadd L
.5855 .34599 -1.875 0 Mabsadd L closepath F
.58813 .34694 -1.875 0 Mabsadd m
.58813 .34694 0 2.5 Mabsadd L
.58813 .34694 1.875 0 Mabsadd L
.58813 .34694 0 -2.5 Mabsadd L
.58813 .34694 -1.875 0 Mabsadd L closepath F
.58945 .34789 -1.875 0 Mabsadd m
.58945 .34789 0 2.5 Mabsadd L
.58945 .34789 1.875 0 Mabsadd L
.58945 .34789 0 -2.5 Mabsadd L
.58945 .34789 -1.875 0 Mabsadd L closepath F
.59077 .34883 -1.875 0 Mabsadd m
.59077 .34883 0 2.5 Mabsadd L
.59077 .34883 1.875 0 Mabsadd L
.59077 .34883 0 -2.5 Mabsadd L
.59077 .34883 -1.875 0 Mabsadd L closepath F
.59077 .34978 -1.875 0 Mabsadd m
.59077 .34978 0 2.5 Mabsadd L
.59077 .34978 1.875 0 Mabsadd L
.59077 .34978 0 -2.5 Mabsadd L
.59077 .34978 -1.875 0 Mabsadd L closepath F
.59471 .35072 -1.875 0 Mabsadd m
.59471 .35072 0 2.5 Mabsadd L
.59471 .35072 1.875 0 Mabsadd L
.59471 .35072 0 -2.5 Mabsadd L
.59471 .35072 -1.875 0 Mabsadd L closepath F
.59471 .35166 -1.875 0 Mabsadd m
.59471 .35166 0 2.5 Mabsadd L
.59471 .35166 1.875 0 Mabsadd L
.59471 .35166 0 -2.5 Mabsadd L
.59471 .35166 -1.875 0 Mabsadd L closepath F
.59471 .3526 -1.875 0 Mabsadd m
.59471 .3526 0 2.5 Mabsadd L
.59471 .3526 1.875 0 Mabsadd L
.59471 .3526 0 -2.5 Mabsadd L
.59471 .3526 -1.875 0 Mabsadd L closepath F
.59471 .35353 -1.875 0 Mabsadd m
.59471 .35353 0 2.5 Mabsadd L
.59471 .35353 1.875 0 Mabsadd L
.59471 .35353 0 -2.5 Mabsadd L
.59471 .35353 -1.875 0 Mabsadd L closepath F
.59603 .35447 -1.875 0 Mabsadd m
.59603 .35447 0 2.5 Mabsadd L
.59603 .35447 1.875 0 Mabsadd L
.59603 .35447 0 -2.5 Mabsadd L
.59603 .35447 -1.875 0 Mabsadd L closepath F
.59997 .3554 -1.875 0 Mabsadd m
.59997 .3554 0 2.5 Mabsadd L
.59997 .3554 1.875 0 Mabsadd L
.59997 .3554 0 -2.5 Mabsadd L
.59997 .3554 -1.875 0 Mabsadd L closepath F
.60392 .35633 -1.875 0 Mabsadd m
.60392 .35633 0 2.5 Mabsadd L
.60392 .35633 1.875 0 Mabsadd L
.60392 .35633 0 -2.5 Mabsadd L
.60392 .35633 -1.875 0 Mabsadd L closepath F
.60524 .35725 -1.875 0 Mabsadd m
.60524 .35725 0 2.5 Mabsadd L
.60524 .35725 1.875 0 Mabsadd L
.60524 .35725 0 -2.5 Mabsadd L
.60524 .35725 -1.875 0 Mabsadd L closepath F
.60655 .35818 -1.875 0 Mabsadd m
.60655 .35818 0 2.5 Mabsadd L
.60655 .35818 1.875 0 Mabsadd L
.60655 .35818 0 -2.5 Mabsadd L
.60655 .35818 -1.875 0 Mabsadd L closepath F
.60918 .3591 -1.875 0 Mabsadd m
.60918 .3591 0 2.5 Mabsadd L
.60918 .3591 1.875 0 Mabsadd L
.60918 .3591 0 -2.5 Mabsadd L
.60918 .3591 -1.875 0 Mabsadd L closepath F
.60918 .36002 -1.875 0 Mabsadd m
.60918 .36002 0 2.5 Mabsadd L
.60918 .36002 1.875 0 Mabsadd L
.60918 .36002 0 -2.5 Mabsadd L
.60918 .36002 -1.875 0 Mabsadd L closepath F
.6105 .36094 -1.875 0 Mabsadd m
.6105 .36094 0 2.5 Mabsadd L
.6105 .36094 1.875 0 Mabsadd L
.6105 .36094 0 -2.5 Mabsadd L
.6105 .36094 -1.875 0 Mabsadd L closepath F
.61444 .36186 -1.875 0 Mabsadd m
.61444 .36186 0 2.5 Mabsadd L
.61444 .36186 1.875 0 Mabsadd L
.61444 .36186 0 -2.5 Mabsadd L
.61444 .36186 -1.875 0 Mabsadd L closepath F
.61707 .36278 -1.875 0 Mabsadd m
.61707 .36278 0 2.5 Mabsadd L
.61707 .36278 1.875 0 Mabsadd L
.61707 .36278 0 -2.5 Mabsadd L
.61707 .36278 -1.875 0 Mabsadd L closepath F
.61707 .36369 -1.875 0 Mabsadd m
.61707 .36369 0 2.5 Mabsadd L
.61707 .36369 1.875 0 Mabsadd L
.61707 .36369 0 -2.5 Mabsadd L
.61707 .36369 -1.875 0 Mabsadd L closepath F
.61707 .3646 -1.875 0 Mabsadd m
.61707 .3646 0 2.5 Mabsadd L
.61707 .3646 1.875 0 Mabsadd L
.61707 .3646 0 -2.5 Mabsadd L
.61707 .3646 -1.875 0 Mabsadd L closepath F
.61707 .36551 -1.875 0 Mabsadd m
.61707 .36551 0 2.5 Mabsadd L
.61707 .36551 1.875 0 Mabsadd L
.61707 .36551 0 -2.5 Mabsadd L
.61707 .36551 -1.875 0 Mabsadd L closepath F
.61839 .36642 -1.875 0 Mabsadd m
.61839 .36642 0 2.5 Mabsadd L
.61839 .36642 1.875 0 Mabsadd L
.61839 .36642 0 -2.5 Mabsadd L
.61839 .36642 -1.875 0 Mabsadd L closepath F
.62102 .36732 -1.875 0 Mabsadd m
.62102 .36732 0 2.5 Mabsadd L
.62102 .36732 1.875 0 Mabsadd L
.62102 .36732 0 -2.5 Mabsadd L
.62102 .36732 -1.875 0 Mabsadd L closepath F
.62497 .36822 -1.875 0 Mabsadd m
.62497 .36822 0 2.5 Mabsadd L
.62497 .36822 1.875 0 Mabsadd L
.62497 .36822 0 -2.5 Mabsadd L
.62497 .36822 -1.875 0 Mabsadd L closepath F
.62497 .36912 -1.875 0 Mabsadd m
.62497 .36912 0 2.5 Mabsadd L
.62497 .36912 1.875 0 Mabsadd L
.62497 .36912 0 -2.5 Mabsadd L
.62497 .36912 -1.875 0 Mabsadd L closepath F
.6276 .37002 -1.875 0 Mabsadd m
.6276 .37002 0 2.5 Mabsadd L
.6276 .37002 1.875 0 Mabsadd L
.6276 .37002 0 -2.5 Mabsadd L
.6276 .37002 -1.875 0 Mabsadd L closepath F
.62891 .37092 -1.875 0 Mabsadd m
.62891 .37092 0 2.5 Mabsadd L
.62891 .37092 1.875 0 Mabsadd L
.62891 .37092 0 -2.5 Mabsadd L
.62891 .37092 -1.875 0 Mabsadd L closepath F
.63023 .37182 -1.875 0 Mabsadd m
.63023 .37182 0 2.5 Mabsadd L
.63023 .37182 1.875 0 Mabsadd L
.63023 .37182 0 -2.5 Mabsadd L
.63023 .37182 -1.875 0 Mabsadd L closepath F
.63286 .37271 -1.875 0 Mabsadd m
.63286 .37271 0 2.5 Mabsadd L
.63286 .37271 1.875 0 Mabsadd L
.63286 .37271 0 -2.5 Mabsadd L
.63286 .37271 -1.875 0 Mabsadd L closepath F
.63418 .3736 -1.875 0 Mabsadd m
.63418 .3736 0 2.5 Mabsadd L
.63418 .3736 1.875 0 Mabsadd L
.63418 .3736 0 -2.5 Mabsadd L
.63418 .3736 -1.875 0 Mabsadd L closepath F
.63549 .37449 -1.875 0 Mabsadd m
.63549 .37449 0 2.5 Mabsadd L
.63549 .37449 1.875 0 Mabsadd L
.63549 .37449 0 -2.5 Mabsadd L
.63549 .37449 -1.875 0 Mabsadd L closepath F
.63681 .37538 -1.875 0 Mabsadd m
.63681 .37538 0 2.5 Mabsadd L
.63681 .37538 1.875 0 Mabsadd L
.63681 .37538 0 -2.5 Mabsadd L
.63681 .37538 -1.875 0 Mabsadd L closepath F
.64075 .37626 -1.875 0 Mabsadd m
.64075 .37626 0 2.5 Mabsadd L
.64075 .37626 1.875 0 Mabsadd L
.64075 .37626 0 -2.5 Mabsadd L
.64075 .37626 -1.875 0 Mabsadd L closepath F
.6447 .37715 -1.875 0 Mabsadd m
.6447 .37715 0 2.5 Mabsadd L
.6447 .37715 1.875 0 Mabsadd L
.6447 .37715 0 -2.5 Mabsadd L
.6447 .37715 -1.875 0 Mabsadd L closepath F
.6447 .37803 -1.875 0 Mabsadd m
.6447 .37803 0 2.5 Mabsadd L
.6447 .37803 1.875 0 Mabsadd L
.6447 .37803 0 -2.5 Mabsadd L
.6447 .37803 -1.875 0 Mabsadd L closepath F
.64733 .37891 -1.875 0 Mabsadd m
.64733 .37891 0 2.5 Mabsadd L
.64733 .37891 1.875 0 Mabsadd L
.64733 .37891 0 -2.5 Mabsadd L
.64733 .37891 -1.875 0 Mabsadd L closepath F
.64865 .37979 -1.875 0 Mabsadd m
.64865 .37979 0 2.5 Mabsadd L
.64865 .37979 1.875 0 Mabsadd L
.64865 .37979 0 -2.5 Mabsadd L
.64865 .37979 -1.875 0 Mabsadd L closepath F
.65259 .38066 -1.875 0 Mabsadd m
.65259 .38066 0 2.5 Mabsadd L
.65259 .38066 1.875 0 Mabsadd L
.65259 .38066 0 -2.5 Mabsadd L
.65259 .38066 -1.875 0 Mabsadd L closepath F
.65391 .38154 -1.875 0 Mabsadd m
.65391 .38154 0 2.5 Mabsadd L
.65391 .38154 1.875 0 Mabsadd L
.65391 .38154 0 -2.5 Mabsadd L
.65391 .38154 -1.875 0 Mabsadd L closepath F
.65522 .38241 -1.875 0 Mabsadd m
.65522 .38241 0 2.5 Mabsadd L
.65522 .38241 1.875 0 Mabsadd L
.65522 .38241 0 -2.5 Mabsadd L
.65522 .38241 -1.875 0 Mabsadd L closepath F
.65917 .38328 -1.875 0 Mabsadd m
.65917 .38328 0 2.5 Mabsadd L
.65917 .38328 1.875 0 Mabsadd L
.65917 .38328 0 -2.5 Mabsadd L
.65917 .38328 -1.875 0 Mabsadd L closepath F
.65917 .38415 -1.875 0 Mabsadd m
.65917 .38415 0 2.5 Mabsadd L
.65917 .38415 1.875 0 Mabsadd L
.65917 .38415 0 -2.5 Mabsadd L
.65917 .38415 -1.875 0 Mabsadd L closepath F
.6618 .38502 -1.875 0 Mabsadd m
.6618 .38502 0 2.5 Mabsadd L
.6618 .38502 1.875 0 Mabsadd L
.6618 .38502 0 -2.5 Mabsadd L
.6618 .38502 -1.875 0 Mabsadd L closepath F
.66311 .38588 -1.875 0 Mabsadd m
.66311 .38588 0 2.5 Mabsadd L
.66311 .38588 1.875 0 Mabsadd L
.66311 .38588 0 -2.5 Mabsadd L
.66311 .38588 -1.875 0 Mabsadd L closepath F
.66443 .38674 -1.875 0 Mabsadd m
.66443 .38674 0 2.5 Mabsadd L
.66443 .38674 1.875 0 Mabsadd L
.66443 .38674 0 -2.5 Mabsadd L
.66443 .38674 -1.875 0 Mabsadd L closepath F
.66706 .38761 -1.875 0 Mabsadd m
.66706 .38761 0 2.5 Mabsadd L
.66706 .38761 1.875 0 Mabsadd L
.66706 .38761 0 -2.5 Mabsadd L
.66706 .38761 -1.875 0 Mabsadd L closepath F
.66706 .38847 -1.875 0 Mabsadd m
.66706 .38847 0 2.5 Mabsadd L
.66706 .38847 1.875 0 Mabsadd L
.66706 .38847 0 -2.5 Mabsadd L
.66706 .38847 -1.875 0 Mabsadd L closepath F
.66706 .38932 -1.875 0 Mabsadd m
.66706 .38932 0 2.5 Mabsadd L
.66706 .38932 1.875 0 Mabsadd L
.66706 .38932 0 -2.5 Mabsadd L
.66706 .38932 -1.875 0 Mabsadd L closepath F
.66838 .39018 -1.875 0 Mabsadd m
.66838 .39018 0 2.5 Mabsadd L
.66838 .39018 1.875 0 Mabsadd L
.66838 .39018 0 -2.5 Mabsadd L
.66838 .39018 -1.875 0 Mabsadd L closepath F
.66969 .39103 -1.875 0 Mabsadd m
.66969 .39103 0 2.5 Mabsadd L
.66969 .39103 1.875 0 Mabsadd L
.66969 .39103 0 -2.5 Mabsadd L
.66969 .39103 -1.875 0 Mabsadd L closepath F
.67101 .39188 -1.875 0 Mabsadd m
.67101 .39188 0 2.5 Mabsadd L
.67101 .39188 1.875 0 Mabsadd L
.67101 .39188 0 -2.5 Mabsadd L
.67101 .39188 -1.875 0 Mabsadd L closepath F
.67101 .39274 -1.875 0 Mabsadd m
.67101 .39274 0 2.5 Mabsadd L
.67101 .39274 1.875 0 Mabsadd L
.67101 .39274 0 -2.5 Mabsadd L
.67101 .39274 -1.875 0 Mabsadd L closepath F
.67232 .39358 -1.875 0 Mabsadd m
.67232 .39358 0 2.5 Mabsadd L
.67232 .39358 1.875 0 Mabsadd L
.67232 .39358 0 -2.5 Mabsadd L
.67232 .39358 -1.875 0 Mabsadd L closepath F
.67232 .39443 -1.875 0 Mabsadd m
.67232 .39443 0 2.5 Mabsadd L
.67232 .39443 1.875 0 Mabsadd L
.67232 .39443 0 -2.5 Mabsadd L
.67232 .39443 -1.875 0 Mabsadd L closepath F
.67232 .39528 -1.875 0 Mabsadd m
.67232 .39528 0 2.5 Mabsadd L
.67232 .39528 1.875 0 Mabsadd L
.67232 .39528 0 -2.5 Mabsadd L
.67232 .39528 -1.875 0 Mabsadd L closepath F
.67232 .39612 -1.875 0 Mabsadd m
.67232 .39612 0 2.5 Mabsadd L
.67232 .39612 1.875 0 Mabsadd L
.67232 .39612 0 -2.5 Mabsadd L
.67232 .39612 -1.875 0 Mabsadd L closepath F
.67232 .39696 -1.875 0 Mabsadd m
.67232 .39696 0 2.5 Mabsadd L
.67232 .39696 1.875 0 Mabsadd L
.67232 .39696 0 -2.5 Mabsadd L
.67232 .39696 -1.875 0 Mabsadd L closepath F
.67232 .3978 -1.875 0 Mabsadd m
.67232 .3978 0 2.5 Mabsadd L
.67232 .3978 1.875 0 Mabsadd L
.67232 .3978 0 -2.5 Mabsadd L
.67232 .3978 -1.875 0 Mabsadd L closepath F
.67364 .39864 -1.875 0 Mabsadd m
.67364 .39864 0 2.5 Mabsadd L
.67364 .39864 1.875 0 Mabsadd L
.67364 .39864 0 -2.5 Mabsadd L
.67364 .39864 -1.875 0 Mabsadd L closepath F
.67364 .39947 -1.875 0 Mabsadd m
.67364 .39947 0 2.5 Mabsadd L
.67364 .39947 1.875 0 Mabsadd L
.67364 .39947 0 -2.5 Mabsadd L
.67364 .39947 -1.875 0 Mabsadd L closepath F
.67495 .40031 -1.875 0 Mabsadd m
.67495 .40031 0 2.5 Mabsadd L
.67495 .40031 1.875 0 Mabsadd L
.67495 .40031 0 -2.5 Mabsadd L
.67495 .40031 -1.875 0 Mabsadd L closepath F
.67627 .40114 -1.875 0 Mabsadd m
.67627 .40114 0 2.5 Mabsadd L
.67627 .40114 1.875 0 Mabsadd L
.67627 .40114 0 -2.5 Mabsadd L
.67627 .40114 -1.875 0 Mabsadd L closepath F
.67758 .40197 -1.875 0 Mabsadd m
.67758 .40197 0 2.5 Mabsadd L
.67758 .40197 1.875 0 Mabsadd L
.67758 .40197 0 -2.5 Mabsadd L
.67758 .40197 -1.875 0 Mabsadd L closepath F
.6789 .4028 -1.875 0 Mabsadd m
.6789 .4028 0 2.5 Mabsadd L
.6789 .4028 1.875 0 Mabsadd L
.6789 .4028 0 -2.5 Mabsadd L
.6789 .4028 -1.875 0 Mabsadd L closepath F
.6789 .40363 -1.875 0 Mabsadd m
.6789 .40363 0 2.5 Mabsadd L
.6789 .40363 1.875 0 Mabsadd L
.6789 .40363 0 -2.5 Mabsadd L
.6789 .40363 -1.875 0 Mabsadd L closepath F
.68285 .40445 -1.875 0 Mabsadd m
.68285 .40445 0 2.5 Mabsadd L
.68285 .40445 1.875 0 Mabsadd L
.68285 .40445 0 -2.5 Mabsadd L
.68285 .40445 -1.875 0 Mabsadd L closepath F
.68285 .40528 -1.875 0 Mabsadd m
.68285 .40528 0 2.5 Mabsadd L
.68285 .40528 1.875 0 Mabsadd L
.68285 .40528 0 -2.5 Mabsadd L
.68285 .40528 -1.875 0 Mabsadd L closepath F
.68548 .4061 -1.875 0 Mabsadd m
.68548 .4061 0 2.5 Mabsadd L
.68548 .4061 1.875 0 Mabsadd L
.68548 .4061 0 -2.5 Mabsadd L
.68548 .4061 -1.875 0 Mabsadd L closepath F
.68548 .40692 -1.875 0 Mabsadd m
.68548 .40692 0 2.5 Mabsadd L
.68548 .40692 1.875 0 Mabsadd L
.68548 .40692 0 -2.5 Mabsadd L
.68548 .40692 -1.875 0 Mabsadd L closepath F
.68548 .40774 -1.875 0 Mabsadd m
.68548 .40774 0 2.5 Mabsadd L
.68548 .40774 1.875 0 Mabsadd L
.68548 .40774 0 -2.5 Mabsadd L
.68548 .40774 -1.875 0 Mabsadd L closepath F
.68679 .40855 -1.875 0 Mabsadd m
.68679 .40855 0 2.5 Mabsadd L
.68679 .40855 1.875 0 Mabsadd L
.68679 .40855 0 -2.5 Mabsadd L
.68679 .40855 -1.875 0 Mabsadd L closepath F
.68679 .40937 -1.875 0 Mabsadd m
.68679 .40937 0 2.5 Mabsadd L
.68679 .40937 1.875 0 Mabsadd L
.68679 .40937 0 -2.5 Mabsadd L
.68679 .40937 -1.875 0 Mabsadd L closepath F
.68679 .41018 -1.875 0 Mabsadd m
.68679 .41018 0 2.5 Mabsadd L
.68679 .41018 1.875 0 Mabsadd L
.68679 .41018 0 -2.5 Mabsadd L
.68679 .41018 -1.875 0 Mabsadd L closepath F
.68679 .41099 -1.875 0 Mabsadd m
.68679 .41099 0 2.5 Mabsadd L
.68679 .41099 1.875 0 Mabsadd L
.68679 .41099 0 -2.5 Mabsadd L
.68679 .41099 -1.875 0 Mabsadd L closepath F
.68942 .4118 -1.875 0 Mabsadd m
.68942 .4118 0 2.5 Mabsadd L
.68942 .4118 1.875 0 Mabsadd L
.68942 .4118 0 -2.5 Mabsadd L
.68942 .4118 -1.875 0 Mabsadd L closepath F
.69074 .41261 -1.875 0 Mabsadd m
.69074 .41261 0 2.5 Mabsadd L
.69074 .41261 1.875 0 Mabsadd L
.69074 .41261 0 -2.5 Mabsadd L
.69074 .41261 -1.875 0 Mabsadd L closepath F
.69337 .41342 -1.875 0 Mabsadd m
.69337 .41342 0 2.5 Mabsadd L
.69337 .41342 1.875 0 Mabsadd L
.69337 .41342 0 -2.5 Mabsadd L
.69337 .41342 -1.875 0 Mabsadd L closepath F
.69337 .41422 -1.875 0 Mabsadd m
.69337 .41422 0 2.5 Mabsadd L
.69337 .41422 1.875 0 Mabsadd L
.69337 .41422 0 -2.5 Mabsadd L
.69337 .41422 -1.875 0 Mabsadd L closepath F
.69337 .41503 -1.875 0 Mabsadd m
.69337 .41503 0 2.5 Mabsadd L
.69337 .41503 1.875 0 Mabsadd L
.69337 .41503 0 -2.5 Mabsadd L
.69337 .41503 -1.875 0 Mabsadd L closepath F
.69469 .41583 -1.875 0 Mabsadd m
.69469 .41583 0 2.5 Mabsadd L
.69469 .41583 1.875 0 Mabsadd L
.69469 .41583 0 -2.5 Mabsadd L
.69469 .41583 -1.875 0 Mabsadd L closepath F
.69732 .41663 -1.875 0 Mabsadd m
.69732 .41663 0 2.5 Mabsadd L
.69732 .41663 1.875 0 Mabsadd L
.69732 .41663 0 -2.5 Mabsadd L
.69732 .41663 -1.875 0 Mabsadd L closepath F
.69732 .41743 -1.875 0 Mabsadd m
.69732 .41743 0 2.5 Mabsadd L
.69732 .41743 1.875 0 Mabsadd L
.69732 .41743 0 -2.5 Mabsadd L
.69732 .41743 -1.875 0 Mabsadd L closepath F
.69863 .41822 -1.875 0 Mabsadd m
.69863 .41822 0 2.5 Mabsadd L
.69863 .41822 1.875 0 Mabsadd L
.69863 .41822 0 -2.5 Mabsadd L
.69863 .41822 -1.875 0 Mabsadd L closepath F
.69863 .41902 -1.875 0 Mabsadd m
.69863 .41902 0 2.5 Mabsadd L
.69863 .41902 1.875 0 Mabsadd L
.69863 .41902 0 -2.5 Mabsadd L
.69863 .41902 -1.875 0 Mabsadd L closepath F
.69995 .41981 -1.875 0 Mabsadd m
.69995 .41981 0 2.5 Mabsadd L
.69995 .41981 1.875 0 Mabsadd L
.69995 .41981 0 -2.5 Mabsadd L
.69995 .41981 -1.875 0 Mabsadd L closepath F
.70126 .4206 -1.875 0 Mabsadd m
.70126 .4206 0 2.5 Mabsadd L
.70126 .4206 1.875 0 Mabsadd L
.70126 .4206 0 -2.5 Mabsadd L
.70126 .4206 -1.875 0 Mabsadd L closepath F
.70126 .42139 -1.875 0 Mabsadd m
.70126 .42139 0 2.5 Mabsadd L
.70126 .42139 1.875 0 Mabsadd L
.70126 .42139 0 -2.5 Mabsadd L
.70126 .42139 -1.875 0 Mabsadd L closepath F
.70258 .42218 -1.875 0 Mabsadd m
.70258 .42218 0 2.5 Mabsadd L
.70258 .42218 1.875 0 Mabsadd L
.70258 .42218 0 -2.5 Mabsadd L
.70258 .42218 -1.875 0 Mabsadd L closepath F
.70389 .42297 -1.875 0 Mabsadd m
.70389 .42297 0 2.5 Mabsadd L
.70389 .42297 1.875 0 Mabsadd L
.70389 .42297 0 -2.5 Mabsadd L
.70389 .42297 -1.875 0 Mabsadd L closepath F
.70389 .42375 -1.875 0 Mabsadd m
.70389 .42375 0 2.5 Mabsadd L
.70389 .42375 1.875 0 Mabsadd L
.70389 .42375 0 -2.5 Mabsadd L
.70389 .42375 -1.875 0 Mabsadd L closepath F
.70652 .42454 -1.875 0 Mabsadd m
.70652 .42454 0 2.5 Mabsadd L
.70652 .42454 1.875 0 Mabsadd L
.70652 .42454 0 -2.5 Mabsadd L
.70652 .42454 -1.875 0 Mabsadd L closepath F
.70652 .42532 -1.875 0 Mabsadd m
.70652 .42532 0 2.5 Mabsadd L
.70652 .42532 1.875 0 Mabsadd L
.70652 .42532 0 -2.5 Mabsadd L
.70652 .42532 -1.875 0 Mabsadd L closepath F
.70652 .4261 -1.875 0 Mabsadd m
.70652 .4261 0 2.5 Mabsadd L
.70652 .4261 1.875 0 Mabsadd L
.70652 .4261 0 -2.5 Mabsadd L
.70652 .4261 -1.875 0 Mabsadd L closepath F
.70652 .42687 -1.875 0 Mabsadd m
.70652 .42687 0 2.5 Mabsadd L
.70652 .42687 1.875 0 Mabsadd L
.70652 .42687 0 -2.5 Mabsadd L
.70652 .42687 -1.875 0 Mabsadd L closepath F
.70652 .42765 -1.875 0 Mabsadd m
.70652 .42765 0 2.5 Mabsadd L
.70652 .42765 1.875 0 Mabsadd L
.70652 .42765 0 -2.5 Mabsadd L
.70652 .42765 -1.875 0 Mabsadd L closepath F
.70784 .42843 -1.875 0 Mabsadd m
.70784 .42843 0 2.5 Mabsadd L
.70784 .42843 1.875 0 Mabsadd L
.70784 .42843 0 -2.5 Mabsadd L
.70784 .42843 -1.875 0 Mabsadd L closepath F
.70784 .4292 -1.875 0 Mabsadd m
.70784 .4292 0 2.5 Mabsadd L
.70784 .4292 1.875 0 Mabsadd L
.70784 .4292 0 -2.5 Mabsadd L
.70784 .4292 -1.875 0 Mabsadd L closepath F
.70784 .42997 -1.875 0 Mabsadd m
.70784 .42997 0 2.5 Mabsadd L
.70784 .42997 1.875 0 Mabsadd L
.70784 .42997 0 -2.5 Mabsadd L
.70784 .42997 -1.875 0 Mabsadd L closepath F
.70784 .43074 -1.875 0 Mabsadd m
.70784 .43074 0 2.5 Mabsadd L
.70784 .43074 1.875 0 Mabsadd L
.70784 .43074 0 -2.5 Mabsadd L
.70784 .43074 -1.875 0 Mabsadd L closepath F
.71047 .43151 -1.875 0 Mabsadd m
.71047 .43151 0 2.5 Mabsadd L
.71047 .43151 1.875 0 Mabsadd L
.71047 .43151 0 -2.5 Mabsadd L
.71047 .43151 -1.875 0 Mabsadd L closepath F
.71179 .43228 -1.875 0 Mabsadd m
.71179 .43228 0 2.5 Mabsadd L
.71179 .43228 1.875 0 Mabsadd L
.71179 .43228 0 -2.5 Mabsadd L
.71179 .43228 -1.875 0 Mabsadd L closepath F
.7131 .43304 -1.875 0 Mabsadd m
.7131 .43304 0 2.5 Mabsadd L
.7131 .43304 1.875 0 Mabsadd L
.7131 .43304 0 -2.5 Mabsadd L
.7131 .43304 -1.875 0 Mabsadd L closepath F
.71442 .4338 -1.875 0 Mabsadd m
.71442 .4338 0 2.5 Mabsadd L
.71442 .4338 1.875 0 Mabsadd L
.71442 .4338 0 -2.5 Mabsadd L
.71442 .4338 -1.875 0 Mabsadd L closepath F
.71705 .43457 -1.875 0 Mabsadd m
.71705 .43457 0 2.5 Mabsadd L
.71705 .43457 1.875 0 Mabsadd L
.71705 .43457 0 -2.5 Mabsadd L
.71705 .43457 -1.875 0 Mabsadd L closepath F
.72099 .43533 -1.875 0 Mabsadd m
.72099 .43533 0 2.5 Mabsadd L
.72099 .43533 1.875 0 Mabsadd L
.72099 .43533 0 -2.5 Mabsadd L
.72099 .43533 -1.875 0 Mabsadd L closepath F
.72099 .43608 -1.875 0 Mabsadd m
.72099 .43608 0 2.5 Mabsadd L
.72099 .43608 1.875 0 Mabsadd L
.72099 .43608 0 -2.5 Mabsadd L
.72099 .43608 -1.875 0 Mabsadd L closepath F
.72099 .43684 -1.875 0 Mabsadd m
.72099 .43684 0 2.5 Mabsadd L
.72099 .43684 1.875 0 Mabsadd L
.72099 .43684 0 -2.5 Mabsadd L
.72099 .43684 -1.875 0 Mabsadd L closepath F
.72099 .4376 -1.875 0 Mabsadd m
.72099 .4376 0 2.5 Mabsadd L
.72099 .4376 1.875 0 Mabsadd L
.72099 .4376 0 -2.5 Mabsadd L
.72099 .4376 -1.875 0 Mabsadd L closepath F
.72099 .43835 -1.875 0 Mabsadd m
.72099 .43835 0 2.5 Mabsadd L
.72099 .43835 1.875 0 Mabsadd L
.72099 .43835 0 -2.5 Mabsadd L
.72099 .43835 -1.875 0 Mabsadd L closepath F
.72099 .4391 -1.875 0 Mabsadd m
.72099 .4391 0 2.5 Mabsadd L
.72099 .4391 1.875 0 Mabsadd L
.72099 .4391 0 -2.5 Mabsadd L
.72099 .4391 -1.875 0 Mabsadd L closepath F
.72099 .43985 -1.875 0 Mabsadd m
.72099 .43985 0 2.5 Mabsadd L
.72099 .43985 1.875 0 Mabsadd L
.72099 .43985 0 -2.5 Mabsadd L
.72099 .43985 -1.875 0 Mabsadd L closepath F
.72231 .4406 -1.875 0 Mabsadd m
.72231 .4406 0 2.5 Mabsadd L
.72231 .4406 1.875 0 Mabsadd L
.72231 .4406 0 -2.5 Mabsadd L
.72231 .4406 -1.875 0 Mabsadd L closepath F
.72231 .44135 -1.875 0 Mabsadd m
.72231 .44135 0 2.5 Mabsadd L
.72231 .44135 1.875 0 Mabsadd L
.72231 .44135 0 -2.5 Mabsadd L
.72231 .44135 -1.875 0 Mabsadd L closepath F
.72231 .44209 -1.875 0 Mabsadd m
.72231 .44209 0 2.5 Mabsadd L
.72231 .44209 1.875 0 Mabsadd L
.72231 .44209 0 -2.5 Mabsadd L
.72231 .44209 -1.875 0 Mabsadd L closepath F
.72363 .44284 -1.875 0 Mabsadd m
.72363 .44284 0 2.5 Mabsadd L
.72363 .44284 1.875 0 Mabsadd L
.72363 .44284 0 -2.5 Mabsadd L
.72363 .44284 -1.875 0 Mabsadd L closepath F
.72363 .44358 -1.875 0 Mabsadd m
.72363 .44358 0 2.5 Mabsadd L
.72363 .44358 1.875 0 Mabsadd L
.72363 .44358 0 -2.5 Mabsadd L
.72363 .44358 -1.875 0 Mabsadd L closepath F
.72494 .44432 -1.875 0 Mabsadd m
.72494 .44432 0 2.5 Mabsadd L
.72494 .44432 1.875 0 Mabsadd L
.72494 .44432 0 -2.5 Mabsadd L
.72494 .44432 -1.875 0 Mabsadd L closepath F
.72757 .44506 -1.875 0 Mabsadd m
.72757 .44506 0 2.5 Mabsadd L
.72757 .44506 1.875 0 Mabsadd L
.72757 .44506 0 -2.5 Mabsadd L
.72757 .44506 -1.875 0 Mabsadd L closepath F
.7302 .4458 -1.875 0 Mabsadd m
.7302 .4458 0 2.5 Mabsadd L
.7302 .4458 1.875 0 Mabsadd L
.7302 .4458 0 -2.5 Mabsadd L
.7302 .4458 -1.875 0 Mabsadd L closepath F
.73152 .44654 -1.875 0 Mabsadd m
.73152 .44654 0 2.5 Mabsadd L
.73152 .44654 1.875 0 Mabsadd L
.73152 .44654 0 -2.5 Mabsadd L
.73152 .44654 -1.875 0 Mabsadd L closepath F
.73152 .44727 -1.875 0 Mabsadd m
.73152 .44727 0 2.5 Mabsadd L
.73152 .44727 1.875 0 Mabsadd L
.73152 .44727 0 -2.5 Mabsadd L
.73152 .44727 -1.875 0 Mabsadd L closepath F
.73152 .448 -1.875 0 Mabsadd m
.73152 .448 0 2.5 Mabsadd L
.73152 .448 1.875 0 Mabsadd L
.73152 .448 0 -2.5 Mabsadd L
.73152 .448 -1.875 0 Mabsadd L closepath F
.73283 .44873 -1.875 0 Mabsadd m
.73283 .44873 0 2.5 Mabsadd L
.73283 .44873 1.875 0 Mabsadd L
.73283 .44873 0 -2.5 Mabsadd L
.73283 .44873 -1.875 0 Mabsadd L closepath F
.73415 .44946 -1.875 0 Mabsadd m
.73415 .44946 0 2.5 Mabsadd L
.73415 .44946 1.875 0 Mabsadd L
.73415 .44946 0 -2.5 Mabsadd L
.73415 .44946 -1.875 0 Mabsadd L closepath F
.7381 .45019 -1.875 0 Mabsadd m
.7381 .45019 0 2.5 Mabsadd L
.7381 .45019 1.875 0 Mabsadd L
.7381 .45019 0 -2.5 Mabsadd L
.7381 .45019 -1.875 0 Mabsadd L closepath F
.7381 .45092 -1.875 0 Mabsadd m
.7381 .45092 0 2.5 Mabsadd L
.7381 .45092 1.875 0 Mabsadd L
.7381 .45092 0 -2.5 Mabsadd L
.7381 .45092 -1.875 0 Mabsadd L closepath F
.73941 .45164 -1.875 0 Mabsadd m
.73941 .45164 0 2.5 Mabsadd L
.73941 .45164 1.875 0 Mabsadd L
.73941 .45164 0 -2.5 Mabsadd L
.73941 .45164 -1.875 0 Mabsadd L closepath F
.74073 .45237 -1.875 0 Mabsadd m
.74073 .45237 0 2.5 Mabsadd L
.74073 .45237 1.875 0 Mabsadd L
.74073 .45237 0 -2.5 Mabsadd L
.74073 .45237 -1.875 0 Mabsadd L closepath F
.74073 .45309 -1.875 0 Mabsadd m
.74073 .45309 0 2.5 Mabsadd L
.74073 .45309 1.875 0 Mabsadd L
.74073 .45309 0 -2.5 Mabsadd L
.74073 .45309 -1.875 0 Mabsadd L closepath F
.74073 .45381 -1.875 0 Mabsadd m
.74073 .45381 0 2.5 Mabsadd L
.74073 .45381 1.875 0 Mabsadd L
.74073 .45381 0 -2.5 Mabsadd L
.74073 .45381 -1.875 0 Mabsadd L closepath F
.74336 .45453 -1.875 0 Mabsadd m
.74336 .45453 0 2.5 Mabsadd L
.74336 .45453 1.875 0 Mabsadd L
.74336 .45453 0 -2.5 Mabsadd L
.74336 .45453 -1.875 0 Mabsadd L closepath F
.74467 .45524 -1.875 0 Mabsadd m
.74467 .45524 0 2.5 Mabsadd L
.74467 .45524 1.875 0 Mabsadd L
.74467 .45524 0 -2.5 Mabsadd L
.74467 .45524 -1.875 0 Mabsadd L closepath F
.74467 .45596 -1.875 0 Mabsadd m
.74467 .45596 0 2.5 Mabsadd L
.74467 .45596 1.875 0 Mabsadd L
.74467 .45596 0 -2.5 Mabsadd L
.74467 .45596 -1.875 0 Mabsadd L closepath F
.74467 .45667 -1.875 0 Mabsadd m
.74467 .45667 0 2.5 Mabsadd L
.74467 .45667 1.875 0 Mabsadd L
.74467 .45667 0 -2.5 Mabsadd L
.74467 .45667 -1.875 0 Mabsadd L closepath F
.74599 .45739 -1.875 0 Mabsadd m
.74599 .45739 0 2.5 Mabsadd L
.74599 .45739 1.875 0 Mabsadd L
.74599 .45739 0 -2.5 Mabsadd L
.74599 .45739 -1.875 0 Mabsadd L closepath F
.7473 .4581 -1.875 0 Mabsadd m
.7473 .4581 0 2.5 Mabsadd L
.7473 .4581 1.875 0 Mabsadd L
.7473 .4581 0 -2.5 Mabsadd L
.7473 .4581 -1.875 0 Mabsadd L closepath F
.74862 .45881 -1.875 0 Mabsadd m
.74862 .45881 0 2.5 Mabsadd L
.74862 .45881 1.875 0 Mabsadd L
.74862 .45881 0 -2.5 Mabsadd L
.74862 .45881 -1.875 0 Mabsadd L closepath F
.74993 .45951 -1.875 0 Mabsadd m
.74993 .45951 0 2.5 Mabsadd L
.74993 .45951 1.875 0 Mabsadd L
.74993 .45951 0 -2.5 Mabsadd L
.74993 .45951 -1.875 0 Mabsadd L closepath F
.75125 .46022 -1.875 0 Mabsadd m
.75125 .46022 0 2.5 Mabsadd L
.75125 .46022 1.875 0 Mabsadd L
.75125 .46022 0 -2.5 Mabsadd L
.75125 .46022 -1.875 0 Mabsadd L closepath F
.75257 .46092 -1.875 0 Mabsadd m
.75257 .46092 0 2.5 Mabsadd L
.75257 .46092 1.875 0 Mabsadd L
.75257 .46092 0 -2.5 Mabsadd L
.75257 .46092 -1.875 0 Mabsadd L closepath F
.75651 .46163 -1.875 0 Mabsadd m
.75651 .46163 0 2.5 Mabsadd L
.75651 .46163 1.875 0 Mabsadd L
.75651 .46163 0 -2.5 Mabsadd L
.75651 .46163 -1.875 0 Mabsadd L closepath F
.75914 .46233 -1.875 0 Mabsadd m
.75914 .46233 0 2.5 Mabsadd L
.75914 .46233 1.875 0 Mabsadd L
.75914 .46233 0 -2.5 Mabsadd L
.75914 .46233 -1.875 0 Mabsadd L closepath F
.76046 .46303 -1.875 0 Mabsadd m
.76046 .46303 0 2.5 Mabsadd L
.76046 .46303 1.875 0 Mabsadd L
.76046 .46303 0 -2.5 Mabsadd L
.76046 .46303 -1.875 0 Mabsadd L closepath F
.76046 .46373 -1.875 0 Mabsadd m
.76046 .46373 0 2.5 Mabsadd L
.76046 .46373 1.875 0 Mabsadd L
.76046 .46373 0 -2.5 Mabsadd L
.76046 .46373 -1.875 0 Mabsadd L closepath F
.76177 .46442 -1.875 0 Mabsadd m
.76177 .46442 0 2.5 Mabsadd L
.76177 .46442 1.875 0 Mabsadd L
.76177 .46442 0 -2.5 Mabsadd L
.76177 .46442 -1.875 0 Mabsadd L closepath F
.76177 .46512 -1.875 0 Mabsadd m
.76177 .46512 0 2.5 Mabsadd L
.76177 .46512 1.875 0 Mabsadd L
.76177 .46512 0 -2.5 Mabsadd L
.76177 .46512 -1.875 0 Mabsadd L closepath F
.7644 .46581 -1.875 0 Mabsadd m
.7644 .46581 0 2.5 Mabsadd L
.7644 .46581 1.875 0 Mabsadd L
.7644 .46581 0 -2.5 Mabsadd L
.7644 .46581 -1.875 0 Mabsadd L closepath F
.76572 .4665 -1.875 0 Mabsadd m
.76572 .4665 0 2.5 Mabsadd L
.76572 .4665 1.875 0 Mabsadd L
.76572 .4665 0 -2.5 Mabsadd L
.76572 .4665 -1.875 0 Mabsadd L closepath F
.76572 .46719 -1.875 0 Mabsadd m
.76572 .46719 0 2.5 Mabsadd L
.76572 .46719 1.875 0 Mabsadd L
.76572 .46719 0 -2.5 Mabsadd L
.76572 .46719 -1.875 0 Mabsadd L closepath F
.76703 .46788 -1.875 0 Mabsadd m
.76703 .46788 0 2.5 Mabsadd L
.76703 .46788 1.875 0 Mabsadd L
.76703 .46788 0 -2.5 Mabsadd L
.76703 .46788 -1.875 0 Mabsadd L closepath F
.77098 .46857 -1.875 0 Mabsadd m
.77098 .46857 0 2.5 Mabsadd L
.77098 .46857 1.875 0 Mabsadd L
.77098 .46857 0 -2.5 Mabsadd L
.77098 .46857 -1.875 0 Mabsadd L closepath F
.7723 .46926 -1.875 0 Mabsadd m
.7723 .46926 0 2.5 Mabsadd L
.7723 .46926 1.875 0 Mabsadd L
.7723 .46926 0 -2.5 Mabsadd L
.7723 .46926 -1.875 0 Mabsadd L closepath F
.77493 .46994 -1.875 0 Mabsadd m
.77493 .46994 0 2.5 Mabsadd L
.77493 .46994 1.875 0 Mabsadd L
.77493 .46994 0 -2.5 Mabsadd L
.77493 .46994 -1.875 0 Mabsadd L closepath F
.77756 .47062 -1.875 0 Mabsadd m
.77756 .47062 0 2.5 Mabsadd L
.77756 .47062 1.875 0 Mabsadd L
.77756 .47062 0 -2.5 Mabsadd L
.77756 .47062 -1.875 0 Mabsadd L closepath F
.77756 .4713 -1.875 0 Mabsadd m
.77756 .4713 0 2.5 Mabsadd L
.77756 .4713 1.875 0 Mabsadd L
.77756 .4713 0 -2.5 Mabsadd L
.77756 .4713 -1.875 0 Mabsadd L closepath F
.77756 .47198 -1.875 0 Mabsadd m
.77756 .47198 0 2.5 Mabsadd L
.77756 .47198 1.875 0 Mabsadd L
.77756 .47198 0 -2.5 Mabsadd L
.77756 .47198 -1.875 0 Mabsadd L closepath F
.77756 .47266 -1.875 0 Mabsadd m
.77756 .47266 0 2.5 Mabsadd L
.77756 .47266 1.875 0 Mabsadd L
.77756 .47266 0 -2.5 Mabsadd L
.77756 .47266 -1.875 0 Mabsadd L closepath F
.77756 .47334 -1.875 0 Mabsadd m
.77756 .47334 0 2.5 Mabsadd L
.77756 .47334 1.875 0 Mabsadd L
.77756 .47334 0 -2.5 Mabsadd L
.77756 .47334 -1.875 0 Mabsadd L closepath F
.77887 .47401 -1.875 0 Mabsadd m
.77887 .47401 0 2.5 Mabsadd L
.77887 .47401 1.875 0 Mabsadd L
.77887 .47401 0 -2.5 Mabsadd L
.77887 .47401 -1.875 0 Mabsadd L closepath F
.77887 .47469 -1.875 0 Mabsadd m
.77887 .47469 0 2.5 Mabsadd L
.77887 .47469 1.875 0 Mabsadd L
.77887 .47469 0 -2.5 Mabsadd L
.77887 .47469 -1.875 0 Mabsadd L closepath F
.78019 .47536 -1.875 0 Mabsadd m
.78019 .47536 0 2.5 Mabsadd L
.78019 .47536 1.875 0 Mabsadd L
.78019 .47536 0 -2.5 Mabsadd L
.78019 .47536 -1.875 0 Mabsadd L closepath F
.7815 .47603 -1.875 0 Mabsadd m
.7815 .47603 0 2.5 Mabsadd L
.7815 .47603 1.875 0 Mabsadd L
.7815 .47603 0 -2.5 Mabsadd L
.7815 .47603 -1.875 0 Mabsadd L closepath F
.7815 .4767 -1.875 0 Mabsadd m
.7815 .4767 0 2.5 Mabsadd L
.7815 .4767 1.875 0 Mabsadd L
.7815 .4767 0 -2.5 Mabsadd L
.7815 .4767 -1.875 0 Mabsadd L closepath F
.7815 .47737 -1.875 0 Mabsadd m
.7815 .47737 0 2.5 Mabsadd L
.7815 .47737 1.875 0 Mabsadd L
.7815 .47737 0 -2.5 Mabsadd L
.7815 .47737 -1.875 0 Mabsadd L closepath F
.78414 .47803 -1.875 0 Mabsadd m
.78414 .47803 0 2.5 Mabsadd L
.78414 .47803 1.875 0 Mabsadd L
.78414 .47803 0 -2.5 Mabsadd L
.78414 .47803 -1.875 0 Mabsadd L closepath F
.78414 .47869 -1.875 0 Mabsadd m
.78414 .47869 0 2.5 Mabsadd L
.78414 .47869 1.875 0 Mabsadd L
.78414 .47869 0 -2.5 Mabsadd L
.78414 .47869 -1.875 0 Mabsadd L closepath F
.78545 .47936 -1.875 0 Mabsadd m
.78545 .47936 0 2.5 Mabsadd L
.78545 .47936 1.875 0 Mabsadd L
.78545 .47936 0 -2.5 Mabsadd L
.78545 .47936 -1.875 0 Mabsadd L closepath F
.78677 .48002 -1.875 0 Mabsadd m
.78677 .48002 0 2.5 Mabsadd L
.78677 .48002 1.875 0 Mabsadd L
.78677 .48002 0 -2.5 Mabsadd L
.78677 .48002 -1.875 0 Mabsadd L closepath F
.78677 .48068 -1.875 0 Mabsadd m
.78677 .48068 0 2.5 Mabsadd L
.78677 .48068 1.875 0 Mabsadd L
.78677 .48068 0 -2.5 Mabsadd L
.78677 .48068 -1.875 0 Mabsadd L closepath F
.78677 .48134 -1.875 0 Mabsadd m
.78677 .48134 0 2.5 Mabsadd L
.78677 .48134 1.875 0 Mabsadd L
.78677 .48134 0 -2.5 Mabsadd L
.78677 .48134 -1.875 0 Mabsadd L closepath F
.78808 .48199 -1.875 0 Mabsadd m
.78808 .48199 0 2.5 Mabsadd L
.78808 .48199 1.875 0 Mabsadd L
.78808 .48199 0 -2.5 Mabsadd L
.78808 .48199 -1.875 0 Mabsadd L closepath F
.7894 .48265 -1.875 0 Mabsadd m
.7894 .48265 0 2.5 Mabsadd L
.7894 .48265 1.875 0 Mabsadd L
.7894 .48265 0 -2.5 Mabsadd L
.7894 .48265 -1.875 0 Mabsadd L closepath F
.7894 .4833 -1.875 0 Mabsadd m
.7894 .4833 0 2.5 Mabsadd L
.7894 .4833 1.875 0 Mabsadd L
.7894 .4833 0 -2.5 Mabsadd L
.7894 .4833 -1.875 0 Mabsadd L closepath F
.7894 .48395 -1.875 0 Mabsadd m
.7894 .48395 0 2.5 Mabsadd L
.7894 .48395 1.875 0 Mabsadd L
.7894 .48395 0 -2.5 Mabsadd L
.7894 .48395 -1.875 0 Mabsadd L closepath F
.7894 .4846 -1.875 0 Mabsadd m
.7894 .4846 0 2.5 Mabsadd L
.7894 .4846 1.875 0 Mabsadd L
.7894 .4846 0 -2.5 Mabsadd L
.7894 .4846 -1.875 0 Mabsadd L closepath F
.79203 .48525 -1.875 0 Mabsadd m
.79203 .48525 0 2.5 Mabsadd L
.79203 .48525 1.875 0 Mabsadd L
.79203 .48525 0 -2.5 Mabsadd L
.79203 .48525 -1.875 0 Mabsadd L closepath F
.79334 .4859 -1.875 0 Mabsadd m
.79334 .4859 0 2.5 Mabsadd L
.79334 .4859 1.875 0 Mabsadd L
.79334 .4859 0 -2.5 Mabsadd L
.79334 .4859 -1.875 0 Mabsadd L closepath F
.79334 .48654 -1.875 0 Mabsadd m
.79334 .48654 0 2.5 Mabsadd L
.79334 .48654 1.875 0 Mabsadd L
.79334 .48654 0 -2.5 Mabsadd L
.79334 .48654 -1.875 0 Mabsadd L closepath F
.79597 .48719 -1.875 0 Mabsadd m
.79597 .48719 0 2.5 Mabsadd L
.79597 .48719 1.875 0 Mabsadd L
.79597 .48719 0 -2.5 Mabsadd L
.79597 .48719 -1.875 0 Mabsadd L closepath F
.79729 .48783 -1.875 0 Mabsadd m
.79729 .48783 0 2.5 Mabsadd L
.79729 .48783 1.875 0 Mabsadd L
.79729 .48783 0 -2.5 Mabsadd L
.79729 .48783 -1.875 0 Mabsadd L closepath F
.79861 .48847 -1.875 0 Mabsadd m
.79861 .48847 0 2.5 Mabsadd L
.79861 .48847 1.875 0 Mabsadd L
.79861 .48847 0 -2.5 Mabsadd L
.79861 .48847 -1.875 0 Mabsadd L closepath F
.79992 .48911 -1.875 0 Mabsadd m
.79992 .48911 0 2.5 Mabsadd L
.79992 .48911 1.875 0 Mabsadd L
.79992 .48911 0 -2.5 Mabsadd L
.79992 .48911 -1.875 0 Mabsadd L closepath F
.80124 .48975 -1.875 0 Mabsadd m
.80124 .48975 0 2.5 Mabsadd L
.80124 .48975 1.875 0 Mabsadd L
.80124 .48975 0 -2.5 Mabsadd L
.80124 .48975 -1.875 0 Mabsadd L closepath F
.80124 .49038 -1.875 0 Mabsadd m
.80124 .49038 0 2.5 Mabsadd L
.80124 .49038 1.875 0 Mabsadd L
.80124 .49038 0 -2.5 Mabsadd L
.80124 .49038 -1.875 0 Mabsadd L closepath F
.80124 .49102 -1.875 0 Mabsadd m
.80124 .49102 0 2.5 Mabsadd L
.80124 .49102 1.875 0 Mabsadd L
.80124 .49102 0 -2.5 Mabsadd L
.80124 .49102 -1.875 0 Mabsadd L closepath F
.80255 .49165 -1.875 0 Mabsadd m
.80255 .49165 0 2.5 Mabsadd L
.80255 .49165 1.875 0 Mabsadd L
.80255 .49165 0 -2.5 Mabsadd L
.80255 .49165 -1.875 0 Mabsadd L closepath F
.8065 .49228 -1.875 0 Mabsadd m
.8065 .49228 0 2.5 Mabsadd L
.8065 .49228 1.875 0 Mabsadd L
.8065 .49228 0 -2.5 Mabsadd L
.8065 .49228 -1.875 0 Mabsadd L closepath F
.8065 .49291 -1.875 0 Mabsadd m
.8065 .49291 0 2.5 Mabsadd L
.8065 .49291 1.875 0 Mabsadd L
.8065 .49291 0 -2.5 Mabsadd L
.8065 .49291 -1.875 0 Mabsadd L closepath F
.80781 .49354 -1.875 0 Mabsadd m
.80781 .49354 0 2.5 Mabsadd L
.80781 .49354 1.875 0 Mabsadd L
.80781 .49354 0 -2.5 Mabsadd L
.80781 .49354 -1.875 0 Mabsadd L closepath F
.80913 .49417 -1.875 0 Mabsadd m
.80913 .49417 0 2.5 Mabsadd L
.80913 .49417 1.875 0 Mabsadd L
.80913 .49417 0 -2.5 Mabsadd L
.80913 .49417 -1.875 0 Mabsadd L closepath F
.81044 .49479 -1.875 0 Mabsadd m
.81044 .49479 0 2.5 Mabsadd L
.81044 .49479 1.875 0 Mabsadd L
.81044 .49479 0 -2.5 Mabsadd L
.81044 .49479 -1.875 0 Mabsadd L closepath F
.81176 .49542 -1.875 0 Mabsadd m
.81176 .49542 0 2.5 Mabsadd L
.81176 .49542 1.875 0 Mabsadd L
.81176 .49542 0 -2.5 Mabsadd L
.81176 .49542 -1.875 0 Mabsadd L closepath F
.81176 .49604 -1.875 0 Mabsadd m
.81176 .49604 0 2.5 Mabsadd L
.81176 .49604 1.875 0 Mabsadd L
.81176 .49604 0 -2.5 Mabsadd L
.81176 .49604 -1.875 0 Mabsadd L closepath F
.81176 .49666 -1.875 0 Mabsadd m
.81176 .49666 0 2.5 Mabsadd L
.81176 .49666 1.875 0 Mabsadd L
.81176 .49666 0 -2.5 Mabsadd L
.81176 .49666 -1.875 0 Mabsadd L closepath F
.81308 .49728 -1.875 0 Mabsadd m
.81308 .49728 0 2.5 Mabsadd L
.81308 .49728 1.875 0 Mabsadd L
.81308 .49728 0 -2.5 Mabsadd L
.81308 .49728 -1.875 0 Mabsadd L closepath F
.81308 .4979 -1.875 0 Mabsadd m
.81308 .4979 0 2.5 Mabsadd L
.81308 .4979 1.875 0 Mabsadd L
.81308 .4979 0 -2.5 Mabsadd L
.81308 .4979 -1.875 0 Mabsadd L closepath F
.81439 .49851 -1.875 0 Mabsadd m
.81439 .49851 0 2.5 Mabsadd L
.81439 .49851 1.875 0 Mabsadd L
.81439 .49851 0 -2.5 Mabsadd L
.81439 .49851 -1.875 0 Mabsadd L closepath F
.81571 .49913 -1.875 0 Mabsadd m
.81571 .49913 0 2.5 Mabsadd L
.81571 .49913 1.875 0 Mabsadd L
.81571 .49913 0 -2.5 Mabsadd L
.81571 .49913 -1.875 0 Mabsadd L closepath F
.81571 .49974 -1.875 0 Mabsadd m
.81571 .49974 0 2.5 Mabsadd L
.81571 .49974 1.875 0 Mabsadd L
.81571 .49974 0 -2.5 Mabsadd L
.81571 .49974 -1.875 0 Mabsadd L closepath F
.81571 .50035 -1.875 0 Mabsadd m
.81571 .50035 0 2.5 Mabsadd L
.81571 .50035 1.875 0 Mabsadd L
.81571 .50035 0 -2.5 Mabsadd L
.81571 .50035 -1.875 0 Mabsadd L closepath F
.81571 .50096 -1.875 0 Mabsadd m
.81571 .50096 0 2.5 Mabsadd L
.81571 .50096 1.875 0 Mabsadd L
.81571 .50096 0 -2.5 Mabsadd L
.81571 .50096 -1.875 0 Mabsadd L closepath F
.81571 .50157 -1.875 0 Mabsadd m
.81571 .50157 0 2.5 Mabsadd L
.81571 .50157 1.875 0 Mabsadd L
.81571 .50157 0 -2.5 Mabsadd L
.81571 .50157 -1.875 0 Mabsadd L closepath F
.81702 .50217 -1.875 0 Mabsadd m
.81702 .50217 0 2.5 Mabsadd L
.81702 .50217 1.875 0 Mabsadd L
.81702 .50217 0 -2.5 Mabsadd L
.81702 .50217 -1.875 0 Mabsadd L closepath F
.81965 .50278 -1.875 0 Mabsadd m
.81965 .50278 0 2.5 Mabsadd L
.81965 .50278 1.875 0 Mabsadd L
.81965 .50278 0 -2.5 Mabsadd L
.81965 .50278 -1.875 0 Mabsadd L closepath F
.82097 .50338 -1.875 0 Mabsadd m
.82097 .50338 0 2.5 Mabsadd L
.82097 .50338 1.875 0 Mabsadd L
.82097 .50338 0 -2.5 Mabsadd L
.82097 .50338 -1.875 0 Mabsadd L closepath F
.82491 .50398 -1.875 0 Mabsadd m
.82491 .50398 0 2.5 Mabsadd L
.82491 .50398 1.875 0 Mabsadd L
.82491 .50398 0 -2.5 Mabsadd L
.82491 .50398 -1.875 0 Mabsadd L closepath F
.82623 .50458 -1.875 0 Mabsadd m
.82623 .50458 0 2.5 Mabsadd L
.82623 .50458 1.875 0 Mabsadd L
.82623 .50458 0 -2.5 Mabsadd L
.82623 .50458 -1.875 0 Mabsadd L closepath F
.82623 .50518 -1.875 0 Mabsadd m
.82623 .50518 0 2.5 Mabsadd L
.82623 .50518 1.875 0 Mabsadd L
.82623 .50518 0 -2.5 Mabsadd L
.82623 .50518 -1.875 0 Mabsadd L closepath F
.82623 .50578 -1.875 0 Mabsadd m
.82623 .50578 0 2.5 Mabsadd L
.82623 .50578 1.875 0 Mabsadd L
.82623 .50578 0 -2.5 Mabsadd L
.82623 .50578 -1.875 0 Mabsadd L closepath F
.82623 .50638 -1.875 0 Mabsadd m
.82623 .50638 0 2.5 Mabsadd L
.82623 .50638 1.875 0 Mabsadd L
.82623 .50638 0 -2.5 Mabsadd L
.82623 .50638 -1.875 0 Mabsadd L closepath F
.82623 .50697 -1.875 0 Mabsadd m
.82623 .50697 0 2.5 Mabsadd L
.82623 .50697 1.875 0 Mabsadd L
.82623 .50697 0 -2.5 Mabsadd L
.82623 .50697 -1.875 0 Mabsadd L closepath F
.82623 .50756 -1.875 0 Mabsadd m
.82623 .50756 0 2.5 Mabsadd L
.82623 .50756 1.875 0 Mabsadd L
.82623 .50756 0 -2.5 Mabsadd L
.82623 .50756 -1.875 0 Mabsadd L closepath F
.82623 .50815 -1.875 0 Mabsadd m
.82623 .50815 0 2.5 Mabsadd L
.82623 .50815 1.875 0 Mabsadd L
.82623 .50815 0 -2.5 Mabsadd L
.82623 .50815 -1.875 0 Mabsadd L closepath F
.82623 .50874 -1.875 0 Mabsadd m
.82623 .50874 0 2.5 Mabsadd L
.82623 .50874 1.875 0 Mabsadd L
.82623 .50874 0 -2.5 Mabsadd L
.82623 .50874 -1.875 0 Mabsadd L closepath F
.82623 .50933 -1.875 0 Mabsadd m
.82623 .50933 0 2.5 Mabsadd L
.82623 .50933 1.875 0 Mabsadd L
.82623 .50933 0 -2.5 Mabsadd L
.82623 .50933 -1.875 0 Mabsadd L closepath F
.82755 .50992 -1.875 0 Mabsadd m
.82755 .50992 0 2.5 Mabsadd L
.82755 .50992 1.875 0 Mabsadd L
.82755 .50992 0 -2.5 Mabsadd L
.82755 .50992 -1.875 0 Mabsadd L closepath F
.83018 .5105 -1.875 0 Mabsadd m
.83018 .5105 0 2.5 Mabsadd L
.83018 .5105 1.875 0 Mabsadd L
.83018 .5105 0 -2.5 Mabsadd L
.83018 .5105 -1.875 0 Mabsadd L closepath F
.83018 .51109 -1.875 0 Mabsadd m
.83018 .51109 0 2.5 Mabsadd L
.83018 .51109 1.875 0 Mabsadd L
.83018 .51109 0 -2.5 Mabsadd L
.83018 .51109 -1.875 0 Mabsadd L closepath F
.83018 .51167 -1.875 0 Mabsadd m
.83018 .51167 0 2.5 Mabsadd L
.83018 .51167 1.875 0 Mabsadd L
.83018 .51167 0 -2.5 Mabsadd L
.83018 .51167 -1.875 0 Mabsadd L closepath F
.83018 .51225 -1.875 0 Mabsadd m
.83018 .51225 0 2.5 Mabsadd L
.83018 .51225 1.875 0 Mabsadd L
.83018 .51225 0 -2.5 Mabsadd L
.83018 .51225 -1.875 0 Mabsadd L closepath F
.83149 .51282 -1.875 0 Mabsadd m
.83149 .51282 0 2.5 Mabsadd L
.83149 .51282 1.875 0 Mabsadd L
.83149 .51282 0 -2.5 Mabsadd L
.83149 .51282 -1.875 0 Mabsadd L closepath F
.83149 .5134 -1.875 0 Mabsadd m
.83149 .5134 0 2.5 Mabsadd L
.83149 .5134 1.875 0 Mabsadd L
.83149 .5134 0 -2.5 Mabsadd L
.83149 .5134 -1.875 0 Mabsadd L closepath F
.83149 .51398 -1.875 0 Mabsadd m
.83149 .51398 0 2.5 Mabsadd L
.83149 .51398 1.875 0 Mabsadd L
.83149 .51398 0 -2.5 Mabsadd L
.83149 .51398 -1.875 0 Mabsadd L closepath F
.83149 .51455 -1.875 0 Mabsadd m
.83149 .51455 0 2.5 Mabsadd L
.83149 .51455 1.875 0 Mabsadd L
.83149 .51455 0 -2.5 Mabsadd L
.83149 .51455 -1.875 0 Mabsadd L closepath F
.83281 .51512 -1.875 0 Mabsadd m
.83281 .51512 0 2.5 Mabsadd L
.83281 .51512 1.875 0 Mabsadd L
.83281 .51512 0 -2.5 Mabsadd L
.83281 .51512 -1.875 0 Mabsadd L closepath F
.83281 .51569 -1.875 0 Mabsadd m
.83281 .51569 0 2.5 Mabsadd L
.83281 .51569 1.875 0 Mabsadd L
.83281 .51569 0 -2.5 Mabsadd L
.83281 .51569 -1.875 0 Mabsadd L closepath F
.83281 .51626 -1.875 0 Mabsadd m
.83281 .51626 0 2.5 Mabsadd L
.83281 .51626 1.875 0 Mabsadd L
.83281 .51626 0 -2.5 Mabsadd L
.83281 .51626 -1.875 0 Mabsadd L closepath F
.83412 .51683 -1.875 0 Mabsadd m
.83412 .51683 0 2.5 Mabsadd L
.83412 .51683 1.875 0 Mabsadd L
.83412 .51683 0 -2.5 Mabsadd L
.83412 .51683 -1.875 0 Mabsadd L closepath F
.83412 .51739 -1.875 0 Mabsadd m
.83412 .51739 0 2.5 Mabsadd L
.83412 .51739 1.875 0 Mabsadd L
.83412 .51739 0 -2.5 Mabsadd L
.83412 .51739 -1.875 0 Mabsadd L closepath F
.83675 .51796 -1.875 0 Mabsadd m
.83675 .51796 0 2.5 Mabsadd L
.83675 .51796 1.875 0 Mabsadd L
.83675 .51796 0 -2.5 Mabsadd L
.83675 .51796 -1.875 0 Mabsadd L closepath F
.83675 .51852 -1.875 0 Mabsadd m
.83675 .51852 0 2.5 Mabsadd L
.83675 .51852 1.875 0 Mabsadd L
.83675 .51852 0 -2.5 Mabsadd L
.83675 .51852 -1.875 0 Mabsadd L closepath F
.83675 .51908 -1.875 0 Mabsadd m
.83675 .51908 0 2.5 Mabsadd L
.83675 .51908 1.875 0 Mabsadd L
.83675 .51908 0 -2.5 Mabsadd L
.83675 .51908 -1.875 0 Mabsadd L closepath F
.83807 .51964 -1.875 0 Mabsadd m
.83807 .51964 0 2.5 Mabsadd L
.83807 .51964 1.875 0 Mabsadd L
.83807 .51964 0 -2.5 Mabsadd L
.83807 .51964 -1.875 0 Mabsadd L closepath F
.83938 .5202 -1.875 0 Mabsadd m
.83938 .5202 0 2.5 Mabsadd L
.83938 .5202 1.875 0 Mabsadd L
.83938 .5202 0 -2.5 Mabsadd L
.83938 .5202 -1.875 0 Mabsadd L closepath F
.8407 .52076 -1.875 0 Mabsadd m
.8407 .52076 0 2.5 Mabsadd L
.8407 .52076 1.875 0 Mabsadd L
.8407 .52076 0 -2.5 Mabsadd L
.8407 .52076 -1.875 0 Mabsadd L closepath F
.8407 .52131 -1.875 0 Mabsadd m
.8407 .52131 0 2.5 Mabsadd L
.8407 .52131 1.875 0 Mabsadd L
.8407 .52131 0 -2.5 Mabsadd L
.8407 .52131 -1.875 0 Mabsadd L closepath F
.84596 .52186 -1.875 0 Mabsadd m
.84596 .52186 0 2.5 Mabsadd L
.84596 .52186 1.875 0 Mabsadd L
.84596 .52186 0 -2.5 Mabsadd L
.84596 .52186 -1.875 0 Mabsadd L closepath F
.84596 .52241 -1.875 0 Mabsadd m
.84596 .52241 0 2.5 Mabsadd L
.84596 .52241 1.875 0 Mabsadd L
.84596 .52241 0 -2.5 Mabsadd L
.84596 .52241 -1.875 0 Mabsadd L closepath F
.84596 .52296 -1.875 0 Mabsadd m
.84596 .52296 0 2.5 Mabsadd L
.84596 .52296 1.875 0 Mabsadd L
.84596 .52296 0 -2.5 Mabsadd L
.84596 .52296 -1.875 0 Mabsadd L closepath F
.84596 .52351 -1.875 0 Mabsadd m
.84596 .52351 0 2.5 Mabsadd L
.84596 .52351 1.875 0 Mabsadd L
.84596 .52351 0 -2.5 Mabsadd L
.84596 .52351 -1.875 0 Mabsadd L closepath F
.84728 .52406 -1.875 0 Mabsadd m
.84728 .52406 0 2.5 Mabsadd L
.84728 .52406 1.875 0 Mabsadd L
.84728 .52406 0 -2.5 Mabsadd L
.84728 .52406 -1.875 0 Mabsadd L closepath F
.84728 .5246 -1.875 0 Mabsadd m
.84728 .5246 0 2.5 Mabsadd L
.84728 .5246 1.875 0 Mabsadd L
.84728 .5246 0 -2.5 Mabsadd L
.84728 .5246 -1.875 0 Mabsadd L closepath F
.84991 .52515 -1.875 0 Mabsadd m
.84991 .52515 0 2.5 Mabsadd L
.84991 .52515 1.875 0 Mabsadd L
.84991 .52515 0 -2.5 Mabsadd L
.84991 .52515 -1.875 0 Mabsadd L closepath F
.85122 .52569 -1.875 0 Mabsadd m
.85122 .52569 0 2.5 Mabsadd L
.85122 .52569 1.875 0 Mabsadd L
.85122 .52569 0 -2.5 Mabsadd L
.85122 .52569 -1.875 0 Mabsadd L closepath F
.85122 .52623 -1.875 0 Mabsadd m
.85122 .52623 0 2.5 Mabsadd L
.85122 .52623 1.875 0 Mabsadd L
.85122 .52623 0 -2.5 Mabsadd L
.85122 .52623 -1.875 0 Mabsadd L closepath F
.85254 .52677 -1.875 0 Mabsadd m
.85254 .52677 0 2.5 Mabsadd L
.85254 .52677 1.875 0 Mabsadd L
.85254 .52677 0 -2.5 Mabsadd L
.85254 .52677 -1.875 0 Mabsadd L closepath F
.85254 .5273 -1.875 0 Mabsadd m
.85254 .5273 0 2.5 Mabsadd L
.85254 .5273 1.875 0 Mabsadd L
.85254 .5273 0 -2.5 Mabsadd L
.85254 .5273 -1.875 0 Mabsadd L closepath F
.85254 .52784 -1.875 0 Mabsadd m
.85254 .52784 0 2.5 Mabsadd L
.85254 .52784 1.875 0 Mabsadd L
.85254 .52784 0 -2.5 Mabsadd L
.85254 .52784 -1.875 0 Mabsadd L closepath F
.85254 .52837 -1.875 0 Mabsadd m
.85254 .52837 0 2.5 Mabsadd L
.85254 .52837 1.875 0 Mabsadd L
.85254 .52837 0 -2.5 Mabsadd L
.85254 .52837 -1.875 0 Mabsadd L closepath F
.85254 .52891 -1.875 0 Mabsadd m
.85254 .52891 0 2.5 Mabsadd L
.85254 .52891 1.875 0 Mabsadd L
.85254 .52891 0 -2.5 Mabsadd L
.85254 .52891 -1.875 0 Mabsadd L closepath F
.85254 .52944 -1.875 0 Mabsadd m
.85254 .52944 0 2.5 Mabsadd L
.85254 .52944 1.875 0 Mabsadd L
.85254 .52944 0 -2.5 Mabsadd L
.85254 .52944 -1.875 0 Mabsadd L closepath F
.85385 .52996 -1.875 0 Mabsadd m
.85385 .52996 0 2.5 Mabsadd L
.85385 .52996 1.875 0 Mabsadd L
.85385 .52996 0 -2.5 Mabsadd L
.85385 .52996 -1.875 0 Mabsadd L closepath F
.85385 .53049 -1.875 0 Mabsadd m
.85385 .53049 0 2.5 Mabsadd L
.85385 .53049 1.875 0 Mabsadd L
.85385 .53049 0 -2.5 Mabsadd L
.85385 .53049 -1.875 0 Mabsadd L closepath F
.85385 .53102 -1.875 0 Mabsadd m
.85385 .53102 0 2.5 Mabsadd L
.85385 .53102 1.875 0 Mabsadd L
.85385 .53102 0 -2.5 Mabsadd L
.85385 .53102 -1.875 0 Mabsadd L closepath F
.85385 .53154 -1.875 0 Mabsadd m
.85385 .53154 0 2.5 Mabsadd L
.85385 .53154 1.875 0 Mabsadd L
.85385 .53154 0 -2.5 Mabsadd L
.85385 .53154 -1.875 0 Mabsadd L closepath F
.8578 .53206 -1.875 0 Mabsadd m
.8578 .53206 0 2.5 Mabsadd L
.8578 .53206 1.875 0 Mabsadd L
.8578 .53206 0 -2.5 Mabsadd L
.8578 .53206 -1.875 0 Mabsadd L closepath F
.8578 .53258 -1.875 0 Mabsadd m
.8578 .53258 0 2.5 Mabsadd L
.8578 .53258 1.875 0 Mabsadd L
.8578 .53258 0 -2.5 Mabsadd L
.8578 .53258 -1.875 0 Mabsadd L closepath F
.85912 .5331 -1.875 0 Mabsadd m
.85912 .5331 0 2.5 Mabsadd L
.85912 .5331 1.875 0 Mabsadd L
.85912 .5331 0 -2.5 Mabsadd L
.85912 .5331 -1.875 0 Mabsadd L closepath F
.86043 .53362 -1.875 0 Mabsadd m
.86043 .53362 0 2.5 Mabsadd L
.86043 .53362 1.875 0 Mabsadd L
.86043 .53362 0 -2.5 Mabsadd L
.86043 .53362 -1.875 0 Mabsadd L closepath F
.86306 .53414 -1.875 0 Mabsadd m
.86306 .53414 0 2.5 Mabsadd L
.86306 .53414 1.875 0 Mabsadd L
.86306 .53414 0 -2.5 Mabsadd L
.86306 .53414 -1.875 0 Mabsadd L closepath F
.86569 .53465 -1.875 0 Mabsadd m
.86569 .53465 0 2.5 Mabsadd L
.86569 .53465 1.875 0 Mabsadd L
.86569 .53465 0 -2.5 Mabsadd L
.86569 .53465 -1.875 0 Mabsadd L closepath F
.86701 .53516 -1.875 0 Mabsadd m
.86701 .53516 0 2.5 Mabsadd L
.86701 .53516 1.875 0 Mabsadd L
.86701 .53516 0 -2.5 Mabsadd L
.86701 .53516 -1.875 0 Mabsadd L closepath F
.86701 .53567 -1.875 0 Mabsadd m
.86701 .53567 0 2.5 Mabsadd L
.86701 .53567 1.875 0 Mabsadd L
.86701 .53567 0 -2.5 Mabsadd L
.86701 .53567 -1.875 0 Mabsadd L closepath F
.86701 .53618 -1.875 0 Mabsadd m
.86701 .53618 0 2.5 Mabsadd L
.86701 .53618 1.875 0 Mabsadd L
.86701 .53618 0 -2.5 Mabsadd L
.86701 .53618 -1.875 0 Mabsadd L closepath F
.86701 .53669 -1.875 0 Mabsadd m
.86701 .53669 0 2.5 Mabsadd L
.86701 .53669 1.875 0 Mabsadd L
.86701 .53669 0 -2.5 Mabsadd L
.86701 .53669 -1.875 0 Mabsadd L closepath F
.86701 .5372 -1.875 0 Mabsadd m
.86701 .5372 0 2.5 Mabsadd L
.86701 .5372 1.875 0 Mabsadd L
.86701 .5372 0 -2.5 Mabsadd L
.86701 .5372 -1.875 0 Mabsadd L closepath F
.86701 .5377 -1.875 0 Mabsadd m
.86701 .5377 0 2.5 Mabsadd L
.86701 .5377 1.875 0 Mabsadd L
.86701 .5377 0 -2.5 Mabsadd L
.86701 .5377 -1.875 0 Mabsadd L closepath F
.86701 .5382 -1.875 0 Mabsadd m
.86701 .5382 0 2.5 Mabsadd L
.86701 .5382 1.875 0 Mabsadd L
.86701 .5382 0 -2.5 Mabsadd L
.86701 .5382 -1.875 0 Mabsadd L closepath F
.86701 .5387 -1.875 0 Mabsadd m
.86701 .5387 0 2.5 Mabsadd L
.86701 .5387 1.875 0 Mabsadd L
.86701 .5387 0 -2.5 Mabsadd L
.86701 .5387 -1.875 0 Mabsadd L closepath F
.86701 .5392 -1.875 0 Mabsadd m
.86701 .5392 0 2.5 Mabsadd L
.86701 .5392 1.875 0 Mabsadd L
.86701 .5392 0 -2.5 Mabsadd L
.86701 .5392 -1.875 0 Mabsadd L closepath F
.86832 .5397 -1.875 0 Mabsadd m
.86832 .5397 0 2.5 Mabsadd L
.86832 .5397 1.875 0 Mabsadd L
.86832 .5397 0 -2.5 Mabsadd L
.86832 .5397 -1.875 0 Mabsadd L closepath F
.87096 .5402 -1.875 0 Mabsadd m
.87096 .5402 0 2.5 Mabsadd L
.87096 .5402 1.875 0 Mabsadd L
.87096 .5402 0 -2.5 Mabsadd L
.87096 .5402 -1.875 0 Mabsadd L closepath F
.87096 .54069 -1.875 0 Mabsadd m
.87096 .54069 0 2.5 Mabsadd L
.87096 .54069 1.875 0 Mabsadd L
.87096 .54069 0 -2.5 Mabsadd L
.87096 .54069 -1.875 0 Mabsadd L closepath F
.87096 .54118 -1.875 0 Mabsadd m
.87096 .54118 0 2.5 Mabsadd L
.87096 .54118 1.875 0 Mabsadd L
.87096 .54118 0 -2.5 Mabsadd L
.87096 .54118 -1.875 0 Mabsadd L closepath F
.87227 .54168 -1.875 0 Mabsadd m
.87227 .54168 0 2.5 Mabsadd L
.87227 .54168 1.875 0 Mabsadd L
.87227 .54168 0 -2.5 Mabsadd L
.87227 .54168 -1.875 0 Mabsadd L closepath F
.87227 .54216 -1.875 0 Mabsadd m
.87227 .54216 0 2.5 Mabsadd L
.87227 .54216 1.875 0 Mabsadd L
.87227 .54216 0 -2.5 Mabsadd L
.87227 .54216 -1.875 0 Mabsadd L closepath F
.87227 .54265 -1.875 0 Mabsadd m
.87227 .54265 0 2.5 Mabsadd L
.87227 .54265 1.875 0 Mabsadd L
.87227 .54265 0 -2.5 Mabsadd L
.87227 .54265 -1.875 0 Mabsadd L closepath F
.87359 .54314 -1.875 0 Mabsadd m
.87359 .54314 0 2.5 Mabsadd L
.87359 .54314 1.875 0 Mabsadd L
.87359 .54314 0 -2.5 Mabsadd L
.87359 .54314 -1.875 0 Mabsadd L closepath F
.87359 .54362 -1.875 0 Mabsadd m
.87359 .54362 0 2.5 Mabsadd L
.87359 .54362 1.875 0 Mabsadd L
.87359 .54362 0 -2.5 Mabsadd L
.87359 .54362 -1.875 0 Mabsadd L closepath F
.8749 .54411 -1.875 0 Mabsadd m
.8749 .54411 0 2.5 Mabsadd L
.8749 .54411 1.875 0 Mabsadd L
.8749 .54411 0 -2.5 Mabsadd L
.8749 .54411 -1.875 0 Mabsadd L closepath F
.87753 .54459 -1.875 0 Mabsadd m
.87753 .54459 0 2.5 Mabsadd L
.87753 .54459 1.875 0 Mabsadd L
.87753 .54459 0 -2.5 Mabsadd L
.87753 .54459 -1.875 0 Mabsadd L closepath F
.87753 .54507 -1.875 0 Mabsadd m
.87753 .54507 0 2.5 Mabsadd L
.87753 .54507 1.875 0 Mabsadd L
.87753 .54507 0 -2.5 Mabsadd L
.87753 .54507 -1.875 0 Mabsadd L closepath F
.87753 .54554 -1.875 0 Mabsadd m
.87753 .54554 0 2.5 Mabsadd L
.87753 .54554 1.875 0 Mabsadd L
.87753 .54554 0 -2.5 Mabsadd L
.87753 .54554 -1.875 0 Mabsadd L closepath F
.87753 .54602 -1.875 0 Mabsadd m
.87753 .54602 0 2.5 Mabsadd L
.87753 .54602 1.875 0 Mabsadd L
.87753 .54602 0 -2.5 Mabsadd L
.87753 .54602 -1.875 0 Mabsadd L closepath F
.87753 .54649 -1.875 0 Mabsadd m
.87753 .54649 0 2.5 Mabsadd L
.87753 .54649 1.875 0 Mabsadd L
.87753 .54649 0 -2.5 Mabsadd L
.87753 .54649 -1.875 0 Mabsadd L closepath F
.87753 .54697 -1.875 0 Mabsadd m
.87753 .54697 0 2.5 Mabsadd L
.87753 .54697 1.875 0 Mabsadd L
.87753 .54697 0 -2.5 Mabsadd L
.87753 .54697 -1.875 0 Mabsadd L closepath F
.87753 .54744 -1.875 0 Mabsadd m
.87753 .54744 0 2.5 Mabsadd L
.87753 .54744 1.875 0 Mabsadd L
.87753 .54744 0 -2.5 Mabsadd L
.87753 .54744 -1.875 0 Mabsadd L closepath F
.87753 .54791 -1.875 0 Mabsadd m
.87753 .54791 0 2.5 Mabsadd L
.87753 .54791 1.875 0 Mabsadd L
.87753 .54791 0 -2.5 Mabsadd L
.87753 .54791 -1.875 0 Mabsadd L closepath F
.87753 .54837 -1.875 0 Mabsadd m
.87753 .54837 0 2.5 Mabsadd L
.87753 .54837 1.875 0 Mabsadd L
.87753 .54837 0 -2.5 Mabsadd L
.87753 .54837 -1.875 0 Mabsadd L closepath F
.87753 .54884 -1.875 0 Mabsadd m
.87753 .54884 0 2.5 Mabsadd L
.87753 .54884 1.875 0 Mabsadd L
.87753 .54884 0 -2.5 Mabsadd L
.87753 .54884 -1.875 0 Mabsadd L closepath F
.87885 .5493 -1.875 0 Mabsadd m
.87885 .5493 0 2.5 Mabsadd L
.87885 .5493 1.875 0 Mabsadd L
.87885 .5493 0 -2.5 Mabsadd L
.87885 .5493 -1.875 0 Mabsadd L closepath F
.87885 .54976 -1.875 0 Mabsadd m
.87885 .54976 0 2.5 Mabsadd L
.87885 .54976 1.875 0 Mabsadd L
.87885 .54976 0 -2.5 Mabsadd L
.87885 .54976 -1.875 0 Mabsadd L closepath F
.87885 .55023 -1.875 0 Mabsadd m
.87885 .55023 0 2.5 Mabsadd L
.87885 .55023 1.875 0 Mabsadd L
.87885 .55023 0 -2.5 Mabsadd L
.87885 .55023 -1.875 0 Mabsadd L closepath F
.87885 .55068 -1.875 0 Mabsadd m
.87885 .55068 0 2.5 Mabsadd L
.87885 .55068 1.875 0 Mabsadd L
.87885 .55068 0 -2.5 Mabsadd L
.87885 .55068 -1.875 0 Mabsadd L closepath F
.88016 .55114 -1.875 0 Mabsadd m
.88016 .55114 0 2.5 Mabsadd L
.88016 .55114 1.875 0 Mabsadd L
.88016 .55114 0 -2.5 Mabsadd L
.88016 .55114 -1.875 0 Mabsadd L closepath F
.88016 .5516 -1.875 0 Mabsadd m
.88016 .5516 0 2.5 Mabsadd L
.88016 .5516 1.875 0 Mabsadd L
.88016 .5516 0 -2.5 Mabsadd L
.88016 .5516 -1.875 0 Mabsadd L closepath F
.88148 .55205 -1.875 0 Mabsadd m
.88148 .55205 0 2.5 Mabsadd L
.88148 .55205 1.875 0 Mabsadd L
.88148 .55205 0 -2.5 Mabsadd L
.88148 .55205 -1.875 0 Mabsadd L closepath F
.88279 .5525 -1.875 0 Mabsadd m
.88279 .5525 0 2.5 Mabsadd L
.88279 .5525 1.875 0 Mabsadd L
.88279 .5525 0 -2.5 Mabsadd L
.88279 .5525 -1.875 0 Mabsadd L closepath F
.88279 .55295 -1.875 0 Mabsadd m
.88279 .55295 0 2.5 Mabsadd L
.88279 .55295 1.875 0 Mabsadd L
.88279 .55295 0 -2.5 Mabsadd L
.88279 .55295 -1.875 0 Mabsadd L closepath F
.88411 .5534 -1.875 0 Mabsadd m
.88411 .5534 0 2.5 Mabsadd L
.88411 .5534 1.875 0 Mabsadd L
.88411 .5534 0 -2.5 Mabsadd L
.88411 .5534 -1.875 0 Mabsadd L closepath F
.88542 .55385 -1.875 0 Mabsadd m
.88542 .55385 0 2.5 Mabsadd L
.88542 .55385 1.875 0 Mabsadd L
.88542 .55385 0 -2.5 Mabsadd L
.88542 .55385 -1.875 0 Mabsadd L closepath F
.88542 .55429 -1.875 0 Mabsadd m
.88542 .55429 0 2.5 Mabsadd L
.88542 .55429 1.875 0 Mabsadd L
.88542 .55429 0 -2.5 Mabsadd L
.88542 .55429 -1.875 0 Mabsadd L closepath F
.88806 .55474 -1.875 0 Mabsadd m
.88806 .55474 0 2.5 Mabsadd L
.88806 .55474 1.875 0 Mabsadd L
.88806 .55474 0 -2.5 Mabsadd L
.88806 .55474 -1.875 0 Mabsadd L closepath F
.88806 .55518 -1.875 0 Mabsadd m
.88806 .55518 0 2.5 Mabsadd L
.88806 .55518 1.875 0 Mabsadd L
.88806 .55518 0 -2.5 Mabsadd L
.88806 .55518 -1.875 0 Mabsadd L closepath F
.88937 .55562 -1.875 0 Mabsadd m
.88937 .55562 0 2.5 Mabsadd L
.88937 .55562 1.875 0 Mabsadd L
.88937 .55562 0 -2.5 Mabsadd L
.88937 .55562 -1.875 0 Mabsadd L closepath F
.88937 .55606 -1.875 0 Mabsadd m
.88937 .55606 0 2.5 Mabsadd L
.88937 .55606 1.875 0 Mabsadd L
.88937 .55606 0 -2.5 Mabsadd L
.88937 .55606 -1.875 0 Mabsadd L closepath F
.88937 .55649 -1.875 0 Mabsadd m
.88937 .55649 0 2.5 Mabsadd L
.88937 .55649 1.875 0 Mabsadd L
.88937 .55649 0 -2.5 Mabsadd L
.88937 .55649 -1.875 0 Mabsadd L closepath F
.88937 .55693 -1.875 0 Mabsadd m
.88937 .55693 0 2.5 Mabsadd L
.88937 .55693 1.875 0 Mabsadd L
.88937 .55693 0 -2.5 Mabsadd L
.88937 .55693 -1.875 0 Mabsadd L closepath F
.89069 .55736 -1.875 0 Mabsadd m
.89069 .55736 0 2.5 Mabsadd L
.89069 .55736 1.875 0 Mabsadd L
.89069 .55736 0 -2.5 Mabsadd L
.89069 .55736 -1.875 0 Mabsadd L closepath F
.89332 .55779 -1.875 0 Mabsadd m
.89332 .55779 0 2.5 Mabsadd L
.89332 .55779 1.875 0 Mabsadd L
.89332 .55779 0 -2.5 Mabsadd L
.89332 .55779 -1.875 0 Mabsadd L closepath F
.89332 .55822 -1.875 0 Mabsadd m
.89332 .55822 0 2.5 Mabsadd L
.89332 .55822 1.875 0 Mabsadd L
.89332 .55822 0 -2.5 Mabsadd L
.89332 .55822 -1.875 0 Mabsadd L closepath F
.89595 .55865 -1.875 0 Mabsadd m
.89595 .55865 0 2.5 Mabsadd L
.89595 .55865 1.875 0 Mabsadd L
.89595 .55865 0 -2.5 Mabsadd L
.89595 .55865 -1.875 0 Mabsadd L closepath F
.89595 .55907 -1.875 0 Mabsadd m
.89595 .55907 0 2.5 Mabsadd L
.89595 .55907 1.875 0 Mabsadd L
.89595 .55907 0 -2.5 Mabsadd L
.89595 .55907 -1.875 0 Mabsadd L closepath F
.89858 .5595 -1.875 0 Mabsadd m
.89858 .5595 0 2.5 Mabsadd L
.89858 .5595 1.875 0 Mabsadd L
.89858 .5595 0 -2.5 Mabsadd L
.89858 .5595 -1.875 0 Mabsadd L closepath F
.89858 .55992 -1.875 0 Mabsadd m
.89858 .55992 0 2.5 Mabsadd L
.89858 .55992 1.875 0 Mabsadd L
.89858 .55992 0 -2.5 Mabsadd L
.89858 .55992 -1.875 0 Mabsadd L closepath F
.89858 .56034 -1.875 0 Mabsadd m
.89858 .56034 0 2.5 Mabsadd L
.89858 .56034 1.875 0 Mabsadd L
.89858 .56034 0 -2.5 Mabsadd L
.89858 .56034 -1.875 0 Mabsadd L closepath F
.89989 .56076 -1.875 0 Mabsadd m
.89989 .56076 0 2.5 Mabsadd L
.89989 .56076 1.875 0 Mabsadd L
.89989 .56076 0 -2.5 Mabsadd L
.89989 .56076 -1.875 0 Mabsadd L closepath F
.89989 .56117 -1.875 0 Mabsadd m
.89989 .56117 0 2.5 Mabsadd L
.89989 .56117 1.875 0 Mabsadd L
.89989 .56117 0 -2.5 Mabsadd L
.89989 .56117 -1.875 0 Mabsadd L closepath F
.89989 .56159 -1.875 0 Mabsadd m
.89989 .56159 0 2.5 Mabsadd L
.89989 .56159 1.875 0 Mabsadd L
.89989 .56159 0 -2.5 Mabsadd L
.89989 .56159 -1.875 0 Mabsadd L closepath F
.89989 .562 -1.875 0 Mabsadd m
.89989 .562 0 2.5 Mabsadd L
.89989 .562 1.875 0 Mabsadd L
.89989 .562 0 -2.5 Mabsadd L
.89989 .562 -1.875 0 Mabsadd L closepath F
.90253 .56241 -1.875 0 Mabsadd m
.90253 .56241 0 2.5 Mabsadd L
.90253 .56241 1.875 0 Mabsadd L
.90253 .56241 0 -2.5 Mabsadd L
.90253 .56241 -1.875 0 Mabsadd L closepath F
.90647 .56282 -1.875 0 Mabsadd m
.90647 .56282 0 2.5 Mabsadd L
.90647 .56282 1.875 0 Mabsadd L
.90647 .56282 0 -2.5 Mabsadd L
.90647 .56282 -1.875 0 Mabsadd L closepath F
.90647 .56323 -1.875 0 Mabsadd m
.90647 .56323 0 2.5 Mabsadd L
.90647 .56323 1.875 0 Mabsadd L
.90647 .56323 0 -2.5 Mabsadd L
.90647 .56323 -1.875 0 Mabsadd L closepath F
.90647 .56364 -1.875 0 Mabsadd m
.90647 .56364 0 2.5 Mabsadd L
.90647 .56364 1.875 0 Mabsadd L
.90647 .56364 0 -2.5 Mabsadd L
.90647 .56364 -1.875 0 Mabsadd L closepath F
.90647 .56404 -1.875 0 Mabsadd m
.90647 .56404 0 2.5 Mabsadd L
.90647 .56404 1.875 0 Mabsadd L
.90647 .56404 0 -2.5 Mabsadd L
.90647 .56404 -1.875 0 Mabsadd L closepath F
.90647 .56444 -1.875 0 Mabsadd m
.90647 .56444 0 2.5 Mabsadd L
.90647 .56444 1.875 0 Mabsadd L
.90647 .56444 0 -2.5 Mabsadd L
.90647 .56444 -1.875 0 Mabsadd L closepath F
.90779 .56485 -1.875 0 Mabsadd m
.90779 .56485 0 2.5 Mabsadd L
.90779 .56485 1.875 0 Mabsadd L
.90779 .56485 0 -2.5 Mabsadd L
.90779 .56485 -1.875 0 Mabsadd L closepath F
.90779 .56524 -1.875 0 Mabsadd m
.90779 .56524 0 2.5 Mabsadd L
.90779 .56524 1.875 0 Mabsadd L
.90779 .56524 0 -2.5 Mabsadd L
.90779 .56524 -1.875 0 Mabsadd L closepath F
.90779 .56564 -1.875 0 Mabsadd m
.90779 .56564 0 2.5 Mabsadd L
.90779 .56564 1.875 0 Mabsadd L
.90779 .56564 0 -2.5 Mabsadd L
.90779 .56564 -1.875 0 Mabsadd L closepath F
.90779 .56604 -1.875 0 Mabsadd m
.90779 .56604 0 2.5 Mabsadd L
.90779 .56604 1.875 0 Mabsadd L
.90779 .56604 0 -2.5 Mabsadd L
.90779 .56604 -1.875 0 Mabsadd L closepath F
.9091 .56643 -1.875 0 Mabsadd m
.9091 .56643 0 2.5 Mabsadd L
.9091 .56643 1.875 0 Mabsadd L
.9091 .56643 0 -2.5 Mabsadd L
.9091 .56643 -1.875 0 Mabsadd L closepath F
.9091 .56682 -1.875 0 Mabsadd m
.9091 .56682 0 2.5 Mabsadd L
.9091 .56682 1.875 0 Mabsadd L
.9091 .56682 0 -2.5 Mabsadd L
.9091 .56682 -1.875 0 Mabsadd L closepath F
.9091 .56721 -1.875 0 Mabsadd m
.9091 .56721 0 2.5 Mabsadd L
.9091 .56721 1.875 0 Mabsadd L
.9091 .56721 0 -2.5 Mabsadd L
.9091 .56721 -1.875 0 Mabsadd L closepath F
.9091 .5676 -1.875 0 Mabsadd m
.9091 .5676 0 2.5 Mabsadd L
.9091 .5676 1.875 0 Mabsadd L
.9091 .5676 0 -2.5 Mabsadd L
.9091 .5676 -1.875 0 Mabsadd L closepath F
.91042 .56798 -1.875 0 Mabsadd m
.91042 .56798 0 2.5 Mabsadd L
.91042 .56798 1.875 0 Mabsadd L
.91042 .56798 0 -2.5 Mabsadd L
.91042 .56798 -1.875 0 Mabsadd L closepath F
.91042 .56837 -1.875 0 Mabsadd m
.91042 .56837 0 2.5 Mabsadd L
.91042 .56837 1.875 0 Mabsadd L
.91042 .56837 0 -2.5 Mabsadd L
.91042 .56837 -1.875 0 Mabsadd L closepath F
.91042 .56875 -1.875 0 Mabsadd m
.91042 .56875 0 2.5 Mabsadd L
.91042 .56875 1.875 0 Mabsadd L
.91042 .56875 0 -2.5 Mabsadd L
.91042 .56875 -1.875 0 Mabsadd L closepath F
.91042 .56913 -1.875 0 Mabsadd m
.91042 .56913 0 2.5 Mabsadd L
.91042 .56913 1.875 0 Mabsadd L
.91042 .56913 0 -2.5 Mabsadd L
.91042 .56913 -1.875 0 Mabsadd L closepath F
.91042 .56951 -1.875 0 Mabsadd m
.91042 .56951 0 2.5 Mabsadd L
.91042 .56951 1.875 0 Mabsadd L
.91042 .56951 0 -2.5 Mabsadd L
.91042 .56951 -1.875 0 Mabsadd L closepath F
.91042 .56989 -1.875 0 Mabsadd m
.91042 .56989 0 2.5 Mabsadd L
.91042 .56989 1.875 0 Mabsadd L
.91042 .56989 0 -2.5 Mabsadd L
.91042 .56989 -1.875 0 Mabsadd L closepath F
.91042 .57026 -1.875 0 Mabsadd m
.91042 .57026 0 2.5 Mabsadd L
.91042 .57026 1.875 0 Mabsadd L
.91042 .57026 0 -2.5 Mabsadd L
.91042 .57026 -1.875 0 Mabsadd L closepath F
.91173 .57064 -1.875 0 Mabsadd m
.91173 .57064 0 2.5 Mabsadd L
.91173 .57064 1.875 0 Mabsadd L
.91173 .57064 0 -2.5 Mabsadd L
.91173 .57064 -1.875 0 Mabsadd L closepath F
.91305 .57101 -1.875 0 Mabsadd m
.91305 .57101 0 2.5 Mabsadd L
.91305 .57101 1.875 0 Mabsadd L
.91305 .57101 0 -2.5 Mabsadd L
.91305 .57101 -1.875 0 Mabsadd L closepath F
.91305 .57138 -1.875 0 Mabsadd m
.91305 .57138 0 2.5 Mabsadd L
.91305 .57138 1.875 0 Mabsadd L
.91305 .57138 0 -2.5 Mabsadd L
.91305 .57138 -1.875 0 Mabsadd L closepath F
.91305 .57174 -1.875 0 Mabsadd m
.91305 .57174 0 2.5 Mabsadd L
.91305 .57174 1.875 0 Mabsadd L
.91305 .57174 0 -2.5 Mabsadd L
.91305 .57174 -1.875 0 Mabsadd L closepath F
.91436 .57211 -1.875 0 Mabsadd m
.91436 .57211 0 2.5 Mabsadd L
.91436 .57211 1.875 0 Mabsadd L
.91436 .57211 0 -2.5 Mabsadd L
.91436 .57211 -1.875 0 Mabsadd L closepath F
.91436 .57247 -1.875 0 Mabsadd m
.91436 .57247 0 2.5 Mabsadd L
.91436 .57247 1.875 0 Mabsadd L
.91436 .57247 0 -2.5 Mabsadd L
.91436 .57247 -1.875 0 Mabsadd L closepath F
.91436 .57283 -1.875 0 Mabsadd m
.91436 .57283 0 2.5 Mabsadd L
.91436 .57283 1.875 0 Mabsadd L
.91436 .57283 0 -2.5 Mabsadd L
.91436 .57283 -1.875 0 Mabsadd L closepath F
.91436 .57319 -1.875 0 Mabsadd m
.91436 .57319 0 2.5 Mabsadd L
.91436 .57319 1.875 0 Mabsadd L
.91436 .57319 0 -2.5 Mabsadd L
.91436 .57319 -1.875 0 Mabsadd L closepath F
.917 .57355 -1.875 0 Mabsadd m
.917 .57355 0 2.5 Mabsadd L
.917 .57355 1.875 0 Mabsadd L
.917 .57355 0 -2.5 Mabsadd L
.917 .57355 -1.875 0 Mabsadd L closepath F
.91963 .57391 -1.875 0 Mabsadd m
.91963 .57391 0 2.5 Mabsadd L
.91963 .57391 1.875 0 Mabsadd L
.91963 .57391 0 -2.5 Mabsadd L
.91963 .57391 -1.875 0 Mabsadd L closepath F
.91963 .57426 -1.875 0 Mabsadd m
.91963 .57426 0 2.5 Mabsadd L
.91963 .57426 1.875 0 Mabsadd L
.91963 .57426 0 -2.5 Mabsadd L
.91963 .57426 -1.875 0 Mabsadd L closepath F
.91963 .57461 -1.875 0 Mabsadd m
.91963 .57461 0 2.5 Mabsadd L
.91963 .57461 1.875 0 Mabsadd L
.91963 .57461 0 -2.5 Mabsadd L
.91963 .57461 -1.875 0 Mabsadd L closepath F
.92226 .57497 -1.875 0 Mabsadd m
.92226 .57497 0 2.5 Mabsadd L
.92226 .57497 1.875 0 Mabsadd L
.92226 .57497 0 -2.5 Mabsadd L
.92226 .57497 -1.875 0 Mabsadd L closepath F
.92226 .57531 -1.875 0 Mabsadd m
.92226 .57531 0 2.5 Mabsadd L
.92226 .57531 1.875 0 Mabsadd L
.92226 .57531 0 -2.5 Mabsadd L
.92226 .57531 -1.875 0 Mabsadd L closepath F
.92357 .57566 -1.875 0 Mabsadd m
.92357 .57566 0 2.5 Mabsadd L
.92357 .57566 1.875 0 Mabsadd L
.92357 .57566 0 -2.5 Mabsadd L
.92357 .57566 -1.875 0 Mabsadd L closepath F
.92357 .57601 -1.875 0 Mabsadd m
.92357 .57601 0 2.5 Mabsadd L
.92357 .57601 1.875 0 Mabsadd L
.92357 .57601 0 -2.5 Mabsadd L
.92357 .57601 -1.875 0 Mabsadd L closepath F
.92489 .57635 -1.875 0 Mabsadd m
.92489 .57635 0 2.5 Mabsadd L
.92489 .57635 1.875 0 Mabsadd L
.92489 .57635 0 -2.5 Mabsadd L
.92489 .57635 -1.875 0 Mabsadd L closepath F
.92489 .57669 -1.875 0 Mabsadd m
.92489 .57669 0 2.5 Mabsadd L
.92489 .57669 1.875 0 Mabsadd L
.92489 .57669 0 -2.5 Mabsadd L
.92489 .57669 -1.875 0 Mabsadd L closepath F
.92489 .57703 -1.875 0 Mabsadd m
.92489 .57703 0 2.5 Mabsadd L
.92489 .57703 1.875 0 Mabsadd L
.92489 .57703 0 -2.5 Mabsadd L
.92489 .57703 -1.875 0 Mabsadd L closepath F
.92489 .57736 -1.875 0 Mabsadd m
.92489 .57736 0 2.5 Mabsadd L
.92489 .57736 1.875 0 Mabsadd L
.92489 .57736 0 -2.5 Mabsadd L
.92489 .57736 -1.875 0 Mabsadd L closepath F
.9262 .5777 -1.875 0 Mabsadd m
.9262 .5777 0 2.5 Mabsadd L
.9262 .5777 1.875 0 Mabsadd L
.9262 .5777 0 -2.5 Mabsadd L
.9262 .5777 -1.875 0 Mabsadd L closepath F
.9262 .57803 -1.875 0 Mabsadd m
.9262 .57803 0 2.5 Mabsadd L
.9262 .57803 1.875 0 Mabsadd L
.9262 .57803 0 -2.5 Mabsadd L
.9262 .57803 -1.875 0 Mabsadd L closepath F
.9262 .57836 -1.875 0 Mabsadd m
.9262 .57836 0 2.5 Mabsadd L
.9262 .57836 1.875 0 Mabsadd L
.9262 .57836 0 -2.5 Mabsadd L
.9262 .57836 -1.875 0 Mabsadd L closepath F
.9262 .57869 -1.875 0 Mabsadd m
.9262 .57869 0 2.5 Mabsadd L
.9262 .57869 1.875 0 Mabsadd L
.9262 .57869 0 -2.5 Mabsadd L
.9262 .57869 -1.875 0 Mabsadd L closepath F
.9262 .57902 -1.875 0 Mabsadd m
.9262 .57902 0 2.5 Mabsadd L
.9262 .57902 1.875 0 Mabsadd L
.9262 .57902 0 -2.5 Mabsadd L
.9262 .57902 -1.875 0 Mabsadd L closepath F
.92752 .57935 -1.875 0 Mabsadd m
.92752 .57935 0 2.5 Mabsadd L
.92752 .57935 1.875 0 Mabsadd L
.92752 .57935 0 -2.5 Mabsadd L
.92752 .57935 -1.875 0 Mabsadd L closepath F
.92752 .57967 -1.875 0 Mabsadd m
.92752 .57967 0 2.5 Mabsadd L
.92752 .57967 1.875 0 Mabsadd L
.92752 .57967 0 -2.5 Mabsadd L
.92752 .57967 -1.875 0 Mabsadd L closepath F
.92752 .57999 -1.875 0 Mabsadd m
.92752 .57999 0 2.5 Mabsadd L
.92752 .57999 1.875 0 Mabsadd L
.92752 .57999 0 -2.5 Mabsadd L
.92752 .57999 -1.875 0 Mabsadd L closepath F
.92883 .58031 -1.875 0 Mabsadd m
.92883 .58031 0 2.5 Mabsadd L
.92883 .58031 1.875 0 Mabsadd L
.92883 .58031 0 -2.5 Mabsadd L
.92883 .58031 -1.875 0 Mabsadd L closepath F
.93147 .58063 -1.875 0 Mabsadd m
.93147 .58063 0 2.5 Mabsadd L
.93147 .58063 1.875 0 Mabsadd L
.93147 .58063 0 -2.5 Mabsadd L
.93147 .58063 -1.875 0 Mabsadd L closepath F
.93147 .58094 -1.875 0 Mabsadd m
.93147 .58094 0 2.5 Mabsadd L
.93147 .58094 1.875 0 Mabsadd L
.93147 .58094 0 -2.5 Mabsadd L
.93147 .58094 -1.875 0 Mabsadd L closepath F
.93147 .58126 -1.875 0 Mabsadd m
.93147 .58126 0 2.5 Mabsadd L
.93147 .58126 1.875 0 Mabsadd L
.93147 .58126 0 -2.5 Mabsadd L
.93147 .58126 -1.875 0 Mabsadd L closepath F
.93147 .58157 -1.875 0 Mabsadd m
.93147 .58157 0 2.5 Mabsadd L
.93147 .58157 1.875 0 Mabsadd L
.93147 .58157 0 -2.5 Mabsadd L
.93147 .58157 -1.875 0 Mabsadd L close